/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.engin.formula.base;

import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormFormulaBean;
import com.seeyon.cap4.form.bean.FormulaValidateResultBean;
import com.seeyon.cap4.form.modules.engin.formula.base.ElementParamVO;
import com.seeyon.cap4.form.modules.engin.formula.base.ExpressionComponentType;
import com.seeyon.cap4.form.modules.engin.formula.base.ExpressionElement;
import com.seeyon.cap4.form.modules.engin.formula.base.ExpressionUtil;
import com.seeyon.cap4.form.modules.engin.formula.base.ResultVO;
import com.seeyon.cap4.form.modules.engin.formula.base.enums.ExpressionFormulaType;
import com.seeyon.cap4.form.modules.engin.formula.base.enums.ExpressionResultType;
import com.seeyon.cap4.form.modules.engin.formula.base.enums.ExpressionType;
import com.seeyon.cap4.form.modules.engin.formula.validate.FormulaValidate;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.util.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Expression {
    private ExpressionElement root;
    private ExpressionElement last;
    private ExpressionType type;
    private ExpressionComponentType componentType;
    private boolean subFieldCanUseWithoutFunction = true;
    private String expression;
    private boolean success = true;
    private String errorMsg = "";
    private FormBean formBean;
    private FormBean oFormBean;
    private String queryOrReportId;

    public Expression(String expression, FormBean formBean, FormBean oFormBean) throws BusinessException {
        this.expression = expression;
        this.formBean = formBean;
        this.oFormBean = oFormBean;
        this.init(expression, formBean, oFormBean, false, null);
    }

    public Expression(ExpressionType type, ExpressionComponentType componentType) {
        this.type = type;
        this.componentType = componentType;
    }

    public Expression(ExpressionType type, ExpressionComponentType componentType, String expression, FormBean formBean, FormBean oFormBean, boolean subFieldCanUseWithoutFunction, String queryOrReportId) throws BusinessException {
        this.type = type;
        this.componentType = componentType;
        this.init(expression, formBean, oFormBean, subFieldCanUseWithoutFunction, queryOrReportId);
    }

    public ResultVO init(String expression, FormBean formBean, FormBean oFormBean, boolean subFieldCanUseWithoutFunction, String queryOrReportId) throws BusinessException {
        this.reset();
        this.subFieldCanUseWithoutFunction = subFieldCanUseWithoutFunction;
        this.expression = expression;
        this.setFormBean(formBean);
        this.setoFormBean(oFormBean);
        this.setQueryOrReportId(queryOrReportId);
        return this.init();
    }

    public ResultVO validate() throws BusinessException {
        ElementParamVO paramVO = new ElementParamVO(null, this.formBean, this.oFormBean, this.queryOrReportId);
        ExpressionResultType resultType = this.root.getResultType();
        ResultVO resultVO = new ResultVO(true);
        if (this.getType() == ExpressionType.condition) {
            if (resultType != ExpressionResultType.Boolean) {
                resultVO.setSuccess(false);
                resultVO.setMsg(ResourceUtil.getString((String)"form.baseinfo.formula.validate.0003", (Object)this.root.toString()));
            }
        } else if (this.getComponentType().getKey().equals(ExpressionFormulaType.TIMESTAMP.getKey())) {
            if (ExpressionResultType.Timestamp != resultType) {
                resultVO.setSuccess(false);
                resultVO.setMsg(ResourceUtil.getString((String)"form.baseinfo.formula.validate.0004", (Object)this.root.toString()));
            }
        } else if (this.getComponentType().getKey().equals(ExpressionFormulaType.DATETIME.getKey())) {
            if (ExpressionResultType.DateTime != resultType) {
                resultVO.setSuccess(false);
                resultVO.setMsg(ResourceUtil.getString((String)"form.baseinfo.formula.validate.0005", (Object)this.root.toString()));
            }
        } else if (this.getComponentType().getKey().equals(ExpressionFormulaType.DECIMAL.getKey()) && ExpressionResultType.Number != resultType) {
            resultVO.setSuccess(false);
            resultVO.setMsg(ResourceUtil.getString((String)"form.baseinfo.formula.validate.0006", (Object)this.root.toString()));
        }
        if (resultVO.isSuccess()) {
            resultVO = this.root.validate(paramVO, this.type, this.componentType);
        }
        return resultVO;
    }

    public List<FormulaValidateResultBean> validate4BizRedirect() throws BusinessException {
        ElementParamVO paramVO = new ElementParamVO(null, this.formBean, this.oFormBean, this.queryOrReportId);
        if (this.root != null) {
            return this.root.procValidateFormulaStr4BizImport(paramVO);
        }
        return new ArrayList<FormulaValidateResultBean>();
    }

    public String translateFormula4CheckRule() throws BusinessException {
        if (this.root != null) {
            ElementParamVO paramVO = new ElementParamVO(null, this.formBean, this.oFormBean, this.queryOrReportId);
            return this.root.translateFormula(paramVO);
        }
        return "";
    }

    public List<FormFormulaBean.FormulaBaseBean> getFormulaBeanList() throws BusinessException {
        return this.root.getFormulaBeanList();
    }

    public String getExecuteFormulaForGroove() throws BusinessException {
        return this.getExecuteFormulaForGroove(true);
    }

    public String getExecuteFormulaForGroove(boolean needProc) throws BusinessException {
        return this.root.getExecuteFormulaForGroove(needProc);
    }

    public String getExecuteFormulaForSQL(boolean hasIncludeChildDepartment, boolean needTableName) throws BusinessException {
        return this.root.getExecuteFormulaForSQL(hasIncludeChildDepartment, needTableName);
    }

    public void reset() {
        this.setRoot(null);
        this.setLast(null);
        this.setSuccess(true);
    }

    private ResultVO init() throws BusinessException {
        List expressions = FormulaValidate.parseToSimpleElement((String)this.expression);
        if (Strings.isNotEmpty((Collection)expressions)) {
            ElementParamVO paramVO = new ElementParamVO(null, this.formBean, this.oFormBean, this.queryOrReportId);
            int len = expressions.size();
            for (int i = 0; i < len; ++i) {
                ResultVO vo;
                String s = (String)expressions.get(i);
                paramVO.setExp(s);
                ExpressionElement element = ExpressionUtil.getElement(paramVO);
                if (element == null) {
                    this.errorMsg = ResourceUtil.getString((String)"form.baseinfo.formula.validate.0001") + ": " + s;
                    this.success = false;
                    return new ResultVO(false, this.errorMsg, null);
                }
                if (i + 1 < len && element.initValue((String)expressions.get(i + 1), this.formBean, this.oFormBean)) {
                    ++i;
                }
                if ((vo = this.addElement(element)).isSuccess()) continue;
                return vo;
            }
        }
        return new ResultVO(true);
    }

    private ResultVO addElement(ExpressionElement element) throws BusinessException {
        ResultVO vo = new ResultVO(true);
        if (element == null) {
            return vo;
        }
        if (this.root == null && this.last == null) {
            this.root = this.last = element;
            return vo;
        }
        vo = this.last.addElement4Last(element);
        if (!vo.isSuccess()) {
            return vo;
        }
        this.last = this.root = element;
        for (ExpressionElement e = element.getParentElement(); e != null; e = e.getParentElement()) {
            this.root = e;
        }
        return vo;
    }

    public String toString() {
        if (this.root == null) {
            return "";
        }
        return this.root.toString();
    }

    public ExpressionElement getRoot() {
        return this.root;
    }

    public void setRoot(ExpressionElement root) {
        this.root = root;
    }

    public ExpressionElement getLast() {
        return this.last;
    }

    public void setLast(ExpressionElement last) {
        this.last = last;
    }

    public ExpressionType getType() {
        return this.type;
    }

    public void setType(ExpressionType type) {
        this.type = type;
    }

    public ExpressionComponentType getComponentType() {
        return this.componentType;
    }

    public void setComponentType(ExpressionComponentType componentType) {
        this.componentType = componentType;
    }

    public boolean isSubFieldCanUseWithoutFunction() {
        return this.subFieldCanUseWithoutFunction;
    }

    public void setSubFieldCanUseWithoutFunction(boolean subFieldCanUseWithoutFunction) {
        this.subFieldCanUseWithoutFunction = subFieldCanUseWithoutFunction;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public FormBean getFormBean() {
        return this.formBean;
    }

    public void setFormBean(FormBean formBean) {
        this.formBean = formBean;
    }

    public FormBean getoFormBean() {
        return this.oFormBean;
    }

    public void setoFormBean(FormBean oFormBean) {
        this.oFormBean = oFormBean;
    }

    public String getQueryOrReportId() {
        return this.queryOrReportId;
    }

    public void setQueryOrReportId(String queryOrReportId) {
        this.queryOrReportId = queryOrReportId;
    }
}

