/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.engin.formula.base;

import com.seeyon.cap4.form.modules.engin.formula.base.ElementParamVO;
import com.seeyon.cap4.form.modules.engin.formula.base.ExpressionElement;
import com.seeyon.cap4.form.modules.engin.formula.base.ExpressionElementExtend;
import com.seeyon.cap4.form.modules.engin.formula.base.bracket.BaseBracketElement;
import com.seeyon.cap4.form.modules.engin.formula.base.bracket.ExpressionBracketElement;
import com.seeyon.cap4.form.modules.engin.formula.base.constant.BaseConstantElement;
import com.seeyon.cap4.form.modules.engin.formula.base.constant.ExpressionConstantElement;
import com.seeyon.cap4.form.modules.engin.formula.base.function.BaseFunctionElement;
import com.seeyon.cap4.form.modules.engin.formula.base.function.ExpressionFunctionElement;
import com.seeyon.cap4.form.modules.engin.formula.base.operator.BaseConditionOperatorElement;
import com.seeyon.cap4.form.modules.engin.formula.base.operator.BaseFormulaOperatorElement;
import com.seeyon.cap4.form.modules.engin.formula.base.operator.BaseLogicOperatorElement;
import com.seeyon.cap4.form.modules.engin.formula.base.operator.ExpressionOperatorElement;
import com.seeyon.cap4.form.modules.engin.formula.base.variation.BaseVariationElement;
import com.seeyon.cap4.form.modules.engin.formula.base.variation.ExpressionVariationElement;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import org.apache.commons.logging.Log;

public class ExpressionUtil {
    private static final Log LOGGER = CtpLogFactory.getLog(ExpressionUtil.class);
    private static ExpressionBracketElement bracketElement = new BaseBracketElement();
    private static ExpressionConstantElement constantElement = new BaseConstantElement();
    private static ExpressionFunctionElement functionElement = new BaseFunctionElement();
    private static ExpressionOperatorElement logicOperator = new BaseLogicOperatorElement();
    private static ExpressionOperatorElement formulaOperator = new BaseFormulaOperatorElement();
    private static ExpressionOperatorElement conditionOperator = new BaseConditionOperatorElement();
    private static ExpressionVariationElement variationElement = new BaseVariationElement();

    public static ExpressionElement getElement(ElementParamVO paramVO) {
        ExpressionElement element = null;
        String exp = paramVO.getExp();
        try {
            element = ExpressionUtil.getElement(functionElement, paramVO);
            if (element != null) {
                return element;
            }
            if (exp.length() == 1) {
                switch (exp.charAt(0)) {
                    case '*': 
                    case '+': 
                    case '-': 
                    case '/': {
                        element = ExpressionUtil.getElement(formulaOperator, paramVO);
                        break;
                    }
                    case '<': 
                    case '=': 
                    case '>': {
                        element = ExpressionUtil.getElement(conditionOperator, paramVO);
                        break;
                    }
                    case '(': 
                    case ')': {
                        element = ExpressionUtil.getElement(bracketElement, paramVO);
                        break;
                    }
                    case '!': 
                    case '^': {
                        element = ExpressionUtil.getElement(logicOperator, paramVO);
                        break;
                    }
                    default: {
                        element = ExpressionUtil.getElement(constantElement, paramVO);
                        break;
                    }
                }
            } else {
                element = exp.length() == 2 ? (">=".equals(exp) || "<=".equals(exp) || "<>".equals(exp) || "==".equals(exp) || "!=".equals(exp) || "&&".equals(exp) || "||".equals(exp) ? ExpressionUtil.getElement(conditionOperator, paramVO) : ("or".equals(exp) ? ExpressionUtil.getElement(logicOperator, paramVO) : ExpressionUtil.getElement(constantElement, paramVO))) : (ExpressionUtil.isStartsAndEndWithStr(exp, "[", "]") || ExpressionUtil.isStartsAndEndWithStr(exp, "{", "}") ? ExpressionUtil.getElement(variationElement, paramVO) : ("and".equals(exp) || "not".equals(exp) ? ExpressionUtil.getElement(logicOperator, paramVO) : ExpressionUtil.getElement(constantElement, paramVO)));
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        return element;
    }

    public static boolean isStartsAndEndWithStr(String str, String startStr, String endStr) {
        return str.startsWith(startStr) && str.endsWith(endStr);
    }

    private static ExpressionElement getElement(ExpressionElementExtend element, ElementParamVO paramVO) throws BusinessException {
        return element.getElement(paramVO, true);
    }
}

