/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.engin.formula.base.enums;

import com.seeyon.cap4.form.util.Enums;

public enum ExpressionResultType {
    Number(1, Enums.FieldType.DECIMAL.getKey()),
    Boolean(2, "boolean"),
    Timestamp(3, Enums.FieldType.TIMESTAMP.getKey()),
    DateTime(4, Enums.FieldType.DATETIME.getKey()),
    NullValue(5, "nullvalue"),
    StringValue(6, Enums.FieldType.VARCHAR.getKey());

    private int key;
    private String name;

    private ExpressionResultType(int key, String name) {
        this.key = key;
        this.name = name;
    }

    public boolean isNum() {
        return this == Number;
    }

    public boolean isBool() {
        return this == Boolean;
    }

    public boolean isStr() {
        return this == StringValue;
    }

    public boolean isNull() {
        return this == NullValue;
    }

    public boolean isDateOrDateTime() {
        return this == Timestamp || this == DateTime;
    }

    public static ExpressionResultType getResultType(String name) {
        if ("date".equalsIgnoreCase(name)) {
            return Timestamp;
        }
        for (ExpressionResultType type : ExpressionResultType.values()) {
            if (!type.getName().equalsIgnoreCase(name)) continue;
            return type;
        }
        return null;
    }

    public int getKey() {
        return this.key;
    }

    public void setKey(int key) {
        this.key = key;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

