/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.engin.formula.function;

import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormFormulaBean;
import com.seeyon.cap4.form.bean.FormQueryWhereClause;
import com.seeyon.cap4.form.modules.engin.formula.FormFormulaBaseFunction;
import com.seeyon.cap4.form.modules.engin.formula.FormulaEnums;
import com.seeyon.cap4.form.modules.engin.formula.FormulaFunctionUitl;
import com.seeyon.cap4.form.modules.engin.formula.validate.ExpressionUtil;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.report.utils.ReportDBUtils;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.Datetimes;
import com.seeyon.ctp.util.JDBCAgent;
import com.seeyon.ctp.util.Strings;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;

public class FormFormulaFunctionToDate
extends FormFormulaBaseFunction {
    private static final Log LOGGER = CtpLogFactory.getLog(FormFormulaFunctionToDate.class);

    public String getId() {
        return "to_date";
    }

    public String getI18nName() {
        return "clacType.Duplicateform.todate";
    }

    public boolean canUse() {
        return false;
    }

    public String getComponentType() {
        return "componentType_condition";
    }

    public String getFormulaType() {
        return null;
    }

    public String getConditionType() {
        return this.getTypeString(new String[]{"conditionType_formula_sub", "conditionType_BizCheck", "conditionType_sql", "conditionType_noFunction"});
    }

    public FormulaEnums.FunctionType getFunctionType() {
        return FormulaEnums.FunctionType.FORMULA_DATE;
    }

    public FormulaEnums.FunctionType getFunctionType(String params) {
        if (Strings.isBlank((String)(params = this.getReallyString(params)))) {
            return super.getFunctionType(params);
        }
        if (FormulaFunctionUitl.isValidDate((String)params)) {
            return FormulaEnums.FunctionType.FORMULA_DATE;
        }
        if (FormulaFunctionUitl.isValidDateTime((String)params)) {
            return FormulaEnums.FunctionType.FORMULA_DATETIME;
        }
        return null;
    }

    public boolean validate(String e, FormBean formBean, FormBean oFormBean, String formulaComponentType, String formulaType) throws BusinessException {
        String exp = this.getReallyString(e);
        FormFieldBean fieldBean = FormulaFunctionUitl.getFormFieldBeanFromFormula((String)exp, (FormBean)formBean, (FormBean)oFormBean, (boolean)false);
        if (fieldBean != null) {
            String msg = exp + " " + ResourceUtil.getString((String)"cap.formDesign.setting.paramnotdate");
            if (exp.contains("a")) {
                msg = exp + " " + ResourceUtil.getString((String)"cap.formDesign.setting.todate.notatablefield");
            }
            FormFieldBean rffb = fieldBean;
            if (!Enums.FieldType.TIMESTAMP.getKey().equals(rffb.getFieldType()) && !Enums.FieldType.DATETIME.getKey().equals(rffb.getFieldType())) {
                throw new BusinessException(msg);
            }
        } else if (!FormulaFunctionUitl.isValidDate((String)exp) && !FormulaFunctionUitl.isValidDateTime((String)exp)) {
            throw new BusinessException(exp + " \u4e0d\u662f\u6709\u6548\u7684\u65e5\u671f\uff0c\u65e5\u671f\u65f6\u95f4\uff01");
        }
        return true;
    }

    public String procFormulaStrForSQL(String sql) {
        String group1 = sql;
        if (sql != null && sql.contains(FormulaEnums.FunctionSymbol.to_date.getKey())) {
            group1 = sql.substring(sql.indexOf(FormulaEnums.FormulaExtendSymbol.leftSmallBracket.getKey()) + 1, sql.indexOf(FormulaEnums.FormulaExtendSymbol.rightSmallBracket.getKey()));
        }
        if (ReportDBUtils.isOracleRuntime() || ReportDBUtils.isDMSQLRuntime() || JDBCAgent.isKingBaseesRunTime()) {
            String fmt = "'YYYY-MM-DD'";
            if (group1.length() == "yyyy-MM-dd HH:mm".length() + 2) {
                fmt = "'YYYY-MM-DD HH24:MI'";
            }
            group1 = FormulaEnums.FunctionSymbol.to_date.getKey() + "(" + group1 + "," + fmt + ")";
        } else if (ReportDBUtils.isSQLServerRuntime()) {
            String fmt = "110";
            if (group1.length() >= "yyyy-MM-dd HH:mm".length()) {
                fmt = "0";
            }
            group1 = "CONVERT(VARCHAR(100)," + group1 + "," + fmt + ")";
        }
        return group1;
    }

    public String translateFormula(String formula, FormBean formBean) throws BusinessException {
        return formula;
    }

    public FormQueryWhereClause procFormulaStrForWhereClauseSQL(boolean isNeedTableName, FormBean formBean, FormBean relationFormBean, FormFormulaBean.FormulaFunctionBean formulaFunctionBean, Map<String, FormulaEnums.FormulaVar> formulaVarMap) {
        FormFormulaBean.FormulaDataFieldBean dateValue;
        FormQueryWhereClause whereClause = new FormQueryWhereClause();
        ArrayList<Object> queryParams = new ArrayList<Object>();
        List formulaList = formulaFunctionBean.getList();
        boolean isFirstField = formulaList.get(1) instanceof FormFormulaBean.FormulaDataFieldBean;
        String dateValueStr = "";
        boolean isValue = false;
        if (isFirstField) {
            dateValue = (FormFormulaBean.FormulaDataFieldBean)formulaList.get(1);
            dateValueStr = dateValue.getValue();
            FormulaEnums.FormulaVar var = formulaVarMap.get(dateValueStr);
            if (null != var) {
                dateValueStr = var.getValue();
                isValue = true;
            }
        } else {
            dateValue = (FormFormulaBean.FormulaValueBean)formulaList.get(1);
            dateValueStr = dateValue.getValue();
            isValue = true;
        }
        if (Strings.isBlank((String)dateValueStr)) {
            return null;
        }
        if (isValue) {
            boolean hasFunc = false;
            boolean isDate = false;
            if (dateValueStr.contains(FormulaEnums.FunctionSymbol.to_date.getKey())) {
                hasFunc = true;
                dateValueStr = dateValueStr.substring(dateValueStr.indexOf(FormulaEnums.FormulaExtendSymbol.leftSmallBracket.getKey()) + 1, dateValueStr.indexOf(FormulaEnums.FormulaExtendSymbol.rightSmallBracket.getKey()));
            }
            if ((dateValueStr = dateValueStr.replaceAll("'", "")).length() == 10) {
                isDate = true;
                dateValueStr = dateValueStr + " 00:00:00";
            } else if (dateValueStr.length() == 16) {
                dateValueStr = dateValueStr + ":00";
            }
            Date date = null;
            date = Datetimes.parseNoTimeZone((String)dateValueStr, (String)"yyyy-MM-dd HH:mm:ss");
            if (ReportDBUtils.isMySQLRuntime()) {
                if (isDate) {
                    queryParams.add(DateUtil.format((Date)date, (String)"yyyy-MM-dd"));
                } else {
                    queryParams.add(DateUtil.format((Date)date, (String)"yyyy-MM-dd HH:mm:ss"));
                }
            } else {
                queryParams.add(date);
            }
            whereClause.setAllSqlClause(" ? ");
            whereClause.setQueryParams(queryParams);
            return whereClause;
        }
        String masterTableName = super.getFieldOwnerTableName(isNeedTableName, formBean, dateValueStr);
        String sql = masterTableName + dateValueStr;
        whereClause.setAllSqlClause(" " + sql + " ");
        return whereClause;
    }

    public String replaceFieldWithValue(String formula, FormBean formBean, Map<String, Object> data) throws BusinessException {
        return ExpressionUtil.replaceFieldWithValue((String)formula, (FormBean)formBean, data);
    }
}

