/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.engin.formula.validate;

import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.modules.engin.formula.FormulaFunction;
import com.seeyon.cap4.form.modules.engin.formula.validate.ElementType;
import com.seeyon.cap4.form.modules.engin.formula.validate.ExpressionUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.workflow.script.WorkFlowFunctions;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;

public class ElementTypeUtil {
    private static final Log LOGGER = CtpLogFactory.getLog(ElementTypeUtil.class);
    private static boolean initFlag = false;
    private static Map<String, Boolean> methodNameMap = new HashMap<String, Boolean>();

    public static boolean isFunction(String name) {
        return ExpressionUtil.isFunction((String)name);
    }

    public static boolean isSumOrAver(String name) {
        return ElementTypeUtil.isFunction(name) && ("sum".equals(name) || "aver".equals(name));
    }

    public static boolean isDoubleOperator(String name) {
        if (Strings.isNotBlank((String)name)) {
            if (name.length() == 1) {
                switch (name.charAt(0)) {
                    case '&': 
                    case '*': 
                    case '+': 
                    case '-': 
                    case '/': 
                    case '<': 
                    case '=': 
                    case '>': 
                    case '^': 
                    case '|': {
                        return true;
                    }
                }
            } else {
                return ">=".equals(name) || "<=".equals(name) || "==".equals(name) || "!=".equals(name) || "<>".equals(name) || "&&".equals(name) || "||".equals(name);
            }
        }
        return false;
    }

    public static boolean isSizeyunsuanOperator(String name) {
        if (name != null && name.length() > 0 && name.length() == 1) {
            switch (name.charAt(0)) {
                case '*': 
                case '+': 
                case '-': 
                case '/': {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isEqualsssOperator(String name) {
        if (name != null && name.length() > 0) {
            if (name.length() == 1) {
                switch (name.charAt(0)) {
                    case '<': 
                    case '>': {
                        return true;
                    }
                }
            } else if (">=".equals(name) || "<=".equals(name) || "==".equals(name) || "!=".equals(name)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isLuojiOperator(String name) {
        return name != null && name.length() > 0 && ("&&".equals(name) || "||".equals(name) || "^".equals(name));
    }

    public static boolean isNotOperator(String name) {
        return "!".equals(name);
    }

    public static boolean isStartBracket(String name) {
        return "(".equals(name);
    }

    public static boolean isEndBracket(String name) {
        return ")".equals(name);
    }

    public static boolean isExistFunction(String name) {
        return "exist".equals(name);
    }

    public static ElementType getElementType(String name, Map<String, FormFieldBean> fieldMap) {
        ElementType type = null;
        if (name.length() == 1) {
            switch (name.charAt(0)) {
                case '+': {
                    type = ElementType.plus;
                    break;
                }
                case '-': {
                    type = ElementType.minus;
                    break;
                }
                case '*': {
                    type = ElementType.multiplication;
                    break;
                }
                case '/': {
                    type = ElementType.division;
                    break;
                }
                case '>': {
                    type = ElementType.greaterThan;
                    break;
                }
                case '<': {
                    type = ElementType.lessThan;
                    break;
                }
                case '=': {
                    type = ElementType.equalSingle;
                    break;
                }
                case '&': {
                    type = ElementType.andSingle;
                    break;
                }
                case '|': {
                    type = ElementType.orSingle;
                    break;
                }
                case '!': {
                    type = ElementType.not;
                    break;
                }
                case '^': {
                    type = ElementType.xor;
                    break;
                }
                case '(': {
                    type = ElementType.startBracket;
                    break;
                }
                case ')': {
                    type = ElementType.endBracket;
                    break;
                }
                default: {
                    if (name.matches("\\d+")) {
                        type = ElementType.numberFinal;
                        break;
                    } else {
                        break;
                    }
                }
            }
        } else if (name.length() == 2) {
            if (">=".equals(name)) {
                type = ElementType.greaterThanOrEqual;
            } else if ("<=".equals(name)) {
                type = ElementType.lessThanOrEqual;
            } else if ("==".equals(name)) {
                type = ElementType.equal;
            } else if ("!=".equals(name)) {
                type = ElementType.notEqual;
            } else if ("&&".equals(name)) {
                type = ElementType.and;
            } else if ("||".equals(name)) {
                type = ElementType.or;
            } else {
                try {
                    Double.parseDouble(name);
                    type = ElementType.numberFinal;
                }
                catch (NumberFormatException e) {
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        } else if (ElementTypeUtil.isFunction(name)) {
            type = ElementType.function;
        } else if (fieldMap != null && fieldMap.get(name) != null) {
            type = ElementType.formField;
        } else if (name.startsWith("{") && name.endsWith("}")) {
            String tempName = name.substring(1, name.length() - 1);
            if (fieldMap != null && fieldMap.get(tempName) != null) {
                type = ElementType.formField;
            }
        } else if (name.startsWith("'") && name.endsWith("'")) {
            type = ElementType.stringFinal;
        } else if (name.startsWith("\"") && name.endsWith("\"")) {
            type = ElementType.stringFinal;
        } else {
            try {
                Double.parseDouble(name);
                type = ElementType.numberFinal;
            }
            catch (NumberFormatException e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return type;
    }

    public static void init() {
        if (!initFlag) {
            initFlag = true;
            ElementTypeUtil.putCache(WorkFlowFunctions.class);
            ElementTypeUtil.putCache(FormulaFunction.class);
        }
    }

    private static <T> void putCache(Class<T> clazz) {
        Method[] allMethodArray = clazz.getMethods();
        if (allMethodArray != null && allMethodArray.length > 0) {
            for (Method method : allMethodArray) {
                String name = method.getName();
                int modefiers = method.getModifiers();
                if (!Modifier.isPublic(modefiers) || !Modifier.isStatic(modefiers)) continue;
                methodNameMap.put(name, Boolean.TRUE);
            }
        }
    }
}

