/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.engin.relation;

import com.seeyon.apps.collaboration.api.CollaborationApi;
import com.seeyon.cap4.form.bean.FormAuthViewBean;
import com.seeyon.cap4.form.bean.FormDataBean;
import com.seeyon.cap4.form.bean.FormDataMasterBean;
import com.seeyon.cap4.form.bean.FormDataSubBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormFieldComEnum;
import com.seeyon.cap4.form.bean.FormFormulaBean;
import com.seeyon.cap4.form.bean.FormQueryWhereClause;
import com.seeyon.cap4.form.bean.FormRelationshipBean;
import com.seeyon.cap4.form.bean.FormRelationshipMapBean;
import com.seeyon.cap4.form.bean.FormTableBean;
import com.seeyon.cap4.form.bean.SimpleObjectBean;
import com.seeyon.cap4.form.bean.fieldCtrl.FormFieldUtil;
import com.seeyon.cap4.form.modules.engin.base.formData.CAP4FormDataDAO;
import com.seeyon.cap4.form.modules.engin.base.formData.CAP4FormDataManager;
import com.seeyon.cap4.form.modules.engin.formula.FormulaEnums;
import com.seeyon.cap4.form.modules.engin.formula.FormulaUtil;
import com.seeyon.cap4.form.modules.engin.relation.CAP4FormRelationActionManager;
import com.seeyon.cap4.form.modules.engin.relation.CAP4FormRelationRecordDAO;
import com.seeyon.cap4.form.modules.engin.relation.FormRelationEnums;
import com.seeyon.cap4.form.modules.engin.relation.bo.CAP4RelationFillDataBO;
import com.seeyon.cap4.form.modules.engin.relation.bo.CAP4RelationQueryParamsBO;
import com.seeyon.cap4.form.modules.engin.relation.comparator.RelationshipCreateTimeAscComparator;
import com.seeyon.cap4.form.modules.engin.relation.comparator.RelationshipMapCreateTimeAscComparator;
import com.seeyon.cap4.form.po.CAPFormRelationRecord;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.service.CAP4FormManager;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.form.util.FormSearchUtil;
import com.seeyon.cap4.form.util.FormUtil;
import com.seeyon.cap4.form.vo.FieldRelationInfoVO;
import com.seeyon.cap4.magic.execute.ICAP4MagicExecuteManager;
import com.seeyon.cap4.magic.utils.MagicHandleFormUtils;
import com.seeyon.cap4.template.bean.AutoRelationTipBean;
import com.seeyon.cap4.template.manager.CAPDataListSqlHelpManager;
import com.seeyon.cap4.template.util.CAPAttachmentUtil;
import com.seeyon.cap4.template.util.CAPFormDataLogUtil;
import com.seeyon.cap4.template.util.CAPFormUtil;
import com.seeyon.ctp.cap.api.manager.CAPFormManager;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.constants.ApplicationCategoryEnum;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.ctpenumnew.CtpEnumItem;
import com.seeyon.ctp.form.bean.FormBean;
import com.seeyon.ctp.form.bean.FormFieldComBean;
import com.seeyon.ctp.form.po.FormRelation;
import com.seeyon.ctp.form.service.FormCacheManager;
import com.seeyon.ctp.form.util.Enums;
import com.seeyon.ctp.organization.bo.V3xOrgAccount;
import com.seeyon.ctp.organization.bo.V3xOrgDepartment;
import com.seeyon.ctp.organization.bo.V3xOrgMember;
import com.seeyon.ctp.organization.bo.V3xOrgPost;
import com.seeyon.ctp.organization.manager.OrgManager;
import com.seeyon.ctp.util.Datetimes;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.JDBCAgent;
import com.seeyon.ctp.util.ParamUtil;
import com.seeyon.ctp.util.StringUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.v3x.common.security.AccessControlBean;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.taglibs.standard.functions.Functions;

public class CAP4FormRelationActionManagerImpl
implements CAP4FormRelationActionManager {
    private static final Log LOGGER = CtpLogFactory.getLog(CAP4FormRelationActionManagerImpl.class);
    private CAP4FormRelationRecordDAO cap4FormRelationRecordDAO;
    private CAP4FormDataDAO cap4FormDataDAO;
    private CAP4FormDataManager cap4FormDataManager;
    private CAP4FormManager cap4FormManager;
    private CAP4FormCacheManager cap4FormCacheManager;
    private FormCacheManager formCacheManager;
    private CollaborationApi collaborationApi;
    private OrgManager orgManager;
    private CAPFormManager capFormManager;
    private CAPDataListSqlHelpManager capDataListSqlHelpManager;
    private Map<Long, Map<Long, Object>> cacheRelationDataMap = new ConcurrentHashMap<Long, Map<Long, Object>>();

    @Override
    public void removeCacheRelationData(Long masterId) {
        if (this.cacheRelationDataMap.get(masterId) != null) {
            Long userId = AppContext.currentUserId();
            this.cacheRelationDataMap.get(masterId).remove(userId);
            if (this.cacheRelationDataMap.get(masterId) == null || this.cacheRelationDataMap.get(masterId).size() == 0) {
                this.cacheRelationDataMap.remove(masterId);
            }
        }
    }

    @Override
    public void addCacheRelationData(Long masterId, Map<String, Object> relationDataMap) {
        Long userId = AppContext.currentUserId();
        if (this.cacheRelationDataMap.get(masterId) == null) {
            this.cacheRelationDataMap.put(masterId, new ConcurrentHashMap());
        }
        this.cacheRelationDataMap.get(masterId).put(userId, relationDataMap);
    }

    @Override
    public Map<String, Object> getCacheRelationData(Long masterId) {
        Long userId = AppContext.currentUserId();
        if (this.cacheRelationDataMap.get(masterId) == null) {
            return null;
        }
        return (Map)this.cacheRelationDataMap.get(masterId).get(userId);
    }

    @Override
    public List<FormRelationshipBean> getValidFormRelationshipBeansByMappingFieldName(Long formId, String fieldName, FormRelationEnums.ViewSelectType selectType) {
        com.seeyon.cap4.form.bean.FormBean formBean = this.cap4FormCacheManager.getForm(formId);
        FormFieldBean formFieldBean = formBean.getFieldBeanByName(fieldName);
        List vos = formFieldBean.getRelationInfoList();
        ArrayList<FormRelationshipBean> beans = null;
        if (CollectionUtils.isNotEmpty((Collection)vos)) {
            beans = new ArrayList<FormRelationshipBean>();
            for (FieldRelationInfoVO vo : vos) {
                FormRelationshipBean relationshipBean = this.cap4FormCacheManager.getFormRelationshipBean(vo.getRelationId());
                if (relationshipBean == null || relationshipBean.getState() != 1) continue;
                if (selectType != null) {
                    if (selectType.getKey() != relationshipBean.getRelationType()) continue;
                    beans.add(relationshipBean);
                    continue;
                }
                beans.add(relationshipBean);
            }
            Collections.sort(beans, new RelationshipCreateTimeAscComparator());
        }
        return beans;
    }

    @Override
    public List<FormRelationshipMapBean> getValidFormRelationshipMapBeansByType(com.seeyon.cap4.form.bean.FormBean formBean, int relationType) {
        List formRelationshipIdList = formBean.getFormRelationshipIdList();
        ArrayList<FormRelationshipMapBean> formRelationshipMapBeans = new ArrayList<FormRelationshipMapBean>();
        for (Long formRelationshipId : formRelationshipIdList) {
            FormRelationshipBean formRelationshipBean = this.cap4FormCacheManager.getFormRelationshipBean(formRelationshipId);
            if (formRelationshipBean.getState() == 0 || formRelationshipBean.getRelationMapList() == null || formRelationshipBean.getRelationType() != relationType) continue;
            formRelationshipMapBeans.addAll(formRelationshipBean.getRelationMapList());
        }
        Collections.sort(formRelationshipMapBeans, new RelationshipMapCreateTimeAscComparator());
        return formRelationshipMapBeans;
    }

    @Override
    public Set<String> getValidAutoIncreaseConditionFields(com.seeyon.cap4.form.bean.FormBean formBean) {
        List<FormRelationshipMapBean> autoIncreaseMapBeans = this.getValidFormRelationshipMapBeansByType(formBean, FormRelationEnums.ViewSelectType.auto_increase_row.getKey());
        HashSet<String> set = new HashSet<String>();
        for (FormRelationshipMapBean mapBean : autoIncreaseMapBeans) {
            List controlTriggerSets = mapBean.getControlTriggerSet();
            if (controlTriggerSets == null) continue;
            for (SimpleObjectBean sob : controlTriggerSets) {
                set.add(sob.getName());
            }
        }
        return set;
    }

    @Override
    public Set<FormRelationshipMapBean> getAutoIncreaseByConditionField(com.seeyon.cap4.form.bean.FormBean formBean, FormFieldBean formFieldBean) {
        TreeSet<FormRelationshipMapBean> mapBeans = new TreeSet<FormRelationshipMapBean>(new RelationshipMapCreateTimeAscComparator());
        List<FormRelationshipMapBean> autoIncreaseMapBeans = this.getValidFormRelationshipMapBeansByType(formBean, FormRelationEnums.ViewSelectType.auto_increase_row.getKey());
        for (FormRelationshipMapBean bean : autoIncreaseMapBeans) {
            List controlTriggerSets = bean.getControlTriggerSet();
            if (controlTriggerSets == null) continue;
            for (SimpleObjectBean sob : controlTriggerSets) {
                if (!formFieldBean.getName().equals(sob.getName())) continue;
                mapBeans.add(bean);
            }
        }
        return mapBeans;
    }

    @Override
    @Deprecated
    public Map<String, FormRelationshipMapBean> getField4ManualFormRelationshipMapBean(com.seeyon.cap4.form.bean.FormBean formBean) {
        HashMap<String, FormRelationshipMapBean> formRelationshipMapBeanMap = new HashMap<String, FormRelationshipMapBean>();
        List<FormRelationshipMapBean> formRelationshipMapBeans = this.getValidFormRelationshipMapBeansByType(formBean, FormRelationEnums.ViewSelectType.user.getKey());
        for (FormRelationshipMapBean formRelationshipMapBean : formRelationshipMapBeans) {
            formRelationshipMapBeanMap.put(formRelationshipMapBean.getSelectedField(), formRelationshipMapBean);
        }
        return formRelationshipMapBeanMap;
    }

    @Override
    public Map<String, List<FormRelationshipMapBean>> getFormField4ManualRelationMapBeans(com.seeyon.cap4.form.bean.FormBean formBean) {
        HashMap<String, List<FormRelationshipMapBean>> map = new HashMap<String, List<FormRelationshipMapBean>>();
        for (FormFieldBean fieldBean : formBean.getAllFieldBeans()) {
            List<FormRelationshipMapBean> list = this.getField4ManualFormRelationshipMapBeans(fieldBean, false);
            if (!CollectionUtils.isNotEmpty(list)) continue;
            map.put(fieldBean.getName(), list);
        }
        return map;
    }

    @Override
    public List<FormRelationshipMapBean> getField4ManualFormRelationshipMapBeans(FormFieldBean fieldBean) {
        return this.getField4ManualFormRelationshipMapBeans(fieldBean, false);
    }

    @Override
    public List<FormRelationshipMapBean> getField4ManualFormRelationshipMapBeans(FormFieldBean fieldBean, boolean needDisable) {
        if (CollectionUtils.isEmpty((Collection)fieldBean.getRelationInfoList())) {
            return null;
        }
        ArrayList<FormRelationshipMapBean> list = new ArrayList<FormRelationshipMapBean>();
        List relationInfoVOS = fieldBean.getRelationInfoList();
        for (FieldRelationInfoVO vo : relationInfoVOS) {
            FormRelationshipBean formRelationshipBean;
            if (!vo.getRelationSelectedField().booleanValue() || vo.getRelationId() == null || (formRelationshipBean = this.cap4FormCacheManager.getFormRelationshipBean(vo.getRelationId())).getRelationMapList() == null || !needDisable && formRelationshipBean.getState() == 0) continue;
            for (FormRelationshipMapBean mapBean : formRelationshipBean.getRelationMapList()) {
                if (!fieldBean.getName().equals(mapBean.getSelectedField())) continue;
                list.add(mapBean);
            }
        }
        Collections.sort(list, new RelationshipMapCreateTimeAscComparator());
        return list;
    }

    @Override
    public boolean isMagicManualRelation(FormRelationshipBean formRelationshipBean) {
        boolean result = false;
        if (formRelationshipBean == null) {
            return result;
        }
        if (FormRelationEnums.relationApplicationType.inner.getKey().equals(formRelationshipBean.getApplicationType())) {
            result = !this.isManualRelationSelf(formRelationshipBean);
        }
        return result;
    }

    @Override
    public boolean isManualRelationSelf(FormRelationshipBean formRelationshipBean) {
        boolean result = false;
        if (formRelationshipBean != null && FormRelationEnums.relationApplicationType.inner.getKey().equals(formRelationshipBean.getApplicationType()) && FormRelationEnums.ViewSelectType.user.getKey() == formRelationshipBean.getRelationType() && formRelationshipBean.getTargetFormId() == formRelationshipBean.getSourceFormId()) {
            result = true;
        }
        return result;
    }

    @Override
    public boolean isSysRelation(Long formId, String fieldName) {
        List<FormRelationshipBean> relationshipBeans = this.getValidFormRelationshipBeansByMappingFieldName(formId, fieldName, FormRelationEnums.ViewSelectType.system);
        return CollectionUtils.isNotEmpty(relationshipBeans);
    }

    @Override
    public List<FormRelationshipBean> getValidFormRelationshipBeansByConditionField(Long formId, String fieldName, FormRelationEnums.ViewSelectType selectType) {
        ArrayList<FormRelationshipBean> relationshipBeanList = new ArrayList<FormRelationshipBean>();
        com.seeyon.cap4.form.bean.FormBean formBean = this.cap4FormCacheManager.getForm(formId);
        List formRelationshipIdList = formBean.getFormRelationshipIdList();
        for (Long formRelationshipId : formRelationshipIdList) {
            FormRelationshipMapBean formRelationshipMapBean;
            Map<String, String> formulaFieldMap;
            FormRelationshipBean formRelationshipBean = this.cap4FormCacheManager.getFormRelationshipBean(formRelationshipId);
            if (formRelationshipBean.getState() != 1 || formRelationshipBean.getRelationType() != selectType.getKey() || !(formulaFieldMap = this.getRelationFormulaFieldMap((formRelationshipMapBean = (FormRelationshipMapBean)formRelationshipBean.getRelationMapList().get(0)).getConditionFormula())).containsKey(fieldName)) continue;
            relationshipBeanList.add(formRelationshipBean);
        }
        Collections.sort(relationshipBeanList, new RelationshipCreateTimeAscComparator());
        return relationshipBeanList;
    }

    @Override
    public Map<String, String> getRelationFormulaFieldMap(FormFormulaBean formFormulaBean) {
        return FormUtil.getRelationFormulaFieldMap((FormFormulaBean)formFormulaBean);
    }

    @Override
    public boolean forceDealSysRelation(FormFieldBean formFieldBean, FormAuthViewBean formAuthViewBean, FormRelationshipBean formRelationshipBean) {
        boolean force = false;
        if (formAuthViewBean == null) {
            LOGGER.error((Object)("forceDealSysRelation auth is null " + formFieldBean.getDisplay() + " " + formFieldBean.getName() + " " + formFieldBean.getOwnerTableName()));
            return force;
        }
        Object wso = AppContext.getThreadContext((String)"waitSentOpen");
        if (wso == null) {
            return force;
        }
        if (formRelationshipBean != null && formRelationshipBean.getRelationType() == FormRelationEnums.ViewSelectType.system.getKey()) {
            boolean waitSendOpen;
            FormRelationshipMapBean mapBean = (FormRelationshipMapBean)formRelationshipBean.getRelationMapList().get(0);
            boolean bl = waitSendOpen = wso != null ? (Boolean)wso : false;
            if (mapBean.getRefreshOperationUpdate() != null && mapBean.getRefreshOperationUpdate().contains(formAuthViewBean.getId().toString())) {
                force = true;
            } else if (mapBean.getRefreshOperationAdd() != null && mapBean.getRefreshOperationAdd().contains(formAuthViewBean.getId().toString())) {
                boolean bl2 = waitSendOpen ? mapBean.getWaitSentRefresh() == 1 : (force = true);
            }
            if (mapBean.getWaitSentRefresh() == 1 && waitSendOpen) {
                force = true;
            }
        }
        return force;
    }

    @Override
    public void dealSysRelationByShipBean(FormDataMasterBean formDataMasterBean, FormDataSubBean formDataSubBean, Set<String> fillBackFields, FormRelationshipBean formRelationshipBean) throws BusinessException {
        FormRelationshipMapBean formRelationshipMapBean = (FormRelationshipMapBean)formRelationshipBean.getRelationMapList().get(0);
        Long recordId = formDataSubBean == null ? 0L : formDataSubBean.getId();
        this.dealSysRelationData(formDataMasterBean, recordId, formRelationshipMapBean, fillBackFields);
    }

    @Override
    public void dealSysRelationByShipBean4FieldIn(com.seeyon.cap4.form.bean.FormBean formBean, FormDataMasterBean formDataMasterBean, FormAuthViewBean formAuthViewBean, FormDataSubBean formDataSubBean, Set<String> fillBackFields, FormRelationshipBean formRelationshipBean) throws BusinessException {
        if (formRelationshipBean.getState() == 0) {
            return;
        }
        FormRelationshipMapBean formRelationshipMapBean = (FormRelationshipMapBean)formRelationshipBean.getRelationMapList().get(0);
        Long recordId = formDataSubBean == null ? 0L : formDataSubBean.getId();
        this.dealSysRelationData(formDataMasterBean, recordId, formRelationshipMapBean, fillBackFields);
        Map formRelationFieldMap = formRelationshipMapBean.getFormRelationFieldMap();
        ArrayList<FormFieldBean> fromFormFieldBeans = new ArrayList<FormFieldBean>();
        HashMap<String, Object> fieldEnumValues = (HashMap<String, Object>)AppContext.getThreadContext((String)"fieldInnerChangeMap");
        if (fieldEnumValues == null) {
            fieldEnumValues = new HashMap<String, Object>();
        }
        for (String fromField : formRelationFieldMap.keySet()) {
            FormFieldBean fromFieldBean = formBean.getFieldBeanByName(fromField);
            if (fromFieldBean == null) continue;
            fromFormFieldBeans.add(fromFieldBean);
            if (!fromFieldBean.getInputTypeEnum().getKey().equals(FormFieldComEnum.SELECT.getKey())) continue;
            if (fromFieldBean.isMasterField()) {
                fieldEnumValues.put(fromField, formDataMasterBean.getFieldValue(fromField));
                continue;
            }
            if (formDataSubBean != null) {
                fieldEnumValues.put(fromField + "_" + formDataSubBean.getId(), formDataSubBean.getFieldValue(fromField));
                continue;
            }
            List formDataSubBeans = formDataMasterBean.getSubData(fromFieldBean.getOwnerTableName());
            for (FormDataSubBean fdsb : formDataSubBeans) {
                fieldEnumValues.put(fromField + "_" + fdsb.getId(), fdsb.getFieldValue(fromField));
            }
        }
        AppContext.putThreadContext((String)"fieldInnerChangeMap", fieldEnumValues);
        for (FormFieldBean fromFieldBean : fromFormFieldBeans) {
            if (fromFieldBean.isInCalculate()) {
                this.cap4FormDataManager.calcAllWithFieldIn(formBean, fromFieldBean, formDataMasterBean, formDataSubBean, fillBackFields, formAuthViewBean, true);
            }
            if (fromFieldBean.isInInnerRelation()) {
                if (fromFieldBean.getInputTypeEnum().getKey().equals(FormFieldComEnum.SELECT.getKey())) {
                    FormFieldBean toParentFieldBean;
                    Object enumValue = CAPFormUtil.getFieldEnumIdFromMasterBean(formDataMasterBean, CAPFormUtil.getFieldEnumIdKey(fromFieldBean, formDataSubBean));
                    if ((enumValue == null || Long.valueOf(0L).equals(enumValue)) && Strings.isNotBlank((String)fromFieldBean.getEnumParent()) && (toParentFieldBean = formBean.getFieldBeanByName(fromFieldBean.getEnumParent())) != null) {
                        Long toParentValue = this.getSelfRelationFieldValue((FormDataBean)(toParentFieldBean.isMasterField() ? formDataMasterBean : formDataSubBean), toParentFieldBean.getName());
                        if (!Long.valueOf(0L).equals(toParentValue)) {
                            CAPFormUtil.putFieldEnumIdToMasterBean(formDataMasterBean, CAPFormUtil.getFieldEnumIdKey(fromFieldBean, formDataSubBean), toParentValue);
                        }
                    }
                    this.dealEnumRelation(formBean, formDataMasterBean, formAuthViewBean, fromFieldBean, formDataSubBean, fillBackFields, true, fieldEnumValues);
                } else {
                    this.dealRelationByType(formBean, formDataMasterBean, formAuthViewBean, fromFieldBean, formDataSubBean, fillBackFields, fromFieldBean.getPossibleRelationAttrType(), true);
                }
            }
            if (!fromFieldBean.isInRelationCondition()) continue;
            this.dealSysRelation(formBean, formDataMasterBean, formAuthViewBean, fromFieldBean, fromFieldBean.isMasterField() ? null : formDataSubBean, fillBackFields);
        }
    }

    @Override
    public void dealSysRelation(com.seeyon.cap4.form.bean.FormBean formBean, FormDataMasterBean formDataMasterBean, FormAuthViewBean formAuthViewBean, FormFieldBean fieldBean, FormDataSubBean formDataSubBean, Set<String> fillBackFields) throws BusinessException {
        block3: {
            block2: {
                if (!fieldBean.isInRelationCondition() || "calcAll".equals(String.valueOf(AppContext.getThreadContext((String)"isFrom")))) break block2;
                List<FormRelationshipBean> formRelationshipBeans = this.getValidFormRelationshipBeansByConditionField(formBean.getId(), fieldBean.getName(), FormRelationEnums.ViewSelectType.system);
                for (FormRelationshipBean formRelationshipBean : formRelationshipBeans) {
                    this.dealSysRelationByShipBean4FieldIn(formBean, formDataMasterBean, formAuthViewBean, formDataSubBean, fillBackFields, formRelationshipBean);
                }
                break block3;
            }
            List<FormRelationshipBean> relationshipBeans = this.getValidFormRelationshipBeansByMappingFieldName(formBean.getId(), fieldBean.getName(), FormRelationEnums.ViewSelectType.system);
            if (!CollectionUtils.isNotEmpty(relationshipBeans)) break block3;
            for (FormRelationshipBean formRelationshipBean : relationshipBeans) {
                this.dealSysRelationByShipBean(formDataMasterBean, formDataSubBean, fillBackFields, formRelationshipBean);
            }
        }
    }

    @Override
    public List<Map<String, Object>> getSysRelationDatas(FormDataMasterBean formDataMasterBean, Long recordId, FormRelationshipMapBean formRelationshipMapBean) throws BusinessException {
        FormRelationshipBean formRelationshipBean = formRelationshipMapBean.getRelationshipBean();
        if (FormRelationEnums.relationApplicationType.inner.getKey().equals(formRelationshipBean.getApplicationType())) {
            ICAP4MagicExecuteManager cap4MagicExecuteManager = (ICAP4MagicExecuteManager)AppContext.getBean((String)"cap4MagicExecuteManager");
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("toFormId", formRelationshipBean.getTargetFormId());
            params.put("fromFormId", formRelationshipBean.getSourceFormId());
            params.put("fromDataId", formDataMasterBean.getId());
            params.put("formRecordId", recordId);
            params.put("formCacheDataMasterBean", formDataMasterBean);
            Map<String, Object> dataMap = cap4MagicExecuteManager.getRelationData(params, formRelationshipMapBean);
            return dataMap.get("data") == null ? null : (List)dataMap.get("data");
        }
        return this.getCAP4SysRelationDatas(formDataMasterBean, recordId, formRelationshipMapBean, null);
    }

    private List<Map<String, Object>> getCAP4SysRelationDatas(FormDataMasterBean formCacheDataMasterBean, Long formRecordId, FormRelationshipMapBean formRelationshipMapBean, CAP4RelationFillDataBO fillDataBO) throws BusinessException {
        FormRelationshipBean formRelationshipBean = formRelationshipMapBean.getRelationshipBean();
        com.seeyon.cap4.form.bean.FormBean fromFormBean = this.cap4FormCacheManager.getForm(formRelationshipBean.getSourceFormId());
        ArrayList<String> toShowFieldList = new ArrayList<String>();
        Map<String, String> conditionFieldMap = this.getRelationFormulaFieldMap(formRelationshipMapBean.getConditionFormula());
        ArrayList<Map<String, Object>> conditions = new ArrayList<Map<String, Object>>();
        boolean conditionAllNull = true;
        for (String fromField : conditionFieldMap.keySet()) {
            String toField = conditionFieldMap.get(fromField);
            toShowFieldList.add(toField);
            FormFieldBean formFieldBean = fromFormBean.getFieldBeanByName(fromField);
            if (formFieldBean.isMasterField()) {
                Object value = formCacheDataMasterBean.getFieldValue(fromField);
                HashMap<String, Object> selectedObject = new HashMap<String, Object>();
                selectedObject.put("fieldName", toField);
                selectedObject.put("fieldValue", value == null ? value : String.valueOf(FormSearchUtil.dealValueByFieldInputType(formFieldBean, value)));
                selectedObject.put("operation", "=");
                selectedObject.put("rowOperation", "and");
                conditions.add(selectedObject);
                if (conditionAllNull && value != null) {
                    conditionAllNull = false;
                }
            }
            if (!formFieldBean.isSubField() || formRecordId == null || formRecordId == 0L) continue;
            Map subData = formCacheDataMasterBean.getSubDataMapById(formFieldBean.getOwnerTableName(), formRecordId);
            Object value = subData.get(fromField);
            HashMap<String, String> selectedObject = new HashMap<String, String>();
            selectedObject.put("fieldName", toField);
            selectedObject.put("fieldValue", (String)(value == null ? value : String.valueOf(FormSearchUtil.dealValueByFieldInputType(formFieldBean, value))));
            selectedObject.put("operation", "=");
            selectedObject.put("rowOperation", "and");
            conditions.add(selectedObject);
            if (!conditionAllNull || value == null) continue;
            conditionAllNull = false;
        }
        if (fillDataBO != null) {
            fillDataBO.setConditionAllNull(conditionAllNull);
        }
        com.seeyon.cap4.form.bean.FormBean toFormBean = this.cap4FormCacheManager.getForm(formRelationshipBean.getTargetFormId());
        List<Map<String, Object>> queryConditions = FormSearchUtil.getUserConditions(toFormBean, conditions);
        CAP4RelationQueryParamsBO cap4RelationQueryParamsBO = new CAP4RelationQueryParamsBO();
        cap4RelationQueryParamsBO.setFromFormId(formRelationshipBean.getSourceFormId());
        cap4RelationQueryParamsBO.setFromDataId(formCacheDataMasterBean.getId());
        cap4RelationQueryParamsBO.setCustomShowFields(toShowFieldList);
        cap4RelationQueryParamsBO.setFormRelationshipMapBean(formRelationshipMapBean);
        FlipInfo flipInfo = new FlipInfo();
        flipInfo.setSize(-1);
        this.getFormRelationDataList(flipInfo, cap4RelationQueryParamsBO, queryConditions);
        return flipInfo.getData();
    }

    private void dealSysRelationData(FormDataMasterBean formCacheDataMasterBean, Long formRecordId, FormRelationshipMapBean formRelationshipMapBean, Set<String> fillBackFields) throws BusinessException {
        Long fromDataId = formCacheDataMasterBean.getId();
        FormRelationshipBean formRelationshipBean = formRelationshipMapBean.getRelationshipBean();
        if (!formRelationshipBean.hasMapping()) {
            LOGGER.info((Object)("\u4e0d\u6267\u884c\u81ea\u52a8\u5173\u8054\u56de\u586b\uff0c\u65e0\u6620\u5c04\u5173\u7cfb\u3002" + formCacheDataMasterBean.getId() + " " + formRelationshipBean.getId() + " " + formRelationshipBean.getName()));
            return;
        }
        if (formRelationshipBean.getRelationType() != FormRelationEnums.ViewSelectType.system.getKey()) {
            return;
        }
        if (FormRelationEnums.relationApplicationType.inner.getKey().equals(formRelationshipBean.getApplicationType())) {
            ICAP4MagicExecuteManager cap4MagicExecuteManager = (ICAP4MagicExecuteManager)AppContext.getBean((String)"cap4MagicExecuteManager");
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("toFormId", formRelationshipBean.getTargetFormId());
            params.put("fromFormId", formRelationshipBean.getSourceFormId());
            params.put("fromDataId", fromDataId);
            params.put("formRecordId", formRecordId);
            params.put("formCacheDataMasterBean", formCacheDataMasterBean);
            cap4MagicExecuteManager.dealSysRelationDataByMagic(params, formRelationshipMapBean, fillBackFields);
            return;
        }
        CAP4RelationFillDataBO bo = new CAP4RelationFillDataBO();
        List<Map<String, Object>> relationDatas = this.getCAP4SysRelationDatas(formCacheDataMasterBean, formRecordId, formRelationshipMapBean, bo);
        bo.setFormCacheDataMasterBean(formCacheDataMasterBean);
        bo.setRelationDatas(relationDatas);
        bo.setFormRecordId(formRecordId);
        bo.setFormRelationshipMapBean(formRelationshipMapBean);
        this.dealFillOrCleanSysRelationData(bo, fillBackFields);
    }

    private void recordSysRelationNoDataTips(com.seeyon.cap4.form.bean.FormBean formBean, CAP4RelationFillDataBO bo, Long recordId) {
        Long lastRecordId;
        if (bo.getFormRelationshipMapBean().getShowUnmatchTip() == 0) {
            return;
        }
        if (bo.isConditionAllNull()) {
            LOGGER.info((Object)("\u6761\u4ef6\u5b57\u6bb5\u90fd\u4e3a\u7a7a\uff0c\u4e0d\u505a\u8bb0\u5f55\uff01" + bo.getFormRelationshipMapBean().export4Log()));
            return;
        }
        AutoRelationTipBean tipBean = (AutoRelationTipBean)AppContext.getThreadContext((String)"autoRelationTips");
        tipBean = tipBean == null ? new AutoRelationTipBean() : tipBean;
        Map<String, String> conditionFieldMap = this.getRelationFormulaFieldMap(bo.getFormRelationshipMapBean().getConditionFormula());
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (String fromField : conditionFieldMap.keySet()) {
            FormFieldBean formFieldBean = formBean.getFieldBeanByName(fromField);
            fieldNames.add(formFieldBean.getDisplay());
        }
        String str = ResourceUtil.getStringByParams((String)"cap.template.data.relation.auto.noData", (Object[])new Object[]{bo.getFormRelationshipMapBean().getRelationshipBean().getName(), StringUtils.join(fieldNames, (String)"/")});
        tipBean.getTips().add(str);
        Long l = lastRecordId = recordId != null ? recordId : bo.getFormRecordId();
        if (lastRecordId != null) {
            Set<String> recordSet = tipBean.getRecord2Tips().get(lastRecordId);
            if (recordSet == null) {
                recordSet = new HashSet<String>();
                tipBean.getRecord2Tips().put(lastRecordId, recordSet);
            }
            recordSet.add(str);
        }
        AppContext.putThreadContext((String)"autoRelationTips", (Object)tipBean);
    }

    @Override
    public void dealFillOrCleanSysRelationData(CAP4RelationFillDataBO bo, Set<String> fillBackFields) throws BusinessException {
        com.seeyon.cap4.form.bean.FormBean formBean = this.cap4FormCacheManager.getForm(bo.getFormRelationshipMapBean().getRelationshipBean().getSourceFormId());
        if (CollectionUtils.isEmpty(bo.getRelationDatas())) {
            this.cleanData(bo, formBean, fillBackFields);
            this.recordSysRelationNoDataTips(formBean, bo, null);
        } else {
            Map<String, Object> relationData;
            Map<String, String> conditionFieldMap = this.getRelationFormulaFieldMap(bo.getFormRelationshipMapBean().getConditionFormula());
            HashMap<String, String> sonTableFieldConditionFieldMap = new HashMap<String, String>();
            String fromSonTableName = "";
            boolean conditionHasSon = false;
            for (String fromField : conditionFieldMap.keySet()) {
                FormFieldBean formFieldBean = formBean.getFieldBeanByName(fromField);
                if (!formFieldBean.isSubField()) continue;
                conditionHasSon = true;
                fromSonTableName = formFieldBean.getOwnerTableName();
                sonTableFieldConditionFieldMap.put(fromField, conditionFieldMap.get(fromField));
            }
            bo.setFromSonTableName(fromSonTableName);
            bo.setConditionHasSon(conditionHasSon);
            bo.setSonTableFieldConditionFieldMap(sonTableFieldConditionFieldMap);
            FormDataMasterBean formCacheDataMasterBean = bo.getFormCacheDataMasterBean();
            if (!bo.isConditionHasSon()) {
                relationData = bo.getRelationDatas().get(0);
                this.fillSysRelationData(bo, formBean, null, relationData, fillBackFields, true);
            } else if (bo.getFormRecordId() != null && bo.getFormRecordId() != 0L) {
                relationData = bo.getRelationDatas().get(0);
                this.fillSysRelationData(bo, formBean, bo.getFormRecordId(), relationData, fillBackFields, true);
            } else {
                List formDataSubBeans = formCacheDataMasterBean.getSubData(bo.getFromSonTableName());
                boolean isFillMasterField = true;
                for (FormDataSubBean formDataSubBean : formDataSubBeans) {
                    boolean subFilled = false;
                    for (Map<String, Object> relationData2 : bo.getRelationDatas()) {
                        boolean flag = true;
                        for (Map.Entry<String, String> fieldEntry : bo.getSonTableFieldConditionFieldMap().entrySet()) {
                            String toValue;
                            String fromValue = formDataSubBean.getFieldValue(fieldEntry.getKey()) == null ? "" : String.valueOf(formDataSubBean.getFieldValue(fieldEntry.getKey()));
                            if (fromValue.equals(toValue = relationData2.get(fieldEntry.getValue()) == null ? "" : String.valueOf(relationData2.get(fieldEntry.getValue())))) continue;
                            flag = false;
                            break;
                        }
                        if (!flag) continue;
                        this.fillSysRelationData(bo, formBean, formDataSubBean.getId(), relationData2, fillBackFields, isFillMasterField);
                        isFillMasterField = false;
                        subFilled = true;
                    }
                    if (subFilled) continue;
                    this.recordSysRelationNoDataTips(formBean, bo, formDataSubBean.getId());
                }
                if (isFillMasterField) {
                    this.cleanData(bo, formBean, fillBackFields);
                    this.recordSysRelationNoDataTips(formBean, bo, null);
                }
            }
        }
    }

    private void cleanData(CAP4RelationFillDataBO bo, com.seeyon.cap4.form.bean.FormBean formBean, Set<String> fillBackFields) {
        Set relationFieldMapKeys = bo.getFormRelationshipMapBean().getFormRelationFieldMap().keySet();
        FormDataMasterBean formCacheDataMasterBean = bo.getFormCacheDataMasterBean();
        HashMap<String, Object> changeField = new HashMap<String, Object>();
        for (String fieldName : relationFieldMapKeys) {
            FormFieldBean fromFieldBean = formBean.getFieldBeanByName(fieldName);
            if (fromFieldBean.isMasterField()) {
                formCacheDataMasterBean.putSessionAttachments(String.valueOf(formCacheDataMasterBean.getFieldValue(fieldName)), null);
                formCacheDataMasterBean.addFieldValue(fieldName, null, fillBackFields);
                changeField.put(fieldName, null);
                continue;
            }
            if (bo.getFormRecordId() != null) {
                FormDataSubBean subBean = formCacheDataMasterBean.getFormDataSubBeanById(fromFieldBean.getOwnerTableName(), bo.getFormRecordId());
                if (subBean == null) {
                    List formDataSubBeans = (List)formCacheDataMasterBean.getSubTables().get(fromFieldBean.getOwnerTableName());
                    for (FormDataSubBean formDataSubBean : formDataSubBeans) {
                        formCacheDataMasterBean.putSessionAttachments(String.valueOf(formDataSubBean.getFieldValue(fieldName)), null);
                        formDataSubBean.addFieldValue(fieldName, null, fillBackFields);
                        changeField.put(formDataSubBean.generageFillbackKey(fieldName), null);
                    }
                    continue;
                }
                formCacheDataMasterBean.putSessionAttachments(String.valueOf(subBean.getFieldValue(fieldName)), null);
                subBean.addFieldValue(fieldName, null, fillBackFields);
                changeField.put(subBean.generageFillbackKey(fieldName), null);
                continue;
            }
            List formDataSubBeans = (List)formCacheDataMasterBean.getSubTables().get(fromFieldBean.getOwnerTableName());
            for (FormDataSubBean formDataSubBean : formDataSubBeans) {
                formCacheDataMasterBean.putSessionAttachments(String.valueOf(formDataSubBean.getFieldValue(fieldName)), null);
                formDataSubBean.addFieldValue(fieldName, null, fillBackFields);
                changeField.put(formDataSubBean.generageFillbackKey(fieldName), null);
            }
        }
        CAPFormDataLogUtil.recordRelation(bo.getFormRelationshipMapBean(), formCacheDataMasterBean.getId(), changeField);
    }

    private Long copySysRelationLBSAndAttachment(com.seeyon.cap4.form.bean.FormBean fromFormBean, FormDataMasterBean formDataMasterBean, FormFieldBean fromFieldBean, Long subDataId, Object toFieldValue) throws BusinessException {
        if (toFieldValue == null || Strings.isBlank((String)String.valueOf(toFieldValue))) {
            return null;
        }
        Long newSubReference = null;
        Long subReference = Long.parseLong(String.valueOf(toFieldValue));
        if (fromFieldBean.isMap()) {
            newSubReference = CAPFormUtil.copyLBS(fromFormBean.getId(), formDataMasterBean.getId(), subDataId, subReference, fromFieldBean);
        }
        if (fromFieldBean.isAttachment()) {
            boolean saveDb;
            Long fromModuleId = formDataMasterBean.getExtraAttr("moduleId") == null ? null : Long.valueOf(Long.parseLong(String.valueOf(formDataMasterBean.getExtraAttr("moduleId"))));
            Long newReference = fromModuleId == null ? formDataMasterBean.getId() : fromModuleId;
            boolean isFromTrigger = "dataFromTrigger".equals(formDataMasterBean.getExtraAttr("dataFromTrigger"));
            boolean isFromBatch = "dataFromBatchOperation".equals(formDataMasterBean.getExtraAttr("calcAttachSaveDb"));
            boolean bl = saveDb = isFromTrigger || isFromBatch;
            if (saveDb && newSubReference == null && fromFieldBean.isMasterField() && formDataMasterBean.getFieldValue(fromFieldBean.getName()) != null) {
                formDataMasterBean.addFieldValue(fromFieldBean.getName(), null);
            }
            newSubReference = CAPAttachmentUtil.copyAttachment(formDataMasterBean, fromFieldBean, subReference, newReference, newSubReference, saveDb);
        }
        return newSubReference;
    }

    private void fillSysRelationData(CAP4RelationFillDataBO bo, com.seeyon.cap4.form.bean.FormBean fromFormBean, Long formRecordId, Map<String, Object> relationData, Set<String> fillBackFields, boolean isFillMasterField) throws BusinessException {
        FormDataMasterBean formCacheDataMasterBean = bo.getFormCacheDataMasterBean();
        Map relationFieldMap = bo.getFormRelationshipMapBean().getFormRelationFieldMap();
        HashMap<String, Object> changeField = new HashMap<String, Object>();
        block0: for (String fromFieldName : relationFieldMap.keySet()) {
            String toFieldName = (String)relationFieldMap.get(fromFieldName);
            Object value = relationData.get(toFieldName);
            FormFieldBean fromFieldBean = fromFormBean.getFieldBeanByName(fromFieldName);
            if (fromFieldBean == null) {
                LOGGER.error((Object)("fillSysRelationData \u65e0\u6cd5\u627e\u5230\u5b57\u6bb5 " + fromFieldName + ", data:" + bo.getFormCacheDataMasterBean().getId() + ", relation:" + bo.getFormRelationshipMapBean().export4Log()));
                continue;
            }
            if (fromFieldBean.isAttachment() || fromFieldBean.isMap()) {
                value = this.copySysRelationLBSAndAttachment(fromFormBean, formCacheDataMasterBean, fromFieldBean, formRecordId, relationData.get(toFieldName));
            }
            if (fromFieldBean.isMasterField() && isFillMasterField) {
                formCacheDataMasterBean.addFieldValue(fromFieldName, value, fillBackFields);
                changeField.put(fromFieldName, value);
                continue;
            }
            if (!Strings.isNotBlank((String)bo.getFromSonTableName()) || !bo.getFromSonTableName().equals(fromFieldBean.getOwnerTableName()) || !fromFieldBean.isSubField()) continue;
            List formDataSubBeans = (List)formCacheDataMasterBean.getSubTables().get(fromFieldBean.getOwnerTableName());
            for (FormDataSubBean formDataSubBean : formDataSubBeans) {
                if (formRecordId == null || formRecordId.longValue() != formDataSubBean.getId().longValue()) continue;
                formDataSubBean.addFieldValue(fromFieldName, value);
                if (fillBackFields != null) {
                    fillBackFields.add(fromFieldName + "_" + formRecordId);
                }
                changeField.put(formDataSubBean.generageFillbackKey(fromFieldName), value);
                continue block0;
            }
        }
        CAPFormDataLogUtil.recordRelation(bo.getFormRelationshipMapBean(), formCacheDataMasterBean.getId(), changeField);
    }

    @Override
    public Set<String> dealEnumRelation(com.seeyon.cap4.form.bean.FormBean formBean, FormDataMasterBean formDataMasterBean, FormAuthViewBean formAuthViewBean, FormFieldBean fieldBean, FormDataSubBean formDataSubBean, Set<String> fillBackFields, boolean needSysRelation, Map<String, Object> sysFillBackValues) {
        block13: {
            try {
                List formRelations = formBean.getRelationList();
                FormRelation formRelation = fieldBean.getFormRelation();
                if ("calcAll".equals(String.valueOf(AppContext.getThreadContext((String)"isFrom")))) {
                    Set runtimeCalcEnumSets = AppContext.getThreadContext((String)"runtimeCalcEnumSets") == null ? null : (Set)AppContext.getThreadContext((String)"runtimeCalcEnumSets");
                    for (FormRelation tempFormRelation : formRelations) {
                        Object relationValue;
                        if (!formRelation.getToRelationAttr().equals(tempFormRelation.getToRelationAttr())) continue;
                        FormFieldBean fromFieldBean = formBean.getFieldBeanByName(tempFormRelation.getFromRelationAttr());
                        FormFieldBean toFieldBean = formBean.getFieldBeanByName(tempFormRelation.getToRelationAttr());
                        Long fromValue = 0L;
                        if (fromFieldBean.isMasterField()) {
                            fromValue = this.getSelfRelationFieldValue((FormDataBean)formDataMasterBean, tempFormRelation.getToRelationAttr());
                            if (toFieldBean.getInputTypeEnum().getKey().equalsIgnoreCase(FormFieldComEnum.EXTEND_MEMBER.getKey()) && this.getInnerRelationValueChanged(fromFieldBean, formDataSubBean)) {
                                relationValue = FormRelationEnums.getRelationValue((String)tempFormRelation.getViewAttr(), (FormRelationEnums.ToRelationAttrType)FormRelationEnums.ToRelationAttrType.data_relation_member, (Long)fromValue, (FormFieldBean)fromFieldBean);
                                formDataMasterBean.addFieldValue(fromFieldBean.getName(), relationValue, fillBackFields);
                                continue;
                            }
                            if (runtimeCalcEnumSets != null) {
                                runtimeCalcEnumSets.add(formDataMasterBean.generageFillbackKey(fromFieldBean.getName()));
                            }
                            CAPFormUtil.putFieldEnumIdToMasterBean(formDataMasterBean, CAPFormUtil.getFieldEnumIdKey(fromFieldBean, formDataSubBean), fromValue);
                            continue;
                        }
                        if (toFieldBean.isMasterField()) {
                            List subDataBeans = formDataMasterBean.getSubData(fromFieldBean.getOwnerTableName());
                            fromValue = this.getSelfRelationFieldValue((FormDataBean)formDataMasterBean, tempFormRelation.getToRelationAttr());
                            if (toFieldBean.getInputTypeEnum().getKey().equalsIgnoreCase(FormFieldComEnum.EXTEND_MEMBER.getKey()) && this.getInnerRelationValueChanged(fromFieldBean, formDataSubBean)) {
                                Object relationValue2 = FormRelationEnums.getRelationValue((String)tempFormRelation.getViewAttr(), (FormRelationEnums.ToRelationAttrType)FormRelationEnums.ToRelationAttrType.data_relation_member, (Long)fromValue, (FormFieldBean)fromFieldBean);
                                for (FormDataSubBean subBean : subDataBeans) {
                                    subBean.addFieldValue(fromFieldBean.getName(), relationValue2, fillBackFields);
                                }
                                continue;
                            }
                            if (runtimeCalcEnumSets != null) {
                                for (FormDataSubBean subBean : subDataBeans) {
                                    runtimeCalcEnumSets.add(subBean.generageFillbackKey(fromFieldBean.getName()));
                                }
                            }
                            CAPFormUtil.putFieldEnumIdToMasterBean(formDataMasterBean, CAPFormUtil.getFieldEnumIdKey(fromFieldBean, formDataSubBean), fromValue);
                            continue;
                        }
                        fromValue = this.getSelfRelationFieldValue((FormDataBean)formDataSubBean, tempFormRelation.getToRelationAttr());
                        if (toFieldBean.getInputTypeEnum().getKey().equalsIgnoreCase(FormFieldComEnum.EXTEND_MEMBER.getKey()) && this.getInnerRelationValueChanged(fromFieldBean, formDataSubBean)) {
                            relationValue = FormRelationEnums.getRelationValue((String)tempFormRelation.getViewAttr(), (FormRelationEnums.ToRelationAttrType)FormRelationEnums.ToRelationAttrType.data_relation_member, (Long)fromValue, (FormFieldBean)fromFieldBean);
                            if (formDataSubBean == null) continue;
                            formDataSubBean.addFieldValue(fromFieldBean.getName(), relationValue, fillBackFields);
                            continue;
                        }
                        CAPFormUtil.putFieldEnumIdToMasterBean(formDataMasterBean, CAPFormUtil.getFieldEnumIdKey(fromFieldBean, formDataSubBean), fromValue);
                        if (runtimeCalcEnumSets == null || formDataSubBean == null) continue;
                        runtimeCalcEnumSets.add(formDataSubBean.generageFillbackKey(fromFieldBean.getName()));
                    }
                    break block13;
                }
                this.dealEnumRelation(formRelations, formBean, fieldBean, formDataMasterBean, fillBackFields, formAuthViewBean, formDataSubBean, needSysRelation, sysFillBackValues);
            }
            catch (Exception e) {
                LOGGER.error((Object)"dealEnumRelation is error ", (Throwable)e);
            }
        }
        return fillBackFields;
    }

    private void dealEnumRelation(List<FormRelation> formRelations, com.seeyon.cap4.form.bean.FormBean formBean, FormFieldBean fieldBean, FormDataMasterBean formDataMasterBean, Set<String> fillBackFields, FormAuthViewBean formAuthViewBean, FormDataSubBean formDataSubBean, boolean needSysRelation, Map<String, Object> sysFillBackValues) throws Exception {
        if (sysFillBackValues == null) {
            sysFillBackValues = (Map)AppContext.getThreadContext((String)"fieldInnerChangeMap");
        }
        for (FormRelation tempFormRelation : formRelations) {
            String enumIdKey;
            List subDataBeans;
            if (!fieldBean.getName().equals(tempFormRelation.getToRelationAttr())) continue;
            FormFieldBean fromFieldBean = formBean.getFieldBeanByName(tempFormRelation.getFromRelationAttr());
            FormFieldBean toFieldBean = formBean.getFieldBeanByName(tempFormRelation.getToRelationAttr());
            Long fromValue = 0L;
            if (fieldBean.isMasterField()) {
                if (fromFieldBean.isMasterField()) {
                    if ("true".equals(String.valueOf(AppContext.getThreadContext((String)"ignoreFillMasterField")))) continue;
                    if (!toFieldBean.getInputTypeEnum().getKey().equalsIgnoreCase(FormFieldComEnum.EXTEND_MEMBER.getKey())) {
                        fromValue = this.getSelfRelationFieldValue((FormDataBean)formDataMasterBean, tempFormRelation.getToRelationAttr());
                        CAPFormUtil.putFieldEnumIdToMasterBean(formDataMasterBean, CAPFormUtil.getFieldEnumIdKey(fromFieldBean, formDataSubBean), fromValue);
                        if (toFieldBean.isMasterField() && formDataSubBean != null) {
                            CAPFormUtil.putFieldEnumIdToMasterBean(formDataMasterBean, CAPFormUtil.getFieldEnumIdKey(fromFieldBean, null), fromValue);
                        }
                    }
                    formDataMasterBean.addFieldValue(fromFieldBean.getName(), sysFillBackValues != null ? sysFillBackValues.get(fromFieldBean.getName()) : null, fillBackFields);
                } else {
                    subDataBeans = formDataMasterBean.getSubData(fromFieldBean.getOwnerTableName());
                    if (!toFieldBean.getInputTypeEnum().getKey().equalsIgnoreCase(FormFieldComEnum.EXTEND_MEMBER.getKey())) {
                        fromValue = this.getSelfRelationFieldValue((FormDataBean)formDataMasterBean, tempFormRelation.getToRelationAttr());
                    }
                    for (FormDataSubBean subDataBean : subDataBeans) {
                        enumIdKey = CAPFormUtil.getFieldEnumIdKey(fromFieldBean, subDataBean);
                        Object oldFromValue = CAPFormUtil.getFieldEnumIdFromMasterBean(formDataMasterBean, enumIdKey);
                        if (fromValue.equals(oldFromValue) && !fromValue.equals(0L)) continue;
                        CAPFormUtil.putFieldEnumIdToMasterBean(formDataMasterBean, enumIdKey, fromValue);
                        subDataBean.addFieldValue(fromFieldBean.getName(), sysFillBackValues != null ? sysFillBackValues.get(fromFieldBean.getName() + "_" + subDataBean.getId()) : null, fillBackFields);
                    }
                }
            } else if (formDataSubBean == null) {
                subDataBeans = formDataMasterBean.getSubData(fromFieldBean.getOwnerTableName());
                for (FormDataSubBean subDataBean : subDataBeans) {
                    if (!toFieldBean.getInputTypeEnum().getKey().equalsIgnoreCase(FormFieldComEnum.EXTEND_MEMBER.getKey())) {
                        fromValue = this.getSelfRelationFieldValue((FormDataBean)subDataBean, tempFormRelation.getToRelationAttr());
                    }
                    enumIdKey = CAPFormUtil.getFieldEnumIdKey(fromFieldBean, subDataBean);
                    CAPFormUtil.putFieldEnumIdToMasterBean(formDataMasterBean, enumIdKey, fromValue);
                    subDataBean.addFieldValue(fromFieldBean.getName(), sysFillBackValues != null ? sysFillBackValues.get(fromFieldBean.getName() + "_" + subDataBean.getId()) : null, fillBackFields);
                }
            } else {
                if (!toFieldBean.getInputTypeEnum().getKey().equalsIgnoreCase(FormFieldComEnum.EXTEND_MEMBER.getKey())) {
                    fromValue = this.getSelfRelationFieldValue((FormDataBean)formDataSubBean, tempFormRelation.getToRelationAttr());
                    CAPFormUtil.putFieldEnumIdToMasterBean(formDataMasterBean, CAPFormUtil.getFieldEnumIdKey(fromFieldBean, formDataSubBean), fromValue);
                }
                formDataSubBean.addFieldValue(fromFieldBean.getName(), sysFillBackValues != null ? sysFillBackValues.get(fromFieldBean.getName() + "_" + formDataSubBean.getId()) : null, fillBackFields);
            }
            if (fromFieldBean.isInRelationCondition() && (needSysRelation || fillBackFields != null && fillBackFields.contains(fromFieldBean.isSubField() && formDataSubBean != null ? formDataSubBean.generageFillbackKey(fromFieldBean.getName()) : formDataMasterBean.generageFillbackKey(fromFieldBean.getName())))) {
                this.dealSysRelation(formBean, formDataMasterBean, formAuthViewBean, fromFieldBean, formDataSubBean, fillBackFields);
            }
            if (fromFieldBean.isInCalculate()) {
                this.cap4FormDataManager.calcAllWithFieldIn(formBean, fromFieldBean, formDataMasterBean, formDataSubBean, fillBackFields, formAuthViewBean, needSysRelation);
            }
            if (!fromFieldBean.isInInnerRelation()) continue;
            this.dealEnumRelation(formRelations, formBean, fromFieldBean, formDataMasterBean, fillBackFields, formAuthViewBean, formDataSubBean, needSysRelation, sysFillBackValues);
        }
    }

    @Override
    public Set<String> dealRelationByType(com.seeyon.cap4.form.bean.FormBean formBean, FormDataMasterBean formDataMasterBean, FormAuthViewBean formAuthViewBean, FormFieldBean fieldBean, FormDataSubBean formDataSubBean, Set<String> fillBackFields, FormRelationEnums.ToRelationAttrType toRelationAttrType, boolean needSysRelation) throws BusinessException {
        block7: {
            try {
                List formRelations = formBean.getRelationList();
                FormRelation formRelation = fieldBean.getFormRelation();
                if ("calcAll".equals(String.valueOf(AppContext.getThreadContext((String)"isFrom")))) {
                    for (FormRelation tempFormRelation : formRelations) {
                        Object value;
                        if (!formRelation.getToRelationAttr().equals(tempFormRelation.getToRelationAttr())) continue;
                        String viewAttr = tempFormRelation.getViewAttr();
                        FormFieldBean fromFieldBean = formBean.getFieldBeanByName(tempFormRelation.getFromRelationAttr());
                        FormFieldBean toFieldBean = formBean.getFieldBeanByName(tempFormRelation.getToRelationAttr());
                        Long fromValue = 0L;
                        if (fromFieldBean.isMasterField()) {
                            fromValue = this.getSelfRelationFieldValue((FormDataBean)formDataMasterBean, tempFormRelation.getToRelationAttr());
                            value = FormRelationEnums.getRelationValue((String)viewAttr, (FormRelationEnums.ToRelationAttrType)toRelationAttrType, (Long)fromValue, (FormFieldBean)fromFieldBean);
                            formDataMasterBean.addFieldValue(fromFieldBean.getName(), value, fillBackFields);
                            continue;
                        }
                        if (toFieldBean.isMasterField()) {
                            List subDataBeans = formDataMasterBean.getSubData(fromFieldBean.getOwnerTableName());
                            fromValue = this.getSelfRelationFieldValue((FormDataBean)formDataMasterBean, tempFormRelation.getToRelationAttr());
                            for (FormDataSubBean subDataBean : subDataBeans) {
                                Object value2 = FormRelationEnums.getRelationValue((String)viewAttr, (FormRelationEnums.ToRelationAttrType)toRelationAttrType, (Long)fromValue, (FormFieldBean)fromFieldBean);
                                subDataBean.addFieldValue(fromFieldBean.getName(), value2, fillBackFields);
                            }
                            continue;
                        }
                        fromValue = this.getSelfRelationFieldValue((FormDataBean)formDataSubBean, tempFormRelation.getToRelationAttr());
                        value = FormRelationEnums.getRelationValue((String)viewAttr, (FormRelationEnums.ToRelationAttrType)toRelationAttrType, (Long)fromValue, (FormFieldBean)fromFieldBean);
                        if (formDataSubBean == null) continue;
                        formDataSubBean.addFieldValue(fromFieldBean.getName(), value, fillBackFields);
                    }
                    break block7;
                }
                this.dealRelationByType(formRelations, formBean, fieldBean, formDataMasterBean, toRelationAttrType, fillBackFields, formAuthViewBean, formDataSubBean, needSysRelation);
            }
            catch (Exception e) {
                throw new BusinessException((Throwable)e);
            }
        }
        return fillBackFields;
    }

    private void dealRelationByType(List<FormRelation> formRelations, com.seeyon.cap4.form.bean.FormBean formBean, FormFieldBean fieldBean, FormDataMasterBean formDataMasterBean, FormRelationEnums.ToRelationAttrType toRelationAttrType, Set<String> fillBackFields, FormAuthViewBean formAuthViewBean, FormDataSubBean formDataSubBean, boolean needSysRelation) throws Exception {
        for (FormRelation tempFormRelation : formRelations) {
            Object value;
            if (!fieldBean.getName().equals(tempFormRelation.getToRelationAttr())) continue;
            String viewAttr = tempFormRelation.getViewAttr();
            FormFieldBean fromFieldBean = formBean.getFieldBeanByName(tempFormRelation.getFromRelationAttr());
            FormFieldBean toFieldBean = formBean.getFieldBeanByName(tempFormRelation.getToRelationAttr());
            Long fromValue = 0L;
            if (toFieldBean.isMasterField()) {
                if (fromFieldBean.isMasterField()) {
                    if ("true".equals(String.valueOf(AppContext.getThreadContext((String)"ignoreFillMasterField")))) continue;
                    fromValue = this.getSelfRelationFieldValue((FormDataBean)formDataMasterBean, tempFormRelation.getToRelationAttr());
                    value = FormRelationEnums.getRelationValue((String)viewAttr, (FormRelationEnums.ToRelationAttrType)toRelationAttrType, (Long)fromValue, (FormFieldBean)fromFieldBean);
                    formDataMasterBean.addFieldValue(fromFieldBean.getName(), value, fillBackFields);
                } else {
                    fromValue = this.getSelfRelationFieldValue((FormDataBean)formDataMasterBean, tempFormRelation.getToRelationAttr());
                    value = FormRelationEnums.getRelationValue((String)viewAttr, (FormRelationEnums.ToRelationAttrType)toRelationAttrType, (Long)fromValue, (FormFieldBean)fromFieldBean);
                    if (formDataSubBean == null) {
                        List subDataBeans = formDataMasterBean.getSubData(fromFieldBean.getOwnerTableName());
                        for (FormDataSubBean subDataBean : subDataBeans) {
                            subDataBean.addFieldValue(fromFieldBean.getName(), value, fillBackFields);
                        }
                    } else {
                        formDataSubBean.addFieldValue(fromFieldBean.getName(), value, fillBackFields);
                    }
                }
            } else if (formDataSubBean != null) {
                fromValue = this.getSelfRelationFieldValue((FormDataBean)formDataSubBean, tempFormRelation.getToRelationAttr());
                value = FormRelationEnums.getRelationValue((String)viewAttr, (FormRelationEnums.ToRelationAttrType)toRelationAttrType, (Long)fromValue, (FormFieldBean)fromFieldBean);
                formDataSubBean.addFieldValue(fromFieldBean.getName(), value, fillBackFields);
            } else {
                List subDataBeans = formDataMasterBean.getSubData(fromFieldBean.getOwnerTableName());
                for (FormDataSubBean subDataBean : subDataBeans) {
                    fromValue = this.getSelfRelationFieldValue((FormDataBean)subDataBean, tempFormRelation.getToRelationAttr());
                    Object value2 = FormRelationEnums.getRelationValue((String)viewAttr, (FormRelationEnums.ToRelationAttrType)toRelationAttrType, (Long)fromValue, (FormFieldBean)fromFieldBean);
                    subDataBean.addFieldValue(fromFieldBean.getName(), value2, fillBackFields);
                }
            }
            if (fromFieldBean.isInRelationCondition() && (needSysRelation || fillBackFields != null && fillBackFields.contains(fromFieldBean.isSubField() && formDataSubBean != null ? formDataSubBean.generageFillbackKey(fromFieldBean.getName()) : formDataMasterBean.generageFillbackKey(fromFieldBean.getName())))) {
                this.dealSysRelation(formBean, formDataMasterBean, formAuthViewBean, fromFieldBean, formDataSubBean, fillBackFields);
            }
            if (fromFieldBean.isInCalculate()) {
                this.cap4FormDataManager.calcAllWithFieldIn(formBean, fromFieldBean, formDataMasterBean, formDataSubBean, fillBackFields, formAuthViewBean, needSysRelation);
            }
            if (!fromFieldBean.isInInnerRelation()) continue;
            this.dealRelationByType(formBean, formDataMasterBean, formAuthViewBean, fromFieldBean, formDataSubBean, fillBackFields, fromFieldBean.getPossibleRelationAttrType(), needSysRelation);
        }
    }

    @Override
    public boolean getInnerRelationValueChanged(FormFieldBean formFieldBean, FormDataSubBean formDataSubBean) {
        Map changeFields = (Map)AppContext.getThreadContext((String)"fieldChangeTag");
        Map changeField = (Map)changeFields.get(formFieldBean.getOwnerTableName());
        boolean hasContainField = false;
        if (changeField != null) {
            String keyName = formFieldBean.getName() + (formFieldBean.isMasterField() ? "" : "_" + formDataSubBean.getId());
            hasContainField = changeField.keySet().contains(keyName);
        }
        return hasContainField;
    }

    private Long getSelfRelationFieldValue(FormDataBean formDataBean, String fieldName) {
        if (formDataBean == null) {
            return 0L;
        }
        Object fromValueObj = formDataBean.getFieldValue(fieldName);
        return fromValueObj != null ? Long.valueOf(String.valueOf(fromValueObj)) : 0L;
    }

    @Override
    public FormRelationshipMapBean getFormRelationshipMapBeanBySelectedFieldName(FormRelationshipBean formRelationshipBean, String fieldName) {
        if (formRelationshipBean == null || Strings.isBlank((String)fieldName)) {
            return null;
        }
        List formRelationshipMapBeans = formRelationshipBean.getRelationMapList();
        for (FormRelationshipMapBean formRelationshipMapBean : formRelationshipMapBeans) {
            if (!formRelationshipMapBean.getSelectedField().equals(fieldName)) continue;
            return formRelationshipMapBean;
        }
        return null;
    }

    @Override
    public List<CAPFormRelationRecord> getCAPFormRelationRecordsByMasterDataId(Long masterDataId) {
        try {
            return this.cap4FormRelationRecordDAO.selectRecordByFormMasterDataId(masterDataId);
        }
        catch (BusinessException e) {
            LOGGER.error((Object)("getCAPFormRelationRecordsByMasterId error is " + e.getMessage() + "param masterDataId is " + masterDataId));
            return new ArrayList<CAPFormRelationRecord>();
        }
    }

    @Override
    public void upgradeCAPFormRelationRecords(com.seeyon.cap4.form.bean.FormBean formBean, List<CAPFormRelationRecord> relationRecords, boolean saveDb) throws BusinessException {
        if (CollectionUtils.isEmpty(relationRecords)) {
            return;
        }
        ArrayList<CAPFormRelationRecord> updateRecords = new ArrayList<CAPFormRelationRecord>();
        ArrayList<CAPFormRelationRecord> deleteRecords = new ArrayList<CAPFormRelationRecord>();
        Iterator<CAPFormRelationRecord> iterator = relationRecords.iterator();
        while (iterator.hasNext()) {
            CAPFormRelationRecord relationRecord = iterator.next();
            if (relationRecord.getRelationShipId() != null) continue;
            FormFieldBean fieldBean = formBean.getFieldBeanByName(relationRecord.getFieldName());
            if (fieldBean == null) {
                deleteRecords.add(relationRecord);
                iterator.remove();
                continue;
            }
            List<FormRelationshipMapBean> mapBeans = this.getField4ManualFormRelationshipMapBeans(fieldBean, true);
            if (CollectionUtils.isEmpty(mapBeans)) {
                deleteRecords.add(relationRecord);
                iterator.remove();
                continue;
            }
            relationRecord.setDataInfo(mapBeans.get(0));
            updateRecords.add(relationRecord);
        }
        if (saveDb) {
            if (CollectionUtils.isNotEmpty(deleteRecords)) {
                LOGGER.info((Object)("upgradeCAPFormRelationRecords\u5220\u9664\u5173\u8054\u5173\u7cfb\u8bb0\u5f55 " + ((Object)deleteRecords).toString()));
                this.cap4FormRelationRecordDAO.delete(deleteRecords);
            }
            if (CollectionUtils.isNotEmpty(updateRecords)) {
                LOGGER.info((Object)("upgradeCAPFormRelationRecords\u66f4\u65b0\u5173\u8054\u5173\u7cfb\u8bb0\u5f55 " + ((Object)updateRecords).toString()));
                this.cap4FormRelationRecordDAO.update(updateRecords);
            }
        }
    }

    @Override
    public void saveOrUpdateCAPFormRelationRecords(Long fromMasterDataId, List<CAPFormRelationRecord> relationRecords) {
        try {
            LOGGER.info((Object)("\u5220\u9664\u5173\u8054\u5173\u7cfb\u8bb0\u5f55,single," + fromMasterDataId));
            this.cap4FormRelationRecordDAO.deleteByFromFormMasterDataId(fromMasterDataId);
            if (Strings.isNotEmpty(relationRecords)) {
                LOGGER.info((Object)("\u4fdd\u5b58\u5173\u8054\u5173\u7cfb\u8bb0\u5f55,single," + fromMasterDataId + ",records:" + relationRecords.size()));
                this.cap4FormRelationRecordDAO.insertCAPFormRelationRecords(relationRecords);
            }
        }
        catch (BusinessException e) {
            LOGGER.error((Object)("saveOrUpdateCAPFormRelationRecords error" + e.getMessage() + ",fromMasterDataId is" + fromMasterDataId), (Throwable)e);
        }
    }

    @Override
    public void deleteCAPFormRelationRecordByFromMasterIds(List<Long> masterIds) throws BusinessException, SQLException {
        if (Strings.isNotEmpty(masterIds)) {
            LOGGER.info((Object)("\u5220\u9664\u5173\u8054\u5173\u7cfb\u8bb0\u5f55,multi," + masterIds));
            this.cap4FormRelationRecordDAO.deleteByFromFormMasterDataIds(masterIds);
        }
    }

    @Override
    public FlipInfo getFormRelationSubDataList(FlipInfo flipInfo, CAP4RelationQueryParamsBO bo, List<Map<String, Object>> queryConditions) throws BusinessException {
        String masTableName;
        String subTableName;
        FormFieldBean toRelationFieldBean;
        FormRelationshipMapBean formRelationshipMapBean = bo.getFormRelationshipMapBean();
        List<String> relationShowFields = this.getRelationQueryFields(formRelationshipMapBean);
        com.seeyon.cap4.form.bean.FormBean toFormBean = this.cap4FormCacheManager.getForm(formRelationshipMapBean.getRelationshipBean().getTargetFormId());
        FormBean toFormBean3 = null;
        if (toFormBean == null) {
            toFormBean3 = this.formCacheManager.getForm(formRelationshipMapBean.getRelationshipBean().getTargetFormId());
        }
        Map relationFieldMap = formRelationshipMapBean.getFormRelationFieldMap();
        String toRelationAttr = (String)relationFieldMap.get(bo.getFromRelationAttr());
        if (toFormBean != null) {
            toRelationFieldBean = toFormBean.getFieldBeanByName(toRelationAttr);
            subTableName = toFormBean.getTableByTableName(toRelationFieldBean.getOwnerTableName()).getTableName();
            masTableName = toFormBean.getMasterTableBean().getTableName();
        } else {
            toRelationFieldBean = toFormBean3.getFieldBeanByName(toRelationAttr);
            subTableName = toFormBean3.getTableByTableName(toRelationFieldBean.getOwnerTableName()).getTableName();
            masTableName = toFormBean3.getMasterTableBean().getTableName();
        }
        LinkedHashSet<String> fieldSet = new LinkedHashSet<String>();
        fieldSet.add(subTableName + "." + Enums.SubTableField.id);
        fieldSet.add(subTableName + "." + Enums.SubTableField.formmain_id);
        for (int i = 0; i < relationShowFields.size(); ++i) {
            FormFieldBean formFieldBean;
            String fieldName = relationShowFields.get(i);
            if (fieldName.contains(".")) {
                fieldName = fieldName.split("[.]")[1];
            }
            if (toFormBean != null) {
                formFieldBean = toFormBean.getFieldBeanByName(fieldName);
                if (formFieldBean.isMasterField()) {
                    fieldSet.add(masTableName + "." + formFieldBean.getName());
                    continue;
                }
                fieldSet.add(subTableName + "." + formFieldBean.getName());
                continue;
            }
            formFieldBean = toFormBean3.getFieldBeanByName(fieldName);
            if (formFieldBean.isMasterField()) {
                fieldSet.add(masTableName + "." + formFieldBean.getName());
                continue;
            }
            fieldSet.add(subTableName + "." + formFieldBean.getName());
        }
        String fieldNames = StringUtils.join(fieldSet, (String)",");
        StringBuilder sql = new StringBuilder("SELECT ");
        sql.append(fieldNames);
        sql.append(" FROM ").append(masTableName).append(" INNER JOIN ").append(subTableName).append(" ON ");
        sql.append(this.capDataListSqlHelpManager.getSQLMasterEqualSub4Id(masTableName, subTableName));
        ArrayList<FormQueryWhereClause> whereClauses = new ArrayList<FormQueryWhereClause>();
        if (bo.getSelectedToMasterDataId() != null) {
            FormQueryWhereClause whereClause = new FormQueryWhereClause();
            ArrayList<Long> qp = new ArrayList<Long>();
            qp.add(bo.getSelectedToMasterDataId());
            whereClause.setAllSqlClause(subTableName + "." + Enums.SubTableField.formmain_id.getKey() + " = ? ");
            whereClause.setQueryParams(qp);
            whereClauses.add(whereClause);
        }
        if (CollectionUtils.isNotEmpty(queryConditions)) {
            FormQueryWhereClause conditionWhereClause = this.capDataListSqlHelpManager.getFormQueryWhereClauseByMap(queryConditions, true);
            whereClauses.add(conditionWhereClause);
        }
        FormQueryWhereClause relationSqlWhereClause = null;
        if (!(formRelationshipMapBean.getRelationshipBean().getRelationType() != 1 && formRelationshipMapBean.getRelationshipBean().getRelationType() != 4 || toFormBean == null || this.isMagicManualRelation(formRelationshipMapBean.getRelationshipBean()))) {
            relationSqlWhereClause = this.getRelationConditionFormQueryWhereClause(toFormBean, bo, formRelationshipMapBean);
        } else if (toFormBean != null) {
            relationSqlWhereClause = this.getMagicRelationConditionFormQueryWhereClause(toFormBean, bo, formRelationshipMapBean);
        }
        whereClauses.add(relationSqlWhereClause);
        ArrayList<Object> queryParams = new ArrayList<Object>();
        String whereStr = this.capDataListSqlHelpManager.getSQLWhere(whereClauses, queryParams);
        if (StringUtils.isNotEmpty((String)whereStr)) {
            sql.append(" WHERE ").append(whereStr);
        }
        sql.append(" ORDER BY ");
        List sortFieldList = formRelationshipMapBean.getSortFieldList();
        if (CollectionUtils.isEmpty((Collection)sortFieldList)) {
            sql.append(masTableName + "." + Enums.MasterTableField.start_date + " ASC," + subTableName + "." + Enums.SubTableField.sort + " ASC");
        } else {
            sql.append(this.getSortSql(sortFieldList));
        }
        if (JDBCAgent.isOracleRuntime()) {
            sql.append(",").append(masTableName).append(".id ASC");
        }
        try {
            LOGGER.info((Object)("queryType:[relation sub] " + formRelationshipMapBean.export4Log()));
            this.capDataListSqlHelpManager.selectDataList(flipInfo, sql.toString(), queryParams);
        }
        catch (BusinessException e) {
            LOGGER.error((Object)("getFormRelationSubDataList is BusinessException. params bo is " + bo.toString()), (Throwable)e);
        }
        catch (SQLException e) {
            LOGGER.error((Object)("getFormRelationSubDataList is SQLException. params bo is " + bo.toString()), (Throwable)e);
        }
        this.dealPreRelationData(flipInfo.getData(), toFormBean != null ? toFormBean : toFormBean3);
        return flipInfo;
    }

    @Override
    public List<String> getRelationQueryFields(FormRelationshipMapBean formRelationshipMapBean) {
        List showFieldList = formRelationshipMapBean.getShowFieldList();
        ArrayList<String> newShowFieldList = new ArrayList<String>();
        for (SimpleObjectBean temp : showFieldList) {
            newShowFieldList.add(temp.getName());
        }
        Map relationFieldMap = formRelationshipMapBean.getFormRelationFieldMap();
        if (relationFieldMap != null) {
            for (String key : relationFieldMap.keySet()) {
                newShowFieldList.add((String)relationFieldMap.get(key));
            }
            HashSet<String> hashSet = new HashSet<String>(newShowFieldList);
            newShowFieldList.clear();
            newShowFieldList.addAll(hashSet);
        }
        newShowFieldList.remove(FormRelationEnums.SpecialRelationItem.FLOW_NAME.getKey());
        return newShowFieldList;
    }

    @Override
    public FlipInfo getFormRelationDataList(FlipInfo flipInfo, CAP4RelationQueryParamsBO queryBo, List<Map<String, Object>> queryConditions) throws BusinessException {
        FormRelationshipMapBean formRelationshipMapBean = queryBo.getFormRelationshipMapBean();
        ArrayList<String> relationShowFields = new ArrayList<String>(this.getRelationQueryFields(formRelationshipMapBean));
        if (queryBo.getCustomShowFields() != null) {
            relationShowFields.addAll(queryBo.getCustomShowFields());
        }
        com.seeyon.cap4.form.bean.FormBean toFormBean = this.cap4FormCacheManager.getForm(formRelationshipMapBean.getRelationshipBean().getTargetFormId());
        FormBean toFormBean3 = null;
        if (toFormBean == null) {
            toFormBean3 = this.formCacheManager.getForm(formRelationshipMapBean.getRelationshipBean().getTargetFormId());
        }
        ArrayList<FormQueryWhereClause> whereClauses = new ArrayList<FormQueryWhereClause>();
        if (queryBo.getSelectedToMasterDataId() != null) {
            String masterTableName = toFormBean != null ? toFormBean.getMasterTableBean().getTableName() : toFormBean3.getMasterTableBean().getTableName();
            ArrayList<Long> queryParams = new ArrayList<Long>();
            queryParams.add(queryBo.getSelectedToMasterDataId());
            FormQueryWhereClause whereClause = new FormQueryWhereClause();
            whereClause.setAllSqlClause(masterTableName + "." + Enums.MasterTableField.id.getKey() + " = ? ");
            whereClause.setQueryParams(queryParams);
            whereClauses.add(whereClause);
        }
        if (CollectionUtils.isNotEmpty(queryConditions)) {
            FormQueryWhereClause conditionWhereClause = this.capDataListSqlHelpManager.getFormQueryWhereClauseByMap(queryConditions, true);
            whereClauses.add(conditionWhereClause);
        }
        FormQueryWhereClause relationFormQueryWhereClause = null;
        if (!(formRelationshipMapBean.getRelationshipBean().getRelationType() != FormRelationEnums.ViewSelectType.user.getKey() && formRelationshipMapBean.getRelationshipBean().getRelationType() != FormRelationEnums.ViewSelectType.auto_increase_row.getKey() || toFormBean == null || this.isMagicManualRelation(formRelationshipMapBean.getRelationshipBean()))) {
            relationFormQueryWhereClause = this.getRelationConditionFormQueryWhereClause(toFormBean, queryBo, formRelationshipMapBean);
        } else if (toFormBean != null) {
            relationFormQueryWhereClause = this.getMagicRelationConditionFormQueryWhereClause(toFormBean, queryBo, formRelationshipMapBean);
        }
        whereClauses.add(relationFormQueryWhereClause);
        FormQueryWhereClause querySqlClause = this.getRelationFormQueryWhereClause(toFormBean, toFormBean3, whereClauses, relationShowFields, formRelationshipMapBean);
        if (Strings.isNotBlank((String)querySqlClause.getAllSqlClause())) {
            querySqlClause.setAllSqlClause(querySqlClause.getAllSqlClause().replaceAll("<> null", "is not null"));
        }
        try {
            if (formRelationshipMapBean.getRelationshipBean().getRelationType() == FormRelationEnums.ViewSelectType.system.getKey()) {
                // empty if block
            }
            LOGGER.info((Object)("queryType:[relation master] " + formRelationshipMapBean.export4Log()));
            this.capDataListSqlHelpManager.selectDataList(flipInfo, querySqlClause.getAllSqlClause(), querySqlClause.getQueryParams());
        }
        catch (BusinessException e) {
            LOGGER.error((Object)("getFormRelationDataList is BusinessException. " + queryBo.toString()), (Throwable)e);
        }
        catch (SQLException e) {
            LOGGER.error((Object)("getFormRelationDataList is SQLException. " + queryBo.toString()), (Throwable)e);
        }
        this.dealPreRelationData(flipInfo.getData(), toFormBean != null ? toFormBean : toFormBean3);
        return flipInfo;
    }

    private void dealPreRelationData(List<Map<String, Object>> relationDatas, Object toFormBean) {
        if (CollectionUtils.isEmpty(relationDatas)) {
            LOGGER.warn((Object)"\u6ca1\u6709\u627e\u5230\u53ef\u5173\u8054\u7684\u76ee\u6807\u8868\u6570\u636e");
            return;
        }
        com.seeyon.cap4.form.bean.FormBean toFormBean4 = null;
        FormBean toFormBean3 = null;
        if (toFormBean instanceof com.seeyon.cap4.form.bean.FormBean) {
            toFormBean4 = (com.seeyon.cap4.form.bean.FormBean)toFormBean;
        } else {
            toFormBean3 = (FormBean)toFormBean;
        }
        for (Map<String, Object> relationData : relationDatas) {
            for (String key : relationData.keySet()) {
                FormFieldBean formFieldBean;
                Object value = relationData.get(key);
                if (toFormBean4 != null) {
                    formFieldBean = toFormBean4.getFieldBeanByName(key);
                    if (formFieldBean == null || value == null || !FormFieldComEnum.FLOWDEALOPITION.getKey().equals(formFieldBean.getInputType()) || !formFieldBean.getFormatType().contains(Enums.FlowDealOptionsType.signet.getKey())) continue;
                    relationData.put(key, FormUtil.replaceDealOptionSinget((String)((String)value)));
                    continue;
                }
                formFieldBean = toFormBean3.getFieldBeanByName(key);
                if (formFieldBean == null || value == null || !FormFieldComBean.FormFieldComEnum.FLOWDEALOPITION.getKey().equals(formFieldBean.getInputType()) || !formFieldBean.getFormatType().contains(Enums.FlowDealOptionsType.signet.getKey())) continue;
                relationData.put(key, FormUtil.replaceDealOptionSinget((String)((String)value)));
            }
        }
    }

    @Override
    public boolean hasRightForRelation(Long memberId, Long moduleId) throws BusinessException {
        if (memberId == null || moduleId == null) {
            return false;
        }
        boolean result = AccessControlBean.getInstance().isAccess(ApplicationCategoryEnum.form, moduleId.toString(), memberId.longValue());
        LOGGER.info((Object)("\u5173\u8054\u6743\u9650\u9a8c\u8bc1\uff1a" + memberId + ", " + moduleId + ", " + result));
        return result;
    }

    private void addRightForRelation(Long memberId, List<Long> moduleIds) {
        if (memberId != null && moduleIds != null) {
            for (Long id : moduleIds) {
                CAPFormUtil.addFormAccessControl(id, memberId);
            }
        }
    }

    @Override
    public Map<Long, Long> getMasterIdToModuleIdAndAddRight(int formType, Set<Long> masterIds, boolean addRight) throws BusinessException {
        Map<Long, Long> masterDataId2SummeryId = null;
        ArrayList<Long> list = new ArrayList<Long>();
        list.addAll(masterIds);
        if (!list.isEmpty() && Enums.FormType.processesForm.getKey() == formType) {
            masterDataId2SummeryId = this.collaborationApi.getColSummaryIdByFormRecordIds(list);
            if (masterDataId2SummeryId == null) {
                masterDataId2SummeryId = new HashMap();
            }
        } else {
            masterDataId2SummeryId = new HashMap();
            for (Long id : list) {
                masterDataId2SummeryId.put(id, id);
            }
        }
        if (addRight && masterDataId2SummeryId.size() > 0) {
            ArrayList<Long> moduleIds = new ArrayList<Long>();
            for (Long key : masterDataId2SummeryId.keySet()) {
                moduleIds.add(masterDataId2SummeryId.get(key));
            }
            Long memberId = AppContext.currentUserId();
            LOGGER.info((Object)("\u5173\u8054\u5904\u7406\u7a7f\u900f\u6743\u9650\uff1amemberId" + memberId + ", formType: " + formType + ", ids: " + ((Object)moduleIds).toString()));
            this.addRightForRelation(memberId, moduleIds);
        }
        return masterDataId2SummeryId;
    }

    private FormQueryWhereClause getRelationFormQueryWhereClause(com.seeyon.cap4.form.bean.FormBean formBean, FormBean formBean3, List<FormQueryWhereClause> whereClauses, List<String> relationShowFields, FormRelationshipMapBean formRelationshipMapBean) {
        FormQueryWhereClause allWhereClause = new FormQueryWhereClause();
        ArrayList<Object> queryParams = new ArrayList<Object>();
        String whereClauseStr = this.capDataListSqlHelpManager.getSQLWhere(whereClauses, queryParams);
        String masterTableName = formBean != null ? formBean.getMasterTableBean().getTableName() : formBean3.getMasterTableBean().getTableName();
        LinkedHashSet<String> fieldSet = new LinkedHashSet<String>();
        fieldSet.add(masterTableName + "." + Enums.MasterTableField.id);
        boolean showHasSubField = false;
        for (String fieldName : relationShowFields) {
            if (!fieldName.contains(".")) {
                FormFieldBean fieldBean;
                if (formBean != null) {
                    fieldBean = formBean.getFieldBeanByName(fieldName);
                    if (fieldBean != null) {
                        fieldName = fieldBean.getOwnerTableName() + "." + fieldName;
                        if (fieldBean.isSubField()) {
                            showHasSubField = true;
                        }
                    }
                } else {
                    fieldBean = formBean3.getFieldBeanByName(fieldName);
                    if (fieldBean != null) {
                        fieldName = fieldBean.getOwnerTableName() + "." + fieldName;
                        if (fieldBean.isSubField()) {
                            showHasSubField = true;
                        }
                    }
                }
            }
            fieldSet.add(fieldName);
        }
        String fieldNames = StringUtils.join(fieldSet, (String)",");
        StringBuilder sqlStartAtFrom = new StringBuilder();
        sqlStartAtFrom.append(" FROM ").append(masterTableName).append(" ");
        String sqlJoin = formBean != null ? this.capDataListSqlHelpManager.getSQLJoin(formBean, fieldNames, whereClauseStr, "LEFT") : this.capDataListSqlHelpManager.getSQLJoin(formBean3, fieldNames, whereClauseStr, "LEFT");
        sqlStartAtFrom.append(sqlJoin);
        if (Strings.isNotBlank((String)whereClauseStr.trim())) {
            sqlStartAtFrom.append(" WHERE ");
            whereClauseStr = FormUtil.changeAndAddNullWhereSql((String)whereClauseStr);
            sqlStartAtFrom.append(whereClauseStr);
        }
        allWhereClause.setWhereClause(whereClauseStr);
        StringBuilder sql = new StringBuilder(" SELECT ");
        if (!showHasSubField && whereClauseStr.contains("formson")) {
            sql.append(fieldNames).append(" FROM ").append(masterTableName).append(" WHERE ");
            String masterNameId = masterTableName + "." + Enums.MasterTableField.id.getKey();
            sql.append(masterNameId);
            sql.append(" IN (");
            sql.append(" SELECT ").append(masterNameId).append((CharSequence)sqlStartAtFrom);
            sql.append(" ) ");
        } else {
            sql.append(fieldNames).append((CharSequence)sqlStartAtFrom);
        }
        sql.append(" ORDER BY ");
        List sortFieldList = formRelationshipMapBean.getSortFieldList();
        if (CollectionUtils.isEmpty((Collection)sortFieldList)) {
            sql.append(masterTableName).append(".start_date ASC");
        } else {
            sql.append(this.getSortSql(sortFieldList));
        }
        if (JDBCAgent.isOracleRuntime()) {
            sql.append(",").append(masterTableName).append(".id ASC");
        }
        allWhereClause.setAllSqlClause(sql.toString());
        allWhereClause.setQueryParams(queryParams);
        return allWhereClause;
    }

    private String getSortSql(List<SimpleObjectBean> sortFieldList) {
        HashSet<String> sets = new HashSet<String>();
        for (SimpleObjectBean simpleObjectBean : sortFieldList) {
            sets.add(simpleObjectBean.getName() + " " + simpleObjectBean.getValue());
        }
        return StringUtils.join(sets, (String)",");
    }

    public FormQueryWhereClause getRelationConditionFormQueryWhereClause(com.seeyon.cap4.form.bean.FormBean formBean, CAP4RelationQueryParamsBO bo, FormRelationshipMapBean formRelationshipMapBean) throws BusinessException {
        Long conditionId = formRelationshipMapBean.getConditionFormulaId();
        FormQueryWhereClause whereClause = null;
        try {
            FormFormulaBean conditionFormFormulaBean;
            Long fromFormId = bo.getFromFormId();
            com.seeyon.cap4.form.bean.FormBean fromForm = this.cap4FormCacheManager.getForm(fromFormId);
            FormDataMasterBean fromData = this.cap4FormManager.getSessioMasterDataBean(bo.getFromDataId());
            String fromSubTableName = bo.getFromSubTableName();
            if (Strings.isBlank((String)fromSubTableName)) {
                FormFieldBean fromFormFieldBean = fromForm.getFieldBeanByName(bo.getFromRelationAttr());
                fromSubTableName = fromFormFieldBean.getOwnerTableName();
            }
            if (null != (conditionFormFormulaBean = this.cap4FormDataManager.changeFormFormulaBean(fromForm, fromData, bo.getFromRecordId(), fromSubTableName, conditionId))) {
                if (this.isManualRelationSelf(formRelationshipMapBean.getRelationshipBean())) {
                    Object[] o = FormUtil.preDealFlowCondition((com.seeyon.cap4.form.bean.FormBean)formBean, (Map)fromData.getRowData(), (FormFormulaBean)conditionFormFormulaBean, (boolean)true, (boolean)true);
                    List param = (List)o[1];
                    String sql = String.valueOf(o[0]);
                    String whereSb = "";
                    if (Strings.isNotEmpty((String)sql)) {
                        whereSb = "(" + sql + ")";
                    }
                    whereSb = FormUtil.changeAndAddNullWhereSql((String)whereSb);
                    whereSb = FormUtil.changeEnumFieldsCompare((com.seeyon.cap4.form.bean.FormBean)formBean, (String)whereSb);
                    whereSb = FormulaUtil.procReplaceNull((String)whereSb);
                    whereSb = whereSb + (Strings.isBlank((String)whereSb) ? "" : " and ");
                    whereSb = whereSb + " " + formBean.getMasterTableBean().getTableName() + "." + Enums.MasterTableField.id.getKey() + " <> " + fromData.getId() + " ";
                    LOGGER.info((Object)("\u624b\u52a8\u5173\u8054\u672c\u8868\u8fc7\u6ee4\u4e3b\u8868\u6570\u636esql where : " + whereSb));
                    LOGGER.info((Object)("\u624b\u52a8\u5173\u8054\u672c\u8868\u8fc7\u6ee4\u4e3b\u8868\u6570\u636esql param : " + param));
                    whereClause = new FormQueryWhereClause();
                    whereClause.setAllSqlClause(whereSb);
                    whereClause.setQueryParams(param);
                } else {
                    AppContext.putThreadContext((String)"isRelationCondition", (Object)true);
                    whereClause = conditionFormFormulaBean.getExecuteFormulaForWhereClauseSQL(formBean, true, true);
                    AppContext.removeThreadContext((String)"isRelationCondition");
                }
                String relationSql = whereClause.getAllSqlClause();
                if (!StringUtil.checkNull((String)relationSql)) {
                    for (FormTableBean table : formBean.getTableList()) {
                        String tablePrefix = "b" + Functions.substringAfter((String)table.getTableName(), (String)"_");
                        if (relationSql.indexOf(tablePrefix) == -1) continue;
                        relationSql = relationSql.replace(tablePrefix, table.getTableName());
                    }
                }
                whereClause.setAllSqlClause(relationSql);
            } else if (this.isManualRelationSelf(formRelationshipMapBean.getRelationshipBean())) {
                whereClause = new FormQueryWhereClause();
                String whereSb = " " + formBean.getMasterTableBean().getTableName() + "." + Enums.MasterTableField.id.getKey() + " <> " + fromData.getId() + " ";
                whereClause.setAllSqlClause(whereSb);
            }
        }
        catch (Exception e) {
            LOGGER.info((Object)"", (Throwable)e);
            throw new BusinessException((Throwable)e);
        }
        return whereClause;
    }

    public FormQueryWhereClause getMagicRelationConditionFormQueryWhereClause(com.seeyon.cap4.form.bean.FormBean formBean, CAP4RelationQueryParamsBO bo, FormRelationshipMapBean formRelationshipMapBean) throws BusinessException {
        try {
            FormFieldBean fromFormFieldBean;
            Long fromFormId = bo.getFromFormId();
            com.seeyon.cap4.form.bean.FormBean fromForm = this.cap4FormCacheManager.getForm(fromFormId);
            FormDataMasterBean fromData = this.cap4FormManager.getSessioMasterDataBean(bo.getFromDataId());
            String fromSubTableName = bo.getFromSubTableName();
            if (Strings.isBlank((String)fromSubTableName) && (fromFormFieldBean = fromForm.getFieldBeanByName(bo.getFromRelationAttr())) != null) {
                fromSubTableName = fromFormFieldBean.getOwnerTableName();
            }
            FormFormulaBean scopeSet = (FormFormulaBean)formRelationshipMapBean.getParams("scopeSet");
            FormFormulaBean conditionFormFormulaBean = formRelationshipMapBean.getConditionFormula();
            if (formRelationshipMapBean.getRelationshipBean().getRelationType() == 2) {
                conditionFormFormulaBean = scopeSet;
            } else if (conditionFormFormulaBean != null && scopeSet != null) {
                FormFormulaBean filterFormula = new FormFormulaBean(fromForm);
                filterFormula.setIdIfNew();
                filterFormula.loadFromFormula("(" + scopeSet.getFormulaForDisplay() + ") and (" + conditionFormFormulaBean.getFormulaForDisplay() + ")");
                conditionFormFormulaBean = filterFormula;
            } else if (conditionFormFormulaBean == null) {
                conditionFormFormulaBean = scopeSet;
            }
            conditionFormFormulaBean = this.cap4FormDataManager.changeFormFormulaBean(fromForm, fromData, bo.getFromRecordId(), fromSubTableName, conditionFormFormulaBean);
            if (null != conditionFormFormulaBean) {
                AppContext.putThreadContext((String)"isRelationCondition", (Object)true);
                FormQueryWhereClause whereClause = conditionFormFormulaBean.getExecuteFormulaForWhereClauseSQL(formBean, true, true);
                AppContext.removeThreadContext((String)"isRelationCondition");
                String relationSql = whereClause.getAllSqlClause();
                if (Strings.isNotBlank((String)relationSql)) {
                    for (FormTableBean table : formBean.getTableList()) {
                        String tablePrefix = "b" + Functions.substringAfter((String)table.getTableName(), (String)"_");
                        if (relationSql.indexOf(tablePrefix) == -1) continue;
                        relationSql = relationSql.replace(tablePrefix, table.getTableName());
                    }
                    Map params = formRelationshipMapBean.getParams();
                    String businessId = ParamUtil.getString((Map)params, (String)"businessId", (String)"");
                    String versionId = ParamUtil.getString((Map)params, (String)"versionId", (String)"");
                    String methodName = ParamUtil.getString((Map)params, (String)"methodName", (String)"");
                    relationSql = MagicHandleFormUtils.replaceFilterConditionFormRelation(businessId, versionId, methodName, relationSql);
                }
                whereClause.setAllSqlClause(relationSql);
                return whereClause;
            }
        }
        catch (Exception e) {
            LOGGER.info((Object)"", (Throwable)e);
            throw new BusinessException((Throwable)e);
        }
        return null;
    }

    @Override
    public Map<String, List<FormDataSubBean>> getRelationAutoSummaryFromSelf(com.seeyon.cap4.form.bean.FormBean formBean, FormDataMasterBean formDataMasterBean, FormAuthViewBean formAuthViewBean, FormRelationshipMapBean formRelationshipMapBean, Map<String, Set<String>> tableName2DeleteIds) throws BusinessException {
        HashMap<String, List<FormDataSubBean>> resultMap = new HashMap<String, List<FormDataSubBean>>();
        Map collectionMap = formRelationshipMapBean.getCollectMapping();
        Iterator iterator = collectionMap.keySet().iterator();
        while (iterator.hasNext()) {
            List<FormDataSubBean> newSubDataBeans = new LinkedList<FormDataSubBean>();
            String fromTableName = (String)iterator.next();
            String toTableName = (String)collectionMap.get(fromTableName);
            FormTableBean subTableBean = formBean.getTableByTableName(toTableName);
            List datas = formDataMasterBean.getSubData(fromTableName);
            Map<String, List<FormDataSubBean>> relationDatas = this.groupAutoSummaryDatasBySelf(formBean, datas, formRelationshipMapBean);
            if (!relationDatas.isEmpty()) {
                for (Map.Entry<String, List<FormDataSubBean>> et : relationDatas.entrySet()) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    List<FormDataSubBean> v = et.getValue();
                    FormDataSubBean dataSubBean = v.get(0);
                    Map formulaValueMap = formDataMasterBean.getFormulaMap(formBean, fromTableName, v, "formulaType_number");
                    List relationFields = formRelationshipMapBean.getRelationFieldMap();
                    FormDataSubBean subDataBean = new FormDataSubBean(subTableBean, formDataMasterBean, new boolean[]{true});
                    for (Map fieldMap : relationFields) {
                        String fillBackFieldName = "";
                        for (String key : fieldMap.keySet()) {
                            if (key.indexOf("field") != 0) continue;
                            fillBackFieldName = key;
                            break;
                        }
                        if (Strings.isBlank((String)fillBackFieldName)) continue;
                        FormFieldBean fillBackFieldBean = formBean.getFieldBeanByName(fillBackFieldName);
                        Object value = null;
                        if (fieldMap.get("formulaId") != null) {
                            FormFormulaBean formulaBean;
                            Long formulaId = Long.valueOf((String)fieldMap.get("formulaId"));
                            FormFormulaBean formFormulaBean = formulaBean = formRelationshipMapBean.getCollectFormulaBean() == null ? null : (FormFormulaBean)formRelationshipMapBean.getCollectFormulaBean().get(formulaId);
                            if (formulaBean == null) {
                                LOGGER.error((Object)("\u5173\u8054\u81ea\u52a8\u6c47\u603b/\u672c\u8868\uff0c\u8bbe\u7f6e\u8ba1\u7b97\u5f0f\u65e0\u6cd5\u627e\u5230\u3002formulaId: " + formulaId + " , fieldName: " + fillBackFieldName + " , shipMapId: " + formRelationshipMapBean.getId()));
                            } else {
                                String forumlaStr = formulaBean.getExecuteFormulaForGroove();
                                try {
                                    value = FormulaUtil.doResult((String)forumlaStr, (Map)formulaValueMap);
                                    String formulaType = FormulaEnums.getFormulaTypeByFieldType((String)fillBackFieldBean.getFieldType());
                                    value = FormUtil.formatCalcValue((FormFieldBean)fillBackFieldBean, (Object)value, (String)formulaType);
                                }
                                catch (BusinessException e) {
                                    LOGGER.error((Object)("\u5173\u8054\u81ea\u52a8\u6c47\u603b/\u672c\u8868\uff0c\u6570\u636e\uff1a" + formDataMasterBean.getId() + " \u5b57\u6bb5\uff1a" + fillBackFieldBean.getName() + fillBackFieldBean.getDisplay() + " forumlaStr:" + forumlaStr), (Throwable)e);
                                }
                            }
                        } else {
                            String dataFromFieldName = (String)fieldMap.get(fillBackFieldName);
                            FormFieldBean dataFromFieldBean = formBean.getFieldBeanByName(dataFromFieldName);
                            if (dataFromFieldBean == null) continue;
                            value = dataFromFieldBean.isMasterField() ? formDataMasterBean.getFieldValue(dataFromFieldName) : dataSubBean.getFieldValue(dataFromFieldName);
                        }
                        formDataMasterBean.addFieldChanges4Calc(fillBackFieldBean, value, subDataBean);
                        map.put(fillBackFieldName, value);
                    }
                    subDataBean.setFormmainId(formDataMasterBean.getId().longValue());
                    this.calcDataBeanDefaultVal((FormDataBean)subDataBean, subTableBean, formAuthViewBean);
                    subDataBean.addFieldValue(map);
                    newSubDataBeans.add(subDataBean);
                }
            } else {
                FormDataSubBean subDataBean = new FormDataSubBean(subTableBean, formDataMasterBean, new boolean[]{true});
                subDataBean.setFormmainId(formDataMasterBean.getId().longValue());
                this.calcDataBeanDefaultVal((FormDataBean)subDataBean, subTableBean, formAuthViewBean);
                newSubDataBeans.add(subDataBean);
            }
            newSubDataBeans = this.sortDataBySortFieldList(formBean, newSubDataBeans, formRelationshipMapBean);
            List oldDataSubBeans = formDataMasterBean.getSubData(toTableName);
            Set<String> deleteIds = tableName2DeleteIds.get(toTableName);
            if (deleteIds == null) {
                deleteIds = new HashSet<String>();
                tableName2DeleteIds.put(toTableName, deleteIds);
            }
            for (FormDataSubBean subBean : oldDataSubBeans) {
                deleteIds.add(String.valueOf(subBean.getId()));
            }
            formDataMasterBean.setSubData(toTableName, newSubDataBeans, true);
            resultMap.put(toTableName, newSubDataBeans);
            this.removeSessionRelationRecordsByDelete(formDataMasterBean, deleteIds);
            CAPFormDataLogUtil.recordRelation(formRelationshipMapBean, formDataMasterBean.getId(), toTableName);
        }
        return resultMap;
    }

    private void removeSessionRelationRecordsByDelete(FormDataMasterBean formDataMasterBean, Set<String> deleteSubIds) {
        if (CollectionUtils.isEmpty(deleteSubIds) || CollectionUtils.isEmpty((Collection)formDataMasterBean.getRelationRecords())) {
            return;
        }
        Iterator iterator = formDataMasterBean.getRelationRecords().iterator();
        while (iterator.hasNext()) {
            CAPFormRelationRecord relationRecord = (CAPFormRelationRecord)iterator.next();
            if (relationRecord.getFromSubdataId() == null || !deleteSubIds.contains(String.valueOf(relationRecord.getFromSubdataId()))) continue;
            if (formDataMasterBean.getRelationRecordMap() != null) {
                formDataMasterBean.getRelationRecordMap().remove(relationRecord.getFieldName() + "_" + relationRecord.getFromSubdataId());
            }
            LOGGER.info((Object)("\u5220\u9664\u5173\u8054\u5173\u7cfb\u8bb0\u5f55(session),cause by AutoIncreaseRow or AutoSummary," + relationRecord.exportToMap()));
            iterator.remove();
        }
    }

    @Override
    public Map<String, List<FormDataSubBean>> getRelationAutoIncreaseRow(com.seeyon.cap4.form.bean.FormBean formBean, FormDataMasterBean formDataMasterBean, FormAuthViewBean formAuthViewBean, FormRelationshipMapBean formRelationshipMapBean, Map<String, Set<String>> tableName2DeleteIds, Set<String> clearSubReferences) throws BusinessException {
        FlipInfo flipInfo = new FlipInfo(1, 500);
        CAP4RelationQueryParamsBO cap4RelationQueryParamsBO = new CAP4RelationQueryParamsBO();
        cap4RelationQueryParamsBO.setFromFormId(formBean.getId());
        cap4RelationQueryParamsBO.setFromDataId(formDataMasterBean.getId());
        Map formRelationFieldMap = formRelationshipMapBean.getFormRelationFieldMap();
        Iterator it1 = formRelationFieldMap.keySet().iterator();
        String firstFieldName = (String)it1.next();
        String fromSubTableName = formBean.getFieldBeanByName(firstFieldName).getOwnerTableName();
        cap4RelationQueryParamsBO.setFromSubTableName(fromSubTableName);
        cap4RelationQueryParamsBO.setFromRelationAttr(firstFieldName);
        cap4RelationQueryParamsBO.setFormRelationshipMapBean(formRelationshipMapBean);
        if (this.isMagicManualRelation(formRelationshipMapBean.getRelationshipBean())) {
            ICAP4MagicExecuteManager cap4MagicExecuteManager = (ICAP4MagicExecuteManager)AppContext.getBean((String)"cap4MagicExecuteManager");
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("fromFormId", formBean.getId());
            params.put("fromDataId", formDataMasterBean.getId());
            params.put("fromRelationAttr", firstFieldName);
            params.put("fromSubTableName", fromSubTableName);
            cap4MagicExecuteManager.getRelationAutoIncreaseRow(flipInfo, params, formRelationshipMapBean.getRelationshipBean(), formRelationshipMapBean);
        } else {
            this.getFormRelationDataList(flipInfo, cap4RelationQueryParamsBO, null);
        }
        List relationDatas = flipInfo.getData();
        FormTableBean subTableBean = formBean.getTableByTableName(fromSubTableName);
        LinkedList<FormDataSubBean> newSubDataBeans = new LinkedList<FormDataSubBean>();
        if (!relationDatas.isEmpty()) {
            for (Object relationData : relationDatas) {
                Iterator it = formRelationFieldMap.keySet().iterator();
                HashMap data = new HashMap();
                Map tempRelationData = (Map)relationData;
                FormDataSubBean subDataBean = new FormDataSubBean(subTableBean, formDataMasterBean, new boolean[]{true});
                while (it.hasNext()) {
                    String fromFieldName = (String)it.next();
                    String toFieldName = (String)formRelationFieldMap.get(fromFieldName);
                    Object value = tempRelationData.get(toFieldName);
                    FormFieldBean fromFieldBean = formBean.getFieldBeanByName(fromFieldName);
                    if (fromFieldBean.isAttachment() || fromFieldBean.isMap()) {
                        value = this.copySysRelationLBSAndAttachment(formBean, formDataMasterBean, fromFieldBean, subDataBean.getId(), tempRelationData.get(toFieldName));
                    }
                    data.put(fromFieldName, value);
                    formDataMasterBean.addFieldChanges4Calc(fromFieldBean, value, subDataBean);
                }
                subDataBean.setFormmainId(formDataMasterBean.getId().longValue());
                this.calcDataBeanDefaultVal((FormDataBean)subDataBean, subTableBean, formAuthViewBean);
                subDataBean.addFieldValue(data);
                newSubDataBeans.add(subDataBean);
            }
        } else {
            FormDataSubBean subDataBean = new FormDataSubBean(subTableBean, formDataMasterBean, new boolean[]{true});
            subDataBean.setFormmainId(formDataMasterBean.getId().longValue());
            this.calcDataBeanDefaultVal((FormDataBean)subDataBean, subTableBean, formAuthViewBean);
            newSubDataBeans.add(subDataBean);
        }
        HashMap<String, List<FormDataSubBean>> result = new HashMap<String, List<FormDataSubBean>>();
        if (newSubDataBeans.size() > 0) {
            List oldDataSubBeans = (List)formDataMasterBean.getSubTables().get(fromSubTableName);
            Set<String> ids = tableName2DeleteIds.get(fromSubTableName);
            if (ids == null) {
                ids = new HashSet<String>();
            }
            List fieldBeans = formBean.getTableByTableName(fromSubTableName).getFields();
            HashSet<String> subReferences = new HashSet<String>();
            for (FormDataSubBean formDataSubBean : oldDataSubBeans) {
                for (FormFieldBean fieldBean : fieldBeans) {
                    if (!fieldBean.isAttachment() || formDataSubBean.getFieldValue(fieldBean.getName()) == null) continue;
                    subReferences.add(String.valueOf(formDataSubBean.getFieldValue(fieldBean.getName())));
                }
                ids.add(String.valueOf(formDataSubBean.getId()));
            }
            tableName2DeleteIds.put(fromSubTableName, ids);
            result.put(fromSubTableName, newSubDataBeans);
            formDataMasterBean.setSubData(fromSubTableName, newSubDataBeans, true);
            this.removeSessionRelationRecordsByDelete(formDataMasterBean, ids);
            CAPFormDataLogUtil.recordRelation(formRelationshipMapBean, formDataMasterBean.getId(), fromSubTableName);
            CAPAttachmentUtil.removeSessionAttachmentsBySubReferences(formDataMasterBean, subReferences);
            if (clearSubReferences != null && Strings.isNotEmpty(subReferences)) {
                clearSubReferences.addAll(subReferences);
            }
        }
        return result;
    }

    @Override
    public void addRelationThroughUnFlowRight(FormRelationshipMapBean formRelationshipMapBean, String throughType) {
        com.seeyon.cap4.form.bean.FormBean toFormBean;
        boolean isThrough;
        boolean bl = "list".equals(throughType) ? formRelationshipMapBean.getListThrough() == 1 : (isThrough = formRelationshipMapBean.getViewThrough() == 1);
        if (isThrough && (toFormBean = this.cap4FormCacheManager.getForm(formRelationshipMapBean.getRelationshipBean().getTargetFormId())) != null && !toFormBean.isFlowForm()) {
            String phoneRight;
            String pcRight;
            String string = pcRight = "list".equals(throughType) ? formRelationshipMapBean.getListPcView() : formRelationshipMapBean.getPcView();
            if (Strings.isNotBlank((String)pcRight)) {
                this.capFormManager.addRight(pcRight);
            }
            String string2 = phoneRight = "list".equals(throughType) ? formRelationshipMapBean.getListPhoneView() : formRelationshipMapBean.getPhoneView();
            if (Strings.isNotBlank((String)phoneRight)) {
                this.capFormManager.addRight(phoneRight);
            }
        }
    }

    private void calcDataBeanDefaultVal(FormDataBean formDataBean, FormTableBean formTableBean, FormAuthViewBean formAuthViewBean) throws BusinessException {
        for (FormFieldBean formFieldBean : formTableBean.getFields()) {
            this.cap4FormDataManager.procFieldDefaultVal(formDataBean, formAuthViewBean, false, formFieldBean);
        }
    }

    private Map<String, List<FormDataSubBean>> groupAutoSummaryDatasBySelf(com.seeyon.cap4.form.bean.FormBean formBean, List<FormDataSubBean> subBeans, FormRelationshipMapBean formRelationshipMapBean) throws BusinessException {
        LinkedHashMap<String, List<FormDataSubBean>> map = new LinkedHashMap<String, List<FormDataSubBean>>();
        List relationFields = formRelationshipMapBean.getRelationFieldMap();
        LinkedHashSet<String> keySet = new LinkedHashSet<String>();
        for (Map ele : relationFields) {
            keySet.addAll(ele.values());
        }
        for (FormDataSubBean subBean : subBeans) {
            String key = this.getAutoSummaryKeyBySelf(formBean, subBean, keySet);
            Strings.addToMap(map, (Object)key, (Object)subBean);
        }
        return map;
    }

    private String getAutoSummaryKeyBySelf(com.seeyon.cap4.form.bean.FormBean formBean, FormDataSubBean subBean, Collection<String> keySet) throws BusinessException {
        if (Strings.isNotEmpty(keySet)) {
            StringBuilder sb = new StringBuilder();
            for (String fieldName : keySet) {
                FormFieldBean fieldBean;
                if (fieldName.indexOf("field") != 0 || (fieldBean = formBean.getFieldBeanByName(fieldName)) == null) continue;
                Object value = subBean.getFieldValue(fieldName);
                sb.append(fieldBean.getDbValue(value)).append("_");
            }
            return sb.toString();
        }
        return "";
    }

    private List<FormDataSubBean> sortDataBySortFieldList(com.seeyon.cap4.form.bean.FormBean fb, List<FormDataSubBean> toDataSubBeans, FormRelationshipMapBean formRelationshipMapBean) {
        if (toDataSubBeans == null || toDataSubBeans.size() <= 1) {
            return toDataSubBeans;
        }
        if (Strings.isNotEmpty((Collection)formRelationshipMapBean.getSortFieldList())) {
            final List sortFieldList = formRelationshipMapBean.getSortFieldList();
            final com.seeyon.cap4.form.bean.FormBean formBean = fb;
            Collections.sort(toDataSubBeans, new Comparator<FormDataSubBean>(){

                @Override
                public int compare(FormDataSubBean o1, FormDataSubBean o2) {
                    int flag = 0;
                    for (SimpleObjectBean sob : sortFieldList) {
                        FormFieldBean formFieldBean = formBean.getFieldBeanByName(sob.getName().substring(sob.getName().indexOf(".") + 1));
                        String sortBy = sob.getValue();
                        Object value1 = o1.getFieldValue(formFieldBean.getName());
                        Object value2 = o2.getFieldValue(formFieldBean.getName());
                        try {
                            flag = SimpleObjectBean.OrderByValue.Asc.getKey().equals(sortBy) ? CAP4FormRelationActionManagerImpl.this.getAutoSummaryBySelfSort(value1, value2, formFieldBean) : CAP4FormRelationActionManagerImpl.this.getAutoSummaryBySelfSort(value2, value1, formFieldBean);
                        }
                        catch (BusinessException e) {
                            LOGGER.error((Object)("getAutoSummaryBySelfSort error " + value1 + " " + value2 + " " + formFieldBean.getName() + " " + e.getMessage()), (Throwable)e);
                            flag = 0;
                        }
                        if (flag == 0) continue;
                        return flag;
                    }
                    return flag;
                }
            });
        }
        return toDataSubBeans;
    }

    private int getAutoSummaryBySelfSort(Object value1, Object value2, FormFieldBean formFieldBean) throws BusinessException {
        int flag = 0;
        if (value1 == null && value2 == null) {
            return flag;
        }
        flag = this.getSortNullFlag(value1, value2);
        if (flag == 0) {
            if (value1.equals(value2)) {
                flag = 0;
            } else if (formFieldBean.isEnumField()) {
                CtpEnumItem ctpEnumItem2;
                CtpEnumItem ctpEnumItem1 = this.getEnumItem(formFieldBean, String.valueOf(value1));
                flag = this.getSortNullFlag(ctpEnumItem1, ctpEnumItem2 = this.getEnumItem(formFieldBean, String.valueOf(value2)));
                flag = flag != 0 ? flag : ctpEnumItem1.getSort().compareTo(ctpEnumItem2.getSort());
            } else if (FormFieldComEnum.EXTEND_MEMBER.getKey().equals(formFieldBean.getInputType())) {
                V3xOrgMember member1 = StringUtil.checkNull((String)String.valueOf(value1)) ? null : this.orgManager.getMemberById(Long.valueOf(String.valueOf(value1)));
                V3xOrgMember member2 = StringUtil.checkNull((String)String.valueOf(value2)) ? null : this.orgManager.getMemberById(Long.valueOf(String.valueOf(value2)));
                flag = this.getSortNullFlag(member1, member2);
                flag = flag != 0 ? flag : member1.getSortId().compareTo(member2.getSortId());
            } else if (FormFieldComEnum.EXTEND_DEPARTMENT.getKey().equals(formFieldBean.getInputType())) {
                V3xOrgDepartment department1 = StringUtil.checkNull((String)String.valueOf(value1)) ? null : this.orgManager.getDepartmentById(Long.valueOf(String.valueOf(value1)));
                V3xOrgDepartment department2 = StringUtil.checkNull((String)String.valueOf(value1)) ? null : this.orgManager.getDepartmentById(Long.valueOf(String.valueOf(value2)));
                flag = this.getSortNullFlag(department1, department2);
                flag = flag != 0 ? flag : department1.getSortId().compareTo(department2.getSortId());
            } else if (FormFieldComEnum.EXTEND_POST.getKey().equals(formFieldBean.getInputType())) {
                V3xOrgPost post1 = StringUtil.checkNull((String)String.valueOf(value1)) ? null : this.orgManager.getPostById(Long.valueOf(String.valueOf(value1)));
                V3xOrgPost post2 = StringUtil.checkNull((String)String.valueOf(value1)) ? null : this.orgManager.getPostById(Long.valueOf(String.valueOf(value2)));
                flag = this.getSortNullFlag(post1, post2);
                flag = flag != 0 ? flag : post1.getSortId().compareTo(post2.getSortId());
            } else if (FormFieldComEnum.EXTEND_ACCOUNT.getKey().equals(formFieldBean.getInputType())) {
                V3xOrgAccount account1 = StringUtil.checkNull((String)String.valueOf(value1)) ? null : this.orgManager.getAccountById(Long.valueOf(String.valueOf(value1)));
                V3xOrgAccount account2 = StringUtil.checkNull((String)String.valueOf(value1)) ? null : this.orgManager.getAccountById(Long.valueOf(String.valueOf(value2)));
                flag = this.getSortNullFlag(account1, account2);
                flag = flag != 0 ? flag : account1.getSortId().compareTo(account2.getSortId());
            } else if (FormFieldComEnum.LINE_NUMBER.getKey().equals(formFieldBean.getInputType())) {
                BigDecimal bd1 = new BigDecimal(StringUtil.checkNull((String)String.valueOf(value1)) ? "0" : String.valueOf(value1));
                BigDecimal bd2 = new BigDecimal(StringUtil.checkNull((String)String.valueOf(value2)) ? "0" : String.valueOf(value2));
                flag = bd1.compareTo(bd2);
            } else {
                String fieldTypeStr = formFieldBean.getFieldType();
                if (Strings.isNotBlank((String)fieldTypeStr)) {
                    Enums.FieldType fieldType = Enums.FieldType.getEnumByKey((String)fieldTypeStr.toUpperCase());
                    switch (fieldType) {
                        case VARCHAR: {
                            Collator collatorInstance = Collator.getInstance(Locale.CHINA);
                            flag = collatorInstance.compare(value1, value2);
                            break;
                        }
                        case DECIMAL: {
                            BigDecimal bd1 = new BigDecimal(StringUtil.checkNull((String)String.valueOf(value1)) ? "0" : String.valueOf(value1));
                            BigDecimal bd2 = new BigDecimal(StringUtil.checkNull((String)String.valueOf(value2)) ? "0" : String.valueOf(value2));
                            flag = bd1.compareTo(bd2);
                            break;
                        }
                        case TIMESTAMP: 
                        case DATETIME: {
                            Date date1 = Enums.FieldType.TIMESTAMP.getKey().equalsIgnoreCase(fieldTypeStr) ? this.getTimeStampValue(value1) : this.getDateValue(value1);
                            Date date2 = Enums.FieldType.TIMESTAMP.getKey().equalsIgnoreCase(fieldTypeStr) ? this.getTimeStampValue(value2) : this.getDateValue(value2);
                            flag = this.getSortNullFlag(date1, date2);
                            flag = flag != 0 ? flag : date1.compareTo(date2);
                            break;
                        }
                    }
                }
            }
        }
        return flag;
    }

    private int getSortNullFlag(Object o1, Object o2) {
        int flag = 0;
        if (o1 == null) {
            flag = -1;
        } else if (o2 == null) {
            flag = 1;
        }
        if (o1 == null && o2 == null) {
            LOGGER.error((Object)"getSortNullFlag check null , both null , just data convert error on this operation");
        }
        return flag;
    }

    private CtpEnumItem getEnumItem(FormFieldBean fieldBean, String valueStr) throws BusinessException {
        CtpEnumItem ctpEnumBean = null;
        if (!(StringUtil.checkNull((String)valueStr) || "0.0".equals(valueStr) || "0".equals(valueStr))) {
            try {
                Long itemId = Long.parseLong(valueStr);
                ctpEnumBean = FormFieldUtil.getItemByEnumId((String)fieldBean.getName(), (Long)itemId, (String)"", (int)-1);
            }
            catch (NumberFormatException e) {
                LOGGER.error((Object)("getEnumItem format excetion " + e.getMessage()), (Throwable)e);
            }
        }
        return ctpEnumBean;
    }

    private Date getDateValue(Object value) {
        String valueStr;
        Date date = null;
        String string = valueStr = value == null ? null : String.valueOf(value);
        if (Strings.isNotBlank((String)valueStr)) {
            if (value instanceof Date) {
                date = (Date)value;
            } else {
                if (valueStr.length() == 10) {
                    valueStr = valueStr + " 00:00:00";
                }
                date = Datetimes.parseNoTimeZone((String)valueStr, (String)"yyyy-MM-dd HH:mm");
            }
        }
        return date;
    }

    private Date getTimeStampValue(Object value) {
        String valueStr;
        Date date = null;
        String string = valueStr = value == null ? null : String.valueOf(value);
        if (Strings.isNotBlank((String)valueStr)) {
            date = value instanceof Date ? (Date)value : Datetimes.parseNoTimeZone((String)valueStr, (String)"yyyy-MM-dd");
        }
        return date;
    }

    public void setCap4FormDataManager(CAP4FormDataManager cap4FormDataManager) {
        this.cap4FormDataManager = cap4FormDataManager;
    }

    public void setCap4FormRelationRecordDAO(CAP4FormRelationRecordDAO cap4FormRelationRecordDAO) {
        this.cap4FormRelationRecordDAO = cap4FormRelationRecordDAO;
    }

    public void setCap4FormDataDAO(CAP4FormDataDAO cap4FormDataDAO) {
        this.cap4FormDataDAO = cap4FormDataDAO;
    }

    public void setCap4FormManager(CAP4FormManager cap4FormManager) {
        this.cap4FormManager = cap4FormManager;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public void setCollaborationApi(CollaborationApi collaborationApi) {
        this.collaborationApi = collaborationApi;
    }

    public void setFormCacheManager(FormCacheManager formCacheManager) {
        this.formCacheManager = formCacheManager;
    }

    public void setOrgManager(OrgManager orgManager) {
        this.orgManager = orgManager;
    }

    public void setCapFormManager(CAPFormManager capFormManager) {
        this.capFormManager = capFormManager;
    }

    public void setCapDataListSqlHelpManager(CAPDataListSqlHelpManager capDataListSqlHelpManager) {
        this.capDataListSqlHelpManager = capDataListSqlHelpManager;
    }
}

