/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.engin.trigger;

import com.seeyon.cap4.form.modules.engin.trigger.CAP4FormTriggerEventDAO;
import com.seeyon.cap4.form.po.CAPFormTriggerEvent;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.util.DBAgent;
import com.seeyon.ctp.util.FlipInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class CAP4FormTriggerEventDAOImpl
implements CAP4FormTriggerEventDAO {
    @Override
    public void save(CAPFormTriggerEvent event) throws BusinessException {
        event.setModifyTime(new Date());
        DBAgent.save((Object)event);
        DBAgent.commit();
    }

    @Override
    public void update(List<CAPFormTriggerEvent> eventList) throws BusinessException {
        ArrayList<CAPFormTriggerEvent> newEventList = new ArrayList<CAPFormTriggerEvent>();
        for (CAPFormTriggerEvent event : eventList) {
            event.setModifyTime(new Date());
            newEventList.add(event);
        }
        DBAgent.mergeAll(newEventList);
    }

    @Override
    public void updateState(Long eventId, int state) throws BusinessException {
        String sql = "UPDATE CAPFormTriggerEvent SET state = :state,modifyTime = :modifyTime WHERE id = :id";
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("state", Integer.valueOf(state));
        map.put("id", eventId);
        map.put("modifyTime", new Date());
        DBAgent.bulkUpdate((String)sql, map);
    }

    @Override
    public void updateState(int oldState, int newState) throws BusinessException {
        String sql = "UPDATE CAPFormTriggerEvent SET state = :newState,modifyTime = :modifyTime WHERE state = :oldState";
        HashMap<String, Comparable<Integer>> map = new HashMap<String, Comparable<Integer>>();
        map.put("newState", Integer.valueOf(newState));
        map.put("oldState", Integer.valueOf(oldState));
        map.put("modifyTime", new Date());
        DBAgent.bulkUpdate((String)sql, map);
    }

    @Override
    public List<CAPFormTriggerEvent> getRecords(int state) throws BusinessException {
        FlipInfo fi = new FlipInfo();
        fi.setSize(900);
        ArrayList<CAPFormTriggerEvent> list = new ArrayList<CAPFormTriggerEvent>();
        fi.setTotal(this.countByState(state));
        int page = fi.getPages();
        String sql = "FROM CAPFormTriggerEvent WHERE state = :state ORDER BY createTime";
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("state", state);
        for (int i = 1; i <= page; ++i) {
            fi.setPage(i);
            DBAgent.find((String)sql, map, (FlipInfo)fi);
            list.addAll(fi.getData());
        }
        return list;
    }

    @Override
    public CAPFormTriggerEvent getRecordById(long id) throws BusinessException {
        String sql = "FROM CAPFormTriggerEvent WHERE id = :id";
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("id", id);
        return (CAPFormTriggerEvent)DBAgent.find((String)sql, map).get(0);
    }

    @Override
    public List<CAPFormTriggerEvent> getRecords(FlipInfo fi, int state) throws BusinessException {
        String sql = "FROM CAPFormTriggerEvent WHERE state = :state ORDER BY createTime";
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("state", state);
        DBAgent.find((String)sql, map, (FlipInfo)fi);
        return fi.getData();
    }

    @Override
    public int countByState(int state) throws BusinessException {
        String sql = "select count(id) from CAPFormTriggerEvent WHERE state = :state";
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("state", state);
        return DBAgent.count((String)sql, map);
    }

    @Override
    public void delete(CAPFormTriggerEvent event) {
        DBAgent.delete((Object)event);
    }
}

