/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.engin.trigger;

import com.seeyon.cap4.form.bean.FormAuthViewBean;
import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormDataMasterBean;
import com.seeyon.cap4.form.bean.FormDataSubBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormFormulaBean;
import com.seeyon.cap4.form.bean.FormTableBean;
import com.seeyon.cap4.form.bean.FormTriggerActionBean;
import com.seeyon.cap4.form.bean.FormTriggerBean;
import com.seeyon.cap4.form.bean.FormTriggerConditionBean;
import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.cap4.form.modules.business.BusinessManager;
import com.seeyon.cap4.form.modules.engin.base.formData.CAP4FormDataDAO;
import com.seeyon.cap4.form.modules.engin.base.formData.CAP4FormDataManager;
import com.seeyon.cap4.form.modules.engin.base.formData.CAPFormDataCacheManagerImpl;
import com.seeyon.cap4.form.modules.engin.formula.FormulaUtil;
import com.seeyon.cap4.form.modules.engin.trigger.CAP4FormTriggerFireEvent;
import com.seeyon.cap4.form.modules.engin.trigger.CAP4FormTriggerManager;
import com.seeyon.cap4.form.modules.engin.trigger.CAP4FormTriggerRecordDAO;
import com.seeyon.cap4.form.modules.engin.trigger.FormTriggerActionContext;
import com.seeyon.cap4.form.modules.engin.trigger.FormTriggerUtil;
import com.seeyon.cap4.form.modules.engin.trigger.TriggerActionContext;
import com.seeyon.cap4.form.modules.log.CapRunningLogManager;
import com.seeyon.cap4.form.po.CAP4FormTriggerRecord;
import com.seeyon.cap4.form.po.CAPFormTriggerEvent;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.service.CAP4FormManager;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.form.vo.FormDataStateResultVO;
import com.seeyon.cap4.form.vo.FormTriggerQuartzDataVo;
import com.seeyon.cap4.task.TaskExecuteManager;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.ModuleType;
import com.seeyon.ctp.common.authenticate.domain.User;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.affair.CtpAffair;
import com.seeyon.ctp.common.quartz.QuartzHolder;
import com.seeyon.ctp.common.quartz.QuartzListener;
import com.seeyon.ctp.event.Event;
import com.seeyon.ctp.event.EventDispatcher;
import com.seeyon.ctp.event.EventTriggerMode;
import com.seeyon.ctp.form.modules.trigger.FormTriggerEventObject;
import com.seeyon.ctp.form.modules.trigger.FormWithHoldingDAO;
import com.seeyon.ctp.form.po.FormWithholding;
import com.seeyon.ctp.thread.ThreadInfoHolder;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.Datetimes;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.StringUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.annotation.AjaxAccess;
import com.seeyon.ctp.util.annotation.ListenEvent;
import com.seeyon.ctp.util.json.JSONUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.impl.matchers.GroupMatcher;

public class CAP4FormTriggerManagerImpl
implements CAP4FormTriggerManager {
    private static final Log LOGGER = CtpLogFactory.getLog(CAP4FormTriggerManagerImpl.class);
    private CAP4FormCacheManager cap4FormCacheManager;
    private CAP4FormTriggerRecordDAO cap4FormTriggerRecordDAO;
    private TaskExecuteManager taskExecuteManager;
    private CAP4FormManager cap4FormManager;
    private FormWithHoldingDAO formWithHoldingDAO;
    private CAP4FormDataDAO cap4FormDataDAO;
    private CAP4FormDataManager cap4FormDataManager;
    private BusinessManager businessManager4;
    private CapRunningLogManager capRunningLogManager;
    private static Pattern datePattern = Pattern.compile("(\\d{4}-\\d{2}-\\d{2})");
    private CAPFormDataCacheManagerImpl capFormDataCacheManager;

    @Override
    public void doTrigger(int moduleType, long moduleId, long formId, String rightStr) throws BusinessException, SQLException {
        this.doTrigger(moduleType, moduleId, formId, rightStr, null, FormTriggerBean.TriggerEventSourceEnum.outerInterface.getKey());
    }

    @Override
    public void doTrigger(int moduleType, long moduleId, long formId, String rightStr, List<String> modifiedFields, boolean isAuto) throws BusinessException, SQLException {
        this.doTrigger(moduleType, moduleId, formId, rightStr, modifiedFields, isAuto, "otherInterface");
    }

    @Override
    public void doTrigger(int moduleType, long moduleId, long formId, String rightStr, List<String> modifiedFields, boolean isAuto, String from) throws BusinessException, SQLException {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("formId", formId);
        param.put("rightStr", rightStr);
        param.put("modifyFields", modifiedFields);
        param.put("isAuto", isAuto);
        param.put("sourceType", FormTriggerBean.TriggerEventSourceEnum.triggerInner.getKey());
        param.put("current_user_id", AppContext.currentUserId());
        param.put("from", from);
        param.put("userLocale", AppContext.getCurrentUser().getLocale());
        param.put("ipAddress", AppContext.getRemoteAddr());
        this.dispatchTriggerFireEvent(moduleType, moduleId, moduleId, param);
    }

    @Override
    public void doTrigger(FormTriggerQuartzDataVo dataVo) throws BusinessException, SQLException {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("formId", dataVo.getFormId());
        param.put("rightStr", dataVo.getRightStr());
        param.put("modifyFields", dataVo.getModifiedFields());
        param.put("isAuto", dataVo.isAuto());
        param.put("current_user_id", dataVo.getMemberId());
        param.put("from", "quartz");
        param.put("userLocale", dataVo.getLocale());
        param.put("ipAddress", AppContext.getRemoteAddr());
        param.put("sourceType", FormTriggerBean.TriggerEventSourceEnum.triggerInner.getKey());
        this.dispatchTriggerFireEvent(dataVo.getModuleType(), dataVo.getMasterId(), dataVo.getMasterId(), param);
    }

    @Override
    public void doTrigger(int moduleType, long moduleId, long formId, long sourceTriggerId, long sourceActionId, List<String> modifiedFields) throws BusinessException {
        this.doTrigger(moduleType, moduleId, formId, sourceTriggerId, sourceActionId, modifiedFields, "");
    }

    @Override
    public void doTrigger(int moduleType, long moduleId, long formId, long sourceTriggerId, long sourceActionId, List<String> modifiedFields, String rightStr) throws BusinessException {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("formId", formId);
        param.put("sourceTriggerId", sourceTriggerId);
        param.put("sourceActionId", sourceActionId);
        param.put("modifyFields", modifiedFields);
        param.put("rightStr", rightStr);
        param.put("sourceType", FormTriggerBean.TriggerEventSourceEnum.triggerInner.getKey());
        param.put("current_user_id", AppContext.currentUserId());
        param.put("from", "distribute");
        param.put("userLocale", AppContext.getCurrentUser().getLocale());
        param.put("ipAddress", AppContext.getRemoteAddr());
        this.dispatchTriggerFireEvent(moduleType, moduleId, moduleId, param);
    }

    @Override
    public void doTrigger(int moduleType, long moduleId, long formId, String rightStr, List<String> modifiedFields, String sourceFrom) throws BusinessException, SQLException {
        FormBean formBean;
        FormAuthViewBean viewBean;
        HashMap<String, Object> param = new HashMap<String, Object>();
        String right = rightStr;
        if (Strings.isNotBlank((String)rightStr) && (viewBean = (formBean = this.cap4FormCacheManager.getForm(formId)).getAuthViewBeanById(Long.valueOf(rightStr))) != null) {
            if (!viewBean.isBaseAuth()) {
                viewBean = this.cap4FormCacheManager.getAuth(viewBean.getParentId());
            }
            if (viewBean != null) {
                right = viewBean.getId().toString();
            }
        }
        param.put("formId", formId);
        param.put("rightStr", right);
        param.put("modifyFields", modifiedFields);
        param.put("isAuto", false);
        param.put("sourceType", sourceFrom);
        param.put("current_user_id", AppContext.currentUserId());
        param.put("userLocale", AppContext.getCurrentUser().getLocale());
        param.put("ipAddress", AppContext.getRemoteAddr());
        this.dispatchTriggerFireEvent(moduleType, moduleId, moduleId, param);
    }

    @Override
    public void doTrigger(CtpAffair affair, int moduleType, long moduleId, FormTriggerBean.TriggerPoint triggerPoint, String triggerEventSourceEnum) throws BusinessException, SQLException {
        FormBean formBean = this.cap4FormCacheManager.getForm(affair == null ? 0L : affair.getFormAppId());
        if (affair == null || formBean == null) {
            LOGGER.info((Object)"\u5f53\u524d\u6d41\u7a0b\u5bf9\u5e94\u8868\u5355\u4e0d\u5b58\u5728\uff0c\u89e6\u53d1\u4e2d\u65ad\u2026\u2026\u2026\u2026");
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("formId", formBean.getId());
        map.put("conditionState", triggerPoint);
        map.put("affair_member_id", affair.getMemberId());
        map.put("current_user_id", AppContext.currentUserId());
        map.put("userLocale", AppContext.getCurrentUser().getLocale());
        map.put("ipAddress", AppContext.getRemoteAddr());
        map.put("flowTitle", affair.getSubject());
        map.put("sourceType", triggerEventSourceEnum);
        this.dispatchTriggerFireEvent(moduleType, moduleId, affair.getFormRecordid(), map);
    }

    private void dispatchTriggerFireEvent(int moduleType, long moduleId, long dataId, Map<String, Object> map) {
        CAP4FormTriggerFireEvent event = new CAP4FormTriggerFireEvent((Object)this);
        event.setModuleType(Integer.valueOf(moduleType));
        event.setModuleId(Long.valueOf(moduleId));
        event.setMasterId(Long.valueOf(dataId));
        event.setParam(map);
        EventDispatcher.fireEventAfterCommit((Event)event);
    }

    @Override
    @ListenEvent(event=CAP4FormTriggerFireEvent.class, async=true, mode=EventTriggerMode.afterCommit)
    public void doTriggerAfterCommit(CAP4FormTriggerFireEvent fireEvent) throws BusinessException, SQLException {
        this.doTrigger(fireEvent.getMasterId(), fireEvent.getModuleType(), (long)fireEvent.getModuleId(), fireEvent.getParam());
    }

    private void doTrigger(Long dataId, int moduleType, long moduleId, Map<String, Object> map) throws BusinessException {
        Long formId = (Long)map.get("formId");
        FormBean formBean = this.cap4FormCacheManager.getForm(formId);
        if (formBean == null) {
            LOGGER.warn((Object)("\u8868\u5355\u7f13\u5b58\u4e0d\u5b58\u5728\uff0c\u8868\u5355\u6b63\u5728\u521d\u59cb\u5316\u6216\u8005\u5df2\u88ab\u5220\u9664\uff01" + formId));
            return;
        }
        if (Strings.isEmpty((Collection)formBean.getFormTriggerIdList())) {
            LOGGER.warn((Object)("\u8868\u5355 ID " + formBean.getId() + " ;\u8868\u5355 \u540d\u79f0" + formBean.getFormName() + " \u6ca1\u6709\u89e6\u53d1\u8bbe\u7f6e"));
            return;
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.putAll(map);
        Long currentUserId = (Long)map.get("current_user_id");
        if (currentUserId == null) {
            currentUserId = AppContext.currentUserId();
            map.put("userLocale", AppContext.getCurrentUser().getLocale());
            map.put("ipAddress", AppContext.getRemoteAddr());
        }
        param.put("userId", currentUserId);
        LOGGER.info((Object)("\u8868\u5355 ID " + formBean.getId() + " ;\u8868\u5355 \u540d\u79f0" + formBean.getFormName() + "\u6570\u636eID " + dataId + "\u53d1\u8d77\u89e6\u53d1\u6267\u884c\u4e8b\u4ef6\u2026\u2026"));
        CAPFormTriggerEvent event = new CAPFormTriggerEvent();
        event.setNewId();
        event.setState(Integer.valueOf(0));
        event.setModuleType(Integer.valueOf(moduleType));
        event.setModuleId(Long.valueOf(moduleId));
        event.setFormId(formBean.getId());
        event.setFormName(formBean.getFormName());
        event.setMasterId(dataId);
        event.setUserId(currentUserId);
        event.setCreateTime(new Date());
        String title = param.get("flowTitle") == null ? formBean.getFormName() : param.get("flowTitle").toString();
        event.setTitle(title);
        String sourceFrom = param.get("sourceType") == null ? FormTriggerBean.TriggerEventSourceEnum.outerInterface.getKey() : param.get("sourceType").toString();
        event.setSourceType(sourceFrom);
        Long groupId = 0L;
        BusinessManager businessManager4 = (BusinessManager)AppContext.getBean((String)"businessManager4");
        BizConfigBean bizConfigBean = businessManager4.findBizConfigByFormId(formBean.getId());
        if (bizConfigBean != null) {
            groupId = bizConfigBean.getId();
        }
        event.setGroupId(groupId);
        HashMap<String, Object> par = new HashMap<String, Object>();
        par.putAll(param);
        par.remove("ctpContentAll");
        par.remove("masterBean");
        par.remove("FormBean");
        par.remove("conditionState");
        event.setExtendAttr(JSONUtil.toJSONString(par));
        if (param.get("conditionState") != null) {
            event.setConditionState(((FormTriggerBean.TriggerPoint)param.get("conditionState")).getKey());
        }
        this.taskExecuteManager.addTaskEvent((FormTriggerEventObject)event);
    }

    @Override
    public List<FormTriggerBean> getNeedExecTriggerList(FormBean sourceForm, long masterId) throws BusinessException {
        LinkedList<FormTriggerBean> needExecList = new LinkedList<FormTriggerBean>();
        LinkedList formTriggerIdList = new LinkedList(sourceForm.getFormTriggerIdList());
        List<Object> recordList = new ArrayList();
        if (sourceForm.isFlowForm()) {
            recordList = this.getRecordList(FormTriggerUtil.getTriggerRecordName(sourceForm), masterId);
        }
        if (Strings.isNotEmpty(recordList)) {
            FormTriggerBean temp;
            HashMap triggerRecordMap = new HashMap();
            for (CAP4FormTriggerRecord cAP4FormTriggerRecord : recordList) {
                long triggerId = cAP4FormTriggerRecord.getTriggerId();
                temp = this.cap4FormCacheManager.getFormTriggerBean(triggerId);
                if (temp == null || !sourceForm.getFormTriggerIdList().contains(triggerId)) {
                    sourceForm.removeFormTriggerSet(Long.valueOf(triggerId));
                    continue;
                }
                Strings.addToMap(triggerRecordMap, (Object)triggerId, (Object)cAP4FormTriggerRecord);
            }
            for (Map.Entry entry : triggerRecordMap.entrySet()) {
                CAP4FormTriggerRecord tempRecord = null;
                StringBuilder contentDesc = new StringBuilder();
                for (CAP4FormTriggerRecord record : (List)entry.getValue()) {
                    if (Strings.isNotEmpty((String)record.getTriggerContentDesc())) {
                        String desc = record.getTriggerContentDesc();
                        if (desc.contains("|")) {
                            desc = desc.split("\\|")[0];
                        }
                        contentDesc.append(desc).append("|");
                    }
                    if (tempRecord != null && record.getLastTriggerTime().compareTo(tempRecord.getLastTriggerTime()) <= 0) continue;
                    tempRecord = record;
                }
                if (tempRecord == null) continue;
                FormTriggerBean tempTriggerBean = new FormTriggerBean(tempRecord.getTriggerJson());
                temp = this.cap4FormCacheManager.getFormTriggerBean(tempRecord.getTriggerId());
                tempTriggerBean.putExtraAttr("triggerContentDesc_" + masterId, contentDesc.toString());
                if (FormTriggerBean.TriggerPoint.FlowState_PerRatify.getKey().equals(tempTriggerBean.getTriggerPoint())) {
                    needExecList.add(tempTriggerBean);
                    if (tempTriggerBean.getState() != temp.getState()) {
                        LOGGER.info((Object)("\u89e6\u53d1\u72b6\u6001\u88ab\u4fee\u6539\uff01" + tempTriggerBean.getState() + " -> " + temp.getState()));
                    }
                    tempTriggerBean.setState(temp.getState());
                    formTriggerIdList.remove(tempTriggerBean.getId());
                    continue;
                }
                if (tempRecord.getState().intValue() == FormTriggerBean.TriggerState.TRIGGERED.getKey()) {
                    formTriggerIdList.remove(tempTriggerBean.getId());
                    continue;
                }
                needExecList.add(tempTriggerBean);
                if (tempTriggerBean.getState() != temp.getState()) {
                    LOGGER.info((Object)("\u89e6\u53d1\u72b6\u6001\u88ab\u4fee\u6539\uff01" + tempTriggerBean.getState() + " -> " + temp.getState()));
                }
                tempTriggerBean.setState(temp.getState());
                formTriggerIdList.remove(tempTriggerBean.getId());
            }
            for (Long triggerId : formTriggerIdList) {
                FormTriggerBean bean = this.cap4FormCacheManager.getFormTriggerBean(triggerId);
                needExecList.add(bean);
            }
        } else {
            for (Long triggerId : formTriggerIdList) {
                FormTriggerBean bean = this.cap4FormCacheManager.getFormTriggerBean(triggerId);
                if (bean == null) {
                    sourceForm.removeFormTriggerSet(triggerId);
                    continue;
                }
                needExecList.add(bean);
            }
        }
        return needExecList;
    }

    private List<CAP4FormTriggerRecord> getRecordList(String tableName, long masterId) throws BusinessException {
        return this.cap4FormTriggerRecordDAO.getRecordListByMasterId(tableName, masterId);
    }

    @Override
    public List<CAP4FormTriggerRecord> getRecordList(FormBean sourceForm, Long masterId, Long triggerId, Long actionId) throws BusinessException {
        return this.cap4FormTriggerRecordDAO.getRecordList(FormTriggerUtil.getTriggerRecordName(sourceForm), (long)masterId, (long)triggerId, actionId);
    }

    @Override
    public List<CAP4FormTriggerRecord> getRecordList(FormBean sourceForm, Long triggerId, Long contentId, String actionType) throws BusinessException {
        return this.cap4FormTriggerRecordDAO.getRecordList(FormTriggerUtil.getTriggerRecordName(sourceForm), (long)triggerId, (long)contentId, actionType);
    }

    @Override
    public List<CAP4FormTriggerRecord> getRecordList(FormBean sourceForm, Long contentId, String actionType) throws BusinessException {
        return this.cap4FormTriggerRecordDAO.getRecordList(FormTriggerUtil.getTriggerRecordName(sourceForm), (long)contentId, actionType);
    }

    @Override
    public int saveOrUpdate(FormBean sourceForm, CAP4FormTriggerRecord record) throws BusinessException {
        return this.cap4FormTriggerRecordDAO.saveOrUpdate(FormTriggerUtil.getTriggerRecordName(sourceForm), record);
    }

    @Override
    public int saveOrUpdate(FormBean sourceForm, List<CAP4FormTriggerRecord> recordList) throws BusinessException {
        return this.cap4FormTriggerRecordDAO.saveOrUpdate(FormTriggerUtil.getTriggerRecordName(sourceForm), recordList);
    }

    @Override
    public void saveAll(FormBean sourceForm, List<CAP4FormTriggerRecord> recordList) throws BusinessException {
        this.cap4FormTriggerRecordDAO.saveAll(FormTriggerUtil.getTriggerRecordName(sourceForm), recordList);
    }

    @Override
    public void addTriggerQuartzJob(Map<String, String> map, FormDataMasterBean masterBean, FormTriggerConditionBean dateCondition) throws Exception {
        FormFormulaBean dateFormula = dateCondition.getConditionFormula();
        if (dateFormula == null) {
            return;
        }
        Map dataMap = masterBean.getFormulaMap("formulaType_datetime");
        String formulaStr = dateFormula.getExecuteFormulaForGroove();
        if (Strings.isBlank((String)formulaStr)) {
            return;
        }
        LOGGER.info((Object)("\u89e6\u53d11\uff1a\u6642\u9593: " + formulaStr));
        String groupName = map.get("triggerId");
        String dataId = map.get("masterId");
        this.removeDataParamInQuartzJob(groupName, dataId);
        String jobName = map.get("masterId");
        if (formulaStr.contains("SpecifiedTime")) {
            Matcher m = datePattern.matcher(formulaStr);
            m.find();
            String dateStr = m.group();
            Date date = Datetimes.parse((String)dateStr, (String)"yyyy-MM-dd");
            FormTriggerBean.TimeFrequency timeFrequency = FormTriggerBean.TimeFrequency.getEnumByKey((String)dateCondition.getTimeFrequency());
            this.addTriggerQuartzJob(jobName, false, map, date, timeFrequency, dateCondition);
        } else if (formulaStr.contains(FormTriggerBean.TimeFrequency.PerMonthBegin.getKey())) {
            dataMap.put(FormTriggerBean.TimeFrequency.PerMonthBegin.getKey(), Datetimes.getFirstDayInMonth((Date)new Date()));
            Date date = (Date)FormulaUtil.doResult((String)formulaStr, (Map)dataMap);
            this.addTriggerQuartzJob(jobName, false, map, date, FormTriggerBean.TimeFrequency.PerMonthBegin, dateCondition);
        } else if (formulaStr.contains(FormTriggerBean.TimeFrequency.PerMonthEnd.getKey())) {
            dataMap.put(FormTriggerBean.TimeFrequency.PerMonthEnd.getKey(), Datetimes.getLastDayInMonth((Date)new Date()));
            Date date = (Date)FormulaUtil.doResult((String)formulaStr, (Map)dataMap);
            this.addTriggerQuartzJob(jobName, false, map, date, FormTriggerBean.TimeFrequency.PerMonthEnd, dateCondition);
        } else if (formulaStr.contains(FormTriggerBean.TimeFrequency.PerSeasonBegin.getKey())) {
            dataMap.put(FormTriggerBean.TimeFrequency.PerSeasonBegin.getKey(), Datetimes.getFirstDayInSeason((Date)new Date()));
            Date date = (Date)FormulaUtil.doResult((String)formulaStr, (Map)dataMap);
            this.addTriggerQuartzJob(jobName, false, map, date, FormTriggerBean.TimeFrequency.PerSeasonBegin, dateCondition);
        } else if (formulaStr.contains(FormTriggerBean.TimeFrequency.PerSeasonEnd.getKey())) {
            dataMap.put(FormTriggerBean.TimeFrequency.PerSeasonEnd.getKey(), Datetimes.getLastDayInSeason((Date)new Date()));
            Date date = (Date)FormulaUtil.doResult((String)formulaStr, (Map)dataMap);
            this.addTriggerQuartzJob(jobName, false, map, date, FormTriggerBean.TimeFrequency.PerSeasonEnd, dateCondition);
        } else if (formulaStr.contains(FormTriggerBean.TimeFrequency.PerHalfYearBegin.getKey())) {
            Date date;
            Calendar c = Calendar.getInstance();
            int month = c.get(2);
            c.set(5, 1);
            if (month <= 5) {
                c.set(2, 1);
                date = c.getTime();
            } else {
                c.set(2, 7);
                date = c.getTime();
            }
            dataMap.put(FormTriggerBean.TimeFrequency.PerHalfYearBegin.getKey(), Datetimes.getFirstDayInSeason((Date)date));
            Date date1 = (Date)FormulaUtil.doResult((String)formulaStr, (Map)dataMap);
            this.addTriggerQuartzJob(jobName, false, map, date1, FormTriggerBean.TimeFrequency.PerHalfYearBegin, dateCondition);
        } else if (formulaStr.contains(FormTriggerBean.TimeFrequency.PerHalfYearEnd.getKey())) {
            Date date;
            Calendar c = Calendar.getInstance();
            int month = c.get(2);
            c.set(5, 1);
            if (month <= 5) {
                c.set(2, 4);
                date = c.getTime();
            } else {
                c.set(2, 10);
                date = c.getTime();
            }
            dataMap.put(FormTriggerBean.TimeFrequency.PerHalfYearEnd.getKey(), Datetimes.getLastDayInSeason((Date)date));
            Date date1 = (Date)FormulaUtil.doResult((String)formulaStr, (Map)dataMap);
            this.addTriggerQuartzJob(jobName, false, map, date1, FormTriggerBean.TimeFrequency.PerHalfYearEnd, dateCondition);
        } else if (formulaStr.contains(FormTriggerBean.TimeFrequency.PerYearBegin.getKey())) {
            dataMap.put(FormTriggerBean.TimeFrequency.PerYearBegin.getKey(), Datetimes.getFirstDayInYear((Date)new Date()));
            Date date = (Date)FormulaUtil.doResult((String)formulaStr, (Map)dataMap);
            this.addTriggerQuartzJob(jobName, false, map, date, FormTriggerBean.TimeFrequency.year, dateCondition);
        } else if (formulaStr.contains(FormTriggerBean.TimeFrequency.PerYearEnd.getKey())) {
            dataMap.put(FormTriggerBean.TimeFrequency.PerYearEnd.getKey(), Datetimes.getLastDayInYear((Date)new Date()));
            Date date = (Date)FormulaUtil.doResult((String)formulaStr, (Map)dataMap);
            this.addTriggerQuartzJob(jobName, false, map, date, FormTriggerBean.TimeFrequency.year, dateCondition);
        } else {
            FormTriggerBean.TimeFrequency timeFrequency = FormTriggerBean.TimeFrequency.getEnumByKey((String)dateCondition.getTimeFrequency());
            String fieldName = StringUtils.substringBetween((String)formulaStr, (String)"(", (String)",");
            FormFieldBean fieldBean = null;
            try {
                FormBean formBean;
                String formId = map.get("formId");
                fieldBean = StringUtil.checkNull((String)formId) ? masterBean.getFieldBeanByFieldName(fieldName) : ((formBean = this.cap4FormCacheManager.getForm(Long.valueOf(formId))) == null ? masterBean.getFieldBeanByFieldName(fieldName) : formBean.getFieldBeanByName(fieldName));
            }
            catch (Exception e) {
                LOGGER.error((Object)("\u83b7\u53d6\u5b57\u6bb5\u5f02\u5e38\uff0c\u8868\u5355 " + map.get("formId") + " \u6570\u636e " + masterBean.getId() + " \u5b57\u6bb5 " + fieldName));
            }
            if (fieldBean != null && fieldBean.isSubField()) {
                Date date;
                FormTriggerBean triggerBean = dateCondition.getFormTriggerBean();
                String filterSubTableName = triggerBean.getFilterConditionSubTableName();
                String formId = map.get("formId");
                FormBean formBean = this.cap4FormCacheManager.getForm(Long.valueOf(formId));
                List<Long> triggeredSubDataIds = this.cap4FormTriggerRecordDAO.getTriggeredSubDataIds(FormTriggerUtil.getTriggerRecordName(formBean), masterBean.getId(), triggerBean.getId(), FormTriggerBean.TriggerState.TRIGGERED.getKey());
                String ownerTableName = fieldBean.getOwnerTableName();
                List<FormDataSubBean> subBeanList = masterBean.getSubData(ownerTableName);
                subBeanList = FormTriggerUtil.filterSubBeansByFilterCondition(triggerBean, masterBean, subBeanList, ownerTableName, filterSubTableName);
                HashMap triggerSubBeanMap = new HashMap();
                for (FormDataSubBean formDataSubBean : subBeanList) {
                    if (triggeredSubDataIds.contains(formDataSubBean.getId()) && timeFrequency == FormTriggerBean.TimeFrequency.once && triggerBean.isConditionFirstMet()) continue;
                    dataMap.putAll(formDataSubBean.getRowData());
                    date = (Date)FormulaUtil.doResult((String)formulaStr, (Map)dataMap);
                    if (date == null) continue;
                    Strings.addToMap(triggerSubBeanMap, (Object)Datetimes.formatDate((Date)date), (Object)String.valueOf(formDataSubBean.getId()));
                }
                map.put("dateSubTableName", ownerTableName);
                map.put("formField", "isSubField");
                for (Map.Entry entry : triggerSubBeanMap.entrySet()) {
                    date = Datetimes.parseDate((String)((String)entry.getKey()));
                    String subDataStr = Strings.join((Collection)((Collection)entry.getValue()), (String)",");
                    LOGGER.info((Object)("jobName: " + jobName + " subDataIds1---: " + subDataStr));
                    map.put("dateSubDataIds", subDataStr);
                    HashMap<String, String> paramMap = new HashMap<String, String>(map);
                    this.addTriggerQuartzJob(jobName, true, paramMap, date, timeFrequency, dateCondition);
                }
            } else if (fieldBean != null || fieldName.equals(Enums.MasterTableField.start_date.getKey())) {
                Date date = (Date)FormulaUtil.doResult((String)formulaStr, (Map)dataMap);
                this.addTriggerQuartzJob(jobName, false, map, date, timeFrequency, dateCondition);
            } else {
                LOGGER.error((Object)(map.get("formId") + ",\u4fee\u6539\u8868\u5355\u66f4\u65b0\u8868\u5355\u6570\u636e\u89e6\u53d1\u65f6\uff0c\u89e6\u53d1\u65f6\u95f4\u70b9\u4e3a\u91cd\u590d\u8868\u5b57\u6bb5\uff0c\u8017\u6027\u80fd\uff0c\u6682\u65f6\u4e0d\u66f4\u65b0\uff0c\u8868\u5355\u5b57\u6bb5\uff1a" + fieldName));
            }
        }
    }

    private void removeDataParamInQuartzJob(String groupName, String dataId) throws SchedulerException {
        Scheduler sched = QuartzListener.getScheduler();
        Set jobNameSet = sched.getJobKeys(GroupMatcher.groupStartsWith((String)groupName));
        if (jobNameSet != null && !jobNameSet.isEmpty()) {
            for (JobKey jobKey : jobNameSet) {
                String oldSubDataIds;
                JobDataMap jobDataMap;
                String dataIds;
                String name = jobKey.getName();
                if (name.startsWith(dataId)) {
                    QuartzHolder.deleteQuartzJobByGroupAndJobName((String)groupName, (String)dataId);
                    continue;
                }
                JobDetail jd = sched.getJobDetail(JobKey.jobKey((String)name, (String)groupName));
                if (jd == null || Strings.isBlank((String)(dataIds = (jobDataMap = jd.getJobDataMap()).getString("dateDataIds"))) || !dataIds.contains(dataId)) continue;
                if (jd.getJobDataMap().getString("formField") != null && "null".equals(jd.getJobDataMap().getString("formField")) && (oldSubDataIds = jobDataMap.getString("dateSubDataIds")).contains(dataId)) {
                    oldSubDataIds = this.replaceDataParam(oldSubDataIds, dataId, "@@@");
                    jobDataMap.put("dateSubDataIds", oldSubDataIds);
                    LOGGER.info((Object)("jobName: " + name + " subDataIds2---: " + oldSubDataIds));
                }
                dataIds = this.replaceDataParam(dataIds, dataId, ",");
                jobDataMap.put("dateDataIds", dataIds);
                String memIds = jobDataMap.getString("userId");
                memIds = this.replaceDataParam(memIds, dataId, ",");
                jobDataMap.put("userId", memIds);
                String moduleIds = jobDataMap.getString("dateModuleIds");
                moduleIds = this.replaceDataParam(moduleIds, dataId, ",");
                jobDataMap.put("moduleId", moduleIds);
                sched.addJob(jd, true, true);
            }
        }
    }

    private String replaceDataParam(String paramString, String dataId, String split) {
        if (paramString.contains(split)) {
            int splitLen = split.length();
            int index = paramString.indexOf(dataId);
            int beginIndex = paramString.indexOf(split, index) == -1 ? index - splitLen : index;
            int endIndex = paramString.indexOf(split, index) == -1 ? paramString.length() : paramString.indexOf(split, index) + splitLen;
            String tempStr = paramString.substring(beginIndex, endIndex);
            return paramString.replace(tempStr, "");
        }
        return "";
    }

    private void addTriggerQuartzJob(String jobName, boolean needSubName, Map<String, String> map, Date date0, FormTriggerBean.TimeFrequency timeFrequency, FormTriggerConditionBean dateCondition) throws BusinessException, SchedulerException {
        FormTriggerBean triggerBean = dateCondition.getFormTriggerBean();
        if (date0 == null || timeFrequency == null) {
            LOGGER.warn((Object)("\u89e6\u53d1\u5f02\u5e38\uff0c\u65e5\u671f[" + date0 + "]\u6216\u8005\u5468\u671f[" + timeFrequency + "]\u4e3anull; FormTriggerCondition.id=" + dateCondition.getFormTriggerBean().getId()));
            return;
        }
        String groupName = map.get("triggerId");
        String dataId = map.get("masterId");
        String subDataId = map.get("dateSubDataIds");
        String moduleId = map.get("moduleId");
        String userId = map.get("userId");
        String formId = map.get("formId");
        FormBean formBean = this.cap4FormCacheManager.getForm(Long.valueOf(formId));
        List<CAP4FormTriggerRecord> triggeredList = this.cap4FormTriggerRecordDAO.getRecordList(FormTriggerUtil.getTriggerRecordName(formBean), (long)Long.valueOf(groupName), Long.valueOf(dataId));
        if (triggerBean.isConditionFirstMet() && timeFrequency == FormTriggerBean.TimeFrequency.once && Strings.isNotEmpty(triggeredList)) {
            LOGGER.info((Object)("\u89e6\u53d1\uff1a" + groupName + "." + jobName + "\u5df2\u7ecf\u6267\u884c\uff0c\u4e14\u975e\u5468\u671f\u6027\uff0c\u4e0d\u52a0\u5165\u65f6\u95f4\u8c03\u5ea6\uff01"));
            return;
        }
        String result = Datetimes.format((Date)date0, (String)"yyyy-MM-dd") + " " + dateCondition.getTriggerTime();
        Date date = Datetimes.parse((String)result, (String)"yyyy-MM-dd HH:mm");
        LOGGER.info((Object)("\u89e6\u53d12\uff1a" + jobName + " \u985e\u578b\uff1a" + timeFrequency + ", \u6642\u9593: " + date));
        jobName = map.get("formId") + "_" + Datetimes.format((Date)date, (String)"yyyy-MM-dd HH:mm:ss");
        map.put("triggerJobName", jobName);
        JobDetail jobDetail = QuartzListener.getScheduler().getJobDetail(JobKey.jobKey((String)jobName, (String)groupName));
        if (null != jobDetail) {
            String dataIds = jobDetail.getJobDataMap().getString("dateDataIds");
            dataIds = Strings.isBlank((String)dataIds) ? dataId : (dataIds.contains(dataId) ? dataIds : dataIds + "," + dataId);
            map.put("dateDataIds", dataIds);
            if (needSubName) {
                String subDataIds = jobDetail.getJobDataMap().getString("dateSubDataIds");
                String tempSubDataIds = dataId + ":" + subDataId;
                subDataIds = Strings.isBlank((String)subDataIds) ? tempSubDataIds : subDataIds + "@@@" + tempSubDataIds;
                map.put("dateSubDataIds", subDataIds);
                LOGGER.info((Object)("jobName: " + jobName + " subDataIds3---: " + subDataIds));
            }
            String memIds = jobDetail.getJobDataMap().getString("userId");
            String tempMedIds = dataId + "_" + userId;
            memIds = Strings.isBlank((String)memIds) ? tempMedIds : memIds + "," + tempMedIds;
            map.put("userId", memIds);
            String moduleIds = jobDetail.getJobDataMap().getString("dateModuleIds");
            String tempModuleIds = dataId + "_" + moduleId;
            moduleIds = Strings.isBlank((String)moduleIds) ? tempModuleIds : moduleIds + "," + tempModuleIds;
            map.put("dateModuleIds", moduleIds);
            QuartzHolder.deleteQuartzJobByGroupAndJobName((String)groupName, (String)jobName);
        } else {
            map.put("dateDataIds", dataId);
            map.put("dateSubDataIds", dataId + ":" + subDataId);
            map.put("dateModuleIds", dataId + "_" + moduleId);
            map.put("userId", dataId + "_" + userId);
        }
        this.addQuartzJob(groupName, jobName, date, map, timeFrequency);
    }

    @Override
    public void updateTriggerQuartzJob(FormTriggerBean triggerBean, boolean isNew, String oldTimeSet, String newTimeSet) throws BusinessException {
        boolean needDoThis;
        if (!isNew && !triggerBean.isEnable()) {
            QuartzHolder.deleteQuartzJobByGroup((String)triggerBean.getId().toString());
            return;
        }
        boolean bl = needDoThis = isNew && Strings.isNotBlank((String)newTimeSet) || !isNew && !oldTimeSet.equals(newTimeSet);
        if (!needDoThis) {
            return;
        }
        UpdateQuartzJobThread jobThread = new UpdateQuartzJobThread();
        jobThread.user = AppContext.getCurrentUser();
        jobThread.manager = this;
        jobThread.triggerBean = triggerBean;
        jobThread.sourceForm = this.cap4FormCacheManager.getForm(triggerBean.getSourceFormId());
        jobThread.updateQuartz = !isNew && Strings.isNotBlank((String)oldTimeSet) && !oldTimeSet.equals(newTimeSet);
        jobThread.start();
    }

    private FormTriggerBean.TimeFrequency analysisTimeSet(Map<String, Map<String, String>> allDataJobParamMap, FormBean sourceForm, FormTriggerConditionBean dateCondition, String formulaStr, FormTriggerBean.TimeFrequency timeFrequency, Date date, List<FormDataMasterBean> dataList, Map<String, String> dataMemberMap) throws BusinessException {
        FormTriggerBean triggerBean = dateCondition.getFormTriggerBean();
        String triggerTime = dateCondition.getTriggerTime();
        if (triggerTime.length() == 4) {
            triggerTime = "0" + triggerTime;
        }
        CAP4FormTriggerRecordDAO triggerRecordDAO = (CAP4FormTriggerRecordDAO)AppContext.getBean((String)"cap4FormTriggerRecordDAO");
        for (FormDataMasterBean dataBean : dataList) {
            Date resultDate;
            List<CAP4FormTriggerRecord> triggeredList;
            if (!triggerBean.isMatchCondition(dataBean, null)) {
                LOGGER.info((Object)("\u66f4\u65b0\u8c03\u5ea6 \u6570\u636e\uff1a" + dataBean.getId() + " \u4e0d\u6ee1\u8db3\u6761\u4ef6"));
                continue;
            }
            String dataId = String.valueOf(dataBean.getId());
            String memberId = dataMemberMap.get(String.valueOf(triggerBean.getId()) + dataId);
            memberId = Strings.isNotBlank((String)memberId) ? memberId : dataBean.getStartMemberId() + "";
            memberId = memberId.replace(dataId + "_", "");
            Map dataMap = dataBean.getFormulaMap("formulaType_datetime");
            if (date != null) {
                if (triggerBean.isConditionFirstMet() && timeFrequency == FormTriggerBean.TimeFrequency.once && Strings.isNotEmpty(triggeredList = triggerRecordDAO.getRecordList(FormTriggerUtil.getTriggerRecordName(sourceForm), (long)triggerBean.getId(), dataBean.getId()))) {
                    LOGGER.info((Object)("\u6570\u636e\uff1a" + dataBean.getId() + " \u89e6\u53d1\uff1a" + triggerBean.getId() + " \u5df2\u7ecf\u6267\u884c\uff0c\u4e14\u975e\u5468\u671f\u6027\uff0c\u4e0d\u52a0\u5165\u65f6\u95f4\u8c03\u5ea6\uff01"));
                    continue;
                }
                if (formulaStr.contains("SpecifiedTime")) {
                    resultDate = date;
                } else {
                    dataMap.put(timeFrequency.getKey(), date);
                    resultDate = (Date)FormulaUtil.doResult((String)formulaStr, (Map)dataMap);
                }
                this.addDataParam2JobMap(allDataJobParamMap, resultDate, sourceForm.getId(), dataId, memberId, null, null, triggerTime);
                continue;
            }
            timeFrequency = FormTriggerBean.TimeFrequency.getEnumByKey((String)dateCondition.getTimeFrequency());
            if (triggerBean.isConditionFirstMet() && timeFrequency == FormTriggerBean.TimeFrequency.once && Strings.isNotEmpty(triggeredList = triggerRecordDAO.getRecordList(FormTriggerUtil.getTriggerRecordName(sourceForm), (long)triggerBean.getId(), dataBean.getId()))) {
                LOGGER.info((Object)("\u6570\u636e\uff1a" + dataBean.getId() + " \u89e6\u53d1\uff1a" + triggerBean.getId() + " \u5df2\u7ecf\u6267\u884c\uff0c\u4e14\u975e\u5468\u671f\u6027\uff0c\u4e0d\u52a0\u5165\u65f6\u95f4\u8c03\u5ea6\uff01"));
                continue;
            }
            String fieldName = StringUtils.substringBetween((String)formulaStr, (String)"(", (String)",");
            FormFieldBean fieldBean = sourceForm.getFieldBeanByName(fieldName);
            if (fieldBean != null && fieldBean.isSubField()) {
                String filterSubTableName = triggerBean.getFilterConditionSubTableName();
                List<Long> triggeredSubDataIds = triggerRecordDAO.getTriggeredSubDataIds(FormTriggerUtil.getTriggerRecordName(sourceForm), triggerBean.getId(), dataBean.getId(), FormTriggerBean.TriggerState.TRIGGERED.getKey());
                String ownerTableName = fieldBean.getOwnerTableName();
                List<FormDataSubBean> subBeanList = dataBean.getSubData(ownerTableName);
                subBeanList = FormTriggerUtil.filterSubBeansByFilterCondition(triggerBean, dataBean, subBeanList, ownerTableName, filterSubTableName);
                HashMap triggerSubBeanMap = new HashMap();
                for (FormDataSubBean formDataSubBean : subBeanList) {
                    if (triggeredSubDataIds.contains(formDataSubBean.getId()) && timeFrequency == FormTriggerBean.TimeFrequency.once && triggerBean.isConditionFirstMet()) continue;
                    dataMap.putAll(formDataSubBean.getRowData());
                    Date date1 = (Date)FormulaUtil.doResult((String)formulaStr, (Map)dataMap);
                    if (date1 == null) {
                        LOGGER.warn((Object)"\u89e6\u53d1\u5f02\u5e38\uff0c\u65e5\u671f\u4e3anull");
                        continue;
                    }
                    Strings.addToMap(triggerSubBeanMap, (Object)Datetimes.formatDate((Date)date1), (Object)String.valueOf(formDataSubBean.getId()));
                }
                for (Map.Entry entry : triggerSubBeanMap.entrySet()) {
                    resultDate = Datetimes.parseDate((String)((String)entry.getKey()));
                    String subDataStr = Strings.join((Collection)((Collection)entry.getValue()), (String)",");
                    LOGGER.info((Object)("jobName: " + (String)entry.getKey() + " subDataIds1: " + subDataStr));
                    this.addDataParam2JobMap(allDataJobParamMap, resultDate, sourceForm.getId(), dataId, memberId, subDataStr, ownerTableName, triggerTime);
                }
                continue;
            }
            if (fieldBean != null || fieldName.equals(Enums.MasterTableField.start_date.getKey())) {
                resultDate = (Date)FormulaUtil.doResult((String)formulaStr, (Map)dataMap);
                if (resultDate == null) {
                    LOGGER.warn((Object)"\u89e6\u53d1\u5f02\u5e38\uff0c\u65e5\u671f\u4e3anull");
                    continue;
                }
                this.addDataParam2JobMap(allDataJobParamMap, resultDate, sourceForm.getId(), dataId, memberId, null, null, triggerTime);
                continue;
            }
            LOGGER.error((Object)("\u4fee\u6539\u8868\u5355\u66f4\u65b0\u8868\u5355\u6570\u636e\u89e6\u53d1\u65f6\uff0c\u89e6\u53d1\u65f6\u95f4\u70b9\u4e3a\u91cd\u590d\u8868\u5b57\u6bb5\uff0c\u8017\u6027\u80fd\uff0c\u6682\u65f6\u4e0d\u66f4\u65b0\uff0c\u8868\u5355\u5b57\u6bb5\uff1a" + fieldName));
        }
        return timeFrequency;
    }

    private void addDataParam2JobMap(Map<String, Map<String, String>> allDataJobParamMap, Date resultDate, Long formId, String dataId, String memberId, String subDataStr, String subTableName, String dateTime) {
        String key = Datetimes.format((Date)resultDate, (String)"yyyy-MM-dd") + " " + dateTime + ":00";
        Map<String, String> jobParam = allDataJobParamMap.get(key);
        if (jobParam == null) {
            jobParam = new HashMap<String, String>();
            allDataJobParamMap.put(key, jobParam);
            jobParam.put("dateDataIds", dataId);
            jobParam.put("userId", dataId + "_" + memberId);
            jobParam.put("dateModuleIds", dataId + "_" + dataId);
            if (Strings.isNotBlank((String)subDataStr)) {
                jobParam.put("dateSubDataIds", dataId + ":" + subDataStr);
                jobParam.put("formField", "isSubField");
                jobParam.put("dateSubTableName", subTableName);
            }
        } else {
            String dataIds = jobParam.get("dateDataIds");
            dataIds = Strings.isBlank((String)dataIds) ? dataId : (dataIds.contains(dataId) ? dataIds : dataIds + "," + dataId);
            jobParam.put("dateDataIds", dataIds);
            String memIds = jobParam.get("userId");
            String tempMedIds = dataId + "_" + memberId;
            memIds = Strings.isBlank((String)memIds) ? tempMedIds : (memIds.contains(tempMedIds) ? memIds : memIds + "," + tempMedIds);
            jobParam.put("userId", memIds);
            String moduleIds = jobParam.get("dateModuleIds");
            String tempModuleIds = dataId + "_" + dataId;
            moduleIds = Strings.isBlank((String)moduleIds) ? tempModuleIds : (moduleIds.contains(tempModuleIds) ? moduleIds : moduleIds + "," + tempModuleIds);
            jobParam.put("dateModuleIds", moduleIds);
            if (Strings.isNotBlank((String)subDataStr)) {
                String subDataIds = jobParam.get("dateSubDataIds");
                String tempSubDataIds = dataId + ":" + subDataStr;
                subDataIds = Strings.isBlank((String)subDataIds) ? tempSubDataIds : (subDataIds.contains(tempSubDataIds) ? subDataIds : subDataIds + "@@@" + tempSubDataIds);
                jobParam.put("dateSubDataIds", subDataIds);
            }
        }
        jobParam.put("triggerJobName", formId + "_" + key);
        LOGGER.info((Object)("jobName: " + key + " subDataIds2: " + jobParam.get("dateSubDataIds")));
    }

    private void addQuartzJob(String groupName, String jobName, Date quartzDate, Map<String, String> jobParam, FormTriggerBean.TimeFrequency timeFrequency) throws BusinessException {
        LOGGER.info((Object)("\u89e6\u53d12\uff1a" + jobName + " \u985e\u578b\uff1a" + timeFrequency + ", \u6642\u9593: " + quartzDate));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(quartzDate);
        boolean isAfter = quartzDate.compareTo(DateUtil.currentDate()) >= 0;
        LOGGER.info((Object)("jobName: " + jobName + " subDataIds3: " + jobParam.get("dateSubDataIds")));
        String jobBeanName = "cap4FormTriggerQuartzJob";
        switch (timeFrequency) {
            case once: {
                if (isAfter) {
                    QuartzHolder.newQuartzJob((String)groupName, (String)jobName, (Date)quartzDate, (String)"cap4FormTriggerQuartzJob", jobParam);
                    break;
                }
                LOGGER.info((Object)("\u65f6\u95f4\u8c03\u5ea6\u89e6\u53d1\u65f6\u95f4 " + Datetimes.format((Date)quartzDate, (String)"yyyy-MM-dd HH:mm:ss") + " \u70b9\u5728\u5f53\u524d\u65f6\u95f4\u4e4b\u524d\uff0c\u4e0d\u52a0\u5165\u65f6\u95f4\u8c03\u5ea6"));
                break;
            }
            case PerMonthBegin: {
                if (!isAfter) {
                    quartzDate = this.getAfterDate(calendar, 2, 1).getTime();
                }
                QuartzHolder.newQuartzJobPerMonth((String)groupName, (String)jobName, (Date)quartzDate, null, (String)"cap4FormTriggerQuartzJob", jobParam);
                break;
            }
            case PerMonthEnd: {
                if (!isAfter) {
                    quartzDate = this.getAfterDate(calendar, 2, 1).getTime();
                }
                QuartzHolder.newQuartzJobEndOfMonth((String)groupName, (String)jobName, (Date)quartzDate, null, (String)"cap4FormTriggerQuartzJob", jobParam);
                break;
            }
            case PerSeasonBegin: {
                if (!isAfter) {
                    quartzDate = this.getAfterDate(calendar, 2, 3).getTime();
                }
                QuartzHolder.newQuartzJobPerSeason((String)groupName, (String)jobName, (Date)quartzDate, null, (String)"cap4FormTriggerQuartzJob", jobParam);
                break;
            }
            case PerSeasonEnd: {
                if (!isAfter) {
                    quartzDate = this.getAfterDate(calendar, 2, 3).getTime();
                }
                QuartzHolder.newQuartzJobEndOfSeason((String)groupName, (String)jobName, (Date)quartzDate, null, (String)"cap4FormTriggerQuartzJob", jobParam);
                break;
            }
            case PerHalfYearBegin: {
                if (!isAfter) {
                    quartzDate = this.getAfterDate(calendar, 2, 6).getTime();
                }
                QuartzHolder.newQuartzJobPerHalfyear((String)groupName, (String)jobName, (Date)quartzDate, null, (String)"cap4FormTriggerQuartzJob", jobParam);
                break;
            }
            case PerHalfYearEnd: {
                if (!isAfter) {
                    quartzDate = this.getAfterDate(calendar, 2, 6).getTime();
                }
                QuartzHolder.newQuartzJobEndOfHalfyear((String)groupName, (String)jobName, (Date)quartzDate, null, (String)"cap4FormTriggerQuartzJob", jobParam);
                break;
            }
            case day: {
                if (!isAfter) {
                    String timeStr = Datetimes.format((Date)quartzDate, (String)"yyyy-MM-dd HH:mm");
                    calendar = Calendar.getInstance();
                    calendar.set(11, Integer.valueOf(timeStr.substring(11, 13)));
                    calendar.set(12, Integer.valueOf(timeStr.substring(14, 16)));
                    quartzDate = calendar.getTime();
                    boolean bl = isAfter = quartzDate.compareTo(DateUtil.currentDate()) >= 0;
                }
                if (!isAfter) {
                    quartzDate = this.getAfterDate(calendar, 6, 1).getTime();
                }
                QuartzHolder.newQuartzJobPerDay((String)groupName, (String)jobName, (Date)quartzDate, (String)"cap4FormTriggerQuartzJob", jobParam);
                break;
            }
            case week: {
                if (!isAfter) {
                    quartzDate = this.getAfterDate(calendar, 4, 1).getTime();
                }
                QuartzHolder.newQuartzJobPerWeek((String)groupName, (String)jobName, (Date)quartzDate, (String)"cap4FormTriggerQuartzJob", jobParam);
                break;
            }
            case month: {
                if (!isAfter) {
                    quartzDate = this.getAfterDate(calendar, 2, 1).getTime();
                }
                QuartzHolder.newQuartzJobPerMonth((String)groupName, (String)jobName, (Date)quartzDate, (String)"cap4FormTriggerQuartzJob", jobParam);
                break;
            }
            case season: {
                if (!isAfter) {
                    quartzDate = this.getAfterDate(calendar, 2, 3).getTime();
                }
                QuartzHolder.newQuartzJobPerSeason((String)groupName, (String)jobName, (Date)quartzDate, (String)"cap4FormTriggerQuartzJob", jobParam);
                break;
            }
            case halfYear: {
                if (!isAfter) {
                    quartzDate = this.getAfterDate(calendar, 2, 6).getTime();
                }
                QuartzHolder.newQuartzJobPerHalfyear((String)groupName, (String)jobName, (Date)quartzDate, null, (String)"cap4FormTriggerQuartzJob", jobParam);
                break;
            }
            case year: {
                if (!isAfter) {
                    quartzDate = this.getAfterDate(calendar, 1, 1).getTime();
                }
                QuartzHolder.newQuartzJobPerYear((String)groupName, (String)jobName, (Date)quartzDate, (String)"cap4FormTriggerQuartzJob", jobParam);
                break;
            }
        }
        LOGGER.info((Object)("\u89e6\u53d13\uff1a" + jobName + " \u985e\u578b\uff1a" + timeFrequency + ", \u6642\u9593: " + quartzDate));
    }

    private Calendar getAfterDate(Calendar c, int calendarField, int per) {
        c.add(calendarField, per);
        Date date = c.getTime();
        if (!date.after(DateUtil.currentDate())) {
            return this.getAfterDate(c, calendarField, per);
        }
        return c;
    }

    @Override
    public FormDataStateResultVO doPreWrite(int moduleType, long moduleId, FormBean formBean, long masterId, FormTriggerBean.TriggerPoint conditionState, String title) throws BusinessException, SQLException {
        FormDataStateResultVO resultVo = null;
        Long start = System.currentTimeMillis();
        Long currentUserId = AppContext.currentUserId();
        List<FormTriggerBean> triggerList = this.getNeedExecTriggerList(formBean, masterId);
        if (Strings.isEmpty(triggerList)) {
            LOGGER.error((Object)("\u8868\u5355ID " + formBean.getId() + " \u540d\u79f0" + formBean.getFormName() + "\u6570\u636eID " + masterId + "\u6ca1\u6709\u9700\u8981\u6267\u884c\u7684\u89e6\u53d1\u2026\u2026\u2026\u2026"));
            return resultVo;
        }
        FormDataMasterBean masterBean = this.cap4FormManager.getSessioMasterDataBean(masterId);
        if (masterBean == null) {
            masterBean = this.capFormDataCacheManager.get4Data(masterId, formBean.getId());
        }
        if (masterBean == null) {
            LOGGER.error((Object)"\u5b9e\u4f53\u6570\u636e\u5df2\u7ecf\u88ab\u5220\u9664\uff0c\u4e0d\u6267\u884c\u89e6\u53d1\u9884\u6821\u9a8c\u2026\u2026\u2026\u2026");
            return resultVo;
        }
        ArrayList<FormTriggerActionBean> needPreWriteActionList = new ArrayList<FormTriggerActionBean>();
        for (FormTriggerBean triggerBean : triggerList) {
            if (!triggerBean.isEnable() || !triggerBean.isMatchCondition(masterBean) || triggerBean.isConditionFirstMet() || triggerBean.isMatchTriggerPoint(masterBean, conditionState)) continue;
            for (FormTriggerActionBean actionBean : triggerBean.getActionList()) {
                if (!FormTriggerBean.TriggerType.Update.getKey().equals(actionBean.getType()) && !FormTriggerBean.TriggerType.DataMagicInterface.getKey().equals(actionBean.getType()) && !FormTriggerBean.TriggerType.DataMagicOuterForm.getKey().equals(actionBean.getType()) || !actionBean.isWithHolding()) continue;
                needPreWriteActionList.add(actionBean);
            }
        }
        LOGGER.info((Object)("\u8fdb\u5165\u9884\u63d0\u5224\u65ad\uff0c\u8868\u5355\uff1a" + formBean.getFormName() + formBean.getId() + " \u5bf9\u5e94\u6570\u636eid\uff1a" + masterId + " \u9700\u8981\u6821\u9a8c\u6267\u884c\u6570\u4e3a\uff1a" + needPreWriteActionList.size()));
        if (Strings.isNotEmpty(needPreWriteActionList)) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("affair_member_id", currentUserId);
            param.put("conditionState", conditionState.getKey());
            param.put("moduleType", moduleType);
            param.put("moduleId", moduleId);
            param.put("userId", AppContext.currentUserId());
            param.put("FormBean", formBean);
            param.put("masterBean", masterBean);
            param.put("masterId", masterBean.getId());
            param.put("flowTitle", title);
            try {
                this.doPreCheck(needPreWriteActionList, param);
            }
            catch (Exception e) {
                if (e instanceof BusinessException) {
                    String code = ((BusinessException)((Object)e)).getCode();
                    if (code.startsWith("PRE_SUBMIT")) {
                        resultVo = new FormDataStateResultVO();
                        if ("PRE_SUBMIT_LOCK".equals(code)) {
                            resultVo.setErrorMsg(ResourceUtil.getString((String)"form.business.relation.trigger.run.error24"));
                        } else {
                            resultVo.setErrorMsg(ResourceUtil.getString((String)"form.business.relation.trigger.run.error50"));
                        }
                        throw new BusinessException((Throwable)e);
                    }
                    throw new BusinessException((Throwable)e);
                }
                throw new BusinessException((Throwable)e);
            }
        }
        Long end = System.currentTimeMillis();
        LOGGER.info((Object)("\u8017\u65f6\uff1a" + (end - start)));
        return resultVo;
    }

    private synchronized void doPreCheck(List<FormTriggerActionBean> needPreWriteActionList, Map<String, Object> param) throws BusinessException {
        for (FormTriggerActionBean actionBean : needPreWriteActionList) {
            FormTriggerUtil.getTriggerActionByKey(actionBean.getType()).afterColSummarySubmit(actionBean.getFormTriggerBean(), actionBean, param);
        }
    }

    @Override
    public void rollBackWithHolding(long summaryId) throws BusinessException, SQLException {
        this.rollBackWithHolding(summaryId, null, null, null);
    }

    @Override
    public void rollBackWithHolding(long summaryId, Set<Long> recordIdList, FormBean toFormBean, Map<Long, FormDataMasterBean> beanMap) throws BusinessException, SQLException {
        List holdings = this.formWithHoldingDAO.selectWithHolding(summaryId);
        if (holdings != null && holdings.size() > 0) {
            Long masterId;
            ArrayList<FormWithholding> needDeleteHoldings = new ArrayList<FormWithholding>();
            if (recordIdList == null) {
                needDeleteHoldings.addAll(holdings);
            } else {
                for (FormWithholding f : holdings) {
                    if (!recordIdList.contains(f.getRecordId())) continue;
                    needDeleteHoldings.add(f);
                }
            }
            for (FormWithholding f : needDeleteHoldings) {
                this.formWithHoldingDAO.deleteWithHolding(summaryId, f.getFormId().longValue(), f.getPreparewriteFieldName(), f.getRecordId().longValue());
            }
            HashMap holdMap = new HashMap();
            for (FormWithholding formWithholding : needDeleteHoldings) {
                FormFieldBean ffb;
                LOGGER.info((Object)("\u9884\u63d0\u56de\u6eda\uff1aformId--" + formWithholding.getFormId() + " recordId--" + formWithholding.getRecordId() + " fieldName--" + formWithholding.getPreparewriteFieldName()));
                FormBean fb = toFormBean == null ? this.cap4FormCacheManager.getForm(formWithholding.getFormId()) : toFormBean;
                if (fb == null || (ffb = fb.getFieldBeanByName(formWithholding.getPreparewriteFieldName())) == null) continue;
                Double sumValue = this.formWithHoldingDAO.selectSumValue(formWithholding.getFormId().longValue(), formWithholding.getPreparewriteFieldName(), formWithholding.getRecordId().longValue());
                LOGGER.info((Object)(" sumValue\uff1a" + sumValue));
                String key1 = formWithholding.getFormId() + "," + ffb.getName();
                HashMap<String, Double> valueMap = (HashMap<String, Double>)holdMap.get(key1);
                if (valueMap == null) {
                    valueMap = new HashMap<String, Double>();
                    holdMap.put(key1, valueMap);
                }
                String key2 = "";
                if (!ffb.isMasterField()) {
                    List<Map<String, Object>> dList;
                    FormTableBean ftb = fb.getTableByTableName(ffb.getOwnerTableName());
                    if (ftb != null && (dList = this.cap4FormDataDAO.selectDataById(new Long[]{formWithholding.getRecordId()}, ftb, new String[]{Enums.SubTableField.formmain_id.getKey()})) != null && dList.size() == 1) {
                        masterId = Long.parseLong(dList.get(0).get(Enums.SubTableField.formmain_id.getKey()).toString());
                        key2 = masterId + "," + formWithholding.getRecordId();
                    }
                } else {
                    key2 = formWithholding.getRecordId() + ",0";
                }
                if (!Strings.isNotBlank((String)key2)) continue;
                valueMap.put(key2, sumValue);
            }
            if (holdMap.size() > 0) {
                for (Map.Entry entry : holdMap.entrySet()) {
                    Long formId = Long.valueOf(((String)entry.getKey()).split(",")[0]);
                    FormBean relFormBean = toFormBean == null ? this.cap4FormCacheManager.getForm(formId) : toFormBean;
                    String fieldName = ((String)entry.getKey()).split(",")[1];
                    FormFieldBean field = relFormBean.getFieldBeanByName(fieldName);
                    ArrayList<FormDataMasterBean> dataList = new ArrayList<FormDataMasterBean>();
                    if (entry.getValue() != null && ((Map)entry.getValue()).size() > 0) {
                        HashMap<Long, FormDataMasterBean> tempBean = new HashMap<Long, FormDataMasterBean>();
                        for (Map.Entry ent : ((Map)entry.getValue()).entrySet()) {
                            Object oldValue;
                            FormDataMasterBean newDataBean;
                            masterId = Long.valueOf(((String)ent.getKey()).split(",")[0]);
                            LOGGER.info((Object)("\u5f00\u59cb\u5237\u65b0\u56de\u6eda\u9884\u63d0\u6570\u636e\uff1a" + relFormBean.getFormName() + " " + relFormBean.getId() + " " + masterId));
                            if (tempBean.containsKey(masterId)) {
                                newDataBean = (FormDataMasterBean)tempBean.get(masterId);
                            } else {
                                newDataBean = beanMap == null ? null : beanMap.get(masterId);
                                FormDataMasterBean formDataMasterBean = newDataBean = newDataBean == null ? this.capFormDataCacheManager.get4Data(masterId, relFormBean.getId()) : newDataBean;
                                if (newDataBean == null) {
                                    LOGGER.info((Object)("\u6d41\u7a0b\uff1a" + summaryId + "\u64a4\u9500\u9884\u63d0\u4f4e\u8868\u6570\u636e\u5931\u8d25 " + relFormBean.getFormName() + relFormBean.getId() + "\uff0c\u5e95\u8868\u6570\u636e " + masterId + " \u4e0d\u5b58\u5728\u6216\u8005\u5df2\u7ecf\u88ab\u5220\u9664\uff01"));
                                    continue;
                                }
                                tempBean.put(masterId, newDataBean);
                            }
                            HashMap changeTag = new HashMap();
                            AppContext.putThreadContext((String)"fieldChangeTag", changeTag);
                            Long subId = Long.valueOf(((String)ent.getKey()).split(",")[1]);
                            if (subId != 0L) {
                                FormDataSubBean subBean = newDataBean.getFormDataSubBeanById(field.getOwnerTableName(), subId);
                                oldValue = subBean.getFieldValue(fieldName);
                                subBean.addFieldValue(fieldName, ent.getValue());
                            } else {
                                oldValue = newDataBean.getFieldValue(fieldName);
                                newDataBean.addFieldValue(fieldName, ent.getValue());
                            }
                            this.cap4FormDataManager.calcAll(relFormBean, newDataBean, null, false, false, true, false);
                            AppContext.removeThreadContext((String)"fieldChangeTag");
                            LOGGER.info((Object)("\u4fdd\u5b58\u5b8c\u6210\u5237\u65b0\u56de\u6eda\u9884\u63d0\u6570\u636e\uff1aformId--" + relFormBean.getId() + " dataId--" + masterId + ",subId--" + subId + " fieldName--" + fieldName + " \u65e7\u503c\uff1a" + oldValue + " \u65b0\u7684\u9884\u63d0\u503c\uff1a" + ent.getValue()));
                        }
                        dataList.addAll(tempBean.values());
                    }
                    this.cap4FormDataManager.insertOrUpdateMasterData(dataList, true);
                }
            }
        }
    }

    @Override
    public void getNewRecord(TriggerActionContext context, Long contentId, String desc, FormTriggerBean.TriggerState state, Collection<Long> subDataIds) throws BusinessException {
        if (Strings.isEmpty(subDataIds)) {
            this.getNewRecord(context, contentId, desc, state, 0L);
        } else {
            for (Long subId : subDataIds) {
                this.getNewRecord(context, contentId, desc, state, subId);
            }
        }
    }

    @Override
    public void getNewRecord(TriggerActionContext context, Long contentId, String desc, FormTriggerBean.TriggerState state, Long subDataId) throws BusinessException {
        FormTriggerActionContext triggerContext = (FormTriggerActionContext)context;
        FormDataMasterBean masterBean = context.getMasterBean();
        FormTriggerBean triggerBean = context.getTriggerBean();
        FormTriggerActionBean actionBean = context.getActionBean();
        if (triggerContext.isMagic()) {
            actionBean = triggerContext.getMagicAction();
        }
        CAP4FormTriggerRecord record = new CAP4FormTriggerRecord();
        record.setNewId();
        record.setSourceMasterId(masterBean.getId());
        record.setSourceSubId(subDataId);
        record.setTargetFormId(Long.valueOf(triggerBean.getTargetFormId()));
        record.setTriggerId(triggerBean.getId());
        record.setActionId(actionBean.getId());
        record.setActionType(actionBean.getType());
        record.setTriggerContentId(contentId);
        record.setTriggerContentDesc(desc);
        record.setState(Integer.valueOf(state.getKey()));
        record.setLastTriggerTime(DateUtil.currentDate());
        record.setCreateId(Long.valueOf(AppContext.currentUserId()));
        record.setTriggerJson(context.getTriggerBean().toJSon4Record());
        triggerContext.getRecords().add(record);
    }

    @Override
    public void saveLog(FormBean formBean, FormDataMasterBean masterBean, String logDesc, Enums.CapLogType type, Long operatorId, String operatorOrgName, String ipAddress) {
        try {
            BizConfigBean bizConfig = this.businessManager4.findBizConfigByFormId(formBean.getId());
            Long bizId = 0L;
            String bizName = "\u8868\u5355\u7ba1\u7406";
            if (bizConfig != null) {
                bizId = bizConfig.getId();
                bizName = bizConfig.getName();
            } else {
                LOGGER.error((Object)("\u5f53\u524d\u8868\u5355\u4e0d\u5728\u4e1a\u52a1\u5305\u5185\uff0c\u5c5e\u4e8e\u8868\u5355\u7ba1\u7406\u8868\u5355\uff0c\u8868\u5355\uff1a" + formBean.getId() + formBean.getFormName()));
            }
            this.capRunningLogManager.saveRunningLog(bizId, bizName, formBean.getId(), formBean.getFormName(), masterBean.getId(), type.getKey(), logDesc, operatorId, masterBean.getStartMemberId(), masterBean.getStartDate(), operatorOrgName, ipAddress);
        }
        catch (Exception e) {
            LOGGER.error((Object)("\u65e5\u5fd7\u8bb0\u5f55\u5f02\u5e38\uff01" + e.getMessage()), (Throwable)e);
        }
    }

    @Override
    public void saveLog(FormBean formBean, String logDesc, Enums.CapLogType type, Long operatorId, String operatorOrgName, String ipAddress) throws BusinessException {
        try {
            BizConfigBean bizConfig = this.businessManager4.findBizConfigByFormId(formBean.getId());
            Long bizId = 0L;
            String bizName = "\u8868\u5355\u7ba1\u7406";
            if (bizConfig != null) {
                bizId = bizConfig.getId();
                bizName = bizConfig.getName();
            } else {
                LOGGER.error((Object)("\u5f53\u524d\u8868\u5355\u4e0d\u5728\u4e1a\u52a1\u5305\u5185\uff0c\u5c5e\u4e8e\u8868\u5355\u7ba1\u7406\u8868\u5355\uff0c\u8868\u5355\uff1a" + formBean.getId() + formBean.getFormName()));
            }
            this.capRunningLogManager.saveRunningLog(bizId, bizName, formBean.getId(), formBean.getFormName(), 0L, type.getKey(), logDesc, operatorId, operatorId, DateUtil.currentDate(), operatorOrgName, ipAddress);
        }
        catch (Exception e) {
            LOGGER.error((Object)"\u65e5\u5fd7\u8bb0\u5f55\u5f02\u5e38\uff01", (Throwable)e);
        }
    }

    @Override
    @AjaxAccess
    public String showExecTriggerRecord(long formId, long masterId) throws BusinessException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        try {
            ArrayList resultList = new ArrayList();
            FormBean formBean = this.cap4FormCacheManager.getForm(formId);
            String tableName = FormTriggerUtil.getTriggerRecordName(formBean);
            List<CAP4FormTriggerRecord> triggerRecordList = this.cap4FormTriggerRecordDAO.getRecordListByMasterId(tableName, masterId);
            if (Strings.isNotEmpty(triggerRecordList)) {
                HashMap triggerRecordMap = new HashMap();
                for (CAP4FormTriggerRecord record : triggerRecordList) {
                    long triggerId;
                    FormTriggerBean temp;
                    if (record.getState().intValue() == FormTriggerBean.TriggerState.TRIGGER.getKey() || (temp = this.cap4FormCacheManager.getFormTriggerBean(triggerId = record.getTriggerId().longValue())) == null || !formBean.getFormTriggerIdList().contains(triggerId)) continue;
                    Strings.addToMap(triggerRecordMap, (Object)triggerId, (Object)record);
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (Map.Entry entry : triggerRecordMap.entrySet()) {
                    FormTriggerConditionBean filterCondition;
                    CAP4FormTriggerRecord tempRecord = null;
                    for (CAP4FormTriggerRecord record : (List)entry.getValue()) {
                        if (tempRecord != null && record.getLastTriggerTime().compareTo(tempRecord.getLastTriggerTime()) <= 0) continue;
                        tempRecord = record;
                    }
                    if (tempRecord == null) continue;
                    FormTriggerBean triggerBean = new FormTriggerBean(tempRecord.getTriggerJson());
                    map.put("triggerName", triggerBean.getName());
                    map.put("state", triggerBean.getState());
                    map.put("triggerType", triggerBean.getType());
                    map.put("triggerPoint", triggerBean.getTriggerPoint());
                    if (FormTriggerBean.TriggerPoint.Condition_Operation.getKey().equals(triggerBean.getTriggerPoint())) {
                        map.put("pcRight", triggerBean.getPcRight());
                        map.put("phoneRight", triggerBean.getPhoneRight());
                    }
                    if ((filterCondition = triggerBean.getFilterCondition()) == null) {
                        map.put("filterConditionValue", "");
                    } else {
                        map.put("filterConditionValue", filterCondition.getConditionFormula() == null ? "" : filterCondition.getConditionFormula().getFormulaForDisplay());
                    }
                    FormTriggerConditionBean dateCondition = triggerBean.getDateCondition();
                    if (dateCondition == null) {
                        map.put("timeQuartz", "");
                    } else {
                        map.put("timeQuartz", dateCondition.getTimeFrequency() + "|" + dateCondition.getConditionFormula().getFormulaForDisplay() + "|" + dateCondition.getTriggerTime());
                    }
                    if (FormTriggerBean.TriggerBusinessType.FormOuter.getKey().equals(triggerBean.getType()) || FormTriggerBean.TriggerBusinessType.Message.getKey().equals(triggerBean.getType()) || FormTriggerBean.TriggerBusinessType.OuterForm.getKey().equals(triggerBean.getType()) || FormTriggerBean.TriggerBusinessType.DataInterface.getKey().equals(triggerBean.getType())) {
                        ArrayList<Map> actionMapList = new ArrayList<Map>();
                        map.put("actionList", actionMapList);
                        for (FormTriggerActionBean action : triggerBean.getActionList()) {
                            Map paramMap = FormTriggerUtil.getDesignManagerByKey(action.getType()).getParamFromAction(triggerBean, action);
                            actionMapList.add(paramMap);
                        }
                    }
                    resultList.add(map);
                }
            }
            resultMap.put("recordList", resultList);
            resultMap.put("success", "true");
        }
        catch (Exception e) {
            LOGGER.error((Object)("\u83b7\u53d6\u6267\u884c\u89e6\u53d1\u8bbe\u7f6e\u5f02\u5e38:" + e.getMessage()), (Throwable)e);
            resultMap.put("success", "false");
            resultMap.put("error", "\u83b7\u53d6\u6267\u884c\u89e6\u53d1\u8bbe\u7f6e\u5f02\u5e38");
        }
        return JSONUtil.toJSONString(resultMap);
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public void setCap4FormTriggerRecordDAO(CAP4FormTriggerRecordDAO cap4FormTriggerRecordDAO) {
        this.cap4FormTriggerRecordDAO = cap4FormTriggerRecordDAO;
    }

    public void setTaskExecuteManager(TaskExecuteManager taskExecuteManager) {
        this.taskExecuteManager = taskExecuteManager;
    }

    public void setCap4FormManager(CAP4FormManager cap4FormManager) {
        this.cap4FormManager = cap4FormManager;
    }

    public void setFormWithHoldingDAO(FormWithHoldingDAO formWithHoldingDAO) {
        this.formWithHoldingDAO = formWithHoldingDAO;
    }

    public void setCap4FormDataDAO(CAP4FormDataDAO cap4FormDataDAO) {
        this.cap4FormDataDAO = cap4FormDataDAO;
    }

    public void setCap4FormDataManager(CAP4FormDataManager cap4FormDataManager) {
        this.cap4FormDataManager = cap4FormDataManager;
    }

    public void setBusinessManager4(BusinessManager businessManager4) {
        this.businessManager4 = businessManager4;
    }

    public void setCapRunningLogManager(CapRunningLogManager capRunningLogManager) {
        this.capRunningLogManager = capRunningLogManager;
    }

    public void setCapFormDataCacheManager(CAPFormDataCacheManagerImpl capFormDataCacheManager) {
        this.capFormDataCacheManager = capFormDataCacheManager;
    }

    private class UpdateQuartzJobThread
    extends Thread {
        User user;
        boolean updateQuartz;
        FormBean sourceForm;
        FormTriggerBean triggerBean;
        CAP4FormTriggerManagerImpl manager;
        CAP4FormDataDAO cap4FormDataDAO = (CAP4FormDataDAO)AppContext.getBean((String)"cap4FormDataDAO");

        private UpdateQuartzJobThread() {
        }

        @Override
        public void run() {
            ThreadInfoHolder.getInstance().initThread((Thread)this);
            AppContext.putThreadContext((String)"SESSION_CONTEXT_USERINFO_KEY", (Object)this.user);
            try {
                Date tempDate;
                Calendar c;
                Long start = System.currentTimeMillis();
                HashMap<String, String> dataMemberMap = new HashMap<String, String>();
                if (this.updateQuartz) {
                    String groupName;
                    Scheduler scheduler = QuartzListener.getScheduler();
                    Set jobNameSet = scheduler.getJobKeys(GroupMatcher.groupStartsWith((String)(groupName = this.triggerBean.getId().toString())));
                    if (jobNameSet != null && !jobNameSet.isEmpty()) {
                        for (JobKey jobKey : jobNameSet) {
                            String[] memIdArr;
                            String memIds;
                            String name = jobKey.getName();
                            JobDetail detail = scheduler.getJobDetail(JobKey.jobKey((String)name, (String)groupName));
                            if (detail == null || !Strings.isNotBlank((String)(memIds = detail.getJobDataMap().getString("userId")))) continue;
                            if (memIds.contains(",")) {
                                for (String memId : memIdArr = memIds.split(",")) {
                                    String[] tempArr = memId.split("_");
                                    dataMemberMap.put(groupName + tempArr[0], tempArr[tempArr.length - 1]);
                                }
                                continue;
                            }
                            if (memIds.contains("_")) {
                                memIdArr = memIds.split("_");
                                dataMemberMap.put(groupName + memIdArr[0], memIdArr[memIdArr.length - 1]);
                                continue;
                            }
                            dataMemberMap.put(groupName + name, memIds);
                        }
                    }
                    QuartzHolder.deleteQuartzJobByGroup((String)groupName);
                }
                LOGGER.info((Object)("\u4e1a\u52a1\u5173\u7cfb\uff1a" + this.triggerBean.getId() + this.triggerBean.getName() + " \u66f4\u65b0\u65f6\u95f4\u8c03\u5ea6\u5f00\u59cb"));
                FormTriggerConditionBean dateCondition = this.triggerBean.getDateCondition();
                if (dateCondition == null || dateCondition.getConditionFormula() == null || Strings.isBlank((String)dateCondition.getConditionFormula().getExecuteFormulaForGroove())) {
                    LOGGER.info((Object)("\u5f53\u524d\u89e6\u53d1\u4e0d\u5b58\u5728\u8c03\u5ea6\u8bbe\u7f6e" + this.triggerBean.getId()));
                    return;
                }
                String formulaStr = dateCondition.getConditionFormula().getExecuteFormulaForGroove();
                LOGGER.info((Object)("\u89e6\u53d1--\u6642\u95931: " + formulaStr));
                Date date = null;
                FormTriggerBean.TimeFrequency timeFrequency = null;
                if (formulaStr.contains("SpecifiedTime")) {
                    Matcher m = datePattern.matcher(formulaStr);
                    m.find();
                    String dateStr = m.group();
                    date = Datetimes.parse((String)dateStr, (String)"yyyy-MM-dd");
                    timeFrequency = FormTriggerBean.TimeFrequency.getEnumByKey((String)dateCondition.getTimeFrequency());
                } else if (formulaStr.contains(FormTriggerBean.TimeFrequency.PerMonthBegin.getKey())) {
                    date = Datetimes.getFirstDayInMonth((Date)new Date());
                    timeFrequency = FormTriggerBean.TimeFrequency.PerMonthBegin;
                } else if (formulaStr.contains(FormTriggerBean.TimeFrequency.PerMonthEnd.getKey())) {
                    date = Datetimes.getLastDayInMonth((Date)new Date());
                    timeFrequency = FormTriggerBean.TimeFrequency.PerMonthEnd;
                } else if (formulaStr.contains(FormTriggerBean.TimeFrequency.PerSeasonBegin.getKey())) {
                    date = Datetimes.getFirstDayInSeason((Date)new Date());
                    timeFrequency = FormTriggerBean.TimeFrequency.PerSeasonBegin;
                } else if (formulaStr.contains(FormTriggerBean.TimeFrequency.PerSeasonEnd.getKey())) {
                    date = Datetimes.getLastDayInSeason((Date)new Date());
                    timeFrequency = FormTriggerBean.TimeFrequency.PerSeasonEnd;
                } else if (formulaStr.contains(FormTriggerBean.TimeFrequency.PerHalfYearBegin.getKey())) {
                    c = Calendar.getInstance();
                    int month = c.get(2);
                    c.set(5, 1);
                    if (month <= 5) {
                        c.set(2, 1);
                        tempDate = c.getTime();
                    } else {
                        c.set(2, 7);
                        tempDate = c.getTime();
                    }
                    date = Datetimes.getFirstDayInSeason((Date)tempDate);
                    timeFrequency = FormTriggerBean.TimeFrequency.PerHalfYearBegin;
                } else if (formulaStr.contains(FormTriggerBean.TimeFrequency.PerHalfYearEnd.getKey())) {
                    c = Calendar.getInstance();
                    int month = c.get(2);
                    c.set(5, 1);
                    if (month <= 5) {
                        c.set(2, 4);
                        tempDate = c.getTime();
                    } else {
                        c.set(2, 10);
                        tempDate = c.getTime();
                    }
                    date = Datetimes.getLastDayInSeason((Date)tempDate);
                    timeFrequency = FormTriggerBean.TimeFrequency.PerHalfYearEnd;
                } else if (formulaStr.contains(FormTriggerBean.TimeFrequency.PerYearBegin.getKey())) {
                    date = Datetimes.getFirstDayInYear((Date)new Date());
                    timeFrequency = FormTriggerBean.TimeFrequency.PerYearBegin;
                } else if (formulaStr.contains(FormTriggerBean.TimeFrequency.PerYearEnd.getKey())) {
                    date = Datetimes.getLastDayInYear((Date)new Date());
                    timeFrequency = FormTriggerBean.TimeFrequency.PerYearEnd;
                }
                HashMap allDataJobParamMap = new HashMap();
                FlipInfo fi = new FlipInfo();
                fi.setSize(900);
                int count = this.cap4FormDataDAO.selectDataCount(this.sourceForm.getMasterTableBean().getTableName());
                fi.setTotal(count);
                int page = fi.getPages();
                for (int i = 1; i <= page; ++i) {
                    fi.setPage(i);
                    List<FormDataMasterBean> dataList = this.cap4FormDataDAO.selectMasterDataList(this.sourceForm, fi);
                    timeFrequency = CAP4FormTriggerManagerImpl.this.analysisTimeSet(allDataJobParamMap, this.sourceForm, dateCondition, formulaStr, timeFrequency, date, dataList, dataMemberMap);
                }
                String moduleType = this.sourceForm.isFlowForm() ? ModuleType.cap4Form.getKey() + "" : ModuleType.cap4UnflowForm.getKey() + "";
                for (Map.Entry entry : allDataJobParamMap.entrySet()) {
                    Map jobParam = (Map)entry.getValue();
                    jobParam.put("moduleType", moduleType);
                    jobParam.put("formId", String.valueOf(this.sourceForm.getId()));
                    jobParam.put("triggerId", String.valueOf(this.triggerBean.getId()));
                    if (FormTriggerBean.TimeFrequency.PerYearBegin == timeFrequency || FormTriggerBean.TimeFrequency.PerYearEnd == timeFrequency) {
                        timeFrequency = FormTriggerBean.TimeFrequency.year;
                    }
                    CAP4FormTriggerManagerImpl.this.addQuartzJob(String.valueOf(this.triggerBean.getId()), (String)jobParam.get("triggerJobName"), Datetimes.parse((String)((String)entry.getKey()), (String)"yyyy-MM-dd HH:mm:ss"), jobParam, timeFrequency);
                }
                Long end = System.currentTimeMillis();
                LOGGER.info((Object)("\u66f4\u65b0\u65f6\u95f4\u8c03\u5ea6\u7ed3\u675f " + this.triggerBean.getName() + " \u8017\u65f6:" + (end - start)));
            }
            catch (Exception e) {
                LOGGER.error((Object)"\u66f4\u65b0\u65f6\u95f4\u8c03\u5ea6\u53d1\u751f\u9519\u8bef", (Throwable)e);
            }
            ThreadInfoHolder.getInstance().remove((Thread)this);
        }
    }
}

