/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.engin.trigger;

import com.seeyon.cap4.form.modules.engin.trigger.CAP4FormTriggerRecordDAO;
import com.seeyon.cap4.form.po.CAP4FormTriggerRecord;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.JDBCAgent;
import com.seeyon.ctp.util.Strings;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.hibernate.dialect.Dialect;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.PrimaryKey;

public class CAP4FormTriggerRecordDAOImpl
implements CAP4FormTriggerRecordDAO {
    private static final Log LOGGER = CtpLogFactory.getLog(CAP4FormTriggerRecordDAOImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createTriggerRecordTable(String tableName) throws BusinessException {
        if (this.hasRecordTable(tableName)) {
            LOGGER.warn((Object)("\u5df2\u5b58\u5728\u6b64\u89e6\u53d1\u8bb0\u5f55\u8868\uff0c\u4e0d\u5728\u65b0\u5efa" + tableName));
            return;
        }
        JDBCAgent jdbc = null;
        try {
            jdbc = new JDBCAgent(true);
            Dialect dialect = jdbc.getDialect();
            String jsonType = dialect.getTypeName(12);
            if (JDBCAgent.isOracleRuntime() || JDBCAgent.isDMRuntime() || JDBCAgent.isKingBaseesRunTime()) {
                jsonType = dialect.getTypeName(2005);
            } else if (JDBCAgent.isSQLServerRuntime()) {
                jsonType = "ntext";
            } else if (JDBCAgent.isPostgreSQLRuntime()) {
                jsonType = "text";
            }
            StringBuilder createSql = new StringBuilder();
            createSql.append(dialect.getCreateTableString()).append(" ").append(tableName).append(" (\r\t");
            createSql.append("ID ").append(dialect.getTypeName(-5)).append(" not null").append(",\r\t");
            createSql.append(" SOURCE_MASTER_ID ").append(dialect.getTypeName(-5)).append(" not null").append(",\r\t");
            createSql.append(" SOURCE_SUB_ID ").append(dialect.getTypeName(-5)).append(" null").append(",\r\t");
            createSql.append(" TARGET_FORM_ID ").append(dialect.getTypeName(-5)).append(" null").append(",\r\t");
            createSql.append(" STATE ").append(dialect.getTypeName(4, 0, 4, 0)).append(" null").append(",\r\t");
            createSql.append(" LAST_TRIGGER_TIME ").append(dialect.getTypeName(93, 7, 0, 0)).append(" null").append(",\r\t");
            createSql.append(" TRIGGER_ID ").append(dialect.getTypeName(-5)).append(" null").append(",\r\t");
            createSql.append(" ACTION_ID ").append(dialect.getTypeName(-5)).append(" null").append(",\r\t");
            createSql.append(" TRIGGER_JSON ").append(jsonType).append(" null").append(",\r\t");
            createSql.append(" ACTION_TYPE ").append(dialect.getTypeName(12, 50, 0, 0)).append(" null").append(",\r\t");
            createSql.append(" TRIGGER_CONTENT_ID ").append(dialect.getTypeName(-5)).append(" null").append(",\r\t");
            createSql.append(" TRIGGER_CONTENT_DESC ").append(jsonType).append(" null").append(",\r\t");
            createSql.append(" CREATE_ID ").append(dialect.getTypeName(-5)).append(" null").append(",\r\t");
            PrimaryKey pk = new PrimaryKey();
            pk.addColumn(new Column("ID"));
            createSql.append(pk.sqlConstraintString(dialect));
            createSql.append(")");
            StringBuilder indexSql1 = new StringBuilder();
            indexSql1.append("CREATE INDEX ").append(" IDX_").append(tableName).append("_1 on ").append(tableName);
            indexSql1.append(" (").append("SOURCE_MASTER_ID").append(")");
            StringBuilder indexSql2 = new StringBuilder();
            indexSql2.append("CREATE INDEX ").append(" IDX_").append(tableName).append("_2 on ").append(tableName);
            indexSql2.append(" (").append("SOURCE_MASTER_ID, TRIGGER_ID, ACTION_ID").append(")");
            StringBuilder indexSql3 = new StringBuilder();
            indexSql3.append("CREATE INDEX ").append(" IDX_").append(tableName).append("_3 on ").append(tableName);
            indexSql3.append(" (").append("TRIGGER_ID, TRIGGER_CONTENT_ID, ACTION_TYPE").append(")");
            ArrayList<String> sqlList = new ArrayList<String>();
            sqlList.add(createSql.toString());
            sqlList.add(indexSql1.toString());
            sqlList.add(indexSql2.toString());
            sqlList.add(indexSql3.toString());
            jdbc.executeBatch(sqlList);
            LOGGER.info((Object)("\u521b\u5efa\u89e6\u53d1\u8bb0\u5f55\u8868\u6210\u529f\uff01" + tableName));
        }
        catch (Exception e) {
            LOGGER.error((Object)("\u521b\u5efa\u89e6\u53d1\u8bb0\u5f55\u8868\u5f02\u5e38\uff1a" + e.getMessage()), (Throwable)e);
        }
        finally {
            if (jdbc != null) {
                jdbc.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasRecordTable(String tableName) {
        boolean flag = false;
        String sql = "";
        if (JDBCAgent.isMySQLRuntime()) {
            JDBCAgent jdbc = null;
            sql = " select count(id) from " + tableName;
            try {
                jdbc = new JDBCAgent(true);
                jdbc.execute(sql);
                flag = true;
            }
            catch (Exception e) {
                LOGGER.info((Object)"\u4e0d\u5b58\u5728\u8868");
            }
            finally {
                if (jdbc != null) {
                    jdbc.close();
                }
            }
        } else {
            if (JDBCAgent.isSQLServerRuntime()) {
                sql = "select name from sysobjects where type='U' and name = '" + tableName + "'";
            } else if (JDBCAgent.isOracleRuntime() || JDBCAgent.isDMRuntime() || JDBCAgent.isKingBaseesRunTime()) {
                sql = "select table_name from user_tables where table_name = '" + tableName + "'";
            } else if (JDBCAgent.isPostgreSQLRuntime()) {
                sql = "select table_name from information_schema.tables where table_name = '" + Strings.lowerCase((String)tableName) + "'";
            }
            JDBCAgent jdbc = null;
            try {
                jdbc = new JDBCAgent(true);
                jdbc.execute(sql);
                if (Strings.isNotEmpty((Collection)jdbc.resultSetToList())) {
                    flag = true;
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)e);
            }
            finally {
                if (jdbc != null) {
                    jdbc.close();
                }
            }
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropRecordTable(String tableName) throws BusinessException {
        JDBCAgent jdbc = null;
        try {
            jdbc = new JDBCAgent(true);
            String sql = "DROP TABLE " + tableName;
            jdbc.execute(sql);
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
        }
        finally {
            if (jdbc != null) {
                jdbc.close();
            }
        }
    }

    @Override
    public List<CAP4FormTriggerRecord> getRecordListByMasterId(String tableName, long masterId) throws BusinessException {
        String sql = "select * from " + tableName + " where source_master_id = " + masterId;
        return this.getRecordList(sql);
    }

    @Override
    public List<CAP4FormTriggerRecord> getRecordList(String tableName, long masterId, long triggerId) throws BusinessException {
        StringBuilder sql = new StringBuilder();
        sql.append("select * from ").append(tableName).append(" where ");
        sql.append(" source_master_id = ").append(masterId);
        sql.append(" and trigger_id = ").append(triggerId);
        return this.getRecordList(sql.toString());
    }

    @Override
    public List<CAP4FormTriggerRecord> getRecordList(String tableName, long masterId, long triggerId, long actionId) throws BusinessException {
        StringBuilder sql = new StringBuilder();
        sql.append("select * from ").append(tableName).append(" where ");
        sql.append(" source_master_id = ").append(masterId);
        sql.append(" and trigger_id = ").append(triggerId);
        sql.append(" and action_id = ").append(actionId);
        return this.getRecordList(sql.toString());
    }

    @Override
    public List<CAP4FormTriggerRecord> getRecordList(String tableName, long triggerId, long contentId, String actionType) throws BusinessException {
        StringBuilder sql = new StringBuilder();
        sql.append("select * from ").append(tableName).append(" where ");
        sql.append(" trigger_id = ").append(triggerId);
        sql.append(" and trigger_content_id = ").append(contentId);
        sql.append(" and action_type = '").append(actionType).append("'");
        return this.getRecordList(sql.toString());
    }

    @Override
    public List<CAP4FormTriggerRecord> getRecordList(String tableName, long contentId, String actionType) throws BusinessException {
        StringBuilder sql = new StringBuilder();
        sql.append("select * from ").append(tableName).append(" where ");
        sql.append(" trigger_content_id = ").append(contentId);
        sql.append(" and action_type = '").append(actionType).append("'");
        return this.getRecordList(sql.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CAP4FormTriggerRecord> getRecordList(String sql) {
        ArrayList<CAP4FormTriggerRecord> recordList = new ArrayList<CAP4FormTriggerRecord>();
        JDBCAgent jdbc = null;
        try {
            jdbc = new JDBCAgent();
            jdbc.execute(sql);
            List result = jdbc.resultSetToList();
            for (Map map : result) {
                CAP4FormTriggerRecord record = new CAP4FormTriggerRecord(map);
                recordList.add(record);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (jdbc != null) {
                jdbc.close();
            }
        }
        return recordList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Long> getTriggeredSubDataIds(String tableName, long masterId, long triggerId, int triggerState) throws BusinessException {
        String sql = "select source_sub_id from " + tableName + " where source_master_id = " + masterId + " and trigger_id = " + triggerId + " and state = " + triggerState;
        ArrayList<Long> list = new ArrayList<Long>();
        JDBCAgent jdbc = null;
        try {
            jdbc = new JDBCAgent();
            jdbc.execute(sql);
            List result = jdbc.resultSetToList();
            for (Map map : result) {
                for (Map.Entry row : map.entrySet()) {
                    Object obj = row.getValue();
                    if (obj instanceof BigDecimal) {
                        list.add(((BigDecimal)obj).longValue());
                        continue;
                    }
                    list.add((Long)obj);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (jdbc != null) {
                jdbc.close();
            }
        }
        return list;
    }

    @Override
    public int delete(String tableName, Long recordId) throws BusinessException {
        return this.delete(tableName, new Long[]{recordId});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int delete(String tableName, Long[] recordIds) throws BusinessException {
        if (recordIds == null || recordIds.length == 0) {
            return 0;
        }
        int count = 0;
        JDBCAgent jdbc = new JDBCAgent();
        try {
            String sql = "delete from " + tableName + " where id =  ?";
            jdbc.batch1Prepare(sql);
            for (Long id : recordIds) {
                if (id == null) continue;
                ArrayList<Long> ids = new ArrayList<Long>(1);
                ids.add(id);
                jdbc.batch2Add(ids);
            }
            count = jdbc.batch3Execute();
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
        }
        finally {
            jdbc.close();
        }
        return count;
    }

    @Override
    public int saveOrUpdate(String tableName, CAP4FormTriggerRecord record) throws BusinessException {
        this.delete(tableName, record.getId());
        ArrayList<CAP4FormTriggerRecord> list = new ArrayList<CAP4FormTriggerRecord>();
        list.add(record);
        return this.saveAll(tableName, list);
    }

    @Override
    public int saveOrUpdate(String tableName, List<CAP4FormTriggerRecord> recordList) throws BusinessException {
        LOGGER.info((Object)("\u5f00\u59cb\u4fdd\u5b58\u6267\u884c\u8bb0\u5f55 " + tableName));
        Long[] recordIds = this.getRecordListId(recordList);
        if (recordIds == null) {
            return 0;
        }
        this.delete(tableName, recordIds);
        return this.saveAll(tableName, recordList);
    }

    private Long[] getRecordListId(List<CAP4FormTriggerRecord> recordList) {
        if (Strings.isEmpty(recordList)) {
            return null;
        }
        Long[] recordIds = new Long[recordList.size()];
        for (int i = 0; i < recordList.size(); ++i) {
            recordIds[i] = recordList.get(i).getId();
        }
        return recordIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int saveAll(String tableName, List<CAP4FormTriggerRecord> recordList) throws BusinessException {
        LOGGER.info((Object)("\u6267\u884c\u8bb0\u5f55\u8868\uff1a" + tableName));
        if (Strings.isEmpty(recordList)) {
            return 0;
        }
        StringBuilder fieldNames = new StringBuilder();
        StringBuilder ps = new StringBuilder();
        Set keys = CAP4FormTriggerRecord.getKeySet();
        int count = 0;
        for (String string : keys) {
            String splitStr = ++count == keys.size() ? "" : ",";
            fieldNames.append(string).append(splitStr);
            ps.append("?").append(splitStr);
        }
        JDBCAgent jdbc = new JDBCAgent();
        String sql = "insert into " + tableName + " (" + fieldNames.toString() + ") values (" + ps.toString() + ")";
        LOGGER.info((Object)("\u63d2\u5165\u6267\u884c\u8bb0\u5f55sql : " + sql));
        try {
            jdbc.batch1Prepare(sql);
            for (CAP4FormTriggerRecord record : recordList) {
                Map rowDataMap = record.getValueMap2DB();
                ArrayList values = new ArrayList();
                for (String string : keys) {
                    values.add(rowDataMap.get(string));
                }
                jdbc.batch2Add(values);
            }
            count = jdbc.batch3Execute();
            LOGGER.info((Object)("\u63d2\u5165\u6267\u884c\u8bb0\u5f55 count = " + count));
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
        }
        finally {
            jdbc.close();
        }
        return count;
    }
}

