/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.engin.trigger;

import com.seeyon.cap4.form.bean.FormDataMasterBean;
import com.seeyon.cap4.form.bean.FormTriggerActionBean;
import com.seeyon.cap4.form.bean.FormTriggerBean;
import com.seeyon.cap4.form.bean.FormTriggerConditionBean;
import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.cap4.form.modules.business.BusinessManager;
import com.seeyon.cap4.form.modules.engin.base.formData.CAP4FormDataDAO;
import com.seeyon.cap4.form.modules.engin.base.formData.CAPFormDataCacheManagerImpl;
import com.seeyon.cap4.form.modules.engin.trigger.CAP4FormTriggerEventDAO;
import com.seeyon.cap4.form.modules.engin.trigger.CAP4FormTriggerManager;
import com.seeyon.cap4.form.modules.engin.trigger.CAP4FormTriggerTaskDAO;
import com.seeyon.cap4.form.modules.engin.trigger.CAP4FormTriggerTaskEventManager;
import com.seeyon.cap4.form.modules.engin.trigger.FormTriggerBaseAction;
import com.seeyon.cap4.form.modules.engin.trigger.FormTriggerUtil;
import com.seeyon.cap4.form.modules.engin.trigger.TriggerTaskEvent;
import com.seeyon.cap4.form.modules.history.CapFormTriggerEventHistoryManager;
import com.seeyon.cap4.form.po.CAP4FormTriggerRecord;
import com.seeyon.cap4.form.po.CAPFormTriggerEvent;
import com.seeyon.cap4.form.po.CAPFormTriggerTask;
import com.seeyon.cap4.form.po.CapFormTriggerTaskHistory;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.magic.dao.IMagicInterfaceDefineDao;
import com.seeyon.cap4.magic.po.MagicInterfaceDefineEntity;
import com.seeyon.cap4.task.Task;
import com.seeyon.cap4.task.TaskEvent;
import com.seeyon.cap4.task.TaskEventManager;
import com.seeyon.cap4.task.vo.CAPFormTriggerTaskVO;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.authenticate.domain.User;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.lock.manager.LockManager;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.BasePO;
import com.seeyon.ctp.form.bean.FormBean;
import com.seeyon.ctp.form.modules.trigger.FormTriggerEventObject;
import com.seeyon.ctp.form.modules.trigger.FormTriggerTask;
import com.seeyon.ctp.form.modules.trigger.FormTriggerTaskObject;
import com.seeyon.ctp.form.service.FormCacheManager;
import com.seeyon.ctp.organization.manager.OrgManager;
import com.seeyon.ctp.util.BeanUtils;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.json.JSONUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;

public class CAP4FormTriggerTaskEventManagerImpl
implements CAP4FormTriggerTaskEventManager,
TaskEventManager {
    private static final Log LOGGER = CtpLogFactory.getLog(CAP4FormTriggerTaskEventManagerImpl.class);
    private LockManager lockManager;
    private CAP4FormCacheManager cap4FormCacheManager;
    private FormCacheManager formCacheManager;
    private BusinessManager businessManager4;
    private CAP4FormTriggerEventDAO cap4FormTriggerEventDAO;
    private CAP4FormTriggerTaskDAO cap4FormTriggerTaskDAO;
    private CAP4FormTriggerManager cap4FormTriggerManager;
    private OrgManager orgManager;
    private CAP4FormDataDAO cap4FormDataDAO;
    private IMagicInterfaceDefineDao magicInterfaceDefineDao;
    private CAPFormDataCacheManagerImpl capFormDataCacheManager;
    private CapFormTriggerEventHistoryManager capFormTriggerEventHistoryManager;

    public void setFormCacheManager(FormCacheManager formCacheManager) {
        this.formCacheManager = formCacheManager;
    }

    public void setMagicInterfaceDefineDao(IMagicInterfaceDefineDao magicInterfaceDefineDao) {
        this.magicInterfaceDefineDao = magicInterfaceDefineDao;
    }

    public void setOrgManager(OrgManager orgManager) {
        this.orgManager = orgManager;
    }

    public void setBusinessManager4(BusinessManager businessManager4) {
        this.businessManager4 = businessManager4;
    }

    public void setLockManager(LockManager lockManager) {
        this.lockManager = lockManager;
    }

    public void setCap4FormTriggerTaskDAO(CAP4FormTriggerTaskDAO cap4FormTriggerTaskDAO) {
        this.cap4FormTriggerTaskDAO = cap4FormTriggerTaskDAO;
    }

    public void setCap4FormDataDAO(CAP4FormDataDAO cap4FormDataDAO) {
        this.cap4FormDataDAO = cap4FormDataDAO;
    }

    public void setCap4FormTriggerEventDAO(CAP4FormTriggerEventDAO cap4FormTriggerEventDAO) {
        this.cap4FormTriggerEventDAO = cap4FormTriggerEventDAO;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public void setCap4FormTriggerManager(CAP4FormTriggerManager cap4FormTriggerManager) {
        this.cap4FormTriggerManager = cap4FormTriggerManager;
    }

    public void setCapFormDataCacheManager(CAPFormDataCacheManagerImpl capFormDataCacheManager) {
        this.capFormDataCacheManager = capFormDataCacheManager;
    }

    public void setCapFormTriggerEventHistoryManager(CapFormTriggerEventHistoryManager capFormTriggerEventHistoryManager) {
        this.capFormTriggerEventHistoryManager = capFormTriggerEventHistoryManager;
    }

    @Override
    public boolean addEvent(TaskEvent event) throws BusinessException {
        try {
            CAPFormTriggerEvent triggerEvent = (CAPFormTriggerEvent)event;
            LOGGER.info((Object)("\u4fdd\u5b58\u89e6\u53d1\u4e8b\u4ef6 \u8868\u5355\uff1a" + triggerEvent.getFormId() + triggerEvent.getFormName() + "  \u6570\u636e\uff1a" + triggerEvent.getMasterId()));
            this.cap4FormTriggerEventDAO.save(triggerEvent);
        }
        catch (Exception e) {
            LOGGER.error((Object)"\u4fdd\u5b58\u89e6\u53d1\u4e8b\u4ef6\u5f02\u5e38\uff01", (Throwable)e);
            throw new BusinessException((Throwable)e);
        }
        return true;
    }

    @Override
    public int getPendingEventCount() throws BusinessException {
        return this.cap4FormTriggerEventDAO.countByState(0);
    }

    @Override
    public List<TaskEvent> getPendingEvent() throws BusinessException {
        List<CAPFormTriggerEvent> triggerEvents = this.cap4FormTriggerEventDAO.getRecords(0);
        ArrayList<TaskEvent> taskEvents = new ArrayList<TaskEvent>();
        taskEvents.addAll(triggerEvents);
        return taskEvents;
    }

    @Override
    public List<Task> eventTransferTask(TaskEvent event) throws BusinessException {
        ArrayList<Task> tasks = new ArrayList<Task>();
        if (!this.checkAndLock(-1L, event.getId())) {
            LOGGER.info((Object)("\u5f53\u524d\u4e8b\u4ef6\u88ab\u5176\u4ed6\u7ebf\u7a0b\u6267\u884c\uff0c\u5df2\u88ab\u9501\u4f4f\uff0c\u5f53\u524d\u7ebf\u7a0b\u8df3\u8fc7\u6b64\u4e8b\u4ef6\uff0cevent:" + event.getId()));
            return tasks;
        }
        try {
            CAPFormTriggerEvent triggerEvent = (CAPFormTriggerEvent)event;
            FormTriggerUtil.addCurrentUser4TriggerAction(triggerEvent.getUserId());
            List<CAPFormTriggerTask> triggerTasks = this.addExecuteAction(triggerEvent);
            if (Strings.isNotEmpty(triggerTasks)) {
                tasks.addAll(triggerTasks);
            }
            this.cap4FormTriggerEventDAO.updateState(triggerEvent.getId(), 1);
            this.capFormTriggerEventHistoryManager.saveHistoryByEvent(triggerEvent);
        }
        catch (SQLException e) {
            LOGGER.error((Object)"\u4e8b\u4ef6\u4efb\u52a1\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
            throw new BusinessException("\u4e8b\u4ef6\u4efb\u52a1\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
        }
        finally {
            this.lockManager.unlock(-1L, event.getId().longValue(), -1);
        }
        return tasks;
    }

    private List<CAPFormTriggerTask> addExecuteAction(CAPFormTriggerEvent event) throws BusinessException, SQLException {
        com.seeyon.cap4.form.bean.FormBean formBean = this.cap4FormCacheManager.getForm(event.getFormId());
        if (formBean == null || !formBean.isEnabled()) {
            LOGGER.warn((Object)" \u8868\u5355\u88ab\u5220\u9664\u6216\u8005\u88ab\u505c\u7528\uff0c\u89e6\u53d1\u52a8\u4f5c\u4e0d\u6267\u884c");
            return null;
        }
        FormDataMasterBean masterBean = this.capFormDataCacheManager.get4Data(event.getMasterId(), formBean.getId());
        if (masterBean == null) {
            masterBean = this.cap4FormDataDAO.selectDataByMasterId(event.getMasterId(), formBean, null);
        }
        if (masterBean == null) {
            LOGGER.warn((Object)" \u5b9e\u4f53\u6570\u636e\u5df2\u7ecf\u88ab\u5220\u9664\uff0c\u89e6\u53d1\u52a8\u4f5c\u4e0d\u6267\u884c");
            return null;
        }
        Enums.FormType formType = Enums.FormType.getEnumByKey((int)formBean.getFormType());
        if (formType != null && formType.isFlowForm() && masterBean.getState() <= 0) {
            LOGGER.warn((Object)" \u5b9e\u4f53\u6570\u636e\u72b6\u6001\u4e3a\u8349\u7a3f\u6216\u8005\u5176\u4ed6\u975e\u6b63\u5f0f\u6d41\u8f6c\u6570\u636e\u72b6\u6001\uff0c\u89e6\u53d1\u52a8\u4f5c\u4e0d\u6267\u884c");
            return null;
        }
        Map param = (Map)JSONUtil.parseJSONString((String)event.getExtendAttr());
        int moduleType = event.getModuleType();
        long moduleId = event.getModuleId();
        param.put("moduleType", moduleType);
        param.put("moduleId", moduleId);
        param.put("masterId", masterBean.getId());
        param.put("conditionState", event.getConditionState());
        List<FormTriggerBean> triggerList = this.cap4FormTriggerManager.getNeedExecTriggerList(formBean, masterBean.getId());
        LOGGER.info((Object)("\u8868\u5355\uff1a" + formBean.getFormName() + " \u6570\u636e\uff1a" + masterBean.getId() + "\u9700\u8981\u6267\u884c\u6570\uff1a" + triggerList.size()));
        List<CAPFormTriggerTask> triggerTasks = new LinkedList<CAPFormTriggerTask>();
        ArrayList<CAP4FormTriggerRecord> records = new ArrayList<CAP4FormTriggerRecord>();
        LinkedList<FormTriggerBean> needExecList = new LinkedList<FormTriggerBean>();
        for (FormTriggerBean triggerBean : triggerList) {
            boolean afterDis2Feed;
            if (!triggerBean.isEnable()) {
                LOGGER.info((Object)(triggerBean.getName() + " \u88ab\u7981\u7528"));
                continue;
            }
            LOGGER.info((Object)("\u52a8\u4f5c\uff1a" + triggerBean.getName()));
            if (formBean.isFlowForm()) {
                this.addTempTriggerRecord(triggerBean, masterBean.getId(), records);
                if (param.get("conditionState") == null) continue;
                FormTriggerBean.TriggerPoint flowState2 = FormTriggerBean.TriggerPoint.getEnumByKey((String)String.valueOf(param.get("conditionState")));
                LOGGER.info((Object)(moduleId + "\u6d41\u7a0b\u8282\u70b9\u72b6\u6001\uff1a" + flowState2.getText()));
                if (triggerBean.isMatchCondition(masterBean) && (triggerBean.isConditionFirstMet() || triggerBean.isMatchTriggerPoint(masterBean, flowState2))) {
                    needExecList.add(triggerBean);
                    continue;
                }
                LOGGER.info((Object)(moduleId + "\u6761\u4ef6\u4e0d\u6ee1\u8db3"));
                continue;
            }
            boolean bl = afterDis2Feed = param.containsKey("sourceTriggerId") && triggerBean.getId().equals(Long.valueOf(param.get("sourceTriggerId").toString()));
            if (afterDis2Feed) {
                LOGGER.error((Object)"\u521a\u6267\u884c\u5b8c\u540c\u6b65\u66f4\u65b0\u65b0\u5efa/\u66f4\u65b0\u6216\u8005\u53cd\u9988\uff0c\u6b64\u540c\u6b65\u66f4\u65b0\u65b0\u5efa/\u66f4\u65b0\u6216\u8005\u53cd\u9988\u5148\u4e0d\u6267\u884c!");
                continue;
            }
            if (triggerBean.getTargetFormId() == formBean.getId().longValue()) {
                needExecList.add(triggerBean);
                continue;
            }
            if (triggerBean.isMatchCondition(masterBean, String.valueOf(param.get("rightStr")))) {
                if (triggerBean.hasTimeCondition()) {
                    this.addQuartzJob(event, moduleType, moduleId, formBean, masterBean, triggerBean);
                    continue;
                }
                needExecList.add(triggerBean);
                continue;
            }
            LOGGER.info((Object)(moduleId + "\u6761\u4ef6\u4e0d\u6ee1\u8db3"));
        }
        if (Strings.isNotEmpty(records)) {
            this.cap4FormTriggerManager.saveOrUpdate(formBean, records);
        }
        LOGGER.info((Object)("\u9700\u8981\u6267\u884c\u6570\uff1a" + needExecList.size()));
        if (Strings.isNotEmpty(needExecList)) {
            triggerTasks = this.convertTrigger2Task(event, param, needExecList, formBean);
        }
        return triggerTasks;
    }

    private void addTempTriggerRecord(FormTriggerBean triggerBean, Long dataId, List<CAP4FormTriggerRecord> records) throws BusinessException {
        if (triggerBean.isInitFromRecord()) {
            return;
        }
        CAP4FormTriggerRecord record = new CAP4FormTriggerRecord();
        record.setNewId();
        record.setSourceMasterId(dataId);
        record.setSourceSubId(Long.valueOf(0L));
        record.setTargetFormId(Long.valueOf(triggerBean.getTargetFormId()));
        record.setTriggerId(triggerBean.getId());
        record.setActionId(Long.valueOf(0L));
        record.setActionType("");
        record.setTriggerContentId(Long.valueOf(0L));
        record.setTriggerContentDesc("");
        record.setState(Integer.valueOf(FormTriggerBean.TriggerState.TRIGGER.getKey()));
        record.setLastTriggerTime(DateUtil.currentDate());
        record.setCreateId(Long.valueOf(AppContext.currentUserId()));
        record.setTriggerJson(triggerBean.toJSon4Record());
        records.add(record);
    }

    private void addQuartzJob(CAPFormTriggerEvent event, int moduleType, long moduleId, com.seeyon.cap4.form.bean.FormBean formBean, FormDataMasterBean masterBean, FormTriggerBean triggerBean) {
        try {
            FormTriggerConditionBean dateCondition = triggerBean.getDateCondition();
            HashMap<String, String> jobParam = new HashMap<String, String>();
            jobParam.put("moduleType", "" + moduleType);
            jobParam.put("moduleId", "" + moduleId);
            jobParam.put("triggerId", "" + triggerBean.getId());
            jobParam.put("formId", "" + formBean.getId());
            jobParam.put("masterId", "" + masterBean.getId());
            jobParam.put("userId", event.getUserId() + "");
            FormTriggerUtil.addCurrentUser4TriggerAction(event.getUserId());
            this.cap4FormTriggerManager.addTriggerQuartzJob(jobParam, masterBean, dateCondition);
        }
        catch (Exception e) {
            LOGGER.error((Object)("\u89e6\u53d1/\u56de\u5199\u8c03\u8bd5\uff1a" + moduleId + "\u89e6\u53d1\u52a0\u5165\u65f6\u95f4\u8c03\u5ea6\u5f02\u5e38"), (Throwable)e);
        }
    }

    private List<CAPFormTriggerTask> convertTrigger2Task(CAPFormTriggerEvent event, Map<String, Object> param, List<FormTriggerBean> triggerBeans, com.seeyon.cap4.form.bean.FormBean formBean) throws BusinessException {
        LinkedList<CAPFormTriggerTask> triggerTasks = new LinkedList<CAPFormTriggerTask>();
        for (FormTriggerBean triggerBean : triggerBeans) {
            FormTriggerBean.TriggerBusinessType businessType = FormTriggerBean.TriggerBusinessType.getEnumByKey((String)triggerBean.getType());
            String triggerJson = triggerBean.toJSon4Record();
            BizConfigBean bizConfigBean = this.businessManager4.findBizConfigByFormId(formBean.getId());
            BizConfigBean targetBizConfigBean = this.businessManager4.findBizConfigByFormId(triggerBean.getTargetFormId());
            Long groupId = 0L;
            if (targetBizConfigBean != null) {
                groupId = targetBizConfigBean.getId();
            }
            for (FormTriggerActionBean actionBean : triggerBean.getActionList()) {
                MagicInterfaceDefineEntity magicInterfaceDefineEntity;
                String magicId;
                CAPFormTriggerTask triggerTask = new CAPFormTriggerTask();
                triggerTask.setNewId();
                triggerTask.setEventId(event.getId());
                triggerTask.setEventCreateTime(event.getCreateTime());
                triggerTask.setSourceType(event.getSourceType());
                triggerTask.setSourceUserId(event.getUserId());
                triggerTask.setSourceUserName(this.orgManager.getMemberById(event.getUserId()).getName());
                triggerTask.setSourceTitle(event.getTitle() + "-" + event.getMasterId());
                if (bizConfigBean != null) {
                    triggerTask.setSourceAppId(bizConfigBean.getId());
                    triggerTask.setSourceAppName(bizConfigBean.getName());
                }
                if (targetBizConfigBean != null) {
                    triggerTask.setTargetAppId(targetBizConfigBean.getId());
                    triggerTask.setTargetAppName(targetBizConfigBean.getName());
                }
                triggerTask.setTriggerId(triggerBean.getId());
                triggerTask.setTriggerName(triggerBean.getName());
                triggerTask.setActionId(actionBean.getId());
                triggerTask.setActionName(actionBean.getName());
                triggerTask.setContext(JSONUtil.toJSONString(param));
                triggerTask.setTriggerJson(triggerJson);
                triggerTask.setSourceFormId(formBean.getId());
                triggerTask.setSourceFormName(formBean.getFormName());
                triggerTask.setSourceMasterId(event.getMasterId());
                triggerTask.setTargetFormId(triggerBean.getTargetFormId());
                if (actionBean.getType().equals(FormTriggerBean.TriggerType.Distribution.getKey()) && formBean.getId().longValue() != triggerBean.getSourceFormId()) {
                    triggerTask.setTargetFormId(triggerBean.getSourceFormId());
                }
                String string = magicId = actionBean.getParam("dataMagicId") == null ? "" : actionBean.getParam("dataMagicId").toString();
                if (Strings.isNotEmpty((String)magicId) && (magicInterfaceDefineEntity = this.magicInterfaceDefineDao.loadDefineById(Long.parseLong(magicId))) != null) {
                    triggerTask.setTargetFormId(magicInterfaceDefineEntity.getFormId());
                }
                triggerTask.setGroupId(groupId);
                if (businessType != null && businessType.isCanParallel()) {
                    triggerTask.setParallel(1);
                }
                if (bizConfigBean != null && targetBizConfigBean != null && !bizConfigBean.getId().equals(targetBizConfigBean.getId())) {
                    triggerTask.setReferGroupId(formBean.getCategoryId());
                }
                triggerTask.setEvent((FormTriggerEventObject)event);
                triggerTasks.add(triggerTask);
            }
        }
        return triggerTasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean preExecTask(Task task) throws BusinessException {
        boolean result = true;
        if (!this.checkAndLock(-1L, task.getId())) {
            LOGGER.info((Object)("\u5f53\u524d\u4efb\u52a1\u88ab\u5176\u4ed6\u7ebf\u7a0b\u6267\u884c\uff0c\u5df2\u88ab\u9501\u4f4f\uff0c\u5f53\u524d\u7ebf\u7a0b\u8df3\u8fc7\u6b64\u4efb\u52a1\uff0ctask:" + task.getId()));
            return false;
        }
        try {
            CAPFormTriggerEvent event;
            AppContext.clearThreadContext();
            CAPFormTriggerTask triggerTask = (CAPFormTriggerTask)task;
            FormTriggerBean triggerBean = new FormTriggerBean(triggerTask.getTriggerJson());
            if (!triggerBean.isEnable()) {
                LOGGER.error((Object)"\u5f53\u524d\u89e6\u53d1\u5df2\u505c\u7528\uff0c\u4e0d\u6267\u884c\uff01");
                boolean bl = true;
                return bl;
            }
            FormTriggerActionBean actionBean = triggerBean.getActionBean(triggerTask.getActionId());
            LOGGER.info((Object)("\u5f00\u59cb\u9884\u6267\u884c\u4efb\u52a1\uff1a" + triggerBean.getName() + "_" + actionBean.getId() + actionBean.getType()));
            if (task.getEvent() instanceof CAPFormTriggerEvent) {
                event = (CAPFormTriggerEvent)task.getEvent();
            } else {
                event = this.capFormTriggerEventHistoryManager.getRecordById(triggerTask.getEventId());
                if (event == null) {
                    event = this.cap4FormTriggerEventDAO.getRecordById(triggerTask.getEventId());
                }
            }
            Map param = (Map)JSONUtil.parseJSONString((String)triggerTask.getContext());
            String localeKey = param.get("userLocale") == null ? "" : String.valueOf(param.get("userLocale"));
            String ipAddress = param.get("ipAddress") == null ? "" : String.valueOf(param.get("ipAddress"));
            User user = FormTriggerUtil.getCurrentUser4TriggerAction(event.getUserId(), FormTriggerUtil.getLocale(localeKey), ipAddress);
            AppContext.putThreadContext((String)"SESSION_CONTEXT_USERINFO_KEY", (Object)user);
            FormTriggerBaseAction actionManager = FormTriggerUtil.getTriggerActionByKey(actionBean.getType());
            String formId = (String)param.get("formId");
            com.seeyon.cap4.form.bean.FormBean formBean = this.cap4FormCacheManager.getForm(Long.valueOf(formId));
            if (!this.cap4FormCacheManager.isEnabled(formBean)) {
                LOGGER.error((Object)"\u6e90\u8868\u5355\u88ab\u505c\u7528\uff0c\u4e0d\u6267\u884c\uff01");
                boolean bl = true;
                return bl;
            }
            param.put("FormBean", formBean);
            if (actionBean.getType().equals(FormTriggerBean.TriggerType.Distribution.getKey()) && formBean.getId().equals(triggerBean.getTargetFormId())) {
                actionManager = FormTriggerUtil.getTriggerActionByKey(FormTriggerBean.TriggerType.FeedBack.getKey());
            }
            result = actionManager.preExecute(param, triggerBean, actionBean, (TriggerTaskEvent)event);
            LOGGER.info((Object)("\u9884\u6267\u884c\u7ed3\u675f\uff1a" + result));
        }
        catch (Throwable e) {
            LOGGER.error((Object)("\u9884\u6267\u884c\u5f02\u5e381:" + e.getMessage()), e);
            result = false;
        }
        finally {
            this.lockManager.unlock(-1L, task.getId().longValue(), -1);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int handleTask(Task task, boolean needPre) {
        int result = CAPFormTriggerTask.TriggerTaskState.executeSuccess.getKey();
        if (!this.checkAndLock(-1L, task.getId())) {
            LOGGER.info((Object)("\u5f53\u524d\u4efb\u52a1\u88ab\u5176\u4ed6\u7ebf\u7a0b\u6267\u884c\uff0c\u5df2\u88ab\u9501\u4f4f\uff0c\u5f53\u524d\u7ebf\u7a0b\u8df3\u8fc7\u6b64\u4efb\u52a1\uff0ctask:" + task.getId()));
            return CAPFormTriggerTask.TriggerTaskState.executeFail.getKey();
        }
        try {
            boolean preFlag;
            CAPFormTriggerEvent event;
            AppContext.clearThreadContext();
            CAPFormTriggerTask triggerTask = (CAPFormTriggerTask)task;
            FormTriggerBean triggerBean = new FormTriggerBean(triggerTask.getTriggerJson());
            if (!triggerBean.isEnable()) {
                LOGGER.error((Object)"\u5f53\u524d\u89e6\u53d1\u5df2\u505c\u7528\uff0c\u4e0d\u6267\u884c\uff01");
                triggerTask.setState(CAPFormTriggerTask.TriggerTaskState.executeSuccess.getKey());
                int n = result;
                return n;
            }
            FormTriggerActionBean actionBean = triggerBean.getActionBean(triggerTask.getActionId());
            LOGGER.info((Object)(triggerBean.getName() + "_" + actionBean.getType()));
            if (task.getEvent() instanceof CAPFormTriggerEvent) {
                event = (CAPFormTriggerEvent)task.getEvent();
            } else {
                event = this.capFormTriggerEventHistoryManager.getRecordById(triggerTask.getEventId());
                if (event == null) {
                    event = this.cap4FormTriggerEventDAO.getRecordById(triggerTask.getEventId());
                }
            }
            Map param = (Map)JSONUtil.parseJSONString((String)triggerTask.getContext());
            String localeKey = param.get("userLocale") == null ? "" : String.valueOf(param.get("userLocale"));
            String ipAddress = param.get("ipAddress") == null ? "" : String.valueOf(param.get("ipAddress"));
            User user = FormTriggerUtil.getCurrentUser4TriggerAction(event.getUserId(), FormTriggerUtil.getLocale(localeKey), ipAddress);
            AppContext.putThreadContext((String)"SESSION_CONTEXT_USERINFO_KEY", (Object)user);
            FormTriggerBaseAction actionManager = FormTriggerUtil.getTriggerActionByKey(actionBean.getType());
            String formId = (String)param.get("formId");
            com.seeyon.cap4.form.bean.FormBean formBean = this.cap4FormCacheManager.getForm(Long.valueOf(formId));
            if (!this.cap4FormCacheManager.isEnabled(formBean)) {
                LOGGER.error((Object)"\u6e90\u8868\u5355\u88ab\u505c\u7528\uff0c\u4e0d\u6267\u884c\uff01");
                triggerTask.setState(CAPFormTriggerTask.TriggerTaskState.executeSuccess.getKey());
                int n = result;
                return n;
            }
            param.put("FormBean", formBean);
            if (actionBean.getType().equals(FormTriggerBean.TriggerType.Distribution.getKey()) && formBean.getId().equals(triggerBean.getTargetFormId())) {
                actionManager = FormTriggerUtil.getTriggerActionByKey(FormTriggerBean.TriggerType.FeedBack.getKey());
            }
            if (needPre && !(preFlag = actionManager.preExecute(param, triggerBean, actionBean, (TriggerTaskEvent)event))) {
                int n = CAPFormTriggerTask.TriggerTaskState.executeNext.getKey();
                return n;
            }
            FormTriggerUtil.doTriggerExecute(actionManager, param, triggerBean, actionBean, event);
            triggerTask.setState(CAPFormTriggerTask.TriggerTaskState.executeSuccess.getKey());
            LOGGER.info((Object)(triggerBean.getName() + "_" + actionBean.getType()));
        }
        catch (Throwable e) {
            LOGGER.error((Object)("\u89e6\u53d1\u4efb\u52a1\u6267\u884c\u5f02\u5e381:" + e.getMessage()), e);
            result = CAPFormTriggerTask.TriggerTaskState.executeFail.getKey();
        }
        finally {
            this.lockManager.unlock(-1L, task.getId().longValue(), -1);
        }
        return result;
    }

    @Override
    public boolean save(FormTriggerTaskObject task) throws BusinessException {
        FormTriggerTask triggerTask = (FormTriggerTask)task;
        this.cap4FormTriggerTaskDAO.save(triggerTask);
        return true;
    }

    private boolean checkAndLock(Long userId, Long resourceId) {
        boolean result = this.lockManager.check(userId.longValue(), resourceId.longValue());
        if (result) {
            result = this.lockManager.lock(userId.longValue(), resourceId.longValue());
        }
        return result;
    }

    @Override
    public boolean save2Execute(Task task) throws BusinessException {
        CAPFormTriggerTask capFormTriggerTask = (CAPFormTriggerTask)task;
        capFormTriggerTask.setState(CAPFormTriggerTask.TriggerTaskState.unExecute.getKey());
        this.cap4FormTriggerTaskDAO.update(capFormTriggerTask);
        return true;
    }

    @Override
    public int getExecuteTasksCount() throws BusinessException {
        return this.cap4FormTriggerTaskDAO.countByState(0);
    }

    @Override
    public List<Task> getExecuteTasks() throws BusinessException {
        ArrayList<Task> tasks = new ArrayList<Task>();
        List<CAPFormTriggerTask> triggerTasks = this.cap4FormTriggerTaskDAO.getTasks(CAPFormTriggerTask.TriggerTaskState.unExecute.getKey());
        tasks.addAll(triggerTasks);
        return tasks;
    }

    @Override
    public FlipInfo getTaskEvents(FlipInfo fi, Map<String, Object> param) throws BusinessException {
        if (!param.containsKey("state")) {
            param.put("state", String.valueOf(CAPFormTriggerTask.TriggerTaskState.unExecute.getKey()));
        }
        boolean isHistory = false;
        if (!param.get("state").equals(String.valueOf(CAPFormTriggerTask.TriggerTaskState.unExecute.getKey()))) {
            isHistory = true;
        }
        FlipInfo flipInfo = isHistory ? this.capFormTriggerEventHistoryManager.getTasks(fi, param) : this.cap4FormTriggerTaskDAO.getTasks(fi, param);
        ArrayList<CAPFormTriggerTaskVO> taskVOs = new ArrayList<CAPFormTriggerTaskVO>();
        if (CollectionUtils.isNotEmpty((Collection)flipInfo.getData())) {
            List tasks = flipInfo.getData();
            for (BasePO basePO : tasks) {
                FormTriggerBean.TriggerEventSourceEnum triggerEventSourceEnum;
                CAPFormTriggerTask task;
                if (isHistory) {
                    task = new CAPFormTriggerTask();
                    BeanUtils.convert((Object)task, (Object)basePO);
                    task.setState(((CapFormTriggerTaskHistory)basePO).getTaskState());
                } else {
                    task = (CAPFormTriggerTask)basePO;
                }
                CAPFormTriggerTaskVO taskVO = new CAPFormTriggerTaskVO(task);
                taskVO.setCreateTimeStr(DateUtil.format((Date)task.getCreateTime(), (String)"yyyy-MM-dd HH:mm:ss"));
                taskVO.setTargetFormName("");
                if (task.getTargetFormId() != null) {
                    com.seeyon.cap4.form.bean.FormBean formBean = this.cap4FormCacheManager.getForm(task.getTargetFormId());
                    if (formBean != null) {
                        taskVO.setTargetFormName(formBean.getFormName());
                    } else {
                        try {
                            FormBean formBean1 = this.formCacheManager.getForm(task.getTargetFormId().longValue());
                            if (formBean1 != null) {
                                taskVO.setTargetFormName(formBean1.getFormName());
                            }
                        }
                        catch (Exception e) {
                            LOGGER.info((Object)("also not exists in cap3:" + task.getTargetFormId()), (Throwable)e);
                        }
                    }
                }
                if ((triggerEventSourceEnum = FormTriggerBean.TriggerEventSourceEnum.getEnumByKey((String)task.getSourceType())) != null) {
                    taskVO.setSourceTypeName(ResourceUtil.getString((String)triggerEventSourceEnum.getI18n()));
                }
                taskVO.setStateName(CAPFormTriggerTask.TriggerTaskState.getByKey(task.getState()).getName());
                if (Strings.isNotBlank((String)taskVO.getActionName()) && !"null".equals(taskVO.getActionName())) {
                    taskVO.setTargetContent(taskVO.getActionName() + "-" + taskVO.getTargetFormName());
                } else {
                    taskVO.setActionName("");
                    taskVO.setTargetContent(taskVO.getTargetFormName());
                }
                if (null == taskVO.getTargetContent() || "null".equals(taskVO.getTargetContent())) {
                    taskVO.setTargetContent("");
                }
                taskVOs.add(taskVO);
            }
        }
        flipInfo.setData(taskVOs);
        return flipInfo;
    }

    @Override
    public Task getTaskById(Long taskId) throws BusinessException {
        return this.cap4FormTriggerTaskDAO.getTaskById(taskId);
    }
}

