/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.engin.trigger;

import com.seeyon.apps.collaboration.api.CollaborationApi;
import com.seeyon.apps.collaboration.constants.ColConstant;
import com.seeyon.apps.collaboration.po.ColSummary;
import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormCheckRuleBean;
import com.seeyon.cap4.form.bean.FormDataBean;
import com.seeyon.cap4.form.bean.FormDataMasterBean;
import com.seeyon.cap4.form.bean.FormDataSubBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormFieldComEnum;
import com.seeyon.cap4.form.bean.FormFormulaBean;
import com.seeyon.cap4.form.bean.FormTableBean;
import com.seeyon.cap4.form.bean.FormTriggerActionBean;
import com.seeyon.cap4.form.bean.FormTriggerBean;
import com.seeyon.cap4.form.bean.SimpleObjectBean;
import com.seeyon.cap4.form.bean.fieldCtrl.FormFieldFlowDealOption;
import com.seeyon.cap4.form.bean.fieldCtrl.FormFieldMapCtrl;
import com.seeyon.cap4.form.bean.fieldCtrl.FormFieldMapMarked;
import com.seeyon.cap4.form.bean.fieldCtrl.FormFieldUtil;
import com.seeyon.cap4.form.modules.engin.base.formData.CAP4FormDataManager;
import com.seeyon.cap4.form.modules.engin.businessRelation.CAP4FormTriggerDesignManager;
import com.seeyon.cap4.form.modules.engin.formula.FormulaEnums;
import com.seeyon.cap4.form.modules.engin.formula.FormulaUtil;
import com.seeyon.cap4.form.modules.engin.trigger.CAP4FormTriggerSourceRecordDAO;
import com.seeyon.cap4.form.modules.engin.trigger.FormTriggerActionContext;
import com.seeyon.cap4.form.modules.engin.trigger.FormTriggerBaseAction;
import com.seeyon.cap4.form.modules.engin.trigger.FormTriggerBaseDesignInterface;
import com.seeyon.cap4.form.modules.engin.trigger.TriggerActionContext;
import com.seeyon.cap4.form.modules.engin.trigger.TriggerTaskEvent;
import com.seeyon.cap4.form.modules.engin.trigger.action.FormTriggerExecutor;
import com.seeyon.cap4.form.modules.engin.trigger.design.FormTriggerDesignManagerComparator;
import com.seeyon.cap4.form.po.CAPFormTriggerEvent;
import com.seeyon.cap4.form.po.CAPFormTriggerSourceRecord;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.form.util.FormUtil;
import com.seeyon.cap4.form.vo.FormTriggerFillBackResultVo;
import com.seeyon.cap4.form.vo.FormTriggerQuartzDataVo;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.BeansOfTypeListener;
import com.seeyon.ctp.common.ModuleType;
import com.seeyon.ctp.common.authenticate.domain.User;
import com.seeyon.ctp.common.constants.ApplicationCategoryEnum;
import com.seeyon.ctp.common.constants.Constants;
import com.seeyon.ctp.common.content.mainbody.MainbodyService;
import com.seeyon.ctp.common.content.mainbody.MainbodyType;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.filemanager.manager.AttachmentManager;
import com.seeyon.ctp.common.i18n.LocaleContext;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.lbs.manager.LbsManager;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.content.CtpContentAll;
import com.seeyon.ctp.monitor.util.UniqueIndexUtil;
import com.seeyon.ctp.organization.OrgConstants;
import com.seeyon.ctp.organization.bo.V3xOrgAccount;
import com.seeyon.ctp.organization.bo.V3xOrgDepartment;
import com.seeyon.ctp.organization.bo.V3xOrgMember;
import com.seeyon.ctp.organization.bo.V3xOrgRole;
import com.seeyon.ctp.organization.manager.OrgManager;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.ParamUtil;
import com.seeyon.ctp.util.StringUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDLong;
import com.seeyon.ctp.workflow.wapi.WorkflowApiManager;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;

public class FormTriggerUtil {
    private static final Log LOGGER = CtpLogFactory.getLog(FormTriggerUtil.class);
    public static final String NO_NEED_DELETE_SUBLINE_KEY = "NO_NEED_DELETE_SUBLINE_KEY";
    public static final String NO_NEED_DELETE_SUBLINE_VALUE = "NO_NEED_DELETE_SUBLINE_VALUE";
    public static final String FLOW_TITLE_NAME = "flowTitleName";
    private static Map<String, FormTriggerBaseDesignInterface> triggerDesignManagerMap = new HashMap<String, FormTriggerBaseDesignInterface>();
    private static Map<String, FormTriggerBaseDesignInterface> canUseTriggerDesignManagerMap = new HashMap<String, FormTriggerBaseDesignInterface>();
    private static Map<String, FormTriggerBaseAction> triggerActionMap = new HashMap<String, FormTriggerBaseAction>();
    private static OrgManager orgManager;
    private static LbsManager lbsManager;
    private static AttachmentManager attachmentManager;
    private static CAP4FormDataManager cap4FormDataManager;
    private static CAP4FormCacheManager cap4FormCacheManager;
    private static CAP4FormTriggerDesignManager cap4FormTriggerDesignManager;
    private static CAP4FormTriggerSourceRecordDAO cap4FormTriggerSourceRecordDAO;
    private static WorkflowApiManager wapi;
    private static CollaborationApi collaborationApi;
    private static Pattern parseRelationPattern;

    public static void init() {
        AppContext.addBeansOfTypeListener(FormTriggerBaseDesignInterface.class, (BeansOfTypeListener)new BeansOfTypeListener(){

            public void onChange(Class clazz) {
                FormTriggerUtil.initTriggerDesignManager();
            }
        });
        AppContext.addBeansOfTypeListener(FormTriggerBaseAction.class, (BeansOfTypeListener)new BeansOfTypeListener(){

            public void onChange(Class clazz) {
                FormTriggerUtil.initTriggerAction();
            }
        });
        FormTriggerUtil.initTriggerDesignManager();
        FormTriggerUtil.initTriggerAction();
    }

    private static void initTriggerDesignManager() {
        if (triggerDesignManagerMap.isEmpty()) {
            Map designManagers = AppContext.getBeansOfType(FormTriggerBaseDesignInterface.class);
            for (Map.Entry entry : designManagers.entrySet()) {
                triggerDesignManagerMap.put(((FormTriggerBaseDesignInterface)entry.getValue()).getId(), (FormTriggerBaseDesignInterface)entry.getValue());
                if (!((FormTriggerBaseDesignInterface)entry.getValue()).canUse()) continue;
                canUseTriggerDesignManagerMap.put(((FormTriggerBaseDesignInterface)entry.getValue()).getId(), (FormTriggerBaseDesignInterface)entry.getValue());
            }
        }
    }

    private static void initTriggerAction() {
        if (triggerActionMap.isEmpty()) {
            Map actions = AppContext.getBeansOfType(FormTriggerBaseAction.class);
            for (Map.Entry entry : actions.entrySet()) {
                triggerActionMap.put(((FormTriggerBaseAction)entry.getValue()).getId(), (FormTriggerBaseAction)entry.getValue());
            }
        }
    }

    public static FormTriggerBaseDesignInterface getDesignManagerByKey(String key) {
        return canUseTriggerDesignManagerMap.get(key);
    }

    public static List<FormTriggerBaseDesignInterface> getDesignManagerListByFormType(Enums.FormType formType) {
        ArrayList<FormTriggerBaseDesignInterface> designManagerList = new ArrayList<FormTriggerBaseDesignInterface>();
        for (Map.Entry<String, FormTriggerBaseDesignInterface> entry : canUseTriggerDesignManagerMap.entrySet()) {
            if (!entry.getValue().canUse4FormType(formType)) continue;
            designManagerList.add(entry.getValue());
        }
        Collections.sort(designManagerList, FormTriggerDesignManagerComparator.getInstance());
        return designManagerList;
    }

    public static List<FormTriggerBaseDesignInterface> getDesignManagerList(Enums.FormType formType, FormTriggerBean.TriggerBusinessType ownerType) {
        ArrayList<FormTriggerBaseDesignInterface> designManagerList = new ArrayList<FormTriggerBaseDesignInterface>();
        for (Map.Entry<String, FormTriggerBaseDesignInterface> entry : canUseTriggerDesignManagerMap.entrySet()) {
            FormTriggerBean.TriggerType triggerType = FormTriggerBean.TriggerType.getEnumByKey((String)entry.getKey());
            if (!entry.getValue().canUse4FormType(formType) || triggerType == null || triggerType.getOwnerType() != ownerType) continue;
            designManagerList.add(entry.getValue());
        }
        Collections.sort(designManagerList, FormTriggerDesignManagerComparator.getInstance());
        return designManagerList;
    }

    public static List<FormTriggerBaseDesignInterface> getDesignManagerList(Enums.FormType sFormType, Enums.FormType tFormType, FormTriggerBean.TriggerBusinessType ownerType) {
        ArrayList<FormTriggerBaseDesignInterface> designManagerList = new ArrayList<FormTriggerBaseDesignInterface>();
        for (Map.Entry<String, FormTriggerBaseDesignInterface> entry : canUseTriggerDesignManagerMap.entrySet()) {
            FormTriggerBean.TriggerType triggerType = FormTriggerBean.TriggerType.getEnumByKey((String)entry.getKey());
            if (!entry.getValue().canUse4FormType(sFormType, tFormType) || triggerType == null || triggerType.getOwnerType() != ownerType) continue;
            designManagerList.add(entry.getValue());
        }
        Collections.sort(designManagerList, FormTriggerDesignManagerComparator.getInstance());
        return designManagerList;
    }

    public static FormTriggerBaseAction getTriggerActionByKey(String key) {
        return triggerActionMap.get(key);
    }

    public static void filterMappingFields(FormBean formBean, List<FormFieldBean> fieldList, List<FormFieldBean> conditionFieldList) throws BusinessException {
        FormFieldComEnum[] filters = new FormFieldComEnum[]{FormFieldComEnum.MAP_LOCATE, FormFieldComEnum.MAP_PHOTO, FormFieldComEnum.LINE_NUMBER, FormFieldComEnum.CUSTOM_CONTROL};
        HashSet<FormFieldComEnum> filterStr = new HashSet<FormFieldComEnum>(Arrays.asList(filters));
        List allFields = formBean.getAllFieldBeans();
        for (FormFieldBean field : allFields) {
            if (filterStr.contains(field.getInputTypeEnum())) continue;
            fieldList.add(field);
            if (conditionFieldList == null || field.getFieldType().equals(Enums.FieldType.LONGTEXT.getKey()) || field.isAttachment() || field.isLbs() || field.isCustomerCtrl() || field.isMultiOrg()) continue;
            conditionFieldList.add(field);
        }
    }

    public static Set<FormTableBean> getSubTableBeanInMsgContent(FormBean formBean, String msg) throws BusinessException {
        HashSet<FormTableBean> subTableNameList = new HashSet<FormTableBean>();
        Matcher matcher = FormFormulaBean.initBeanMapPattern.matcher(msg);
        while (matcher.find()) {
            String value;
            FormFieldBean tempField;
            String group = matcher.group();
            if (!group.startsWith(FormulaEnums.FormulaExtendSymbol.leftBigBracket.getKey()) || !group.endsWith(FormulaEnums.FormulaExtendSymbol.rightBigBracket.getKey()) || (tempField = formBean.getFieldBeanByDisplay(value = group.substring(1, group.length() - 1))) == null || tempField.isMasterField()) continue;
            subTableNameList.add(formBean.getTableByTableName(tempField.getOwnerTableName()));
        }
        return subTableNameList;
    }

    public static String getTriggerRecordName(FormBean sourceForm) {
        String mainTableName = sourceForm.getMasterTableBean().getTableName();
        String tableIndex = mainTableName.replace(Enums.TableType.MASTER.getTableSufName() + "_", "");
        return ("form_trigger_record_" + tableIndex).toUpperCase();
    }

    public static Map<String, String> parseRelationCondition(String formulaStr) {
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        List formulaList = FormUtil.getConditionMap((String)formulaStr);
        if (Strings.isNotEmpty((Collection)formulaList)) {
            for (Map map : formulaList) {
                String sourceField;
                String targetField = (String)map.get("fieldValue");
                Matcher matcher = parseRelationPattern.matcher(targetField);
                if (matcher.find()) {
                    targetField = matcher.group();
                }
                if ((matcher = parseRelationPattern.matcher(sourceField = (String)map.get("fieldName"))).find()) {
                    sourceField = matcher.group();
                }
                fieldMap.put(targetField, sourceField);
            }
        }
        return fieldMap;
    }

    public static void addCurrentUser4TriggerAction(Long memberId) throws BusinessException {
        User userOld;
        User user = userOld = (User)AppContext.getThreadContext((String)"SESSION_CONTEXT_USERINFO_KEY");
        if (userOld == null || !userOld.getId().equals(memberId)) {
            user = FormTriggerUtil.getCurrentUser4TriggerAction(memberId);
        }
        LOGGER.info((Object)("userId; " + memberId + " loginAccount: " + user.getLoginAccount() + " locale: " + user.getLocale()));
        AppContext.putThreadContext((String)"SESSION_CONTEXT_USERINFO_KEY", (Object)user);
    }

    public static User getCurrentUser4TriggerAction(Long memberId) throws BusinessException {
        return FormTriggerUtil.getCurrentUser4TriggerAction(memberId, null, null);
    }

    public static User getCurrentUser4TriggerAction(Long memberId, Locale locale, String ipAddress) throws BusinessException {
        V3xOrgAccount account;
        V3xOrgMember member = FormTriggerUtil.getOrgManager().getMemberById(memberId);
        User user = new User();
        if (member == null) {
            user.setId(memberId);
            return user;
        }
        user.setId(member.getId());
        user.setAccountId(member.getOrgAccountId());
        user.setDepartmentId(member.getOrgDepartmentId());
        user.setLevelId(member.getOrgLevelId());
        user.setLoginAccount(member.getOrgAccountId());
        user.setPostId(member.getOrgPostId());
        user.setName(member.getName());
        user.setLoginName(member.getLoginName());
        user.setUserAgentFrom(Constants.login_useragent_from.pc.name());
        if (member.getOrgAccountId() != null && (account = FormTriggerUtil.getOrgManager().getAccountById(member.getOrgAccountId())) != null) {
            user.setLoginAccount(account.getId());
            user.setLoginAccountName(account.getName());
            user.setLoginAccountShortName(account.getShortName());
        }
        if (locale == null) {
            user.setLocale(AppContext.getLocale());
        } else {
            user.setLocale(locale);
        }
        if (ipAddress == null || Strings.isBlank((String)ipAddress)) {
            user.setRemoteAddr(AppContext.getRemoteAddr());
        } else {
            user.setRemoteAddr(ipAddress);
        }
        return user;
    }

    public static Locale getLocale(String localeKey) throws BusinessException {
        Locale locale = null;
        if (Strings.isNotBlank((String)localeKey)) {
            List allLocales = LocaleContext.getAllLocales();
            for (Locale loc : allLocales) {
                if (!loc.toString().contains(localeKey)) continue;
                locale = loc;
                break;
            }
        }
        return locale;
    }

    public static ColSummary getColSummaryByContent(long moduleId) throws BusinessException {
        CollaborationApi manager = (CollaborationApi)AppContext.getBean((String)"collaborationApi");
        ColSummary summary = (ColSummary)AppContext.getThreadContext((String)("TRIGGER_PARAM_SUMMARY_" + moduleId));
        if (summary == null) {
            summary = manager.getColSummary(Long.valueOf(moduleId));
            AppContext.putThreadContext((String)("TRIGGER_PARAM_SUMMARY_" + moduleId), (Object)summary);
        }
        return summary;
    }

    public static List<FormDataSubBean> filterSubBeansByFilterAndTimeCondition(FormTriggerActionContext context, List<FormDataSubBean> subBeans, String sourceTable, String dataTable) throws BusinessException {
        FormTriggerBean triggerBean = context.getTriggerBean();
        FormDataMasterBean masterBean = context.getMasterBean();
        ArrayList<FormDataSubBean> resultSubBeans = new ArrayList<FormDataSubBean>();
        for (FormDataSubBean subBean : subBeans) {
            FormFormulaBean filterFormula;
            FormFormulaBean formFormulaBean = filterFormula = triggerBean.getFilterCondition() == null ? null : triggerBean.getFilterCondition().getConditionFormula();
            if (sourceTable.equals(dataTable) && !FormUtil.isMatchFilterCondition((FormFormulaBean)filterFormula, (FormDataMasterBean)masterBean, (FormDataSubBean)subBean) || sourceTable.equals(context.getDateSubTableName()) && !context.getDateSubIds().contains(subBean.getId())) continue;
            resultSubBeans.add(subBean);
        }
        return resultSubBeans;
    }

    public static List<FormDataSubBean> filterSubBeansByFilterCondition(FormTriggerBean triggerBean, FormDataMasterBean masterBean, List<FormDataSubBean> subBeans, String sourceTable, String dataTable) throws BusinessException {
        ArrayList<FormDataSubBean> resultSubBeans = new ArrayList<FormDataSubBean>();
        for (FormDataSubBean subBean : subBeans) {
            FormFormulaBean filterFormula;
            FormFormulaBean formFormulaBean = filterFormula = triggerBean.getFilterCondition() == null ? null : triggerBean.getFilterCondition().getConditionFormula();
            if (sourceTable.equals(dataTable) && !FormUtil.isMatchFilterCondition((FormFormulaBean)filterFormula, (FormDataMasterBean)masterBean, (FormDataSubBean)subBean)) continue;
            resultSubBeans.add(subBean);
        }
        return resultSubBeans;
    }

    public static Object[] getDateSubTableAndSubData(String triggerParamDateSubDataIds) {
        String[] subDataIdStr;
        String tableName = "";
        HashSet<Long> dateSubDataIds = new HashSet<Long>();
        if (Strings.isBlank((String)triggerParamDateSubDataIds) || "null".equals(triggerParamDateSubDataIds)) {
            return new Object[]{tableName, dateSubDataIds};
        }
        String[] dateSubDataIdsStr = triggerParamDateSubDataIds.split("[|]");
        tableName = dateSubDataIdsStr[0];
        for (String s : subDataIdStr = dateSubDataIdsStr[1].split(",")) {
            if (Strings.isBlank((String)s) || "null".equals(s)) continue;
            dateSubDataIds.add(Long.valueOf(s));
        }
        return new Object[]{tableName, dateSubDataIds};
    }

    public static String[] getFieldName(String value) {
        return FormUtil.getFieldName((String)value);
    }

    public static Set<FormTriggerQuartzDataVo> doTriggerExecute(FormTriggerBaseAction actionManager, Map<String, Object> param, FormTriggerBean triggerBean, FormTriggerActionBean actionBean, CAPFormTriggerEvent event) throws BusinessException, SQLException {
        FormTriggerActionContext context = FormTriggerExecutor.getInstance().getContext(param, triggerBean, actionBean, (TriggerTaskEvent)event);
        if (context == null) {
            return new HashSet<FormTriggerQuartzDataVo>();
        }
        actionManager.init();
        actionManager.execute((TriggerActionContext)context);
        return FormTriggerExecutor.getInstance().afterExecute(context);
    }

    public static Map<Long, Map<String, List<FormDataSubBean>>> getTriggerSenderList(FormTriggerActionContext context) throws BusinessException {
        FormTriggerActionBean actionBean = context.getActionBean();
        List entity = (List)actionBean.getParam(FormTriggerBean.ActionParam.Entity.getKey());
        SimpleObjectBean entityObj = (SimpleObjectBean)entity.get(0);
        String key = String.valueOf(entityObj.getName());
        String value = String.valueOf(entityObj.getValue());
        HashMap<Long, Map<String, List<FormDataSubBean>>> senderMap = new HashMap<Long, Map<String, List<FormDataSubBean>>>();
        if ("FormField".equals(key)) {
            senderMap.putAll(FormTriggerUtil.getFormFieldSender(context, value));
        } else {
            Long senderId = FormTriggerUtil.getSimpleSender(key, value, context);
            if (senderId != 0L) {
                senderMap.put(senderId, null);
            }
        }
        return senderMap;
    }

    private static Long getSimpleSender(String senderType, String value, FormTriggerActionContext context) {
        Long senderId = 0L;
        if ("Role".equals(senderType)) {
            if ("Sender".equals(value)) {
                senderId = context.getMasterBean().getStartMemberId();
            } else if ("Node".equals(value)) {
                Map<String, Object> param = context.getParam();
                senderId = AppContext.currentUserId();
                if (param.get("affair_member_id") != null) {
                    senderId = Long.parseLong(param.get("affair_member_id").toString());
                    try {
                        V3xOrgMember member = FormTriggerUtil.getOrgManager().getMemberById(senderId);
                        if (member == null) {
                            senderId = 0L;
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error((Object)("\u67e5\u8be2\u4eba\u5458\u5f02\u5e38\uff1a" + e.getMessage()), (Throwable)e);
                        senderId = 0L;
                    }
                }
            }
        } else if ("Member".equals(senderType)) {
            senderId = Long.parseLong(value);
        }
        return senderId;
    }

    private static Map<Long, Map<String, List<FormDataSubBean>>> getFormFieldSender(FormTriggerActionContext context, String value) throws BusinessException {
        HashMap<Long, Map<String, List<FormDataSubBean>>> senderMap = new HashMap<Long, Map<String, List<FormDataSubBean>>>();
        FormBean formBean = context.getFormBean();
        FormDataMasterBean masterBean = context.getMasterBean();
        String fieldName = FormTriggerUtil.getFieldName(value)[1];
        FormFieldBean fieldBean = formBean.getFieldBeanByName(fieldName);
        if (fieldBean.isMasterField()) {
            Object fieldValue = masterBean.getFieldValue(fieldName);
            if (!StringUtil.checkNull((String)String.valueOf(fieldValue))) {
                FormTriggerUtil.getFieldSender(senderMap, value, String.valueOf(fieldValue), null, null);
            }
        } else {
            FormTriggerUtil.getSubFieldSender(context, fieldBean.getOwnerTableName(), fieldBean, senderMap, value);
        }
        return senderMap;
    }

    private static void getSubFieldSender(FormTriggerActionContext context, String tableName, FormFieldBean fieldBean, Map<Long, Map<String, List<FormDataSubBean>>> senderMap, String value) throws BusinessException {
        FormDataMasterBean masterBean = context.getMasterBean();
        FormTriggerBean triggerBean = context.getTriggerBean();
        String conditionSubTableName = triggerBean.getFilterConditionSubTableName();
        List<FormDataSubBean> dataSubBeans = FormTriggerUtil.filterSubBeansByFilterAndTimeCondition(context, masterBean.getSubData(tableName), tableName, conditionSubTableName);
        for (FormDataSubBean subBean : dataSubBeans) {
            Object fieldValue = subBean.getFieldValue(fieldBean.getName());
            if (StringUtil.checkNull((String)String.valueOf(fieldValue))) continue;
            FormTriggerUtil.getFieldSender(senderMap, value, String.valueOf(fieldValue), tableName, subBean);
        }
    }

    private static void getFieldSender(Map<Long, Map<String, List<FormDataSubBean>>> senderMap, String value, String fieldValue, String subTableName, FormDataSubBean subBean) throws BusinessException {
        String[] senderStr = FormTriggerUtil.getFieldName(value);
        String fieldType = senderStr[0];
        String fieldRole = senderStr[3];
        String[] ids = fieldValue.split(",");
        HashSet<Long> idSet = new HashSet<Long>();
        if (fieldType.toLowerCase().contains(FormFieldComEnum.EXTEND_DEPARTMENT.getKey())) {
            if (StringUtil.checkNull((String)fieldRole)) {
                for (String id : ids) {
                    List members = FormTriggerUtil.getOrgManager().getMembersByDepartment(Long.valueOf(Long.parseLong(id)), true);
                    for (V3xOrgMember v3xOrgMember : members) {
                        idSet.add(v3xOrgMember.getId());
                    }
                }
            } else {
                for (String id : ids) {
                    idSet.addAll(FormTriggerUtil.getFieldRoleSender(fieldRole, Long.parseLong(id), false));
                }
            }
        } else if (StringUtil.checkNull((String)fieldRole)) {
            for (String id : ids) {
                idSet.add(Long.parseLong(id));
            }
        } else {
            for (String id : ids) {
                idSet.addAll(FormTriggerUtil.getFieldRoleSender(fieldRole, Long.parseLong(id), true));
            }
        }
        for (Long id : idSet) {
            if (StringUtil.checkNull((String)subTableName)) {
                senderMap.put(id, null);
                continue;
            }
            Map<String, List<FormDataSubBean>> map = senderMap.get(id);
            if (map == null) {
                map = new LinkedHashMap<String, List<FormDataSubBean>>();
            }
            Strings.addToMap(map, (Object)subTableName, (Object)subBean);
            senderMap.put(id, map);
        }
    }

    private static Set<Long> getFieldRoleSender(String role, Long memOrDeptId, boolean isMem) throws BusinessException {
        HashSet<Long> idSet = new HashSet<Long>();
        if ("ReciprocalRoleReporter".equals(role)) {
            V3xOrgMember member = FormTriggerUtil.getOrgManager().getMemberById(memOrDeptId);
            if (member != null && member.getReporter() != null) {
                idSet.add(member.getReporter());
            }
        } else {
            V3xOrgMember member;
            Long deptId = memOrDeptId;
            if (isMem && (member = FormTriggerUtil.getOrgManager().getMemberById(memOrDeptId)) != null && member.getOrgDepartmentId() != null) {
                deptId = member.getOrgDepartmentId();
            }
            List memberList = new ArrayList();
            if ("DeptMember".equals(role)) {
                memberList = FormTriggerUtil.getOrgManager().getMembersByDepartment(deptId, true);
            } else {
                V3xOrgDepartment department = FormTriggerUtil.getOrgManager().getDepartmentById(deptId);
                Long roleId = 0L;
                try {
                    roleId = Long.valueOf(role);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                V3xOrgRole v3xRole = FormTriggerUtil.getOrgManager().getRoleById(roleId);
                if (v3xRole != null) {
                    if (v3xRole.getBond() == OrgConstants.ROLE_BOND.DEPARTMENT.ordinal()) {
                        memberList = FormTriggerUtil.getOrgManager().getMembersByRole(deptId, roleId);
                    } else if (v3xRole.getBond() == OrgConstants.ROLE_BOND.ACCOUNT.ordinal()) {
                        memberList = FormTriggerUtil.getOrgManager().getMembersByRole(v3xRole.getOrgAccountId(), roleId);
                    }
                } else {
                    List v3xRoles = FormTriggerUtil.getOrgManager().getRoleByCode(role, department.getOrgAccountId());
                    if (Strings.isNotEmpty((Collection)v3xRoles)) {
                        v3xRole = (V3xOrgRole)v3xRoles.get(0);
                        if (v3xRole.getBond() == OrgConstants.ROLE_BOND.DEPARTMENT.ordinal()) {
                            memberList = FormTriggerUtil.getOrgManager().getMembersByRole(deptId, v3xRole.getId());
                        } else if (v3xRole.getBond() == OrgConstants.ROLE_BOND.ACCOUNT.ordinal()) {
                            memberList = FormTriggerUtil.getOrgManager().getMembersByRole(v3xRole.getOrgAccountId(), v3xRole.getId());
                        }
                    }
                }
            }
            for (V3xOrgMember v3xOrgMember : memberList) {
                idSet.add(v3xOrgMember.getId());
            }
        }
        return idSet;
    }

    public static FormFieldBean getSourceFieldBean(FormBean formBean, String fieldName) {
        FormFieldBean fieldBean = new FormFieldBean();
        fieldBean.setName(fieldName);
        if (FLOW_TITLE_NAME.equals(fieldName)) {
            fieldBean.setDisplay(ResourceUtil.getString((String)"form.relation.member.attr.flowname.label"));
            fieldBean.setFieldType(Enums.FieldType.VARCHAR.getKey());
            fieldBean.setInputType(FormFieldComEnum.TEXT.getKey());
            fieldBean.setInputTypeEnum(FormFieldComEnum.TEXT);
            fieldBean.setFieldLength("100");
            fieldBean.setDigitNum("0");
        }
        fieldBean.setOwnerTableName(formBean.getMasterTableBean().getTableName());
        return fieldBean;
    }

    public static void fillMappingData(FormTriggerActionContext context, FormBean toFormBean, FormTriggerFillBackResultVo resultVo, String subTableName, List<FormDataSubBean> subBeanList) throws BusinessException {
        FormBean formBean = context.getFormBean();
        FormDataMasterBean masterBean = context.getMasterBean();
        FormTriggerActionBean actionBean = context.getActionBean();
        FormDataSubBean sourceSubBean = Strings.isEmpty(subBeanList) ? null : subBeanList.get(0);
        Map<String, Object> masterMap = resultVo.getMasterMap();
        Map<String, Map<String, Object>> main2Sub = resultVo.getMain2Sub();
        List fillBackList = (List)actionBean.getParam(FormTriggerBean.ActionParam.FillBack.getKey());
        if (resultVo.isFeedBack()) {
            fillBackList = (List)actionBean.getParam(FormTriggerBean.ActionParam.FeedBack.getKey());
        }
        if (Strings.isNotEmpty((Collection)fillBackList)) {
            FormDataMasterBean cloneMasterBean = FormTriggerUtil.cloneNowMasterBean(context, masterBean);
            Map<String, Object> allDataMap = FormTriggerUtil.convertData2GroovyParamMap(formBean, cloneMasterBean, sourceSubBean);
            LOGGER.info((Object)"\u503c\u62f7\u8d1d\u5f00\u59cb");
            for (SimpleObjectBean objectBean : fillBackList) {
                String type = objectBean.getType();
                String key = objectBean.getName();
                String value = objectBean.getValue();
                String triggerSource = objectBean.getPhoneValue();
                String[] valueTo = key.split("\\.");
                FormTableBean toTableBean = toFormBean.getTableByTableName(valueTo[0]);
                FormFieldBean toFieldBean = toTableBean.getFieldBeanByName(valueTo[1]);
                if (toFieldBean == null) {
                    LOGGER.error((Object)("\u76ee\u6807\u8868\u5355\u5b57\u6bb5\uff1a" + valueTo[0] + valueTo[1] + " \u672a\u627e\u5230\u5176\u5bf9\u5e94\u7684formfieldbean\uff0c\u8df3\u8fc7\u6b64\u884c\uff01"));
                    continue;
                }
                FormFormulaBean rowCondition = null;
                if (Strings.isNotEmpty((String)objectBean.getDisplay()) && (rowCondition = (FormFormulaBean)objectBean.getExtraAttr(objectBean.getDisplay())) == null) {
                    rowCondition = cap4FormCacheManager.loadFormFormulaBean(formBean, Long.valueOf(objectBean.getDisplay()));
                }
                if (FormTriggerBean.FillBackType.formula.getKey().equals(type)) {
                    LOGGER.info((Object)(toFieldBean.getName() + " \u6761\u4ef6\u5224\u65ad\uff1a"));
                    if (!FormTriggerUtil.isMatchRowCondition(formBean, cloneMasterBean, sourceSubBean, rowCondition)) continue;
                    FormTriggerUtil.fillFormulaData(formBean, cloneMasterBean, toFieldBean, objectBean, allDataMap, resultVo);
                    if (toFieldBean.isMasterField()) {
                        resultVo.addTriggerSourceField("main2main", toFieldBean.getName(), triggerSource);
                        continue;
                    }
                    resultVo.addTriggerSourceField("main2sub", toFieldBean.getName(), triggerSource);
                    continue;
                }
                String[] valueFrom = value.split("\\.");
                FormTableBean fromTableBean = formBean.getTableByTableName(valueFrom[0]);
                FormFieldBean fromFieldBean = FLOW_TITLE_NAME.equals(valueFrom[1]) ? FormTriggerUtil.getSourceFieldBean(formBean, FLOW_TITLE_NAME) : fromTableBean.getFieldBeanByName(valueFrom[1]);
                if (fromFieldBean == null) {
                    LOGGER.error((Object)("\u6e90\u8868\u5355\u5b57\u6bb5\uff1a" + valueFrom[0] + " \u672a\u627e\u5230\u5176\u5bf9\u5e94\u7684formfieldbean\uff0c\u8df3\u8fc7\u6b64\u884c\uff01"));
                    continue;
                }
                if (fromFieldBean.isMasterField()) {
                    LOGGER.info((Object)(toFieldBean.getName() + " \u6761\u4ef6\u5224\u65ad\uff1a"));
                    if (!FormTriggerUtil.isMatchRowCondition(formBean, cloneMasterBean, sourceSubBean, rowCondition)) continue;
                }
                if (fromTableBean.isMainTable() && toTableBean.isMainTable()) {
                    FormTriggerUtil.fillMappingValueMap(context, resultVo, masterMap, (FormDataBean)cloneMasterBean, fromFieldBean, sourceSubBean, toFieldBean, null);
                    resultVo.addTriggerSourceField("main2main", toFieldBean.getName(), triggerSource);
                    continue;
                }
                if (fromTableBean.isMainTable()) {
                    Map<String, Object> valueMap = main2Sub.get(toTableBean.getTableName());
                    if (valueMap == null) {
                        valueMap = new HashMap<String, Object>();
                        main2Sub.put(toTableBean.getTableName(), valueMap);
                    }
                    FormTriggerUtil.fillMappingValueMap(context, resultVo, valueMap, (FormDataBean)cloneMasterBean, fromFieldBean, sourceSubBean, toFieldBean, null);
                    resultVo.getTargetSubFieldList().add(toFieldBean.getName());
                    resultVo.addTriggerSourceField("main2sub", toFieldBean.getName(), triggerSource);
                    continue;
                }
                FormTriggerUtil.fillMappingSubData(context, cloneMasterBean, toTableBean, toFieldBean, fromTableBean, fromFieldBean, resultVo, subTableName, subBeanList, rowCondition, triggerSource);
            }
            LOGGER.info((Object)"\u503c\u62f7\u8d1d\u7ed3\u675f");
        }
    }

    public static FormDataMasterBean cloneNowMasterBean(FormTriggerActionContext context, FormDataMasterBean masterBean) throws BusinessException {
        FormDataMasterBean cloneMasterBean = new FormDataMasterBean(masterBean.getRowData(), context.getFormBean().getMasterTableBean(), new boolean[0]);
        for (FormTableBean tableBean : context.getFormBean().getSubTableBean()) {
            List<FormDataSubBean> subList = masterBean.getSubData(tableBean.getTableName());
            subList = FormTriggerUtil.filterSubBeansByFilterAndTimeCondition(context, subList, tableBean.getTableName(), context.getConditionSubTableName());
            cloneMasterBean.setSubData(tableBean.getTableName(), subList);
        }
        return cloneMasterBean;
    }

    public static boolean isMatchRowCondition(FormBean formBean, FormDataMasterBean masterBean, FormDataSubBean subBean, FormFormulaBean rowCondition) throws BusinessException {
        String key;
        Boolean isMatch;
        if (rowCondition == null) {
            return true;
        }
        HashMap rowConditionMap = (HashMap)AppContext.getThreadContext((String)"rowConditionMap");
        if (rowConditionMap == null) {
            rowConditionMap = new HashMap();
            AppContext.putThreadContext((String)"rowConditionMap", rowConditionMap);
        }
        if ((isMatch = (Boolean)rowConditionMap.get(key = subBean == null ? "-1-" + rowCondition.getFormulaId().toString() : subBean.getId() + "-" + rowCondition.getFormulaId())) == null) {
            String formula = rowCondition.getExecuteFormulaForGroove();
            Map map = masterBean.getFormulaMap("componentType_condition");
            if (subBean != null) {
                map.putAll(subBean.getFormulaMap("componentType_condition"));
            } else {
                FormDataSubBean tempData = null;
                String subTableName = FormTriggerUtil.getCap4FormTriggerDesignManager().getSubTableNameInCondition(formBean.getId(), rowCondition.getFormulaForDisplay(), true);
                List subList = masterBean.getSubData(subTableName);
                if (Strings.isNotEmpty((Collection)subList)) {
                    tempData = (FormDataSubBean)subList.get(0);
                }
                if (tempData != null) {
                    map.putAll(tempData.getFormulaMap("componentType_condition"));
                }
            }
            map.put("formDataBean", masterBean);
            map.put("formBean", formBean);
            String conStr = formula;
            conStr = FormulaUtil.procReplaceNullToGroove((String)conStr);
            boolean result = FormulaUtil.isMatch((String)conStr, (Map)map);
            LOGGER.info((Object)("\u884c\u6761\u4ef6\u5224\u65ad\uff1a" + conStr + " \u6ee1\u8db3\u72b6\u6001\uff1a" + result));
            isMatch = result;
        }
        return isMatch;
    }

    private static boolean fillFormulaData(FormBean formBean, FormDataMasterBean masterBean, FormFieldBean toFieldBean, SimpleObjectBean objectBean, Map<String, Object> allDataMap, FormTriggerFillBackResultVo resultVo) throws BusinessException {
        String value = objectBean.getValue();
        if (Strings.isBlank((String)value)) {
            LOGGER.error((Object)("\u76ee\u6807\u5b57\u6bb5\uff1a" + toFieldBean.getName() + " \u8ba1\u7b97\u5f0f\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u6b64\u884c\uff01"));
            return false;
        }
        FormFormulaBean formula = (FormFormulaBean)objectBean.getExtraAttr(value);
        if (formula == null) {
            formula = cap4FormCacheManager.loadFormFormulaBean(formBean, Long.valueOf(value));
        }
        if (formula == null) {
            LOGGER.error((Object)("\u76ee\u6807\u5b57\u6bb5\uff1a" + toFieldBean.getName() + " \u8ba1\u7b97\u5f0f\u4e3a\u7a7a\uff0c\u8df3\u8fc7\u6b64\u884c\uff01"));
            return false;
        }
        Map<String, Object> targetGroovyParam = FormTriggerUtil.getFormulaGroovyParamMap(formBean, masterBean, formula);
        HashMap<String, Object> tempMap = new HashMap<String, Object>(allDataMap);
        tempMap.putAll(targetGroovyParam);
        String formulaExecuteStr = FormTriggerUtil.convertFormula4Groovy(formula);
        LOGGER.info((Object)(toFieldBean.getName() + " \u8868\u8fbe\u5f0f\uff1a" + formulaExecuteStr));
        Object resultValue = FormulaUtil.doResult((String)formulaExecuteStr, tempMap);
        LOGGER.info((Object)(toFieldBean.getName() + " value\uff1a" + resultValue));
        Map<String, Object> masterMap = resultVo.getMasterMap();
        Map<String, Map<String, Object>> subMap = resultVo.getSubMap();
        BigDecimal sv = FormTriggerUtil.formatNumberFieldValue(resultValue, toFieldBean.getDigitNum());
        if (toFieldBean.isMasterField()) {
            masterMap.put(toFieldBean.getName(), sv);
        } else {
            Map<String, Object> tempSubMap = subMap.get(toFieldBean.getOwnerTableName());
            if (tempSubMap == null) {
                tempSubMap = new HashMap<String, Object>();
                subMap.put(toFieldBean.getOwnerTableName(), tempSubMap);
            }
            tempSubMap.put(toFieldBean.getName(), sv);
            resultVo.getTargetSubFieldList().add(toFieldBean.getName());
        }
        return true;
    }

    private static Map<String, Object> convertData2GroovyParamMap(FormBean formBean, FormDataMasterBean masterBean, FormDataSubBean sourceSubBean) throws BusinessException {
        FormFieldBean tempFfb;
        HashMap<String, Object> allFormData = new HashMap<String, Object>();
        Map data = masterBean.getRowData();
        for (Map.Entry en : data.entrySet()) {
            tempFfb = formBean.getFieldBeanByName((String)en.getKey());
            allFormData.put((String)en.getKey(), FormTriggerUtil.convertValue2GroovyParam(en.getValue(), tempFfb));
        }
        List tableBeans = formBean.getSubTableBean();
        FormDataSubBean tempData = null;
        for (FormTableBean subTable : tableBeans) {
            if (sourceSubBean != null && sourceSubBean.getFormTable().getTableName().equals(subTable.getTableName())) {
                tempData = sourceSubBean;
            } else {
                List subList = masterBean.getSubData(subTable.getTableName());
                if (Strings.isNotEmpty((Collection)subList)) {
                    tempData = (FormDataSubBean)subList.get(0);
                }
            }
            if (tempData == null) continue;
            for (Map.Entry en : tempData.getRowData().entrySet()) {
                tempFfb = formBean.getFieldBeanByName((String)en.getKey());
                allFormData.put((String)en.getKey(), FormTriggerUtil.convertValue2GroovyParam(en.getValue(), tempFfb));
            }
        }
        return allFormData;
    }

    private static Map<String, Object> getFormulaGroovyParamMap(FormBean formBean, FormDataMasterBean masterBean, FormFormulaBean formulaBean) throws BusinessException {
        HashMap<String, Object> tempMap = new HashMap<String, Object>();
        for (FormFormulaBean.FormulaBaseBean formula : formulaBean.getFormulaBeanList()) {
            if (!(formula instanceof FormFormulaBean.FormulaFunctionBean)) continue;
            List list = ((FormFormulaBean.FormulaFunctionBean)formula).getList();
            for (FormFormulaBean.FormulaBaseBean funBean : list) {
                String fieldStr;
                if (!(funBean instanceof FormFormulaBean.FormulaDataFieldBean) || !(fieldStr = ((FormFormulaBean.FormulaDataFieldBean)funBean).getValue()).contains(".")) continue;
                String fieldName = fieldStr.substring(fieldStr.indexOf(".") + 1);
                String keyFieldStr = fieldStr.replaceAll("\\.", "_") + "_fun";
                tempMap.put(keyFieldStr, FormTriggerUtil.convertValue2GroovyParam(masterBean.getDataList(fieldName), formBean.getFieldBeanByName(fieldName)));
            }
        }
        return tempMap;
    }

    public static Object convertValue2GroovyParam(Object value, FormFieldBean ffb) throws BusinessException {
        Object v = value;
        if (ffb != null && ffb.getFieldType().equalsIgnoreCase(Enums.FieldType.DECIMAL.getKey())) {
            if (v instanceof List) {
                List l = (List)v;
                for (int i = 0; i < l.size(); ++i) {
                    l.set(i, ffb.getFormulaValue(l.get(i), "formulaType_number"));
                }
                return v;
            }
            if ((v = ffb.getFormulaValue(v, "formulaType_number")) instanceof String) {
                v = 0;
            }
        }
        return v;
    }

    public static String convertFormula4Groovy(FormFormulaBean formulaBean) throws BusinessException {
        return FormTriggerUtil.convertFormula4Groovy(formulaBean, false);
    }

    public static String convertFormula4Groovy(FormFormulaBean formulaBean, boolean isCap4ToCap3) throws BusinessException {
        FormFormulaBean tempFormula;
        try {
            tempFormula = (FormFormulaBean)formulaBean.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new BusinessException((Throwable)e);
        }
        for (FormFormulaBean.FormulaBaseBean formula : tempFormula.getFormulaBeanList()) {
            if (!(formula instanceof FormFormulaBean.FormulaFunctionBean) || !((FormFormulaBean.FormulaFunctionBean)formula).getName().equals(FormulaEnums.FunctionSymbol.aver.getKey()) && !((FormFormulaBean.FormulaFunctionBean)formula).getName().equals(FormulaEnums.FunctionSymbol.sum.getKey())) continue;
            List list = ((FormFormulaBean.FormulaFunctionBean)formula).getList();
            for (FormFormulaBean.FormulaBaseBean funBean : list) {
                String fieldStr;
                if (!(funBean instanceof FormFormulaBean.FormulaDataFieldBean) || !(fieldStr = ((FormFormulaBean.FormulaDataFieldBean)funBean).getValue()).contains(".") && !isCap4ToCap3) continue;
                String keyFieldStr = fieldStr.replaceAll("\\.", "_") + "_fun";
                ((FormFormulaBean.FormulaDataFieldBean)funBean).setValue(keyFieldStr);
            }
        }
        return tempFormula.getExecuteFormulaForGroove();
    }

    private static void fillMappingSubData(FormTriggerActionContext context, FormDataMasterBean masterBean, FormTableBean toTableBean, FormFieldBean toFieldBean, FormTableBean fromTableBean, FormFieldBean fromFieldBean, FormTriggerFillBackResultVo resultVo, String subTableName, List<FormDataSubBean> subBeanList, FormFormulaBean rowCondition, String triggerSource) throws BusinessException {
        FormBean formBean = context.getFormBean();
        Map<String, Object> masterMap = resultVo.getMasterMap();
        Map<String, Map<String, Object>> sub2Main = resultVo.getSub2Main();
        Map<String, FormDataSubBean> sub2Sub = resultVo.getSub2Sub();
        List<FormDataSubBean> subDataList = masterBean.getSubData(fromTableBean.getTableName());
        if (Strings.isNotEmpty(subBeanList) && fromTableBean.getTableName().equals(subTableName)) {
            subDataList = subBeanList;
        }
        if (toTableBean.isMainTable()) {
            for (FormDataSubBean fromSubBean : subDataList) {
                if (!FormTriggerUtil.isMatchRowCondition(formBean, masterBean, fromSubBean, rowCondition)) continue;
                Map<String, Object> valueMap = sub2Main.get(fromTableBean.getTableName() + "," + fromSubBean.getId());
                if (null == valueMap) {
                    valueMap = new HashMap<String, Object>(masterMap);
                    sub2Main.put(fromTableBean.getTableName() + "," + fromSubBean.getId(), valueMap);
                }
                FormTriggerUtil.fillMappingValueMap(context, resultVo, valueMap, (FormDataBean)fromSubBean, fromFieldBean, fromSubBean, toFieldBean, null);
            }
            resultVo.addTriggerSourceField("sub2main", toFieldBean.getName(), triggerSource);
        } else {
            for (FormDataSubBean fromSubBean : subDataList) {
                if (!FormTriggerUtil.isMatchRowCondition(formBean, masterBean, fromSubBean, rowCondition)) continue;
                FormDataSubBean subBean = sub2Sub.get(fromTableBean.getTableName() + "," + fromSubBean.getId());
                if (subBean == null) {
                    subBean = FormTriggerUtil.addNewSubBean(fromTableBean, fromSubBean, toTableBean, sub2Sub);
                }
                Map valueMap = subBean.getRowData();
                FormTriggerUtil.fillMappingValueMap(context, resultVo, valueMap, (FormDataBean)fromSubBean, fromFieldBean, fromSubBean, toFieldBean, subBean);
                subBean.addFieldValue(valueMap);
            }
            resultVo.getTargetSubFieldList().add(toFieldBean.getName());
            resultVo.addTriggerSourceField("sub2sub", toFieldBean.getName(), triggerSource);
        }
    }

    public static FormDataSubBean addNewSubBean(FormTableBean fromTableBean, FormDataSubBean fromSubBean, FormTableBean toTableBean, Map<String, FormDataSubBean> sub2Sub) {
        HashMap<String, Long> valueMap = new HashMap<String, Long>();
        valueMap.put(Enums.SubTableField.id.getKey(), UUIDLong.longUUID());
        valueMap.put(Enums.SubTableField.formmain_id.getKey(), (Long)valueMap.get(Enums.SubTableField.id.getKey()));
        FormDataSubBean subBean = new FormDataSubBean(valueMap, toTableBean, null, new boolean[0]);
        subBean.putExtraAttr("tableName", toTableBean.getTableName());
        sub2Sub.put(fromTableBean.getTableName() + "," + fromSubBean.getId(), subBean);
        return subBean;
    }

    public static void fillMappingValueMap(FormTriggerActionContext context, FormTriggerFillBackResultVo resultVo, Map<String, Object> dataMap, FormDataBean nowDataBean, FormFieldBean fromFieldBean, FormDataSubBean sourceSubBean, FormFieldBean toFieldBean, FormDataSubBean newSubBean) throws BusinessException {
        Object value = nowDataBean.getFieldValue(fromFieldBean.getName());
        if (FLOW_TITLE_NAME.equals(fromFieldBean.getName())) {
            value = context.getTitle();
        }
        if (fromFieldBean.isAttachment() && !(FormFieldUtil.getFormFieldCtrl((String)fromFieldBean.getInputType()) instanceof FormFieldMapCtrl)) {
            Long newSub = FormTriggerUtil.getSubReference(context, toFieldBean, dataMap.get(toFieldBean.getName()), value);
            if (newSub != null && value != null && Strings.isNotEmpty((String)String.valueOf(value))) {
                Long subReference;
                Set<Long> tempList;
                Map<String, Map<Long, Set<Long>>> attachmentMap = resultVo.getAttachmentMap();
                Map<Long, Set<Long>> temp = attachmentMap.get(toFieldBean.getName());
                if (temp == null) {
                    temp = new HashMap<Long, Set<Long>>();
                }
                if ((tempList = temp.get(subReference = Long.valueOf(Long.parseLong(value.toString())))) == null) {
                    tempList = new HashSet<Long>();
                }
                tempList.add(newSub);
                temp.put(subReference, tempList);
                attachmentMap.put(toFieldBean.getName(), temp);
            }
            dataMap.put(toFieldBean.getName(), newSub);
        } else if (value != null && FormFieldUtil.getFormFieldCtrl((String)fromFieldBean.getInputType()) instanceof FormFieldFlowDealOption && fromFieldBean.getFormatType().contains(Enums.FlowDealOptionsType.signet.getKey())) {
            dataMap.put(toFieldBean.getName(), FormUtil.replaceDealOptionSinget((String)String.valueOf(value)));
        } else {
            if (value == null || !Strings.isNotBlank((String)value.toString())) {
                value = null;
            }
            dataMap.put(toFieldBean.getName(), value);
        }
        if (nowDataBean.getFieldValue(fromFieldBean.getName()) != null && FormFieldUtil.getFormFieldCtrl((String)fromFieldBean.getInputType()) instanceof FormFieldMapMarked) {
            FormTriggerUtil.fillMapMarkedMap(dataMap, value, resultVo.getMapMarkedMap(), toFieldBean, newSubBean);
        }
        LOGGER.info((Object)("from " + fromFieldBean.getName() + fromFieldBean.getDisplay() + "  to " + toFieldBean.getName() + toFieldBean.getDisplay() + "  value\uff1a" + dataMap.get(toFieldBean.getName())));
    }

    private static Long getSubReference(FormTriggerActionContext context, FormFieldBean toFieldBean, Object oldSub, Object sourceSub) {
        Object multiAttrFields;
        boolean isMultiAtt;
        Long sub = null;
        boolean isUpdate = FormTriggerBean.TriggerType.Update.getKey().equals(context.getActionBean().getType());
        if (context.getTriggerBean().isDataMagic()) {
            isUpdate = FormTriggerBean.TriggerType.Update.getKey().equals(ParamUtil.getString((Map)context.getActionBean().getParam(), (String)"triggerType"));
        }
        boolean bl = isMultiAtt = (multiAttrFields = context.getActionBean().getParam(FormTriggerBean.ActionParam.MultiAttrFields.getKey())) != null && multiAttrFields.toString().contains(toFieldBean.getName()) && toFieldBean.isAttachment();
        if (isUpdate && isMultiAtt) {
            if (oldSub != null) {
                sub = Long.valueOf(oldSub.toString());
            } else if (!StringUtil.checkNull((String)String.valueOf(sourceSub))) {
                sub = UUIDLong.longUUID();
            }
        } else if (!StringUtil.checkNull((String)String.valueOf(sourceSub))) {
            sub = UUIDLong.longUUID();
        }
        return sub;
    }

    public static BigDecimal formatNumberFieldValue(Object value, String digitNumStr) {
        int digitNum = 0;
        if (Strings.isNotBlank((String)digitNumStr)) {
            digitNum = Integer.valueOf(digitNumStr);
        }
        return FormTriggerUtil.formatNumberFieldValue(value, digitNum);
    }

    private static BigDecimal formatNumberFieldValue(Object value, int digitNum) {
        BigDecimal result = new BigDecimal("0");
        if (value == null) {
            return null;
        }
        if (value instanceof Double) {
            BigDecimal b = new BigDecimal((Double)value);
            result = b.setScale(digitNum, 4);
            if (Double.doubleToRawLongBits(result.doubleValue()) == 0L) {
                result = new BigDecimal("0");
            }
        } else if (value instanceof BigDecimal) {
            BigDecimal b = (BigDecimal)value;
            result = b.setScale(digitNum, 4);
            if (Double.doubleToRawLongBits(result.doubleValue()) == 0L) {
                result = new BigDecimal("0");
            }
        } else if (value instanceof Integer) {
            result = new BigDecimal((Integer)value);
        }
        return result;
    }

    private static void fillMapMarkedMap(Map<String, Object> dataMap, Object value, Map<String, Map<Long, Set<String>>> mapMarkedMap, FormFieldBean toFieldBean, FormDataSubBean newSubBean) {
        Long subReference;
        Set<String> set;
        if (value == null || Strings.isEmpty((String)String.valueOf(value))) {
            return;
        }
        Map<Long, Set<String>> temp = mapMarkedMap.get(toFieldBean.getName());
        if (temp == null) {
            temp = new HashMap<Long, Set<String>>();
        }
        if ((set = temp.get(subReference = Long.valueOf(Long.parseLong(value.toString())))) == null) {
            set = new HashSet<String>();
        }
        Long newSub = UUIDLong.longUUID();
        dataMap.put(toFieldBean.getName(), newSub);
        String valueStr = newSubBean != null ? newSub + "_" + newSubBean.getId() : newSub + "_0";
        set.add(valueStr);
        temp.put(subReference, set);
        mapMarkedMap.put(toFieldBean.getName(), temp);
    }

    public static void addTriggerSourceRecord(FormTriggerActionContext context, FormTriggerFillBackResultVo resultVo, String type, Long sSubId, Long tMasterId, FormTableBean tTableBean, Long tSubId) {
        Map<String, String> triggerSourceFieldMap = resultVo.getTriggerSourceFieldMap().get(type);
        if (triggerSourceFieldMap != null && !triggerSourceFieldMap.isEmpty()) {
            Long sMasterId = context.getMasterBean().getId();
            FormTriggerBean triggerBean = context.getTriggerBean();
            for (Map.Entry<String, String> source : triggerSourceFieldMap.entrySet()) {
                if (tTableBean.getFieldBeanByName(source.getKey()) == null) continue;
                CAPFormTriggerSourceRecord record = new CAPFormTriggerSourceRecord();
                record.setId(UUIDLong.longUUID());
                record.setTriggerId(triggerBean.getId());
                record.setActionId(context.getActionBean().getId());
                record.setViewAuth(source.getValue());
                record.setFieldName(source.getKey());
                record.setModuleId(context.getModuleId());
                record.setSourceFormId(triggerBean.getSourceFormId());
                record.setSourceMasterDataId(sMasterId);
                record.setSourceSubDataId(sSubId);
                record.setTargetFormId(triggerBean.getTargetFormId());
                record.setTargetMasterDataId(tMasterId);
                record.setTargetSubDataId(tSubId);
                record.setCreateId(AppContext.currentUserId());
                record.setCreateTime(DateUtil.currentDate());
                resultVo.addTriggerSourceRecord(tMasterId, record);
            }
        }
    }

    public static String getMapKeyOrValue(FormDataBean dataBean) {
        FormTableBean tableBean = dataBean.getFormTable();
        return tableBean.getTableName() + "," + dataBean.getFieldValue(Enums.MasterTableField.id.getKey());
    }

    public static void deleteNullSubData(String tableName, FormDataMasterBean targetFormMasterBean, boolean checkAttachment) {
        FormDataSubBean subBean;
        boolean flag;
        List subBeans = targetFormMasterBean.getSubData(tableName);
        if (Strings.isNotEmpty((Collection)subBeans) && subBeans.size() == 1 && (flag = (subBean = (FormDataSubBean)subBeans.get(0)).isEmpty(checkAttachment)) && (subBean.getExtraAttr(NO_NEED_DELETE_SUBLINE_KEY) == null || Strings.isEmpty((String)String.valueOf(subBean.getExtraAttr(NO_NEED_DELETE_SUBLINE_KEY))))) {
            subBeans.clear();
        }
    }

    public static void addEmptySubLineAndFillMain2SubData(FormTriggerActionContext context, FormBean toFormBean, FormDataMasterBean toMasterBean, FormTriggerFillBackResultVo resultVo, boolean isNew) {
        List tableBeans = toFormBean.getSubTableBean();
        Map<String, Map<String, Object>> subMap = resultVo.getSubMap();
        Map<String, Map<String, Object>> main2Sub = resultVo.getMain2Sub();
        if (Strings.isNotEmpty((Collection)tableBeans)) {
            for (FormTableBean subTableBean : tableBeans) {
                FormTriggerUtil.deleteNullSubData(subTableBean.getTableName(), toMasterBean, false);
                ArrayList<FormDataSubBean> subBeans = toMasterBean.getSubData(subTableBean.getTableName());
                if (Strings.isEmpty((Collection)subBeans)) {
                    FormDataSubBean subBean;
                    subBeans = new ArrayList<FormDataSubBean>();
                    if (isNew) {
                        subBean = new FormDataSubBean(subTableBean, toMasterBean, new boolean[]{true});
                        subBean.setFormmainId(toMasterBean.getId().longValue());
                    } else {
                        HashMap<String, Long> tempMap = new HashMap<String, Long>();
                        tempMap.put(Enums.SubTableField.formmain_id.getKey(), toMasterBean.getId());
                        subBean = new FormDataSubBean(tempMap, subTableBean, toMasterBean, new boolean[]{true});
                    }
                    subBeans.add(subBean);
                    toMasterBean.addSubData(subTableBean.getTableName(), subBean);
                }
                Map<String, Object> temp = main2Sub.get(subTableBean.getTableName());
                if (subMap.get(subTableBean.getTableName()) != null) {
                    if (temp == null) {
                        temp = new HashMap<String, Object>();
                    }
                    temp.putAll(subMap.get(subTableBean.getTableName()));
                }
                if (temp == null || temp.isEmpty()) continue;
                for (FormDataSubBean formDataSubBean2 : subBeans) {
                    formDataSubBean2.addFieldValue(temp);
                    if (!context.getFormBean().isFlowForm() && !toFormBean.isFlowForm()) {
                        resultVo.addMain2SubRecord(context.getMasterBean(), toMasterBean, subTableBean.getTableName(), formDataSubBean2.getId());
                    }
                    FormTriggerUtil.addTriggerSourceRecord(context, resultVo, "main2sub", 0L, toMasterBean.getId(), subTableBean, formDataSubBean2.getId());
                }
            }
        }
    }

    public static void dealMapMarked(FormBean toFormBean, FormDataMasterBean targetMasterBean, FormTriggerFillBackResultVo resultVo) throws BusinessException {
        Map<String, Map<Long, Set<String>>> mapMarkedMap = resultVo.getMapMarkedMap();
        if (!mapMarkedMap.isEmpty()) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("referenceSummaryId", 0L);
            params.put("referenceTemplateId", 0L);
            params.put("referenceFormId", toFormBean.getId());
            params.put("referenceFormMasterDataId", targetMasterBean.getId());
            for (Map.Entry<String, Map<Long, Set<String>>> entity : mapMarkedMap.entrySet()) {
                params.put("referenceFieldName", entity.getKey());
                for (Map.Entry<Long, Set<String>> en : entity.getValue().entrySet()) {
                    Set<String> set = en.getValue();
                    for (String value : set) {
                        String[] values = value.split("_");
                        params.put("lbsId", values[0]);
                        params.put("referenceRecordId", values[1]);
                        FormTriggerUtil.getLbsManager().lbsBaseCopy(en.getKey().longValue(), params);
                    }
                }
            }
            FormTriggerUtil.getLbsManager().updateStateByMasterDataId(targetMasterBean.getId().longValue(), 2);
        }
    }

    public static void dealSpecialFieldData(FormTriggerActionContext context, FormDataMasterBean toMasterBean, FormTriggerFillBackResultVo resultVo, boolean isNew) throws BusinessException {
        List<CAPFormTriggerSourceRecord> sourceRecordList;
        Map<String, Map<Long, Set<Long>>> attachmentMap = resultVo.getAttachmentMap();
        if (!attachmentMap.isEmpty()) {
            Long oldModuleId = context.getModuleId();
            oldModuleId = FormTriggerUtil.getParentSummaryIdByChildSummaryId(oldModuleId);
            Long newModuleId = toMasterBean.getId();
            for (Map.Entry<String, Map<Long, Set<Long>>> entity : attachmentMap.entrySet()) {
                List valueList = toMasterBean.getDataList(entity.getKey());
                for (Map.Entry<Long, Set<Long>> en : entity.getValue().entrySet()) {
                    Set<Long> set = en.getValue();
                    for (Long value : set) {
                        if (!valueList.contains(value.toString())) continue;
                        FormTriggerUtil.getAttachmentManager().copy(oldModuleId, en.getKey(), newModuleId, value, Integer.valueOf(ApplicationCategoryEnum.cap4Form.getKey()));
                    }
                }
            }
        }
        if (Strings.isNotEmpty(sourceRecordList = resultVo.getTriggerSourceRecord(toMasterBean.getId()))) {
            if (isNew) {
                FormTriggerUtil.getCap4FormTriggerSourceRecordDAO().saveAll(sourceRecordList);
            } else {
                for (CAPFormTriggerSourceRecord sourceRecord : sourceRecordList) {
                    FormTriggerUtil.getCap4FormTriggerSourceRecordDAO().delete(sourceRecord.getTargetMasterDataId(), sourceRecord.getTargetSubDataId(), sourceRecord.getFieldName());
                    FormTriggerUtil.getCap4FormTriggerSourceRecordDAO().save(sourceRecord);
                }
            }
        }
    }

    private static Long getParentSummaryIdByChildSummaryId(Long moduleId) throws BusinessException {
        ColSummary summary = (ColSummary)AppContext.getThreadContext((String)("TRIGGER_PARAM_SUMMARY_" + moduleId));
        if (summary == null) {
            summary = FormTriggerUtil.getCollaborationApi().getColSummary(moduleId);
        }
        if (summary == null) {
            return moduleId;
        }
        if (Integer.valueOf(ColConstant.NewflowType.child.ordinal()).equals(summary.getNewflowType())) {
            String processId = summary.getProcessId();
            if (Strings.isBlank((String)processId)) {
                return moduleId;
            }
            Long parentProcessId = FormTriggerUtil.getWapi().getMainProcessIdBySubProcessId(Long.valueOf(processId));
            if (null == parentProcessId) {
                return moduleId;
            }
            ColSummary colSummaryById = FormTriggerUtil.getCollaborationApi().getColSummaryByProcessId(String.valueOf(parentProcessId));
            if (null != colSummaryById) {
                return colSummaryById.getId();
            }
        }
        return moduleId;
    }

    public static void saveDataAndContent(FormBean formBean, FormDataMasterBean masterBean, long creator, String title) throws BusinessException, SQLException {
        CtpContentAll contentAll = FormUtil.getCtpContentAll((long)creator, (Long)masterBean.getId(), (int)ModuleType.cap4UnflowForm.getKey(), (Long)masterBean.getId(), (int)MainbodyType.FORM.getKey(), (Long)formBean.getId(), (Long)masterBean.getId(), (String)title);
        MainbodyService.getInstance().saveOrUpdateContentAll(contentAll);
        LOGGER.info((Object)("\u4fdd\u5b58ctpContentAll\u4fe1\u606f\uff1a\u8868\u5355 " + formBean.getId() + formBean.getFormName() + " \u6570\u636e " + masterBean.getId() + " \u6b63\u6587 " + contentAll.getId()));
    }

    public static String validateCheckRule(FormBean formBean, List<FormDataMasterBean> masterBeans) throws BusinessException {
        FormDataMasterBean masterBean;
        String result = "";
        Iterator<FormDataMasterBean> iterator = masterBeans.iterator();
        while (iterator.hasNext() && !Strings.isNotBlank((String)(result = FormTriggerUtil.validateCheckRule(formBean, masterBean = iterator.next())))) {
        }
        return result;
    }

    public static String validateCheckRule(FormBean formBean, FormDataMasterBean targetMasterBean) throws BusinessException {
        FormCheckRuleBean checkRuleBean = formBean.getCheckRuleBean();
        List checkRules = checkRuleBean == null ? null : checkRuleBean.getCheckRuleList();
        int forceCheck = checkRuleBean == null ? 1 : checkRuleBean.getForceCheck();
        String result = "";
        if (Strings.isNotEmpty((Collection)checkRules) && forceCheck != 2) {
            Map conditionMap = targetMasterBean.getFormulaMap("componentType_condition");
            Map formulaMap = formBean.getCheckRuleFormula(conditionMap);
            List formulaList = (List)formulaMap.get("checkRule");
            boolean checkResult = true;
            for (FormFormulaBean formula : formulaList) {
                String formulaStr = formula.getExecuteFormulaForGroove();
                if (FormulaUtil.isMatch((String)formulaStr, (Map)conditionMap)) continue;
                checkResult = false;
                break;
            }
            if (!checkResult) {
                result = "checkRule";
            }
        }
        return result;
    }

    public static String validateDataUnique(FormBean toFormBean, List<FormDataMasterBean> masterBeans) throws BusinessException, SQLException {
        String result = "";
        if (toFormBean.hasDataUniqueField()) {
            List maxFieldList = UniqueIndexUtil.getIndexForForm((String)String.valueOf(toFormBean.getId()));
            boolean hasMaxField = CollectionUtils.isNotEmpty((Collection)maxFieldList);
            List uniqueList = toFormBean.getUniqueFieldList();
            for (List unique : uniqueList) {
                boolean uniqueMarked;
                if (Strings.isEmpty((Collection)unique)) continue;
                if (unique.size() == 1) {
                    List<Object> valueList = FormTriggerUtil.getUniqueFieldValueList((String)unique.get(0), masterBeans);
                    uniqueMarked = FormTriggerUtil.getCap4FormDataManager().isFieldUnique(toFormBean, (String)unique.get(0), valueList);
                } else {
                    List indexList;
                    uniqueMarked = !hasMaxField ? FormTriggerUtil.getCap4FormDataManager().isUniqueMarked(toFormBean, unique) : (CollectionUtils.isEmpty((Collection)(indexList = (List)CollectionUtils.intersection((Iterable)unique, (Iterable)maxFieldList))) ? FormTriggerUtil.getCap4FormDataManager().isUniqueMarked(toFormBean, unique) : FormTriggerUtil.getCap4FormDataManager().isUniqueMarked(toFormBean, unique, indexList, masterBeans));
                }
                if (uniqueMarked) continue;
                result = "uniqueMarked";
                break;
            }
            UniqueIndexUtil.mergeUniqueCache((long)toFormBean.getId(), (List)uniqueList);
        }
        return result;
    }

    private static List<Object> getUniqueFieldValueList(String fieldName, List<FormDataMasterBean> masterBeans) {
        LinkedList<Object> valueList = new LinkedList<Object>();
        for (FormDataMasterBean masterBean : masterBeans) {
            valueList.addAll(masterBean.getDataList(fieldName));
        }
        return valueList;
    }

    private static OrgManager getOrgManager() {
        if (orgManager == null) {
            orgManager = (OrgManager)AppContext.getBean((String)"orgManager");
        }
        return orgManager;
    }

    private static LbsManager getLbsManager() {
        if (lbsManager == null) {
            lbsManager = (LbsManager)AppContext.getBean((String)"lbsManager");
        }
        return lbsManager;
    }

    private static AttachmentManager getAttachmentManager() {
        if (attachmentManager == null) {
            attachmentManager = (AttachmentManager)AppContext.getBean((String)"attachmentManager");
        }
        return attachmentManager;
    }

    private static CAP4FormDataManager getCap4FormDataManager() {
        if (cap4FormDataManager == null) {
            cap4FormDataManager = (CAP4FormDataManager)AppContext.getBean((String)"cap4FormDataManager");
        }
        return cap4FormDataManager;
    }

    private static CAP4FormCacheManager getCap4FormCacheManager() {
        if (cap4FormCacheManager == null) {
            cap4FormCacheManager = (CAP4FormCacheManager)AppContext.getBean((String)"cap4FormCacheManager");
        }
        return cap4FormCacheManager;
    }

    private static CAP4FormTriggerDesignManager getCap4FormTriggerDesignManager() {
        if (cap4FormTriggerDesignManager == null) {
            cap4FormTriggerDesignManager = (CAP4FormTriggerDesignManager)AppContext.getBean((String)"cap4FormTriggerDesignManager");
        }
        return cap4FormTriggerDesignManager;
    }

    private static CAP4FormTriggerSourceRecordDAO getCap4FormTriggerSourceRecordDAO() {
        if (cap4FormTriggerSourceRecordDAO == null) {
            cap4FormTriggerSourceRecordDAO = (CAP4FormTriggerSourceRecordDAO)AppContext.getBean((String)"cap4FormTriggerSourceRecordDAO");
        }
        return cap4FormTriggerSourceRecordDAO;
    }

    private static WorkflowApiManager getWapi() {
        if (wapi == null) {
            wapi = (WorkflowApiManager)AppContext.getBean((String)"wapi");
        }
        return wapi;
    }

    private static CollaborationApi getCollaborationApi() {
        if (collaborationApi == null) {
            collaborationApi = (CollaborationApi)AppContext.getBean((String)"collaborationApi");
        }
        return collaborationApi;
    }

    static {
        parseRelationPattern = Pattern.compile("(field\\d{4,})");
    }
}

