/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.engin.trigger.action;

import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormDataBean;
import com.seeyon.cap4.form.bean.FormDataMasterBean;
import com.seeyon.cap4.form.bean.FormDataSubBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormTableBean;
import com.seeyon.cap4.form.bean.FormTriggerActionBean;
import com.seeyon.cap4.form.bean.FormTriggerBean;
import com.seeyon.cap4.form.bean.SimpleObjectBean;
import com.seeyon.cap4.form.modules.engin.trigger.FormTriggerActionContext;
import com.seeyon.cap4.form.modules.engin.trigger.FormTriggerUtil;
import com.seeyon.cap4.form.modules.engin.trigger.action.FormTriggerAutoBaseAction;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.form.vo.FormTriggerFillBackResultVo;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.content.mainbody.MainbodyService;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.content.CtpContentAll;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDLong;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;

public class FormTriggerAutoInsertAction
extends FormTriggerAutoBaseAction {
    private static final Log LOGGER = CtpLogFactory.getLog(FormTriggerAutoInsertAction.class);

    public String getId() {
        return FormTriggerBean.TriggerType.AutoInsert.getKey();
    }

    @Override
    public String getActionType() {
        return FormTriggerBean.TriggerType.AutoInsert.getText();
    }

    @Override
    public void execute(FormTriggerActionContext context) throws BusinessException {
        context.setLogOperateType(Enums.CapLogType.AUTOINSERT);
        String msg = this.beforeExecute(context);
        if (Strings.isNotBlank((String)msg)) {
            if (msg.startsWith("\u6743\u9650_")) {
                this.sendErrorMsg(context, msg.replace("\u6743\u9650_", ""), false);
            } else {
                this.saveCheckErrMsg(context, msg);
            }
            return;
        }
        CtpContentAll contentAll = MainbodyService.getInstance().getContent(context.getModuleType(), context.getModuleId());
        if (contentAll == null) {
            this.sendErrorMsg(context, ResourceUtil.getString((String)"form.business.relation.trigger.run.error49"), true);
            return;
        }
        try {
            FormTriggerFillBackResultVo resultVo = new FormTriggerFillBackResultVo();
            FormDataMasterBean matchConditionDataBean = FormTriggerUtil.cloneNowMasterBean(context, context.getMasterBean());
            this.fillMappingData(context, matchConditionDataBean, resultVo);
            HashMap changeTag = new HashMap();
            AppContext.putThreadContext((String)"fieldChangeTag", changeTag);
            FormDataMasterBean toMasterBean = this.getNewMasterBean(context, resultVo);
            this.dealOtherInfoAndValidate(context, toMasterBean, resultVo);
            AppContext.removeThreadContext((String)"fieldChangeTag");
            resultVo.removeDataChangeTagMap(toMasterBean.getId());
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            this.sendErrorMsg(context, ResourceUtil.getString((String)"form.business.relation.trigger.run.error4") + e.getMessage(), true);
        }
    }

    private void fillMappingData(FormTriggerActionContext context, FormDataMasterBean matchConditionDataBean, FormTriggerFillBackResultVo resultVo) throws BusinessException {
        FormBean formBean = context.getFormBean();
        FormTriggerActionBean actionBean = context.getActionBean();
        FormDataMasterBean nowMasterBean = context.getMasterBean();
        Map<String, Object> masterMap = resultVo.getMasterMap();
        Map<String, Map<String, Object>> subMap = resultVo.getSubMap();
        Map<String, FormDataSubBean> sub2Sub = resultVo.getSub2Sub();
        List fillBackList = (List)actionBean.getParam(FormTriggerBean.ActionParam.FillBack.getKey());
        if (Strings.isNotEmpty((Collection)fillBackList)) {
            for (SimpleObjectBean objectBean : fillBackList) {
                String type = objectBean.getType();
                String key = objectBean.getName();
                String value = objectBean.getValue();
                String[] valueTo = key.split("\\.");
                FormTableBean toTableBean = formBean.getTableByTableName(valueTo[0]);
                FormFieldBean toFieldBean = toTableBean.getFieldBeanByName(valueTo[1]);
                if (toFieldBean == null) {
                    LOGGER.error((Object)("\u5b57\u6bb5" + valueTo[1] + " \u89e3\u6790\u5f02\u5e38\uff0c\u5f53\u524d\u7f16\u8f91\u8868\u5355\u4e2d\u672a\u627e\u5230\u6b64\u5b57\u6bb5\uff01\r\n"));
                    continue;
                }
                if (FormTriggerBean.FillBackType.formula.getKey().equals(type)) {
                    String msg = this.fillFormulaData(formBean, matchConditionDataBean, nowMasterBean, toFieldBean, objectBean, masterMap, subMap);
                    if (!Strings.isNotBlank((String)msg)) continue;
                    this.sendErrorMsg(context, msg, false);
                    continue;
                }
                FormFieldBean fromFieldBean = formBean.getFieldBeanByDisplay(value = value.substring(1, value.length() - 1));
                if (fromFieldBean == null) {
                    LOGGER.error((Object)("\u62f7\u8d1d\u578b\u66f4\u65b0\uff0c\u89e3\u6790 " + value + " \u5b57\u6bb5\u5f02\u5e38\uff0c\u8df3\u8fc7\u6b64\u884c\uff01"));
                    continue;
                }
                FormTableBean fromTableBean = formBean.getTableByTableName(fromFieldBean.getOwnerTableName());
                LOGGER.info((Object)("\u81ea\u52a8\u66f4\u65b0\u8868\u5355\uff1a" + formBean.getFormName()));
                if (fromFieldBean.isMasterField()) {
                    FormTriggerUtil.fillMappingValueMap(context, resultVo, masterMap, (FormDataBean)matchConditionDataBean, fromFieldBean, null, toFieldBean, null);
                    continue;
                }
                List subDataList = matchConditionDataBean.getSubData(toFieldBean.getOwnerTableName());
                if (Strings.isEmpty((Collection)subDataList)) {
                    LOGGER.info((Object)"\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u91cd\u590d\u8868\u6570\u636e!");
                    return;
                }
                for (FormDataSubBean fromSubBean : subDataList) {
                    FormDataSubBean newSubBean = sub2Sub.get(fromTableBean.getTableName() + "," + fromSubBean.getId());
                    if (newSubBean == null) {
                        newSubBean = FormTriggerUtil.addNewSubBean(toTableBean, fromSubBean, toTableBean, sub2Sub);
                    }
                    Map valueMap = newSubBean.getRowData();
                    FormTriggerUtil.fillMappingValueMap(context, resultVo, valueMap, (FormDataBean)fromSubBean, fromFieldBean, fromSubBean, toFieldBean, newSubBean);
                    newSubBean.addFieldValue(valueMap);
                }
            }
        }
    }

    private FormDataMasterBean getNewMasterBean(FormTriggerActionContext context, FormTriggerFillBackResultVo resultVo) throws BusinessException {
        List tableBeans;
        FormDataSubBean subBean;
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        valueMap.put(Enums.MasterTableField.start_member_id.getKey(), AppContext.currentUserId());
        valueMap.put(Enums.MasterTableField.modify_member_id.getKey(), AppContext.currentUserId());
        valueMap.put(Enums.MasterTableField.start_date.getKey(), DateUtil.currentTimestamp());
        valueMap.put(Enums.MasterTableField.state.getKey(), Enums.FormDataStateEnum.FLOW_UNOFFICIAL.getKey());
        valueMap.putAll(resultVo.getMasterMap());
        FormBean formBean = context.getFormBean();
        FormDataMasterBean newMasterBean = new FormDataMasterBean(formBean.getMasterTableBean(), new boolean[]{true});
        newMasterBean.addFieldValue(valueMap);
        if (!resultVo.getSub2Sub().isEmpty()) {
            Map<String, Map<String, Object>> subMap = resultVo.getSubMap();
            for (Map.Entry<String, FormDataSubBean> entry : resultVo.getSub2Sub().entrySet()) {
                FormDataSubBean subBean2 = entry.getValue();
                FormTableBean tableBean = subBean2.getFormTable();
                Long newId = UUIDLong.longUUID();
                FormDataSubBean tempSubBean = new FormDataSubBean(tableBean, newMasterBean, new boolean[]{true});
                tempSubBean.addFieldValue(subBean2.getRowData());
                tempSubBean.setId(newId);
                tempSubBean.setFormmainId(newMasterBean.getId().longValue());
                if (subMap.get(entry.getKey()) != null) {
                    tempSubBean.addFieldValue((Map)subMap.get(entry.getKey()));
                }
                tempSubBean.putExtraAttr("NO_NEED_DELETE_SUBLINE_KEY", "NO_NEED_DELETE_SUBLINE_VALUE");
                newMasterBean.addSubData(tableBean.getTableName(), tempSubBean);
            }
        } else if (!resultVo.getSubMap().isEmpty()) {
            for (Map.Entry entry : resultVo.getSubMap().entrySet()) {
                String[] key = ((String)entry.getKey()).split(",");
                FormTableBean tableBean = formBean.getTableByTableName(key[0]);
                subBean = new FormDataSubBean(tableBean, newMasterBean, new boolean[]{true});
                subBean.addFieldValue((Map)entry.getValue());
                subBean.setFormmainId(newMasterBean.getId().longValue());
                newMasterBean.addSubData(tableBean.getTableName(), subBean);
            }
        }
        if (Strings.isNotEmpty((Collection)(tableBeans = formBean.getSubTableBean()))) {
            for (FormTableBean subTableBean : tableBeans) {
                FormTriggerUtil.deleteNullSubData(subTableBean.getTableName(), newMasterBean, false);
                List list = newMasterBean.getSubData(subTableBean.getTableName());
                if (!Strings.isEmpty((Collection)list)) continue;
                subBean = new FormDataSubBean(subTableBean, newMasterBean, new boolean[]{true});
                subBean.setFormmainId(newMasterBean.getId().longValue());
                newMasterBean.addSubData(subTableBean.getTableName(), subBean);
            }
        }
        return newMasterBean;
    }
}

