/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.engin.trigger.action;

import com.seeyon.apps.index.api.IndexApi;
import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormDataMasterBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormTriggerActionBean;
import com.seeyon.cap4.form.bean.FormTriggerBean;
import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.cap4.form.modules.business.BusinessManager;
import com.seeyon.cap4.form.modules.engin.base.formData.CAP4FormDataDAO;
import com.seeyon.cap4.form.modules.engin.base.formData.CAP4FormDataManager;
import com.seeyon.cap4.form.modules.engin.base.formData.CAPFormDataCacheManagerImpl;
import com.seeyon.cap4.form.modules.engin.trigger.CAP4FormTriggerManager;
import com.seeyon.cap4.form.modules.engin.trigger.FormTriggerAbstractBaseAction;
import com.seeyon.cap4.form.modules.engin.trigger.FormTriggerActionContext;
import com.seeyon.cap4.form.modules.engin.trigger.FormTriggerUtil;
import com.seeyon.cap4.form.modules.engin.trigger.TriggerActionContext;
import com.seeyon.cap4.form.modules.engin.trigger.TriggerTaskEvent;
import com.seeyon.cap4.form.modules.event.FormDataAfterSubmitEvent;
import com.seeyon.cap4.form.modules.log.CapRunningLogManager;
import com.seeyon.cap4.form.po.CAPFormTriggerEvent;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.service.CAP4FormManager;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.form.vo.FormTriggerFillBackResultVo;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.constants.ApplicationCategoryEnum;
import com.seeyon.ctp.common.ctpenumnew.manager.EnumManager;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.lock.manager.LockManager;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.lock.Lock;
import com.seeyon.ctp.common.processlog.ProcessLogAction;
import com.seeyon.ctp.common.processlog.manager.ProcessLogManager;
import com.seeyon.ctp.common.usermessage.MessageContent;
import com.seeyon.ctp.common.usermessage.MessageReceiver;
import com.seeyon.ctp.common.usermessage.UserMessageManager;
import com.seeyon.ctp.event.Event;
import com.seeyon.ctp.event.EventDispatcher;
import com.seeyon.ctp.form.modules.serialNumber.SerialCalRecordManager;
import com.seeyon.ctp.form.util.log.FormSingLogUtil;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.StringUtil;
import com.seeyon.ctp.util.Strings;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;

public abstract class FormTriggerBaseActionManager
extends FormTriggerAbstractBaseAction {
    private static final Log LOGGER = CtpLogFactory.getLog(FormTriggerBaseActionManager.class);
    static Map<String, String> errorMap = new HashMap<String, String>();
    static final String FORCE_EXECUTE = "forceExecute";
    static final String BILATERAL_BACK_TRIGGER_RECORD = "bilateralBackTriggerRecord";
    static final String TARGET_MASTER_BEAN_KEY = "TARGET_MASTER_BEAN_KEY";
    static final String TARGET_SUB_BEAN_KEY = "TARGET_SUB_BEAN_KEY";
    static final String TARGET_TABLE_BEAN_KEY = "TARGET_TABLE_BEAN_KEY";
    static final String DATA_MSG = "DATA_MSG";
    static final String CALC_FROM_TRIGGER = "CALC_FROM_TRIGGER";
    protected EnumManager enumManagerNew;
    protected UserMessageManager messageManager;
    protected CAP4FormDataDAO cap4FormDataDAO;
    protected CAP4FormManager cap4FormManager;
    protected CAP4FormDataManager cap4FormDataManager;
    protected CAP4FormCacheManager cap4FormCacheManager;
    private LockManager lockManager;
    ProcessLogManager processLogManager;
    CAP4FormTriggerManager cap4FormTriggerManager;
    protected CapRunningLogManager capRunningLogManager;
    private BusinessManager businessManager;
    CAPFormDataCacheManagerImpl capFormDataCacheManager;
    private boolean hasInit = false;

    public void init() {
        if (this.hasInit) {
            return;
        }
        LOGGER.warn((Object)"\u521d\u59cb\u5316\u89e6\u53d1\u9700\u8981\u7684manager");
        this.hasInit = true;
        this.lockManager = (LockManager)AppContext.getBean((String)"lockManager");
        this.enumManagerNew = (EnumManager)AppContext.getBean((String)"enumManagerNew");
        this.messageManager = (UserMessageManager)AppContext.getBean((String)"userMessageManager");
        this.processLogManager = (ProcessLogManager)AppContext.getBean((String)"processLogManager");
        this.cap4FormDataDAO = (CAP4FormDataDAO)AppContext.getBean((String)"cap4FormDataDAO");
        this.cap4FormManager = (CAP4FormManager)AppContext.getBean((String)"cap4FormManager");
        this.cap4FormDataManager = (CAP4FormDataManager)AppContext.getBean((String)"cap4FormDataManager");
        this.cap4FormCacheManager = (CAP4FormCacheManager)AppContext.getBean((String)"cap4FormCacheManager");
        this.cap4FormTriggerManager = (CAP4FormTriggerManager)AppContext.getBean((String)"cap4FormTriggerManager");
        this.capRunningLogManager = (CapRunningLogManager)AppContext.getBean((String)"capRunningLogManager");
        this.businessManager = (BusinessManager)AppContext.getBean((String)"businessManager4");
        this.capFormDataCacheManager = (CAPFormDataCacheManagerImpl)AppContext.getBean((String)"capFormDataCacheManager");
        errorMap.put("checkRule", "form.baseinfo.checkRule.label");
        errorMap.put("uniqueMarked", "form.unique.marked.label");
    }

    public boolean preExecute(Map<String, Object> param, FormTriggerBean triggerBean, FormTriggerActionBean actionBean, TriggerTaskEvent event) {
        if (event instanceof CAPFormTriggerEvent) {
            this.init();
            CAPFormTriggerEvent capEvent = (CAPFormTriggerEvent)event;
            return this.preExecute(param, triggerBean, actionBean, capEvent);
        }
        return true;
    }

    public boolean preExecute(Map<String, Object> param, FormTriggerBean triggerBean, FormTriggerActionBean actionBean, CAPFormTriggerEvent event) {
        return true;
    }

    public void execute(TriggerActionContext context) throws BusinessException {
        FormTriggerActionContext triggerContext = (FormTriggerActionContext)context;
        this.execute(triggerContext);
    }

    public abstract void execute(FormTriggerActionContext var1) throws BusinessException;

    void checkAndLockData(Long dataId) throws BusinessException, SQLException {
        this.checkAndLockData(dataId, 60000L);
    }

    void checkAndLockData(Long dataId, long millis) throws BusinessException, SQLException {
        boolean label = true;
        while (label) {
            boolean result = this.lockManager.lock(AppContext.currentUserId(), dataId.longValue());
            if (!result) {
                Lock lock = this.cap4FormManager.getLock(dataId);
                if (lock == null) {
                    LOGGER.info((Object)("\u76ee\u6807\u6570\u636e" + dataId + "\u88ab\u5176\u4ed6\u4eba\u9501\u4f4f\uff0c\u4f46\u9501\u5df2\u5931\u6548\uff0c\u76f4\u63a5\u91ca\u653e\u65e0\u6548\u9501"));
                    label = false;
                    continue;
                }
                LOGGER.info((Object)("\u76ee\u6807\u6570\u636e" + dataId + "\u88abuserId:" + lock.getOwner() + "\u9501\u4f4f\uff0c\u6682\u7f13\u6267\u884c\uff0c\u7b49\u5f85\u9501\u91ca\u653e"));
                try {
                    Thread.sleep(millis);
                }
                catch (InterruptedException e) {
                    LOGGER.error((Object)"\u7ebf\u7a0b\u4f11\u7720\u5f02\u5e38", (Throwable)e);
                }
                continue;
            }
            label = false;
            LOGGER.info((Object)("\u7528\u6237 " + AppContext.currentUserId() + " \u5bf9\u76ee\u6807\u6570\u636e\u52a0\u9501\uff1a\u6570\u636eid " + dataId));
        }
    }

    void unLockData(Long dataId) {
        this.lockManager.unlock(dataId.longValue());
        LOGGER.info((Object)("\u7528\u6237 " + AppContext.currentUserId() + " \u5bf9\u76ee\u6807\u6570\u636e\u91ca\u653e\u9501\uff1a\u6570\u636eid " + dataId));
    }

    final String validateUnique(FormBean toFormBean, List<FormDataMasterBean> masterBeans, List<String> changeFieldList) throws BusinessException, SQLException {
        return this.validateUnique(toFormBean, masterBeans, changeFieldList, null, true);
    }

    final String validateUnique(FormBean toFormBean, List<FormDataMasterBean> masterBeans, List<String> changeFieldList, FormDataMasterBean oldMasterBean, boolean needUpdateDataState) throws BusinessException, SQLException {
        LOGGER.info((Object)("\u6821\u9a8c\u552f\u4e00\u6807\u8bc6\u524d\u6267\u884c\u6570\u636e\u4fdd\u5b58\uff1a\u8868\u5355id " + toFormBean.getId() + "; \u4eba\u5458id " + AppContext.currentUserId()));
        String result = "";
        try {
            result = FormTriggerUtil.validateDataUnique(toFormBean, masterBeans);
            if (Strings.isNotBlank((String)result)) {
                LOGGER.error((Object)"\u552f\u4e00\u6807\u8bc6\u6821\u9a8c\u4e0d\u901a\u8fc7\uff0c\u5220\u9664/\u56de\u6eda\u6570\u636e");
                if (needUpdateDataState) {
                    this.cap4FormDataManager.deleteMasterData(masterBeans);
                } else {
                    this.cap4FormDataManager.insertOrUpdateMasterData(oldMasterBean);
                }
            } else if (needUpdateDataState) {
                for (FormDataMasterBean dataBean : masterBeans) {
                    dataBean.setState(Enums.FormDataStateEnum.UNFLOW_UNLOCK.getKey());
                }
                LOGGER.info((Object)"\u552f\u4e00\u6807\u8bc6\u6821\u9a8c\u901a\u8fc7\uff0c\u4fee\u6539\u6570\u636e\u72b6\u6001");
                this.cap4FormDataDAO.updateDataState2Unlock(masterBeans);
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("\u6821\u9a8c\u5f02\u5e38\uff0c\u56de\u6eda\u6570\u636e" + e.getMessage()), (Throwable)e);
            if (needUpdateDataState) {
                this.cap4FormDataManager.deleteMasterData(masterBeans);
            }
            this.cap4FormDataManager.insertOrUpdateMasterData(oldMasterBean);
        }
        return result;
    }

    final void dealOtherInfoAfterValidate(FormTriggerActionContext context, FormBean toFormBean, FormDataMasterBean toMasterBean, FormTriggerFillBackResultVo resultVo, boolean isNew) throws BusinessException {
        for (FormFieldBean field : toFormBean.getAllFieldBeans()) {
            List attValues;
            if (!field.isEnumField() || (attValues = toMasterBean.getDataList(field.getName())).size() <= 0) continue;
            try {
                for (Object objVal : attValues) {
                    String objValStr = String.valueOf(objVal);
                    if (StringUtil.checkNull((String)objValStr) || "0".equals(objValStr)) continue;
                    this.enumManagerNew.updateEnumItemRef(Long.valueOf(Long.parseLong(objValStr)));
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"\u66f4\u65b0\u679a\u4e3e\u72b6\u6001\u5f02\u5e38\u2026\u2026", (Throwable)e);
            }
        }
        List serialRecordList = (List)toMasterBean.getExtraAttr("serialCalRecords");
        if (Strings.isNotEmpty((Collection)serialRecordList)) {
            SerialCalRecordManager serialCalRecordManager = (SerialCalRecordManager)AppContext.getBean((String)"serialCalRecordManager");
            serialCalRecordManager.save(serialRecordList);
        }
        FormTriggerUtil.dealSpecialFieldData(context, toMasterBean, resultVo, isNew);
        FormDataAfterSubmitEvent afterEvent = new FormDataAfterSubmitEvent(toMasterBean);
        EventDispatcher.fireEvent((Event)afterEvent);
    }

    protected final void getNewRecord(FormTriggerActionContext context, Long contentId, String desc, FormTriggerBean.TriggerState state, Collection<Long> subDataIds) throws BusinessException {
        this.cap4FormTriggerManager.getNewRecord((TriggerActionContext)context, contentId, desc, state, subDataIds);
    }

    final void refreshOtherModuleInfo(FormBean toFormBean, FormDataMasterBean toMasterBean) throws BusinessException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("formBean", toFormBean);
        params.put("formDataMasterBean", toMasterBean);
        params.put("moduleId", toMasterBean.getId());
        this.cap4FormDataManager.refreshCustomControls(params);
        if (AppContext.hasPlugin((String)"index")) {
            IndexApi indexApi = (IndexApi)AppContext.getBean((String)"indexApi");
            indexApi.update(toMasterBean.getId(), Integer.valueOf(ApplicationCategoryEnum.form.getKey()));
        }
    }

    final void saveCheckErrMsg(FormTriggerActionContext context, String reason) throws BusinessException {
        String errorMsg = ResourceUtil.getString((String)"form.business.relation.trigger.run.error5", (Object)context.getTitle(), (Object)context.getLogOperateType().getText()) + reason;
        this.saveLog(context.getFormBean(), context.getMasterBean(), errorMsg, context.getLogOperateType());
    }

    final void sendErrorMsg(FormTriggerActionContext context, FormBean toFormBean, String prefix, String error, boolean needSend) throws BusinessException {
        FormBean formBean = context.getFormBean();
        Set<Long> errorReceivers = context.getErrorReceivers();
        String errorMsg = prefix + error;
        try {
            String fileName = FormSingLogUtil.getInstance().saveLogForCap4(errorMsg, (TriggerActionContext)context);
            errorMsg = errorMsg + " " + ResourceUtil.getString((String)"form.business.relation.trigger.run.error8") + fileName;
            this.saveLog(formBean, context.getMasterBean(), errorMsg, context.getLogOperateType());
        }
        catch (Exception e) {
            LOGGER.error((Object)("\u6dfb\u52a0\u65e5\u5fd7\u5f02\u5e38" + e.getMessage()), (Throwable)e);
        }
        LOGGER.error((Object)errorMsg);
        if (needSend) {
            this.saveFailMsg(toFormBean, context.getLogOperateType(), context.getTitle(), error);
            this.messageManager.sendSystemMessage(MessageContent.get((String)errorMsg, (Object[])new Object[0]), ApplicationCategoryEnum.cap4Form, 2L, MessageReceiver.get((Long)-1L, errorReceivers), new Object[0]);
            if (formBean.isFlowForm()) {
                ProcessLogAction logAction = ProcessLogAction.createUnFlow;
                if (toFormBean.isFlowForm()) {
                    logAction = ProcessLogAction.createFlow;
                }
                this.processLogManager.insertLog(AppContext.getCurrentUser(), Long.parseLong(FormTriggerUtil.getColSummaryByContent(context.getModuleId()).getProcessId()), 1L, logAction, new String[]{errorMsg});
            }
        }
    }

    protected final void saveFailMsg(FormBean toFormBean, Enums.CapLogType operateType, String flowTitle, String errorMsg) {
        try {
            String msg = "\u300a" + flowTitle + "\u300b" + ResourceUtil.getString((String)"form.trigger.operate.fail.all.label") + errorMsg;
            LOGGER.error((Object)msg);
            BizConfigBean bizConfig = this.businessManager.findBizConfigByFormId(toFormBean.getId());
            Long bizId = 0L;
            String bizName = "\u8868\u5355\u7ba1\u7406";
            if (bizConfig != null) {
                bizId = bizConfig.getId();
                bizName = bizConfig.getName();
            } else {
                LOGGER.error((Object)("\u5f53\u524d\u8868\u5355\u4e0d\u5728\u4e1a\u52a1\u5305\u5185\uff0c\u5c5e\u4e8e\u8868\u5355\u7ba1\u7406\u8868\u5355\uff0c\u8868\u5355\uff1a" + toFormBean.getId() + toFormBean.getFormName()));
            }
            this.capRunningLogManager.saveRunningLog(bizId, bizName, toFormBean.getId(), toFormBean.getFormName(), 0L, Enums.CapLogType.OPERATEFAIL.getKey(), msg, 0L, AppContext.currentUserId(), DateUtil.currentDate(), AppContext.currentAccountName(), AppContext.getRemoteAddr());
        }
        catch (Exception e) {
            LOGGER.error((Object)("\u64cd\u4f5c\u65e5\u5fd7\u8bb0\u5f55\u5f02\u5e38......" + e.getMessage()), (Throwable)e);
        }
    }

    protected void saveLog(FormBean formBean, FormDataMasterBean masterBean, String logDesc, Enums.CapLogType type) {
        this.cap4FormTriggerManager.saveLog(formBean, masterBean, logDesc, type, 0L, AppContext.currentAccountName(), AppContext.getRemoteAddr());
    }
}

