/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.engin.trigger.action;

import com.seeyon.apps.collaboration.api.CollaborationApi;
import com.seeyon.apps.collaboration.constants.ColConstant;
import com.seeyon.cap4.form.bean.FormAuthViewBean;
import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormDataMasterBean;
import com.seeyon.cap4.form.bean.FormDataSubBean;
import com.seeyon.cap4.form.bean.FormTableBean;
import com.seeyon.cap4.form.bean.FormTriggerBean;
import com.seeyon.cap4.form.modules.engin.trigger.FormTriggerActionContext;
import com.seeyon.cap4.form.modules.engin.trigger.FormTriggerUtil;
import com.seeyon.cap4.form.modules.engin.trigger.action.FormTriggerCreateBaseAction;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.form.util.FormUtil;
import com.seeyon.cap4.form.vo.FormTriggerFillBackResultVo;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.authenticate.domain.User;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.template.CtpTemplate;
import com.seeyon.ctp.common.template.manager.TemplateManager;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDLong;
import com.seeyon.ctp.workflow.wapi.WorkflowApiManager;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;

public class FormTriggerCreateFlowAction
extends FormTriggerCreateBaseAction {
    private static final Log LOGGER = CtpLogFactory.getLog(FormTriggerCreateFlowAction.class);

    public String getId() {
        return FormTriggerBean.TriggerType.CreateFlow.getKey();
    }

    @Override
    public void execute(FormTriggerActionContext context) throws BusinessException {
        if (context.isMagic()) {
            context.setLogOperateType(Enums.CapLogType.MAGICCREATEFLOW);
        } else {
            context.setLogOperateType(Enums.CapLogType.CREATEFLOW);
        }
        if (!context.getTriggerBean().isEnable()) {
            LOGGER.warn((Object)"\u5f53\u524d\u89e6\u53d1\u5df2\u505c\u7528\uff0c\u4e0d\u6267\u884c");
            this.saveCheckErrMsg(context, ResourceUtil.getString((String)"form.business.relation.trigger.run.error1"));
            return;
        }
        Long toFormId = context.getTriggerBean().getTargetFormId();
        FormBean targetFormBean = this.cap4FormCacheManager.getForm(toFormId);
        if (targetFormBean == null || !this.cap4FormCacheManager.isEnabled(targetFormBean)) {
            LOGGER.warn((Object)"\u627e\u4e0d\u5230\u76ee\u6807\u8868\u5355\u6216\u8005\u76ee\u6807\u8868\u5355\u4e0d\u53ef\u7528\uff0c\u4e0d\u6267\u884c\u6b64\u52a8\u4f5c");
            this.saveCheckErrMsg(context, ResourceUtil.getString((String)"form.business.relation.trigger.run.error2"));
            return;
        }
        Long templateId = Long.valueOf((String)context.getActionBean().getParam(FormTriggerBean.ActionParam.TemplateId.getKey()));
        TemplateManager templateManager = (TemplateManager)AppContext.getBean((String)"templateManager");
        CtpTemplate template = templateManager.getCtpTemplate(templateId);
        if (null == template || template.isDelete().booleanValue()) {
            this.sendErrorMsg(context, targetFormBean, ResourceUtil.getString((String)"form.business.relation.trigger.run.error3"), true);
            return;
        }
        String templateName = template.getSubject();
        Map<Long, Map<String, List<FormDataSubBean>>> senderMap = FormTriggerUtil.getTriggerSenderList(context);
        if (senderMap.isEmpty()) {
            this.sendErrorMsg(context, targetFormBean, ResourceUtil.getString((String)"form.trigger.triggerSet.actions.error.sender.empty"), false);
            return;
        }
        for (Map.Entry<Long, Map<String, List<FormDataSubBean>>> entry : senderMap.entrySet()) {
            if (entry.getKey() == null || entry.getKey() == 0L || entry.getKey() == -1L) continue;
            Map<String, List<FormDataSubBean>> subMap = entry.getValue();
            if (subMap == null) {
                this.doTriggerExecute(context, targetFormBean, templateName, template, entry.getKey(), null, null);
                continue;
            }
            for (Map.Entry<String, List<FormDataSubBean>> et : subMap.entrySet()) {
                this.doTriggerExecute(context, targetFormBean, templateName, template, entry.getKey(), et.getKey(), et.getValue());
            }
        }
    }

    private void doTriggerExecute(FormTriggerActionContext context, FormBean targetFormBean, String templateName, CtpTemplate template, Long sender, String subTableName, List<FormDataSubBean> subBeanList) throws BusinessException {
        try {
            String localeKey = context.getParam().get("userLocale") == null ? null : String.valueOf(context.getParam().get("userLocale"));
            String ipAddress = context.getParam().get("ipAddress") == null ? null : String.valueOf(context.getParam().get("ipAddress"));
            User user = FormTriggerUtil.getCurrentUser4TriggerAction(sender, FormTriggerUtil.getLocale(localeKey), ipAddress);
            AppContext.putThreadContext((String)"SESSION_CONTEXT_USERINFO_KEY", (Object)user);
            FormTriggerFillBackResultVo resultVo = new FormTriggerFillBackResultVo();
            CollaborationApi service = (CollaborationApi)AppContext.getBean((String)"collaborationApi");
            WorkflowApiManager wapi = (WorkflowApiManager)AppContext.getBean((String)"wapi");
            String operationId = FormUtil.parseOperationId((String)wapi.getNodeFormOperationName(template.getWorkflowId(), null));
            FormAuthViewBean authViewBean = targetFormBean.getAuthViewBeanById(Long.valueOf(operationId));
            List<FormDataMasterBean> masterBeans = this.getFormDataMaserBeanList(context, targetFormBean, authViewBean, sender, resultVo, subTableName, subBeanList);
            for (FormDataMasterBean targetMasterBean : masterBeans) {
                this.dealOtherInfoAfterValidate(context, targetFormBean, targetMasterBean, resultVo, true);
                service.transSendColl(ColConstant.SendType.auto, template.getId(), sender, targetMasterBean.getId(), null, targetMasterBean.getId());
                this.saveNewLog(context, targetFormBean, targetMasterBean);
                this.getNewRecord(context, targetMasterBean.getId(), targetFormBean.getId() + "|" + targetMasterBean.getId(), FormTriggerBean.TriggerState.TRIGGERED, context.getDateSubIds());
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            this.sendErrorMsg(context, targetFormBean, ResourceUtil.getString((String)"form.business.relation.trigger.run.error4") + e.getMessage(), true);
        }
    }

    private List<FormDataMasterBean> getFormDataMaserBeanList(FormTriggerActionContext context, FormBean targetFormBean, FormAuthViewBean authViewBean, Long sender, FormTriggerFillBackResultVo resultVo, String subTableName, List<FormDataSubBean> subBeanList) throws BusinessException, SQLException, CloneNotSupportedException {
        FormTriggerUtil.fillMappingData(context, targetFormBean, resultVo, subTableName, subBeanList);
        List<FormDataMasterBean> masterBeans = this.getMasterBeanList(context, targetFormBean, authViewBean, sender, resultVo, subTableName, subBeanList, false);
        List<String> targetSubFieldList = resultVo.getTargetSubFieldList();
        for (FormDataMasterBean dataBean : masterBeans) {
            AppContext.putThreadContext((String)"fieldChangeTag", resultVo.getDataChangeTagMap(dataBean.getId()));
            if (!resultVo.getSub2Sub().isEmpty()) {
                Map<String, Map<String, Object>> subMap = resultVo.getSubMap();
                for (Map.Entry<String, FormDataSubBean> entry : resultVo.getSub2Sub().entrySet()) {
                    FormDataSubBean subBean = entry.getValue();
                    FormTableBean tableBean = targetFormBean.getTableByTableName((String)subBean.getExtraAttr("tableName"));
                    Map subVMap = subBean.getRowData();
                    Long newId = UUIDLong.longUUID();
                    subVMap.put(Enums.SubTableField.id.getKey(), newId);
                    if (subMap.get(tableBean.getTableName()) != null) {
                        subVMap.putAll(subMap.get(tableBean.getTableName()));
                    }
                    FormDataSubBean tempSubBean = new FormDataSubBean(tableBean, dataBean, new boolean[]{true});
                    if (Strings.isNotEmpty(targetSubFieldList)) {
                        for (String field : targetSubFieldList) {
                            if (tableBean.getFieldBeanByName(field) == null) continue;
                            tempSubBean.addFieldValue(field, subVMap.get(field));
                        }
                        tempSubBean.setId((Long)subVMap.get(Enums.SubTableField.id.getKey()));
                        tempSubBean.addFieldValue(Enums.SubTableField.id.getKey(), subVMap.get(Enums.SubTableField.id.getKey()));
                    }
                    tempSubBean.setFormmainId(dataBean.getId().longValue());
                    tempSubBean.putExtraAttr("NO_NEED_DELETE_SUBLINE_KEY", "NO_NEED_DELETE_SUBLINE_VALUE");
                    dataBean.addSubData(tableBean.getTableName(), tempSubBean);
                    FormTriggerUtil.addTriggerSourceRecord(context, resultVo, "sub2sub", Long.valueOf(entry.getKey().split(",")[1]), dataBean.getId(), tableBean, newId);
                }
            }
            FormTriggerUtil.addEmptySubLineAndFillMain2SubData(context, targetFormBean, dataBean, resultVo, true);
            this.dealOtherInfoBeforeValidate(targetFormBean, dataBean, authViewBean, resultVo, true);
            AppContext.removeThreadContext((String)"fieldChangeTag");
            resultVo.removeDataChangeTagMap(dataBean.getId());
        }
        this.cap4FormDataManager.insertMasterData(masterBeans);
        return masterBeans;
    }

    private void sendErrorMsg(FormTriggerActionContext context, FormBean toFormBean, String reason, boolean needSend) throws BusinessException {
        String error = (String)errorMap.get(reason);
        String prefix = ResourceUtil.getString((String)"form.business.relation.trigger.run.error6", (Object)(context.getFormBean().isFlowForm() ? context.getTitle() : context.getFormBean().getFormName()), (Object)context.getTriggerBean().getName(), (Object)toFormBean.getFormName(), (Object)ResourceUtil.getString((String)"processLog.action.name.72"));
        error = Strings.isNotBlank((String)error) ? ResourceUtil.getString((String)"form.business.relation.trigger.run.error7", (Object)ResourceUtil.getString((String)"form.business.relation.trigger.run.error11"), (Object)ResourceUtil.getString((String)error)) : reason;
        this.sendErrorMsg(context, toFormBean, prefix, error, needSend);
    }
}

