/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.engin.trigger.action;

import com.seeyon.cap4.form.bean.FormAuthViewBean;
import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormDataMasterBean;
import com.seeyon.cap4.form.bean.FormDataSubBean;
import com.seeyon.cap4.form.bean.FormTableBean;
import com.seeyon.cap4.form.bean.FormTriggerBean;
import com.seeyon.cap4.form.modules.engin.trigger.FormTriggerActionContext;
import com.seeyon.cap4.form.modules.engin.trigger.FormTriggerUtil;
import com.seeyon.cap4.form.modules.engin.trigger.action.FormTriggerCreateBaseAction;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.form.vo.FormTriggerFillBackResultVo;
import com.seeyon.cap4.form.vo.FormTriggerRecordVo;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.ModuleType;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDLong;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;

public class FormTriggerCreateUnflowAction
extends FormTriggerCreateBaseAction {
    private static final Log LOGGER = CtpLogFactory.getLog(FormTriggerCreateUnflowAction.class);

    public String getId() {
        return FormTriggerBean.TriggerType.CreateUnflow.getKey();
    }

    @Override
    public void execute(FormTriggerActionContext context) throws BusinessException {
        if (context.isMagic()) {
            context.setLogOperateType(Enums.CapLogType.MAGICCREATEUNFLOW);
        } else {
            context.setLogOperateType(Enums.CapLogType.CREATEUNFLOW);
        }
        if (!context.getTriggerBean().isEnable()) {
            LOGGER.error((Object)"\u5f53\u524d\u89e6\u53d1\u5df2\u505c\u7528\uff0c\u4e0d\u6267\u884c");
            this.saveCheckErrMsg(context, ResourceUtil.getString((String)"form.business.relation.trigger.run.error1"));
            return;
        }
        Long toFormId = context.getTriggerBean().getTargetFormId();
        if (context.getFormBean().getId().equals(toFormId)) {
            LOGGER.error((Object)"\u76ee\u6807\u8868\u5355\u548c\u5f53\u524d\u8868\u5355\u662f\u540c\u4e00\u4e2a\u8868\u5355\uff0c\u5f02\u5e38\u8bbe\u7f6e\uff0c\u4e0d\u6267\u884c\u6b64\u52a8\u4f5c");
            this.saveCheckErrMsg(context, ResourceUtil.getString((String)"form.business.relation.trigger.run.error9"));
            return;
        }
        FormBean toFormBean = this.cap4FormCacheManager.getForm(toFormId);
        if (toFormBean == null || !this.cap4FormCacheManager.isEnabled(toFormBean)) {
            LOGGER.error((Object)"\u627e\u4e0d\u5230\u76ee\u6807\u8868\u5355\u6216\u8005\u76ee\u6807\u8868\u5355\u4e0d\u53ef\u7528\uff0c\u4e0d\u6267\u884c\u6b64\u52a8\u4f5c");
            this.saveCheckErrMsg(context, ResourceUtil.getString((String)"form.business.relation.trigger.run.error2"));
            return;
        }
        String dataRight = String.valueOf(context.getActionBean().getParam(FormTriggerBean.ActionParam.DataRight.getKey()));
        String addStr = Strings.isEmpty((String)dataRight) ? "" : dataRight.split(",")[0];
        Long addRightId = Strings.isEmpty((String)addStr) ? 0L : Long.valueOf(addStr.split("\\.")[1]);
        FormAuthViewBean authViewBean = toFormBean.getAuthViewBeanById(addRightId);
        if (authViewBean == null) {
            this.sendErrorMsg(context, toFormBean, ResourceUtil.getString((String)"form.business.relation.trigger.run.error10"), true);
            return;
        }
        Map<Long, Map<String, List<FormDataSubBean>>> senderMap = FormTriggerUtil.getTriggerSenderList(context);
        if (senderMap.isEmpty()) {
            this.sendErrorMsg(context, toFormBean, ResourceUtil.getString((String)"form.trigger.triggerSet.actions.error.sender.empty"), false);
            return;
        }
        for (Map.Entry<Long, Map<String, List<FormDataSubBean>>> entry : senderMap.entrySet()) {
            if (entry.getKey() == null || entry.getKey() == 0L || entry.getKey() == -1L) continue;
            Map<String, List<FormDataSubBean>> subMap = entry.getValue();
            if (subMap == null) {
                this.doTriggerExecute4NotSync(context, toFormBean, authViewBean, 0L, entry.getKey(), null, null);
                continue;
            }
            for (Map.Entry<String, List<FormDataSubBean>> et : subMap.entrySet()) {
                this.doTriggerExecute4NotSync(context, toFormBean, authViewBean, 0L, entry.getKey(), et.getKey(), et.getValue());
            }
        }
    }

    private void doTriggerExecute4NotSync(FormTriggerActionContext context, FormBean toFormBean, FormAuthViewBean authViewBean, Long templateId, Long sender, String subTableName, List<FormDataSubBean> subBeanList) throws BusinessException {
        FormTriggerUtil.addCurrentUser4TriggerAction(sender);
        FormTriggerFillBackResultVo resultVo = new FormTriggerFillBackResultVo();
        try {
            List<FormDataMasterBean> masterBeans = this.getMasterBeanList4NotSync(context, toFormBean, authViewBean, sender, resultVo, subTableName, subBeanList);
            String flag = FormTriggerUtil.validateCheckRule(toFormBean, masterBeans);
            if (Strings.isEmpty((String)flag)) {
                this.cap4FormDataManager.insertMasterData(masterBeans);
                flag = this.validateUnique(toFormBean, masterBeans, null);
            }
            if (Strings.isNotBlank((String)flag)) {
                this.sendErrorMsg(context, toFormBean, flag, true);
                return;
            }
            for (FormDataMasterBean targetMasterBean : masterBeans) {
                this.dealOtherInfoAfterValidate(context, toFormBean, targetMasterBean, resultVo, true);
                FormTriggerUtil.saveDataAndContent(toFormBean, targetMasterBean, AppContext.currentUserId(), "");
                this.saveNewLog(context, toFormBean, targetMasterBean);
                FormTriggerRecordVo recordVo = resultVo.getRecordVo(context.getMasterBean(), targetMasterBean);
                this.getNewRecord(context, targetMasterBean.getId(), recordVo.toJSON(), FormTriggerBean.TriggerState.TRIGGERED, context.getDateSubIds());
                if (context.getFormBean().isFlowForm()) {
                    this.cap4FormTriggerManager.doTrigger(ModuleType.cap4UnflowForm.getKey(), (long)targetMasterBean.getId(), (long)toFormBean.getId(), authViewBean.getId().toString(), null, false, "createUnFlow");
                    continue;
                }
                if (context.isTime()) {
                    context.addQuartzDataVo(ModuleType.cap4UnflowForm.getKey(), targetMasterBean.getId(), toFormBean.getId(), authViewBean.getId().toString(), null, false, AppContext.currentUserId(), AppContext.getCurrentUser().getLocale());
                    continue;
                }
                this.cap4FormTriggerManager.doTrigger(ModuleType.cap4UnflowForm.getKey(), (long)targetMasterBean.getId(), (long)toFormBean.getId(), authViewBean.getId().toString(), null, false, "createUnFlow");
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            this.sendErrorMsg(context, toFormBean, ResourceUtil.getString((String)"form.business.relation.trigger.run.error4") + e.getMessage(), true);
        }
    }

    private List<FormDataMasterBean> getMasterBeanList4NotSync(FormTriggerActionContext context, FormBean toFormBean, FormAuthViewBean authViewBean, Long sender, FormTriggerFillBackResultVo resultVo, String subTableName, List<FormDataSubBean> subBeanList) throws BusinessException, SQLException {
        FormTriggerUtil.fillMappingData(context, toFormBean, resultVo, subTableName, subBeanList);
        List<FormDataMasterBean> masterBeans = this.getMasterBeanList(context, toFormBean, authViewBean, sender, resultVo, subTableName, subBeanList, true);
        List<String> targetSubFieldList = resultVo.getTargetSubFieldList();
        for (FormDataMasterBean dataBean : masterBeans) {
            AppContext.putThreadContext((String)"fieldChangeTag", resultVo.getDataChangeTagMap(dataBean.getId()));
            if (!resultVo.getSub2Sub().isEmpty()) {
                Map<String, Map<String, Object>> subMap = resultVo.getSubMap();
                for (Map.Entry<String, FormDataSubBean> entry : resultVo.getSub2Sub().entrySet()) {
                    FormDataSubBean subBean = entry.getValue();
                    FormTableBean tableBean = subBean.getFormTable();
                    Map subVMap = subBean.getRowData();
                    Long newId = UUIDLong.longUUID();
                    subVMap.put(Enums.SubTableField.id.getKey(), newId);
                    if (subMap.get(tableBean.getTableName()) != null) {
                        subVMap.putAll(subMap.get(tableBean.getTableName()));
                    }
                    FormDataSubBean tempSubBean = new FormDataSubBean(tableBean, dataBean, new boolean[]{true});
                    if (Strings.isNotEmpty(targetSubFieldList)) {
                        for (String field : targetSubFieldList) {
                            if (tableBean.getFieldBeanByName(field) == null) continue;
                            tempSubBean.addFieldValue(field, subVMap.get(field));
                        }
                        tempSubBean.setId((Long)subVMap.get(Enums.SubTableField.id.getKey()));
                        tempSubBean.addFieldValue(Enums.SubTableField.id.getKey(), subVMap.get(Enums.SubTableField.id.getKey()));
                    }
                    tempSubBean.setFormmainId(dataBean.getId().longValue());
                    tempSubBean.putExtraAttr("NO_NEED_DELETE_SUBLINE_KEY", "NO_NEED_DELETE_SUBLINE_VALUE");
                    dataBean.addSubData(tableBean.getTableName(), tempSubBean);
                    resultVo.addSub2SubRecord(context.getMasterBean(), dataBean, entry.getKey(), tempSubBean);
                    FormTriggerUtil.addTriggerSourceRecord(context, resultVo, "sub2sub", Long.valueOf(entry.getKey().split(",")[1]), dataBean.getId(), tableBean, newId);
                }
            }
            FormTriggerUtil.addEmptySubLineAndFillMain2SubData(context, toFormBean, dataBean, resultVo, true);
            this.dealOtherInfoBeforeValidate(toFormBean, dataBean, authViewBean, resultVo, true);
            AppContext.removeThreadContext((String)"fieldChangeTag");
            resultVo.removeDataChangeTagMap(dataBean.getId());
        }
        return masterBeans;
    }

    private void sendErrorMsg(FormTriggerActionContext context, FormBean toFormBean, String reason, boolean needSend) throws BusinessException {
        String error = (String)errorMap.get(reason);
        String prefix = ResourceUtil.getString((String)"form.business.relation.trigger.run.error6", (Object)(context.getFormBean().isFlowForm() ? context.getTitle() : context.getFormBean().getFormName()), (Object)context.getTriggerBean().getName(), (Object)toFormBean.getFormName(), (Object)ResourceUtil.getString((String)"processLog.action.name.73"));
        error = Strings.isNotBlank((String)error) ? ResourceUtil.getString((String)"form.business.relation.trigger.run.error7", (Object)ResourceUtil.getString((String)"form.business.relation.trigger.run.error11"), (Object)ResourceUtil.getString((String)error)) : reason;
        this.sendErrorMsg(context, toFormBean, prefix, error, needSend);
    }
}

