/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.engin.trigger.action;

import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormDataMasterBean;
import com.seeyon.cap4.form.bean.FormTriggerActionBean;
import com.seeyon.cap4.form.bean.FormTriggerBean;
import com.seeyon.cap4.form.bean.FormTriggerConditionBean;
import com.seeyon.cap4.form.modules.engin.base.formData.CAPFormDataCacheManagerImpl;
import com.seeyon.cap4.form.modules.engin.trigger.CAP4FormTriggerManager;
import com.seeyon.cap4.form.modules.engin.trigger.FormTriggerActionContext;
import com.seeyon.cap4.form.modules.engin.trigger.TriggerTaskEvent;
import com.seeyon.cap4.form.po.CAP4FormTriggerRecord;
import com.seeyon.cap4.form.po.CAPFormTriggerEvent;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.service.CAP4FormManager;
import com.seeyon.cap4.form.vo.FormTriggerQuartzDataVo;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.LRUMap;
import com.seeyon.ctp.util.ParamUtil;
import com.seeyon.ctp.util.StringUtil;
import com.seeyon.ctp.util.Strings;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;

public class FormTriggerExecutor {
    private static final Log LOGGER = CtpLogFactory.getLog(FormTriggerExecutor.class);
    private static LRUMap<Long, List<Long>> dataExecuteMap = new LRUMap(5000);
    static final String TRIGGER_CONTEXT_KEY = "executeContext_";
    private CAP4FormManager cap4FormManager = (CAP4FormManager)AppContext.getBean((String)"cap4FormManager");
    private CAP4FormCacheManager cap4FormCacheManager = (CAP4FormCacheManager)AppContext.getBean((String)"cap4FormCacheManager");
    private CAP4FormTriggerManager cap4FormTriggerManager = (CAP4FormTriggerManager)AppContext.getBean((String)"cap4FormTriggerManager");
    private CAPFormDataCacheManagerImpl capFormDataCacheManager = (CAPFormDataCacheManagerImpl)AppContext.getBean((String)"capFormDataCacheManager");
    private static final FormTriggerExecutor executor = new FormTriggerExecutor();

    private FormTriggerExecutor() {
    }

    public static FormTriggerExecutor getInstance() {
        return executor;
    }

    public FormTriggerActionContext getContext(Map<String, Object> param, FormTriggerBean triggerBean, FormTriggerActionBean actionBean, TriggerTaskEvent event) throws BusinessException, SQLException {
        boolean isAuto;
        CAPFormTriggerEvent capEvent = null;
        if (event instanceof CAPFormTriggerEvent) {
            capEvent = (CAPFormTriggerEvent)event;
        } else {
            LOGGER.error((Object)"\u8c03\u5ea6event\u4e3a\u7a7a\uff0c\u6216\u8005\u5f53\u524d\u8c03\u5ea6\u975eCAPFormTriggerEvent");
        }
        long masterId = ParamUtil.getLong(param, (String)"masterId", (Long)0L);
        boolean bl = isAuto = param.get("isAuto") == null ? false : (Boolean)param.get("isAuto");
        if (isAuto && this.isExistInDataExecMap(masterId)) {
            LOGGER.warn((Object)("\u8b66\u544a\uff1a\u5f53\u524d\u6570\u636e\u5b58\u5728\u6b7b\u5faa\u73af\uff0c\u6570\u636e\uff1a" + masterId));
            return null;
        }
        FormTriggerActionContext context = null;
        String key = masterId + "_" + (actionBean == null ? 0L : actionBean.getId());
        if (AppContext.getThreadContext((String)(TRIGGER_CONTEXT_KEY + key)) != null) {
            context = (FormTriggerActionContext)AppContext.getThreadContext((String)(TRIGGER_CONTEXT_KEY + key));
        }
        if (context == null) {
            context = this.getContext(param, triggerBean, actionBean, capEvent);
        }
        if (context == null) {
            LOGGER.warn((Object)"\u6b64\u6b21\u89e6\u53d1\u4e0d\u6267\u884c\uff01");
            return null;
        }
        return context;
    }

    private FormTriggerActionContext getContext(Map<String, Object> param, FormTriggerBean triggerBean, FormTriggerActionBean actionBean, CAPFormTriggerEvent event) throws BusinessException, SQLException {
        FormBean formBean = (FormBean)param.get("FormBean");
        if (formBean == null) {
            long formId = ParamUtil.getLong(param, (String)"formId", (Long)0L);
            formBean = this.cap4FormCacheManager.getForm(formId);
        }
        param.put("FormBean", formBean);
        long masterId = ParamUtil.getLong(param, (String)"masterId", (Long)0L);
        FormDataMasterBean masterBean = this.capFormDataCacheManager.get4Data(masterId, formBean.getId());
        if (masterBean == null) {
            LOGGER.error((Object)"\u5f53\u524d\u6570\u636e\u88ab\u5220\u9664\uff0c\u4e0d\u6267\u884c\u89e6\u53d1\uff01");
            return null;
        }
        param.put("masterBean", masterBean);
        String subDataIds = ParamUtil.getString(param, (String)"dateSubDataIds");
        FormTriggerActionContext context = new FormTriggerActionContext(param, triggerBean, actionBean, event);
        if (triggerBean != null && actionBean != null) {
            List<CAP4FormTriggerRecord> recordList = new ArrayList<CAP4FormTriggerRecord>();
            boolean isDistribution = actionBean.getType().equals(FormTriggerBean.TriggerType.Distribution.getKey()) || actionBean.getType().equals(FormTriggerBean.TriggerType.DataMagicInterface.getKey()) || actionBean.getType().equals(FormTriggerBean.TriggerType.DataMagicOuterForm.getKey());
            boolean isFeedBack = isDistribution && formBean.getId().equals(triggerBean.getTargetFormId());
            LOGGER.info((Object)("\u662f\u5426\u53cd\u9988isFeedBack" + isFeedBack + " \u8868\u5355ID\uff1a" + formBean.getId() + " \u4e3b\u8868Number:" + formBean.getMasterTableBean().getTableName() + " \u76ee\u6807\u8868ID\uff1a" + triggerBean.getTargetFormId()));
            if (!isFeedBack) {
                recordList = this.cap4FormTriggerManager.getRecordList(formBean, (Long)masterId, triggerBean.getId(), actionBean.getId());
            }
            if (this.checkNeedExecute(context, formBean, triggerBean, actionBean, recordList, subDataIds, masterId)) {
                return null;
            }
            context.setRecord4History(recordList);
        }
        String key = masterBean.getId() + "_" + (actionBean == null ? 0L : actionBean.getId());
        AppContext.putThreadContext((String)(TRIGGER_CONTEXT_KEY + key), (Object)context);
        return context;
    }

    private boolean checkNeedExecute(FormTriggerActionContext context, FormBean formBean, FormTriggerBean triggerBean, FormTriggerActionBean actionBean, List<CAP4FormTriggerRecord> recordList, String subDataIds, long masterId) throws BusinessException {
        boolean hasTriggered = false;
        CAP4FormTriggerRecord tempRecord = null;
        if (Strings.isNotEmpty(recordList)) {
            StringBuilder contentDesc = new StringBuilder();
            for (CAP4FormTriggerRecord record : recordList) {
                if (Strings.isNotEmpty((String)record.getTriggerContentDesc())) {
                    String desc = record.getTriggerContentDesc();
                    if (desc.contains("|")) {
                        desc = desc.split("\\|")[0];
                    }
                    contentDesc.append(desc).append("|");
                }
                if (tempRecord != null && record.getLastTriggerTime().compareTo(tempRecord.getLastTriggerTime()) <= 0) continue;
                tempRecord = record;
            }
            triggerBean.putExtraAttr("triggerContentDesc_" + masterId, contentDesc.toString());
            context.getParam().put("triggerContentDesc", contentDesc.toString());
        }
        if (tempRecord != null) {
            if (formBean.isFlowForm()) {
                boolean perRatifyFlag;
                FormTriggerBean oldBean = new FormTriggerBean(tempRecord.getTriggerJson());
                boolean bl = perRatifyFlag = !formBean.getFormTriggerIdList().contains(oldBean.getId()) || FormTriggerBean.TriggerPoint.FlowState_PerRatify.getKey().equals(oldBean.getTriggerPoint());
                if (perRatifyFlag) {
                    hasTriggered = false;
                } else if (tempRecord.getState().intValue() == FormTriggerBean.TriggerState.TRIGGERED.getKey()) {
                    hasTriggered = true;
                }
            } else if (!actionBean.getType().equals(FormTriggerBean.TriggerType.Distribution.getKey()) || !formBean.getId().equals(triggerBean.getTargetFormId())) {
                boolean unFlowFlag;
                FormTriggerConditionBean timeCondition = triggerBean.getDateCondition();
                String time = timeCondition == null ? "" : timeCondition.getTimeFrequency();
                boolean subDateFlag = StringUtil.checkNull((String)subDataIds) || subDataIds.contains(String.valueOf(tempRecord.getSourceSubId()));
                boolean bl = unFlowFlag = triggerBean.isConditionFirstMet() && (!triggerBean.hasTimeCondition() || time.equals(FormTriggerBean.TimeFrequency.once.getKey()) && subDateFlag);
                if (unFlowFlag && tempRecord.getState().intValue() == FormTriggerBean.TriggerState.TRIGGERED.getKey()) {
                    hasTriggered = true;
                }
            }
        }
        return hasTriggered;
    }

    private boolean isExistInDataExecMap(long masterId) {
        List toMasterList = (List)dataExecuteMap.get((Object)masterId);
        if (Strings.isNotEmpty((Collection)toMasterList)) {
            LinkedHashSet<Long> idSet = new LinkedHashSet<Long>();
            for (Long toMasterId : toMasterList) {
                this.recursionCheckData(toMasterId, 0, 10, idSet);
            }
            if (idSet.contains(masterId)) {
                dataExecuteMap.remove((Object)masterId);
                return true;
            }
        }
        return false;
    }

    private Set<Long> recursionCheckData(long masterId, int currentIndex, int maxIndex, Set<Long> set) {
        Set<Long> list = set;
        if (list == null) {
            list = new LinkedHashSet<Long>();
        }
        list.add(masterId);
        if (currentIndex > maxIndex) {
            return list;
        }
        int nextIndex = currentIndex + 1;
        if (currentIndex == -1 || maxIndex == -1) {
            nextIndex = -1;
        }
        if (Strings.isNotEmpty((Collection)((Collection)dataExecuteMap.get((Object)masterId)))) {
            for (Long toMasterId : (List)dataExecuteMap.get((Object)masterId)) {
                if (!list.add(toMasterId)) continue;
                Set<Long> tempList = this.recursionCheckData(toMasterId, nextIndex, maxIndex, list);
                list.addAll(tempList);
            }
        }
        return list;
    }

    public void addDataExecute(long masterId, long toMasterId) {
        LinkedList<Long> toMasterList = (LinkedList<Long>)dataExecuteMap.get((Object)masterId);
        if (Strings.isEmpty((Collection)toMasterList)) {
            toMasterList = new LinkedList<Long>();
        }
        if (!toMasterList.contains(toMasterId)) {
            toMasterList.add(toMasterId);
        }
        dataExecuteMap.put((Object)masterId, toMasterList);
    }

    public Set<FormTriggerQuartzDataVo> afterExecute(FormTriggerActionContext context) throws BusinessException {
        if (Strings.isNotEmpty(context.getRecords())) {
            FormTriggerBean triggerBean = context.getTriggerBean();
            FormTriggerActionBean actionBean = context.getActionBean();
            FormBean recordForm = context.getFormBean();
            if (triggerBean != null && actionBean != null && actionBean.getType().equals(FormTriggerBean.TriggerType.Distribution.getKey()) && context.getFormBean().getId().equals(triggerBean.getTargetFormId())) {
                recordForm = this.cap4FormCacheManager.getForm(triggerBean.getSourceFormId());
            }
            this.cap4FormTriggerManager.saveOrUpdate(recordForm, context.getRecords());
        }
        return context.getQuartzDataVoList();
    }
}

