/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.engin.trigger.action;

import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormDataBean;
import com.seeyon.cap4.form.bean.FormDataMasterBean;
import com.seeyon.cap4.form.bean.FormDataSubBean;
import com.seeyon.cap4.form.bean.FormTriggerActionBean;
import com.seeyon.cap4.form.bean.FormTriggerBean;
import com.seeyon.cap4.form.modules.engin.trigger.FormTriggerActionContext;
import com.seeyon.cap4.form.modules.engin.trigger.FormTriggerUtil;
import com.seeyon.cap4.form.modules.engin.trigger.TriggerTaskEvent;
import com.seeyon.cap4.form.modules.engin.trigger.action.FormTriggerCreateBaseAction;
import com.seeyon.cap4.form.modules.engin.trigger.action.FormTriggerExecutor;
import com.seeyon.cap4.form.po.CAP4FormTriggerRecord;
import com.seeyon.cap4.form.po.CAPFormTriggerEvent;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.form.vo.FormTriggerFillBackResultVo;
import com.seeyon.cap4.form.vo.FormTriggerRecordVo;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.content.mainbody.MainbodyStatus;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.lock.Lock;
import com.seeyon.ctp.util.Strings;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;

public class FormTriggerFeedBackAction
extends FormTriggerCreateBaseAction {
    private static final Log LOGGER = CtpLogFactory.getLog(FormTriggerFeedBackAction.class);

    public String getId() {
        return FormTriggerBean.TriggerType.FeedBack.getKey();
    }

    @Override
    public boolean preExecute(Map<String, Object> param, FormTriggerBean triggerBean, FormTriggerActionBean actionBean, CAPFormTriggerEvent event) {
        try {
            FormTriggerActionContext context = FormTriggerExecutor.getInstance().getContext(param, triggerBean, actionBean, (TriggerTaskEvent)event);
            if (context == null) {
                return true;
            }
            Long toFormId = context.getTriggerBean().getSourceFormId();
            FormBean toFormBean = this.cap4FormCacheManager.getForm(toFormId);
            if (toFormBean == null || !this.cap4FormCacheManager.isEnabled(toFormBean)) {
                return true;
            }
            List<CAP4FormTriggerRecord> records = this.cap4FormTriggerManager.getRecordList(toFormBean, triggerBean.getId(), (Long)context.getModuleId(), FormTriggerBean.TriggerType.Distribution.getKey());
            if (Strings.isEmpty(records)) {
                return true;
            }
            CAP4FormTriggerRecord record = records.get(0);
            Long targetDataId = record.getSourceMasterId();
            Lock lock = this.cap4FormManager.getLock(targetDataId);
            if (lock != null) {
                LOGGER.warn((Object)("\u76ee\u6807\u6570\u636e\u6570\u636e\u88ab\u9501 " + targetDataId + "\uff0c\u6682\u7f13\u6267\u884c\uff01"));
                return false;
            }
            AppContext.putThreadContext((String)"bilateralBackTriggerRecord", (Object)record);
        }
        catch (Exception e) {
            LOGGER.error((Object)(triggerBean.getName() + "\u9884\u6267\u884c\u53cd\u9988\u65f6\u5f02\u5e38\uff1a"), (Throwable)e);
        }
        return super.preExecute(param, triggerBean, actionBean, event);
    }

    @Override
    public void execute(FormTriggerActionContext context) throws BusinessException {
        Long sourceTriggerId;
        if (context.isMagic()) {
            context.setLogOperateType(Enums.CapLogType.MAGICDISTRIBUTE);
        } else {
            context.setLogOperateType(Enums.CapLogType.DISTRIBUTE);
        }
        if (!context.getTriggerBean().isEnable()) {
            LOGGER.error((Object)"\u5f53\u524d\u89e6\u53d1\u5df2\u505c\u7528\uff0c\u4e0d\u6267\u884c");
            this.saveCheckErrMsg(context, ResourceUtil.getString((String)"form.business.relation.trigger.run.error1"));
            return;
        }
        if (context.getParam().containsKey("sourceTriggerId") && (sourceTriggerId = Long.valueOf(context.getParam().get("sourceTriggerId").toString())).equals(context.getTriggerBean().getId())) {
            LOGGER.error((Object)"\u521a\u6267\u884c\u5b8c\u540c\u6b65\u66f4\u65b0\u65b0\u5efa/\u66f4\u65b0\uff0c\u6b64\u53cd\u9988\u5148\u4e0d\u6267\u884c!");
            this.saveCheckErrMsg(context, ResourceUtil.getString((String)"form.business.relation.trigger.run.error19"));
            return;
        }
        Long toFormId = context.getTriggerBean().getSourceFormId();
        FormBean toFormBean = this.cap4FormCacheManager.getForm(toFormId);
        if (toFormBean == null || !this.cap4FormCacheManager.isEnabled(toFormBean)) {
            LOGGER.error((Object)"\u627e\u4e0d\u5230\u76ee\u6807\u8868\u5355\u6216\u8005\u76ee\u6807\u8868\u5355\u4e0d\u53ef\u7528\uff0c\u4e0d\u6267\u884c\u6b64\u52a8\u4f5c");
            this.saveCheckErrMsg(context, ResourceUtil.getString((String)"form.business.relation.trigger.run.error2"));
            return;
        }
        CAP4FormTriggerRecord record = (CAP4FormTriggerRecord)AppContext.getThreadContext((String)"bilateralBackTriggerRecord");
        if (record == null) {
            List<CAP4FormTriggerRecord> records;
            String actionType = FormTriggerBean.TriggerType.Distribution.getKey();
            if (context.isMagic()) {
                actionType = context.getMagicAction().getType();
            }
            if (Strings.isEmpty(records = this.cap4FormTriggerManager.getRecordList(toFormBean, context.getTriggerBean().getId(), (Long)context.getModuleId(), actionType))) {
                this.sendErrorMsg(context, toFormBean, ResourceUtil.getString((String)"form.business.relation.trigger.run.error20"), false);
                return;
            }
            record = records.get(0);
        }
        try {
            this.doTriggerExecute(context, toFormBean, record);
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            this.sendErrorMsg(context, toFormBean, e.getMessage(), true);
        }
    }

    private void doTriggerExecute(FormTriggerActionContext context, FormBean toFormBean, CAP4FormTriggerRecord record) throws BusinessException, SQLException {
        Long targetDataId = record.getSourceMasterId();
        FormDataMasterBean toMasterBean = this.cap4FormManager.getDataMasterBeanById(targetDataId, toFormBean, null);
        if (toMasterBean == null) {
            this.sendErrorMsg(context, toFormBean, ResourceUtil.getString((String)"form.business.relation.trigger.run.error21"), false);
            return;
        }
        FormTriggerRecordVo recordVo = this.getRecordVo(context.getMasterBean(), record);
        if (recordVo == null) {
            this.sendErrorMsg(context, toFormBean, ResourceUtil.getString((String)"form.business.relation.trigger.run.error22"), false);
            return;
        }
        try {
            this.checkAndLockData(toMasterBean.getId());
            FormTriggerUtil.addCurrentUser4TriggerAction(recordVo.getMemberId());
            FormTriggerFillBackResultVo resultVo = new FormTriggerFillBackResultVo();
            resultVo.setFeedBack(true);
            FormTriggerUtil.fillMappingData(context, toFormBean, resultVo, null, null);
            AppContext.putThreadContext((String)"fieldChangeTag", resultVo.getDataChangeTagMap(toMasterBean.getId()));
            toMasterBean.addFieldValue(resultVo.getMasterMap());
            resultVo.addMain2MainRecord(context.getMasterBean(), toMasterBean);
            FormTriggerUtil.addTriggerSourceRecord(context, resultVo, "main2main", 0L, toMasterBean.getId(), toFormBean.getMasterTableBean(), 0L);
            Map<String, FormDataSubBean> sub2Sub = resultVo.getSub2Sub();
            Map sub2SubRecord = recordVo.getSub2SubRecord();
            for (Map.Entry entry : sub2SubRecord.entrySet()) {
                FormDataSubBean subBean = sub2Sub.get(entry.getValue());
                if (subBean == null) continue;
                Map map = subBean.getRowData();
                map.remove(Enums.SubTableField.id.getKey());
                map.remove(Enums.SubTableField.formmain_id.getKey());
                map.remove(Enums.SubTableField.sort.getKey());
                FormDataSubBean targetSubBean = this.getSubBean4Record(toMasterBean, (String)entry.getKey());
                if (targetSubBean == null) continue;
                targetSubBean.addFieldValue(map);
                resultVo.addSub2SubRecord(context.getMasterBean(), toMasterBean, (String)entry.getValue(), targetSubBean);
                FormTriggerUtil.addTriggerSourceRecord(context, resultVo, "sub2sub", Long.valueOf(((String)entry.getKey()).split(",")[1]), toMasterBean.getId(), targetSubBean.getFormTable(), targetSubBean.getId());
            }
            Map<String, Map<String, Object>> main2Sub = resultVo.getMain2Sub();
            Map sub2MainRecord = recordVo.getSub2MainRecord();
            for (Map.Entry entry : main2Sub.entrySet()) {
                for (Map.Entry stringEntry : sub2MainRecord.entrySet()) {
                    FormDataSubBean targetSubBean;
                    if (!((String)stringEntry.getKey()).contains((CharSequence)entry.getKey()) || (targetSubBean = this.getSubBean4Record(toMasterBean, (String)stringEntry.getKey())) == null) continue;
                    targetSubBean.addFieldValue((Map)entry.getValue());
                    resultVo.addMain2SubRecord(context.getMasterBean(), toMasterBean, (String)entry.getKey(), targetSubBean.getId());
                    FormTriggerUtil.addTriggerSourceRecord(context, resultVo, "main2sub", 0L, toMasterBean.getId(), targetSubBean.getFormTable(), targetSubBean.getId());
                }
            }
            this.dealOtherInfoBeforeValidate(toFormBean, toMasterBean, null, resultVo, false);
            AppContext.removeThreadContext((String)"fieldChangeTag");
            resultVo.removeDataChangeTagMap(toMasterBean.getId());
            FormDataMasterBean oldMasterBean = this.cap4FormManager.getDataMasterBeanById(toMasterBean.getId(), toFormBean, null);
            String string = this.capRunningLogManager.getDataLog(toFormBean, toMasterBean, MainbodyStatus.STATUS_POST_UPDATE, oldMasterBean);
            ArrayList<String> changeFieldList = new ArrayList<String>();
            ArrayList<FormDataMasterBean> masterBeans = new ArrayList<FormDataMasterBean>();
            masterBeans.add(toMasterBean);
            String flag = FormTriggerUtil.validateCheckRule(toFormBean, masterBeans);
            if (Strings.isEmpty((String)flag)) {
                changeFieldList.addAll(toMasterBean.getModifiedFields((FormDataBean)oldMasterBean));
                this.cap4FormDataManager.insertOrUpdateMasterData(toMasterBean);
                flag = this.validateUnique(toFormBean, masterBeans, changeFieldList, oldMasterBean, false);
            }
            if (Strings.isNotBlank((String)flag)) {
                this.sendErrorMsg(context, toFormBean, flag, true);
                return;
            }
            this.dealOtherInfoAfterValidate(context, toFormBean, toMasterBean, resultVo, false);
            this.saveUpdateLog(context, toFormBean, toMasterBean, recordVo, record, string);
            this.doTargetMasterBeanTrigger(context, toFormBean, toMasterBean, changeFieldList, "");
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
        finally {
            this.unLockData(toMasterBean.getId());
        }
    }

    private FormDataSubBean getSubBean4Record(FormDataMasterBean masterBean, String record) {
        Object[] objArr = this.splitMapKeyAndValue(record);
        return masterBean.getFormDataSubBeanById((String)objArr[0], (Long)objArr[1]);
    }

    private void sendErrorMsg(FormTriggerActionContext context, FormBean toFormBean, String reason, boolean needSend) throws BusinessException {
        String error = (String)errorMap.get(reason);
        String prefix = ResourceUtil.getString((String)"form.business.relation.trigger.run.error6", (Object)(context.getFormBean().isFlowForm() ? context.getTitle() : context.getFormBean().getFormName()), (Object)context.getTriggerBean().getName(), (Object)toFormBean.getFormName(), (Object)ResourceUtil.getString((String)"form.business.relation.trigger.run.error23"));
        error = Strings.isNotBlank((String)error) ? ResourceUtil.getString((String)"form.business.relation.trigger.run.error7", (Object)ResourceUtil.getString((String)"form.business.relation.trigger.run.error12"), (Object)ResourceUtil.getString((String)error)) : reason;
        this.sendErrorMsg(context, toFormBean, prefix, error, needSend);
    }
}

