/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.engin.trigger.action;

import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormTriggerActionBean;
import com.seeyon.cap4.form.bean.FormTriggerBean;
import com.seeyon.cap4.form.modules.engin.trigger.FormTriggerActionContext;
import com.seeyon.cap4.form.modules.engin.trigger.FormTriggerBaseAction;
import com.seeyon.cap4.form.modules.engin.trigger.FormTriggerUtil;
import com.seeyon.cap4.form.modules.engin.trigger.TriggerActionContext;
import com.seeyon.cap4.form.modules.engin.trigger.TriggerTaskEvent;
import com.seeyon.cap4.form.modules.engin.trigger.action.FormTriggerBaseActionManager;
import com.seeyon.cap4.form.modules.engin.trigger.action.FormTriggerExecutor;
import com.seeyon.cap4.form.modules.engin.trigger.design.FormTriggerMagicInterfaceManager;
import com.seeyon.cap4.form.po.CAPFormTriggerEvent;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.magic.dao.IMagicInterfaceDefineDao;
import com.seeyon.cap4.magic.dao.IMagicProviderDao;
import com.seeyon.cap4.magic.dao.IMagicReflectionRelationDao;
import com.seeyon.cap4.magic.execute.ICAP4MagicExecuteManager;
import com.seeyon.cap4.magic.execute.MagicExecuteByVersionManager;
import com.seeyon.cap4.magic.initializer.CAP4MagicCacheInitializer;
import com.seeyon.cap4.magic.po.MagicReflectionRelationPO;
import com.seeyon.cap4.magic.po.MagicServiceProviderPO;
import com.seeyon.cap4.magic.utils.MagicPrivateUtils;
import com.seeyon.cap4.magic.vo.MagicEnums;
import com.seeyon.cap4.magic.vo.MethodProviderInfo;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.ParamUtil;
import com.seeyon.ctp.util.Strings;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;

public class FormTriggerMagicInterfaceAction
extends FormTriggerBaseActionManager {
    private static final Log LOGGER = CtpLogFactory.getLog(FormTriggerMagicInterfaceAction.class);
    private IMagicReflectionRelationDao magicReflectionRelationDao;
    private IMagicInterfaceDefineDao magicInterfaceDefineDao;
    private ICAP4MagicExecuteManager cap4MagicExecuteManager;
    private IMagicProviderDao magicProviderDao;

    public String getId() {
        return FormTriggerBean.TriggerType.DataMagicInterface.getKey();
    }

    public boolean afterColSummarySubmit(FormTriggerBean triggerBean, FormTriggerActionBean actionBean, Map<String, Object> param) throws BusinessException {
        LOGGER.info((Object)"\u9884\u5199\u8bbe\u7f6e");
        try {
            MethodProviderInfo methodProviderInfo;
            boolean isCap4Trigger = false;
            String businessId = ParamUtil.getString((Map)actionBean.getParam(), (String)"businessId");
            String versionId = ParamUtil.getString((Map)actionBean.getParam(), (String)"versionId");
            String methodName = ParamUtil.getString((Map)actionBean.getParam(), (String)"methodName");
            MagicServiceProviderPO provider = this.magicProviderDao.loadProviders(businessId, versionId, MagicEnums.ProviderStatus.ON);
            if (provider != null && MagicEnums.ProviderType.DEFAULT_FORM.getType().equals(provider.getSourceType()) && (methodProviderInfo = new MethodProviderInfo(provider, methodName)).isExists()) {
                isCap4Trigger = true;
                FormTriggerMagicInterfaceManager magicDesignManager = (FormTriggerMagicInterfaceManager)FormTriggerUtil.getDesignManagerByKey(FormTriggerBean.TriggerType.DataMagicInterface.getKey());
                Long masterId = (Long)param.get("masterId");
                Object obj = triggerBean.getExtraAttr("triggerContentDesc_" + masterId);
                boolean isFirst = false;
                if (obj == null || Strings.isEmpty((String)obj.toString())) {
                    isFirst = true;
                }
                FormTriggerActionContext context = new FormTriggerActionContext(param, triggerBean, actionBean, null);
                super.init();
                String key = masterId + "_" + actionBean.getId();
                AppContext.putThreadContext((String)("executeContext_" + key), (Object)context);
                actionBean = magicDesignManager.convertActionBean(actionBean, Long.parseLong(provider.getSource()), methodProviderInfo, isFirst);
            }
            if (isCap4Trigger) {
                String triggerType = ParamUtil.getString((Map)actionBean.getParam(), (String)"triggerType");
                FormTriggerBaseAction magicActionManager = FormTriggerUtil.getTriggerActionByKey(triggerType);
                if (magicActionManager != null) {
                    magicActionManager.init();
                    magicActionManager.afterColSummarySubmit(triggerBean, actionBean, param);
                }
            } else {
                FormTriggerActionContext context = new FormTriggerActionContext(param, triggerBean, actionBean, null);
                super.init();
                String point = triggerBean.getId() + "_" + actionBean.getId();
                List<MagicReflectionRelationPO> reflectionRelation = this.magicReflectionRelationDao.getReflectionRelationByCallPoint(point);
                if (reflectionRelation == null || reflectionRelation.isEmpty()) {
                    LOGGER.warn((Object)("\u65e0\u6cd5\u627e\u5230\u89e6\u53d1\u70b9 = " + point + ",\u7684\u6620\u5c04\u914d\u7f6e\uff0c\u5c06\u4e0d\u6267\u884c\u9884\u5199"));
                    return true;
                }
                MagicExecuteByVersionManager execute = CAP4MagicCacheInitializer.getExecuteByVersionManager(reflectionRelation.get(0).getVersionId());
                if (execute != null) {
                    execute.trigger(context, reflectionRelation.get(0), 1);
                }
            }
        }
        catch (BusinessException e) {
            LOGGER.error((Object)e);
            return false;
        }
        return true;
    }

    @Override
    public boolean preExecute(Map<String, Object> param, FormTriggerBean triggerBean, FormTriggerActionBean actionBean, CAPFormTriggerEvent event) {
        try {
            MagicExecuteByVersionManager magicExecuteManager;
            MethodProviderInfo methodProviderInfo;
            Map actionParam = actionBean.getParam();
            FormTriggerActionBean tempActionBean = actionBean;
            String businessId = ParamUtil.getString((Map)actionParam, (String)"businessId");
            String versionId = ParamUtil.getString((Map)actionParam, (String)"versionId");
            String methodName = ParamUtil.getString((Map)actionParam, (String)"methodName");
            String triggerType = ParamUtil.getString((Map)actionParam, (String)"triggerType");
            FormTriggerBaseAction magicActionManager = FormTriggerUtil.getTriggerActionByKey(triggerType);
            FormTriggerMagicInterfaceManager magicDesignManager = (FormTriggerMagicInterfaceManager)FormTriggerUtil.getDesignManagerByKey(FormTriggerBean.TriggerType.DataMagicInterface.getKey());
            boolean isCap4Trigger = false;
            MagicServiceProviderPO provider = this.magicProviderDao.loadProviders(businessId, versionId, MagicEnums.ProviderStatus.ON);
            if (provider != null && MagicEnums.ProviderType.DEFAULT_FORM.getType().equals(provider.getSourceType()) && (methodProviderInfo = new MethodProviderInfo(provider, methodName)).isExists()) {
                isCap4Trigger = true;
                tempActionBean = magicDesignManager.convertActionBean(actionBean, Long.parseLong(provider.getSource()), methodProviderInfo, false);
            }
            if (isCap4Trigger) {
                return magicActionManager.preExecute(param, triggerBean, tempActionBean, (TriggerTaskEvent)event);
            }
            Long actionId = actionBean.getId();
            Long triggerId = triggerBean.getId();
            List<MagicReflectionRelationPO> pos = this.magicReflectionRelationDao.getReflectionRelationByCallPoint(triggerId + "_" + actionId);
            if (pos.isEmpty()) {
                return true;
            }
            LOGGER.info((Object)("\u6570\u636e\u63a5\u53e3\u5f00\u59cb\u6267\u884c\u89e6\u53d1" + triggerBean.getName()));
            MagicReflectionRelationPO po = pos.get(0);
            for (MagicReflectionRelationPO p : pos) {
                if (p.getCallingType() != MagicEnums.BusinessMethodType.TRIGGER_CREATE.getType() && p.getCallingType() != MagicEnums.BusinessMethodType.TRIGGER_UPDATE.getType() && p.getCallingType() != MagicEnums.BusinessMethodType.TRIGGER_DISTRIBUTE.getType()) continue;
                po = p;
                break;
            }
            if ((magicExecuteManager = CAP4MagicCacheInitializer.getExecuteByVersionManager(po.getVersionId())) == null) {
                LOGGER.warn((Object)("\u65e0\u6cd5\u627e\u5230 \u7248\u672c\u4e3a" + po.getVersionId() + "\u7684\u6267\u884c\u5668"));
                return true;
            }
            FormTriggerActionContext context = FormTriggerExecutor.getInstance().getContext(param, triggerBean, actionBean, (TriggerTaskEvent)event);
            if (context == null) {
                return true;
            }
            return magicExecuteManager.preTrigger(context, po);
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return true;
        }
    }

    @Override
    public void execute(FormTriggerActionContext context) throws BusinessException {
        Enums.CapLogType capLogType = MagicPrivateUtils.getLogType(context.getActionBean());
        context.setLogOperateType(capLogType);
        String triggerType = ParamUtil.getString((Map)context.getActionBean().getParam(), (String)"triggerType", (String)"");
        if (!context.getTriggerBean().isEnable()) {
            LOGGER.error((Object)"\u5f53\u524d\u89e6\u53d1\u5df2\u505c\u7528\uff0c\u4e0d\u6267\u884c");
            this.saveCheckErrMsg(context, ResourceUtil.getString((String)"form.business.relation.trigger.run.error1"));
            return;
        }
        FormTriggerActionBean actionBean = context.getActionBean();
        boolean isCap4Trigger = false;
        String businessId = ParamUtil.getString((Map)actionBean.getParam(), (String)"businessId");
        String versionId = ParamUtil.getString((Map)actionBean.getParam(), (String)"versionId");
        String methodName = ParamUtil.getString((Map)actionBean.getParam(), (String)"methodName");
        MagicServiceProviderPO provider = this.magicProviderDao.loadProviders(businessId, versionId, MagicEnums.ProviderStatus.ON);
        if (provider != null && MagicEnums.ProviderType.DEFAULT_FORM.getType().equals(provider.getSourceType())) {
            MethodProviderInfo methodProviderInfo = new MethodProviderInfo(provider, methodName);
            isCap4Trigger = true;
            boolean needConvert = false;
            if (actionBean.getType().equals(FormTriggerBean.TriggerType.DataMagicOuterForm.getKey()) || actionBean.getType().equals(FormTriggerBean.TriggerType.DataMagicInterface.getKey())) {
                needConvert = true;
            }
            if (needConvert && methodProviderInfo.isExists()) {
                FormTriggerMagicInterfaceManager magicDesignManager = (FormTriggerMagicInterfaceManager)FormTriggerUtil.getDesignManagerByKey(FormTriggerBean.TriggerType.DataMagicInterface.getKey());
                actionBean = magicDesignManager.convertActionBean(actionBean, Long.parseLong(provider.getSource()), methodProviderInfo, Strings.isEmpty(context.getRecord4History()));
                context.setMagic(true);
                context.setActionBean(actionBean);
            }
        }
        if (isCap4Trigger) {
            FormTriggerBaseAction magicActionManager;
            FormBean formBean = context.getFormBean();
            if (actionBean.getType().equals(FormTriggerBean.TriggerType.Distribution.getKey()) && formBean.getId().equals(actionBean.getFormTriggerBean().getTargetFormId())) {
                triggerType = FormTriggerBean.TriggerType.FeedBack.getKey();
            }
            if ((magicActionManager = FormTriggerUtil.getTriggerActionByKey(triggerType)) != null) {
                magicActionManager.init();
                magicActionManager.execute((TriggerActionContext)context);
            }
        } else {
            FormTriggerActionBean fta = context.getActionBean();
            Long actionId = fta.getId();
            Long triggerId = fta.getFormTriggerBean().getId();
            List<MagicReflectionRelationPO> pos = this.magicReflectionRelationDao.getReflectionRelationByCallPoint(triggerId + "_" + actionId);
            if (pos.isEmpty()) {
                return;
            }
            LOGGER.info((Object)("\u6570\u636e\u63a5\u53e3\u5f00\u59cb\u6267\u884c\u89e6\u53d1" + fta.getName()));
            MagicReflectionRelationPO po = pos.get(0);
            for (MagicReflectionRelationPO p : pos) {
                if (context.getActionBean().getFormTriggerBean().getTargetFormId() == context.getFormBean().getId().longValue()) {
                    if (p.getCallingType() != MagicEnums.BusinessMethodType.TRIGGER_FEEDBACK.getType()) continue;
                    po = p;
                    break;
                }
                if (p.getCallingType() != MagicEnums.BusinessMethodType.TRIGGER_CREATE.getType() && p.getCallingType() != MagicEnums.BusinessMethodType.TRIGGER_UPDATE.getType() && p.getCallingType() != MagicEnums.BusinessMethodType.TRIGGER_DISTRIBUTE.getType()) continue;
                po = p;
                break;
            }
            context.getParam().remove("preExecute");
            MagicExecuteByVersionManager magicExecuteManager = CAP4MagicCacheInitializer.getExecuteByVersionManager(po.getVersionId());
            if (magicExecuteManager == null) {
                LOGGER.warn((Object)("\u65e0\u6cd5\u627e\u5230 \u7248\u672c\u4e3a" + po.getVersionId() + "\u7684\u6267\u884c\u5668"));
            } else {
                magicExecuteManager.trigger(context, po, 2);
            }
        }
    }

    public ICAP4MagicExecuteManager getCap4MagicExecuteManager() {
        return this.cap4MagicExecuteManager;
    }

    public void setCap4MagicExecuteManager(ICAP4MagicExecuteManager cap4MagicExecuteManager) {
        this.cap4MagicExecuteManager = cap4MagicExecuteManager;
    }

    public IMagicReflectionRelationDao getMagicReflectionRelationDao() {
        return this.magicReflectionRelationDao;
    }

    public void setMagicReflectionRelationDao(IMagicReflectionRelationDao magicReflectionRelationDao) {
        this.magicReflectionRelationDao = magicReflectionRelationDao;
    }

    public IMagicInterfaceDefineDao getMagicInterfaceDefineDao() {
        return this.magicInterfaceDefineDao;
    }

    public void setMagicInterfaceDefineDao(IMagicInterfaceDefineDao magicInterfaceDefineDao) {
        this.magicInterfaceDefineDao = magicInterfaceDefineDao;
    }

    public IMagicProviderDao getMagicProviderDao() {
        return this.magicProviderDao;
    }

    public void setMagicProviderDao(IMagicProviderDao magicProviderDao) {
        this.magicProviderDao = magicProviderDao;
    }
}

