/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.engin.trigger.action;

import com.seeyon.cap4.form.bean.FormAuthViewBean;
import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormBindAuthBean;
import com.seeyon.cap4.form.bean.FormBindBean;
import com.seeyon.cap4.form.bean.FormDataMasterBean;
import com.seeyon.cap4.form.bean.FormDataSubBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormFieldComEnum;
import com.seeyon.cap4.form.bean.FormTableBean;
import com.seeyon.cap4.form.bean.FormTriggerActionBean;
import com.seeyon.cap4.form.bean.FormTriggerBean;
import com.seeyon.cap4.form.bean.SimpleObjectBean;
import com.seeyon.cap4.form.modules.engin.trigger.FormTriggerActionContext;
import com.seeyon.cap4.form.modules.engin.trigger.FormTriggerUtil;
import com.seeyon.cap4.form.modules.engin.trigger.action.FormTriggerBaseActionManager;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.affair.manager.AffairManager;
import com.seeyon.ctp.common.constants.ApplicationCategoryEnum;
import com.seeyon.ctp.common.content.affair.constants.StateEnum;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.affair.CtpAffair;
import com.seeyon.ctp.common.usermessage.Constants;
import com.seeyon.ctp.common.usermessage.MessageContent;
import com.seeyon.ctp.common.usermessage.MessageReceiver;
import com.seeyon.ctp.form.po.FormModuleAuth;
import com.seeyon.ctp.organization.OrgConstants;
import com.seeyon.ctp.organization.bo.V3xOrgAccount;
import com.seeyon.ctp.organization.bo.V3xOrgDepartment;
import com.seeyon.ctp.organization.bo.V3xOrgMember;
import com.seeyon.ctp.organization.bo.V3xOrgRole;
import com.seeyon.ctp.organization.manager.OrgManager;
import com.seeyon.ctp.util.StringUtil;
import com.seeyon.ctp.util.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;

public class FormTriggerMessageAction
extends FormTriggerBaseActionManager {
    private static final Log LOGGER = CtpLogFactory.getLog(FormTriggerMessageAction.class);
    private OrgManager orgManager;

    public String getId() {
        return FormTriggerBean.TriggerType.Message.getKey();
    }

    @Override
    public void execute(FormTriggerActionContext context) throws BusinessException {
        if (!context.getTriggerBean().isEnable()) {
            LOGGER.error((Object)"\u5f53\u524d\u89e6\u53d1\u5df2\u505c\u7528\uff0c\u4e0d\u6267\u884c");
            return;
        }
        FormBean formBean = context.getFormBean();
        FormTriggerActionBean actionBean = context.getActionBean();
        String msgContent = actionBean.getParam(FormTriggerBean.ActionParam.MsgContent.getKey()).toString();
        List msgMem = (List)actionBean.getParam(FormTriggerBean.ActionParam.Entity.getKey());
        ArrayList<V3xOrgMember> members = new ArrayList<V3xOrgMember>();
        HashSet<Long> receivers = new HashSet<Long>();
        HashMap<String, List<String>> subReceiver = new HashMap<String, List<String>>();
        HashMap<Long, List<MessageContent>> subReceiverContent = new HashMap<Long, List<MessageContent>>();
        try {
            for (SimpleObjectBean entity : msgMem) {
                members.addAll(this.getMsgReceivers(context, entity.getName(), entity.getValue(), context.getMasterBean().getStartMemberId(), subReceiver));
            }
            for (V3xOrgMember member : members) {
                if (member == null) {
                    LOGGER.error((Object)"\u6d88\u606f\u63a5\u6536\u4eba\u4e3a\u7a7a\uff0c\u5176ID\u5bf9\u5e94\u7684\u4eba\u5458\u4e0d\u80fd\u5b58\u5728\uff01");
                    continue;
                }
                receivers.add(member.getId());
            }
            List<MessageContent> msgContents = this.getMsgContentList(context, msgContent, receivers, subReceiver, subReceiverContent);
            Set<Long> linkIds = this.getOpenLinkMemberIds(formBean, context.getModuleId());
            List linkId = Strings.getCollectionActionResult(receivers, linkIds, (Strings.CollectionActionType)Strings.CollectionActionType.intersection);
            if (Strings.isNotEmpty((Collection)linkId)) {
                receivers.removeAll(linkId);
            }
            boolean sendSms = false;
            String sms = (String)actionBean.getParam(FormTriggerBean.ActionParam.MsgSendSMS.getKey());
            if (Strings.isNotBlank((String)sms) && "1".equals(sms)) {
                sendSms = true;
            }
            String showRightId = "";
            if (!formBean.isFlowForm()) {
                String dataRight = String.valueOf(context.getActionBean().getParam(FormTriggerBean.ActionParam.DataRight.getKey()));
                String pcShowStr = Strings.isEmpty((String)dataRight) ? "" : dataRight.split(",")[0];
                Long pcShowRightId = Strings.isEmpty((String)pcShowStr) ? 0L : Long.valueOf(pcShowStr.split("\\.")[1]);
                FormAuthViewBean pcAuthViewBean = formBean.getAuthViewBeanById(pcShowRightId);
                String phoneShowStr = Strings.isEmpty((String)dataRight) ? "" : dataRight.split(",")[1];
                Long phoneShowRightId = Strings.isEmpty((String)phoneShowStr) ? 0L : Long.valueOf(phoneShowStr.split("\\.")[1]);
                FormAuthViewBean phoneAuthViewBean = formBean.getAuthViewBeanById(phoneShowRightId);
                if (pcAuthViewBean == null || phoneAuthViewBean == null) {
                    LOGGER.info((Object)"\u6ca1\u6709\u8bbe\u7f6e\u6d88\u606f\u7684\u7a7f\u900f\u663e\u793a\u6743\u9650\uff01");
                }
                showRightId = pcShowRightId + "_" + phoneShowRightId;
            }
            this.sendMsgContent(context, receivers, linkId, msgContents, sendSms, showRightId);
            if (!subReceiverContent.isEmpty()) {
                ArrayList<Long> noLinkId = new ArrayList<Long>();
                ArrayList<Long> subLinkId = new ArrayList<Long>();
                for (Map.Entry entry : subReceiverContent.entrySet()) {
                    noLinkId.clear();
                    subLinkId.clear();
                    Long memberId = (Long)entry.getKey();
                    List content = (List)entry.getValue();
                    if (linkIds.contains(memberId)) {
                        subLinkId.add(memberId);
                    } else {
                        noLinkId.add(memberId);
                    }
                    this.sendMsgContent(context, noLinkId, subLinkId, content, sendSms, showRightId);
                }
            }
        }
        catch (Exception e) {
            this.sendErrorMsg(e, context);
        }
    }

    private List<V3xOrgMember> getMsgReceivers(FormTriggerActionContext context, String key, String value, Long createId, Map<String, List<String>> subReceiver) throws BusinessException {
        return this.getMsgReceivers(context, key, value, createId, subReceiver, null);
    }

    private List<V3xOrgMember> getMsgReceivers(FormTriggerActionContext context, String key, String value, Long createId, Map<String, List<String>> subReceiver, String role) throws BusinessException {
        List<Object> members = new ArrayList();
        if ("Department".equalsIgnoreCase(key) || FormFieldComEnum.EXTEND_MULTI_DEPARTMENT.getKey().equalsIgnoreCase(key) || "BusinessDepartment".equals(key)) {
            members = this.orgManager.getMembersByDepartment(Long.valueOf(value), false);
            if (Strings.isNotBlank((String)role)) {
                members = this.getDeptMembers(Long.valueOf(value), role);
            }
        } else if ("Member".equalsIgnoreCase(key) || FormFieldComEnum.EXTEND_MULTI_MEMBER.getKey().equalsIgnoreCase(key)) {
            V3xOrgMember member = this.orgManager.getMemberById(Long.valueOf(Long.parseLong(value)));
            if (Strings.isNotBlank((String)role)) {
                if (role.contains("ReciprocalRoleReporter")) {
                    V3xOrgMember reporter = this.orgManager.getMemberById(member.getReporter());
                    if (reporter != null) {
                        members.add(reporter);
                    }
                } else {
                    members = this.getDeptMembers(member.getOrgDepartmentId(), role);
                }
            } else {
                members.add(member);
            }
        } else if ("Account".equalsIgnoreCase(key) || FormFieldComEnum.EXTEND_MULTI_ACCOUNT.getKey().equalsIgnoreCase(key) || "BusinessAccount".equals(key)) {
            Long accountId = Long.parseLong(value);
            members = this.orgManager.getAllMembers(accountId);
            if (Strings.isNotBlank((String)role)) {
                Long roleId = 0L;
                try {
                    roleId = Long.valueOf(role);
                }
                catch (Exception e) {
                    LOGGER.error((Object)"\u89e6\u53d1\u6d88\u606f\u89d2\u8272\u6267\u884cid\u8f6c\u6362\u65f6\u79fb\u9664\uff0c\u6309\u7167\u89d2\u8272\u540d\u79f0\u5904\u7406", (Throwable)e);
                }
                V3xOrgRole v3xRole = this.orgManager.getRoleById(roleId);
                if (v3xRole != null) {
                    members = this.orgManager.getMembersByRole(accountId, roleId);
                } else {
                    List v3xRoles = this.orgManager.getRoleByCode(role, accountId);
                    if (Strings.isNotEmpty((Collection)v3xRoles)) {
                        v3xRole = (V3xOrgRole)v3xRoles.get(0);
                        members = this.orgManager.getMembersByRole(accountId, v3xRole.getId());
                    }
                }
            }
        } else if ("Role".equalsIgnoreCase(key) || "Node".equalsIgnoreCase(key)) {
            V3xOrgMember member = this.orgManager.getMemberById(createId);
            if (value.contains("SenderSuperDept")) {
                V3xOrgDepartment department = this.orgManager.getParentDepartment(member.getOrgDepartmentId());
                if (department != null) {
                    members = this.getDeptMembers(department.getId(), value.replace("SenderSuperDept", ""));
                }
            } else if (value.contains("SenderSuperAccount")) {
                V3xOrgAccount account = this.orgManager.getAccountById(member.getOrgAccountId());
                if (account != null && (account = (V3xOrgAccount)this.orgManager.getParentUnitById(account.getId())) != null) {
                    members = this.orgManager.getMembersByAccountRoleOfUp(account.getId().longValue(), value.replace("SenderSuperAccount", ""));
                }
            } else if (value.contains("Sender")) {
                if ("Sender".equals(value)) {
                    members.add(this.orgManager.getMemberById(createId));
                } else if (value.contains("ReciprocalRoleReporter")) {
                    V3xOrgMember reporter = this.orgManager.getMemberById(member.getReporter());
                    if (reporter != null) {
                        members.add(reporter);
                    }
                } else {
                    members = this.getDeptMembers(member.getOrgDepartmentId(), value.replace("Sender", ""));
                }
            }
        } else if ("Level".equalsIgnoreCase(key) || FormFieldComEnum.EXTEND_MULTI_LEVEL.getKey().equalsIgnoreCase(key)) {
            members = this.orgManager.getMembersByLevel(Long.valueOf(Long.parseLong(value)));
        } else if ("Post".equalsIgnoreCase(key) || FormFieldComEnum.EXTEND_MULTI_POST.getKey().equalsIgnoreCase(key)) {
            members = this.orgManager.getMembersByPost(Long.valueOf(Long.parseLong(value)));
        } else if ("Team".equalsIgnoreCase(key)) {
            members = this.orgManager.getMembersByTeam(Long.valueOf(Long.parseLong(value)));
        } else if ("Department_Role".equalsIgnoreCase(key)) {
            String[] depRole = value.split("_");
            members = this.orgManager.getMembersByDepartmentRole(Long.parseLong(depRole[0]), depRole[1]);
        } else if ("Department_Post".equalsIgnoreCase(key)) {
            String[] depPost = value.split("_");
            members = this.orgManager.getMembersByDepartmentPost(Long.parseLong(depPost[0]), Long.parseLong(depPost[1]));
        } else if ("BusinessDepartment_BusinessRole".equalsIgnoreCase(key)) {
            String[] depRole = value.split("_");
            members = this.orgManager.getMembersByDepartmentRole(Long.parseLong(depRole[0]), depRole[1]);
        } else if ("FormField".equalsIgnoreCase(key)) {
            members.addAll(this.getFieldReceivers(context, value, createId, subReceiver));
        }
        return members;
    }

    private List<V3xOrgMember> getDeptMembers(Long deptId, String role) throws BusinessException {
        V3xOrgDepartment department = this.orgManager.getDepartmentById(deptId);
        List memberList = new ArrayList();
        if ("DeptMember".equals(role)) {
            memberList = this.orgManager.getMembersByDepartment(department.getId(), true);
        } else {
            String roleIdTemp;
            if (role.startsWith("SVjoin") && Strings.isDigits((String)(roleIdTemp = role.substring("SVjoin".length())))) {
                role = roleIdTemp;
            }
            if (Strings.isDigits((String)role)) {
                Long roleId = Long.valueOf(role);
                V3xOrgRole v3xRole = this.orgManager.getRoleById(roleId);
                if (v3xRole != null) {
                    if (v3xRole.getBond() == OrgConstants.ROLE_BOND.DEPARTMENT.ordinal()) {
                        memberList = this.orgManager.getMembersByDepartmentRoleOfUp(department.getId().longValue(), role);
                    } else if (v3xRole.getBond() == OrgConstants.ROLE_BOND.ACCOUNT.ordinal()) {
                        memberList = this.orgManager.getMembersByRole(v3xRole.getOrgAccountId(), roleId);
                    }
                }
            } else {
                List v3xRoles = this.orgManager.getRoleByCode(role, department.getOrgAccountId());
                if (Strings.isNotEmpty((Collection)v3xRoles)) {
                    V3xOrgRole v3xRole = (V3xOrgRole)v3xRoles.get(0);
                    if (v3xRole.getBond() == OrgConstants.ROLE_BOND.DEPARTMENT.ordinal()) {
                        memberList = this.orgManager.getMembersByRole(department.getId(), v3xRole.getId());
                    } else if (v3xRole.getBond() == OrgConstants.ROLE_BOND.ACCOUNT.ordinal()) {
                        memberList = this.orgManager.getMembersByRole(v3xRole.getOrgAccountId(), v3xRole.getId());
                    }
                }
            }
        }
        return memberList;
    }

    private List<V3xOrgMember> getFieldReceivers(FormTriggerActionContext context, String value, Long createId, Map<String, List<String>> subReceiver) throws BusinessException {
        ArrayList<V3xOrgMember> members = new ArrayList<V3xOrgMember>();
        String[] memStr = FormTriggerUtil.getFieldName(value);
        String fieldType = memStr[0];
        String fieldName = memStr[1];
        String fieldRole = memStr[3];
        FormFieldBean fieldBean = context.getFormBean().getFieldBeanByName(fieldName);
        if (fieldBean != null) {
            if (fieldBean.isMasterField()) {
                Object fieldValue = context.getMasterBean().getFieldValue(fieldName);
                if (fieldValue != null) {
                    String[] values;
                    for (String val : values = fieldValue.toString().split(",")) {
                        if (!Strings.isNotBlank((String)val)) continue;
                        members.addAll(this.getMsgReceivers(context, fieldType, val, createId, subReceiver, fieldRole));
                    }
                }
            } else {
                List<String> fields = subReceiver.get(fieldBean.getOwnerTableName());
                if (Strings.isEmpty(fields)) {
                    fields = new ArrayList<String>();
                }
                fields.add(value);
                subReceiver.put(fieldBean.getOwnerTableName(), fields);
            }
        }
        return members;
    }

    private List<MessageContent> getMsgContentList(FormTriggerActionContext context, String msgContent, Set<Long> receivers, Map<String, List<String>> subReceiver, Map<Long, List<MessageContent>> subReceiverContent) throws BusinessException {
        ArrayList<MessageContent> msgContents = new ArrayList<MessageContent>();
        FormBean formBean = context.getFormBean();
        FormDataMasterBean masterBean = context.getMasterBean();
        FormTriggerBean triggerBean = context.getTriggerBean();
        boolean isTimeJob = context.isTime();
        HashMap<String, Object> allDataMap = new HashMap<String, Object>(masterBean.getRowData());
        allDataMap.put("isAutoSend", isTimeJob);
        LinkedHashMap<String, List<FormDataSubBean>> subDataMap = new LinkedHashMap<String, List<FormDataSubBean>>();
        String conditionSubTableName = triggerBean.getFilterConditionSubTableName();
        Set<FormTableBean> msgContentSubTableList = FormTriggerUtil.getSubTableBeanInMsgContent(formBean, msgContent);
        HashMap<String, Map<String, List<FormDataSubBean>>> subRecMap = new HashMap<String, Map<String, List<FormDataSubBean>>>();
        FormDataMasterBean cloneMasterBean = FormTriggerUtil.cloneNowMasterBean(context, masterBean);
        List tableBeans = formBean.getSubTableBean();
        for (FormTableBean tableBean : tableBeans) {
            ArrayList<FormDataSubBean> tempSubDataList = new ArrayList<FormDataSubBean>();
            List subDataList = cloneMasterBean.getSubData(tableBean.getTableName());
            List<String> list = subReceiver.get(tableBean.getTableName());
            boolean isSameTable = conditionSubTableName.equalsIgnoreCase(tableBean.getTableName());
            for (FormDataSubBean subBean : subDataList) {
                if (isSameTable || msgContentSubTableList.contains(tableBean)) {
                    tempSubDataList.add(subBean);
                }
                if (!isSameTable && !Strings.isNotEmpty(list)) continue;
                this.parseSubReceiverAndDataMap(list, tableBean, subBean, receivers, subRecMap);
            }
            if (!Strings.isNotEmpty(tempSubDataList)) continue;
            subDataMap.put(tableBean.getTableName(), tempSubDataList);
        }
        if (subDataMap.isEmpty()) {
            this.parseMsgReceiversContent(context, msgContents, allDataMap, msgContent, null);
        } else {
            List<Map<String, Object>> dataList = this.getSubDataMap(subDataMap);
            for (Map<String, Object> map : dataList) {
                this.parseMsgReceiversContent(context, msgContents, map, msgContent, allDataMap);
            }
        }
        if (!subRecMap.isEmpty()) {
            HashMap<Long, HashSet<String>> msgMap = new HashMap<Long, HashSet<String>>();
            for (Map.Entry entry : subRecMap.entrySet()) {
                String[] maneAndIds = ((String)entry.getKey()).split(",");
                Long memberId = Long.valueOf(maneAndIds[1]);
                Map tempSubDataMap = (Map)entry.getValue();
                for (FormTableBean tableBean : msgContentSubTableList) {
                    if (tempSubDataMap.get(tableBean.getTableName()) != null || subDataMap.get(tableBean.getTableName()) == null) continue;
                    tempSubDataMap.put(tableBean.getTableName(), subDataMap.get(tableBean.getTableName()));
                }
                List<Map<String, Object>> data = this.getSubDataMap(tempSubDataMap);
                for (Map<String, Object> listEntry : data) {
                    String result = this.getReplaceMsg(context, listEntry, msgContent, allDataMap);
                    HashSet<String> subMsgSet = (HashSet<String>)msgMap.get(memberId);
                    if (subMsgSet == null) {
                        subMsgSet = new HashSet<String>();
                    }
                    subMsgSet.add(result);
                    msgMap.put(memberId, subMsgSet);
                }
            }
            for (Map.Entry entry : msgMap.entrySet()) {
                ArrayList<MessageContent> subContents = new ArrayList<MessageContent>();
                for (String msg : (Set)entry.getValue()) {
                    subContents.add(this.getMsgContent(msg));
                }
                subReceiverContent.put((Long)entry.getKey(), (List<MessageContent>)subContents);
            }
        }
        return msgContents;
    }

    private void parseSubReceiverAndDataMap(List<String> subFields, FormTableBean subTableBean, FormDataSubBean subBean, Set<Long> receivers, Map<String, Map<String, List<FormDataSubBean>>> subRecMap) throws BusinessException {
        if (Strings.isNotEmpty(subFields)) {
            for (String field : subFields) {
                String[] values;
                String[] senderStr = FormTriggerUtil.getFieldName(field);
                String fieldType = senderStr[0];
                String fieldName = senderStr[1];
                String fieldRole = senderStr[3];
                Object obj = subBean.getFieldValue(fieldName);
                if (StringUtil.checkNull((String)String.valueOf(obj))) continue;
                for (String value : values = obj.toString().split(",")) {
                    List<V3xOrgMember> members = this.getMsgReceivers(null, fieldType.toLowerCase(), value, null, null, fieldRole);
                    for (V3xOrgMember member : members) {
                        List<FormDataSubBean> subBeans;
                        Long memberId = member.getId();
                        if (receivers.contains(memberId)) continue;
                        Map<String, List<FormDataSubBean>> tables = subRecMap.get(subTableBean.getTableName() + "," + memberId);
                        if (tables == null) {
                            tables = new HashMap<String, List<FormDataSubBean>>();
                        }
                        if ((subBeans = tables.get(subTableBean.getTableName())) == null) {
                            subBeans = new ArrayList<FormDataSubBean>();
                        }
                        subBeans.add(subBean);
                        tables.put(subTableBean.getTableName(), subBeans);
                        subRecMap.put(subTableBean.getTableName() + "," + memberId, tables);
                    }
                }
            }
        }
    }

    private List<Map<String, Object>> getSubDataMap(Map<String, List<FormDataSubBean>> subDataMap) {
        List<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (Map.Entry<String, List<FormDataSubBean>> et : subDataMap.entrySet()) {
            result = this.getSubDataMap(result, et.getValue());
        }
        return result;
    }

    private List<Map<String, Object>> getSubDataMap(List<Map<String, Object>> list, List<FormDataSubBean> subBeans) {
        ArrayList<Map<String, Object>> temp = new ArrayList<Map<String, Object>>();
        if (Strings.isEmpty(list)) {
            for (FormDataSubBean subBean : subBeans) {
                temp.add(new HashMap(subBean.getRowData()));
            }
        } else {
            for (FormDataSubBean subBean : subBeans) {
                for (Map<String, Object> map : list) {
                    if (map == null) {
                        map = new HashMap<String, Object>();
                    }
                    HashMap<String, Object> tempMap = new HashMap<String, Object>(map);
                    tempMap.putAll(subBean.getRowData());
                    temp.add(tempMap);
                }
            }
        }
        return temp;
    }

    private void parseMsgReceiversContent(FormTriggerActionContext context, List<MessageContent> contentList, Map<String, Object> dataMap, String msg, Map<String, Object> allDataMap) throws BusinessException {
        String replaceMsg = this.getReplaceMsg(context, dataMap, msg, allDataMap);
        MessageContent messageContent = this.getMsgContent(replaceMsg);
        contentList.add(messageContent);
    }

    private String getReplaceMsg(FormTriggerActionContext context, Map<String, Object> data, String msg, Map<String, Object> dataMap) throws BusinessException {
        HashMap<String, Object> map = new HashMap<String, Object>(data);
        if (dataMap != null) {
            map.putAll(dataMap);
        }
        return this.cap4FormDataManager.getReplaceMsg(msg, context.getFormBean(), map, true);
    }

    private MessageContent getMsgContent(String msg) {
        String result = msg;
        if (msg.length() > 1333) {
            LOGGER.info((Object)("\u89e6\u53d1\u6d88\u606f\u8d85\u957f\uff0c\u622a\u53d6\u6d88\u606f\u5185\u5bb9\uff1a" + msg));
            result = msg.substring(0, 1333);
        }
        return MessageContent.get((String)result, (Object[])new Object[0]);
    }

    private void sendMsgContent(FormTriggerActionContext context, Collection<Long> noLinkId, Collection<Long> linkId, List<MessageContent> contents, boolean sendSms, String showRightId) throws BusinessException {
        FormBean formBean = context.getFormBean();
        for (MessageContent content : contents) {
            Object[] obj;
            if (Strings.isNotEmpty(noLinkId)) {
                this.messageManager.sendSystemMessage(content, ApplicationCategoryEnum.collaboration, 2L, MessageReceiver.get((Long)-1L, noLinkId, (boolean)sendSms), new Object[]{8});
                this.getNewRecord(context, null, ((Object[])content.getKeys().get(0))[0].toString(), FormTriggerBean.TriggerState.TRIGGERED, context.getDateSubIds());
            }
            if (!Strings.isNotEmpty(linkId)) continue;
            if (formBean.isFlowForm()) {
                obj = new Object[]{context.getModuleId()};
                this.messageManager.sendSystemMessage(content, ApplicationCategoryEnum.collaboration, 2L, MessageReceiver.get((Long)-1L, linkId, (String)"message.link.formtrigger.msg.flow", (Constants.LinkOpenType)Constants.LinkOpenType.open, (boolean)sendSms, (Object[])obj), new Object[]{8});
            } else {
                obj = new Object[]{context.getModuleId(), context.getModuleType(), showRightId};
                this.messageManager.sendSystemMessage(content, ApplicationCategoryEnum.collaboration, 2L, MessageReceiver.get((Long)-1L, linkId, (String)"message.link.formtrigger.cap4.msg.unflow", (Constants.LinkOpenType)Constants.LinkOpenType.open, (boolean)sendSms, (Object[])obj), new Object[]{8});
            }
            this.getNewRecord(context, null, ((Object[])content.getKeys().get(0))[0].toString(), FormTriggerBean.TriggerState.TRIGGERED, context.getDateSubIds());
        }
    }

    private Set<Long> getOpenLinkMemberIds(FormBean formBean, long moduleId) throws BusinessException {
        HashSet<Long> results;
        block3: {
            block2: {
                results = new HashSet<Long>();
                if (!formBean.isFlowForm()) break block2;
                AffairManager affairManager = (AffairManager)AppContext.getBean((String)"affairManager");
                ArrayList<StateEnum> states = new ArrayList<StateEnum>();
                states.add(StateEnum.col_done);
                states.add(StateEnum.col_pending);
                states.add(StateEnum.col_sent);
                List affairs = affairManager.getAffairs(Long.valueOf(moduleId), states);
                if (!Strings.isNotEmpty((Collection)affairs)) break block3;
                for (CtpAffair ctpAffair : affairs) {
                    results.add(ctpAffair.getMemberId());
                }
                break block3;
            }
            FormBindBean bindBean = formBean.getBind();
            Map unTemplates = bindBean.getUnFlowTemplateMap();
            for (Map.Entry entry : unTemplates.entrySet()) {
                results.addAll(this.getMembersIdByAuth(((FormBindAuthBean)entry.getValue()).getModuleAuthList()));
            }
        }
        return results;
    }

    private Set<Long> getMembersIdByAuth(List<FormModuleAuth> auths) throws BusinessException {
        HashSet<Long> ids = new HashSet<Long>();
        List<V3xOrgMember> members = this.getMembersByAuth(auths);
        for (V3xOrgMember v3xOrgMember : members) {
            if (v3xOrgMember == null) continue;
            ids.add(v3xOrgMember.getId());
        }
        return ids;
    }

    private List<V3xOrgMember> getMembersByAuth(List<FormModuleAuth> auths) throws BusinessException {
        ArrayList<V3xOrgMember> results = new ArrayList<V3xOrgMember>();
        List members = null;
        for (FormModuleAuth formModuleAuth : auths) {
            Enums.FormModuleAuthOrgType moduleAuth = Enums.FormModuleAuthOrgType.getFormModuleAuthOrgTypeByKey((int)formModuleAuth.getOrgType());
            switch (moduleAuth) {
                case Account: 
                case BusinessAccount: {
                    members = this.orgManager.getAllMembers(formModuleAuth.getOrgId());
                    break;
                }
                case Department: 
                case BusinessDepartment: {
                    members = this.orgManager.getMembersByDepartment(formModuleAuth.getOrgId(), false);
                    break;
                }
                case Team: {
                    members = this.orgManager.getMembersByTeam(formModuleAuth.getOrgId());
                    break;
                }
                case Member: {
                    results.add(this.orgManager.getMemberById(formModuleAuth.getOrgId()));
                    break;
                }
                case Post: {
                    members = this.orgManager.getMembersByPost(formModuleAuth.getOrgId());
                    break;
                }
                case Level: {
                    members = this.orgManager.getMembersByLevel(formModuleAuth.getOrgId());
                    break;
                }
            }
            if (!Strings.isNotEmpty(members)) continue;
            results.addAll(members);
        }
        return results;
    }

    private void sendErrorMsg(Exception e, FormTriggerActionContext context) throws BusinessException {
        LOGGER.error((Object)("\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff01" + e.getMessage()), (Throwable)e);
        this.messageManager.sendSystemMessage(MessageContent.get((String)ResourceUtil.getString((String)"form.trigger.triggerSet.actions.error.msg", (Object)context.getFormBean().getFormName()), (Object[])new Object[0]), ApplicationCategoryEnum.cap4Form, 2L, MessageReceiver.get((Long)-1L, context.getErrorReceivers()), new Object[0]);
    }

    public void setOrgManager(OrgManager orgManager) {
        this.orgManager = orgManager;
    }
}

