/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.engin.trigger.design;

import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormFormulaBean;
import com.seeyon.cap4.form.bean.FormTriggerActionBean;
import com.seeyon.cap4.form.bean.FormTriggerBean;
import com.seeyon.cap4.form.bean.SimpleObjectBean;
import com.seeyon.cap4.form.modules.engin.trigger.FormTriggerInnerDesignManager;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.po.BasePO;
import com.seeyon.ctp.common.taglibs.functions.Functions;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDLong;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class FormTriggerAutoBaseDesignManager
extends FormTriggerInnerDesignManager {
    private CAP4FormCacheManager cap4FormCacheManager;

    public CAP4FormCacheManager getCap4FormCacheManager() {
        return this.cap4FormCacheManager;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public String getTriggerBusinessTypeKey() {
        return FormTriggerBean.TriggerBusinessType.FormSelf.getKey();
    }

    public String getTriggerBusinessTypeText() {
        return FormTriggerBean.TriggerBusinessType.FormSelf.getText();
    }

    public String getConfigPageURL() {
        return "formInnerBusiness.do?method=editTrigger4FormSelf" + Functions.csrfSuffix();
    }

    public boolean canUse4FormType(Enums.FormType formType) {
        return formType == Enums.FormType.unFlowForm;
    }

    public FormTriggerActionBean getActionFromMap(FormTriggerBean triggerBean, Map<String, String> map) throws BusinessException {
        FormTriggerActionBean actionBean = new FormTriggerActionBean(triggerBean);
        String actionId = map.get("actionId");
        actionBean.setId(Long.valueOf(Strings.isBlank((String)actionId) ? UUIDLong.longUUID() : Long.parseLong(actionId)));
        actionBean.setType(this.getId());
        actionBean.setName(this.getName());
        if (map.get(FormTriggerBean.ActionParam.DataRight.getKey()) != null) {
            actionBean.addParam(FormTriggerBean.ActionParam.DataRight.getKey(), (Object)map.get(FormTriggerBean.ActionParam.DataRight.getKey()));
        }
        String fillBackKey = map.get("fillBackKey");
        String fillBackType = map.get("fillBackType");
        String fillBackValue = map.get("fillBackValue");
        List<SimpleObjectBean> fillBackList = this.parseFillBackFromMap4BillDesign(triggerBean, fillBackKey, fillBackType, fillBackValue);
        actionBean.addParam(FormTriggerBean.ActionParam.FillBack.getKey(), fillBackList);
        return actionBean;
    }

    private List<SimpleObjectBean> parseFillBackFromMap4BillDesign(FormTriggerBean triggerBean, String fillBackKey, String fillBackType, String fillBackValue) {
        ArrayList<SimpleObjectBean> fillBackList = new ArrayList<SimpleObjectBean>();
        if (!Strings.isBlank((String)fillBackKey)) {
            FormBean sourceFormBean = this.getCap4FormCacheManager().getForm(triggerBean.getSourceFormId());
            String[] fillBackTypes = fillBackType.split("\\|");
            String[] fillBackKeys = fillBackKey.split("\\|");
            String[] fillBackValues = fillBackValue.split("\\|");
            for (int i = 0; i < fillBackTypes.length; ++i) {
                SimpleObjectBean object = new SimpleObjectBean();
                object.setType(fillBackTypes[i]);
                object.setName(fillBackKeys[i]);
                if (fillBackTypes[i].equals(FormTriggerBean.FillBackType.formula.getKey())) {
                    FormFormulaBean formulaBean = new FormFormulaBean(sourceFormBean);
                    formulaBean.loadFromFormula(fillBackValues[i]);
                    triggerBean.addFormula(formulaBean, true);
                    object.setValue(formulaBean.getFormulaId().toString());
                    object.putExtraAttr(formulaBean.getFormulaId().toString(), (BasePO)formulaBean);
                } else {
                    object.setValue(fillBackValues[i]);
                }
                fillBackList.add(object);
            }
        }
        return fillBackList;
    }

    public Map<String, Object> getParamFromAction(FormTriggerBean triggerBean, FormTriggerActionBean bean) throws BusinessException {
        HashMap<String, Object> actionMap = new HashMap<String, Object>();
        actionMap.put("actionId", bean.getId());
        actionMap.put("actionType", bean.getType());
        for (Map.Entry entry : bean.getParam().entrySet()) {
            if (FormTriggerBean.ActionParam.FillBack.getKey().equals(entry.getKey())) {
                List fillBackList = (List)entry.getValue();
                actionMap.putAll(this.getFillBackMapFromBean4BillDesign(fillBackList));
                continue;
            }
            actionMap.put((String)entry.getKey(), entry.getValue());
        }
        return actionMap;
    }

    private Map<String, Object> getFillBackMapFromBean4BillDesign(List<SimpleObjectBean> fillBackList) {
        HashMap<String, Object> fillBackMap = new HashMap<String, Object>();
        StringBuilder types = new StringBuilder();
        StringBuilder keys = new StringBuilder();
        StringBuilder values = new StringBuilder();
        int fillSize = fillBackList.size();
        int size = 0;
        for (SimpleObjectBean object : fillBackList) {
            String flag = size < fillSize - 1 ? "|" : "";
            types.append(object.getType()).append(flag);
            keys.append(object.getName()).append(flag);
            if (object.getType().equals(FormTriggerBean.FillBackType.formula.getKey())) {
                values.append(((FormFormulaBean)object.getExtraAttr(object.getValue())).getFormulaForDisplay()).append(flag);
            } else {
                values.append(object.getValue()).append(flag);
            }
            ++size;
        }
        fillBackMap.put("fillBackType", types.toString());
        fillBackMap.put("fillBackKey", keys.toString());
        fillBackMap.put("fillBackValue", values.toString());
        return fillBackMap;
    }

    public String checkFieldInActionSet(FormBean formBean, String fieldName, FormTriggerActionBean actionBean) throws BusinessException {
        List fillBackList = (List)actionBean.getParam(FormTriggerBean.ActionParam.FillBack.getKey());
        for (SimpleObjectBean sob : fillBackList) {
            String setFieldName;
            if (sob.getName().contains(fieldName)) {
                return FormTriggerBean.CheckResultEnum.fillBack.getKey();
            }
            if (FormTriggerBean.FillBackType.formula.getKey().equals(sob.getType())) {
                Long formulaId = Long.valueOf(sob.getValue());
                FormFormulaBean ffb = (FormFormulaBean)sob.getExtraAttr(formulaId.toString());
                if (ffb == null) {
                    ffb = this.getCap4FormCacheManager().loadFormFormulaBean(formBean, formulaId);
                }
                setFieldName = ffb.getExecuteFormulaForSQL();
            } else {
                setFieldName = sob.getValue();
            }
            if (!setFieldName.contains(fieldName)) continue;
            return FormTriggerBean.CheckResultEnum.fillBack.getKey();
        }
        return FormTriggerBean.CheckResultEnum.none.getKey();
    }
}

