/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.engin.trigger.design;

import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormFormulaBean;
import com.seeyon.cap4.form.bean.FormTriggerActionBean;
import com.seeyon.cap4.form.bean.FormTriggerBean;
import com.seeyon.cap4.form.bean.FormTriggerConditionBean;
import com.seeyon.cap4.form.modules.engin.trigger.design.FormTriggerAutoBaseDesignManager;
import com.seeyon.cap4.form.modules.importandexport.BusinessDataBean;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDLong;
import java.util.Map;
import org.apache.commons.logging.Log;

public class FormTriggerBillOuterDesignManager
extends FormTriggerAutoBaseDesignManager {
    private static final Log LOGGER = CtpLogFactory.getLog(FormTriggerBillOuterDesignManager.class);

    public String getId() {
        return FormTriggerBean.TriggerType.BillOuter.getKey();
    }

    public String getName() {
        return FormTriggerBean.TriggerType.BillOuter.getText();
    }

    public Integer getSort() {
        return FormTriggerBean.TriggerType.BillOuter.ordinal();
    }

    @Override
    public FormTriggerActionBean getActionFromMap(FormTriggerBean triggerBean, Map<String, String> map) throws BusinessException {
        FormTriggerActionBean actionBean = super.getActionFromMap(triggerBean, map);
        FormBean sourceFormBean = this.getCap4FormCacheManager().getForm(triggerBean.getSourceFormId());
        String conditionId = map.get(FormTriggerBean.ActionParam.TargetBill.getKey());
        String conditionValue = map.get(FormTriggerBean.ActionParam.TargetBillValue.getKey());
        if (Strings.isNotBlank((String)conditionValue)) {
            FormFormulaBean formulaBean = new FormFormulaBean(sourceFormBean);
            formulaBean.loadFromFormula(conditionValue);
            if (Strings.isNotBlank((String)map.get(FormTriggerBean.ActionParam.TargetBillFormulaId.getKey()))) {
                formulaBean.setFormulaId(Long.valueOf(Long.parseLong(map.get(FormTriggerBean.ActionParam.TargetBillFormulaId.getKey()))));
            }
            triggerBean.addFormula(formulaBean);
            FormTriggerConditionBean targetBillCondition = new FormTriggerConditionBean(triggerBean);
            targetBillCondition.setId(Long.valueOf("".equals(conditionId) ? UUIDLong.longUUID() : Long.parseLong(conditionId)));
            targetBillCondition.setType(FormTriggerBean.ConditionType.targetBill.getKey());
            targetBillCondition.setConditionFormulaId(formulaBean.getFormulaId() == null ? "" : "" + formulaBean.getFormulaId());
            targetBillCondition.setConditionFormula(formulaBean);
            actionBean.setRelationCondition(targetBillCondition);
        }
        actionBean.addParam(FormTriggerBean.ActionParam.SubRowLocate.getKey(), (Object)map.get(FormTriggerBean.ActionParam.SubRowLocate.getKey()));
        actionBean.addParam(FormTriggerBean.ActionParam.TargetSub.getKey(), (Object)map.get(FormTriggerBean.ActionParam.TargetSub.getKey()));
        return actionBean;
    }

    @Override
    public Map<String, Object> getParamFromAction(FormTriggerBean triggerBean, FormTriggerActionBean bean) throws BusinessException {
        Map<String, Object> actionMap = super.getParamFromAction(triggerBean, bean);
        FormTriggerConditionBean targetBillCondition = bean.getRelationCondition();
        actionMap.put(FormTriggerBean.ActionParam.TargetBill.getKey(), targetBillCondition.getId());
        actionMap.put(FormTriggerBean.ActionParam.TargetBillValue.getKey(), targetBillCondition.getConditionFormula().getFormulaForDisplay());
        actionMap.put(FormTriggerBean.ActionParam.TargetBillFormulaId.getKey(), targetBillCondition.getConditionFormula().getFormulaId());
        actionMap.put(FormTriggerBean.ActionParam.SubRowLocate.getKey(), bean.getParam(FormTriggerBean.ActionParam.SubRowLocate.getKey()));
        actionMap.put(FormTriggerBean.ActionParam.TargetSub.getKey(), bean.getParam(FormTriggerBean.ActionParam.TargetSub.getKey()));
        return actionMap;
    }

    @Override
    public String checkFieldInActionSet(FormBean formBean, String fieldName, FormTriggerActionBean actionBean) throws BusinessException {
        if (actionBean.getRelationCondition().getConditionFormula().isInThisFormula(fieldName)) {
            return FormTriggerBean.CheckResultEnum.targetBill.getKey();
        }
        Object subLocate = actionBean.getParam(FormTriggerBean.ActionParam.SubRowLocate.getKey());
        if (subLocate != null && String.valueOf(subLocate).contains(fieldName)) {
            return FormTriggerBean.CheckResultEnum.subRowLocate.getKey();
        }
        return super.checkFieldInActionSet(formBean, fieldName, actionBean);
    }

    public void initializeActionBean(FormTriggerActionBean actionBean, Map<String, Object> jsonMap, BusinessDataBean businessDataBean) throws BusinessException {
        super.initializeActionBean(actionBean, jsonMap, businessDataBean);
        boolean conflict = (Boolean)jsonMap.get("conflict");
        Map relationConditionMap = (Map)jsonMap.get("relationCondition");
        relationConditionMap.put("conflict", conflict);
        FormTriggerConditionBean relationCondition = new FormTriggerConditionBean(actionBean.getFormTriggerBean(), relationConditionMap, businessDataBean);
        actionBean.setRelationCondition(relationCondition);
        Map paramJsonMap = (Map)jsonMap.get("param");
        actionBean.addParam(FormTriggerBean.ActionParam.TargetSub.getKey(), paramJsonMap.get(FormTriggerBean.ActionParam.TargetSub.getKey()));
        Object subLocateObj = paramJsonMap.get(FormTriggerBean.ActionParam.SubRowLocate.getKey());
        if (businessDataBean != null && subLocateObj != null) {
            String subRowLocate = (String)subLocateObj;
            String oldTableName = subRowLocate.substring(0, subRowLocate.indexOf("."));
            subRowLocate = subRowLocate.replace(oldTableName, businessDataBean.getOldAndNewStringMap(oldTableName));
            actionBean.addParam(FormTriggerBean.ActionParam.SubRowLocate.getKey(), (Object)subRowLocate);
        } else {
            actionBean.addParam(FormTriggerBean.ActionParam.SubRowLocate.getKey(), subLocateObj);
        }
    }

    public Map<String, Object> toJsonObject(FormTriggerActionBean actionBean, BusinessDataBean businessDataBean, boolean forRecord) {
        Map jsonMap = super.toJsonObject(actionBean, businessDataBean, forRecord);
        jsonMap.put(FormTriggerBean.ActionParam.TargetSub.getKey(), actionBean.getParam(FormTriggerBean.ActionParam.TargetSub.getKey()));
        jsonMap.put(FormTriggerBean.ActionParam.SubRowLocate.getKey(), actionBean.getParam(FormTriggerBean.ActionParam.SubRowLocate.getKey()));
        return jsonMap;
    }
}

