/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.engin.trigger.design;

import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormTriggerActionBean;
import com.seeyon.cap4.form.bean.FormTriggerBean;
import com.seeyon.cap4.form.bean.SimpleObjectBean;
import com.seeyon.cap4.form.modules.engin.trigger.FormTriggerInnerDesignManager;
import com.seeyon.cap4.form.modules.importandexport.BusinessDataBean;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.util.FormDesignUtil;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDLong;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FormTriggerMessageDesignManager
extends FormTriggerInnerDesignManager {
    private CAP4FormCacheManager cap4FormCacheManager;

    public CAP4FormCacheManager getCap4FormCacheManager() {
        return this.cap4FormCacheManager;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public String getId() {
        return FormTriggerBean.TriggerType.Message.getKey();
    }

    public String getName() {
        return FormTriggerBean.TriggerType.Message.getText();
    }

    public Integer getSort() {
        return FormTriggerBean.TriggerType.Message.ordinal();
    }

    public boolean canInFormManager() {
        return true;
    }

    public String getTriggerBusinessTypeKey() {
        return FormTriggerBean.TriggerType.Message.getOwnerType().getKey();
    }

    public String getTriggerBusinessTypeText() {
        return FormTriggerBean.TriggerType.Message.getOwnerType().getText();
    }

    public FormTriggerActionBean getActionFromMap(FormTriggerBean triggerBean, Map<String, String> map) throws BusinessException {
        FormTriggerActionBean actionBean = new FormTriggerActionBean(triggerBean);
        String actionId = map.get("actionId");
        actionBean.setId(Long.valueOf(Strings.isBlank((String)actionId) ? UUIDLong.longUUID() : Long.parseLong(actionId)));
        actionBean.setType(map.get("actionType"));
        actionBean.setName(this.getName());
        actionBean.addParam(FormTriggerBean.ActionParam.MsgContent.getKey(), (Object)map.get(FormTriggerBean.ActionParam.MsgContent.getKey()));
        actionBean.addParam(FormTriggerBean.ActionParam.MsgSendSMS.getKey(), (Object)map.get(FormTriggerBean.ActionParam.MsgSendSMS.getKey()));
        if (map.get(FormTriggerBean.ActionParam.DataRight.getKey()) != null) {
            actionBean.addParam(FormTriggerBean.ActionParam.DataRight.getKey(), (Object)map.get(FormTriggerBean.ActionParam.DataRight.getKey()));
        }
        String regex = "\\|";
        ArrayList<SimpleObjectBean> msgMemList = new ArrayList<SimpleObjectBean>();
        actionBean.addParam(FormTriggerBean.ActionParam.Entity.getKey(), msgMemList);
        String msgMem = map.get("messageMem");
        if (Strings.isNotBlank((String)msgMem)) {
            String[] roles = msgMem.split(",");
            FormBean sourceFormBean = this.getCap4FormCacheManager().getForm(triggerBean.getSourceFormId());
            for (String role : roles) {
                SimpleObjectBean object = new SimpleObjectBean();
                String[] keyValue = role.split(regex);
                object.setType(FormTriggerBean.EntityType.MessageSender.getKey());
                object.setName(keyValue[0]);
                object.setValue(keyValue[1].trim());
                String show = object.getName() + "|" + object.getValue();
                object.setDisplay(FormDesignUtil.getShowMemNameByIds((String)show, (FormBean)sourceFormBean));
                msgMemList.add(object);
            }
        }
        return actionBean;
    }

    public Map<String, Object> getParamFromAction(FormTriggerBean triggerBean, FormTriggerActionBean bean) throws BusinessException {
        HashMap<String, Object> actionMap = new HashMap<String, Object>();
        actionMap.put("actionId", bean.getId());
        actionMap.put("actionType", bean.getType());
        FormBean sourceFormBean = this.getCap4FormCacheManager().getForm(triggerBean.getSourceFormId());
        for (Map.Entry entry : bean.getParam().entrySet()) {
            if (FormTriggerBean.ActionParam.Entity.getKey().equals(entry.getKey())) {
                List msgMemList = (List)entry.getValue();
                StringBuilder memSb = new StringBuilder();
                String memName = "";
                int entitySize = msgMemList.size();
                int i = 0;
                for (SimpleObjectBean object : msgMemList) {
                    memSb.append(object.getName()).append("|").append(object.getValue()).append(i < entitySize - 1 ? "," : "");
                }
                String mem = memSb.toString();
                actionMap.put("messageMem", mem);
                if (Strings.isNotBlank((String)mem)) {
                    memName = FormDesignUtil.getShowMemNameByIds((String)mem, (FormBean)sourceFormBean);
                }
                actionMap.put("messageMem_txt", memName);
                continue;
            }
            actionMap.put((String)entry.getKey(), entry.getValue());
        }
        return actionMap;
    }

    public String checkFieldInActionSet(FormBean formBean, String fieldName, FormTriggerActionBean actionBean) throws BusinessException {
        String display = formBean.getFieldBeanByName(fieldName).getDisplay();
        String msgContent = (String)actionBean.getParam(FormTriggerBean.ActionParam.MsgContent.getKey());
        if (msgContent.contains("{" + display + "}")) {
            return FormTriggerBean.CheckResultEnum.msgContent.getKey();
        }
        List msgMem = (List)actionBean.getParam(FormTriggerBean.ActionParam.Entity.getKey());
        for (SimpleObjectBean sob : msgMem) {
            if (!"FormField".equals(sob.getName()) || !sob.getValue().contains(fieldName)) continue;
            return FormTriggerBean.CheckResultEnum.member.getKey();
        }
        return FormTriggerBean.CheckResultEnum.none.getKey();
    }

    public void initializeActionBean(FormTriggerActionBean actionBean, Map<String, Object> jsonMap, BusinessDataBean businessDataBean) throws BusinessException {
        super.initializeActionBean(actionBean, jsonMap, businessDataBean);
        Map paramJsonMap = (Map)jsonMap.get("param");
        actionBean.addParam(FormTriggerBean.ActionParam.MsgContent.getKey(), paramJsonMap.get(FormTriggerBean.ActionParam.MsgContent.getKey()));
        actionBean.addParam(FormTriggerBean.ActionParam.MsgSendSMS.getKey(), paramJsonMap.get(FormTriggerBean.ActionParam.MsgSendSMS.getKey()));
    }

    public Map<String, Object> toJsonObject(FormTriggerActionBean actionBean, BusinessDataBean businessDataBean, boolean forRecord) {
        Map jsonMap = super.toJsonObject(actionBean, businessDataBean, forRecord);
        jsonMap.put(FormTriggerBean.ActionParam.MsgContent.getKey(), actionBean.getParam(FormTriggerBean.ActionParam.MsgContent.getKey()));
        jsonMap.put(FormTriggerBean.ActionParam.MsgSendSMS.getKey(), actionBean.getParam(FormTriggerBean.ActionParam.MsgSendSMS.getKey()));
        return jsonMap;
    }
}

