/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.engin.trigger.design;

import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormBindAuthBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormFormulaBean;
import com.seeyon.cap4.form.bean.FormTriggerActionBean;
import com.seeyon.cap4.form.bean.FormTriggerBean;
import com.seeyon.cap4.form.bean.SimpleObjectBean;
import com.seeyon.cap4.form.modules.engin.trigger.FormTriggerBaseDesignManager;
import com.seeyon.cap4.form.modules.importandexport.BusinessDataBean;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.form.util.FormDesignUtil;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.po.BasePO;
import com.seeyon.ctp.common.po.template.CtpTemplate;
import com.seeyon.ctp.common.template.manager.TemplateManager;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDLong;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class FormTriggerOuterDesignManager
extends FormTriggerBaseDesignManager {
    private TemplateManager templateManager;
    private CAP4FormCacheManager cap4FormCacheManager;
    private static final String regex = "\\|";

    public void setTemplateManager(TemplateManager templateManager) {
        this.templateManager = templateManager;
    }

    public CAP4FormCacheManager getCap4FormCacheManager() {
        return this.cap4FormCacheManager;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public FormTriggerActionBean getActionFromMap(FormTriggerBean triggerBean, Map<String, String> map) throws BusinessException {
        FormTriggerActionBean actionBean = new FormTriggerActionBean(triggerBean);
        String actionId = map.get("actionId");
        actionBean.setId(Long.valueOf(Strings.isBlank((String)actionId) ? UUIDLong.longUUID() : Long.parseLong(actionId)));
        actionBean.setType(map.get("actionType"));
        actionBean.setName(this.getName());
        actionBean.addParam(FormTriggerBean.ActionParam.FormId.getKey(), (Object)triggerBean.getTargetFormId());
        if (map.get(FormTriggerBean.ActionParam.TemplateId.getKey()) != null) {
            actionBean.addParam(FormTriggerBean.ActionParam.TemplateId.getKey(), (Object)map.get(FormTriggerBean.ActionParam.TemplateId.getKey()));
        }
        if (map.get(FormTriggerBean.ActionParam.DataRight.getKey()) != null) {
            actionBean.addParam(FormTriggerBean.ActionParam.DataRight.getKey(), (Object)map.get(FormTriggerBean.ActionParam.DataRight.getKey()));
        }
        ArrayList<SimpleObjectBean> msgMemList = new ArrayList<SimpleObjectBean>();
        actionBean.addParam(FormTriggerBean.ActionParam.Entity.getKey(), msgMemList);
        String flowMem = map.get("flowMem");
        if (Strings.isNotBlank((String)flowMem)) {
            String[] roles = flowMem.split(",");
            FormBean sourceFormBean = this.getCap4FormCacheManager().getForm(triggerBean.getSourceFormId());
            for (String role : roles) {
                SimpleObjectBean object = new SimpleObjectBean();
                String[] keyValue = role.split(regex);
                object.setType(FormTriggerBean.EntityType.CollaborationSender.getKey());
                object.setName(keyValue[0]);
                object.setValue(keyValue[1].trim());
                String show = object.getName() + "|" + object.getValue();
                if (show.contains("ReciprocalRoleReporter") || !show.toLowerCase().contains("role")) {
                    object.setDisplay(FormDesignUtil.getShowMemNameByIds((String)show, (FormBean)sourceFormBean));
                } else {
                    object.setDisplay("");
                }
                msgMemList.add(object);
            }
        }
        List<SimpleObjectBean> fillBackList = this.parseFillBackFromMap4Design(triggerBean, map);
        actionBean.addParam(FormTriggerBean.ActionParam.FillBack.getKey(), fillBackList);
        return actionBean;
    }

    private List<SimpleObjectBean> parseFillBackFromMap4Design(FormTriggerBean triggerBean, Map<String, String> map) {
        String fillBackKey = map.get("fillBackKey");
        String fillBackType = map.get("fillBackType");
        String fillBackValue = map.get("fillBackValue");
        String rowCondition = map.get("rowCondition");
        String triggerSource = map.get("triggerSource");
        ArrayList<SimpleObjectBean> fillBackList = new ArrayList<SimpleObjectBean>();
        if (Strings.isNotBlank((String)fillBackKey)) {
            FormBean sourceFormBean = this.getCap4FormCacheManager().getForm(triggerBean.getSourceFormId());
            String[] fillBackTypes = fillBackType.split(regex);
            String[] fillBackKeys = fillBackKey.split(regex);
            String[] fillBackValues = fillBackValue.split(regex);
            String[] rowConditions = new String[]{};
            if (Strings.isNotBlank((String)rowCondition)) {
                rowConditions = rowCondition.split(":::rowCondition:::");
            }
            String[] triggerSources = new String[]{};
            if (Strings.isNotBlank((String)triggerSource)) {
                triggerSources = triggerSource.split(":::triggerSource:::");
            }
            for (int i = 0; i < fillBackTypes.length; ++i) {
                SimpleObjectBean object = new SimpleObjectBean();
                object.setType(fillBackTypes[i]);
                object.setName(fillBackKeys[i]);
                if (fillBackTypes[i].equals(FormTriggerBean.FillBackType.formula.getKey())) {
                    FormFormulaBean formulaBean = new FormFormulaBean(sourceFormBean);
                    formulaBean.loadFromFormula(fillBackValues[i]);
                    triggerBean.addFormula(formulaBean, true);
                    object.setValue(formulaBean.getFormulaId().toString());
                    object.putExtraAttr(formulaBean.getFormulaId().toString(), (BasePO)formulaBean);
                } else {
                    object.setValue(fillBackValues[i]);
                }
                if (i < rowConditions.length && Strings.isNotBlank((String)rowConditions[i])) {
                    FormFormulaBean rowConditionFormula = new FormFormulaBean(sourceFormBean);
                    rowConditionFormula.loadFromFormula(rowConditions[i]);
                    triggerBean.addFormula(rowConditionFormula, true);
                    object.setDisplay(rowConditionFormula.getFormulaId() + "");
                    object.putExtraAttr(rowConditionFormula.getFormulaId().toString(), (BasePO)rowConditionFormula);
                }
                if (i < triggerSources.length && Strings.isNotBlank((String)triggerSources[i])) {
                    object.setPhoneValue(triggerSources[i]);
                }
                fillBackList.add(object);
            }
        }
        return fillBackList;
    }

    public Map<String, Object> getParamFromAction(FormTriggerBean triggerBean, FormTriggerActionBean bean) throws BusinessException {
        HashMap<String, Object> actionMap = new HashMap<String, Object>();
        actionMap.put("actionId", bean.getId());
        actionMap.put("actionType", bean.getType());
        FormBean sourceFormBean = this.getCap4FormCacheManager().getForm(triggerBean.getSourceFormId());
        FormBean targetFormBean = this.getCap4FormCacheManager().getForm(triggerBean.getTargetFormId());
        for (Map.Entry entry : bean.getParam().entrySet()) {
            String templateId;
            if (FormTriggerBean.ActionParam.Entity.getKey().equals(entry.getKey())) {
                List msgMemList = (List)entry.getValue();
                String mem = "";
                String memName = "";
                int entitySize = msgMemList.size();
                int i = 0;
                for (SimpleObjectBean object : msgMemList) {
                    mem = mem + object.getName() + "|" + object.getValue() + (i < entitySize - 1 ? "," : "");
                }
                if (mem.contains("ReciprocalRoleReporter") || !mem.toLowerCase().contains("role") || mem.contains("MemberMetadataRole")) {
                    actionMap.put("entityMemType", "appoint");
                    if (!Strings.isBlank((String)mem)) {
                        memName = FormDesignUtil.getShowMemNameByIds((String)mem, (FormBean)sourceFormBean);
                    }
                    actionMap.put("flowMem_txt", memName);
                } else if (mem.toLowerCase().indexOf("node") > 0) {
                    actionMap.put("entityMemType", "currentFlowNode");
                    actionMap.put("flowMem_txt", ResourceUtil.getString((String)"form.trigger.triggerSet.clickToPerson.label"));
                } else {
                    actionMap.put("entityMemType", "currentFlowStartMember");
                    actionMap.put("flowMem_txt", ResourceUtil.getString((String)"form.trigger.triggerSet.clickToPerson.label"));
                }
                actionMap.put("flowMem", mem);
                continue;
            }
            if (FormTriggerBean.ActionParam.FillBack.getKey().equals(entry.getKey())) {
                List fillBackList = (List)entry.getValue();
                actionMap.putAll(this.getFillBackMapFromBean4Design(fillBackList, triggerBean));
                continue;
            }
            actionMap.put((String)entry.getKey(), entry.getValue());
            if (!FormTriggerBean.ActionParam.TemplateId.getKey().equals(entry.getKey()) || !Strings.isNotBlank((String)(templateId = (String)bean.getParam(FormTriggerBean.ActionParam.TemplateId.getKey())))) continue;
            CtpTemplate tem = this.templateManager.getCtpTemplate(Long.valueOf(Long.parseLong(templateId)));
            if (tem != null && !tem.isDelete().booleanValue()) {
                actionMap.put("content", tem.getSubject());
                continue;
            }
            if (targetFormBean == null) continue;
            FormBindAuthBean bindAuth = targetFormBean.getBind().getUnFlowTemplateById(Long.valueOf(Long.parseLong(templateId)));
            if (bindAuth != null) {
                actionMap.put("content", bindAuth.getName());
                continue;
            }
            actionMap.put(FormTriggerBean.ActionParam.TemplateId.getKey(), "");
        }
        return actionMap;
    }

    private Map<String, Object> getFillBackMapFromBean4Design(List<SimpleObjectBean> fillBackList, FormTriggerBean triggerBean) {
        HashMap<String, Object> fillBackMap = new HashMap<String, Object>();
        StringBuilder types = new StringBuilder();
        StringBuilder keys = new StringBuilder();
        StringBuilder values = new StringBuilder();
        StringBuilder rowConditions = new StringBuilder();
        StringBuilder triggerSources = new StringBuilder();
        int fillSize = fillBackList.size();
        int size = 0;
        String rowCFlag = ":::rowCondition:::";
        String srcCFlag = ":::triggerSource:::";
        for (SimpleObjectBean object : fillBackList) {
            String flag = size < fillSize - 1 ? "|" : "";
            types.append(object.getType()).append(flag);
            keys.append(object.getName()).append(flag);
            if (object.getType().equals(FormTriggerBean.FillBackType.formula.getKey())) {
                Long formulaId = Long.valueOf(object.getValue());
                FormFormulaBean formulaBean = null;
                try {
                    FormBean sourceFormBean = this.getCap4FormCacheManager().getForm(triggerBean.getSourceFormId());
                    formulaBean = this.getCap4FormCacheManager().loadFormFormulaBean(sourceFormBean, formulaId);
                }
                catch (BusinessException sourceFormBean) {
                    // empty catch block
                }
                if (formulaBean != null) {
                    object.putExtraAttr(object.getValue(), formulaBean);
                    FormFormulaBean formula = triggerBean.getFormula(formulaId.longValue());
                    triggerBean.getFormulaList().remove(formula);
                    triggerBean.addFormula(formulaBean);
                } else {
                    formulaBean = (FormFormulaBean)object.getExtraAttr(object.getValue());
                }
                values.append(formulaBean.getFormulaForDisplay()).append(flag);
            } else {
                values.append(object.getValue()).append(flag);
            }
            String rowCondition = "";
            if (Strings.isNotBlank((String)object.getDisplay())) {
                rowCondition = ((FormFormulaBean)object.getExtraAttr(object.getDisplay())).getFormulaForDisplay();
            }
            rowConditions.append(rowCondition).append(rowCFlag);
            String triggerSource = "";
            if (Strings.isNotBlank((String)object.getPhoneValue())) {
                triggerSource = object.getPhoneValue();
            }
            triggerSources.append(triggerSource).append(srcCFlag);
            ++size;
        }
        fillBackMap.put("fillBackType", types.toString());
        fillBackMap.put("fillBackKey", keys.toString());
        fillBackMap.put("fillBackValue", values.toString());
        fillBackMap.put("rowCondition", rowConditions.toString());
        fillBackMap.put("triggerSource", triggerSources.toString());
        return fillBackMap;
    }

    public String checkFieldInActionSet(FormBean formBean, String fieldName, FormTriggerActionBean actionBean) throws BusinessException {
        block11: {
            String tableIndex;
            List fillBackList;
            block10: {
                fillBackList = (List)actionBean.getParam(FormTriggerBean.ActionParam.FillBack.getKey());
                if (!formBean.getId().equals(actionBean.getFormTriggerBean().getTargetFormId())) break block10;
                for (SimpleObjectBean sob : fillBackList) {
                    if (!sob.getName().contains(fieldName)) continue;
                    return FormTriggerBean.CheckResultEnum.fillBack.getKey();
                }
                break block11;
            }
            FormFieldBean fieldBean = formBean.getFieldBeanByName(fieldName);
            if (fieldBean.isMasterField()) {
                String mainTableName = formBean.getMasterTableBean().getTableName();
                tableIndex = mainTableName.replace(Enums.TableType.MASTER.getTableSufName() + "_", "");
            } else {
                tableIndex = fieldBean.getOwnerTableName().replace(Enums.TableType.SLAVE.getTableSufName() + "_", "");
            }
            String fieldNameWithTableIndex = tableIndex + "." + fieldName;
            for (SimpleObjectBean sob : fillBackList) {
                FormFormulaBean rowCon;
                if (FormTriggerBean.FillBackType.formula.getKey().equals(sob.getType())) {
                    Long formulaId = Long.valueOf(sob.getValue());
                    FormFormulaBean ffb = (FormFormulaBean)sob.getExtraAttr(formulaId.toString());
                    if (ffb == null) {
                        ffb = this.getCap4FormCacheManager().loadFormFormulaBean(formBean, formulaId);
                    }
                    if (ffb.getExecuteFormulaForSQL().contains(fieldNameWithTableIndex)) {
                        return FormTriggerBean.CheckResultEnum.fillBack.getKey();
                    }
                } else if (sob.getValue().contains(fieldName)) {
                    return FormTriggerBean.CheckResultEnum.fillBack.getKey();
                }
                if (!Strings.isNotBlank((String)sob.getDisplay()) || (rowCon = (FormFormulaBean)sob.getExtraAttr(sob.getDisplay())) == null || !rowCon.isInThisFormula(fieldName)) continue;
                return FormTriggerBean.CheckResultEnum.rowCondition.getKey();
            }
            List msgMem = (List)actionBean.getParam(FormTriggerBean.ActionParam.Entity.getKey());
            if (!Strings.isNotEmpty((Collection)msgMem)) break block11;
            for (SimpleObjectBean sob : msgMem) {
                if (!"FormField".equals(sob.getName()) || !sob.getValue().contains(fieldName)) continue;
                return FormTriggerBean.CheckResultEnum.member.getKey();
            }
        }
        return FormTriggerBean.CheckResultEnum.none.getKey();
    }

    public void initializeActionBean(FormTriggerActionBean actionBean, Map<String, Object> jsonMap, BusinessDataBean businessDataBean) throws BusinessException {
        super.initializeActionBean(actionBean, jsonMap, businessDataBean);
        boolean conflict = (Boolean)jsonMap.get("conflict");
        actionBean.addParam(FormTriggerBean.ActionParam.FormId.getKey(), (Object)actionBean.getFormTriggerBean().getTargetFormId());
        Map paramJsonMap = (Map)jsonMap.get("param");
        if (paramJsonMap.get(FormTriggerBean.ActionParam.TemplateId.getKey()) != null) {
            if (businessDataBean != null) {
                String templateId = (String)paramJsonMap.get(FormTriggerBean.ActionParam.TemplateId.getKey());
                if (Strings.isNotBlank((String)templateId)) {
                    Long oldTemplateId = Long.valueOf(templateId);
                    if (businessDataBean.isUpgrade()) {
                        oldTemplateId = businessDataBean.getRealId4Upgrade(oldTemplateId);
                    }
                    Long newTemplateId = businessDataBean.genNewIdByOldId(oldTemplateId, conflict, false);
                    actionBean.addParam(FormTriggerBean.ActionParam.TemplateId.getKey(), (Object)newTemplateId.toString());
                }
            } else {
                actionBean.addParam(FormTriggerBean.ActionParam.TemplateId.getKey(), paramJsonMap.get(FormTriggerBean.ActionParam.TemplateId.getKey()));
            }
        }
    }

    public Map<String, Object> toJsonObject(FormTriggerActionBean actionBean, BusinessDataBean businessDataBean, boolean forRecord) {
        Map jsonMap = super.toJsonObject(actionBean, businessDataBean, forRecord);
        Long formId = (Long)actionBean.getParam(FormTriggerBean.ActionParam.FormId.getKey());
        Object tempId = actionBean.getParam(FormTriggerBean.ActionParam.TemplateId.getKey());
        if (null == tempId || Strings.isBlank((String)tempId.toString())) {
            if (businessDataBean == null) {
                jsonMap.put(FormTriggerBean.ActionParam.FormId.getKey(), formId);
            } else {
                jsonMap.put(FormTriggerBean.ActionParam.FormId.getKey(), businessDataBean.getRealId4Export(formId));
            }
        } else {
            Long templateId = Long.valueOf(tempId.toString());
            if (businessDataBean == null) {
                jsonMap.put(FormTriggerBean.ActionParam.FormId.getKey(), formId);
                jsonMap.put(FormTriggerBean.ActionParam.TemplateId.getKey(), templateId);
            } else {
                jsonMap.put(FormTriggerBean.ActionParam.FormId.getKey(), businessDataBean.getRealId4Export(formId));
                jsonMap.put(FormTriggerBean.ActionParam.TemplateId.getKey(), businessDataBean.getRealId4Export(templateId));
            }
        }
        return jsonMap;
    }
}

