/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.formSection;

import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormFieldComEnum;
import com.seeyon.cap4.form.bean.FormFlowBusinessBean;
import com.seeyon.cap4.form.bean.SimpleObjectBean;
import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.cap4.form.modules.business.BusinessManager;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.template.bean.FormDataListParamBean;
import com.seeyon.cap4.template.manager.CAPFlowToDoManager;
import com.seeyon.cap4.template.vo.FlowListVO;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.ModuleType;
import com.seeyon.ctp.common.authenticate.domain.User;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.taglibs.functions.Functions;
import com.seeyon.ctp.portal.section.BaseSectionImpl;
import com.seeyon.ctp.portal.section.templete.BaseSectionTemplete;
import com.seeyon.ctp.portal.section.templete.FlowBusinessTemplete;
import com.seeyon.ctp.portal.section.templete.IframeTemplete;
import com.seeyon.ctp.portal.util.PortletPropertyContants;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.json.JSONUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;

public class FlowBusinessListSection
extends BaseSectionImpl {
    private static final Log LOGGER = CtpLogFactory.getLog(FlowBusinessListSection.class);
    private CAP4FormCacheManager cap4FormCacheManager;
    private BusinessManager businessManager4;
    private CAPFlowToDoManager capFlowToDoManager;

    public String getId() {
        return "flowBusinessListSection";
    }

    public String getName(Map<String, String> preference) {
        String[] ids;
        FormBean formBean;
        FormFlowBusinessBean formFlowBusinessBean;
        String name = preference.get("columnsName");
        if (Strings.isNotBlank((String)name)) {
            return ResourceUtil.getString((String)name);
        }
        String sectionId = preference.get(PortletPropertyContants.PropertyName.singleBoardId.name());
        if (Strings.isNotBlank((String)sectionId) && (formFlowBusinessBean = (formBean = this.cap4FormCacheManager.getForm(Long.parseLong((ids = sectionId.split("[|]"))[0]))).getBind().getFlowBusinessBean(ids[1])) != null) {
            return formFlowBusinessBean.getName();
        }
        return null;
    }

    public String getBaseName(Map<String, String> preference) {
        return this.getName(preference);
    }

    public Integer getTotal(Map<String, String> map) {
        return null;
    }

    public String getIcon() {
        return null;
    }

    public boolean isAllowUsed() {
        User currentUser = AppContext.getCurrentUser();
        return !currentUser.isGroupAdmin();
    }

    public String getResolveFunction(Map<String, String> preference) {
        String queryType = preference.get("_style");
        if (Strings.isBlank((String)queryType)) {
            queryType = "listData";
        }
        if ("singleData".equals(queryType)) {
            return "iframeTemplete";
        }
        return "flowBusinessTemplete";
    }

    public BaseSectionTemplete projection(Map<String, String> preference) {
        String strCount;
        int count;
        String sectionId = preference.get(PortletPropertyContants.PropertyName.singleBoardId.name());
        IframeTemplete itemp = new IframeTemplete();
        if (Strings.isBlank((String)sectionId)) {
            return itemp;
        }
        String[] ids = sectionId.split("[|]");
        String formId = ids[0];
        String templateId = ids[1];
        String queryType = preference.get("_style");
        if (Strings.isBlank((String)queryType)) {
            queryType = "listData";
        }
        int n = count = Strings.isBlank((String)(strCount = preference.get("count"))) ? 50 : Integer.parseInt(strCount);
        if (Strings.isBlank((String)strCount) && "cardData".equals(queryType)) {
            count = 3;
        }
        String fieldValue = "";
        if (preference.get("source_value") != null) {
            fieldValue = preference.get("source_value");
        }
        FlowBusinessTemplete flowBusinessTemplete = this.getTempleteByStyle(preference, templateId, Long.parseLong(formId), fieldValue, queryType, count);
        return flowBusinessTemplete;
    }

    /*
     * WARNING - void declaration
     */
    private FlowBusinessTemplete getTempleteByStyle(Map<String, String> preference, String templateId, Long formId, String fieldValue, String queryType, int count) {
        FlowBusinessTemplete flowBusinessTemplete = new FlowBusinessTemplete();
        int size = count;
        if (!"listData".equals(queryType)) {
            int[] chessBoardInfo = flowBusinessTemplete.getPageSize(preference);
            if (!"cardData".equals(queryType)) {
                size = chessBoardInfo[0];
            }
            flowBusinessTemplete.setLayout(chessBoardInfo[1], chessBoardInfo[2]);
        }
        try {
            FormBean formBean = this.cap4FormCacheManager.getForm(formId);
            FormFlowBusinessBean formFlowBusinessBean = formBean.getBind().getFlowBusinessBean(templateId);
            FormDataListParamBean formDataListParamBean = new FormDataListParamBean();
            ArrayList<String> showFieldNameList = new ArrayList<String>();
            ArrayList<String> showFieldList = new ArrayList<String>();
            if (Strings.isEmpty((String)fieldValue) || "null".equals(fieldValue)) {
                List businessBeanShowFieldList = formFlowBusinessBean.getShowFieldList();
                for (SimpleObjectBean simpleObjectBean : businessBeanShowFieldList) {
                    showFieldNameList.add(simpleObjectBean.getName());
                    String display = simpleObjectBean.getValue();
                    if (display.contains("(")) {
                        display = display.substring(display.indexOf("(") + 1, display.indexOf(")"));
                    }
                    showFieldList.add(display);
                }
            } else {
                void var18_21;
                Map fieldMap = (Map)JSONUtil.parseJSONString((String)fieldValue, Map.class);
                ArrayList<SimpleObjectBean> simpleObjectBeans = new ArrayList<SimpleObjectBean>();
                String[] showFieldNameListArray = ((String)fieldMap.get("showFieldNameList")).split(",");
                String[] showFieldListArray = ((String)fieldMap.get("showFieldList")).split(",");
                boolean bl = false;
                int j = showFieldNameListArray.length;
                while (var18_21 < j) {
                    String fieldName = showFieldNameListArray[var18_21];
                    String showName = showFieldListArray[var18_21];
                    FormFieldBean formFieldBean = this.getFormFieldBean(formBean, fieldName);
                    if (formFieldBean != null) {
                        showFieldNameList.add(fieldName);
                        showFieldList.add(showName);
                        SimpleObjectBean simpleObjectBean = new SimpleObjectBean();
                        simpleObjectBean.setName(fieldName);
                        simpleObjectBean.setValue(showName);
                        simpleObjectBeans.add(simpleObjectBean);
                    }
                    ++var18_21;
                }
                formDataListParamBean.setCustomShowFields(simpleObjectBeans);
            }
            formDataListParamBean.setInit("0");
            formDataListParamBean.setFormTemplateId(Long.valueOf(templateId));
            formDataListParamBean.setFormId(formId);
            formDataListParamBean.setPageSize(size);
            FlowListVO flowToDoListVO = (FlowListVO)this.capFlowToDoManager.getList(formDataListParamBean);
            List<Map<String, Object>> dataList = flowToDoListVO.getDatas();
            String imgFiledName = this.getImgFiledName(formBean, showFieldNameList);
            for (Map map : dataList) {
                String url;
                String id = String.valueOf(map.get("id"));
                FlowBusinessTemplete.FlowBusinessList flowBusinessList = flowBusinessTemplete.addFlowBusinessList(id);
                Map fixedField = (Map)map.get("fixedField");
                flowBusinessList.setAffairId((String)fixedField.get("affairId"));
                flowBusinessList.setSubject((String)fixedField.get("subject"));
                int j = showFieldNameList.size();
                for (int i = 0; !(i >= j || i > 2 && "pictureAndListData".equals(queryType)); ++i) {
                    String fieldName = (String)showFieldNameList.get(i);
                    FormFieldBean formFieldBean = this.getFormFieldBean(formBean, fieldName);
                    if (formFieldBean == null || Strings.isNotBlank((String)imgFiledName) && formFieldBean.getName().contains(imgFiledName) && "pictureAndListData".equals(queryType)) continue;
                    FlowBusinessTemplete.FieldList fieldList = flowBusinessList.addFieldList();
                    fieldList.setDisplayName((String)showFieldList.get(i));
                    Object valueMapObject = map.get(fieldName.contains(".") ? fieldName.split("[.]")[1] : fieldName);
                    if (valueMapObject == null) {
                        fieldList.setDisplayNameValue("");
                        continue;
                    }
                    Map valueMap = (Map)valueMapObject;
                    Object value = valueMap.get("value");
                    if (value == null) {
                        fieldList.setDisplayNameValue("");
                        continue;
                    }
                    if ("*".equals(String.valueOf(value)) && (FormFieldComEnum.IMAGE_SELECT.getKey().equals(formFieldBean.getInputType()) || FormFieldComEnum.IMAGE_RADIO.getKey().equals(formFieldBean.getInputType()) || FormFieldComEnum.EXTEND_IMAGE.getKey().equals(formFieldBean.getInputType()) && formFieldBean.isAttachment())) {
                        fieldList.setDisplayNameValue(String.valueOf(value));
                        continue;
                    }
                    if (FormFieldComEnum.IMAGE_SELECT.getKey().equals(formFieldBean.getInputType()) || FormFieldComEnum.IMAGE_RADIO.getKey().equals(formFieldBean.getInputType())) {
                        fieldList.setDisplayNameValueUrlForImage(String.valueOf(value));
                        continue;
                    }
                    if (FormFieldComEnum.EXTEND_IMAGE.getKey().equals(formFieldBean.getInputType()) && formFieldBean.isAttachment()) {
                        String url2 = this.getImageUrl(value);
                        if (Strings.isEmpty((String)url2)) {
                            fieldList.setDisplayNameValue("");
                            continue;
                        }
                        fieldList.setDisplayNameValueUrlForImage(url2);
                        continue;
                    }
                    fieldList.setDisplayNameValue(String.valueOf(value));
                }
                if (flowBusinessList.getFieldList() == null) {
                    flowBusinessList.addFieldList();
                }
                flowBusinessList.setImgUrl("/seeyon/common/form/common/css/img/none.png");
                Object valueMap = map.get(imgFiledName);
                if (valueMap == null) continue;
                Object value = ((Map)valueMap).get("value");
                if (!"*".equals(String.valueOf(value)) && value != null && value instanceof String) {
                    flowBusinessList.setImgUrl(String.valueOf(value));
                    continue;
                }
                if ("*".equals(String.valueOf(value)) || !Strings.isNotEmpty((String)(url = this.getImageUrl(value)))) continue;
                flowBusinessList.setImgUrl(url);
            }
            int moduleType = ModuleType.cap4Form.getKey();
            flowBusinessTemplete.setModuleType(String.valueOf(moduleType));
        }
        catch (BusinessException e) {
            LOGGER.error((Object)"capFlowToDoManager.getList businessException", (Throwable)e);
        }
        this.addMoreButton((BaseSectionTemplete)flowBusinessTemplete, String.valueOf(formId), templateId);
        return flowBusinessTemplete;
    }

    private String getImageUrl(Object value) {
        List attrList;
        String url = "";
        if (value != null && (attrList = (List)value) != null) {
            Map attr = (Map)attrList.get(0);
            url = "/seeyon/image.do?method=showImage&id=" + (String)attr.get("fileUrl");
        }
        return url;
    }

    private String getImgFiledName(FormBean formBean, List<String> showFieldNameList) {
        String fieleName = "";
        boolean find = false;
        FormFieldBean enumImageFormFieldBean = null;
        for (String fieldName : showFieldNameList) {
            FormFieldBean formFieldBean = this.getFormFieldBean(formBean, fieldName);
            if (formFieldBean == null) continue;
            boolean showImg = formFieldBean.isAttachment();
            boolean isMasterField = formFieldBean.isMasterField();
            if (showImg && isMasterField) {
                fieleName = formFieldBean.getName();
                find = true;
                break;
            }
            if (null != enumImageFormFieldBean || !FormFieldComEnum.IMAGE_SELECT.getKey().equals(formFieldBean.getInputType()) && !FormFieldComEnum.IMAGE_RADIO.getKey().equals(formFieldBean.getInputType()) || !isMasterField) continue;
            enumImageFormFieldBean = formFieldBean;
        }
        if (!find && null != enumImageFormFieldBean) {
            fieleName = enumImageFormFieldBean.getName();
        }
        return fieleName;
    }

    private FormFieldBean getFormFieldBean(FormBean formBean, String fieldName) {
        Enums.FlowBusinessFixField fixField;
        FormFieldBean formFieldBean;
        if (fieldName.indexOf(".") != -1) {
            fieldName = fieldName.split("[.]")[1];
        }
        if ((formFieldBean = formBean.getFieldBeanByName(fieldName, true)) == null && (fixField = Enums.FlowBusinessFixField.getEnumByKey((String)fieldName)) != null) {
            formFieldBean = fixField.getFormFieldBean();
        }
        return formFieldBean;
    }

    private void addMoreButton(BaseSectionTemplete templete, String formId, String templateId) {
        FormBean formBean = this.cap4FormCacheManager.getForm(Long.parseLong(formId));
        try {
            BizConfigBean bizConfigBean = this.businessManager4.findBizConfigByFormId(formBean.getId());
            if (bizConfigBean != null) {
                templete.addBottomButton("common_more_label", this.getMoreButtonUrl(String.valueOf(bizConfigBean.getId()), templateId, formId));
            }
        }
        catch (BusinessException e) {
            LOGGER.error((Object)"FlowBusinessListSection.addMoreButton.findBizConfigByFormId.BusinessException", (Throwable)e);
        }
    }

    private String getMoreButtonUrl(String bussId, String appId, String formId) {
        StringBuilder sb = new StringBuilder();
        sb.append("/common/cap4/template/display/pc/flowpending/0/dist/index.html?V=").append(Functions.csrfSuffix()).append("_").append(new Date().getTime()).append("&bussId=").append(bussId).append("&appId=").append(appId).append("&formId=").append(formId);
        return sb.toString();
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public void setBusinessManager4(BusinessManager businessManager4) {
        this.businessManager4 = businessManager4;
    }

    public void setCapFlowToDoManager(CAPFlowToDoManager capFlowToDoManager) {
        this.capFlowToDoManager = capFlowToDoManager;
    }
}

