/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.formSection;

import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormFlowBusinessBean;
import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.cap4.form.modules.business.BusinessManager;
import com.seeyon.cap4.form.modules.business.CapBizConfigItemManager;
import com.seeyon.cap4.form.modules.formSection.BusinessSectionBaseManager;
import com.seeyon.cap4.form.po.CapBizConfigItem;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.portal.section.bo.SectionTreeNode;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDLong;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;

public class FlowBusinessSectionManagerImpl
implements BusinessSectionBaseManager {
    private static final Log LOGGER = CtpLogFactory.getLog(FlowBusinessSectionManagerImpl.class);
    private CAP4FormCacheManager cap4FormCacheManager;
    private BusinessManager businessManager4;
    private CapBizConfigItemManager capBizConfigItemManager;

    @Override
    public boolean isEnableUsed() {
        return true;
    }

    public List<SectionTreeNode> getTreeNodeList(String parentId) throws BusinessException {
        return this.getTreeNodeList(parentId, null, null);
    }

    public List<SectionTreeNode> getTreeNodeList(String parentId, String searchKey, Long accountId) throws BusinessException {
        Long bizConfigId;
        BizConfigBean bizConfig;
        String flowBusinessUUID = UUIDLong.longUUID() + "";
        ArrayList<SectionTreeNode> nodes = new ArrayList<SectionTreeNode>();
        SectionTreeNode rootBaseNode = new SectionTreeNode();
        rootBaseNode.setId(flowBusinessUUID);
        rootBaseNode.setSectionName(ResourceUtil.getString((String)"form.base.formtype.flowForm"));
        rootBaseNode.setParentId(parentId);
        nodes.add(rootBaseNode);
        if (Strings.isNotEmpty((String)parentId) && (bizConfig = this.businessManager4.findBizConfigById(bizConfigId = Long.valueOf(Long.parseLong(parentId)))) != null) {
            List<CapBizConfigItem> capBizConfigItemList = this.capBizConfigItemManager.findByBizId(bizConfigId);
            for (CapBizConfigItem capBizConfigItem : capBizConfigItemList) {
                FormBean formBean = this.cap4FormCacheManager.getForm(capBizConfigItem.getFormId());
                if (formBean == null || Enums.FormType.processesForm.getKey() != formBean.getFormType()) continue;
                Map unTemplates = formBean.getBind().getFlowBusinessMap();
                for (Map.Entry entry : unTemplates.entrySet()) {
                    FormFlowBusinessBean template = (FormFlowBusinessBean)entry.getValue();
                    if (!AppContext.isAdministrator() && !template.checkRight(AppContext.currentUserId())) continue;
                    SectionTreeNode baseNode = new SectionTreeNode();
                    baseNode.setId(UUIDLong.longUUID() + "");
                    baseNode.setParentId(flowBusinessUUID);
                    String templateName = template.getName();
                    if (Strings.isNotBlank((String)searchKey) && templateName.indexOf(searchKey) == -1) continue;
                    baseNode.setSectionName(templateName);
                    baseNode.setSingleBoardId(formBean.getId() + "|" + template.getId());
                    baseNode.setSectionBeanId("flowBusinessListSection");
                    nodes.add(baseNode);
                }
            }
        }
        if (Strings.isNotBlank((String)searchKey) && nodes.size() == 1) {
            nodes.clear();
        }
        return nodes;
    }

    @Override
    public String[] getSpaceTypes() {
        return new String[0];
    }

    public Integer getSort() {
        return 3;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public void setBusinessManager4(BusinessManager businessManager4) {
        this.businessManager4 = businessManager4;
    }

    public void setCapBizConfigItemManager(CapBizConfigItemManager capBizConfigItemManager) {
        this.capBizConfigItemManager = capBizConfigItemManager;
    }
}

