/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.formSection;

import com.seeyon.cap4.form.modules.formSection.BusinessSectionBaseManager;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.constants.ApplicationCategoryEnum;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.portal.section.bo.SectionTreeNode;
import com.seeyon.ctp.report.category.ReportCategoryConstants;
import com.seeyon.ctp.report.category.manager.ReportCategoryManager;
import com.seeyon.ctp.report.category.po.ReportRecord;
import com.seeyon.ctp.report.engine.api.ReportConstants;
import com.seeyon.ctp.report.engine.api.manager.ReportApi;
import com.seeyon.ctp.util.ParamUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDLong;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ReportSectionManagerImpl
implements BusinessSectionBaseManager {
    private String[] spaceTypes;
    private ReportApi reportApi;
    private ReportCategoryManager reportCategoryManager;

    @Override
    public boolean isEnableUsed() {
        return true;
    }

    public List<SectionTreeNode> getTreeNodeList(String parentId) throws BusinessException {
        return this.getTreeNodeList(parentId, null, null);
    }

    public List<SectionTreeNode> getTreeNodeList(String parentId, String searchKey, Long accountId) throws BusinessException {
        String reportUUID = UUIDLong.longUUID() + "";
        ArrayList<SectionTreeNode> nodes = new ArrayList<SectionTreeNode>();
        SectionTreeNode rootBaseNode = new SectionTreeNode();
        rootBaseNode.setId(reportUUID);
        rootBaseNode.setSectionName(ResourceUtil.getString((String)"cap4.form.business.common.sectionType.report"));
        rootBaseNode.setParentId(parentId);
        nodes.add(rootBaseNode);
        if (Strings.isNotEmpty((String)parentId)) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("category", ApplicationCategoryEnum.cap4biz.name());
            params.put("categoryId", parentId);
            params.put("designTypeList", new String[]{ReportConstants.DesignType.QUERY.name(), ReportConstants.DesignType.STATISTICS.name(), ReportConstants.DesignType.MULTSTATS.name(), ReportConstants.DesignType.SCHEDULEDSTATS.name()});
            List reportList = this.reportApi.findDesignWithoutAuth(params);
            ArrayList<Long> relatedIds = new ArrayList<Long>();
            for (Map map : reportList) {
                Long designId = ParamUtil.getLong((Map)map, (String)"designId");
                if (!AppContext.isAdmin() && !this.reportApi.checkAuth(designId, Long.valueOf(AppContext.currentUserId()))) continue;
                relatedIds.add(designId);
            }
            if (Strings.isNotEmpty(relatedIds)) {
                HashMap<String, Serializable> recordParams = new HashMap<String, Serializable>();
                recordParams.put("relatedIds", relatedIds);
                recordParams.put("useFlag", Integer.valueOf(ReportCategoryConstants.RecordUseFlag.Enable.key));
                List list = this.reportCategoryManager.findReportRecord(recordParams);
                if (CollectionUtils.isNotEmpty((Collection)list)) {
                    for (ReportRecord record : list) {
                        if (StringUtils.isNotBlank((CharSequence)searchKey) && record.getRecordSubject().indexOf(searchKey) == -1) continue;
                        SectionTreeNode node = new SectionTreeNode();
                        node.setId(record.getId().toString());
                        node.setParentId(reportUUID);
                        node.setSectionName(record.getRecordSubject());
                        node.setSingleBoardId(node.getId());
                        int recordType = record.getRecordType();
                        if (ReportConstants.DesignType.QUERY.ordinal() == recordType) {
                            node.setSectionBeanId("vreportQuerySection");
                        } else if (ReportConstants.DesignType.STATISTICS.ordinal() == recordType || ReportConstants.DesignType.MULTSTATS.ordinal() == recordType || ReportConstants.DesignType.SCHEDULEDSTATS.ordinal() == recordType) {
                            node.setSectionBeanId("vreportStatsSection");
                        }
                        nodes.add(node);
                    }
                }
            }
        }
        if (Strings.isNotBlank((String)searchKey) && nodes.size() == 1) {
            nodes.clear();
        }
        return nodes;
    }

    @Override
    public String[] getSpaceTypes() {
        return this.spaceTypes;
    }

    public Integer getSort() {
        return 2;
    }

    public void setReportApi(ReportApi reportApi) {
        this.reportApi = reportApi;
    }

    public void setReportCategoryManager(ReportCategoryManager reportCategoryManager) {
        this.reportCategoryManager = reportCategoryManager;
    }
}

