/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.formSection;

import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormBindAuthBean;
import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.cap4.form.modules.business.BusinessManager;
import com.seeyon.cap4.form.modules.business.CapBizConfigItemManager;
import com.seeyon.cap4.form.modules.formSection.BusinessSectionBaseManager;
import com.seeyon.cap4.form.po.CapBizConfigItem;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.service.CAP4FormManager;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.authenticate.domain.User;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.portal.section.bo.SectionTreeNode;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDLong;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class UnflowSectionManagerImpl
implements BusinessSectionBaseManager {
    private String[] spaceTypes;
    private CAP4FormCacheManager cap4FormCacheManager;
    private CAP4FormManager cap4FormManager;
    private BusinessManager businessManager4;
    private CapBizConfigItemManager capBizConfigItemManager;

    @Override
    public boolean isEnableUsed() {
        return true;
    }

    public List<SectionTreeNode> getTreeNodeList(String parentId) throws BusinessException {
        return this.getTreeNodeList(parentId, null, null);
    }

    public List<SectionTreeNode> getTreeNodeList(String parentId, String searchKey, Long accountId) throws BusinessException {
        Long bizConfigId;
        BizConfigBean bizConfig;
        User user = AppContext.getCurrentUser();
        String unflowUUID = UUIDLong.longUUID() + "";
        ArrayList<SectionTreeNode> nodes = new ArrayList<SectionTreeNode>();
        SectionTreeNode rootBaseNode = new SectionTreeNode();
        rootBaseNode.setId(unflowUUID);
        rootBaseNode.setSectionName(ResourceUtil.getString((String)"form.base.formtype.unflowform"));
        rootBaseNode.setParentId(parentId);
        nodes.add(rootBaseNode);
        if (Strings.isNotEmpty((String)parentId) && (bizConfig = this.businessManager4.findBizConfigById(bizConfigId = Long.valueOf(Long.parseLong(parentId)))) != null) {
            List<CapBizConfigItem> capBizConfigItemList = this.capBizConfigItemManager.findByBizId(bizConfigId);
            for (CapBizConfigItem capBizConfigItem : capBizConfigItemList) {
                FormBean fb = this.cap4FormCacheManager.getForm(capBizConfigItem.getFormId());
                if (fb == null || Enums.FormType.unFlowForm.getKey() != fb.getFormType()) continue;
                Map unTemplates = fb.getBind().getUnFlowTemplateMap();
                for (Map.Entry entry : unTemplates.entrySet()) {
                    FormBindAuthBean template = (FormBindAuthBean)entry.getValue();
                    if (!AppContext.isAdministrator() && !template.checkRight(AppContext.currentUserId())) continue;
                    SectionTreeNode baseNode = new SectionTreeNode();
                    baseNode.setId(UUIDLong.longUUID() + "");
                    baseNode.setParentId(unflowUUID);
                    String templateName = template.getName();
                    if (Strings.isNotBlank((String)searchKey) && templateName.indexOf(searchKey) == -1) continue;
                    baseNode.setSectionName(templateName);
                    baseNode.setSingleBoardId(fb.getId() + "|" + String.valueOf(template.getId()));
                    baseNode.setSectionBeanId("cap4UnflowQueryResultSection");
                    nodes.add(baseNode);
                }
            }
        }
        if (Strings.isNotBlank((String)searchKey) && nodes.size() == 1) {
            nodes.clear();
        }
        return nodes;
    }

    @Override
    public String[] getSpaceTypes() {
        return this.spaceTypes;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public void setCap4FormManager(CAP4FormManager cap4FormManager) {
        this.cap4FormManager = cap4FormManager;
    }

    public void setCapBizConfigItemManager(CapBizConfigItemManager capBizConfigItemManager) {
        this.capBizConfigItemManager = capBizConfigItemManager;
    }

    public void setBusinessManager4(BusinessManager businessManager4) {
        this.businessManager4 = businessManager4;
    }

    public Integer getSort() {
        return 1;
    }
}

