/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.formlist;

import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.modules.engin.manager.CapFormDefinitionManager;
import com.seeyon.cap4.form.modules.engin.manager.CapFormResourceManager;
import com.seeyon.cap4.form.modules.formlist.CAP4FormListManager;
import com.seeyon.cap4.form.modules.formlist.CAP4WorkflowExportLockManager;
import com.seeyon.cap4.form.po.CAPFormDefinition;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.service.CAP4FormManager;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.form.util.StringUtils;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.ModuleType;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.appLog.AppLogAction;
import com.seeyon.ctp.common.appLog.manager.AppLogManager;
import com.seeyon.ctp.common.authenticate.domain.User;
import com.seeyon.ctp.common.constants.ProductEditionEnum;
import com.seeyon.ctp.common.controller.BaseController;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.po.template.CtpTemplate;
import com.seeyon.ctp.common.po.template.CtpTemplateAuth;
import com.seeyon.ctp.common.po.template.CtpTemplateCategory;
import com.seeyon.ctp.common.taglibs.functions.Functions;
import com.seeyon.ctp.common.template.enums.TemplateEnum;
import com.seeyon.ctp.common.template.manager.ComparatorTemplateBOPub;
import com.seeyon.ctp.common.template.manager.TemplateManager;
import com.seeyon.ctp.common.template.vo.TemplateCategory;
import com.seeyon.ctp.form.modules.engin.manager.FormOwnerManager;
import com.seeyon.ctp.organization.OrgConstants;
import com.seeyon.ctp.organization.manager.OrgManager;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.ReqUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.annotation.CheckRoleAccess;
import com.seeyon.ctp.util.json.JSONUtil;
import com.seeyon.ctp.workflow.wapi.WorkflowApiManager;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.springframework.web.servlet.ModelAndView;

@CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.AccountAdministrator, OrgConstants.Role_NAME.BusinessDesigner})
public class CAP4FormListController
extends BaseController {
    private CAP4FormCacheManager cap4FormCacheManager;
    private CAP4FormListManager cap4FormListManager;
    private TemplateManager templateManager;
    private CAP4FormManager cap4FormManager;
    private WorkflowApiManager wapi;
    private OrgManager orgManager;
    private AppLogManager appLogManager;
    private CAP4WorkflowExportLockManager cap4WorkflowExportLockManager;
    private FormOwnerManager formOwnerManager;
    private CapFormResourceManager capFormResourceManager;
    private CapFormDefinitionManager capFormDefinitionManager;

    public CapFormDefinitionManager getCapFormDefinitionManager() {
        return this.capFormDefinitionManager;
    }

    public void setCapFormDefinitionManager(CapFormDefinitionManager capFormDefinitionManager) {
        this.capFormDefinitionManager = capFormDefinitionManager;
    }

    public CapFormResourceManager getCapFormResourceManager() {
        return this.capFormResourceManager;
    }

    public void setCapFormResourceManager(CapFormResourceManager capFormResourceManager) {
        this.capFormResourceManager = capFormResourceManager;
    }

    public FormOwnerManager getFormOwnerManager() {
        return this.formOwnerManager;
    }

    public void setFormOwnerManager(FormOwnerManager formOwnerManager) {
        this.formOwnerManager = formOwnerManager;
    }

    public ModelAndView index(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView modelAndView = new ModelAndView("cap4/form/design/formListShow");
        String formType = ReqUtil.getString((HttpServletRequest)request, (String)"formType", (String)"9999");
        int type = Integer.parseInt(formType);
        modelAndView.addObject("formType", (Object)type);
        modelAndView.addObject("canCreate", (Object)Enums.FormType.canCreate((int)type));
        List<CtpTemplateCategory> formTemplateCategorys = this.cap4FormManager.getFormCategoryListByMyAccount();
        ArrayList<TemplateCategory> clonedTemplateCategorys = new ArrayList<TemplateCategory>();
        LinkedHashMap<Long, CtpTemplateCategory> categoryMap = new LinkedHashMap<Long, CtpTemplateCategory>();
        for (CtpTemplateCategory tempCategory : formTemplateCategorys) {
            CtpTemplateCategory cloneCategory = (CtpTemplateCategory)tempCategory.clone();
            cloneCategory.setId(tempCategory.getId());
            clonedTemplateCategorys.add(new TemplateCategory(cloneCategory));
            categoryMap.put(cloneCategory.getId(), cloneCategory);
        }
        String childrenStr = "children";
        ArrayList<CtpTemplateCategory> firstLeveCatg = new ArrayList<CtpTemplateCategory>();
        ComparatorTemplateBOPub comparator = new ComparatorTemplateBOPub();
        Collections.sort(clonedTemplateCategorys, comparator);
        for (CtpTemplateCategory ctpTemplateCategory : clonedTemplateCategorys) {
            if (ctpTemplateCategory.getParentId() == null || ctpTemplateCategory.getParentId() == 2L || ctpTemplateCategory.getParentId() == 1L) {
                firstLeveCatg.add(ctpTemplateCategory);
                continue;
            }
            CtpTemplateCategory ctpTemplateCategory2 = (CtpTemplateCategory)categoryMap.get(ctpTemplateCategory.getParentId());
            if (ctpTemplateCategory2 == null) {
                firstLeveCatg.add(ctpTemplateCategory);
                continue;
            }
            ArrayList<CtpTemplateCategory> children = (ArrayList<CtpTemplateCategory>)ctpTemplateCategory2.getExtraAttr(childrenStr);
            if (children == null) {
                children = new ArrayList<CtpTemplateCategory>();
            }
            children.add(ctpTemplateCategory);
            ctpTemplateCategory2.putExtraAttr(childrenStr, children);
        }
        ArrayList<TemplateCategory> templateCategories = new ArrayList<TemplateCategory>(clonedTemplateCategorys.size());
        for (CtpTemplateCategory ctpTemplateCategory : firstLeveCatg) {
            templateCategories.add(new TemplateCategory(ctpTemplateCategory));
            templateCategories.addAll(this.getSubCatg4Show(ctpTemplateCategory, 3, childrenStr));
        }
        modelAndView.addObject("formTemplateCategorysJson", (Object)JSONUtil.toJSONString(templateCategories));
        modelAndView.addObject("catgs", templateCategories);
        String string = ReqUtil.getString((HttpServletRequest)request, (String)"property", (String)"customerForm");
        modelAndView.addObject("property", (Object)string);
        modelAndView.addObject("isAdmin", (Object)AppContext.isAdministrator());
        if ("accountForm".equals(string)) {
            if (!AppContext.isAdministrator()) {
                super.rendJavaScript(response, "alert('" + ResourceUtil.getString((String)"bizconfig.use.authorize.forbidden") + "');window.close()");
            }
            List list = this.orgManager.getMembersByRole(Long.valueOf(AppContext.currentAccountId()), OrgConstants.Role_NAME.FormAdmin.name());
            modelAndView.addObject("formAdmin", (Object)list);
            modelAndView.addObject("formAdminJson", (Object)JSONUtil.toJSONString((Object)list));
            request.setAttribute("fftree", this.cap4FormListManager.getFormCategoryListByMyAccount(null));
        } else if ("customerForm".equals(string)) {
            modelAndView.addObject("formId", (Object)ReqUtil.getLong((HttpServletRequest)request, (String)"formId", (long)-1L));
            modelAndView.addObject("ownerId", (Object)ReqUtil.getLong((HttpServletRequest)request, (String)"ownerId", (long)-1L));
            modelAndView.addObject("categoryId", (Object)ReqUtil.getLong((HttpServletRequest)request, (String)"categoryId", (long)-1L));
            modelAndView.addObject("state", (Object)ReqUtil.getString((HttpServletRequest)request, (String)"state", (String)"9999"));
            modelAndView.addObject("useFlag", (Object)ReqUtil.getString((HttpServletRequest)request, (String)"useFlag", (String)"9999"));
            modelAndView.addObject("name", (Object)ReqUtil.getString((HttpServletRequest)request, (String)"name", (String)""));
            modelAndView.addObject("orgAccountId", (Object)ReqUtil.getLong((HttpServletRequest)request, (String)"orgAccountId", (long)-1L));
        }
        boolean bl = ProductEditionEnum.getCurrentProductEditionEnum().getValue().equals(ProductEditionEnum.a6.getValue());
        boolean isA6s = ProductEditionEnum.getCurrentProductEditionEnum().getValue().equals(ProductEditionEnum.a6s.getValue());
        boolean notShowDataSet = bl || isA6s || !AppContext.hasPlugin((String)"seeyonreport");
        modelAndView.addObject("notShowDataSet", (Object)notShowDataSet);
        modelAndView.addObject("isAdvanced", (Object)AppContext.hasPlugin((String)"formAdvanced"));
        modelAndView.addObject("currentUserId", (Object)AppContext.currentUserId());
        return modelAndView;
    }

    private List<TemplateCategory> getSubCatg4Show(CtpTemplateCategory parent, int spaceNum, String extName) {
        ArrayList<TemplateCategory> subCatg = new ArrayList<TemplateCategory>();
        List children = (List)parent.getExtraAttr(extName);
        if (Strings.isNotEmpty((Collection)children)) {
            for (CtpTemplateCategory category : children) {
                category.setName(StringUtils.space((int)spaceNum) + category.getName());
                subCatg.add(new TemplateCategory(category));
                subCatg.addAll(this.getSubCatg4Show(category, spaceNum + 3, extName));
            }
        }
        return subCatg;
    }

    public ModelAndView deleteForm(HttpServletRequest request, HttpServletResponse response) throws BusinessException {
        String id1 = ReqUtil.getString((HttpServletRequest)request, (String)"id");
        if (id1.indexOf(",") > -1) {
            int i;
            ArrayList<CAPFormDefinition> list = new ArrayList<CAPFormDefinition>();
            String[] id = id1.split(",");
            String[] label = new String[2];
            User user = AppContext.getCurrentUser();
            ArrayList<String[]> labelsList = new ArrayList<String[]>();
            for (i = 0; i < id.length; ++i) {
                this.formOwnerManager.deleteOwnerByFormId(Long.valueOf(id[i]).longValue());
                this.capFormResourceManager.deleteByFormId(Long.valueOf(id[i]));
                list.add(this.capFormDefinitionManager.selectById(Long.valueOf(id[i])));
                label = new String[]{user.getName(), this.cap4FormManager.getForm(Long.valueOf(id[i])).getFormName()};
                labelsList.add(label);
            }
            this.capFormDefinitionManager.delete(list);
            this.appLogManager.insertLogs(user, AppLogAction.Form_Delete, labelsList);
            for (i = 0; i < id.length; ++i) {
                this.cap4FormCacheManager.removeFormBean(Long.valueOf(id[i]));
                List templateList = this.templateManager.getCtpTemplates(Long.valueOf(id[i]).longValue(), false);
                if (templateList == null) continue;
                for (CtpTemplate c : templateList) {
                    this.templateManager.deleteCtpTemplate(c.getId());
                    List authList = this.templateManager.getCtpTemplateAuths(c.getId(), Integer.valueOf(ModuleType.collaboration.getKey()));
                    if (authList != null) {
                        for (CtpTemplateAuth auth : authList) {
                            this.templateManager.deleteCtpTemplateAuth(auth);
                        }
                    }
                    this.wapi.deleteWorkflowTemplate(c.getWorkflowId().longValue());
                }
            }
        } else {
            String formName = this.cap4FormManager.getForm(Long.valueOf(id1)).getFormName();
            this.capFormDefinitionManager.delete(this.capFormDefinitionManager.selectById(Long.valueOf(id1)));
            this.formOwnerManager.deleteOwnerByFormId(Long.valueOf(id1).longValue());
            this.capFormResourceManager.deleteByFormId(Long.valueOf(id1));
            this.cap4FormCacheManager.removeFormBean(Long.valueOf(id1));
            List templateList = this.templateManager.getCtpTemplates(Long.valueOf(id1).longValue(), false);
            if (templateList != null) {
                for (CtpTemplate c : templateList) {
                    this.templateManager.deleteCtpTemplate(c.getId());
                    List authList = this.templateManager.getCtpTemplateAuths(c.getId(), Integer.valueOf(ModuleType.collaboration.getKey()));
                    if (authList != null) {
                        for (CtpTemplateAuth auth : authList) {
                            this.templateManager.deleteCtpTemplateAuth(auth);
                        }
                    }
                    this.wapi.deleteWorkflowTemplate(c.getWorkflowId().longValue());
                }
            }
            this.appLogManager.insertLog(AppContext.getCurrentUser(), AppLogAction.Form_Delete, new String[]{AppContext.currentUserName(), formName});
        }
        return null;
    }

    public ModelAndView releaseForm(HttpServletRequest request, HttpServletResponse response) throws BusinessException {
        String id1 = ReqUtil.getString((HttpServletRequest)request, (String)"id");
        if (id1.contains(",")) {
            ArrayList<String[]> labelsList = new ArrayList<String[]>();
            String[] label = new String[2];
            User user = AppContext.getCurrentUser();
            String[] id = id1.split(",");
            for (int i = 0; i < id.length; ++i) {
                CAPFormDefinition fd = this.capFormDefinitionManager.selectById(Long.valueOf(id[i]));
                fd.setState(Integer.valueOf(Enums.FormStateEnum.official.getKey()));
                this.capFormDefinitionManager.update(fd);
                label = new String[]{user.getName(), this.cap4FormManager.getForm(Long.valueOf(id[i])).getFormName()};
                labelsList.add(label);
            }
            this.appLogManager.insertLogs(AppContext.getCurrentUser(), AppLogAction.Form_Publish, labelsList);
            for (int i = 0; i < id.length; ++i) {
                FormBean fb = this.cap4FormCacheManager.getForm(Long.valueOf(id[i]));
                fb.setState(Enums.FormStateEnum.official.getKey());
                this.cap4FormCacheManager.addFormBean(Long.valueOf(id[i]), fb);
                this.templateManager.updateTemplates(fb.getId(), TemplateEnum.State.normal);
            }
        } else {
            CAPFormDefinition fd = this.capFormDefinitionManager.selectById(Long.valueOf(id1));
            fd.setState(Integer.valueOf(Enums.FormStateEnum.official.getKey()));
            this.capFormDefinitionManager.update(fd);
            FormBean fb = this.cap4FormCacheManager.getForm(Long.valueOf(id1));
            fb.setState(Enums.FormStateEnum.official.getKey());
            this.templateManager.updateTemplates(fb.getId(), TemplateEnum.State.normal);
            this.cap4FormCacheManager.addFormBean(Long.valueOf(id1), fb);
            this.appLogManager.insertLog(AppContext.getCurrentUser(), AppLogAction.Form_Publish, new String[]{AppContext.currentUserName(), fb.getFormName()});
        }
        return null;
    }

    public ModelAndView disableForm(HttpServletRequest request, HttpServletResponse response) throws BusinessException {
        String id1 = ReqUtil.getString((HttpServletRequest)request, (String)"id");
        if (id1.contains(",")) {
            int i;
            ArrayList<String[]> labelsList = new ArrayList<String[]>();
            String[] label = new String[2];
            User user = AppContext.getCurrentUser();
            ArrayList list = new ArrayList();
            String[] id = id1.split(",");
            for (i = 0; i < id.length; ++i) {
                CAPFormDefinition fd = this.capFormDefinitionManager.selectById(Long.valueOf(id[i]));
                fd.setUseFlag(Integer.valueOf(Enums.FormUseFlagEnum.disabled.getKey()));
                this.capFormDefinitionManager.update(fd);
                label = new String[]{user.getName(), this.cap4FormManager.getForm(Long.valueOf(id[i])).getFormName()};
                labelsList.add(label);
            }
            this.appLogManager.insertLogs(AppContext.getCurrentUser(), AppLogAction.Form_Stop, labelsList);
            for (i = 0; i < id.length; ++i) {
                FormBean fb = this.cap4FormCacheManager.getForm(Long.valueOf(id[i]));
                fb.setUseFlag(Enums.FormUseFlagEnum.disabled.getKey());
                this.cap4FormCacheManager.addFormBean(Long.valueOf(id[i]), fb);
                if (fb.getFormType() != Enums.FormType.processesForm.getKey()) continue;
                this.templateManager.updateTemplates(fb.getId(), TemplateEnum.State.invalidation);
            }
        } else {
            CAPFormDefinition fd = this.capFormDefinitionManager.selectById(Long.valueOf(id1));
            fd.setUseFlag(Integer.valueOf(Enums.FormUseFlagEnum.disabled.getKey()));
            this.capFormDefinitionManager.update(fd);
            FormBean fb = this.cap4FormCacheManager.getForm(Long.valueOf(id1));
            fb.setUseFlag(Enums.FormUseFlagEnum.disabled.getKey());
            if (fb.getFormType() == Enums.FormType.processesForm.getKey()) {
                this.templateManager.updateTemplates(fb.getId(), TemplateEnum.State.invalidation);
            }
            this.cap4FormCacheManager.addFormBean(Long.valueOf(id1), fb);
            this.appLogManager.insertLog(AppContext.getCurrentUser(), AppLogAction.Form_Stop, new String[]{AppContext.currentUserName(), fb.getFormName()});
        }
        return null;
    }

    public ModelAndView ableForm(HttpServletRequest request, HttpServletResponse response) throws BusinessException {
        String id1 = ReqUtil.getString((HttpServletRequest)request, (String)"id");
        if (id1.contains(",")) {
            int i;
            ArrayList<String[]> labelsList = new ArrayList<String[]>();
            String[] label = new String[2];
            User user = AppContext.getCurrentUser();
            ArrayList list = new ArrayList();
            String[] id = id1.split(",");
            for (i = 0; i < id.length; ++i) {
                CAPFormDefinition fd = this.capFormDefinitionManager.selectById(Long.valueOf(id[i]));
                fd.setUseFlag(Integer.valueOf(Enums.FormUseFlagEnum.enabled.getKey()));
                this.capFormDefinitionManager.update(fd);
                label = new String[]{user.getName(), this.cap4FormManager.getForm(Long.valueOf(id[i])).getFormName()};
                labelsList.add(label);
            }
            this.appLogManager.insertLogs(AppContext.getCurrentUser(), AppLogAction.Form_Start, labelsList);
            for (i = 0; i < id.length; ++i) {
                FormBean fb = this.cap4FormCacheManager.getForm(Long.valueOf(id[i]));
                fb.setUseFlag(Enums.FormUseFlagEnum.enabled.getKey());
                this.cap4FormCacheManager.addFormBean(Long.valueOf(id[i]), fb);
                this.appLogManager.insertLog(AppContext.getCurrentUser(), AppLogAction.Form_Start, new String[]{AppContext.currentUserName(), fb.getFormName()});
                if (fb.getFormType() != Enums.FormType.processesForm.getKey()) continue;
                this.templateManager.updateTemplates(fb.getId(), TemplateEnum.State.normal);
            }
        } else {
            CAPFormDefinition fd = this.capFormDefinitionManager.selectById(Long.valueOf(id1));
            fd.setUseFlag(Integer.valueOf(Enums.FormUseFlagEnum.enabled.getKey()));
            this.capFormDefinitionManager.update(fd);
            FormBean fb = this.cap4FormCacheManager.getForm(Long.valueOf(id1));
            fb.setUseFlag(Enums.FormUseFlagEnum.enabled.getKey());
            if (fb.getFormType() == Enums.FormType.processesForm.getKey()) {
                this.templateManager.updateTemplates(fb.getId(), TemplateEnum.State.normal);
            }
            this.cap4FormCacheManager.addFormBean(Long.valueOf(id1), fb);
            this.appLogManager.insertLog(AppContext.getCurrentUser(), AppLogAction.Form_Start, new String[]{AppContext.currentUserName(), fb.getFormName()});
        }
        return null;
    }

    public ModelAndView helpInfo(HttpServletRequest request, HttpServletResponse response) throws BusinessException {
        String formTypeValue;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("property", ReqUtil.getString((HttpServletRequest)request, (String)"property", (String)"myForm"));
        int size = request.getParameter("size") == null ? -1 : ReqUtil.getInt((HttpServletRequest)request, (String)"size");
        String title = "";
        if (("" + Enums.FormType.processesForm.getKey()).equals(request.getParameter("formType"))) {
            title = Enums.FormType.processesForm.getValue();
        } else if (("" + Enums.FormType.unFlowForm.getKey()).equals(request.getParameter("formType"))) {
            title = Enums.FormType.unFlowForm.getValue();
        }
        if (!"accountForm".equals(map.get("property"))) {
            map.put("formtype", request.getParameter("formType"));
        }
        ModelAndView modelAndView = new ModelAndView("cap4/form/design/helpinfo");
        String string = formTypeValue = map.get("formtype") == null ? "" : map.get("formtype").toString();
        if (!Strings.isDigits((String)formTypeValue)) {
            formTypeValue = "9999";
        }
        modelAndView.addObject("formtype", (Object)formTypeValue);
        modelAndView.addObject("title", (Object)title);
        modelAndView.addObject("size", (Object)size);
        return modelAndView;
    }

    public ModelAndView showUnflowTemplate(HttpServletRequest request, HttpServletResponse response) throws BusinessException {
        ModelAndView modelAndView = new ModelAndView("cap4/form/design/showUnflowTemplate");
        Long formId = ReqUtil.getLong((HttpServletRequest)request, (String)"formId", (long)-1L);
        FormBean fb = this.cap4FormManager.getForm(formId);
        if (fb != null) {
            if (fb.getFormType() == Enums.FormType.unFlowForm.getKey()) {
                Map templateMap = fb.getBind().getUnFlowTemplateMap();
                ArrayList templateList = new ArrayList();
                for (Map.Entry formBindEntry : templateMap.entrySet()) {
                    templateList.add(formBindEntry.getValue());
                }
                modelAndView.addObject("templateList", templateList);
            }
            modelAndView.addObject("formtype", (Object)fb.getFormType());
        }
        return modelAndView;
    }

    public ModelAndView showFlowTemplate(HttpServletRequest request, HttpServletResponse response) throws BusinessException, CloneNotSupportedException {
        ModelAndView modelAndView = new ModelAndView("cap4/form/design/showFlowTemplate");
        modelAndView.addObject("formId", (Object)ReqUtil.getLong((HttpServletRequest)request, (String)"formId", (long)0L));
        modelAndView.addObject("notTemplateId", (Object)ReqUtil.getLong((HttpServletRequest)request, (String)"notTemplateId", (long)0L));
        modelAndView.addObject("ownerId", (Object)ReqUtil.getLong((HttpServletRequest)request, (String)"ownerId"));
        modelAndView.addObject("canSelect", (Object)ReqUtil.getString((HttpServletRequest)request, (String)"canSelect", (String)"false"));
        List<CtpTemplateCategory> formTemplateCategorys = this.cap4FormManager.getFormCategoryListByMyAccount();
        ArrayList<CtpTemplateCategory> clonedTemplateCategorys = new ArrayList<CtpTemplateCategory>();
        for (CtpTemplateCategory ctpTemplateCategory : formTemplateCategorys) {
            CtpTemplateCategory cloneCategory = (CtpTemplateCategory)ctpTemplateCategory.clone();
            cloneCategory.setId(ctpTemplateCategory.getId());
            clonedTemplateCategorys.add(cloneCategory);
        }
        for (CtpTemplateCategory ctpTemplateCategory : clonedTemplateCategorys) {
            if (ctpTemplateCategory.getParentId() != null) continue;
            ArrayList<CtpTemplateCategory> childrens = (ArrayList<CtpTemplateCategory>)ctpTemplateCategory.getExtraAttr("childrens");
            for (CtpTemplateCategory children : clonedTemplateCategorys) {
                Long pid = children.getParentId();
                if (pid == null || pid.longValue() != ctpTemplateCategory.getId().longValue()) continue;
                if (childrens == null) {
                    childrens = new ArrayList<CtpTemplateCategory>();
                }
                childrens.add(children);
            }
            ctpTemplateCategory.putExtraAttr("childrens", (List)childrens);
        }
        ArrayList<TemplateCategory> templateCategories = new ArrayList<TemplateCategory>(clonedTemplateCategorys.size());
        for (CtpTemplateCategory category : clonedTemplateCategorys) {
            templateCategories.add(new TemplateCategory(category));
        }
        ComparatorTemplateBOPub comparatorTemplateBOPub = new ComparatorTemplateBOPub();
        Collections.sort(templateCategories, comparatorTemplateBOPub);
        modelAndView.addObject("formTemplateCategorys", templateCategories);
        return modelAndView;
    }

    public ModelAndView modifyTemplateCategory(HttpServletRequest request, HttpServletResponse response) throws BusinessException, CloneNotSupportedException {
        TemplateManager templateManager;
        CtpTemplateCategory editCtc;
        ModelAndView modelAndView = new ModelAndView("cap4/form/design/modifyTemplateCategory");
        String oprateType = ReqUtil.getString((HttpServletRequest)request, (String)"oprateType", (String)"");
        Long id = ReqUtil.getLong((HttpServletRequest)request, (String)"id", (long)-1L);
        Long parentId = -1L;
        if ("new".equals(oprateType)) {
            parentId = id;
            modelAndView.addObject("categoryAuth", (Object)AppContext.getCurrentUser().getId());
        } else if ("edit".equals(oprateType) && (editCtc = (templateManager = (TemplateManager)AppContext.getBean((String)"templateManager")).getCtpTemplateCategory(id)) != null) {
            List authList = templateManager.getCtpTemplateAuths(editCtc.getId(), Integer.valueOf(ModuleType.collaboration.getKey()));
            authList.addAll(templateManager.getCtpTemplateAuths(editCtc.getId(), Integer.valueOf(-1)));
            parentId = editCtc.getParentId();
            modelAndView.addObject("id", (Object)id);
            modelAndView.addObject("name", (Object)Strings.toHTML((String)editCtc.getName()));
            modelAndView.addObject("sort", (Object)editCtc.getSort());
            modelAndView.addObject("description", (Object)editCtc.getDescription());
            StringBuilder ids = new StringBuilder("");
            if (Strings.isNotEmpty((Collection)authList)) {
                for (CtpTemplateAuth moduleAuth : authList) {
                    ids.append(moduleAuth.getAuthType()).append("|").append(moduleAuth.getAuthId()).append("|").append(",");
                }
                ids = new StringBuilder(ids.substring(0, ids.toString().length() - 1));
            }
            modelAndView.addObject("categoryAuth", (Object)ids.toString());
        }
        Long notNeedId = "edit".equals(oprateType) ? id : null;
        modelAndView.addObject("formTemplateCategorys", (Object)this.cap4FormManager.getCategory2HTML(AppContext.currentAccountId(), notNeedId, true).toString());
        modelAndView.addObject("parentId", (Object)parentId);
        modelAndView.addObject("categoryType", (Object)ReqUtil.getString((HttpServletRequest)request, (String)"categoryType", (String)""));
        return modelAndView;
    }

    public ModelAndView showDownloadPage(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ModelAndView modelAndView = new ModelAndView("ctp/form/common/showDownloadPage");
        Long userId = AppContext.currentUserId();
        String fileName = this.getFileName();
        if (!this.cap4WorkflowExportLockManager.isLock((long)userId)) {
            if (Strings.isNotBlank((String)fileName)) {
                modelAndView.addObject("url", (Object)(SystemEnvironment.getContextPath() + "/cap4/formList.do?method=doDownload&userId=" + userId + "&fileName=" + fileName + Functions.csrfSuffix()));
            }
            modelAndView.addObject("state", (Object)true);
        } else {
            modelAndView.addObject("state", (Object)false);
        }
        if (Strings.isBlank((String)fileName)) {
            fileName = "\u6d41\u7a0b\u56fe_" + DateUtil.getDate((String)"yyyy-MM-dd") + ".zip";
        }
        modelAndView.addObject("fileName", (Object)fileName);
        return modelAndView;
    }

    private String getFileName() {
        File file;
        File[] list;
        Long userId = AppContext.currentUserId();
        String tempFolder = new File(new File("").getAbsolutePath()).getParentFile().getParentFile().getPath();
        tempFolder = tempFolder + "/base/upload/workflow_export/" + userId + "/zip";
        File zipFile = new File(tempFolder);
        String fileName = "";
        if (zipFile.exists() && (list = zipFile.listFiles()).length > 0 && (file = list[0]) != null && file.exists()) {
            fileName = file.getName();
        }
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModelAndView doDownload(HttpServletRequest request, HttpServletResponse response) throws Exception {
        block8: {
            String fileName = this.getFileName();
            if (Strings.isBlank((String)fileName)) {
                fileName = "\u6d41\u7a0b\u56fe_" + DateUtil.getDate((String)"yyyy-MM-dd") + ".zip";
            }
            fileName = URLEncoder.encode(fileName, "UTF-8");
            String charset = "UTF-8";
            response.setContentType("application/octet-stream; charset=" + charset);
            response.setCharacterEncoding(charset);
            response.setHeader("Content-disposition", "attachment;filename=\"" + fileName + "\"");
            ServletOutputStream outStream = response.getOutputStream();
            BufferedInputStream bf = null;
            try {
                File file;
                File[] list;
                Long userId = AppContext.currentUserId();
                String tempFolder = new File(new File("").getAbsolutePath()).getParentFile().getParentFile().getPath();
                tempFolder = tempFolder + "/base/upload/workflow_export/" + userId + "/zip";
                File zipFile = new File(tempFolder);
                String tempFile = null;
                if (zipFile.exists() && (list = zipFile.listFiles()).length > 0 && (file = list[0]) != null && file.exists()) {
                    tempFile = file.getAbsolutePath();
                }
                bf = new BufferedInputStream(new FileInputStream(tempFile));
                int length = 1024;
                byte[] b = new byte[length];
                int off = 0;
                while ((length = bf.read(b, off, length)) >= 0) {
                    outStream.write(b);
                }
                outStream.flush();
                outStream.close();
                IOUtils.closeQuietly((OutputStream)outStream);
            }
            catch (Exception e) {
                this.logger.error((Object)"\u4e0b\u8f7d\u9644\u4ef6\u5f02\u5e38", (Throwable)e);
                break block8;
            }
            finally {
                IOUtils.closeQuietly((OutputStream)outStream);
                IOUtils.closeQuietly(bf);
            }
            IOUtils.closeQuietly((InputStream)bf);
        }
        return null;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public CAP4FormListManager getCap4FormListManager() {
        return this.cap4FormListManager;
    }

    public void setCap4FormListManager(CAP4FormListManager cap4FormListManager) {
        this.cap4FormListManager = cap4FormListManager;
    }

    public TemplateManager getTemplateManager() {
        return this.templateManager;
    }

    public void setTemplateManager(TemplateManager templateManager) {
        this.templateManager = templateManager;
    }

    public WorkflowApiManager getWapi() {
        return this.wapi;
    }

    public void setWapi(WorkflowApiManager wapi) {
        this.wapi = wapi;
    }

    public CAP4FormManager getCap4FormManager() {
        return this.cap4FormManager;
    }

    public void setCap4FormManager(CAP4FormManager cap4FormManager) {
        this.cap4FormManager = cap4FormManager;
    }

    public OrgManager getOrgManager() {
        return this.orgManager;
    }

    public void setOrgManager(OrgManager orgManager) {
        this.orgManager = orgManager;
    }

    public AppLogManager getAppLogManager() {
        return this.appLogManager;
    }

    public void setAppLogManager(AppLogManager appLogManager) {
        this.appLogManager = appLogManager;
    }

    public void setCap4WorkflowExportLockManager(CAP4WorkflowExportLockManager cap4WorkflowExportLockManager) {
        this.cap4WorkflowExportLockManager = cap4WorkflowExportLockManager;
    }
}

