/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.formlist;

import com.seeyon.apps.seeyonreport.api.SeeyonreportApi;
import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormBindAuthBean;
import com.seeyon.cap4.form.bean.FormBindBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormTableBean;
import com.seeyon.cap4.form.modules.business.BusinessManager;
import com.seeyon.cap4.form.modules.component.ComparatorCtpTemplate;
import com.seeyon.cap4.form.modules.engin.bind.CAP4FormBindDesignManager;
import com.seeyon.cap4.form.modules.engin.design.CAP4FormDesignManager;
import com.seeyon.cap4.form.modules.engin.formula.FormulaFunctionUitl;
import com.seeyon.cap4.form.modules.engin.trigger.FormTriggerUtil;
import com.seeyon.cap4.form.modules.event.FormDelete4WorkflowEvent;
import com.seeyon.cap4.form.modules.formlist.CAP4FormListManager;
import com.seeyon.cap4.form.modules.formlist.CAP4WorkFlowExport;
import com.seeyon.cap4.form.modules.formlist.CAP4WorkflowExportLockManager;
import com.seeyon.cap4.form.modules.importandexport.BusinessEnums;
import com.seeyon.cap4.form.modules.importandexport.BusinessImportAndExportManager;
import com.seeyon.cap4.form.modules.log.CapRunningLogManager;
import com.seeyon.cap4.form.modules.serialNumber.CAP4SerialNumberManager;
import com.seeyon.cap4.form.po.CAPFormDefinition;
import com.seeyon.cap4.form.service.CAP4FormCache;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.service.CAP4FormManager;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.form.util.FormUtil;
import com.seeyon.cap4.form.util.StringUtils;
import com.seeyon.cap4.form.util.TreeNodeUtil;
import com.seeyon.cap4.form.vo.FormTreeNode;
import com.seeyon.cap4.magic.manager.ICAP4MagicManager;
import com.seeyon.cap4.validity.ValidityUtil;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.ModuleType;
import com.seeyon.ctp.common.appLog.AppLogAction;
import com.seeyon.ctp.common.appLog.manager.AppLogManager;
import com.seeyon.ctp.common.authenticate.domain.User;
import com.seeyon.ctp.common.constants.ApplicationCategoryEnum;
import com.seeyon.ctp.common.content.mainbody.MainbodyManager;
import com.seeyon.ctp.common.ctpenumnew.manager.EnumManager;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.filemanager.manager.FileManager;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.supervise.CtpSuperviseDetail;
import com.seeyon.ctp.common.po.supervise.CtpSuperviseTemplateRole;
import com.seeyon.ctp.common.po.supervise.CtpSupervisor;
import com.seeyon.ctp.common.po.template.CtpTemplate;
import com.seeyon.ctp.common.po.template.CtpTemplateAuth;
import com.seeyon.ctp.common.po.template.CtpTemplateCategory;
import com.seeyon.ctp.common.quartz.QuartzHolder;
import com.seeyon.ctp.common.supervise.manager.SuperviseManager;
import com.seeyon.ctp.common.taglibs.functions.Functions;
import com.seeyon.ctp.common.template.enums.TemplateEnum;
import com.seeyon.ctp.common.template.manager.ComparatorTemplateBOPub;
import com.seeyon.ctp.common.template.manager.TemplateManager;
import com.seeyon.ctp.common.template.vo.TemplateCategory;
import com.seeyon.ctp.event.Event;
import com.seeyon.ctp.event.EventDispatcher;
import com.seeyon.ctp.form.bean.FormSerialNumberBean;
import com.seeyon.ctp.form.modules.serialNumber.SerialNumberManager;
import com.seeyon.ctp.form.po.FormOwner;
import com.seeyon.ctp.form.service.FormCacheManager;
import com.seeyon.ctp.organization.OrgConstants;
import com.seeyon.ctp.organization.bo.V3xOrgAccount;
import com.seeyon.ctp.organization.bo.V3xOrgMember;
import com.seeyon.ctp.organization.manager.OrgManager;
import com.seeyon.ctp.privilege.manager.MenuCacheManager;
import com.seeyon.ctp.report.engine.api.manager.ReportApi;
import com.seeyon.ctp.util.CommonTools;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.JDBCAgent;
import com.seeyon.ctp.util.ParamUtil;
import com.seeyon.ctp.util.StringUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.annotation.AjaxAccess;
import com.seeyon.ctp.util.annotation.CheckRoleAccess;
import com.seeyon.ctp.workflow.wapi.WorkflowApiManager;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.collections.map.LinkedMap;
import org.apache.commons.logging.Log;
import org.dom4j.Element;
import www.seeyon.com.biz.enums.BizOperationEnum;

public class CAP4FormListManagerImpl
implements CAP4FormListManager {
    private static final Log logger = CtpLogFactory.getLog(CAP4FormListManagerImpl.class);
    private CAP4FormCacheManager cap4FormCacheManager;
    private FormCacheManager formCacheManager;
    private FileManager fileManager;
    private CAP4FormManager cap4FormManager;
    private TemplateManager templateManager;
    private SuperviseManager superviseManager;
    private OrgManager orgManager;
    private AppLogManager appLogManager;
    private WorkflowApiManager wapi;
    private EnumManager enumManagerNew;
    private SerialNumberManager serialNumberManager;
    private CAP4SerialNumberManager cap4SerialNumberManager;
    private CAP4FormBindDesignManager cap4FormBindDesignManager;
    private MenuCacheManager menuCacheManager;
    private SeeyonreportApi seeyonreportApi;
    private CAP4FormDesignManager cap4FormDesignManager;
    private BusinessImportAndExportManager businessImportAndExportManager;
    private ICAP4MagicManager cap4MagicManager;
    private BusinessManager businessManager4;
    private CapRunningLogManager capRunningLogManager;
    Pattern getSeriaNumFormulaPattern = Pattern.compile("serialNumber\\s*\\(\\s*('|\")([^'\"]*)('|\")\\s*\\)");
    private CAP4WorkflowExportLockManager cap4WorkflowExportLockManager;

    public void setFormCacheManager(FormCacheManager formCacheManager) {
        this.formCacheManager = formCacheManager;
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner, OrgConstants.Role_NAME.AccountAdministrator})
    public FlipInfo showFormList(FlipInfo fi, Map<String, Object> params) throws BusinessException {
        if (params == null) {
            params = new HashMap<String, Object>();
        }
        if (params.containsKey("formid")) {
            params.put("formid", CommonTools.parseStr2Ids((String)ParamUtil.getString(params, (String)"formid")));
        }
        Long owners = AppContext.currentUserId();
        params.put("ownerId", owners);
        params.put("orgAccountId", AppContext.currentAccountId());
        this.getStatusByCap4State(params);
        List<Map<String, Object>> listMap = this.cap4FormCacheManager.getCap4FormDefinitionDAO().showFormList(fi, params);
        for (Map<String, Object> map : listMap) {
            int state = ParamUtil.getInt(map, (String)"state");
            int publishFlag = ParamUtil.getInt(map, (String)"publishFlag", (int)0);
            int useFlag = ParamUtil.getInt(map, (String)"useFlag");
            map.put("formTypeName", Enums.FormType.getEnumByKey((int)ParamUtil.getInt(map, (String)"formType")).getValue());
            map.put("state", state);
            map.put("useFlag", useFlag);
            map.put("useFlagText", Enums.FormUseFlagEnum.getEnumByKey((int)useFlag).getText());
            map.put("publishFlag", publishFlag);
            map.put("publishFlagText", Enums.FormPublishFlagEnum.getEnumByKey((int)publishFlag).getText());
            map.put("createTime", DateUtil.formatDateTime((Date)((Date)map.get("createTime"))));
            map.put("authto", ValidityUtil.getMplusCorpName());
            String categoryName = ParamUtil.getString(map, (String)"cataName");
            if (Strings.isNotEmpty((String)categoryName)) {
                String i18nName = ResourceUtil.getString((String)categoryName);
                if (Strings.isNotEmpty((String)i18nName)) {
                    categoryName = i18nName;
                }
                map.put("cataName", categoryName);
            }
            if (map.get("modifyTime") == null) {
                map.put("modifyTime", DateUtil.toDate((String)map.get("createTime").toString()));
            } else {
                map.put("modifyTime", DateUtil.formatDateTime((Date)((Date)map.get("modifyTime"))));
            }
            if (this.orgManager != null) {
                try {
                    V3xOrgMember member = this.orgManager.getMemberById(ParamUtil.getLong(map, (String)"ownerId"));
                    if (member != null) {
                        map.put("ownerName", member.getName());
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }
            Long formId = ParamUtil.getLong(map, (String)"id");
            FormBean fb = this.cap4FormCacheManager.getForm(formId);
            map.put("sourceType", ResourceUtil.getString((String)BusinessEnums.FormAttribute.NORMAL.getText()));
            map.put("goods", BusinessEnums.FormAttribute.NORMAL.getKey());
            if (fb == null) {
                logger.error((Object)("\u8868\u5355:" + formId + "\u5728\u7f13\u5b58\u4e2d\u627e\u4e0d\u5230\u6570\u636e"));
                this.cap4FormCacheManager.initForm(formId);
                fb = this.cap4FormCacheManager.getForm(formId);
                if (fb == null) {
                    logger.error((Object)("\u8868\u5355:" + formId + "\u91cd\u65b0\u521d\u59cb\u5316\u4e4b\u540e\u5728\u7f13\u5b58\u4e2d\u8fd8\u662f\u627e\u4e0d\u5230\u6570\u636e"));
                }
            } else {
                BusinessEnums.FormAttribute formAttribute = fb.getFormAttribute();
                if (null == formAttribute) {
                    formAttribute = BusinessEnums.FormAttribute.NORMAL;
                }
                map.put("sourceType", ResourceUtil.getString((String)formAttribute.getText()));
                map.put("goods", formAttribute.getKey());
            }
            CtpTemplateCategory ctc = this.templateManager.getCtpTemplateCategory(ParamUtil.getLong(map, (String)"categoryId"));
            map.put("categoryId", this.getCatgName(ctc));
        }
        fi.setData(listMap);
        return fi;
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner, OrgConstants.Role_NAME.AccountAdministrator})
    public Map<String, Object> initFormMgrInfo() throws Exception {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        returnMap.put("catgs", this.cap4FormDesignManager.getFormTemplateCategorys());
        returnMap.put("isAdmin", AppContext.isAdministrator());
        HashMap<Integer, String> formState = new HashMap<Integer, String>();
        for (Enums.FormPublishFlagEnum formPublishFlagEnum : Enums.FormPublishFlagEnum.values()) {
            formState.put(formPublishFlagEnum.getKey(), formPublishFlagEnum.getText());
        }
        returnMap.put("publishFlag", formState);
        HashMap<Integer, String> formUseFlag = new HashMap<Integer, String>();
        formUseFlag.put(Enums.FormUseFlagEnum.disabled.getKey(), Enums.FormUseFlagEnum.disabled.getText());
        formUseFlag.put(Enums.FormUseFlagEnum.enabled.getKey(), Enums.FormUseFlagEnum.enabled.getText());
        returnMap.put("useFlag", formUseFlag);
        return returnMap;
    }

    private List<TemplateCategory> getSubCatg4Show(CtpTemplateCategory parent, int spaceNum, String extName) {
        ArrayList<TemplateCategory> subCatg = new ArrayList<TemplateCategory>();
        List children = (List)parent.getExtraAttr(extName);
        if (Strings.isNotEmpty((Collection)children)) {
            for (CtpTemplateCategory category : children) {
                category.setName(StringUtils.space((int)spaceNum) + category.getName());
                subCatg.add(new TemplateCategory(category));
                subCatg.addAll(this.getSubCatg4Show(category, spaceNum + 3, extName));
            }
        }
        return subCatg;
    }

    private int getCap4State(int state, int useFlag) {
        if (useFlag == Enums.FormUseFlagEnum.disabled.getKey()) {
            return useFlag;
        }
        if (state == Enums.FormStateEnum.official.getKey()) {
            return state;
        }
        return Enums.Cap4FormDisPlayStateEnum.unpublished.getKey();
    }

    private void getStatusByCap4State(Map<String, Object> map) {
        if (map != null) {
            if (map.containsKey("publishFlag")) {
                map.put("publishFlag", ParamUtil.getInt(map, (String)"publishFlag", (int)0));
            }
            if (map.containsKey("useFlag")) {
                map.put("useFlag", ParamUtil.getInt(map, (String)"useFlag", (int)0));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public boolean deleteForms(String formIds) throws BusinessException {
        User user = AppContext.getCurrentUser();
        List idList = CommonTools.parseStr2Ids((String)formIds);
        if (Strings.isNotEmpty((Collection)idList)) {
            ArrayList<CAPFormDefinition> definitionList = new ArrayList<CAPFormDefinition>();
            ArrayList<String[]> labelsList = new ArrayList<String[]>();
            ArrayList<String> sqlList = new ArrayList<String>();
            for (Long formId : idList) {
                FormBean formBean = this.cap4FormCacheManager.getForm(formId);
                if (formBean == null) continue;
                FormOwner formOwner = this.cap4FormCacheManager.getFormOwner(formId);
                boolean hasRight = FormUtil.isRightEditForm((long)user.getId(), (FormOwner)formOwner);
                if (!hasRight) continue;
                CAPFormDefinition capFormDefinition = this.cap4FormCacheManager.getCap4FormDefinitionDAO().selectById(formId);
                if (capFormDefinition != null) {
                    definitionList.add(capFormDefinition);
                }
                String[] labels = new String[]{user.getName(), formBean.getFormName()};
                labelsList.add(labels);
                this.cap4FormCacheManager.getCap4FormResourceDAO().delete(formId);
                if (formBean.getFormType() == Enums.FormType.processesForm.getKey()) {
                    FormDelete4WorkflowEvent workflowEvent = new FormDelete4WorkflowEvent((Object)this);
                    workflowEvent.setFormId(formBean.getId());
                    try {
                        EventDispatcher.fireEventWithException((Event)workflowEvent);
                    }
                    catch (Throwable throwable) {
                        throw new BusinessException(throwable.getMessage(), throwable);
                    }
                    List templateList = this.templateManager.getCtpTemplates(formId.longValue(), false);
                    if (templateList != null) {
                        for (CtpTemplate c : templateList) {
                            this.templateManager.deletePhysicalCtpTemplateById(c.getId());
                            List authList = this.templateManager.getCtpTemplateAuths(c.getId(), Integer.valueOf(ModuleType.collaboration.getKey()));
                            if (authList != null) {
                                for (CtpTemplateAuth auth : authList) {
                                    this.templateManager.deleteCtpTemplateAuth(auth);
                                }
                            }
                            this.wapi.deleteWorkflowTemplate(c.getWorkflowId().longValue());
                        }
                    }
                }
                this.cap4FormCacheManager.getFormAuthModuleDAO().deleteByFormId(formId.longValue());
                MainbodyManager mainbodyManager = (MainbodyManager)AppContext.getBean((String)"ctpMainbodyManager");
                mainbodyManager.deleteContentAllByFormAppId(formId);
                Set<Long> serialIdList = this.cap4SerialNumberManager.getSerialNumber4FormBean(formBean);
                if (Strings.isNotEmpty(serialIdList)) {
                    for (Long serialId : serialIdList) {
                        this.serialNumberManager.unbindingSerialNumber(serialId);
                    }
                }
                this.cap4FormManager.saveOrDeleteEnumRef(null, formBean, false);
                this.cap4FormCacheManager.getFormulaDAO().deleteByModuleId(formId);
                this.cap4FormCacheManager.getFormulaConditionDAO().deleteByModuleId(formId);
                this.cap4FormCacheManager.getFormCustomFunctionDAO().deleteByFormId(formId);
                this.cap4FormCacheManager.getRelationDAO().deleteByModuleId(formId);
                this.cap4FormCacheManager.removeFormRelation(formBean);
                this.cap4FormCacheManager.getFormOwnerDAO().delete(formId.longValue());
                this.cap4FormCacheManager.getCap4FormBusinessRelationDAO().deleteBySourceFormId(formId);
                this.cap4MagicManager.deleteMagicByFormBean(formBean);
                List list = formBean.getFormTriggerIdList();
                for (Long triggerId : list) {
                    QuartzHolder.deleteQuartzJobByGroup((String)String.valueOf(triggerId));
                }
                if (formBean.getFormType() == Enums.FormType.processesForm.getKey()) {
                    this.cap4FormBindDesignManager.delFormBindQuartzJob(formId);
                }
                if (Strings.isNotEmpty((Collection)list)) {
                    String sqlTab = "DROP TABLE " + FormTriggerUtil.getTriggerRecordName(formBean) + "; ";
                    sqlList.add(sqlTab);
                }
                this.cap4FormCacheManager.removeFormBean(formId);
            }
            JDBCAgent jdbc = null;
            try {
                jdbc = new JDBCAgent(true);
                if (Strings.isNotEmpty(sqlList)) {
                    jdbc.executeBatch(sqlList);
                }
            }
            catch (Exception e) {
                logger.error((Object)"\u5220\u9664\u52a8\u6001\u8868\u548c\u89e6\u53d1\u8bb0\u5f55\u8868\u5f02\u5e38");
            }
            finally {
                if (jdbc != null) {
                    jdbc.close();
                }
            }
            this.cap4FormCacheManager.getCap4FormDefinitionDAO().delete(definitionList);
            this.appLogManager.insertLogs(user, AppLogAction.Form_Delete, labelsList);
            this.menuCacheManager.updateBiz();
            logger.info((Object)("\u5220\u9664\u8868\u5355\uff1a" + formIds + "  \u5f53\u524d\u64cd\u4f5c\u4eba\uff1a" + AppContext.currentUserName()));
        }
        return true;
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.AccountAdministrator, OrgConstants.Role_NAME.BusinessDesigner})
    public String changeOwner(String formIdStr, Long newAccountId, Long newOwnerId) throws BusinessException {
        String[] formIds;
        for (String string : formIds = formIdStr.split(",")) {
            Date modifyTime;
            Long formId = Long.valueOf(string);
            FormOwner formOwner = this.cap4FormCacheManager.getFormOwner(formId);
            FormBean formBean = this.cap4FormCacheManager.getForm(formId);
            if (formOwner == null || formBean == null) {
                return "false";
            }
            if (newOwnerId.equals(formOwner.getOwnerId()) && newAccountId.equals(formOwner.getOrgAccountId())) continue;
            Long oldAccountId = formOwner.getOrgAccountId();
            boolean overAccount = newAccountId.longValue() != oldAccountId.longValue();
            Long newCategoryId = formBean.getCategoryId();
            if (overAccount) {
                newCategoryId = this.cap4FormManager.getNewCategory(formBean, newAccountId);
            }
            formOwner.setOwnerId(newOwnerId);
            formOwner.setOrgAccountId(newAccountId);
            this.cap4FormCacheManager.getFormOwnerDAO().update(formOwner);
            List<CtpTemplate> templateList = this.cap4FormManager.getFormSystemTemplate(formId);
            for (CtpTemplate template : templateList) {
                template.setMemberId(newOwnerId);
                if (overAccount) {
                    template.setCategoryId(newCategoryId);
                    template.setOrgAccountId(newAccountId);
                }
                this.templateManager.chownTemplete(template);
            }
            formBean.setOwnerId(newOwnerId.longValue());
            if (overAccount) {
                modifyTime = DateUtil.currentDate();
                formBean.setCategoryId(newCategoryId.longValue());
                this.cap4FormCacheManager.getCap4FormDefinitionDAO().updateFormCategoryId(formBean.getId(), newCategoryId, modifyTime);
            }
            modifyTime = DateUtil.currentDate();
            formBean.setModifyDate(modifyTime);
            this.cap4FormManager.updateFormModifyTime(formBean.getId(), modifyTime);
            this.cap4FormCacheManager.sendNotification((Object)(formId + "_" + newOwnerId), CAP4FormCache.FormCacheType.Change_owner, formId);
            this.appLogManager.insertLog(AppContext.getCurrentUser(), AppLogAction.Form_EditAuth, new String[]{AppContext.currentUserName(), this.cap4FormManager.getForm(formId).getFormName(), this.orgManager.getMemberById(newOwnerId).getName()});
        }
        return "true";
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public boolean disableForms(String formIds) throws BusinessException {
        User user = AppContext.getCurrentUser();
        List idList = CommonTools.parseStr2Ids((String)formIds);
        if (Strings.isNotEmpty((Collection)idList)) {
            ArrayList<String[]> labelsList = new ArrayList<String[]>();
            for (Long formId : idList) {
                boolean hasRight;
                CAPFormDefinition fd = this.cap4FormCacheManager.getCap4FormDefinitionDAO().selectById(formId);
                FormBean fb = this.cap4FormCacheManager.getForm(formId);
                FormOwner formOwner = this.cap4FormCacheManager.getFormOwner(formId);
                if (user != null && !(hasRight = FormUtil.isRightEditForm((long)user.getId(), (FormOwner)formOwner))) continue;
                if (fb.needCheckTotalNum()) {
                    // empty if block
                }
                fd.setUseFlag(Integer.valueOf(Enums.FormUseFlagEnum.disabled.getKey()));
                this.cap4FormCacheManager.getCap4FormDefinitionDAO().update(fd);
                fb.setUseFlag(Enums.FormUseFlagEnum.disabled.getKey());
                this.cap4FormCacheManager.addFormBean(formId, fb);
                if (fb.getFormType() == Enums.FormType.processesForm.getKey()) {
                    this.templateManager.updateTemplates(fb.getId(), TemplateEnum.State.invalidation);
                    this.cap4FormBindDesignManager.delFormBindQuartzJob(formId);
                }
                String[] labels = new String[]{user == null ? "system_auto_trigger_name" : user.getName(), fb.getFormName()};
                labelsList.add(labels);
            }
            if (user != null) {
                this.appLogManager.insertLogs(AppContext.getCurrentUser(), AppLogAction.Form_Stop, labelsList);
            }
            this.menuCacheManager.updateBiz();
        }
        return true;
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public Map<String, Object> releaseForms(String formIds, boolean isRemainData) throws BusinessException {
        List formIdList = CommonTools.parseStr2Ids((String)formIds);
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (Strings.isNotEmpty((Collection)formIdList)) {
            if (!isRemainData && !this.cap4FormDesignManager.cleanFormTestData(formIds)) {
                result.put("success", false);
                result.put("message", ResourceUtil.getString((String)"cap4.form.publish.error"));
                return result;
            }
            ArrayList<String[]> labelsList = new ArrayList<String[]>();
            User user = AppContext.getCurrentUser();
            for (Long formId : formIdList) {
                FormBean fb = this.cap4FormCacheManager.getForm(formId);
                if (fb != null && !fb.isPublished()) {
                    CAPFormDefinition fd = fb.toFormDefinition();
                    fd.setPublishFlag(Integer.valueOf(Enums.FormPublishFlagEnum.published.getKey()));
                    fd.setModifyTime(DateUtil.currentDate());
                    this.cap4FormCacheManager.getCap4FormDefinitionDAO().update(fd);
                    this.cap4FormCacheManager.initForm(formId);
                    String[] label = new String[]{user.getName(), fd.getName()};
                    labelsList.add(label);
                }
                if (isRemainData) continue;
                this.capRunningLogManager.saveRunningLog(0L, null, formId, fb == null ? "" : fb.getFormName(), 0L, Enums.CapLogType.DELETE.getKey(), "\u300a" + (fb == null ? "" : fb.getFormName()) + "\u300b\u8868\u5355\u53d1\u5e03\u5220\u9664\u6570\u636e\u6210\u529f\uff01", AppContext.getCurrentUser().getId(), AppContext.getCurrentUser().getId(), DateUtil.currentDate(), AppContext.currentAccountName(), AppContext.getRemoteAddr());
            }
            this.appLogManager.insertLogs(AppContext.getCurrentUser(), AppLogAction.Form_Publish, labelsList);
        }
        result.put("success", true);
        return result;
    }

    @Override
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    @AjaxAccess
    public String ableForms(String formIds) throws BusinessException {
        User user = AppContext.getCurrentUser();
        List idList = CommonTools.parseStr2Ids((String)formIds);
        if (Strings.isNotEmpty((Collection)idList)) {
            boolean checkNum = false;
            Enums.FormType type = null;
            for (Long formId : idList) {
                FormBean fb = this.cap4FormCacheManager.getForm(formId);
                if (type != null) continue;
                type = Enums.FormType.getEnumByKey((int)fb.getFormType());
            }
            ArrayList<String[]> labelsList = new ArrayList<String[]>();
            for (Long formId : idList) {
                boolean hasRight;
                CAPFormDefinition fd = this.cap4FormCacheManager.getCap4FormDefinitionDAO().selectById(formId);
                FormBean fb = this.cap4FormCacheManager.getForm(formId);
                FormOwner formOwner = this.cap4FormCacheManager.getFormOwner(formId);
                if (user != null && !(hasRight = FormUtil.isRightEditForm((long)user.getId(), (FormOwner)formOwner))) continue;
                BizOperationEnum operationEnum = BizOperationEnum.enable_form_save;
                fd.setUseFlag(Integer.valueOf(Enums.FormUseFlagEnum.enabled.getKey()));
                this.cap4FormCacheManager.getCap4FormDefinitionDAO().update(fd);
                fb.setUseFlag(Enums.FormUseFlagEnum.enabled.getKey());
                this.cap4FormCacheManager.addFormBean(formId, fb);
                if (fb.getFormType() == Enums.FormType.processesForm.getKey()) {
                    this.templateManager.updateTemplates(fb.getId(), TemplateEnum.State.normal);
                    this.cap4FormBindDesignManager.newFormBindQuartzJob(formId);
                }
                String[] label = new String[]{user == null ? "system_auto_trigger_name" : user.getName(), fb.getFormName()};
                labelsList.add(label);
            }
            this.menuCacheManager.updateBiz();
            if (user != null) {
                this.appLogManager.insertLogs(AppContext.getCurrentUser(), AppLogAction.Form_Start, labelsList);
            }
        }
        return "";
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public Map<String, Object> exportForm(Map<String, Object> params) throws BusinessException {
        return this.businessImportAndExportManager.exportForm(params);
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public Map<String, Object> formSetup(Map<String, Object> params) throws BusinessException {
        String from = ParamUtil.getString(params, (String)"from");
        if (BusinessEnums.ExportType.APPLICATION.getKey().equals(from) && !AppContext.hasPlugin((String)"cap_advance")) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>(2);
            resultMap.put("msg", ResourceUtil.getString((String)"form.over.power.tips"));
            return resultMap;
        }
        return this.businessImportAndExportManager.formSetup(params);
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public Map<String, Object> workflowExport(String formIds, String currentUserId) throws BusinessException, SQLException {
        String[] ids;
        Long userId = Long.valueOf(currentUserId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (this.cap4WorkflowExportLockManager.isLock(userId)) {
            map.put("result", false);
            map.put("message", ResourceUtil.getString((String)"cap4.workflow.export.tips"));
            return map;
        }
        int formCount = 0;
        int templateCount = 0;
        for (String id : ids = formIds.split(",")) {
            FormBean formBean = this.cap4FormCacheManager.getForm(Long.valueOf(id));
            if (formBean == null) continue;
            ++formCount;
            List<CtpTemplate> templateList = this.cap4FormManager.getFormSystemTemplate(formBean.getId());
            templateCount += templateList.size();
        }
        Thread thread = new Thread(new CAP4WorkFlowExport(ids, userId));
        thread.start();
        HashMap<String, Integer> countMap = new HashMap<String, Integer>();
        countMap.put("formCount", formCount);
        countMap.put("templateCount", templateCount);
        map.put("result", true);
        map.put("countMap", countMap);
        return map;
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public String checkForm(String id1) throws BusinessException, SQLException {
        StringBuilder sb = new StringBuilder();
        StringBuilder relationError = new StringBuilder();
        String[] id = id1.split(",");
        block2: for (int i = 0; i < id.length; ++i) {
            FormBean fb = this.cap4FormCacheManager.getForm(Long.valueOf(id[i]));
            if (null == fb || fb.getState() == Enums.FormStateEnum.draft.getKey()) continue;
            List tb = fb.getTableList();
            for (FormTableBean ftb : tb) {
                int count = 0;
                try {
                    count = this.cap4FormCacheManager.getCap4FormDataDAO().selectRecordCount(ftb.getTableName());
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
                if (count <= 0) continue;
                sb.append("\u300a" + fb.getFormName() + "\u300b,");
                continue block2;
            }
        }
        String sbStr = sb.toString().indexOf(",") > 1 ? sb.substring(0, sb.toString().length() - 1) : sb.toString();
        return sbStr.length() > 0 ? ResourceUtil.getString((String)"form.formlist.fromcantdel.js", (Object)sbStr) : relationError.toString();
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public Map<String, Object> checkFormReport(String formIds) throws BusinessException {
        List idList = CommonTools.parseStr2Ids((String)formIds);
        ArrayList<String> formNameList = new ArrayList<String>();
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (Strings.isNotEmpty((Collection)idList)) {
            ReportApi reportApi = (ReportApi)AppContext.getBean((String)"reportApi");
            for (Long formId : idList) {
                FormBean fb = this.cap4FormCacheManager.getForm(formId);
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("categoryId", formId.toString());
                params.put("category", ApplicationCategoryEnum.cap4Form.name());
                List reportResult = reportApi.findDesignWithoutAuth(params);
                if (Strings.isNotEmpty((Collection)reportResult)) {
                    formNameList.add(fb.getFormName());
                }
                for (Map reportMap : reportResult) {
                    String reportTitle = ParamUtil.getString((Map)reportMap, (String)"title");
                    if (!Strings.isNotEmpty((String)reportTitle)) continue;
                    formNameList.add("\u300a" + reportTitle + "\u300b");
                }
            }
            if (Strings.isNotEmpty(formNameList)) {
                result.put("success", false);
                result.put("message", ResourceUtil.getString((String)"cap4.form.report.delete.tips", (Object)Strings.join(formNameList, (String)",")));
                return result;
            }
            result.put("success", true);
        }
        return result;
    }

    public void checkExistSerialNumber(String fistName, Element root, Map<String, String> serialNumbeMap) throws BusinessException {
        String name = root.attributeValue("name");
        FormSerialNumberBean fsnb = this.formCacheManager.getSerialNumberByName(name, Long.valueOf(AppContext.currentAccountId()));
        if (fsnb != null) {
            root.addAttribute("name", name + 1);
            this.checkExistSerialNumber(fistName, root, serialNumbeMap);
        } else {
            FormSerialNumberBean fsn = new FormSerialNumberBean();
            fsn.setNewId();
            fsn.setVariableName(name);
            fsn.setDigit(Integer.valueOf(root.attributeValue("digit")));
            fsn.setPrefix(root.attributeValue("prefix"));
            fsn.setSuffix(root.attributeValue("suffix"));
            fsn.setTimeDate(Integer.valueOf(root.attributeValue("timedate")));
            fsn.setTextTimeBehind(root.attributeValue("texttimebehond"));
            fsn.setRuleReset(Integer.valueOf(root.attributeValue("rulereset")));
            fsn.setTextTimeFront(root.attributeValue("texttimefont"));
            fsn.setCreateTime((Date)DateUtil.currentTimestamp());
            fsn.setMinValue(Long.valueOf(root.attributeValue("minvalue")));
            fsn.setValue(fsn.getMinValue().longValue());
            fsn.setState(Integer.valueOf(Enums.SerialNumberState.NO.getKey()));
            fsn.setAccountId(AppContext.currentAccountId());
            this.cap4FormCacheManager.getSerialNumberDAO().saveOrUpdate(fsn.toFormSerialNumber());
            this.formCacheManager.addFormSerialNumberBean(fsn.getId().longValue(), fsn);
            serialNumbeMap.put(fistName, fsn.getVariableName());
        }
    }

    @Override
    public List<FormTreeNode> getUnFlowFormBindList(Map<String, Object> map) throws BusinessException {
        int formType = ParamUtil.getInt(map, (String)"formType");
        String condition = ParamUtil.getString(map, (String)"condition");
        String value = ParamUtil.getString(map, (String)"data");
        String id = ParamUtil.getString(map, (String)"id");
        if (id != null) {
            return null;
        }
        String templateCategoryId = ParamUtil.getString(map, (String)"templateCategoryId");
        ArrayList<FormTreeNode> nodes = new ArrayList<FormTreeNode>();
        FormTreeNode rootNode = new FormTreeNode();
        nodes.add(rootNode);
        if (Enums.FormType.unFlowForm.getKey() == formType) {
            rootNode.setId(Enums.FormType.unFlowForm.getKey() + "");
            rootNode.setName(Enums.FormType.unFlowForm.getValue());
        }
        HashMap<String, CtpTemplateCategory> catgMap = new HashMap<String, CtpTemplateCategory>();
        List<FormBean> formList = this.cap4FormCacheManager.getFormList();
        boolean isSearch = Strings.isNotBlank((String)condition) && Strings.isNotBlank((String)value);
        long currentAccountId = AppContext.currentAccountId();
        for (FormBean fbean : formList) {
            CtpTemplateCategory currentTemplate;
            int type;
            if (!this.cap4FormCacheManager.isEnabled(fbean) || (type = fbean.getFormType()) != formType || (currentTemplate = this.templateManager.getCtpTemplateCategory(Long.valueOf(fbean.getCategoryId()))) == null || Strings.isNotBlank((String)templateCategoryId) && !templateCategoryId.equals(currentTemplate.getId().toString()) || isSearch && "categoryName".equals(condition) && !currentTemplate.getName().contains(value)) continue;
            long currentTempOrgId = currentTemplate.getOrgAccountId() == null ? 0L : currentTemplate.getOrgAccountId();
            FormBindBean bindBean = fbean.getBind();
            Map templates = bindBean.getUnFlowTemplateMap();
            for (Map.Entry entry : templates.entrySet()) {
                V3xOrgAccount accountById;
                FormBindAuthBean template = (FormBindAuthBean)entry.getValue();
                if (isSearch && "bindName".equals(condition) && !template.getName().contains(value) || !template.checkRight(AppContext.currentUserId())) continue;
                catgMap.put(currentTemplate.getName(), currentTemplate);
                String templateName = template.getName();
                if (currentAccountId != currentTempOrgId && null != (accountById = this.orgManager.getAccountById(Long.valueOf(currentTempOrgId)))) {
                    templateName = templateName + "(" + this.orgManager.getAccountById(Long.valueOf(currentTempOrgId)).getName() + ")";
                }
                FormTreeNode node = new FormTreeNode();
                node.setName(templateName);
                node.setId(template.getId().toString());
                node.setParentId(currentTemplate.getName());
                node.setIconString("collaboration");
                node.setFormId(fbean.getId().toString());
                nodes.add(node);
            }
        }
        TreeNodeUtil.getTreeNode4SortCatg(catgMap, rootNode, nodes, "", catgMap);
        return nodes;
    }

    @Override
    public List<Map<String, Object>> getFormCategoryListByMyAccount(Map<String, String> map) throws BusinessException {
        ArrayList<Map<String, Object>> wapperMapList = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> root = new HashMap<String, Object>();
        root.put("id", ModuleType.form.getKey());
        root.put("name", ResourceUtil.getString((String)"formsection.config.template.label"));
        wapperMapList.add(root);
        List<CtpTemplateCategory> clonedTemplateCategorys = this.cap4FormManager.getFlowTemplateCategoryListByMyAccount();
        ArrayList<TemplateCategory> templateCategories = new ArrayList<TemplateCategory>(clonedTemplateCategorys.size());
        for (CtpTemplateCategory category : clonedTemplateCategorys) {
            templateCategories.add(new TemplateCategory(category));
        }
        ComparatorTemplateBOPub comparator = new ComparatorTemplateBOPub();
        Collections.sort(templateCategories, comparator);
        for (CtpTemplateCategory ctpTemplateCategory : templateCategories) {
            HashMap<String, Object> wapperMap = new HashMap<String, Object>();
            wapperMap.put("id", ctpTemplateCategory.getId());
            wapperMap.put("parentId", ctpTemplateCategory.getParentId() == null || ctpTemplateCategory.getParentId().equals(ctpTemplateCategory.getId()) || ctpTemplateCategory.getParentId() == (long)ModuleType.collaboration.getKey() ? root.get("id") : ctpTemplateCategory.getParentId());
            wapperMap.put("name", ctpTemplateCategory.getName());
            wapperMapList.add(wapperMap);
        }
        return wapperMapList;
    }

    @Override
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner, OrgConstants.Role_NAME.AccountAdministrator})
    public FlipInfo getFlowTemplateList(FlipInfo fi, Map<String, Object> params) throws BusinessException {
        int n;
        boolean fromOwnerid = true;
        Long formId = Long.parseLong(params.get("formId") + "");
        List<Object> templateList = new ArrayList();
        if (formId != 0L) {
            templateList = this.templateManager.getCtpTemplates(formId.longValue(), false);
            fromOwnerid = false;
        } else {
            templateList = this.cap4FormManager.getMyOwnFlowTemplate(params, params.get("notTemplateId") == null ? null : Long.valueOf(Long.parseLong(params.get("notTemplateId").toString())));
            FormBean currentFormBean = this.cap4FormManager.getEditingForm(formId);
            if (currentFormBean != null) {
                List currentFlowList = currentFormBean.getBind().getFlowTemplateList();
                for (int i = templateList.size() - 1; i >= 0; --i) {
                    if (((Long)((CtpTemplate)templateList.get(i)).getExtraAttr("formId")).longValue() != currentFormBean.getId().longValue()) continue;
                    templateList.remove(i);
                }
                ComparatorCtpTemplate comparatorCtpTemplate = new ComparatorCtpTemplate("desc");
                Collections.sort(currentFlowList, comparatorCtpTemplate);
                for (int i = currentFlowList.size() - 1; i >= 0; --i) {
                    long notTId = params.get("notTemplateId") == null ? 0L : Long.parseLong(params.get("notTemplateId").toString());
                    CtpTemplate c = (CtpTemplate)currentFlowList.get(i);
                    c.setCategoryId(Long.valueOf(currentFormBean.getCategoryId()));
                    c.putExtraAttr("formId", (Object)currentFormBean.getId());
                    if (notTId == c.getId()) continue;
                    if (params.containsKey("forcheck")) {
                        if (params.containsKey("templateName")) {
                            if (!c.getSubject().contains(params.get("templateName").toString())) continue;
                            templateList.add(0, c);
                            continue;
                        }
                        if (params.containsKey("formname")) {
                            if (!currentFormBean.getFormName().contains(params.get("formname").toString())) continue;
                            templateList.add(0, c);
                            continue;
                        }
                        if (params.containsKey("category")) {
                            if (!params.get("category").toString().equals(c.getCategoryId().toString())) continue;
                            templateList.add(0, c);
                            continue;
                        }
                        if (params.containsKey("modifyTime")) {
                            try {
                                List date = (List)params.get("modifyTime");
                                Date beginTime = DateUtil.parse((String)(StringUtil.checkNull((String)(date.get(0) + "")) ? FormulaFunctionUitl.DEFAULT_DATE : date.get(0) + ""), (String)"yyyy-MM-dd");
                                Date endTime = DateUtil.parse((String)(StringUtil.checkNull((String)(date.get(1) + "")) ? DateUtil.getDateAndTime() : date.get(1) + ""), (String)"yyyy-MM-dd");
                                if (!c.getModifyDate().after(beginTime) || !c.getModifyDate().before(endTime)) continue;
                                templateList.add(0, c);
                                continue;
                            }
                            catch (ParseException e) {
                                throw new BusinessException((Throwable)e);
                            }
                        }
                        templateList.add(0, c);
                        continue;
                    }
                    templateList.add(0, c);
                }
            }
        }
        ArrayList<LinkedMap> listMap = new ArrayList<LinkedMap>();
        StringBuilder watcher = new StringBuilder();
        CtpSuperviseDetail superviseDetail = null;
        String[] auths = new String[2];
        String formName = "";
        CtpTemplateCategory ctc = null;
        FormBean fb = this.cap4FormManager.getForm(formId);
        if (fb != null) {
            formName = fb.getFormName();
            ctc = this.templateManager.getCtpTemplateCategory(Long.valueOf(fb.getCategoryId()));
        }
        String category = "";
        String categoryName = "";
        String i18nName = "";
        if (ctc != null) {
            categoryName = ctc.getName();
            i18nName = ResourceUtil.getString((String)categoryName);
            category = !StringUtil.checkNull((String)i18nName) ? i18nName : categoryName;
        }
        String ownerName = "";
        for (CtpTemplate ctpTemplate : templateList) {
            if (!ctpTemplate.isSystem().booleanValue()) continue;
            LinkedMap ctMap = new LinkedMap();
            watcher = new StringBuilder();
            if (fromOwnerid) {
                formId = (Long)ctpTemplate.getExtraAttr("formId");
                fb = this.cap4FormManager.getEditingForm(formId);
                if (fb == null || !formId.equals(fb.getId())) {
                    fb = this.cap4FormManager.getForm(formId);
                }
                formName = fb.getFormName();
                category = "";
                ctc = this.templateManager.getCtpTemplateCategory(Long.valueOf(fb.getCategoryId()));
                if (ctc != null) {
                    categoryName = ctc.getName();
                    i18nName = ResourceUtil.getString((String)categoryName);
                    String string = category = !StringUtil.checkNull((String)i18nName) ? i18nName : categoryName;
                }
            }
            if (params.containsKey("formname") && !formName.contains(params.get("formname").toString())) continue;
            ctMap.put("workflowId", ctpTemplate.getWorkflowId());
            ctMap.put("id", ctpTemplate.getId());
            ctMap.put("name", ctpTemplate.getSubject());
            ctMap.put("formname", formName);
            ctMap.put("category", category);
            ctMap.put("formApp", String.valueOf(ctpTemplate.getExtraAttr("formId")));
            if (this.orgManager != null) {
                try {
                    V3xOrgMember member = this.orgManager.getMemberById(ctpTemplate.getMemberId());
                    if (member != null) {
                        ownerName = member.getName();
                    }
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            ctMap.put("owner", ownerName);
            ctMap.put("modifyTime", DateUtil.format((Date)ctpTemplate.getModifyDate(), (String)"yyyy-MM-dd HH:mm"));
            List authList = this.templateManager.getCtpTemplateAuths(ctpTemplate.getId(), null);
            auths[0] = Functions.showOrgEntities((Collection)authList, (String)"authId", (String)"authType", null);
            auths[1] = Functions.parseElements((Collection)authList, (String)"authId", (String)"authType");
            ctMap.put("auths", auths.length > 0 ? auths[0] : "");
            superviseDetail = this.superviseManager.getSupervise(ctpTemplate.getId());
            if (null != superviseDetail) {
                List supervisors = this.superviseManager.getSupervisors(superviseDetail.getId());
                for (CtpSupervisor ctps : supervisors) {
                    V3xOrgMember orgMember = this.orgManager.getMemberById(ctps.getSupervisorId());
                    if (orgMember == null) continue;
                    watcher.append("," + orgMember.getName());
                }
                for (CtpSuperviseTemplateRole srole : this.superviseManager.findRoleByTemplateId(ctpTemplate.getId().longValue())) {
                    watcher.append("," + ("sender".equals(srole.getRole()) ? ResourceUtil.getString((String)"collaboration.common.common.supervise.initiator") : ResourceUtil.getString((String)"collaboration.common.common.supervise.initiatorManager")));
                }
            }
            ctMap.put("watcher", watcher.toString().replaceFirst(",", ""));
            listMap.add(ctMap);
        }
        ArrayList newMapList = new ArrayList();
        for (int i = n = fi.getStartAt().intValue(); null != listMap && i < listMap.size() && i < n + fi.getSize(); ++i) {
            newMapList.add(listMap.get(i));
        }
        fi.setTotal(listMap.size());
        fi.setData(newMapList);
        return fi;
    }

    @Override
    public boolean checkCategorys(Long categoryId) throws BusinessException {
        boolean flag = this.cap4FormCacheManager.getCap4FormDefinitionDAO().selectByCategoryId(categoryId).size() > 0;
        return flag;
    }

    @Override
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public boolean isFormOwner(String formId) throws BusinessException {
        boolean isFormAdmin = true;
        Long currentFormId = formId == null ? null : Long.valueOf(formId);
        FormBean fb = this.cap4FormCacheManager.getForm(currentFormId);
        long currentUserId = AppContext.currentUserId();
        if (fb.getOwnerId() != currentUserId) {
            isFormAdmin = false;
        }
        return isFormAdmin;
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public List<Map<String, Object>> checkFormOwner(String formIds) throws BusinessException {
        List idList = CommonTools.parseStr2Ids((String)formIds);
        if (Strings.isNotEmpty((Collection)idList)) {
            ArrayList<Map<String, Object>> checkResult = new ArrayList<Map<String, Object>>();
            HashMap<String, Object> ownerMap = new HashMap<String, Object>();
            for (Long formId : idList) {
                FormBean fb = this.cap4FormCacheManager.getForm(formId);
                long currentUserId = AppContext.currentUserId();
                if (fb.getOwnerId() == currentUserId) continue;
                ownerMap.put("id", formId);
                ownerMap.put("name", fb.getFormName());
                checkResult.add(ownerMap);
            }
            return checkResult;
        }
        return Collections.emptyList();
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public List<Map<String, Object>> checkFormIsEdit(String formIds) throws BusinessException {
        List idList = CommonTools.parseStr2Ids((String)formIds);
        if (Strings.isNotEmpty((Collection)idList)) {
            ArrayList<Map<String, Object>> checkResult = new ArrayList<Map<String, Object>>();
            HashMap<String, Object> editMap = new HashMap<String, Object>();
            for (Long formId : idList) {
                FormBean fb = this.cap4FormCacheManager.getForm(formId);
                if (!this.cap4FormDesignManager.checkFormIsEdit(formId)) continue;
                editMap.put("id", formId);
                editMap.put("name", fb.getFormName());
                checkResult.add(editMap);
            }
            return checkResult;
        }
        return Collections.emptyList();
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public void saveFormDataset(List formIdList) throws BusinessException {
        if (formIdList == null || formIdList.size() == 0) {
            return;
        }
        ArrayList<Long> fids = new ArrayList<Long>();
        for (Object fid : formIdList) {
            fids.add(Long.parseLong(fid.toString()));
        }
        this.seeyonreportApi.saveOrUpdateFormDataset(fids);
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public List<String> checkFormDatasetExists(List formIdList) throws BusinessException {
        if (formIdList == null || formIdList.size() == 0) {
            return null;
        }
        HashMap<String, String> formObj = new HashMap<String, String>();
        for (Object obj : formIdList) {
            Map map = (Map)obj;
            formObj.put(map.get("formId").toString(), map.get("formName").toString());
        }
        return this.seeyonreportApi.checkReportDatasetExists(formObj);
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public List<String> checkFormDatasetExistsAuth(List formIdList) throws BusinessException {
        if (formIdList == null || formIdList.size() == 0) {
            return null;
        }
        HashMap<String, String> formObj = new HashMap<String, String>();
        for (Object obj : formIdList) {
            Map map = (Map)obj;
            formObj.put(map.get("formId").toString(), map.get("formName").toString());
        }
        return this.seeyonreportApi.checkReportDatasetExistsAuth(formObj);
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public void saveFormDatasetAuth(List formIds, List memberIds) throws BusinessException {
        ArrayList<Long> fids = new ArrayList<Long>();
        for (Object fid : formIds) {
            fids.add(Long.parseLong(fid.toString()));
        }
        ArrayList<Long> adminIds = new ArrayList<Long>();
        for (Object mid : memberIds) {
            adminIds.add(Long.parseLong(mid.toString()));
        }
        for (Long formId : fids) {
            this.seeyonreportApi.saveOrUpdateFormDatasetAuth(formId, adminIds);
        }
    }

    @Override
    public FlipInfo getUnflowList(FlipInfo fi, Map<String, Object> params) throws BusinessException {
        int[] type = new int[]{Enums.FormType.unFlowForm.getKey()};
        List<FormBean> unflowlist = this.cap4FormCacheManager.getFormsByTypes(type);
        ArrayList listMap = new ArrayList();
        for (int i = 0; i < unflowlist.size(); ++i) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            FormBean fb = unflowlist.get(i);
            if (this.cap4FormCacheManager.isSystemDisabledForm(fb)) continue;
            String stateText = Enums.FormStateEnum.getEnumByKey((int)fb.getState()).getText();
            String useFlag = Enums.FormUseFlagEnum.getEnumByKey((int)fb.getUseFlag()).getText();
            if (Enums.FormUseFlagEnum.enabled.getKey() != fb.getUseFlag()) continue;
            String formTypeName = Enums.FormType.getEnumByKey((int)fb.getFormType()).getValue();
            map.put("name", fb.getFormName());
            map.put("id", fb.getId());
            map.put("stateText", stateText);
            map.put("useFlag", useFlag);
            map.put("formTypeName", formTypeName);
            if (this.orgManager != null) {
                try {
                    V3xOrgMember member = this.orgManager.getMemberById(Long.valueOf(fb.getOwnerId()));
                    if (member != null) {
                        map.put("ownerId", member.getName());
                        V3xOrgAccount org = this.orgManager.getAccountById(member.getOrgAccountId());
                        map.put("orgId", org.getName());
                    }
                }
                catch (Exception e) {
                    logger.error((Object)"getUnflowList is error ", (Throwable)e);
                }
            }
            CtpTemplateCategory ctc = this.templateManager.getCtpTemplateCategory(Long.valueOf(fb.getCategoryId()));
            map.put("categoryId", this.getCatgName(ctc));
            map.put("createTime", DateUtil.formatDateTime((Date)fb.getCreateDate()));
            if (fb.getModifyDate() == null) {
                map.put("modifyTime", map.get("createTime"));
            } else {
                map.put("modifyTime", DateUtil.formatDateTime((Date)fb.getModifyDate()));
            }
            listMap.add(map);
        }
        fi.setData(listMap);
        fi.setTotal(listMap.size());
        return fi;
    }

    private String getCatgName(CtpTemplateCategory ctc) {
        String name = "";
        if (ctc != null) {
            String categoryName = ctc.getName();
            String i18nName = ResourceUtil.getString((String)categoryName);
            name = !StringUtil.checkNull((String)i18nName) ? i18nName : categoryName;
        }
        return name;
    }

    public CAP4FormCacheManager getCap4FormCacheManager() {
        return this.cap4FormCacheManager;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public FileManager getFileManager() {
        return this.fileManager;
    }

    public void setFileManager(FileManager fileManager) {
        this.fileManager = fileManager;
    }

    public CAP4FormManager getCap4FormManager() {
        return this.cap4FormManager;
    }

    public void setCap4FormManager(CAP4FormManager cap4FormManager) {
        this.cap4FormManager = cap4FormManager;
    }

    public TemplateManager getTemplateManager() {
        return this.templateManager;
    }

    public void setTemplateManager(TemplateManager templateManager) {
        this.templateManager = templateManager;
    }

    public SuperviseManager getSuperviseManager() {
        return this.superviseManager;
    }

    public void setSuperviseManager(SuperviseManager superviseManager) {
        this.superviseManager = superviseManager;
    }

    public OrgManager getOrgManager() {
        return this.orgManager;
    }

    public void setOrgManager(OrgManager orgManager) {
        this.orgManager = orgManager;
    }

    public AppLogManager getAppLogManager() {
        return this.appLogManager;
    }

    public void setAppLogManager(AppLogManager appLogManager) {
        this.appLogManager = appLogManager;
    }

    public WorkflowApiManager getWapi() {
        return this.wapi;
    }

    public void setWapi(WorkflowApiManager wapi) {
        this.wapi = wapi;
    }

    public EnumManager getEnumManagerNew() {
        return this.enumManagerNew;
    }

    public void setEnumManagerNew(EnumManager enumManagerNew) {
        this.enumManagerNew = enumManagerNew;
    }

    public SerialNumberManager getSerialNumberManager() {
        return this.serialNumberManager;
    }

    public void setSerialNumberManager(SerialNumberManager serialNumberManager) {
        this.serialNumberManager = serialNumberManager;
    }

    public void setCap4SerialNumberManager(CAP4SerialNumberManager cap4SerialNumberManager) {
        this.cap4SerialNumberManager = cap4SerialNumberManager;
    }

    public void setSeeyonreportApi(SeeyonreportApi seeyonreportApi) {
        this.seeyonreportApi = seeyonreportApi;
    }

    public void setCap4FormBindDesignManager(CAP4FormBindDesignManager cap4FormBindDesignManager) {
        this.cap4FormBindDesignManager = cap4FormBindDesignManager;
    }

    public void setMenuCacheManager(MenuCacheManager menuCacheManager) {
        this.menuCacheManager = menuCacheManager;
    }

    @Override
    public String beforeViewOneRecord(Long formId) throws BusinessException {
        FormBean fromBean = this.cap4FormManager.getForm(formId);
        if (null == fromBean) {
            return null;
        }
        return "true";
    }

    @Override
    public void updateFormCache(String formIds) throws BusinessException {
        String[] ids;
        logger.info((Object)("\u5f00\u59cb\u66f4\u65b0\u8868\u5355\u7f13\u5b58\uff1a" + formIds));
        for (String id : ids = formIds.split(",")) {
            FormBean formBean = this.cap4FormCacheManager.getForm(Long.valueOf(id));
            if (formBean == null) continue;
            this.cap4FormCacheManager.initForm(formBean.getId());
        }
        logger.info((Object)("\u66f4\u65b0\u8868\u5355\u7f13\u5b58\u5b8c\u6210\uff1a" + formIds));
    }

    @Override
    @AjaxAccess
    @CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
    public Map<String, Object> getDataDictionary(Long formId) throws BusinessException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        FormBean formBean = this.cap4FormCacheManager.getForm(formId);
        this.makeFormDataDictionary(map, formBean);
        return map;
    }

    private Map<String, Object> makeFormDataDictionary(Map<String, Object> map, FormBean formBean) throws BusinessException {
        if (null != formBean) {
            HashMap<String, String> keys = new HashMap<String, String>();
            keys.put("formInfo", ResourceUtil.getString((String)"form.datadictionary.formInfo"));
            keys.put("masterInfo", ResourceUtil.getString((String)"form.datadictionary.masterInfo"));
            keys.put("subInfo", ResourceUtil.getString((String)"form.datadictionary.subInfo"));
            keys.put("formName", ResourceUtil.getString((String)"form.datadictionary.formName"));
            keys.put("categoryName", ResourceUtil.getString((String)"form.datadictionary.categoryName"));
            keys.put("creatorName", ResourceUtil.getString((String)"form.datadictionary.creatorName"));
            keys.put("ownerName", ResourceUtil.getString((String)"form.datadictionary.ownerName"));
            keys.put("formTypeName", ResourceUtil.getString((String)"form.datadictionary.formTypeName"));
            keys.put("tableName", ResourceUtil.getString((String)"form.datadictionary.tableName"));
            keys.put("DBtableName", ResourceUtil.getString((String)"form.datadictionary.DBtableName"));
            keys.put("fieldName", ResourceUtil.getString((String)"form.datadictionary.fieldName"));
            keys.put("fieldDisplay", ResourceUtil.getString((String)"form.datadictionary.fieldDisplay"));
            keys.put("fieldType", ResourceUtil.getString((String)"form.datadictionary.fieldType"));
            keys.put("finalFieldType", ResourceUtil.getString((String)"form.datadictionary.finalFieldType"));
            keys.put("fieldLength", ResourceUtil.getString((String)"form.datadictionary.fieldLength"));
            keys.put("finalInputType", ResourceUtil.getString((String)"form.datadictionary.finalInputType"));
            keys.put("close", ResourceUtil.getString((String)"form.datadictionary.close"));
            map.put("keys", keys);
            HashMap<String, Object> formInfo = new HashMap<String, Object>();
            String formName = formBean.getFormName();
            long categoryId = formBean.getCategoryId();
            int formType = formBean.getFormType();
            long creatorId = formBean.getCreatorId();
            long ownerId = formBean.getOwnerId();
            formInfo.put("formName", formName);
            formInfo.put("shortformName", formName.length() > 5 ? formName.substring(0, 5) + "\u2026\u2026" : formName);
            formInfo.put("categoryId", categoryId);
            formInfo.put("categoryName", Strings.toHTML((String)this.templateManager.getCtpTemplateCategory(Long.valueOf(categoryId)).getName()));
            formInfo.put("creatorId", creatorId);
            V3xOrgMember orgMember = this.orgManager.getMemberById(Long.valueOf(creatorId));
            formInfo.put("creatorName", orgMember == null ? "" : orgMember.getName());
            formInfo.put("ownerId", ownerId);
            V3xOrgMember owner = this.orgManager.getMemberById(Long.valueOf(ownerId));
            formInfo.put("ownerName", owner == null ? "" : owner.getName());
            formInfo.put("formType", formType);
            formInfo.put("formTypeName", Enums.FormType.getEnumByKey((int)formType).getValue());
            map.put("formInfo", formInfo);
            FormTableBean mTable = formBean.getMasterTableBean();
            ArrayList<FormTableBean> mftbs = new ArrayList<FormTableBean>();
            mftbs.add(mTable);
            this.makeTableBeanList(map, mftbs);
            List sTables = formBean.getSubTableBean();
            this.makeTableBeanList(map, sTables);
        }
        return map;
    }

    private Map<String, Object> makeTableBeanList(Map<String, Object> map, List<FormTableBean> ftbs) {
        if (null != ftbs && !ftbs.isEmpty()) {
            ArrayList list = new ArrayList();
            String infoList = "mList";
            String tablename = "mTableName";
            String tableStyle = "mTableStyle";
            String tableType = "mTableType";
            String tableDisplay = "mTableDisplay";
            String tableFieldsInfo = "mFieldsInfo";
            for (FormTableBean ftb : ftbs) {
                HashMap<String, Object> infomap = new HashMap<String, Object>();
                HashMap<String, Object> infos = new HashMap<String, Object>();
                if (ftb.getTableType().equals(Enums.TableType.SLAVE.getKey())) {
                    infoList = "sList";
                    tablename = "sTableName";
                    tableStyle = "sTableStyle";
                    tableType = "sTableType";
                    tableDisplay = "sTableDisplay";
                    tableFieldsInfo = "sFieldsInfo";
                }
                infos.put(tablename, ftb.getTableName());
                infos.put(tableType, ftb.getTableType());
                String tableBeanDisplay = ftb.getDisplay();
                if (!ftb.isMainTable()) {
                    tableBeanDisplay = tableBeanDisplay + "(" + ResourceUtil.getString((String)"form.detail.table.label") + ftb.getTableIndex() + ")";
                }
                infos.put(tableDisplay, tableBeanDisplay);
                List ffl = ftb.getFieldsByName();
                ArrayList fieldsList = new ArrayList();
                for (int i = 0; i < ffl.size(); ++i) {
                    FormFieldBean ff = (FormFieldBean)ffl.get(i);
                    HashMap<String, String> field = new HashMap<String, String>();
                    field.put("name", ff.getName());
                    field.put("display", ff.getDisplay());
                    field.put("fieldType", ff.getFieldType());
                    field.put("fieldLength", StringUtil.checkNull((String)ff.getFieldLength()) || Enums.FieldType.LONGTEXT.getKey().equals(ff.getFinalFieldType()) ? "" : ff.getFieldLength());
                    field.put("finalFieldType", ff.getFinalFieldType());
                    field.put("finalInputType", ff.getInputTypeEnum().getText());
                    fieldsList.add(field);
                }
                infos.put(tableFieldsInfo, fieldsList);
                infomap.put("tableType", ftb.getTableType());
                infomap.put("Fields", infos);
                list.add(infomap);
            }
            map.put(infoList, list);
        }
        return map;
    }

    public void setCap4WorkflowExportLockManager(CAP4WorkflowExportLockManager cap4WorkflowExportLockManager) {
        this.cap4WorkflowExportLockManager = cap4WorkflowExportLockManager;
    }

    public void setCap4FormDesignManager(CAP4FormDesignManager cap4FormDesignManager) {
        this.cap4FormDesignManager = cap4FormDesignManager;
    }

    public void setBusinessImportAndExportManager(BusinessImportAndExportManager businessImportAndExportManager) {
        this.businessImportAndExportManager = businessImportAndExportManager;
    }

    public ICAP4MagicManager getCap4MagicManager() {
        return this.cap4MagicManager;
    }

    public void setCap4MagicManager(ICAP4MagicManager cap4MagicManager) {
        this.cap4MagicManager = cap4MagicManager;
    }

    public void setBusinessManager4(BusinessManager businessManager4) {
        this.businessManager4 = businessManager4;
    }

    public void setCapRunningLogManager(CapRunningLogManager capRunningLogManager) {
        this.capRunningLogManager = capRunningLogManager;
    }
}

