/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.formlist;

import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.modules.formlist.CAP4WorkflowExportLockManager;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.service.CAP4FormManager;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.template.CtpTemplate;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.ZipUtil;
import com.seeyon.ctp.workflow.wapi.WorkflowApiManager;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;

public class CAP4WorkFlowExport
implements Runnable {
    private static final Log logger = CtpLogFactory.getLog(CAP4WorkFlowExport.class);
    private String[] formIds;
    private Long memberId;
    private Locale locale;
    private static CAP4WorkflowExportLockManager cap4WorkflowExportLockManager;
    private static CAP4FormCacheManager cap4FormCacheManager;
    private static CAP4FormManager cap4FormManager;
    private static WorkflowApiManager workflowApiManager;

    public CAP4WorkFlowExport(String[] formIds, Long memberId) {
        this.formIds = formIds;
        this.memberId = memberId;
        this.locale = AppContext.getLocale();
    }

    @Override
    public void run() {
        cap4WorkflowExportLockManager.doLock(this.memberId);
        String tempFolder = new File(new File("").getAbsolutePath()).getParentFile().getParentFile().getPath();
        String zipPath = tempFolder + "/base/upload/workflow_export/" + this.memberId + "/zip";
        File zipFile = new File(zipPath);
        if (zipFile.exists()) {
            try {
                FileUtils.deleteDirectory((File)zipFile);
            }
            catch (IOException e) {
                logger.error((Object)"\u6e05\u7a7azip\u6587\u4ef6\u5939\u65f6\u51fa\u73b0\u5f02\u5e38\uff1a", (Throwable)e);
            }
        }
        tempFolder = tempFolder + "/base/upload/workflow_export/" + this.memberId + "/source";
        for (String formId : this.formIds) {
            FormBean formBean = cap4FormCacheManager.getForm(Long.valueOf(formId));
            if (formBean == null) continue;
            try {
                List<CtpTemplate> templateList = cap4FormManager.getFormSystemTemplate(formBean.getId());
                String formFolder = tempFolder + "/" + formBean.getFormName();
                File formFolderFile = new File(formFolder);
                if (!formFolderFile.exists()) {
                    formFolderFile.mkdirs();
                }
                for (CtpTemplate template : templateList) {
                    Long workflowId = template.getWorkflowId();
                    String subject = template.getSubject();
                    try {
                        List fileList = workflowApiManager.exportWorkflowDiagram(workflowId, false);
                        for (File file : fileList) {
                            String newFile = formFolder + "/" + subject + "/" + file.getName();
                            logger.debug((Object)("newFile=" + newFile));
                            FileUtils.copyFile((File)file, (File)new File(newFile));
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)"\u62f7\u8d1d\u6d41\u7a0b\u6587\u4ef6\u65f6\u51fa\u73b0\u5f02\u5e38\uff1a", (Throwable)e);
                    }
                }
            }
            catch (BusinessException e) {
                logger.error((Object)"\u62f7\u8d1d\u8868\u5355\u6d41\u7a0b\u6587\u4ef6\u51fa\u73b0\u5f02\u5e38\uff1a", (Throwable)e);
            }
        }
        try {
            File oldFile = new File(tempFolder);
            File targetFolder = new File(oldFile.getParent() + "/zip");
            if (!targetFolder.exists()) {
                targetFolder.mkdirs();
            }
            File newFile = new File(targetFolder.getPath() + "/" + ResourceUtil.getStringByParams((Locale)this.locale, (String)"form.download.workflow.name", null) + "_" + DateUtil.getDate((String)"yyyy-MM-dd") + ".zip");
            logger.info((Object)("\u6d41\u7a0b\u6253\u5305=" + newFile.getName()));
            ZipUtil.zip((File)oldFile, (File)newFile, (boolean)false, (String)"GBK", (String)"");
            FileUtils.deleteDirectory((File)oldFile);
        }
        catch (Exception e) {
            logger.error((Object)"\u538b\u7f29\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
        }
        cap4WorkflowExportLockManager.unlock(this.memberId);
    }

    static {
        cap4FormCacheManager = (CAP4FormCacheManager)AppContext.getBean((String)"cap4FormCacheManager");
        cap4WorkflowExportLockManager = (CAP4WorkflowExportLockManager)AppContext.getBean((String)"cap4WorkflowExportLockManager");
        workflowApiManager = (WorkflowApiManager)AppContext.getBean((String)"wapi");
        cap4FormManager = (CAP4FormManager)AppContext.getBean((String)"cap4FormManager");
    }
}

