/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.history;

import com.seeyon.cap4.form.modules.history.CapFormTriggerEventHistoryManager;
import com.seeyon.cap4.form.modules.log.CapRunningLogManager;
import com.seeyon.cap4.form.util.FormUtil;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.quartz.QuartzJob;
import com.seeyon.ctp.report.utils.ReportDBUtils;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.Datetimes;
import com.seeyon.ctp.util.FileUtil;
import com.seeyon.ctp.util.JDBCAgent;
import java.io.File;
import java.sql.ResultSet;
import java.util.Date;
import java.util.Map;
import org.apache.commons.logging.Log;

public class CAP4FormTriggerClearDataQuartzJob
implements QuartzJob {
    private static final Log LOGGER = CtpLogFactory.getLog(CAP4FormTriggerClearDataQuartzJob.class);
    private CapFormTriggerEventHistoryManager capFormTriggerEventHistoryManager;
    CapRunningLogManager capRunningLogManager;
    private final String ROOTPATH = SystemEnvironment.getSystemTempFolder() + File.separator + "cap" + File.separator;
    private final String TRIGGERPATH = this.ROOTPATH + "trigger-history" + File.separator;
    private final String RUNNINGLOGPATH = this.ROOTPATH + "runningLog-history" + File.separator;
    private final Integer AMMONT = -6;

    public void execute(Map<String, String> parameters) {
        try {
            Long start = System.currentTimeMillis();
            String fileName = Datetimes.format((Date)DateUtil.currentDate(), (String)"yyyy-MM-dd");
            Date date = DateUtil.addMonth((Date)new Date(), (int)this.AMMONT);
            String dateString = this.getDateSql();
            JDBCAgent jdbcAgent = null;
            try {
                FileUtil.makeDir((String)this.TRIGGERPATH);
                FileUtil.makeDir((String)this.RUNNINGLOGPATH);
                Long start1 = System.currentTimeMillis();
                jdbcAgent = new JDBCAgent(false, false);
                String sql = "SELECT * FROM CAP_FORM_TRIGGER_EVENT_HISTORY";
                jdbcAgent.execute(sql);
                ResultSet rs = jdbcAgent.getQueryResult();
                if (rs != null) {
                    String eventFileName = this.TRIGGERPATH + "trigger-event-history-" + fileName + ".csv";
                    FormUtil.writeFile((ResultSet)rs, (String)eventFileName);
                }
                Long end1 = System.currentTimeMillis();
                LOGGER.info((Object)("\u5907\u4efdevent\u8017\u65f6:" + (end1 - start1)));
                Long start2 = System.currentTimeMillis();
                jdbcAgent = new JDBCAgent(false, false);
                sql = "SELECT * FROM CAP_FORM_TRIGGER_TASK_HISTORY";
                jdbcAgent.execute(sql);
                rs = jdbcAgent.getQueryResult();
                if (rs != null) {
                    String taskFileName = this.TRIGGERPATH + "trigger-task-history-" + fileName + ".csv";
                    FormUtil.writeFile((ResultSet)rs, (String)taskFileName);
                }
                Long end2 = System.currentTimeMillis();
                LOGGER.info((Object)("\u5907\u4efdtask\u8017\u65f6:" + (end2 - start2)));
                Long start3 = System.currentTimeMillis();
                jdbcAgent = new JDBCAgent(false, false);
                sql = "SELECT * FROM CAP_RUNNING_LOG  where CREATE_DATE < " + dateString;
                jdbcAgent.execute(sql, (Object)Datetimes.format((Date)date, (String)"yyyy-MM-dd HH:mm:ss"));
                rs = jdbcAgent.getQueryResult();
                if (rs != null) {
                    String runningLogFileName = this.RUNNINGLOGPATH + "runningLog-history-" + fileName + ".csv";
                    FormUtil.writeFile((ResultSet)rs, (String)runningLogFileName);
                }
                Long end3 = System.currentTimeMillis();
                LOGGER.info((Object)("\u5907\u4efdtask\u8017\u65f6:" + (end3 - start3)));
            }
            catch (Exception e) {
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
                throw new BusinessException((Throwable)e);
            }
            finally {
                if (jdbcAgent != null) {
                    jdbcAgent.close();
                }
            }
            Long start3 = System.currentTimeMillis();
            this.capFormTriggerEventHistoryManager.deleteExecutedHistoryData();
            this.capRunningLogManager.deleteRunningLogByDateString(date);
            Long end = System.currentTimeMillis();
            LOGGER.info((Object)("\u5220\u9664\u6570\u636e\u8017\u65f6:" + (end - start3)));
            LOGGER.info((Object)("\u603b\u8017\u65f6:" + (end - start)));
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private String getDateSql() {
        String sql = "";
        sql = ReportDBUtils.isOracleRuntime() || ReportDBUtils.isPostgreSQLRuntime() ? "to_char(' ? ,yyyy-mm-dd hh24:mi')" : (ReportDBUtils.isSQLServerRuntime() ? "convert(nvarchar(255), ? ,120)" : "DATE_FORMAT( ? ,'%Y-%m-%d %H:%i:%s')");
        return sql;
    }

    public void setCapRunningLogManager(CapRunningLogManager capRunningLogManager) {
        this.capRunningLogManager = capRunningLogManager;
    }

    public void setCapFormTriggerEventHistoryManager(CapFormTriggerEventHistoryManager capFormTriggerEventHistoryManager) {
        this.capFormTriggerEventHistoryManager = capFormTriggerEventHistoryManager;
    }
}

