/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.history;

import com.seeyon.cap4.form.modules.engin.trigger.CAP4FormTriggerEventDAO;
import com.seeyon.cap4.form.modules.engin.trigger.CAP4FormTriggerTaskDAO;
import com.seeyon.cap4.form.modules.history.CapFormTriggerEventHistoryDAO;
import com.seeyon.cap4.form.modules.history.CapFormTriggerEventHistoryManager;
import com.seeyon.cap4.form.po.CAPFormTriggerEvent;
import com.seeyon.cap4.form.po.CapFormTriggerEventHistory;
import com.seeyon.cap4.form.po.CapFormTriggerTaskHistory;
import com.seeyon.cap4.monitor.dao.BaseDaoImpl;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.form.modules.trigger.FormTriggerTask;
import com.seeyon.ctp.util.DBAgent;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.ParamUtil;
import com.seeyon.ctp.util.Strings;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class CapFormTriggerEventHistoryManagerImpl
extends BaseDaoImpl
implements CapFormTriggerEventHistoryManager {
    private static final Log LOGGER = CtpLogFactory.getLog(CapFormTriggerEventHistoryManagerImpl.class);
    private CapFormTriggerEventHistoryDAO capFormTriggerEventHistoryDAO;
    private CAP4FormTriggerEventDAO cap4FormTriggerEventDAO;
    private CAP4FormTriggerTaskDAO cap4FormTriggerTaskDAO;

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void saveHistoryByEvent(CAPFormTriggerEvent event) {
        CapFormTriggerEventHistory history = new CapFormTriggerEventHistory(event);
        this.capFormTriggerEventHistoryDAO.insert(history);
        this.cap4FormTriggerEventDAO.delete(event);
    }

    @Override
    public CAPFormTriggerEvent getRecordById(Long id) throws BusinessException {
        CapFormTriggerEventHistory history = this.capFormTriggerEventHistoryDAO.getHistoryByEventId(id);
        return history == null ? null : this.convertHistoryToRecord(history);
    }

    private CAPFormTriggerEvent convertHistoryToRecord(CapFormTriggerEventHistory history) {
        CAPFormTriggerEvent event = new CAPFormTriggerEvent();
        event.setState(history.getState());
        event.setModuleType(history.getModuleType());
        event.setModuleId(history.getModuleId());
        event.setFormId(history.getFormId());
        event.setFormName(history.getFormName());
        event.setMasterId(history.getMasterId());
        event.setUserId(history.getUserId());
        event.setConditionState(history.getConditionState());
        event.setSourceType(history.getSourceType());
        event.setExtendAttr(history.getExtendAttr());
        event.setCreateTime(history.getCreateTime());
        event.setTitle(history.getTitle());
        event.setGroupId(history.getGroupId());
        return event;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void saveHistoryByTask(FormTriggerTask task) {
        CapFormTriggerTaskHistory taskHistory = new CapFormTriggerTaskHistory(task);
        this.capFormTriggerEventHistoryDAO.insertTaskHistory(taskHistory);
        this.cap4FormTriggerTaskDAO.delete(task);
    }

    @Override
    public void deleteExecutedHistoryData() throws BusinessException {
        LOGGER.info((Object)"event history start clear");
        this.capFormTriggerEventHistoryDAO.deleteAnalysedEventHistoryData();
        LOGGER.info((Object)"event history end clear");
        LOGGER.info((Object)"task history start clear");
        this.capFormTriggerEventHistoryDAO.deleteExecutedTaskHistoryData();
        LOGGER.info((Object)"task history end clear");
    }

    @Override
    public FlipInfo getTasks(FlipInfo fi, Map<String, Object> params) throws BusinessException {
        StringBuilder hql = new StringBuilder("FROM CapFormTriggerTaskHistory ss WHERE 1=1");
        if (params != null && params.size() != 0) {
            if (params.containsKey("state")) {
                hql.append(" AND ss.taskState = :state");
                params.put("state", ParamUtil.getInt(params, (String)"state"));
            }
            if (params.containsKey("sourceAppName")) {
                if (Strings.isNotEmpty((String)params.get("sourceAppName").toString())) {
                    hql.append(" AND ss.sourceAppName like :sourceAppName");
                    params.put("sourceAppName", "%" + params.get("sourceAppName") + "%");
                } else {
                    params.remove("sourceAppName");
                }
            }
            if (params.containsKey("sourceFormName")) {
                if (Strings.isNotEmpty((String)params.get("sourceFormName").toString())) {
                    hql.append(" AND ss.sourceFormName like :sourceFormName");
                    params.put("sourceFormName", "%" + params.get("sourceFormName") + "%");
                } else {
                    params.remove("sourceFormName");
                }
            }
            this.handleCreateTime(hql, params);
        }
        hql.append(" order by ss.createTime desc");
        DBAgent.find((String)hql.toString(), params, (FlipInfo)fi);
        return fi;
    }

    public void setCapFormTriggerEventHistoryDAO(CapFormTriggerEventHistoryDAO capFormTriggerEventHistoryDAO) {
        this.capFormTriggerEventHistoryDAO = capFormTriggerEventHistoryDAO;
    }

    public void setCap4FormTriggerEventDAO(CAP4FormTriggerEventDAO cap4FormTriggerEventDAO) {
        this.cap4FormTriggerEventDAO = cap4FormTriggerEventDAO;
    }

    public void setCap4FormTriggerTaskDAO(CAP4FormTriggerTaskDAO cap4FormTriggerTaskDAO) {
        this.cap4FormTriggerTaskDAO = cap4FormTriggerTaskDAO;
    }
}

