/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.importandexport;

import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormBindAuthBean;
import com.seeyon.cap4.form.bean.FormBindBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormFieldComEnum;
import com.seeyon.cap4.form.bean.FormFlowBusinessBean;
import com.seeyon.cap4.form.bean.FormFormulaBean;
import com.seeyon.cap4.form.bean.SimpleObjectBean;
import com.seeyon.cap4.form.bean.button.CommonBtn;
import com.seeyon.cap4.form.bean.fieldCtrl.FormFieldUtil;
import com.seeyon.cap4.form.modules.importandexport.AbstractBusinessFormExportManager;
import com.seeyon.cap4.form.modules.importandexport.AppUpgradeCacheBean;
import com.seeyon.cap4.form.modules.importandexport.BusinessDataBean;
import com.seeyon.cap4.form.modules.importandexport.BusinessEnums;
import com.seeyon.cap4.form.modules.importandexport.BusinessRedirectDataBean;
import com.seeyon.cap4.form.modules.importandexport.BusinessRedirectResultBean;
import com.seeyon.cap4.form.modules.importandexport.BusinessRedirectResultBean4Authorization;
import com.seeyon.cap4.form.modules.importandexport.BusinessRedirectResultBean4Template;
import com.seeyon.cap4.form.modules.importandexport.CompatibilityDetectionResultBean;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.form.util.FormDesignUtil;
import com.seeyon.cap4.form.vo.FormOperateConditionVo;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.form.po.FormModuleAuth;
import com.seeyon.ctp.organization.bo.V3xOrgEntity;
import com.seeyon.ctp.organization.manager.OrgManager;
import com.seeyon.ctp.util.Datetimes;
import com.seeyon.ctp.util.StringUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.json.JSONUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;

public class BusinessFormExportManager4Bind
extends AbstractBusinessFormExportManager {
    private final Log LOGGER = CtpLogFactory.getLog(BusinessFormExportManager4Bind.class);

    public String getKey() {
        return null;
    }

    public Integer getSort() {
        return 4;
    }

    public void exportData(FormBean formBean, BusinessDataBean businessDataBean, Map<String, Object> formDataMap) throws BusinessException {
        BusinessEnums.ExportType exportType = businessDataBean.getExportType();
        if (exportType.getKey().equals(BusinessEnums.ExportType.APPLICATION.getKey())) {
            if (!formBean.isFlowForm()) {
                formDataMap.put("bindinfo", formBean.getBindInfo4Export(businessDataBean));
            } else {
                formDataMap.put("flow_business_info", formBean.getBindInfo4Export(businessDataBean));
            }
        }
    }

    public void importData(FormBean formBean, BusinessDataBean businessDataBean, Map<String, Object> dataMap) throws BusinessException {
        BusinessEnums.ExportType exportType = businessDataBean.getExportType();
        if (exportType.getKey().equals(BusinessEnums.ExportType.APPLICATION.getKey())) {
            FormBindBean bindBean = formBean.getBind();
            if (!formBean.isFlowForm()) {
                Map bindInfo = (Map)dataMap.get("bindinfo");
                this.importBindInfo(bindBean, bindInfo, businessDataBean, formBean);
            } else {
                Map bindInfo = (Map)dataMap.get("flow_business_info");
                if (bindInfo == null || bindInfo.isEmpty()) {
                    return;
                }
                this.importFlowBusinessBind(bindBean, bindInfo, businessDataBean, formBean);
            }
        }
    }

    private void importBindInfo(FormBindBean bindBean, Map<String, Object> bindInfo, BusinessDataBean businessDataBean, FormBean formBean) {
        List bindAuthList;
        String bindIdStr = String.valueOf(bindInfo.get("id"));
        Long oldBindId = Long.parseLong(bindIdStr);
        Long newId = businessDataBean.genNewIdByOldId(oldBindId);
        bindBean.setId(newId);
        List logFields = (List)bindInfo.get("logFieldList");
        if (Strings.isNotEmpty((Collection)logFields)) {
            ArrayList<String> newLogFields = new ArrayList<String>();
            for (String fieldName : logFields) {
                if (fieldName.contains(".")) {
                    String tableName = fieldName.split("[.]")[0];
                    fieldName = fieldName.replace(tableName, businessDataBean.getOldAndNewStringMap(tableName));
                }
                newLogFields.add(fieldName);
            }
            bindBean.getLogFieldList().addAll(newLogFields);
        }
        if (Strings.isNotEmpty((Collection)(bindAuthList = (List)bindInfo.get("formBindAuthList")))) {
            for (Map bindAuthMapInfo : bindAuthList) {
                FormBindAuthBean bindAuth = new FormBindAuthBean();
                this.importBindAuthInfo(bindAuth, bindAuthMapInfo, businessDataBean, formBean);
                bindBean.getUnFlowTemplateMap().put(String.valueOf(bindAuth.getId()), bindAuth);
            }
        }
    }

    private void importBindAuthInfo(FormBindAuthBean bindAuth, Map<String, Object> bindAuthMapInfo, BusinessDataBean businessDataBean, FormBean formBean) {
        String bindAuthIdStr = String.valueOf(bindAuthMapInfo.get("id"));
        Long oldBindAuthId = Long.parseLong(bindAuthIdStr);
        Long newId = businessDataBean.genNewIdByOldId(oldBindAuthId);
        bindAuth.setId(newId);
        bindAuth.setName(String.valueOf(bindAuthMapInfo.get("name")));
        bindAuth.setFormId(formBean.getId().longValue());
        bindAuth.setCreator(AppContext.currentUserId());
        String timeStr = Datetimes.formatNoTimeZone((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss.S");
        bindAuth.setCreateTime(timeStr);
        bindAuth.setModifyTime(timeStr);
        bindAuth.setScanCodeInput(String.valueOf(bindAuthMapInfo.get("scanCodeInput")));
        bindAuth.setComments(bindAuthMapInfo.get("comments") == null ? "" : String.valueOf(bindAuthMapInfo.get("comments")));
        FormDesignUtil.setSimpleObj4Import((List)((List)bindAuthMapInfo.get("showFieldList")), (List)bindAuth.getShowFieldList(), (boolean)false, (BusinessDataBean)businessDataBean, (boolean)true);
        FormDesignUtil.setSimpleObj4Import((List)((List)bindAuthMapInfo.get("orderByList")), (List)bindAuth.getOrderByList(), (boolean)false, (BusinessDataBean)businessDataBean, (boolean)true);
        FormDesignUtil.setSimpleObj4Import((List)((List)bindAuthMapInfo.get("searchFieldList")), (List)bindAuth.getSearchFieldList(), (boolean)true, (BusinessDataBean)businessDataBean, (boolean)true);
        FormDesignUtil.setSimpleObj4Import((List)((List)bindAuthMapInfo.get("authList")), (List)bindAuth.getAuthList(), (boolean)true, (BusinessDataBean)businessDataBean, (boolean)false);
        FormDesignUtil.setSimpleObj4Import((List)((List)bindAuthMapInfo.get("updateAuthList")), (List)bindAuth.getUpdateAuthList(), (boolean)true, (BusinessDataBean)businessDataBean, (boolean)false);
        FormDesignUtil.setSimpleObj4Import((List)((List)bindAuthMapInfo.get("customAuthList")), (List)bindAuth.getCustomAuthList(), (boolean)false, (BusinessDataBean)businessDataBean, (boolean)false);
        List authList = bindAuth.getAuthList();
        for (SimpleObjectBean simpleObjectBean : authList) {
            String[] fieldName;
            if (!FormBindAuthBean.AuthName.BATHUPDATE.getKey().equals(simpleObjectBean.getName()) || !Strings.isNotBlank((String)simpleObjectBean.getValue())) continue;
            String batchField = simpleObjectBean.getValue();
            HashSet<String> replaceTable = new HashSet<String>();
            for (String name : fieldName = batchField.split(",")) {
                String tableName;
                if (!name.contains(".") || replaceTable.contains(tableName = name.split("[.]")[0])) continue;
                replaceTable.add(tableName);
                batchField = batchField.replace(tableName, businessDataBean.getOldAndNewStringMap(tableName));
            }
            simpleObjectBean.setValue(batchField);
        }
        List moduleAuths = (List)bindAuthMapInfo.get("moduleAuthsList");
        List<FormModuleAuth> moduleAuthList = this.importModuleAuth(businessDataBean, moduleAuths, formBean);
        bindAuth.setModuleAuthList(moduleAuthList);
        Map formulaInfo = (Map)bindAuthMapInfo.get("formFormula");
        if (null != formulaInfo && formulaInfo.size() > 0 && formulaInfo.containsKey("value") && bindAuthMapInfo.containsKey("conditionFormula")) {
            Map formula = (Map)bindAuthMapInfo.get("conditionFormula");
            FormFormulaBean formFormulaBean = (FormFormulaBean)FormDesignUtil.getFormulaFromMap4Import((BusinessDataBean)businessDataBean, (Map)formula, (FormBean)formBean, (int)1, (boolean)false).get("bo");
            bindAuth.setFormFormulaBean(formFormulaBean);
        }
        if (bindAuthMapInfo.containsKey("customBtnList")) {
            List customBtnList = (List)bindAuthMapInfo.get("customBtnList");
            this.importCustomBtn(businessDataBean, customBtnList);
            bindAuth.setCustomBtnList(customBtnList);
        }
        for (SimpleObjectBean sim : bindAuth.getUpdateAuthList()) {
            Long oldBtnId = Long.valueOf(sim.getExtAttr("id"));
            Long newBtnId = businessDataBean.genNewIdByOldId(oldBtnId);
            sim.addExtAttr("id", newBtnId.toString());
        }
        if (bindAuthMapInfo.containsKey("btnShowOrderList")) {
            this.importBthShowOrder((List)bindAuthMapInfo.get("btnShowOrderList"), bindAuth.getBtnShowOrderList(), businessDataBean);
        } else {
            FormDesignUtil.upgradeBindAuth((FormBindAuthBean)bindAuth);
        }
    }

    private void importFlowBusinessBind(FormBindBean bindBean, Map<String, Object> bindInfo, BusinessDataBean businessDataBean, FormBean formBean) {
        String bindIdStr = String.valueOf(bindInfo.get("id"));
        Long oldBindId = Long.parseLong(bindIdStr);
        Long newId = businessDataBean.genNewIdByOldId(oldBindId);
        bindBean.setId(newId);
        List flowBusinessList = (List)bindInfo.get("flowBusinessList");
        if (Strings.isNotEmpty((Collection)flowBusinessList)) {
            for (Map flowBusinessMapInfo : flowBusinessList) {
                FormFlowBusinessBean flowBusiness = new FormFlowBusinessBean();
                this.importFlowBusinessInfo(flowBusiness, flowBusinessMapInfo, businessDataBean, formBean);
                bindBean.getFlowBusinessMap().put(String.valueOf(flowBusiness.getId()), flowBusiness);
            }
        }
    }

    private void importFlowBusinessInfo(FormFlowBusinessBean flowBusiness, Map<String, Object> flowBusinessMapInfo, BusinessDataBean businessDataBean, FormBean formBean) {
        String bindAuthIdStr = String.valueOf(flowBusinessMapInfo.get("id"));
        Long oldBindAuthId = Long.parseLong(bindAuthIdStr);
        Long newId = businessDataBean.genNewIdByOldId(oldBindAuthId);
        flowBusiness.setId(newId);
        flowBusiness.setName(String.valueOf(flowBusinessMapInfo.get("name")));
        flowBusiness.setType(String.valueOf(flowBusinessMapInfo.get("type")));
        flowBusiness.setFormId(formBean.getId().longValue());
        flowBusiness.setCreator(AppContext.currentUserId());
        String timeStr = Datetimes.formatNoTimeZone((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss.S");
        flowBusiness.setCreateTime(timeStr);
        flowBusiness.setModifyTime(timeStr);
        flowBusiness.setComments(flowBusinessMapInfo.get("comments") == null ? "" : String.valueOf(flowBusinessMapInfo.get("comments")));
        FormDesignUtil.setSimpleObj4Import((List)((List)flowBusinessMapInfo.get("showFieldList")), (List)flowBusiness.getShowFieldList(), (boolean)false, (BusinessDataBean)businessDataBean, (boolean)true);
        FormDesignUtil.setSimpleObj4Import((List)((List)flowBusinessMapInfo.get("orderByList")), (List)flowBusiness.getOrderByList(), (boolean)false, (BusinessDataBean)businessDataBean, (boolean)true);
        FormDesignUtil.setSimpleObj4Import((List)((List)flowBusinessMapInfo.get("searchFieldList")), (List)flowBusiness.getSearchFieldList(), (boolean)true, (BusinessDataBean)businessDataBean, (boolean)true);
        FormDesignUtil.setSimpleObj4Import((List)((List)flowBusinessMapInfo.get("btnInfoList")), (List)flowBusiness.getBtnInfoList(), (boolean)true, (BusinessDataBean)businessDataBean, (boolean)true);
        String preConditionJson = flowBusinessMapInfo.get("preCondition").toString();
        List preConditionList = (List)JSONUtil.parseJSONString((String)preConditionJson, List.class);
        if (Strings.isNotEmpty((Collection)preConditionList)) {
            ArrayList<FormOperateConditionVo> preCondition = new ArrayList<FormOperateConditionVo>();
            for (Map pre : preConditionList) {
                FormFieldBean tempField;
                FormOperateConditionVo temp = new FormOperateConditionVo(pre);
                if (temp.isEmpty()) continue;
                if (temp.getLeftOperand().contains("field") && ((tempField = formBean.getFieldBeanByName(temp.getLeftOperand())).isEnumField() || tempField.isImageEnumField())) {
                    String oldEnum = temp.getRightOperand();
                    if (businessDataBean.isUpgrade() && Strings.isNotEmpty((String)oldEnum)) {
                        oldEnum = String.valueOf(businessDataBean.getRealId4Upgrade(Long.valueOf(oldEnum)));
                    }
                    String newEnumId = (String)businessDataBean.getEnumMapOld2New().get(oldEnum);
                    temp.setRightOperand(newEnumId);
                }
                preCondition.add(temp);
            }
            flowBusiness.setPreCondition(preCondition);
        }
        List moduleAuths = (List)flowBusinessMapInfo.get("moduleAuthsList");
        List<FormModuleAuth> moduleAuthList = this.importModuleAuth(businessDataBean, moduleAuths, formBean);
        flowBusiness.setModuleAuthList(moduleAuthList);
        if (flowBusinessMapInfo.containsKey("customBtnList")) {
            List customBtnList = (List)flowBusinessMapInfo.get("customBtnList");
            this.importCustomBtn(businessDataBean, customBtnList);
            flowBusiness.setCustomBtnList(customBtnList);
        }
        if (flowBusinessMapInfo.containsKey("btnShowOrderList")) {
            this.importBthShowOrder((List)flowBusinessMapInfo.get("btnShowOrderList"), flowBusiness.getBtnShowOrderList(), businessDataBean);
        }
    }

    private List<FormModuleAuth> importModuleAuth(BusinessDataBean businessDataBean, List<Map<String, Object>> moduleAuths, FormBean formBean) {
        ArrayList<FormModuleAuth> moduleAuthList = new ArrayList<FormModuleAuth>();
        if (Strings.isNotEmpty(moduleAuths)) {
            for (Map<String, Object> authMap : moduleAuths) {
                FormModuleAuth moduleAuth = new FormModuleAuth();
                moduleAuth.setId(businessDataBean.genNewIdByOldId(Long.valueOf(Long.parseLong(String.valueOf(authMap.get("id"))))));
                moduleAuth.setFormId(formBean.getId());
                String moduleName = String.valueOf(authMap.get("moduleName"));
                if (StringUtil.checkNull((String)moduleName)) {
                    moduleAuth.setModuleName(moduleName);
                }
                moduleAuth.setModuleType(Integer.valueOf(Integer.parseInt(String.valueOf(authMap.get("moduleType")))));
                moduleAuth.setState(Integer.valueOf(Integer.parseInt(String.valueOf(authMap.get("state")))));
                moduleAuth.setOrgType(Integer.valueOf(Integer.parseInt(String.valueOf(authMap.get("orgType")))));
                moduleAuth.putExtraAttr("showName", String.valueOf(authMap.get("showName")));
                moduleAuth.setOrgId(Long.valueOf(Long.parseLong(String.valueOf(authMap.get("orgId")))));
                Long oldModuleId = Long.parseLong(String.valueOf(authMap.get("moduleId")));
                Long newModuleId = businessDataBean.genNewIdByOldId(oldModuleId);
                moduleAuth.setModuleId(newModuleId);
                moduleAuthList.add(moduleAuth);
                businessDataBean.addFormModuleAuth(moduleAuth);
            }
        }
        return moduleAuthList;
    }

    private void importCustomBtn(BusinessDataBean businessDataBean, List<Map<String, Object>> customBtnList) {
        for (Map<String, Object> customBtn : customBtnList) {
            CommonBtn btn = FormFieldUtil.getCustomBtnById((String)customBtn.get("type").toString());
            if (btn == null) continue;
            Long oldBtnId = Long.valueOf(customBtn.get("id").toString().replace("customBtn_", ""));
            Long newBtnId = businessDataBean.genNewIdByOldId(oldBtnId);
            customBtn.put("id", newBtnId.toString());
        }
    }

    private void importBthShowOrder(List<Map<String, Object>> btnShowOrderMapListList, List<SimpleObjectBean> btnShowOrderList, BusinessDataBean businessDataBean) {
        FormDesignUtil.setSimpleObj4Import(btnShowOrderMapListList, btnShowOrderList, (boolean)false, (BusinessDataBean)businessDataBean, (boolean)false);
        for (SimpleObjectBean sim : btnShowOrderList) {
            String[] btnIdArr;
            String phoneValue;
            String value = sim.getValue();
            if (Strings.isNotEmpty((String)value)) {
                String[] btnIdArr2;
                String newValue = value;
                for (String btnId : btnIdArr2 = value.split(",")) {
                    if (!NumberUtils.isNumber((String)btnId)) continue;
                    Long oldBtnId = Long.valueOf(btnId);
                    Long newBtnId = businessDataBean.genNewIdByOldId(oldBtnId);
                    newValue = newValue.replace(btnId, String.valueOf(newBtnId));
                }
                sim.setValue(newValue);
            }
            if (!Strings.isNotEmpty((String)(phoneValue = sim.getValue()))) continue;
            String newValue = phoneValue;
            for (String btnId : btnIdArr = phoneValue.split(",")) {
                if (!NumberUtils.isNumber((String)btnId)) continue;
                Long oldBtnId = Long.valueOf(btnId);
                Long newBtnId = businessDataBean.genNewIdByOldId(oldBtnId);
                newValue = newValue.replace(btnId, String.valueOf(newBtnId));
            }
            sim.setPhoneValue(newValue);
        }
    }

    public void redirectForm(FormBean formBean, BusinessRedirectDataBean businessRedirectDataBean, BusinessDataBean businessDataBean) throws BusinessException {
        block7: {
            BusinessEnums.ExportType exportType = businessDataBean.getExportType();
            String locationType = "bind_";
            if (!exportType.getKey().equals(BusinessEnums.ExportType.APPLICATION.getKey())) break block7;
            HashMap<String, String> valueShareMap = new HashMap<String, String>();
            valueShareMap.put("formName", formBean.getFormName());
            if (!formBean.isFlowForm()) {
                valueShareMap.put("formType", Enums.FormType.unFlowForm.getValue());
                Map bindAuthBeanMap = formBean.getBind().getUnFlowTemplateMap();
                for (Map.Entry entry : bindAuthBeanMap.entrySet()) {
                    FormBindAuthBean bindAuthBean = (FormBindAuthBean)entry.getValue();
                    valueShareMap.put("templateName", bindAuthBean.getName());
                    List searchFieldList = bindAuthBean.getSearchFieldList();
                    if (Strings.isNotEmpty((Collection)searchFieldList)) {
                        this.redirectSearchFieldList(formBean, businessRedirectDataBean, searchFieldList, locationType, bindAuthBean.getId(), valueShareMap);
                    }
                    this.redirectModuleAuth(formBean, businessRedirectDataBean, businessDataBean, bindAuthBean.getModuleAuthList(), bindAuthBean.getId(), bindAuthBean.getName(), 0);
                    FormFormulaBean formulaBean = bindAuthBean.getFormFormulaBean();
                    if (formulaBean == null) continue;
                    HashMap<String, String> valueMap = new HashMap<String, String>();
                    valueMap.putAll(valueShareMap);
                    valueMap.put("location", ResourceUtil.getString((String)"form.binddesign.operrange.label"));
                    valueMap.put("detail", "");
                    FormDesignUtil.redirectFormulaBean((Long)formBean.getId(), (String)(locationType + bindAuthBean.getId().toString()), (FormFormulaBean)formulaBean, (BusinessRedirectDataBean)businessRedirectDataBean, valueMap, BusinessRedirectResultBean4Template.class);
                }
            } else {
                valueShareMap.put("formType", Enums.FormType.processesForm.getValue());
                Map flowBusinessBeanMap = formBean.getBind().getFlowBusinessMap();
                for (Map.Entry entry : flowBusinessBeanMap.entrySet()) {
                    FormFlowBusinessBean flowBusiness = (FormFlowBusinessBean)entry.getValue();
                    valueShareMap.put("templateName", flowBusiness.getName());
                    List searchFieldList = flowBusiness.getSearchFieldList();
                    if (Strings.isNotEmpty((Collection)searchFieldList)) {
                        this.redirectSearchFieldList(formBean, businessRedirectDataBean, searchFieldList, locationType, flowBusiness.getId(), valueShareMap);
                    }
                    this.redirectModuleAuth(formBean, businessRedirectDataBean, businessDataBean, flowBusiness.getModuleAuthList(), flowBusiness.getId(), flowBusiness.getName(), 1);
                    List preConditionList = flowBusiness.getPreCondition();
                    if (!Strings.isNotEmpty((Collection)preConditionList)) continue;
                    for (FormOperateConditionVo preCon : preConditionList) {
                        FormFieldBean tempField;
                        if (!preCon.getLeftOperand().contains("field") || !(tempField = formBean.getFieldBeanByName(preCon.getLeftOperand())).isOrg()) continue;
                        String oldShow = preCon.getRightOperand().split(",")[0];
                        String orgType = preCon.getRightOperand().split(",")[1].split("\\|")[0];
                        String oldVal = preCon.getRightOperand().split(",")[1].split("\\|")[1];
                        BusinessRedirectResultBean4Template redirectResultBean = new BusinessRedirectResultBean4Template();
                        redirectResultBean.setSourceId(formBean.getId());
                        redirectResultBean.setLocation(locationType + flowBusiness.getId() + "_FlowBusiness_" + tempField.getName());
                        redirectResultBean.setOldValue4System(oldVal);
                        redirectResultBean.setOldValue4Show(oldShow);
                        String key = BusinessRedirectDataBean.createKey((String)orgType, (String)oldShow);
                        businessRedirectDataBean.addResultBean(key, (BusinessRedirectResultBean)redirectResultBean);
                        HashMap<String, String> valueMap = new HashMap<String, String>();
                        valueMap.put("location", ResourceUtil.getString((String)"form.binddesign.operrange.label"));
                        valueMap.put("detail", "");
                        valueMap.putAll(valueShareMap);
                        businessRedirectDataBean.addRedirectDetail(key, redirectResultBean.getCategory(), valueMap);
                    }
                }
            }
        }
    }

    private void redirectSearchFieldList(FormBean formBean, BusinessRedirectDataBean businessRedirectDataBean, List<SimpleObjectBean> searchFieldList, String locationType, Long ownerId, Map<String, String> valueShareMap) throws BusinessException {
        OrgManager orgManager = (OrgManager)AppContext.getBean((String)"orgManager");
        ArrayList<SimpleObjectBean> contFindField = new ArrayList<SimpleObjectBean>();
        for (SimpleObjectBean object : searchFieldList) {
            String[] oldVals;
            Map defaultObj;
            String oldValStr;
            FormFieldBean fieldBean;
            String fieldName = object.getName();
            if (fieldName.contains(".")) {
                fieldName = fieldName.split("[.]")[1];
            }
            if (null == (fieldBean = formBean.getFieldBeanByName(fieldName, true))) {
                contFindField.add(object);
                continue;
            }
            FormFieldComEnum comEnum = fieldBean.getInputTypeEnum();
            String extAttrStr = object.getExtAttr("defaultValJOSN");
            if (!comEnum.equals((Object)FormFieldComEnum.EXTEND_MEMBER) && !comEnum.equals((Object)FormFieldComEnum.EXTEND_MULTI_MEMBER) && !comEnum.equals((Object)FormFieldComEnum.EXTEND_DEPARTMENT) && !comEnum.equals((Object)FormFieldComEnum.EXTEND_MULTI_DEPARTMENT) && !comEnum.equals((Object)FormFieldComEnum.EXTEND_ACCOUNT) && !comEnum.equals((Object)FormFieldComEnum.EXTEND_MULTI_ACCOUNT) || StringUtil.checkNull((String)extAttrStr) || StringUtil.checkNull((String)(oldValStr = String.valueOf((defaultObj = (Map)JSONUtil.parseJSONString((String)extAttrStr, Map.class)).get("handOrgIds")))) || (oldVals = oldValStr.split(",")).length <= 0) continue;
            String[] oldShows = String.valueOf(defaultObj.get("defaultVal")).split("\u3001");
            String orgType = "";
            orgType = comEnum.equals((Object)FormFieldComEnum.EXTEND_MEMBER) || comEnum.equals((Object)FormFieldComEnum.EXTEND_MULTI_MEMBER) ? FormFieldComEnum.EXTEND_MEMBER.getKey() : (comEnum.equals((Object)FormFieldComEnum.EXTEND_DEPARTMENT) || comEnum.equals((Object)FormFieldComEnum.EXTEND_MULTI_DEPARTMENT) ? FormFieldComEnum.EXTEND_DEPARTMENT.getKey() : FormFieldComEnum.EXTEND_ACCOUNT.getKey());
            BusinessEnums.OrgRedirectOrgType t = BusinessEnums.OrgRedirectOrgType.getEnumByKey((String)orgType);
            orgType = t.getKey();
            int i = 0;
            for (String oldVal : oldVals) {
                V3xOrgEntity entity;
                Long oldValLong = 0L;
                String[] split = oldVal.split("[|]");
                oldValLong = split.length > 1 ? Long.valueOf(Long.parseLong(split[1])) : Long.valueOf(Long.parseLong(oldVal));
                if (FormFieldComEnum.EXTEND_MEMBER.getKey().equals(orgType) ? null != orgManager.getMemberById(oldValLong) : (FormFieldComEnum.EXTEND_DEPARTMENT.getKey().equals(orgType) ? null != orgManager.getDepartmentById(oldValLong) : (FormFieldComEnum.EXTEND_ACCOUNT.getKey().equals(orgType) ? null != orgManager.getAccountById(oldValLong) : null != (entity = orgManager.getEntityAnyType(oldValLong))))) continue;
                BusinessRedirectResultBean4Template redirectResultBean = new BusinessRedirectResultBean4Template();
                redirectResultBean.setSourceId(formBean.getId());
                redirectResultBean.setLocation(locationType + ownerId + "_defaultValJOSN_" + fieldBean.getDisplay());
                redirectResultBean.setOldValue4System(oldVal);
                String showVal = oldShows[i];
                ++i;
                redirectResultBean.setOldValue4Show(showVal);
                String key = BusinessRedirectDataBean.createKey((String)(split.length > 1 ? "BusinessDepartment" : orgType), (String)showVal);
                businessRedirectDataBean.addResultBean(key, (BusinessRedirectResultBean)redirectResultBean);
                HashMap<String, String> valueMap = new HashMap<String, String>();
                valueMap.put("location", ResourceUtil.getString((String)"form.binddesign.customersear.label"));
                valueMap.put("detail", fieldBean.getDisplay() + "." + ResourceUtil.getString((String)"com.cap.import.app.bind.query.item.default.value"));
                valueMap.putAll(valueShareMap);
                businessRedirectDataBean.addRedirectDetail(key, redirectResultBean.getCategory(), valueMap);
            }
        }
        searchFieldList.removeAll(contFindField);
    }

    private void redirectModuleAuth(FormBean formBean, BusinessRedirectDataBean businessRedirectDataBean, BusinessDataBean businessDataBean, List<FormModuleAuth> moduleAuthList, Long ownerId, String ownerName, Integer fromType) throws BusinessException {
        OrgManager orgManager = (OrgManager)AppContext.getBean((String)"orgManager");
        for (FormModuleAuth module : moduleAuthList) {
            V3xOrgEntity entity;
            FormModuleAuth moduleAuth = businessDataBean.getModuleAuthById(module.getId());
            if (moduleAuth == null) continue;
            String orgId = String.valueOf(moduleAuth.getOrgId());
            Long oldValLong = Long.parseLong(orgId);
            int orgType = moduleAuth.getOrgType();
            if (Enums.FormModuleAuthOrgType.Member.getKey() == orgType ? null != orgManager.getMemberById(oldValLong) : (Enums.FormModuleAuthOrgType.Department.getKey() == orgType ? null != orgManager.getDepartmentById(oldValLong) : (Enums.FormModuleAuthOrgType.Team.getKey() == orgType ? null != orgManager.getTeamById(oldValLong) : (Enums.FormModuleAuthOrgType.Level.getKey() == orgType ? null != orgManager.getLevelById(oldValLong) : (Enums.FormModuleAuthOrgType.Post.getKey() == orgType ? null != orgManager.getPostById(oldValLong) : null != (entity = orgManager.getEntityAnyType(oldValLong))))))) continue;
            String showName = String.valueOf(moduleAuth.getExtraAttr("showName"));
            if (StringUtil.checkNull((String)orgId) || StringUtil.checkNull((String)showName)) continue;
            BusinessRedirectResultBean4Authorization authorization = new BusinessRedirectResultBean4Authorization();
            authorization.setTemplateId(ownerId);
            if (0 == fromType) {
                authorization.setAuthorizationType(BusinessRedirectResultBean4Authorization.AuthorizationType.UNFLOW_TEMPLATE.name());
            } else {
                authorization.setAuthorizationType(BusinessRedirectResultBean4Authorization.AuthorizationType.FLOW_BUSINESS.name());
            }
            authorization.setSourceId(formBean.getId());
            authorization.setOldValue4Show(showName);
            authorization.setOldValue4System(orgId);
            Enums.FormModuleAuthOrgType type = Enums.FormModuleAuthOrgType.getFormModuleAuthOrgTypeByKey((int)moduleAuth.getOrgType());
            String key = BusinessRedirectDataBean.createKey((String)type.getText(), (String)showName);
            businessRedirectDataBean.addResultBean(key, (BusinessRedirectResultBean)authorization);
            HashMap<String, String> valueMap = new HashMap<String, String>();
            valueMap.put(BusinessEnums.AuthorizationDetailKey.LOCATION.getKey(), ResourceUtil.getString((String)"form.import.export.auth.details"));
            if (0 == fromType) {
                valueMap.put(BusinessEnums.AuthorizationDetailKey.TYPE.getKey(), ResourceUtil.getString((String)"com.cap.import.app.unflow.template.label") + "(" + formBean.getFormName() + ")");
            } else {
                valueMap.put(BusinessEnums.AuthorizationDetailKey.TYPE.getKey(), ResourceUtil.getString((String)"form.flow.business.label") + "(" + formBean.getFormName() + ")");
            }
            valueMap.put(BusinessEnums.AuthorizationDetailKey.AUTH_ITEM.getKey(), ownerName);
            businessRedirectDataBean.addRedirectDetail(key, authorization.getCategory(), valueMap);
        }
    }

    public void mergeRedirectData(Map<String, List<Map<String, Object>>> redirectData, FormBean formBean, AppUpgradeCacheBean appUpgradeCacheBean) throws BusinessException {
        List<Map<String, Object>> authRedirectMaps;
        Object bindAuthId;
        List formBeanList = appUpgradeCacheBean == null ? null : appUpgradeCacheBean.getAllForm();
        List<Map<String, Object>> redirectMapList = redirectData.get(BusinessEnums.RedirectCategory.TEMPLATE.getKey());
        if (!Strings.isEmpty(redirectMapList)) {
            for (Map<String, Object> orgMap : redirectMapList) {
                String newValue;
                String location = orgMap.get("location").toString();
                if (!location.startsWith("bind_")) continue;
                location = location.replace("bind_", "");
                String[] locationArr = location.split("_");
                bindAuthId = Long.valueOf(locationArr[0]);
                if (location.contains("_")) {
                    List searchFieldList;
                    FormFlowBusinessBean flowBusiness;
                    String oldValue = orgMap.get("oldValue4System").toString();
                    String oldName = orgMap.get("oldValue4Show").toString();
                    newValue = orgMap.get("newValue4System").toString();
                    String newName = orgMap.get("newValue4Show").toString();
                    String field = locationArr[2];
                    if (formBean.isFlowForm()) {
                        flowBusiness = formBean.getBind().getFlowBusinessById((Long)bindAuthId);
                        searchFieldList = flowBusiness.getSearchFieldList();
                    } else {
                        FormBindAuthBean bindAuthBean = formBean.getBind().getUnFlowTemplateById((Long)bindAuthId);
                        searchFieldList = bindAuthBean.getSearchFieldList();
                    }
                    if (Strings.isNotEmpty((Collection)searchFieldList)) {
                        String[] parts = oldValue.split("[|]");
                        if (parts.length > 1) {
                            oldValue = parts[1];
                        }
                        for (SimpleObjectBean object : searchFieldList) {
                            if (!object.getValue().equals(field)) continue;
                            String extAttrStr = object.getExtAttr("defaultValJOSN");
                            extAttrStr = extAttrStr.replace(oldValue, newValue).replace(oldName, newName);
                            object.addExtAttr("defaultValJOSN", extAttrStr);
                        }
                    }
                    if (!formBean.isFlowForm()) continue;
                    flowBusiness = formBean.getBind().getFlowBusinessById((Long)bindAuthId);
                    List preConditionList = flowBusiness.getPreCondition();
                    for (FormOperateConditionVo preCon : preConditionList) {
                        if (!preCon.getLeftOperand().equals(field)) continue;
                        String oldRight = preCon.getRightOperand();
                        String newRight = oldRight.replace(oldValue, newValue).replace(oldName, newName);
                        preCon.setRightOperand(newRight);
                    }
                    continue;
                }
                FormBindAuthBean bindAuthBean = formBean.getBind().getUnFlowTemplateById((Long)bindAuthId);
                FormFormulaBean formulaBean = bindAuthBean.getFormFormulaBean();
                if (formulaBean == null) continue;
                newValue = orgMap.get("newValue").toString();
                newValue = FormDesignUtil.splitRole4OrgRedirect((String)newValue)[1];
                formulaBean.updateFormula4BizRedirect(orgMap.get("oldValue").toString(), newValue, formBeanList);
            }
        }
        if (!Strings.isEmpty(authRedirectMaps = redirectData.get(BusinessEnums.RedirectCategory.AUTHORIZATION.getKey()))) {
            for (Map<String, Object> authRedirectMap : authRedirectMaps) {
                List moduleAuthList;
                String authType = String.valueOf(authRedirectMap.get("authorizationType"));
                if (StringUtil.checkNull((String)authType) || !authType.equals(BusinessRedirectResultBean4Authorization.AuthorizationType.UNFLOW_TEMPLATE.name()) && !authType.equals(BusinessRedirectResultBean4Authorization.AuthorizationType.FLOW_BUSINESS.name())) continue;
                bindAuthId = String.valueOf(authRedirectMap.get("templateId"));
                String oldOrgId = String.valueOf(authRedirectMap.get("oldValue4System"));
                if (StringUtil.checkNull((String)oldOrgId)) continue;
                String newOrgId = String.valueOf(authRedirectMap.get("newValue4System"));
                if (formBean.isFlowForm()) {
                    FormFlowBusinessBean flowBusiness = formBean.getBind().getFlowBusinessBean((String)bindAuthId);
                    moduleAuthList = flowBusiness.getModuleAuthList();
                } else {
                    FormBindAuthBean bindAuthBean = formBean.getBind().getFormBindAuthBean((String)bindAuthId);
                    moduleAuthList = bindAuthBean.getModuleAuthList();
                }
                for (FormModuleAuth moduleAuth : moduleAuthList) {
                    if (!String.valueOf(moduleAuth.getOrgId()).equals(oldOrgId)) continue;
                    moduleAuth.setOrgId(Long.valueOf(Long.parseLong(newOrgId)));
                }
            }
        }
    }

    public void compatibilityDetection(BusinessDataBean businessDataBean, CompatibilityDetectionResultBean resultBean, FormBean newFormBean, FormBean cacheFormBean) throws BusinessException {
        block8: {
            FormBindBean oldBind;
            if (cacheFormBean == null) break block8;
            FormBindBean newBind = newFormBean.getBind();
            FormBindBean oldBindInCache = cacheFormBean.getBind();
            try {
                oldBind = (FormBindBean)oldBindInCache.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new BusinessException((Throwable)e);
            }
            List<String> allUnFlowBindName = this.getAllUnFlowBindName(newFormBean);
            List<String> allFlowBusinessName = this.getAllFlowBusinessName(newFormBean);
            if (!newFormBean.isFlowForm()) {
                Map newUnFlowTemplateMap = newBind.getUnFlowTemplateMap();
                Map oldUnFlowTemplateMap = oldBind.getUnFlowTemplateMap();
                for (Map.Entry next : oldUnFlowTemplateMap.entrySet()) {
                    String key = (String)next.getKey();
                    FormBindAuthBean value = (FormBindAuthBean)next.getValue();
                    if (newUnFlowTemplateMap.containsKey(key)) {
                        List moduleAuthList = value.getModuleAuthList();
                        FormBindAuthBean formBindAuthBean = (FormBindAuthBean)newUnFlowTemplateMap.get(key);
                        formBindAuthBean.setModuleAuthList(moduleAuthList);
                        continue;
                    }
                    String newName = this.getNewName(allUnFlowBindName, value.getName());
                    value.setName(newName);
                    newUnFlowTemplateMap.put(key, value);
                }
            } else {
                Map newFlowBusinessMap = newBind.getFlowBusinessMap();
                Map oldFlowBusinessMap = oldBind.getFlowBusinessMap();
                for (Map.Entry next : oldFlowBusinessMap.entrySet()) {
                    String key = (String)next.getKey();
                    FormFlowBusinessBean value = (FormFlowBusinessBean)next.getValue();
                    if (newFlowBusinessMap.containsKey(key)) {
                        List moduleAuthList = value.getModuleAuthList();
                        FormFlowBusinessBean flowBusiness = (FormFlowBusinessBean)newFlowBusinessMap.get(key);
                        flowBusiness.setModuleAuthList(moduleAuthList);
                        continue;
                    }
                    String newName = this.getNewName(allFlowBusinessName, value.getName());
                    value.setName(newName);
                    newFlowBusinessMap.put(key, value);
                }
            }
        }
    }

    private List<String> getAllUnFlowBindName(FormBean formBean) {
        ArrayList<String> names = new ArrayList<String>();
        Map unFlowTemplateMap = formBean.getBind().getUnFlowTemplateMap();
        for (Map.Entry next : unFlowTemplateMap.entrySet()) {
            names.add(((FormBindAuthBean)next.getValue()).getName());
        }
        return names;
    }

    private List<String> getAllFlowBusinessName(FormBean formBean) {
        ArrayList<String> names = new ArrayList<String>();
        Map flowBusinessMap = formBean.getBind().getFlowBusinessMap();
        for (Map.Entry next : flowBusinessMap.entrySet()) {
            names.add(((FormFlowBusinessBean)next.getValue()).getName());
        }
        return names;
    }

    private String getNewName(List<String> conflictNames, String name) {
        if (conflictNames.contains(name)) {
            name = this.getNewName(conflictNames, name + "1");
        } else {
            conflictNames.add(name);
        }
        return name;
    }
}

