/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.importandexport;

import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormCheckRuleBean;
import com.seeyon.cap4.form.bean.FormConditionActionBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormFieldComEnum;
import com.seeyon.cap4.form.bean.FormFormulaBean;
import com.seeyon.cap4.form.bean.FormTableBean;
import com.seeyon.cap4.form.bean.fieldCtrl.FormFieldCtrl;
import com.seeyon.cap4.form.bean.fieldCtrl.FormFieldCustomCtrl;
import com.seeyon.cap4.form.bean.fieldCtrl.FormFieldUtil;
import com.seeyon.cap4.form.modules.importandexport.AbstractBusinessFormExportManager;
import com.seeyon.cap4.form.modules.importandexport.AppUpgradeCacheBean;
import com.seeyon.cap4.form.modules.importandexport.BusinessDataBean;
import com.seeyon.cap4.form.modules.importandexport.BusinessEnums;
import com.seeyon.cap4.form.modules.importandexport.BusinessRedirectDataBean;
import com.seeyon.cap4.form.modules.importandexport.BusinessRedirectResultBean4Form;
import com.seeyon.cap4.form.modules.importandexport.CompatibilityDetectionResultBean;
import com.seeyon.cap4.form.modules.importandexport.IncompatibleInfo4Field;
import com.seeyon.cap4.form.modules.importandexport.IncompatibleInfoBaseBean;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.form.util.FormDesignUtil;
import com.seeyon.ctp.common.ctpenumnew.manager.EnumManager;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.ctpenumnew.CtpEnum;
import com.seeyon.ctp.common.po.ctpenumnew.CtpEnumBean;
import com.seeyon.ctp.form.po.FormRelation;
import com.seeyon.ctp.util.StringUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDLong;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;

public class BusinessFormExportManager4FormField
extends AbstractBusinessFormExportManager {
    private final Log logger = CtpLogFactory.getLog(BusinessFormExportManager4FormField.class);
    private EnumManager enumManagerNew;
    private CAP4FormCacheManager cap4FormCacheManager;

    public String getKey() {
        return "field";
    }

    public Integer getSort() {
        return 1;
    }

    public void exportData(FormBean formBean, BusinessDataBean businessDataBean, Map<String, Object> formDataMap) throws BusinessException {
        formDataMap.put("fieldInfo", this.getFieldInfo4export(businessDataBean, formBean));
    }

    private Map<String, Object> getFieldInfo4export(BusinessDataBean businessDataBean, FormBean formBean) throws BusinessException {
        HashMap<String, Object> fieldInfoMap = new HashMap<String, Object>(2);
        FormTableBean mainTableBean = formBean.getMasterTableBean();
        fieldInfoMap.put("front_formmain", this.getTableJson4export(businessDataBean, formBean, mainTableBean));
        List subTables = formBean.getSubTableBean();
        ArrayList<Map<String, Object>> subJsonObj = new ArrayList<Map<String, Object>>();
        for (FormTableBean subTable : subTables) {
            subJsonObj.add(this.getTableJson4export(businessDataBean, formBean, subTable));
        }
        fieldInfoMap.put("formsons", subJsonObj);
        return fieldInfoMap;
    }

    public Map<String, Object> getTableJson4export(BusinessDataBean businessDataBean, FormBean formBean, FormTableBean tableBean) throws BusinessException {
        HashMap<String, Object> tableJsonMap = new HashMap<String, Object>();
        ArrayList<Map<String, Object>> fieldsMap = new ArrayList<Map<String, Object>>();
        String tempTableName = tableBean.getTableName() == null ? "" : tableBean.getTableName();
        String tempDisplay = tableBean.getDisplay() == null ? "" : tableBean.getDisplay();
        String tempTableType = tableBean.getTableType() == null ? "" : tableBean.getTableType();
        String tempOwnerTable = tableBean.getOwnerTable() == null ? "" : tableBean.getOwnerTable();
        String frontTabName = tableBean.getFrontTableName() == null ? "" : tableBean.getFrontTableName();
        Long id = tableBean.getId();
        if (BusinessEnums.ExportType.APPLICATION == businessDataBean.getExportType() && tableBean.getId() == null) {
            try {
                FormBean cloneBean = businessDataBean.getUpgradeFormBean(formBean.getId());
                if (cloneBean == null) {
                    cloneBean = (FormBean)formBean.clone();
                }
                FormTableBean cloneTableBean = cloneBean.getTableByTableName(tableBean.getTableName());
                cloneTableBean.setIdIfNew();
                tableJsonMap.put("id", "" + cloneTableBean.getId());
                businessDataBean.addUpgradeForm(cloneBean);
            }
            catch (CloneNotSupportedException e) {
                throw new BusinessException(ResourceUtil.getString((String)"com.app.export.app.clone.form.error.tips"), (Throwable)e);
            }
        }
        if (id != null) {
            tableJsonMap.put("id", "" + id);
        }
        tableJsonMap.put("tableName", tempTableName);
        tableJsonMap.put("display", tempDisplay);
        tableJsonMap.put("tableType", tempTableType);
        tableJsonMap.put("ownerTable", tempOwnerTable);
        tableJsonMap.put("frontTableName", frontTabName);
        if (!tableBean.isMainTable()) {
            tableJsonMap.put("emptyLineRule", tableBean.getEmptyLineRule());
            tableJsonMap.put("emptyLineFields", tableBean.getEmptyLineFields());
        }
        List fieldList = tableBean.getFields();
        for (FormFieldBean formFieldBean : fieldList) {
            fieldsMap.add(this.getFieldJson4export(businessDataBean, formBean, formFieldBean));
        }
        tableJsonMap.put("fieldInfo", fieldsMap);
        return tableJsonMap;
    }

    public Map<String, Object> getFieldJson4export(BusinessDataBean businessDataBean, FormBean formBean, FormFieldBean formFieldBean) throws BusinessException {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put("id", String.valueOf(businessDataBean.getRealId4Export(formFieldBean.getId())));
        result.put("name", formFieldBean.getName());
        String tempDisplayStr = formFieldBean.getDisplay() == null ? "" : formFieldBean.getDisplay();
        result.put("display", tempDisplayStr);
        result.put("fieldType", formFieldBean.getFieldType());
        result.put("type", formFieldBean.getInputType());
        String tempFormatType = formFieldBean.getFormatType() == null ? "" : formFieldBean.getFormatType();
        result.put("formatType", tempFormatType);
        String tempFieldLength = "";
        if (Strings.isNotBlank((String)formFieldBean.getFieldLength())) {
            tempFieldLength = formFieldBean.getFieldLength();
            if (Strings.isNotBlank((String)formFieldBean.getDigitNum())) {
                tempFieldLength = tempFieldLength + "," + formFieldBean.getDigitNum();
            }
        }
        result.put("fieldLength", tempFieldLength);
        if (formFieldBean.isCustomerCtrl()) {
            result.put("customParam", formFieldBean.getCustomParam());
            FormFieldCtrl formFieldCtrl = formFieldBean.getFieldCtrl();
            formFieldCtrl.getJson4Export(formBean, formFieldBean, businessDataBean, result);
            if (BusinessEnums.ExportType.APPLICATION == businessDataBean.getExportType()) {
                businessDataBean.addCustomCtrl(formFieldCtrl);
            }
        }
        result.put("desc", formFieldBean.getDesc());
        result.put("placeHolder", formFieldBean.getPlaceHolder());
        if (FormFieldComEnum.EXTEND_IMAGE.equals((Object)formFieldBean.getInputTypeEnum())) {
            result.put("maxImgSize", String.valueOf(formFieldBean.getMaxImgSize()));
        }
        if (formFieldBean.isEnumField()) {
            if (formFieldBean.getEnumId() == 0L) {
                this.logger.info((Object)("\u5bfc\u51fa\u5e94\u7528\u7684\u65f6\u5019\uff0c\u8868\u5355[" + formBean.getFormName() + "]\u5b57\u6bb5[" + formFieldBean.getDisplay() + "(" + formFieldBean.getName() + ")]\u679a\u4e3eid\u4e3a0\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\uff01"));
                throw new BusinessException(ResourceUtil.getString((String)"com.cap.export.app.field.enum.null.tips", (Object)formBean.getFormName(), (Object)formFieldBean.getDisplay()));
            }
            String enumParams = formFieldBean.getEnumParams();
            Long realEnumId = businessDataBean.getRealId4Export(Long.valueOf(formFieldBean.getEnumId()));
            CtpEnumBean ctpEnumBean = this.enumManagerNew.getEnum(realEnumId);
            if (null == ctpEnumBean) {
                this.logger.info((Object)("\u5bfc\u51fa\u7684\u65f6\u5019\uff0c\u8868\u5355\u3010" + formBean.getFormName() + "\u3011\u5b57\u6bb5[" + formFieldBean.getDisplay() + "](" + formFieldBean.getName() + ")\u679a\u4e3e\u5728\u7f13\u5b58\u4e2d\u627e\u4e0d\u5230\uff0c\u679a\u4e3eid=" + String.valueOf(realEnumId)));
                throw new BusinessException(ResourceUtil.getString((String)"com.cap.export.app.field.enum.null.tips", (Object)formBean.getFormName(), (Object)formFieldBean.getDisplay()));
            }
            if (formFieldBean.getEnumId() != realEnumId.longValue()) {
                enumParams = enumParams.replace(String.valueOf(formFieldBean.getEnumId()), String.valueOf(realEnumId));
            }
            result.put("enumInfo", enumParams);
            businessDataBean.addEnumsId(Long.valueOf(formFieldBean.getEnumId()));
        }
        if (formFieldBean.getFormRelation() != null) {
            result.put("relationInfo", formFieldBean.getFormRelation().toJson4export());
        }
        return result;
    }

    public void importData(FormBean formBean, BusinessDataBean businessDataBean, Map<String, Object> dataMap) throws BusinessException {
        Map fieldInfo = (Map)dataMap.get("fieldInfo");
        Map formMainInfo = (Map)fieldInfo.get("front_formmain");
        FormTableBean mainTableBean = new FormTableBean();
        this.importTableInfo(formBean, mainTableBean, businessDataBean, formMainInfo);
        formBean.getTableList().add(mainTableBean);
        List formsonInfos = (List)fieldInfo.get("formsons");
        if (null != formsonInfos && formsonInfos.size() > 0) {
            for (Map formsonInfo : formsonInfos) {
                FormTableBean subTableBean = new FormTableBean();
                subTableBean.setOwnerTable(mainTableBean.getTableName());
                this.importTableInfo(formBean, subTableBean, businessDataBean, formsonInfo);
                formBean.getTableList().add(subTableBean);
            }
        }
    }

    private void importTableInfo(FormBean formBean, FormTableBean formTableBean, BusinessDataBean businessDataBean, Map<String, Object> mainInfo) throws BusinessException {
        String oldIdStr;
        String tempTableName = (String)mainInfo.get("tableName");
        String tempDisplay = (String)mainInfo.get("display");
        String tempTableType = (String)mainInfo.get("tableType");
        String frontTabName = (String)mainInfo.get("frontTableName");
        String newTableName = (String)businessDataBean.getOldAndNewStringMap().get(tempTableName);
        String string = oldIdStr = mainInfo.get("id") == null ? null : mainInfo.get("id").toString();
        Long id = businessDataBean.isResetId() ? Long.valueOf(UUIDLong.longUUID()) : Long.valueOf(oldIdStr == null ? UUIDLong.longUUID() : Long.valueOf(oldIdStr));
        formTableBean.setId(id);
        if (businessDataBean.isUpgrade() && "true".equals(businessDataBean.getOldAndNewStringMap("isNew" + tempTableName))) {
            formTableBean.putExtraAttr("isNew", true);
        }
        formTableBean.setFormId(formBean.getId());
        formTableBean.setTableName(newTableName);
        formTableBean.setDisplay(tempDisplay);
        formTableBean.setTableType(tempTableType);
        formTableBean.setFrontTableName(frontTabName);
        Object emptyLineRule = mainInfo.get("emptyLineRule");
        if (emptyLineRule != null) {
            formTableBean.setEmptyLineRule(Integer.valueOf(emptyLineRule.toString()).intValue());
            formTableBean.setEmptyLineFields((List)mainInfo.get("emptyLineFields"));
        }
        List fieldInfoList = (List)mainInfo.get("fieldInfo");
        for (Map fieldInfo : fieldInfoList) {
            FormFieldBean fieldBean = new FormFieldBean();
            fieldBean.setOwnerTableName(formTableBean.getTableName());
            fieldBean.setOwnerTableDisplay(formTableBean.getDisplay());
            fieldBean.setOwnerTableIndex(formTableBean.getTableIndex());
            this.importFieldInfo(formBean, fieldBean, businessDataBean, fieldInfo);
            if (fieldBean.isConstantField()) continue;
            formTableBean.addFormField(fieldBean);
        }
    }

    private void importFieldInfo(FormBean formBean, FormFieldBean formFieldBean, BusinessDataBean businessDataBean, Map<String, Object> fieldInfo) throws BusinessException {
        Map relationInfo;
        String tempFieldLength;
        String tempId = (String)fieldInfo.get("id");
        Long oldFieldId = Long.parseLong(tempId);
        if (businessDataBean.isResetId()) {
            formFieldBean.setId(businessDataBean.genNewIdByOldId(oldFieldId));
        } else {
            if (businessDataBean.isUpgrade()) {
                oldFieldId = businessDataBean.getRealId4Upgrade(oldFieldId);
            }
            FormFieldBean oldFieldBean = this.cap4FormCacheManager.getField(oldFieldId);
            boolean conflict = false;
            if (oldFieldBean != null) {
                FormBean tempBean = this.cap4FormCacheManager.getFormByFormTableName(oldFieldBean.getOwnerTableName());
                conflict = !businessDataBean.isUpgrade() || !formBean.getId().equals(tempBean.getId());
            }
            formFieldBean.setId(businessDataBean.genNewIdByOldId(oldFieldId, conflict, false));
        }
        String tempName = (String)fieldInfo.get("name");
        formFieldBean.setName(tempName);
        String tempDisplay = (String)fieldInfo.get("display");
        tempDisplay = tempDisplay == null ? "" : tempDisplay;
        formFieldBean.setDisplay(tempDisplay);
        String tempFieldType = (String)fieldInfo.get("fieldType");
        formFieldBean.setFieldType(tempFieldType);
        String tempType = (String)fieldInfo.get("type");
        formFieldBean.setInputType(tempType);
        String tempFormatType = (String)fieldInfo.get("formatType");
        tempFormatType = tempFormatType == null ? "" : tempFormatType;
        formFieldBean.setFormatType(tempFormatType);
        if (BusinessEnums.ExportType.APPLICATION.getKey().equals(businessDataBean.getFrom()) && !formBean.isFlowForm() && FormFieldComEnum.FLOWDEALOPITION == formFieldBean.getInputTypeEnum()) {
            formFieldBean.setInputType(FormFieldComEnum.TEXTAREA.getKey());
            formFieldBean.setFormatType("");
        }
        if (null != (tempFieldLength = (String)fieldInfo.get("fieldLength")) && Strings.isNotBlank((String)tempFieldLength)) {
            if (tempFieldLength.contains(",")) {
                String[] lengthInfo = tempFieldLength.split(",");
                formFieldBean.setFieldLength(lengthInfo[0]);
                formFieldBean.setDigitNum(lengthInfo[1]);
            } else {
                formFieldBean.setFieldLength(tempFieldLength);
            }
        }
        String tempDesc = (String)fieldInfo.get("desc");
        formFieldBean.setDesc(tempDesc);
        String tempPlaceHolder = (String)fieldInfo.get("placeHolder");
        formFieldBean.setPlaceHolder(tempPlaceHolder);
        String tempMaxImgSize = (String)fieldInfo.get("maxImgSize");
        if (FormFieldComEnum.EXTEND_IMAGE.equals((Object)formFieldBean.getInputTypeEnum())) {
            if (!StringUtil.checkNull((String)tempMaxImgSize)) {
                formFieldBean.setMaxImgSize(Integer.parseInt(tempMaxImgSize));
            } else {
                formFieldBean.setMaxImgSize(1);
            }
        }
        String tempEnumInfo = (String)fieldInfo.get("enumInfo");
        if (formFieldBean.isEnumField()) {
            CtpEnum ctpEnum;
            formFieldBean.setEnumParams(tempEnumInfo);
            if (formFieldBean.getEnumId() != 0L) {
                Long oldEnumId = formFieldBean.getEnumId();
                if (businessDataBean.isUpgrade()) {
                    oldEnumId = businessDataBean.getRealId4Upgrade(oldEnumId);
                }
                CtpEnumBean ctpEnum2 = this.enumManagerNew.getEnum(oldEnumId);
                boolean needRedirect = true;
                if (ctpEnum2 != null && ctpEnum2.getEnumtype() == 1) {
                    needRedirect = false;
                }
                if (needRedirect) {
                    String newEnumId = (String)businessDataBean.getEnumMapOld2New().get(String.valueOf(oldEnumId));
                    if (Strings.isBlank((String)newEnumId)) {
                        throw new BusinessException(ResourceUtil.getString((String)"com.cap.import.app.field.enum.null.tips", (Object)formBean.getFormName(), (Object)tempDisplay));
                    }
                    formFieldBean.setEnumId(Long.parseLong(newEnumId));
                }
            }
            if (BusinessEnums.ExportType.APPLICATION == businessDataBean.getExportType() && (ctpEnum = businessDataBean.getCtpEnumById(Long.valueOf(formFieldBean.getEnumId()))) != null) {
                HashMap<String, String> enumInfo4Display = new HashMap<String, String>(3);
                enumInfo4Display.put("formName", formBean.getFormName());
                enumInfo4Display.put("enumName", ctpEnum.getEnumname());
                String showFieldInfo = "[" + formFieldBean.getOwnerTableDisplay() + "]" + formFieldBean.getDisplay();
                enumInfo4Display.put("fieldName", showFieldInfo);
                businessDataBean.addEnumDetail4Display(enumInfo4Display);
            }
        }
        if (null != (relationInfo = (Map)fieldInfo.get("relationInfo")) && relationInfo.size() > 0) {
            this.importRelationInfo(formFieldBean, businessDataBean, relationInfo, formBean);
        } else if (businessDataBean.isUpgrade()) {
            formFieldBean.setFormRelation(null);
        }
        if (formFieldBean.isCustomerCtrl()) {
            FormFieldCustomCtrl formFieldCustomCtrl = FormFieldUtil.getCustomCtrlByKey((String)formFieldBean.getInputType());
            if (formFieldCustomCtrl == null || !formFieldCustomCtrl.isValid()) {
                formFieldBean.setInputType(FormFieldComEnum.TEXT.getKey());
                formFieldBean.setCustomParam("");
            } else {
                String tempCustomParam = (String)fieldInfo.get("customParam");
                if (null != tempCustomParam) {
                    formFieldBean.setCustomParam(tempCustomParam);
                }
                formFieldCustomCtrl.importExtInfo(formBean, formFieldBean, businessDataBean, fieldInfo);
            }
        }
        String mappingKey = String.valueOf(formBean.getId() + "_" + formFieldBean.getId());
        businessDataBean.addFieldBeanMap(mappingKey, formFieldBean.getName());
    }

    private void importRelationInfo(FormFieldBean formFieldBean, BusinessDataBean businessDataBean, Map<String, Object> relationInfo, FormBean formBean) {
        String tempTorelationattrtype;
        FormRelation formRelation = new FormRelation();
        Long oldId = Long.parseLong((String)relationInfo.get("id"));
        Long newId = businessDataBean.genNewIdByOldId(oldId, false, true);
        formRelation.setId(newId);
        String tempFromRelationObj = (String)relationInfo.get("fromrelationobj");
        String tempTorelationobj = (String)relationInfo.get("torelationobj");
        Long tempFormRelationObjId = Long.parseLong(tempFromRelationObj);
        Long tempTorelationObjId = Long.parseLong(tempTorelationobj);
        if (businessDataBean.isUpgrade()) {
            formRelation.setFromRelationObj(formBean.getId());
            formRelation.setToRelationObj(formBean.getId());
        } else {
            formRelation.setFromRelationObj(businessDataBean.genNewIdByOldId(tempFormRelationObjId));
            formRelation.setToRelationObj(businessDataBean.genNewIdByOldId(tempTorelationObjId));
        }
        String tempFromrelationattr = (String)relationInfo.get("fromrelationattr");
        formRelation.setFromRelationAttr(tempFromrelationattr);
        String tempTorelationobjtype = (String)relationInfo.get("torelationobjtype");
        if (!StringUtil.checkNull((String)tempTorelationobjtype)) {
            formRelation.setToRelationObjType(Integer.valueOf(Integer.parseInt(tempTorelationobjtype)));
        }
        if (!StringUtil.checkNull((String)(tempTorelationattrtype = (String)relationInfo.get("torelationattrtype")))) {
            formRelation.setToRelationAttrType(Integer.valueOf(Integer.parseInt(tempTorelationattrtype)));
        }
        String tempTorelationattr = (String)relationInfo.get("torelationattr");
        formRelation.setToRelationAttr(tempTorelationattr);
        String tempViewattr = (String)relationInfo.get("viewattr");
        formRelation.setViewAttr(tempViewattr);
        String tempVersion = (String)relationInfo.get("version");
        formRelation.setVersion(tempVersion);
        formFieldBean.setFormRelation(formRelation);
    }

    public void compatibilityDetection(BusinessDataBean businessDataBean, CompatibilityDetectionResultBean resultBean, FormBean newFormBean, FormBean cacheFormBean) throws BusinessException {
        if (null != cacheFormBean) {
            this.obtainFieldExceptComm(businessDataBean, newFormBean, cacheFormBean);
            newFormBean.setUniqueFieldList(cacheFormBean.getUniqueFieldList());
            FormTableBean cacheTableBean = cacheFormBean.getMasterTableBean();
            FormTableBean newImpTableBean = newFormBean.getMasterTableBean();
            List cacheFormSubTables = cacheFormBean.getSubTableBean();
            List newImpFormSubTables = newFormBean.getSubTableBean();
            ArrayList mergeTables = new ArrayList();
            for (FormTableBean formTableBean : cacheFormSubTables) {
                boolean sameId = false;
                Object sameIdSubTableBean = null;
                for (Object newImpSubTableBean : newImpFormSubTables) {
                    if (formTableBean.getId().longValue() != newImpSubTableBean.getId().longValue()) continue;
                    sameId = true;
                    sameIdSubTableBean = newImpSubTableBean;
                    break;
                }
                if (!sameId) {
                    try {
                        Object newImpSubTableBean;
                        List fields = formTableBean.getFields();
                        newImpSubTableBean = fields.iterator();
                        while (newImpSubTableBean.hasNext()) {
                            FormFieldBean fieldBean = (FormFieldBean)newImpSubTableBean.next();
                            FormFieldBean newImpFieldBean = newFormBean.getFieldBeanByDisplay(fieldBean.getDisplay());
                            if (null == newImpFieldBean) continue;
                            this.genIncompatibleInfo4Field(resultBean, CompatibilityDetectionResultBean.IncompatibleType.FIELD, ResourceUtil.getString((String)"cap.formDesign.ctrlSetting.fieldNameRule4", (Object)fieldBean.getDisplay()), cacheFormBean, newFormBean, fieldBean, newImpFieldBean);
                        }
                        FormTableBean cloneTableBean = (FormTableBean)formTableBean.clone();
                        newFormBean.addTable(cloneTableBean);
                        continue;
                    }
                    catch (CloneNotSupportedException e) {
                        this.logger.error((Object)e.getMessage(), (Throwable)e);
                        throw new BusinessException((Throwable)e);
                    }
                }
                HashMap<String, Object> oldAndNewTableBeanMap = new HashMap<String, Object>(2);
                oldAndNewTableBeanMap.put("cacheTableBean", formTableBean);
                oldAndNewTableBeanMap.put("newImpTableBean", sameIdSubTableBean);
                mergeTables.add(oldAndNewTableBeanMap);
            }
            this.mergeTableBeanAttr(businessDataBean, resultBean, cacheFormBean, newFormBean, cacheTableBean, newImpTableBean);
            for (Map map : mergeTables) {
                this.mergeTableBeanAttr(businessDataBean, resultBean, cacheFormBean, newFormBean, (FormTableBean)map.get("cacheTableBean"), (FormTableBean)map.get("newImpTableBean"));
            }
        } else {
            this.logger.info((Object)("\u672c\u5730\u73af\u5883\u5220\u9664\u6216\u8005\u4e91\u7aef\u589e\u52a0\u4e86\u8868\u5355\uff1a" + newFormBean.getId() + " " + newFormBean.getFormName()));
        }
    }

    private void obtainFieldExceptComm(BusinessDataBean businessDataBean, FormBean newImpFormBean, FormBean cacheFormBean) {
        List cacheAllFields = cacheFormBean.getAllFieldBeans();
        List newImpAllFields = newImpFormBean.getAllFieldBeans();
        Map<Long, FormFieldBean> cacheIdFieldMap = this.getIdFieldMap(cacheAllFields);
        Map<Long, FormFieldBean> newImpIdFieldMap = this.getIdFieldMap(newImpAllFields);
        Set<Long> cacheIdSet = cacheIdFieldMap.keySet();
        Set<Long> newImpIdSet = newImpIdFieldMap.keySet();
        ArrayList<FormFieldBean> cacheNotInCommonFields = new ArrayList<FormFieldBean>();
        ArrayList<FormFieldBean> newNotInCommonFields = new ArrayList<FormFieldBean>();
        for (Long cacheId : cacheIdSet) {
            if (newImpIdSet.contains(cacheId)) continue;
            cacheNotInCommonFields.add(cacheIdFieldMap.get(cacheId));
        }
        for (Long newFieldId : newImpIdSet) {
            if (cacheIdSet.contains(newFieldId)) continue;
            newNotInCommonFields.add(newImpIdFieldMap.get(newFieldId));
        }
        HashMap<String, ArrayList<FormFieldBean>> oldAndNewFormFieldExceptComm = new HashMap<String, ArrayList<FormFieldBean>>();
        oldAndNewFormFieldExceptComm.put("cacheFieldsExceptComm", cacheNotInCommonFields);
        oldAndNewFormFieldExceptComm.put("newFieldsExceptComm", newNotInCommonFields);
        businessDataBean.getOldAndnewFormFieldExceptComm().put(newImpFormBean.getId(), oldAndNewFormFieldExceptComm);
    }

    private Map<Long, FormFieldBean> getIdFieldMap(List<FormFieldBean> fields) {
        HashMap<Long, FormFieldBean> resultMap = new HashMap<Long, FormFieldBean>();
        for (FormFieldBean field : fields) {
            if (field.isConstantField()) continue;
            if (null != field.getId()) {
                resultMap.put(field.getId(), field);
                continue;
            }
            String msg = "table\uff1a" + field.getOwnerTableName() + "'s field " + field.getName() + "id is null";
            this.logger.error((Object)msg);
            throw new RuntimeException(msg);
        }
        return resultMap;
    }

    private void mergeTableBeanAttr(BusinessDataBean businessDataBean, CompatibilityDetectionResultBean resultBean, FormBean cacheFormBean, FormBean newImpFormBean, FormTableBean cacheTableBean, FormTableBean newImpTableBean) throws BusinessException {
        List cacheFieldBeans = cacheTableBean.getFields();
        List newImpFieldBeans = newImpTableBean.getFields();
        Map<Long, FormFieldBean> cacheIdFieldBeanMap = this.getIdFieldMap(cacheFieldBeans);
        Map<Long, FormFieldBean> newImpIdFieldBeanMap = this.getIdFieldMap(newImpFieldBeans);
        for (FormFieldBean cacheFieldBean : cacheFieldBeans) {
            FormFieldBean newImpFieldBean;
            if (newImpIdFieldBeanMap.containsKey(cacheFieldBean.getId())) {
                int newImpFieldLength;
                newImpFieldBean = newImpIdFieldBeanMap.get(cacheFieldBean.getId());
                if (!cacheFieldBean.getInputType().equals(newImpFieldBean.getInputType())) {
                    this.genIncompatibleInfo4Field(resultBean, CompatibilityDetectionResultBean.IncompatibleType.FIELD, ResourceUtil.getString((String)"com.cap.import.form.validate.ctrlnotsame"), cacheFormBean, newImpFormBean, cacheFieldBean, newImpFieldBean);
                    continue;
                }
                if (!cacheFieldBean.getFieldType().equals(newImpFieldBean.getFieldType())) {
                    this.genIncompatibleInfo4Field(resultBean, CompatibilityDetectionResultBean.IncompatibleType.FIELD, ResourceUtil.getString((String)"com.cap.import.form.validate.fieldtypenosame"), cacheFormBean, newImpFormBean, cacheFieldBean, newImpFieldBean);
                    continue;
                }
                if (cacheFieldBean.isEnumField() && newImpFieldBean.isEnumField() && (cacheFieldBean.getEnumId() != newImpFieldBean.getEnumId() || cacheFieldBean.getEnumLevel() != newImpFieldBean.getEnumLevel())) {
                    this.genIncompatibleInfo4Field(resultBean, CompatibilityDetectionResultBean.IncompatibleType.FIELD, ResourceUtil.getString((String)"com.cap.import.form.validate.enumnosame"), cacheFormBean, newImpFormBean, cacheFieldBean, newImpFieldBean);
                    continue;
                }
                int cacheFieldLength = StringUtil.checkNull((String)cacheFieldBean.getFieldLength()) ? 0 : Integer.parseInt(cacheFieldBean.getFieldLength());
                int n = newImpFieldLength = StringUtil.checkNull((String)newImpFieldBean.getFieldLength()) ? 0 : Integer.parseInt(newImpFieldBean.getFieldLength());
                if (Enums.FieldType.DECIMAL.getKey().equals(cacheFieldBean.getFieldType())) {
                    int cacheIntLength;
                    int cacheDigitLength = StringUtil.checkNull((String)cacheFieldBean.getDigitNum()) ? 0 : Integer.parseInt(cacheFieldBean.getDigitNum());
                    int newDigitLength = StringUtil.checkNull((String)newImpFieldBean.getDigitNum()) ? 0 : Integer.parseInt(newImpFieldBean.getDigitNum());
                    int newIntLength = newImpFieldLength - newDigitLength;
                    if (newIntLength < (cacheIntLength = cacheFieldLength - cacheDigitLength) || newDigitLength < cacheDigitLength) {
                        this.genIncompatibleInfo4Field(resultBean, CompatibilityDetectionResultBean.IncompatibleType.FIELD, ResourceUtil.getString((String)"com.cap.import.form.validate.lengthnosame"), cacheFormBean, newImpFormBean, cacheFieldBean, newImpFieldBean);
                        continue;
                    }
                } else if (cacheFieldLength != newImpFieldLength && newImpFieldLength < cacheFieldLength) {
                    this.genIncompatibleInfo4Field(resultBean, CompatibilityDetectionResultBean.IncompatibleType.FIELD, ResourceUtil.getString((String)"com.cap.import.form.validate.lengthnosame"), cacheFormBean, newImpFormBean, cacheFieldBean, newImpFieldBean);
                    continue;
                }
                if (cacheFieldBean.getInputType().equals(newImpFieldBean.getInputType()) && FormFieldComEnum.EXTEND_IMAGE.getKey().equals(cacheFieldBean.getFieldCtrl().getKey()) && cacheFieldBean.getMaxImgSize() > newImpFieldBean.getMaxImgSize()) {
                    this.genIncompatibleInfo4Field(resultBean, CompatibilityDetectionResultBean.IncompatibleType.FIELD, ResourceUtil.getString((String)"com.cap.import.form.validate.imgsizenosame"), cacheFormBean, newImpFormBean, cacheFieldBean, newImpFieldBean);
                    continue;
                }
                if (!cacheFieldBean.getDisplay().equals(newImpFieldBean.getDisplay())) {
                    this.genIncompatibleInfo4Field(resultBean, CompatibilityDetectionResultBean.IncompatibleType.FIELD, ResourceUtil.getString((String)"com.cap.import.form.validate.fieldnamenosame"), cacheFormBean, newImpFormBean, cacheFieldBean, newImpFieldBean);
                    continue;
                }
                if (cacheFieldBean.getName().equals(newImpFieldBean.getName())) continue;
                this.genIncompatibleInfo4Field(resultBean, CompatibilityDetectionResultBean.IncompatibleType.FIELD, ResourceUtil.getString((String)"com.cap.import.form.validate.fieldissame", (Object)newImpFieldBean.getName()), cacheFormBean, newImpFormBean, cacheFieldBean, newImpFieldBean);
                continue;
            }
            try {
                newImpFieldBean = newImpFormBean.getFieldBeanByName(cacheFieldBean.getName());
                if (null != newImpFieldBean) {
                    this.genIncompatibleInfo4Field(resultBean, CompatibilityDetectionResultBean.IncompatibleType.FIELD, ResourceUtil.getString((String)"com.cap.import.form.validate.fieldissame", (Object)newImpFieldBean.getName()), cacheFormBean, newImpFormBean, cacheFieldBean, newImpFieldBean);
                    continue;
                }
                FormFieldBean cloneField = (FormFieldBean)cacheFieldBean.clone();
                FormFieldBean newFieldBean = newImpFormBean.getFieldBeanByDisplay(cacheFieldBean.getDisplay());
                if (null != newFieldBean) {
                    this.genIncompatibleInfo4Field(resultBean, CompatibilityDetectionResultBean.IncompatibleType.FIELD, ResourceUtil.getString((String)"cap.formDesign.ctrlSetting.fieldNameRule4", (Object)cacheFieldBean.getDisplay()), cacheFormBean, newImpFormBean, cacheFieldBean, newFieldBean);
                }
                newImpTableBean.addFormField(cloneField);
            }
            catch (CloneNotSupportedException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BusinessException((Throwable)e);
            }
        }
        for (FormFieldBean newImpFieldBean : newImpFieldBeans) {
            if (cacheIdFieldBeanMap.containsKey(newImpFieldBean.getId())) continue;
            this.logger.info((Object)("\u5bfc\u5165\u8986\u76d6\u8868\u5355:" + cacheFormBean.getFormName() + ",\u7531\u4e8e\u672c\u5730\u5220\u9664\u4e86\u6216\u8005\u5916\u90e8\u65b0\u589e\uff0c\u4ece\u800c\u65b0\u589e\u5b57\u6bb5:" + newImpFieldBean.getDisplay()));
        }
    }

    private IncompatibleInfo4Field genIncompatibleInfo4Field(CompatibilityDetectionResultBean resultBean, CompatibilityDetectionResultBean.IncompatibleType type, String desc, FormBean cacheFormBean, FormBean newImpFormBean, FormFieldBean cacheFieldBean, FormFieldBean newImpFieldBean) {
        IncompatibleInfo4Field infoBean = new IncompatibleInfo4Field();
        infoBean.setDesc(desc);
        infoBean.setOldFormName(cacheFormBean.getFormName());
        infoBean.setNewFormName(newImpFormBean.getFormName());
        infoBean.setOldFieldDisplay(cacheFieldBean.getDisplay());
        infoBean.setNewFieldDisplay(newImpFieldBean.getDisplay());
        infoBean.setOldFieldType(cacheFieldBean.getFieldCtrl().getText());
        infoBean.setNewFieldType(newImpFieldBean.getFieldCtrl().getText());
        resultBean.addIncompatibleInfo(type, (IncompatibleInfoBaseBean)infoBean);
        return infoBean;
    }

    public void redirectForm(FormBean formBean, BusinessRedirectDataBean businessRedirectDataBean, BusinessDataBean businessDataBean) throws BusinessException {
        List checkRuleList;
        HashMap<String, String> valueShareMap = new HashMap<String, String>();
        valueShareMap.put("form", formBean.getFormName());
        String locationType = "formField_";
        FormCheckRuleBean checkRuleBean = formBean.getCheckRuleBean();
        List list = checkRuleList = checkRuleBean == null ? null : checkRuleBean.getCheckRuleList();
        if (Strings.isNotEmpty((Collection)checkRuleList)) {
            valueShareMap.put("type", ResourceUtil.getString((String)"cap.formDesign.setting.checkRule"));
            valueShareMap.put("location", "");
            valueShareMap.put("detail", "");
            for (FormConditionActionBean conditionBean : checkRuleList) {
                HashMap<String, String> valueMap;
                FormFormulaBean formulaBean = conditionBean.getConditionFormulaBean();
                if (formulaBean != null) {
                    valueMap = new HashMap<String, String>();
                    valueMap.putAll(valueShareMap);
                    FormDesignUtil.redirectFormulaBean((Long)formBean.getId(), (String)(locationType + conditionBean.getId() + "_" + formulaBean.getFormulaId()), (FormFormulaBean)formulaBean, (BusinessRedirectDataBean)businessRedirectDataBean, valueMap, BusinessRedirectResultBean4Form.class);
                }
                if ((formulaBean = conditionBean.getActionFormulaBean()) == null) continue;
                valueMap = new HashMap();
                valueMap.putAll(valueShareMap);
                FormDesignUtil.redirectFormulaBean((Long)formBean.getId(), (String)(locationType + conditionBean.getId() + "_" + formulaBean.getFormulaId()), (FormFormulaBean)formulaBean, (BusinessRedirectDataBean)businessRedirectDataBean, valueMap, BusinessRedirectResultBean4Form.class);
            }
        }
        valueShareMap.put("type", ResourceUtil.getString((String)"cap.formDesign.setting.ctrlAttrs"));
        valueShareMap.put("location", ResourceUtil.getString((String)"cap.formDesign.ctrlSetting.calculation"));
        for (FormFieldBean fieldBean : formBean.getAllFieldBeans()) {
            if (!Strings.isNotEmpty((Collection)fieldBean.getFormConditionList())) continue;
            if (fieldBean.isMasterField()) {
                valueShareMap.put("detail", "[" + ResourceUtil.getString((String)"cap.formDesign.ctrlArea.dataSource") + "][" + ResourceUtil.getString((String)"form.main.table.label") + "]" + fieldBean.getDisplay());
            } else {
                valueShareMap.put("detail", "[" + ResourceUtil.getString((String)"cap.formDesign.ctrlArea.dataSource") + "][" + ResourceUtil.getString((String)"form.detail.table.label") + "]" + fieldBean.getDisplay());
            }
            for (FormConditionActionBean fieldCondition : fieldBean.getFormConditionList()) {
                HashMap<String, String> valueMap;
                FormFormulaBean formulaBean = fieldCondition.getConditionFormulaBean();
                if (formulaBean != null) {
                    valueMap = new HashMap<String, String>();
                    valueMap.putAll(valueShareMap);
                    FormDesignUtil.redirectFormulaBean((Long)formBean.getId(), (String)(locationType + fieldCondition.getId() + "_" + formulaBean.getFormulaId().toString()), (FormFormulaBean)formulaBean, (BusinessRedirectDataBean)businessRedirectDataBean, valueMap, BusinessRedirectResultBean4Form.class);
                }
                if ((formulaBean = fieldCondition.getActionFormulaBean()) == null) continue;
                valueMap = new HashMap();
                valueMap.putAll(valueShareMap);
                FormDesignUtil.redirectFormulaBean((Long)formBean.getId(), (String)(locationType + fieldCondition.getId() + "_" + formulaBean.getFormulaId().toString()), (FormFormulaBean)formulaBean, (BusinessRedirectDataBean)businessRedirectDataBean, valueMap, BusinessRedirectResultBean4Form.class);
            }
        }
    }

    public void mergeRedirectData(Map<String, List<Map<String, Object>>> redirectData, FormBean formBean, AppUpgradeCacheBean appUpgradeCacheBean) throws BusinessException {
        List<Map<String, Object>> redirectMapList = redirectData.get("form");
        if (Strings.isEmpty(redirectMapList)) {
            return;
        }
        for (Map<String, Object> orgMap : redirectMapList) {
            List checkRuleList;
            String location = orgMap.get("location").toString();
            if (!location.startsWith("formField_")) continue;
            location = location.replace("formField_", "");
            String oldValue = orgMap.get("oldValue").toString();
            String newValue = orgMap.get("newValue").toString();
            newValue = FormDesignUtil.splitRole4OrgRedirect((String)newValue)[1];
            FormCheckRuleBean checkRuleBean = formBean.getCheckRuleBean();
            List list = checkRuleList = checkRuleBean == null ? null : checkRuleBean.getCheckRuleList();
            if (Strings.isNotEmpty((Collection)checkRuleList)) {
                for (FormConditionActionBean conditionBean : checkRuleList) {
                    FormDesignUtil.updateFormula4Redirect((String)location, (FormConditionActionBean)conditionBean, (String)oldValue, (String)newValue, (FormBean)formBean, (AppUpgradeCacheBean)appUpgradeCacheBean);
                }
            }
            for (FormFieldBean fieldBean : formBean.getAllFieldBeans()) {
                if (!Strings.isNotEmpty((Collection)fieldBean.getFormConditionList())) continue;
                for (FormConditionActionBean fieldCondition : fieldBean.getFormConditionList()) {
                    FormDesignUtil.updateFormula4Redirect((String)location, (FormConditionActionBean)fieldCondition, (String)oldValue, (String)newValue, (FormBean)formBean, (AppUpgradeCacheBean)appUpgradeCacheBean);
                }
            }
        }
    }

    public void setEnumManagerNew(EnumManager enumManagerNew) {
        this.enumManagerNew = enumManagerNew;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }
}

