/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.importandexport;

import com.seeyon.cap4.form.bean.FormAuthViewBean;
import com.seeyon.cap4.form.bean.FormAuthViewFieldBean;
import com.seeyon.cap4.form.bean.FormAuthorizationTableBean;
import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormConditionActionBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormFieldComEnum;
import com.seeyon.cap4.form.bean.FormFormulaBean;
import com.seeyon.cap4.form.bean.FormTableBean;
import com.seeyon.cap4.form.bean.FormViewBean;
import com.seeyon.cap4.form.modules.importandexport.AbstractBusinessFormExportManager;
import com.seeyon.cap4.form.modules.importandexport.AppUpgradeCacheBean;
import com.seeyon.cap4.form.modules.importandexport.BusinessDataBean;
import com.seeyon.cap4.form.modules.importandexport.BusinessEnums;
import com.seeyon.cap4.form.modules.importandexport.BusinessRedirectDataBean;
import com.seeyon.cap4.form.modules.importandexport.BusinessRedirectResultBean;
import com.seeyon.cap4.form.modules.importandexport.BusinessRedirectResultBean4Form;
import com.seeyon.cap4.form.modules.importandexport.CompatibilityDetectionResultBean;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.util.FormDesignUtil;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.filemanager.manager.FileManager;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.form.po.FormSerialNumber;
import com.seeyon.ctp.organization.bo.V3xOrgEntity;
import com.seeyon.ctp.organization.manager.OrgManager;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.FileUtil;
import com.seeyon.ctp.util.ParamUtil;
import com.seeyon.ctp.util.StringUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDLong;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;

public class BusinessFormExportManager4FormView
extends AbstractBusinessFormExportManager {
    private final Log LOGGER = CtpLogFactory.getLog(BusinessFormExportManager4FormView.class);
    public static final Pattern pattern = Pattern.compile("&createDate=(\\d*-\\d*-\\d*)&fileId=(-?\\d*)");
    private CAP4FormCacheManager cap4FormCacheManager;
    private FileManager fileManager;

    public String getKey() {
        return null;
    }

    public Integer getSort() {
        return 3;
    }

    public void exportData(FormBean formBean, BusinessDataBean businessDataBean, Map<String, Object> formDataMap) throws BusinessException {
        formDataMap.put("viewInfo", formBean.getViewInfo4Export(businessDataBean));
    }

    public void importData(FormBean formBean, BusinessDataBean businessDataBean, Map<String, Object> dataMap) throws BusinessException {
        Map viewInfo = (Map)dataMap.get("viewInfo");
        List pcViewList = (List)viewInfo.get("pcview");
        List mbViewList = (List)viewInfo.get("mbview");
        int i = 0;
        for (Map pcView : pcViewList) {
            FormViewBean pcViewBean = new FormViewBean();
            this.importViewInfo(pcViewBean, businessDataBean, pcView, formBean);
            pcViewBean.setFormBeanId(formBean.getId().longValue());
            pcViewBean.setSort(++i);
            formBean.getFormViewList().add(pcViewBean);
        }
        i = 0;
        for (Map mView : mbViewList) {
            FormViewBean mViewBean = new FormViewBean();
            this.importViewInfo(mViewBean, businessDataBean, mView, formBean);
            mViewBean.setSort(++i);
            mViewBean.setFormBeanId(formBean.getId().longValue());
            formBean.getFormViewList().add(mViewBean);
        }
    }

    public void compatibilityDetection(BusinessDataBean businessDataBean, CompatibilityDetectionResultBean resultBean, FormBean newFormBean, FormBean cacheFormBean) throws BusinessException {
        if (resultBean.getResultMap().size() == 0 && cacheFormBean != null) {
            Map stringListMap = (Map)businessDataBean.getOldAndnewFormFieldExceptComm().get(newFormBean.getId());
            List newFormFieldBeans = (List)stringListMap.get("newFieldsExceptComm");
            List oldFormFieldBeans = (List)stringListMap.get("cacheFieldsExceptComm");
            List newViewList = newFormBean.getFormViewList();
            List oldViewList = cacheFormBean.getFormViewList();
            List<String> viewNamesPC = this.getAllName(newFormBean, "viewPC");
            List<String> viewNamesMB = this.getAllName(newFormBean, "viewMB");
            for (FormViewBean oldFormViewBean : oldViewList) {
                if (newViewList.contains(oldFormViewBean)) {
                    this.formViewBeanMerge(businessDataBean, (FormViewBean)newViewList.get(newViewList.indexOf(oldFormViewBean)), oldFormViewBean, oldFormFieldBeans, newFormFieldBeans);
                    continue;
                }
                FormViewBean clone = null;
                try {
                    clone = (FormViewBean)oldFormViewBean.clone();
                }
                catch (CloneNotSupportedException e) {
                    throw new BusinessException((Throwable)e);
                }
                clone.setSort(newViewList.size() + 1);
                this.fieldListMerge(clone.getFieldList(), newFormFieldBeans);
                List operations = clone.getOperations();
                Iterator iterator = operations.iterator();
                while (iterator.hasNext()) {
                    FormAuthViewBean formAuthViewBean = (FormAuthViewBean)iterator.next();
                    this.formAuthViewBeanIncrease(formAuthViewBean, newFormFieldBeans);
                    this.subTableIncrease(newFormBean, formAuthViewBean);
                }
                List deleteOperations = clone.getDeleteOperations();
                for (FormAuthViewBean deleteFormAuthViewBean : deleteOperations) {
                    this.formAuthViewBeanIncrease(deleteFormAuthViewBean, newFormFieldBeans);
                    this.subTableIncrease(newFormBean, deleteFormAuthViewBean);
                }
                String newName = "seeyonform".equals(clone.getFormViewType()) ? this.getNewName(viewNamesPC, clone.getFormViewName()) : this.getNewName(viewNamesMB, clone.getFormViewName());
                clone.setFormViewName(newName);
                newViewList.add(clone);
            }
            for (FormViewBean formViewBean : newViewList) {
                if (oldViewList.contains(formViewBean)) continue;
                this.fieldListMerge(formViewBean.getFieldList(), oldFormFieldBeans);
                List operations = formViewBean.getOperations();
                for (FormAuthViewBean formAuthViewBean : operations) {
                    this.formAuthViewBeanIncrease(formAuthViewBean, oldFormFieldBeans);
                    this.subTableIncrease(newFormBean, formAuthViewBean);
                }
                List deleteOperations = formViewBean.getDeleteOperations();
                for (FormAuthViewBean deleteOperation : deleteOperations) {
                    this.formAuthViewBeanIncrease(deleteOperation, oldFormFieldBeans);
                    this.subTableIncrease(newFormBean, deleteOperation);
                }
            }
            this.dealDeleteOperations(newFormBean);
        }
    }

    private void dealDeleteOperations(FormBean formBean) {
        List formViewList = formBean.getFormViewList();
        for (FormViewBean formViewBean : formViewList) {
            List deleteOperations = formViewBean.getDeleteOperations();
            List operations = formViewBean.getOperations();
            for (FormAuthViewBean operation : operations) {
                if (!deleteOperations.contains(operation)) continue;
                deleteOperations.remove(operation);
            }
        }
    }

    private String getNewName(List<String> conflictNames, String name) {
        if (conflictNames.contains(name)) {
            name = this.getNewName(conflictNames, name + "1");
        } else {
            conflictNames.add(name);
        }
        return name;
    }

    private List<String> getAllViewAuthName(List<FormAuthViewBean> operations) {
        ArrayList<String> list = new ArrayList<String>();
        for (FormAuthViewBean formAuthViewBean : operations) {
            list.add(formAuthViewBean.getName());
        }
        return list;
    }

    private List<String> getAllName(FormBean formBean, String type) {
        ArrayList<String> list;
        block3: {
            block2: {
                list = new ArrayList<String>();
                if (!"viewPC".equals(type)) break block2;
                List formViewList = formBean.getFormViewList();
                for (FormViewBean formViewBean : formViewList) {
                    if (!"seeyonform".equals(formViewBean.getFormViewType())) continue;
                    list.add(formViewBean.getFormViewName());
                }
                break block3;
            }
            if (!"viewMB".equals(type)) break block3;
            List formViewList = formBean.getFormViewList();
            for (FormViewBean formViewBean : formViewList) {
                if (!"phone".equals(formViewBean.getFormViewType())) continue;
                list.add(formViewBean.getFormViewName());
            }
        }
        return list;
    }

    private void formViewBeanMerge(BusinessDataBean businessDataBean, FormViewBean newFormViewBean, FormViewBean oldFormViewBean, List<FormFieldBean> oldFormFieldBean, List<FormFieldBean> newFormFieldBean) throws BusinessException {
        List<FormAuthViewBean> formAuthViewBeans = this.formAuthViewBeanMerge(businessDataBean, newFormViewBean.getOperations(), oldFormViewBean.getOperations(), oldFormFieldBean, newFormFieldBean);
        List<FormAuthViewBean> deleteFormAuthViewBeans = this.formAuthViewBeanMerge(businessDataBean, newFormViewBean.getDeleteOperations(), oldFormViewBean.getDeleteOperations(), oldFormFieldBean, newFormFieldBean);
        this.fieldListMerge(newFormViewBean.getFieldList(), oldFormFieldBean);
        newFormViewBean.setOperations(formAuthViewBeans);
        newFormViewBean.setDeleteOperations(deleteFormAuthViewBeans);
        this.multiLanFormViewMerge(newFormViewBean, oldFormViewBean);
    }

    private void multiLanFormViewMerge(FormViewBean newFormViewBean, FormViewBean oldFormViewBean) throws BusinessException {
        Map newMultiLanFormViewMap = newFormViewBean.getMultiLanFormViewMap();
        Map oldMultiLanFormViewMap = oldFormViewBean.getMultiLanFormViewMap();
        for (Map.Entry next : oldMultiLanFormViewMap.entrySet()) {
            if (newMultiLanFormViewMap.containsKey(next.getKey())) continue;
            FormViewBean value = (FormViewBean)next.getValue();
            FormViewBean clone = null;
            try {
                clone = (FormViewBean)value.clone();
                newMultiLanFormViewMap.put(next.getKey(), clone);
            }
            catch (CloneNotSupportedException e) {
                throw new BusinessException((Throwable)e);
            }
        }
    }

    private void fieldListMerge(List<String> fieldList, List<FormFieldBean> fieldBeans) {
        for (FormFieldBean formFieldBean : fieldBeans) {
            fieldList.add(formFieldBean.getName());
        }
    }

    private List<FormAuthViewBean> formAuthViewBeanMerge(BusinessDataBean businessDataBean, List<FormAuthViewBean> newOperations, List<FormAuthViewBean> oldOperations, List<FormFieldBean> oldFormFieldBean, List<FormFieldBean> newFormFieldBean) {
        List<String> allViewAuthName = this.getAllViewAuthName(newOperations);
        for (FormAuthViewBean next : oldOperations) {
            if (newOperations.contains(next)) {
                this.formAuthMerge(businessDataBean, newOperations.get(newOperations.indexOf(next)), next, oldFormFieldBean);
                continue;
            }
            this.formAuthViewBeanIncrease(next, newFormFieldBean);
            String newName = this.getNewName(allViewAuthName, next.getName());
            next.setName(newName);
            newOperations.add(next);
        }
        for (FormAuthViewBean formAuthViewBean : newOperations) {
            if (oldOperations.contains(formAuthViewBean)) continue;
            this.formAuthViewBeanIncrease(formAuthViewBean, oldFormFieldBean);
        }
        return newOperations;
    }

    private void formAuthViewBeanIncrease(FormAuthViewBean sourceOperations, List<FormFieldBean> formFieldBeans) {
        if (formFieldBeans.size() == 0) {
            return;
        }
        Map fields = sourceOperations.getFields();
        for (FormFieldBean formFieldBean : formFieldBeans) {
            FormAuthViewFieldBean defaultFormAuthViewFieldBean = new FormAuthViewFieldBean(formFieldBean);
            fields.put(formFieldBean.getName(), defaultFormAuthViewFieldBean);
        }
    }

    private void subTableIncrease(FormBean formBean, FormAuthViewBean formAuthViewBean) {
        List subTableBean = formBean.getSubTableBean();
        Map tables = formAuthViewBean.getTables();
        HashMap map = new HashMap();
        for (FormTableBean next : subTableBean) {
            if (map.containsKey("my:" + next.getDisplay())) continue;
            FormAuthorizationTableBean formAuthorizationTableBean = new FormAuthorizationTableBean("my:" + next.getDisplay(), true, true, true, true, true, true);
            tables.put("my:" + next.getDisplay(), formAuthorizationTableBean);
        }
    }

    private FormAuthViewBean formAuthMerge(BusinessDataBean businessDataBean, FormAuthViewBean newFormAuthViewBean, FormAuthViewBean oldFormAuthViewBean, List<FormFieldBean> oldFormFieldBean) {
        Map newFields = newFormAuthViewBean.getFields();
        Map oldFields = oldFormAuthViewBean.getFields();
        int advanceAuthType = newFormAuthViewBean.getAdvanceAuthType();
        for (FormFieldBean formFieldBean : oldFormFieldBean) {
            if (newFields.containsKey(formFieldBean.getName())) continue;
            FormAuthViewFieldBean formAuthViewFieldBean = (FormAuthViewFieldBean)oldFields.get(formFieldBean.getName());
            if (advanceAuthType != -1) {
                formAuthViewFieldBean.setFormConditionActionBean(null);
            }
            newFields.put(formFieldBean.getName(), oldFields.get(formFieldBean.getName()));
        }
        if (advanceAuthType != 0 && advanceAuthType == 1) {
            Map newFieldConditionAuths = newFormAuthViewBean.getFieldConditionAuths();
            Map oldFieldConditionAuths = oldFormAuthViewBean.getFieldConditionAuths();
            for (Map.Entry next : oldFieldConditionAuths.entrySet()) {
                List value = (List)next.getValue();
                String key = (String)next.getKey();
                if (newFieldConditionAuths.containsKey(key)) continue;
                newFieldConditionAuths.put(key, value);
            }
        }
        Map newTables = newFormAuthViewBean.getTables();
        Map oldTables = oldFormAuthViewBean.getTables();
        for (Map.Entry next : oldTables.entrySet()) {
            String key = (String)next.getKey();
            FormAuthorizationTableBean value = (FormAuthorizationTableBean)next.getValue();
            if (newTables.containsKey(key)) continue;
            newTables.put(key, value);
        }
        return newFormAuthViewBean;
    }

    private void importViewInfo(FormViewBean viewBean, BusinessDataBean businessDataBean, Map<String, Object> viewInfo, FormBean formBean) throws BusinessException {
        List multiLanFormViews;
        boolean isFormImport = BusinessEnums.ExportType.FORM.getKey().equalsIgnoreCase(businessDataBean.getExportType().getKey());
        String idStr = (String)viewInfo.get("id");
        Long oldId = Long.parseLong(idStr);
        if (businessDataBean.isResetId()) {
            viewBean.setId(businessDataBean.genNewIdByOldId(oldId));
        } else {
            oldId = businessDataBean.getRealId4Upgrade(oldId);
            FormViewBean oldViewBean = this.cap4FormCacheManager.getView(oldId);
            boolean conflict = false;
            if (null != oldViewBean) {
                if (businessDataBean.isUpgrade()) {
                    if (oldViewBean.getFormBeanId() != formBean.getId().longValue()) {
                        conflict = true;
                    }
                } else {
                    conflict = true;
                }
            }
            viewBean.setId(businessDataBean.genNewIdByOldId(oldId, conflict, false));
        }
        viewBean.setFormViewName((String)viewInfo.get("name"));
        String type = (String)viewInfo.get("type");
        viewBean.setFormViewType(type);
        List fields = (List)viewInfo.get("fieldnames");
        if (Strings.isNotEmpty((Collection)fields)) {
            viewBean.getFieldList().addAll(fields);
        }
        viewBean.setSort(ParamUtil.getInt(viewInfo, (String)"sort").intValue());
        viewBean.setFormViewContent(this.importViewContent(idStr, businessDataBean, formBean));
        if (isFormImport) {
            viewBean.createFormAuthViewBean(formBean);
            for (FormAuthViewBean formAuthViewBean : viewBean.getOperations()) {
                formAuthViewBean.setDefaultAuth(formBean);
            }
        } else {
            List operations = (List)viewInfo.get("operations");
            for (Map operation : operations) {
                FormAuthViewBean authViewBean = new FormAuthViewBean();
                this.importFormAuthInfo(authViewBean, businessDataBean, operation, formBean, viewBean);
                viewBean.addAuthorizaton(authViewBean);
            }
        }
        if ((multiLanFormViews = (List)viewInfo.get("multiLanFormViews")) != null) {
            Map multiLanFormViewMap = viewBean.getMultiLanFormViewMap();
            for (Map multiLanFormView : multiLanFormViews) {
                FormViewBean lanViewBean = new FormViewBean();
                String lan = (String)multiLanFormView.get("lan");
                String viewId = (String)multiLanFormView.get("viewId");
                if (businessDataBean.isResetId()) {
                    lanViewBean.setId(Long.valueOf(UUIDLong.longUUID()));
                } else {
                    String id = (String)multiLanFormView.get("id");
                    lanViewBean.setId(Long.valueOf(Long.parseLong(id)));
                }
                String viewContent = this.importViewContent(viewId + lan, businessDataBean, formBean);
                lanViewBean.setFormViewContent(viewContent);
                String multiLangViewEmpty = (String)multiLanFormView.get("multiLangViewEmpty");
                if (Strings.isNotEmpty((String)multiLangViewEmpty)) {
                    lanViewBean.setMultiLangViewEmpty(Boolean.valueOf(multiLangViewEmpty).booleanValue());
                } else {
                    lanViewBean.setMultiLangViewEmpty(false);
                }
                String isDefault = (String)multiLanFormView.get("isDefault");
                if (Strings.isNotEmpty((String)isDefault)) {
                    lanViewBean.setDefault(Boolean.valueOf(isDefault).booleanValue());
                } else {
                    lanViewBean.setDefault(false);
                }
                multiLanFormViewMap.put(lan, lanViewBean);
            }
        }
    }

    private String importViewContent(String fileName, BusinessDataBean businessDataBean, FormBean formBean) throws BusinessException {
        File backgroundFolder;
        File viewFolder = businessDataBean.getViewFolder();
        File attachmentFolder = businessDataBean.getAttachmentFolder();
        File[] background = null;
        if (attachmentFolder != null && attachmentFolder.isDirectory() && null != (backgroundFolder = new File(attachmentFolder.getAbsoluteFile() + File.separator + "background")) && backgroundFolder.isDirectory()) {
            background = backgroundFolder.listFiles();
        }
        File[] files = viewFolder.listFiles();
        String uploadFolder = "";
        Date now = new Date(System.currentTimeMillis());
        String nowStr = DateUtil.format((Date)now, (String)"yyyy-MM-dd");
        try {
            uploadFolder = this.fileManager.getFolder(now, true);
        }
        catch (BusinessException e) {
            this.LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        for (File viewContentFile : files) {
            if (!viewContentFile.getName().equalsIgnoreCase(fileName + ".view")) continue;
            String tempContent = "";
            try {
                tempContent = FileUtils.readFileToString((File)viewContentFile, (String)"UTF-8");
            }
            catch (IOException e) {
                throw new BusinessException(ResourceUtil.getString((String)"com.cap.import.app.read.view.content.error.tips", (Object)formBean.getFormName()));
            }
            Matcher matcher = pattern.matcher(tempContent);
            StringBuffer sb = new StringBuffer();
            while (matcher.find()) {
                String oldFileName = matcher.group(2);
                Long newFileNameId = UUIDLong.longUUID();
                String newFileName = String.valueOf(newFileNameId);
                for (File att : background) {
                    if (!att.getName().equals(oldFileName)) continue;
                    businessDataBean.getOld2NewIdMap().put(Long.parseLong(oldFileName), newFileNameId);
                    File newAttFile = new File(uploadFolder + File.separator + newFileName);
                    try {
                        newAttFile.createNewFile();
                    }
                    catch (IOException e) {
                        this.LOGGER.error((Object)e.getMessage(), (Throwable)e);
                    }
                    FileUtil.copyFile((File)att, (File)newAttFile);
                    break;
                }
                matcher.appendReplacement(sb, "&createDate=" + nowStr + "&fileId=" + newFileName);
            }
            matcher.appendTail(sb);
            return sb.toString();
        }
        return null;
    }

    private void importFormAuthInfo(FormAuthViewBean authViewBean, BusinessDataBean businessDataBean, Map<String, Object> operation, FormBean formBean, FormViewBean formViewBean) {
        List highAuthMaps;
        List tableAuthMaps;
        String idStr = (String)operation.get("id");
        Long oldId = Long.parseLong(idStr);
        boolean conflict = false;
        if (businessDataBean.isResetId()) {
            authViewBean.setId(businessDataBean.genNewIdByOldId(oldId));
        } else {
            FormAuthViewBean oldAuthViewBean = this.cap4FormCacheManager.getAuth(oldId = businessDataBean.getRealId4Upgrade(oldId));
            if (null != oldAuthViewBean) {
                if (businessDataBean.isUpgrade()) {
                    if (oldAuthViewBean.getFormViewId() != formViewBean.getId().longValue()) {
                        conflict = true;
                    }
                } else {
                    conflict = true;
                }
            }
            authViewBean.setId(businessDataBean.genNewIdByOldId(oldId, conflict, false));
        }
        authViewBean.setFormViewId(formViewBean.getId().longValue());
        String nameStr = String.valueOf(operation.get("name"));
        String name = StringUtil.checkNull((String)nameStr) ? "" : nameStr;
        authViewBean.setName(name);
        String typeStr = String.valueOf(operation.get("type"));
        authViewBean.setType(typeStr);
        String pidStr = (String)operation.get("parentId");
        Long oldPid = Long.parseLong(pidStr);
        if (!oldPid.equals(0L)) {
            Long newPid = businessDataBean.genNewIdByOldId(oldPid);
            authViewBean.setParentId(newPid);
        } else {
            authViewBean.setParentId(oldPid);
        }
        String deleteStr = String.valueOf(operation.get("delete"));
        if ("true".equalsIgnoreCase(deleteStr)) {
            authViewBean.setDelete(true);
        } else {
            authViewBean.setDelete(false);
        }
        String defaultStr = String.valueOf(operation.get("defaultAuth"));
        if ("true".equalsIgnoreCase(defaultStr)) {
            authViewBean.setDefaultAuth(true);
        } else {
            authViewBean.setDefaultAuth(false);
        }
        String advanceAuthTypeStr = String.valueOf(operation.get("advanceAuthType"));
        authViewBean.setAdvanceAuthType(Integer.parseInt(advanceAuthTypeStr));
        String conditionIdStr = String.valueOf(operation.get("conditionId"));
        if (operation.get("conditionId") != null && !"0".equals(conditionIdStr)) {
            authViewBean.setFormConditionActionBean(FormDesignUtil.getFormulaActionBean4AuthRedirect((BusinessDataBean)businessDataBean, (Long)authViewBean.getId(), (Long)Long.parseLong(conditionIdStr), (boolean)conflict));
        }
        List fieldMaps = (List)operation.get("fields");
        for (Object fieldInfoMap : fieldMaps) {
            FormAuthViewFieldBean fieldAuthBean = new FormAuthViewFieldBean();
            this.importFormAuthFieldBean(fieldAuthBean, (Map<String, Object>)fieldInfoMap, businessDataBean, formBean, formViewBean, authViewBean, conflict);
            authViewBean.getFields().put(fieldAuthBean.getFieldName(), fieldAuthBean);
        }
        List fieldConditionAuths = (List)operation.get("fieldConditionAuths");
        if (Strings.isNotEmpty((Collection)fieldConditionAuths)) {
            for (Object fieldInfoMap : fieldConditionAuths) {
                FormAuthViewFieldBean conditionAuth = new FormAuthViewFieldBean();
                this.importFormAuthFieldBean(conditionAuth, (Map<String, Object>)fieldInfoMap, businessDataBean, formBean, formViewBean, authViewBean, conflict);
                authViewBean.addConditionAuthFieldBean(conditionAuth);
            }
        }
        if (Strings.isNotEmpty((Collection)(tableAuthMaps = (List)operation.get("tables")))) {
            for (Map tableAuthMap : tableAuthMaps) {
                String tName = String.valueOf(tableAuthMap.get("tableName"));
                if (Strings.isNotEmpty((String)ParamUtil.getString((Map)tableAuthMap, (String)"add"))) {
                    boolean add = "true".equalsIgnoreCase(String.valueOf(tableAuthMap.get("add")));
                    boolean copy = "true".equalsIgnoreCase(String.valueOf(tableAuthMap.get("copy")));
                    boolean delete = "true".equalsIgnoreCase(String.valueOf(tableAuthMap.get("delete")));
                    boolean deleteAll = "true".equalsIgnoreCase(String.valueOf(tableAuthMap.get("deleteAll")));
                    boolean importData = "true".equalsIgnoreCase(String.valueOf(tableAuthMap.get("importData")));
                    boolean exportData = "true".equalsIgnoreCase(String.valueOf(tableAuthMap.get("exportData")));
                    authViewBean.addFormAuthorizationTable(tName, add, copy, delete, deleteAll, importData, exportData);
                    continue;
                }
                boolean allowAdd = "true".equalsIgnoreCase(String.valueOf(tableAuthMap.get("allowAdd")));
                boolean allowDelete = "true".equalsIgnoreCase(String.valueOf(tableAuthMap.get("allowDelete")));
                authViewBean.addFormAuthorizationTable(tName, allowAdd, allowDelete);
            }
        }
        if (Strings.isNotEmpty((Collection)(highAuthMaps = (List)operation.get("auths")))) {
            for (Map highAuthMap : highAuthMaps) {
                FormAuthViewBean highAuth = new FormAuthViewBean();
                this.importFormAuthInfo(highAuth, businessDataBean, highAuthMap, formBean, formViewBean);
                highAuth.setParentId(authViewBean.getId());
                authViewBean.addConditonFormAuthViewBean(highAuth.getId(), highAuth);
            }
        }
    }

    private void importFormAuthFieldBean(FormAuthViewFieldBean authViewFieldBean, Map<String, Object> info, BusinessDataBean businessDataBean, FormBean formBean, FormViewBean formViewBean, FormAuthViewBean formAuthViewBean, boolean conflict) {
        Object showNameObj;
        Object defaultValTypeObj;
        Object defaultValObj;
        String idStr = String.valueOf(info.get("id"));
        if (StringUtil.checkNull((String)idStr)) {
            authViewFieldBean.setId(Long.valueOf(0L));
        } else {
            authViewFieldBean.setId(Long.valueOf(Long.parseLong(idStr)));
        }
        authViewFieldBean.setFieldName(String.valueOf(info.get("fieldName")));
        FormFieldBean formFieldBean = formBean.getFieldBeanByName(authViewFieldBean.getFieldName());
        authViewFieldBean.setFormFieldBean(formFieldBean);
        authViewFieldBean.setAccess(String.valueOf(info.get("access")));
        authViewFieldBean.setIsNotNull(Integer.parseInt(String.valueOf(info.get("isNotNull"))));
        String formulaIdStr = (String)info.get("formulaId");
        if (info.get("formulaId") != null && !"0".equals(formulaIdStr)) {
            authViewFieldBean.setFormConditionActionBean(FormDesignUtil.getFormulaActionBean4AuthRedirect((BusinessDataBean)businessDataBean, (Long)authViewFieldBean.getId(), (Long)Long.parseLong(formulaIdStr), (boolean)conflict));
        }
        authViewFieldBean.setIsInitNull(Integer.parseInt(String.valueOf(info.get("isInitNull"))));
        if (authViewFieldBean.getIsInitNull() == 1) {
            formAuthViewBean.setContainInitNull(true);
        }
        if (null != (defaultValObj = info.get("defaultValue"))) {
            authViewFieldBean.setDefaultValue(String.valueOf(defaultValObj));
        }
        if (null != (defaultValTypeObj = info.get("defaultValueType"))) {
            authViewFieldBean.setDefaultValueType(String.valueOf(defaultValTypeObj));
        }
        if (null != (showNameObj = info.get("showName"))) {
            authViewFieldBean.setShowName(String.valueOf(showNameObj));
        }
        if (authViewFieldBean.isSerialNumberDefaultValue()) {
            FormSerialNumber formSerialNumber;
            if (formFieldBean != null && !formFieldBean.isSn() && !formAuthViewBean.isDelete()) {
                formFieldBean.setSn(true);
            }
            Long oldSerialId = Long.valueOf(authViewFieldBean.getDefaultValue());
            if (businessDataBean.isUpgrade()) {
                oldSerialId = businessDataBean.getRealId4Upgrade(oldSerialId);
            }
            Long newSerialId = businessDataBean.genNewIdByOldId(oldSerialId);
            authViewFieldBean.setDefaultValue(String.valueOf(newSerialId));
            String newSerialName = businessDataBean.getOldAndNewStringMap(authViewFieldBean.getShowName());
            authViewFieldBean.setShowName(newSerialName);
            if (formAuthViewBean.isBaseAuth() && BusinessEnums.ExportType.APPLICATION == businessDataBean.getExportType() && formFieldBean != null && (formSerialNumber = businessDataBean.getSerialNumberByName(newSerialName)) != null) {
                String needDisplay;
                String string = needDisplay = formSerialNumber.getExtraAttr("needDisplay") == null ? "true" : formSerialNumber.getExtraAttr("needDisplay").toString();
                if ("true".equals(needDisplay)) {
                    HashMap<String, String> serialNumDetail = new HashMap<String, String>(4);
                    serialNumDetail.put("formName", formBean.getFormName());
                    serialNumDetail.put("serialNumName", newSerialName);
                    String fieldInfo = "[" + formFieldBean.getOwnerTableDisplay() + "]" + formFieldBean.getDisplay();
                    serialNumDetail.put("fieldName", fieldInfo);
                    StringBuilder location = new StringBuilder(formViewBean.isPc() ? ResourceUtil.getString((String)"form.view.type.pc.label") : ResourceUtil.getString((String)"form.view.type.phone.label"));
                    location.append(".").append(formViewBean.getFormViewName()).append("-").append(formAuthViewBean.getName()).append("-").append(ResourceUtil.getString((String)"com.cap.import.app.default.value.label"));
                    serialNumDetail.put("location", location.toString());
                    businessDataBean.addSerialNumDetail4Display(serialNumDetail);
                }
            }
        } else if (authViewFieldBean.isEnumDefaultValue()) {
            String newDefaultValue;
            Long oldEnumValue = Long.valueOf(authViewFieldBean.getDefaultValue());
            if (businessDataBean.isUpgrade()) {
                oldEnumValue = businessDataBean.getRealId4Upgrade(oldEnumValue);
            }
            if (Strings.isNotBlank((String)(newDefaultValue = (String)businessDataBean.getEnumMapOld2New().get(String.valueOf(oldEnumValue))))) {
                authViewFieldBean.setDefaultValue(newDefaultValue);
            }
        }
    }

    public void redirectForm(FormBean formBean, BusinessRedirectDataBean businessRedirectDataBean, BusinessDataBean businessDataBean) throws BusinessException {
        HashMap<String, String> valueShareMap = new HashMap<String, String>();
        valueShareMap.put("form", formBean.getFormName());
        valueShareMap.put("type", ResourceUtil.getString((String)"form.oper.formoperflag.label"));
        String locationType = "formView_";
        List authViewList = formBean.getAllFormAuthViewBeans();
        OrgManager orgManager = (OrgManager)AppContext.getBean((String)"orgManager");
        for (FormAuthViewBean authViewBean : authViewList) {
            Map fields = authViewBean.getFields();
            for (Map.Entry entry : fields.entrySet()) {
                String fieldName = (String)entry.getKey();
                FormFieldBean formFieldBean = formBean.getFieldBeanByName(fieldName, true);
                if (formFieldBean == null) continue;
                FormFieldComEnum comEnum = formFieldBean.getInputTypeEnum();
                FormAuthViewFieldBean value = (FormAuthViewFieldBean)entry.getValue();
                String defaultValue = value.getDefaultValue();
                String showName = value.getShowName();
                if (!comEnum.equals((Object)FormFieldComEnum.EXTEND_MEMBER) && !comEnum.equals((Object)FormFieldComEnum.EXTEND_MULTI_MEMBER) && !comEnum.equals((Object)FormFieldComEnum.EXTEND_DEPARTMENT) && !comEnum.equals((Object)FormFieldComEnum.EXTEND_MULTI_DEPARTMENT) && !comEnum.equals((Object)FormFieldComEnum.EXTEND_ACCOUNT) && !comEnum.equals((Object)FormFieldComEnum.EXTEND_MULTI_ACCOUNT) || StringUtils.isEmpty((CharSequence)defaultValue) || StringUtils.isEmpty((CharSequence)showName) || defaultValue.startsWith("org")) continue;
                String orgType = "";
                orgType = comEnum.equals((Object)FormFieldComEnum.EXTEND_MEMBER) || comEnum.equals((Object)FormFieldComEnum.EXTEND_MULTI_MEMBER) ? FormFieldComEnum.EXTEND_MEMBER.getKey() : (comEnum.equals((Object)FormFieldComEnum.EXTEND_DEPARTMENT) || comEnum.equals((Object)FormFieldComEnum.EXTEND_MULTI_DEPARTMENT) ? FormFieldComEnum.EXTEND_DEPARTMENT.getKey() : FormFieldComEnum.EXTEND_ACCOUNT.getKey());
                BusinessEnums.OrgRedirectOrgType t = BusinessEnums.OrgRedirectOrgType.getEnumByKey((String)orgType);
                orgType = t.getKey();
                String[] oldVals = defaultValue.split(",");
                if (oldVals.length <= 0) continue;
                String[] array = showName.split("\u3001");
                int i = 0;
                for (String oldVal : oldVals) {
                    V3xOrgEntity entity;
                    Long oldValLong = 0L;
                    String[] split = oldVal.split("[|]");
                    oldValLong = split.length > 1 ? Long.valueOf(Long.parseLong(split[1])) : Long.valueOf(Long.parseLong(oldVal));
                    if (FormFieldComEnum.EXTEND_MEMBER.getKey().equals(orgType) ? null != orgManager.getMemberById(oldValLong) : (FormFieldComEnum.EXTEND_DEPARTMENT.getKey().equals(orgType) ? null != orgManager.getDepartmentById(oldValLong) : (FormFieldComEnum.EXTEND_ACCOUNT.getKey().equals(orgType) ? null != orgManager.getAccountById(oldValLong) : null != (entity = orgManager.getEntityAnyType(oldValLong))))) continue;
                    BusinessRedirectResultBean4Form redirectResultBean = new BusinessRedirectResultBean4Form();
                    redirectResultBean.setSourceId(formBean.getId());
                    redirectResultBean.setLocation(locationType + authViewBean.getId() + "_" + (String)fieldName + "_" + formFieldBean.getDisplay() + "_initialValue");
                    redirectResultBean.setOldValue4System(oldVal);
                    showName = array[i];
                    redirectResultBean.setOldValue4Show(showName);
                    String key = BusinessRedirectDataBean.createKey((String)(split.length > 1 ? "BusinessDepartment" : orgType), (String)showName);
                    ++i;
                    businessRedirectDataBean.addResultBean(key, (BusinessRedirectResultBean)redirectResultBean);
                    HashMap<String, String> valueMap = new HashMap<String, String>();
                    valueMap.put("location", ResourceUtil.getString((String)"com.cap.import.app.default.value.label"));
                    valueMap.put("detail", formFieldBean.getDisplay() + "." + ResourceUtil.getString((String)"com.cap.import.app.default.value.label"));
                    valueMap.putAll(valueShareMap);
                    businessRedirectDataBean.addRedirectDetail(key, redirectResultBean.getCategory(), valueMap);
                }
            }
        }
        for (FormAuthViewBean authViewBean : authViewList) {
            FormViewBean formViewBean = formBean.getFormView(authViewBean.getFormViewId());
            String viewInfo = "[" + ResourceUtil.getString((String)"form.auth.save.as.view") + "]" + (formViewBean.isPc() ? ResourceUtil.getString((String)"form.view.type.pc.label") : ResourceUtil.getString((String)"form.view.type.phone.label"));
            valueShareMap.put("location", viewInfo + "." + authViewBean.getViewBean(formBean).getFormViewName() + "-" + authViewBean.getName());
            if (authViewBean.isApartSetAuth()) {
                Map partSetAuthMap = authViewBean.getFieldConditionAuths();
                for (Map.Entry entry : partSetAuthMap.entrySet()) {
                    FormFieldBean fieldBean;
                    List authViewFieldList = (List)entry.getValue();
                    if (!Strings.isNotEmpty((Collection)authViewFieldList) || (fieldBean = formBean.getFieldBeanByName((String)entry.getKey())) == null) continue;
                    if (fieldBean.isMasterField()) {
                        valueShareMap.put("detail", ResourceUtil.getString((String)"com.cap.import.app.auth.apart.set.label") + "-[" + ResourceUtil.getString((String)"form.base.mastertable.label") + "]" + fieldBean.getDisplay());
                    } else {
                        valueShareMap.put("detail", ResourceUtil.getString((String)"com.cap.import.app.auth.apart.set.label") + "-[" + ResourceUtil.getString((String)"formoper.dupform.label") + "]" + fieldBean.getDisplay());
                    }
                    for (FormAuthViewFieldBean viewFieldAuth : authViewFieldList) {
                        FormConditionActionBean authCondition = viewFieldAuth.getFormConditionActionBean();
                        FormFormulaBean formulaBean = authCondition.getConditionFormulaBean();
                        if (formulaBean == null) continue;
                        HashMap<String, String> valueMap = new HashMap<String, String>();
                        valueMap.putAll(valueShareMap);
                        String location = locationType + authViewBean.getId() + "_" + authCondition.getId() + "_" + formulaBean.getFormulaId().toString() + "_" + (String)entry.getKey();
                        FormDesignUtil.redirectFormulaBean((Long)formBean.getId(), (String)location, (FormFormulaBean)formulaBean, (BusinessRedirectDataBean)businessRedirectDataBean, valueMap, BusinessRedirectResultBean4Form.class);
                    }
                }
                continue;
            }
            valueShareMap.put("detail", ResourceUtil.getString((String)"com.cap.import.app.auth.unified.set.label"));
            for (Map.Entry entry : authViewBean.getAuths().entrySet()) {
                FormFormulaBean formulaBean;
                FormConditionActionBean formConditionActionBean = ((FormAuthViewBean)entry.getValue()).getFormConditionActionBean();
                if (formConditionActionBean == null || (formulaBean = formConditionActionBean.getConditionFormulaBean()) == null) continue;
                HashMap<String, String> valueMap = new HashMap<String, String>();
                valueMap.putAll(valueShareMap);
                FormDesignUtil.redirectFormulaBean((Long)formBean.getId(), (String)(locationType + authViewBean.getId() + "_" + formConditionActionBean.getId() + "_" + formulaBean.getFormulaId().toString()), (FormFormulaBean)formulaBean, (BusinessRedirectDataBean)businessRedirectDataBean, valueMap, BusinessRedirectResultBean4Form.class);
            }
        }
    }

    public void mergeRedirectData(Map<String, List<Map<String, Object>>> redirectData, FormBean formBean, AppUpgradeCacheBean appUpgradeCacheBean) throws BusinessException {
        List<Map<String, Object>> redirectMapList = redirectData.get("form");
        if (Strings.isEmpty(redirectMapList)) {
            return;
        }
        for (Map<String, Object> orgMap : redirectMapList) {
            String location = orgMap.get("location").toString();
            if (!location.startsWith("formView_")) continue;
            location = location.replace("formView_", "");
            String oldValue = orgMap.get("oldValue").toString();
            String newValue = orgMap.get("newValue").toString();
            newValue = FormDesignUtil.splitRole4OrgRedirect((String)newValue)[1];
            String[] locationArr = location.split("_");
            Long authViewId = Long.valueOf(locationArr[0]);
            FormAuthViewBean authViewBean = formBean.getAuthViewBeanById(authViewId);
            if (location.contains("initialValue")) {
                Map fields = authViewBean.getFields();
                String fieldName = String.valueOf(locationArr[1]);
                FormAuthViewFieldBean formAuthViewFieldBean = (FormAuthViewFieldBean)fields.get(fieldName);
                String showName = formAuthViewFieldBean.getShowName();
                String defaultValue = formAuthViewFieldBean.getDefaultValue();
                String oldValue4Show = orgMap.get("oldValue4Show").toString();
                String newValue4Show = orgMap.get("newValue4Show").toString();
                String oldValue4System = orgMap.get("oldValue4System").toString();
                String newValue4System = orgMap.get("newValue4System").toString();
                String newShowName = showName.replace(oldValue4Show, newValue4Show);
                String[] parts = oldValue4System.split("[|]");
                if (parts.length > 1) {
                    oldValue4System = parts[1];
                }
                String newDefaultValue = defaultValue.replace(oldValue4System, newValue4System);
                formAuthViewFieldBean.setDefaultValue(newDefaultValue);
                formAuthViewFieldBean.setShowName(newShowName);
                continue;
            }
            if (authViewBean.isApartSetAuth()) {
                List authViewFieldList = (List)authViewBean.getFieldConditionAuths().get(locationArr[3]);
                if (!Strings.isNotEmpty((Collection)authViewFieldList)) continue;
                for (FormAuthViewFieldBean viewFieldAuth : authViewFieldList) {
                    FormConditionActionBean authCondition = viewFieldAuth.getFormConditionActionBean();
                    if (authCondition == null) continue;
                    FormDesignUtil.updateFormula4Redirect((String)(locationArr[1] + "_" + locationArr[2]), (FormConditionActionBean)authCondition, (String)oldValue, (String)newValue, (FormBean)formBean, (AppUpgradeCacheBean)appUpgradeCacheBean);
                }
                continue;
            }
            for (Map.Entry entry : authViewBean.getAuths().entrySet()) {
                FormConditionActionBean authCondition = ((FormAuthViewBean)entry.getValue()).getFormConditionActionBean();
                if (authCondition == null) continue;
                FormDesignUtil.updateFormula4Redirect((String)(locationArr[1] + "_" + locationArr[2]), (FormConditionActionBean)authCondition, (String)oldValue, (String)newValue, (FormBean)formBean, (AppUpgradeCacheBean)appUpgradeCacheBean);
            }
        }
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public void setFileManager(FileManager fileManager) {
        this.fileManager = fileManager;
    }
}

