/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.importandexport;

import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.modules.importandexport.AbstractBusinessFormExportManager;
import com.seeyon.cap4.form.modules.importandexport.BusinessDataBean;
import com.seeyon.cap4.form.modules.importandexport.BusinessEnums;
import com.seeyon.cap4.form.modules.importandexport.CompatibilityDetectionResultBean;
import com.seeyon.cap4.form.util.FormDesignUtil;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.form.bean.FormSerialNumberBean;
import com.seeyon.ctp.form.modules.serialNumber.SerialNumberManager;
import com.seeyon.ctp.form.po.CtpFormula;
import com.seeyon.ctp.form.po.CtpFormulaCondition;
import com.seeyon.ctp.form.po.FormCustomFunction;
import com.seeyon.ctp.form.po.FormSerialNumber;
import com.seeyon.ctp.util.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BusinessFormExportManager4FormulaCondition
extends AbstractBusinessFormExportManager {
    private static final Pattern serialPattern = Pattern.compile("serialNumber\\s*\\(\\s*('|\")([^'\"]*)('|\")\\s*\\)");

    public String getKey() {
        return null;
    }

    public Integer getSort() {
        return 2;
    }

    public void exportData(FormBean formBean, BusinessDataBean businessDataBean, Map<String, Object> formDataMap) throws BusinessException {
        ArrayList ctpFormulaList = new ArrayList();
        List formulaConditionList = businessDataBean.getExportType() == BusinessEnums.ExportType.FORM ? formBean.getFormulaConditionList4Export() : formBean.getFormulaConditionList();
        ArrayList<Map> conditionListMap = new ArrayList<Map>();
        for (Object condition : formulaConditionList) {
            conditionListMap.add(FormDesignUtil.getFormulaConditionJsonMap4Export((CtpFormulaCondition)condition, ctpFormulaList, (BusinessDataBean)businessDataBean));
        }
        formDataMap.put("conditionInfo", conditionListMap);
        ArrayList<Map> formulaListMap = new ArrayList<Map>();
        for (CtpFormula formula : ctpFormulaList) {
            Map formulaMap = FormDesignUtil.getFormulaJsonMap4Export((FormBean)formBean, (CtpFormula)formula, null, (BusinessDataBean)businessDataBean);
            if (businessDataBean.getExportType() == BusinessEnums.ExportType.FORM) {
                this.getSerialNumberInFormula(businessDataBean, formulaMap.get("expression4Display").toString());
            }
            formulaListMap.add(formulaMap);
        }
        formDataMap.put("formulaInfo", formulaListMap);
        List customFunctionList = formBean.getCustomFunctionList();
        ArrayList customFuncListMap = new ArrayList();
        for (FormCustomFunction customFunc : customFunctionList) {
            HashMap<String, Object> customFuncMap = new HashMap<String, Object>();
            customFuncMap.put("id", customFunc.getId());
            customFuncMap.put("functionName", customFunc.getFunctionName());
            customFuncMap.put("functionParam", customFunc.getFunctionParam());
            customFuncMap.put("codeText", customFunc.getCodeText());
            customFuncMap.put("returnType", customFunc.getReturnType());
            customFuncMap.put("formId", customFunc.getFormId());
            customFuncMap.put("version", customFunc.getVersion());
            customFuncMap.put("auditState", customFunc.getAuditState());
            customFuncListMap.add(customFuncMap);
        }
        formDataMap.put("customFunction", customFuncListMap);
    }

    private void getSerialNumberInFormula(BusinessDataBean businessDataBean, String formulaDisplay) {
        Matcher matcher = serialPattern.matcher(formulaDisplay);
        SerialNumberManager serialNumberManager = (SerialNumberManager)AppContext.getBean((String)"serialNumberManager");
        while (matcher.find()) {
            String group = matcher.group();
            group = group.replace("\"", "'");
            String serialName = "";
            String[] strArr = group.split("'");
            if (strArr.length > 2) {
                serialName = strArr[1];
            }
            if (!Strings.isNotBlank((String)serialName)) continue;
            try {
                FormSerialNumberBean serialBean = serialNumberManager.querySerialNumberByName(serialName);
                if (serialBean == null) continue;
                boolean containTag = false;
                for (FormSerialNumber formSerialNumber : businessDataBean.getFormSerialNumberList()) {
                    if (!formSerialNumber.getId().equals(serialBean.getId())) continue;
                    containTag = true;
                    break;
                }
                if (containTag) continue;
                businessDataBean.getFormSerialNumberList().add(serialBean.toFormSerialNumber());
            }
            catch (Exception exception) {}
        }
    }

    public void importData(FormBean formBean, BusinessDataBean businessDataBean, Map<String, Object> dataMap) throws BusinessException {
        List conditionListMap;
        List formulaListMap = (List)dataMap.get("formulaInfo");
        if (Strings.isNotEmpty((Collection)formulaListMap)) {
            for (Object formulaMap : formulaListMap) {
                FormDesignUtil.getFormulaFromMap4Import((BusinessDataBean)businessDataBean, (Map)formulaMap, (FormBean)formBean, (int)1, (boolean)true);
            }
        }
        if (Strings.isNotEmpty((Collection)(conditionListMap = (List)dataMap.get("conditionInfo")))) {
            for (Map conditionMap : conditionListMap) {
                FormDesignUtil.getFormulaConditionFromMap4Import((BusinessDataBean)businessDataBean, (FormBean)formBean, (Map)conditionMap);
            }
        }
        formBean.setFormulaConditionList4Import(businessDataBean);
        ArrayList<FormCustomFunction> customFunctionList = new ArrayList<FormCustomFunction>();
        List customFunctionListMap = (List)dataMap.get("customFunction");
        if (Strings.isNotEmpty((Collection)customFunctionListMap)) {
            for (Map customFuncMap : customFunctionListMap) {
                FormCustomFunction customFunc = new FormCustomFunction();
                Long oldId = Long.valueOf(customFuncMap.get("id").toString());
                oldId = businessDataBean.getRealId4Upgrade(oldId);
                Long newId = businessDataBean.genNewIdByOldId(oldId);
                customFunc.setId(newId);
                customFunc.setFunctionName(customFuncMap.get("functionName").toString());
                customFunc.setFunctionParam(customFuncMap.get("functionParam").toString());
                customFunc.setCodeText(customFuncMap.get("codeText").toString());
                customFunc.setReturnType(Integer.valueOf(customFuncMap.get("returnType").toString()));
                Long oldFormId = Long.valueOf(customFuncMap.get("formId").toString());
                if (businessDataBean.isUpgrade()) {
                    oldFormId = businessDataBean.getRealId4Upgrade(oldFormId);
                }
                customFunc.setFormId(businessDataBean.getNewIdByOldId(oldFormId));
                customFunc.setVersion(customFuncMap.get("version").toString());
                customFunc.setAuditState(Integer.valueOf(customFuncMap.get("auditState") == null ? 1 : Integer.valueOf(customFuncMap.get("auditState").toString())));
                customFunctionList.add(customFunc);
                businessDataBean.addFormCustomFunction(customFunc);
            }
        }
        formBean.setCustomFunctionList(customFunctionList);
    }

    public void compatibilityDetection(BusinessDataBean businessDataBean, CompatibilityDetectionResultBean resultBean, FormBean newFormBean, FormBean cacheFormBean) throws BusinessException {
        if (null == cacheFormBean) {
            return;
        }
        List newFuncList = newFormBean.getCustomFunctionList();
        List oldFuncList = cacheFormBean.getCustomFunctionList();
        ArrayList<FormCustomFunction> mergeFuncList = new ArrayList<FormCustomFunction>(newFuncList);
        if (Strings.isNotEmpty((Collection)oldFuncList)) {
            for (FormCustomFunction func : oldFuncList) {
                boolean oldNotExist = false;
                for (FormCustomFunction nf : newFuncList) {
                    if (!func.getId().equals(nf.getId())) continue;
                    oldNotExist = true;
                    break;
                }
                if (oldNotExist) continue;
                mergeFuncList.add(func);
                businessDataBean.addFormCustomFunction(func);
            }
        }
        newFormBean.setCustomFunctionList(mergeFuncList);
    }
}

