/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.importandexport;

import com.seeyon.cap4.form.modules.importandexport.BusinessDataBean;
import com.seeyon.cap4.form.modules.importandexport.CompatibilityDetectionResultBean;
import com.seeyon.cap4.form.modules.importandexport.IncompatibleInfoBaseBean;
import com.seeyon.cap4.form.po.CapConflictMapping;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.ModuleType;
import com.seeyon.ctp.common.authenticate.domain.User;
import com.seeyon.ctp.common.ctpenumnew.CtpEnumUtil;
import com.seeyon.ctp.common.ctpenumnew.manager.EnumManager;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.ctpenumnew.CtpEnum;
import com.seeyon.ctp.common.po.ctpenumnew.CtpEnumBean;
import com.seeyon.ctp.common.po.ctpenumnew.CtpEnumItem;
import com.seeyon.ctp.util.ParamUtil;
import com.seeyon.ctp.util.StringUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDLong;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;

public class BusinessImportAndExport4Enum {
    private static final Log logger = CtpLogFactory.getLog(BusinessImportAndExport4Enum.class);
    private static EnumManager enumManagerNew = (EnumManager)AppContext.getBean((String)"enumManagerNew");

    public static List<Map<String, Object>> exportEnumInfo(BusinessDataBean businessDataBean) throws BusinessException {
        ArrayList<Map<String, Object>> enumRootList = new ArrayList<Map<String, Object>>();
        Set enumsSet = businessDataBean.getEnumsId();
        HashMap<String, Object> enumMap = null;
        for (Long enumId : enumsSet) {
            CtpEnumBean enumClass;
            CtpEnumBean ctpEnumBean = enumManagerNew.getEnum(enumId);
            if (ctpEnumBean == null) {
                logger.info((Object)("\u5bfc\u51fa\u6a21\u677f\u6216\u8005\u5e94\u7528\u4e2d\u7684\u679a\u4e3e\u4e3a\u7a7a\uff0cid=" + String.valueOf(enumId)));
                continue;
            }
            if (ctpEnumBean.getEnumtype() == 1) continue;
            enumMap = new HashMap<String, Object>(16);
            enumRootList.add(enumMap);
            enumMap.put("id", businessDataBean.getRealId4Export(ctpEnumBean.getId()).toString());
            enumMap.put("enumname", ctpEnumBean.getEnumname());
            enumMap.put("enumtype", ctpEnumBean.getEnumtype() + "");
            enumMap.put("sortnumber", ctpEnumBean.getSortnumber() + "");
            enumMap.put("description", ctpEnumBean.getDescription());
            enumMap.put("orgaccountid", ctpEnumBean.getOrgAccountId());
            List enumItems = enumManagerNew.getFirstLevelItemsByEmumId(enumId);
            if (!Strings.isEmpty((Collection)enumItems)) {
                ArrayList<HashMap<String, Object>> itemListMap = new ArrayList<HashMap<String, Object>>();
                enumMap.put("items", itemListMap);
                for (CtpEnumItem ctpEnumItem : enumItems) {
                    HashMap<String, Object> itemMap = new HashMap<String, Object>(8);
                    itemMap.put("id", String.valueOf(businessDataBean.getRealId4Export(ctpEnumItem.getId())));
                    itemMap.put("enumvalue", ctpEnumItem.getEnumvalue());
                    itemMap.put("showvalue", ctpEnumItem.getShowvalue());
                    itemMap.put("sort", String.valueOf(ctpEnumItem.getSortnumber()));
                    itemMap.put("level", String.valueOf(ctpEnumItem.getLevelNum()));
                    boolean imageEnum = false;
                    if (4 == ctpEnumBean.getEnumtype() || 8 == ctpEnumBean.getEnumtype()) {
                        imageEnum = true;
                    }
                    if (imageEnum) {
                        if (ctpEnumItem.getImageId() != null) {
                            businessDataBean.addUnifiedExportAttachment("enumimage", ctpEnumItem.getImageId());
                            itemMap.put("imageid", ctpEnumItem.getImageId() + "");
                        } else {
                            throw new BusinessException(ResourceUtil.getString((String)"com.cap.export.app.image.enum.id.null.tips", (Object)ctpEnumBean.getEnumname()));
                        }
                    }
                    BusinessImportAndExport4Enum.dealMultipleEnumItem(businessDataBean, itemMap, ctpEnumItem);
                    itemListMap.add(itemMap);
                }
            }
            if (ctpEnumBean.getParentId() == null || ctpEnumBean.getParentId() == -1L || ctpEnumBean.getParentId() == 0L || (enumClass = enumManagerNew.getEnum(ctpEnumBean.getParentId())) == null) continue;
            HashMap<String, Object> classMap = new HashMap<String, Object>(16);
            enumMap.put("parent", classMap);
            classMap.put("id", enumClass.getId().toString());
            classMap.put("enumname", enumClass.getEnumname());
            classMap.put("enumtype", enumClass.getEnumtype() + "");
            classMap.put("sortnumber", enumClass.getSortnumber() + "");
            classMap.put("description", enumClass.getDescription());
            classMap.put("orgaccountid", enumClass.getOrgAccountId());
            classMap.put("category", enumClass.getCategory());
        }
        return enumRootList;
    }

    private static void dealMultipleEnumItem(BusinessDataBean businessDataBean, Map<String, Object> parentMap, CtpEnumItem ctpEnumItem) throws BusinessException {
        ArrayList<Long> ids = new ArrayList<Long>();
        ids.add(ctpEnumItem.getId());
        List items = enumManagerNew.getEnumItemByRootId(ids);
        if (!Strings.isEmpty((Collection)items)) {
            ArrayList<HashMap<String, Object>> itemListMap = new ArrayList<HashMap<String, Object>>();
            parentMap.put("items", itemListMap);
            for (CtpEnumItem item : items) {
                HashMap<String, Object> itemMap = new HashMap<String, Object>(8);
                itemMap.put("id", String.valueOf(businessDataBean.getRealId4Export(item.getId())));
                itemMap.put("enumvalue", item.getEnumvalue());
                itemMap.put("showvalue", item.getShowvalue());
                itemMap.put("parentid", String.valueOf(businessDataBean.getRealId4Export(item.getParentId())));
                itemMap.put("rootid", String.valueOf(item.getRootId()));
                itemMap.put("sort", String.valueOf(item.getSortnumber()));
                itemMap.put("level", String.valueOf(item.getLevelNum()));
                BusinessImportAndExport4Enum.dealMultipleEnumItem(businessDataBean, itemMap, item);
                itemListMap.add(itemMap);
            }
        }
    }

    public static void importEnumInfo(BusinessDataBean businessDataBean, List<Map<String, Object>> enumList) throws BusinessException {
        if (!Strings.isEmpty(enumList)) {
            List allEnums = enumManagerNew.getAllOrgCtpEnum(null);
            allEnums.addAll(enumManagerNew.getAllOrgCtpEnum(Long.valueOf(AppContext.currentAccountId())));
            allEnums.addAll(enumManagerNew.getUserImageEnums(Long.valueOf(AppContext.currentAccountId())));
            allEnums.addAll(enumManagerNew.getUserBusinessEnums(Long.valueOf(AppContext.currentAccountId())));
            allEnums.addAll(enumManagerNew.getUserBusinessImageEnums(Long.valueOf(AppContext.currentAccountId())));
            HashSet<String> nameSet = new HashSet<String>();
            HashMap<String, CtpEnum> enumClassSet = new HashMap<String, CtpEnum>();
            for (Map<String, Object> map : enumList) {
                if (businessDataBean.isResetId()) {
                    BusinessImportAndExport4Enum.checkExistCtpEnum(businessDataBean, allEnums, map, nameSet, enumClassSet);
                    continue;
                }
                BusinessImportAndExport4Enum.checkEnum4UnchangedId(businessDataBean, allEnums, map, nameSet, enumClassSet);
            }
        }
    }

    private static void checkEnum4UnchangedId(BusinessDataBean businessDataBean, List<CtpEnumBean> allEnums, Map<String, Object> enumInfoMap, Set<String> nameSet, Map<String, CtpEnum> enumClassNameMap) throws BusinessException {
        String enumName = String.valueOf(enumInfoMap.get("enumname"));
        Long enumId = ParamUtil.getLong(enumInfoMap, (String)"id");
        enumId = businessDataBean.getRealId4Upgrade(enumId);
        int enumType = ParamUtil.getInt(enumInfoMap, (String)"enumtype");
        Long accountId = ParamUtil.getLong(enumInfoMap, (String)"orgaccountid");
        CtpEnumBean oldEnum = enumManagerNew.getEnum(enumId);
        if (oldEnum != null) {
            boolean conflict = false;
            if (!oldEnum.getEnumtype().equals(enumType)) {
                logger.info((Object)("\u901a\u8fc7\u679a\u4e3eid\u627e\u5230\u4e00\u4e2a\u4e0d\u540c\u679a\u4e3e\u5206\u7c7b\u7684\u679a\u4e3e\uff0c\u679a\u4e3eid\uff1a" + String.valueOf(enumId) + ";currentEnumType:" + String.valueOf(enumType) + ";findEnumType:" + String.valueOf(oldEnum.getEnumtype())));
                conflict = true;
            }
            if (!conflict && oldEnum.getOrgAccountId() != null && !oldEnum.getOrgAccountId().equals(AppContext.currentAccountId())) {
                logger.info((Object)("\u901a\u8fc7\u679a\u4e3eid\u627e\u5230\u4e00\u4e2a\u5355\u4f4d\u679a\u4e3e\uff0c\u4f46\u662f\u4e0d\u662f\u5f53\u524d\u5355\u4f4d\u7684\uff0c\u679a\u4e3eid\uff1a" + String.valueOf(enumId) + ";\u5355\u4f4did\uff1a" + oldEnum.getOrgAccountId().toString()));
                conflict = true;
            }
            if (!conflict && oldEnum.getOrgAccountId() != null && accountId == null) {
                logger.info((Object)("\u901a\u8fc7\u679a\u4e3eid\u627e\u5230\u4e00\u4e2a\u5355\u4f4d\u679a\u4e3e\uff0c\u4f46\u662f\u5f53\u524d\u5bfc\u5165\u7684\u662f\u4e00\u4e2a\u516c\u5171\u679a\u4e3e\uff0c\u679a\u4e3eid\uff1a" + String.valueOf(enumId) + ";\u5355\u4f4did\uff1a" + oldEnum.getOrgAccountId().toString()));
                conflict = true;
            }
            if (!conflict && oldEnum.getOrgAccountId() == null && accountId != null) {
                logger.info((Object)("\u901a\u8fc7\u679a\u4e3eid\u627e\u5230\u4e00\u4e2a\u516c\u5171\u679a\u4e3e\uff0c\u4f46\u662f\u5f53\u524d\u5bfc\u5165\u7684\u662f\u4e00\u4e2a\u5355\u4f4d\u679a\u4e3e\uff0c\u679a\u4e3eid\uff1a" + String.valueOf(enumId)));
                conflict = true;
            }
            if (conflict) {
                Long newId = UUIDLong.longUUID();
                CapConflictMapping capConflictMapping = new CapConflictMapping(String.valueOf(enumId), String.valueOf(newId));
                businessDataBean.addCapConflictMapping(capConflictMapping);
                enumInfoMap.put("id", newId);
                BusinessImportAndExport4Enum.checkEnum4UnchangedId(businessDataBean, allEnums, enumInfoMap, nameSet, enumClassNameMap);
                businessDataBean.addEnumMapOld2New(enumId.toString(), newId.toString());
            } else {
                BusinessImportAndExport4Enum.mergeEnumItemInfo(businessDataBean, enumInfoMap, oldEnum, 0L);
                businessDataBean.addEnumMapOld2New(enumId.toString(), enumId.toString());
            }
        } else {
            Map classMap = (Map)enumInfoMap.get("parent");
            CtpEnum enumClass = null;
            if (classMap != null) {
                enumClass = BusinessImportAndExport4Enum.createEnumClass(businessDataBean, allEnums, classMap, enumType, enumClassNameMap);
            }
            enumInfoMap.put("enumname", BusinessImportAndExport4Enum.redirectEnumName(enumName, enumType, allEnums, nameSet, enumClass));
            BusinessImportAndExport4Enum.createNewCtpEnum(businessDataBean, enumInfoMap, enumClass);
        }
    }

    private static void mergeEnumItemInfo(BusinessDataBean businessDataBean, Map<String, Object> enumInfoMap, CtpEnumBean ctpEnumBean, Long parentId) throws BusinessException {
        List enumList;
        if (parentId.equals(0L)) {
            enumList = enumManagerNew.getFirstLevelItemsByEmumId(ctpEnumBean.getId());
        } else {
            ArrayList<Long> ids = new ArrayList<Long>();
            ids.add(parentId);
            enumList = enumManagerNew.getEnumItemByRootId(ids);
        }
        List items = (List)enumInfoMap.get("items");
        if (Strings.isNotEmpty((Collection)items)) {
            HashSet<String> itemNameSet = new HashSet<String>();
            for (Map map : items) {
                Long enumItemId = ParamUtil.getLong((Map)map, (String)"id");
                if (businessDataBean.isUpgrade()) {
                    enumItemId = businessDataBean.getRealId4Upgrade(enumItemId);
                }
                String itemName = ParamUtil.getString((Map)map, (String)"showvalue");
                String itemValue = ParamUtil.getString((Map)map, (String)"enumvalue");
                boolean exist = false;
                boolean conflict = false;
                CtpEnumItem oldItem = enumManagerNew.getCtpEnumItem(enumItemId);
                if (oldItem != null && !oldItem.getRefEnumid().equals(ctpEnumBean.getId())) {
                    conflict = true;
                }
                if (!conflict) {
                    for (CtpEnumItem tempItem : enumList) {
                        IncompatibleInfoBaseBean incompatibleInfoBaseBean;
                        if (tempItem.getId().equals(enumItemId) && tempItem.getEnumvalue().equals(itemValue)) {
                            exist = true;
                            break;
                        }
                        if (tempItem.getId().equals(enumItemId) && !tempItem.getEnumvalue().equals(itemValue)) {
                            if (businessDataBean.isUpgrade()) {
                                incompatibleInfoBaseBean = new IncompatibleInfoBaseBean(ctpEnumBean.getEnumname(), itemName + "\u4e0e" + tempItem.getShowvalue() + "id\u76f8\u540c\u4f46\u662f\u679a\u4e3e\u503c\u4e0d\u76f8\u540c!");
                                businessDataBean.addIncompatibleList(CompatibilityDetectionResultBean.IncompatibleType.ENUM, incompatibleInfoBaseBean);
                                conflict = true;
                                break;
                            }
                            throw new BusinessException("\u5f53\u524d\u679a\u4e3e\u3010" + ctpEnumBean.getEnumname() + "\u3011\u5b89\u88c5\u8fc7\u7a0b\u4e2d\uff0c\u679a\u4e3e\u9879\u3010" + itemName + "\u3011\u4e0e\u7cfb\u7edf\u4e2d\u679a\u4e3e\u9879\u3010" + tempItem.getShowvalue() + "\u3011id\u76f8\u540c\u4f46\u662f\u679a\u4e3e\u503c\u4e0d\u76f8\u540c\uff0c\u8bf7\u4fee\u6539\u4e4b\u540e\u518d\u6267\u884c\u6b64\u64cd\u4f5c\uff01");
                        }
                        if (tempItem.getId().equals(enumItemId) || !tempItem.getEnumvalue().equals(itemValue)) continue;
                        if (businessDataBean.isUpgrade()) {
                            incompatibleInfoBaseBean = new IncompatibleInfoBaseBean(ctpEnumBean.getEnumname(), itemName + "\u4e0e" + tempItem.getShowvalue() + "id\u4e0d\u76f8\u540c\u4f46\u662f\u679a\u4e3e\u503c\u76f8\u540c!");
                            businessDataBean.addIncompatibleList(CompatibilityDetectionResultBean.IncompatibleType.ENUM, incompatibleInfoBaseBean);
                            conflict = true;
                            break;
                        }
                        throw new BusinessException("\u5f53\u524d\u679a\u4e3e\u3010" + ctpEnumBean.getEnumname() + "\u3011\u5b89\u88c5\u8fc7\u7a0b\u4e2d\uff0c\u679a\u4e3e\u9879\u3010" + itemName + "\u3011\u4e0e\u7cfb\u7edf\u4e2d\u679a\u4e3e\u9879\u3010" + tempItem.getShowvalue() + "\u3011\u5b58\u5728\u76f8\u540c\u7684\u679a\u4e3e\u503c\uff0c\u8bf7\u4fee\u6539\u4e4b\u540e\u518d\u6267\u884c\u6b64\u64cd\u4f5c\uff01");
                    }
                }
                if (conflict || !exist) {
                    if (conflict) {
                        Long newEnumItemId = businessDataBean.genNewIdByOldId(enumItemId, true, false);
                        map.put("id", newEnumItemId);
                    }
                    CtpEnumItem item = new CtpEnumItem();
                    BusinessImportAndExport4Enum.createSingleEnumItem(businessDataBean, item, map, (CtpEnum)ctpEnumBean, parentId);
                    item.setShowvalue(BusinessImportAndExport4Enum.redirectEnumItemName(itemName, itemNameSet, enumList));
                    businessDataBean.addEnumMapOld2New(enumItemId.toString(), item.getId().toString());
                    businessDataBean.addCtpEnumItem(item);
                    businessDataBean.addMergeCtpEnumItem(item);
                    BusinessImportAndExport4Enum.createNewCtpEnumItem(businessDataBean, map, (CtpEnum)ctpEnumBean, parentId);
                }
                if (!exist) continue;
                businessDataBean.addEnumMapOld2New(enumItemId.toString(), oldItem.getId().toString());
                BusinessImportAndExport4Enum.mergeEnumItemInfo(businessDataBean, map, ctpEnumBean, oldItem.getId());
            }
        }
    }

    private static String redirectEnumItemName(String enumItemName, Set<String> itemNameSet, List<CtpEnumItem> itemList) {
        boolean hasSameName = false;
        for (CtpEnumItem ctpEnumItem : itemList) {
            if (!ctpEnumItem.getShowvalue().equals(enumItemName)) continue;
            hasSameName = true;
            break;
        }
        if (!hasSameName && !itemNameSet.add(enumItemName)) {
            hasSameName = true;
        }
        if (hasSameName) {
            return BusinessImportAndExport4Enum.redirectEnumItemName(enumItemName + "1", itemNameSet, itemList);
        }
        return enumItemName;
    }

    private static String redirectEnumName(String enumName, int enumType, List<CtpEnumBean> allEnums, Set<String> nameSet, CtpEnum parentEnum) {
        String key;
        boolean hasSameName = false;
        for (CtpEnumBean temp : allEnums) {
            if (!temp.getEnumtype().equals(enumType) || !temp.getEnumname().equals(enumName)) continue;
            if (parentEnum != null && parentEnum.getId().equals(temp.getParentId())) {
                hasSameName = true;
                break;
            }
            if (parentEnum != null || !temp.getParentId().equals(0L)) continue;
            hasSameName = true;
            break;
        }
        if (!hasSameName && !nameSet.add(key = BusinessImportAndExport4Enum.getEnumNameSetKey(parentEnum, enumName, enumType))) {
            hasSameName = true;
        }
        if (hasSameName) {
            return BusinessImportAndExport4Enum.redirectEnumName(enumName + "1", enumType, allEnums, nameSet, parentEnum);
        }
        return enumName;
    }

    private static CtpEnum createEnumClass(BusinessDataBean businessDataBean, List<CtpEnumBean> allEnums, Map<String, Object> classMap, int enumType, Map<String, CtpEnum> enumClassNameMap) {
        CtpEnum enumClass = new CtpEnum();
        enumClass.setEnumname(ParamUtil.getString(classMap, (String)"enumname"));
        Long accountId = ParamUtil.getLong(classMap, (String)"orgaccountid", (Long)0L);
        if (accountId != 0L) {
            enumClass.setOrgAccountId(Long.valueOf(AppContext.currentAccountId()));
        }
        if (classMap.get("category") == null) {
            enumClass.setCategory(Integer.valueOf(ModuleType.global.getKey()));
            if (4 == enumType) {
                enumClass.setCategory(Integer.valueOf(1));
            } else if (8 == enumType) {
                enumClass.setCategory(Integer.valueOf(-4));
            } else if (7 == enumType) {
                enumClass.setCategory(Integer.valueOf(-3));
            }
        } else {
            enumClass.setCategory(ParamUtil.getInt(classMap, (String)"category"));
        }
        CtpEnum ctpEnum = BusinessImportAndExport4Enum.checkEnumClassHasExist(enumClass, allEnums, enumClassNameMap);
        if (ctpEnum != null) {
            enumClass = CtpEnumUtil.transCtpEnumToBean((CtpEnum)ctpEnum);
        } else {
            enumClass.setNewId();
            enumClass.setSortnumber(ParamUtil.getInt(classMap, (String)"sortnumber"));
            enumClass.setDescription(ParamUtil.getString(classMap, (String)"description"));
            enumClass.setIfuse("N");
            enumClass.setParentId(Long.valueOf(0L));
            enumClass.setEnumstate(Integer.valueOf(1));
            enumClass.setProgramCode(enumClass.getId().toString());
            enumClass.setEnumtype(Integer.valueOf(3));
            businessDataBean.addCtpEnumList(enumClass);
            String key = enumClass.getEnumname() + "@" + enumClass.getCategory();
            enumClassNameMap.put(key, enumClass);
        }
        return enumClass;
    }

    private static void checkExistCtpEnum(BusinessDataBean businessDataBean, List<CtpEnumBean> allEnums, Map<String, Object> enumInfoMap, Set<String> nameSet, Map<String, CtpEnum> enumClassNameMap) throws BusinessException {
        Map classMap = (Map)enumInfoMap.get("parent");
        CtpEnum enumClass = null;
        int enumType = ParamUtil.getInt(enumInfoMap, (String)"enumtype");
        if (classMap != null) {
            enumClass = BusinessImportAndExport4Enum.createEnumClass(businessDataBean, allEnums, classMap, enumType, enumClassNameMap);
        }
        CtpEnumBean ctpEnum = null;
        String enumname = String.valueOf(enumInfoMap.get("enumname"));
        for (CtpEnumBean temp : allEnums) {
            if (!temp.getEnumname().equals(enumname) || (enumClass == null || !enumClass.getId().equals(temp.getParentId())) && (enumClass != null || !temp.getParentId().equals(0L) || temp.getEnumtype() != enumType)) continue;
            ctpEnum = temp;
            break;
        }
        if (ctpEnum != null) {
            if (BusinessImportAndExport4Enum.checkIsSameEnum(businessDataBean, enumInfoMap, ctpEnum.getId(), 0)) {
                businessDataBean.addEnumMapOld2New(String.valueOf(enumInfoMap.get("id")), ctpEnum.getId().toString());
            } else {
                enumInfoMap.put("enumname", enumname + 1);
                BusinessImportAndExport4Enum.checkExistCtpEnum(businessDataBean, allEnums, enumInfoMap, nameSet, enumClassNameMap);
            }
        } else {
            String setName = BusinessImportAndExport4Enum.getEnumNameSetKey(enumClass, enumname, enumType);
            if (!nameSet.add(setName)) {
                enumInfoMap.put("enumname", enumname + 1);
                BusinessImportAndExport4Enum.checkExistCtpEnum(businessDataBean, allEnums, enumInfoMap, nameSet, enumClassNameMap);
            } else {
                BusinessImportAndExport4Enum.createNewCtpEnum(businessDataBean, enumInfoMap, enumClass);
            }
        }
    }

    private static String getEnumNameSetKey(CtpEnum parentEnum, String enumName, int enumType) {
        String key = parentEnum == null ? "root@@" + enumType + "@@" + enumName : parentEnum.getEnumname() + "@@" + enumType + "@@" + enumName;
        return key;
    }

    private static boolean checkIsSameEnum(BusinessDataBean businessDataBean, Map<String, Object> enumInfoMap, Long enumId, int level) throws BusinessException {
        int databaseCount;
        List items = (List)enumInfoMap.get("items");
        List enumList = null;
        if (level == 0) {
            enumList = enumManagerNew.getFirstLevelItemsByEmumId(enumId);
        } else {
            ArrayList<Long> ids = new ArrayList<Long>();
            ids.add(enumId);
            enumList = enumManagerNew.getEnumItemByRootId(ids);
        }
        int importCount = items == null ? 0 : items.size();
        int n = databaseCount = enumList == null ? 0 : enumList.size();
        if (importCount != databaseCount) {
            return false;
        }
        if (!Strings.isEmpty((Collection)items) && !Strings.isEmpty((Collection)enumList)) {
            for (Map map : items) {
                String itemName = String.valueOf(map.get("showvalue"));
                String itemValue = String.valueOf(map.get("enumvalue"));
                boolean sameFlag = false;
                for (CtpEnumItem ctpEnumItem : enumList) {
                    if (!ctpEnumItem.getEnumvalue().equals(itemValue) || !ctpEnumItem.getShowvalue().equals(itemName)) continue;
                    sameFlag = true;
                    businessDataBean.addEnumMapOld2New(String.valueOf(map.get("id")), ctpEnumItem.getId().toString());
                    if (BusinessImportAndExport4Enum.checkIsSameEnum(businessDataBean, map, ctpEnumItem.getId(), level + 1)) break;
                    return false;
                }
                if (sameFlag) continue;
                return false;
            }
        }
        return true;
    }

    private static void createNewCtpEnum(BusinessDataBean businessDataBean, Map<String, Object> enumInfoMap, CtpEnum parentEnum) throws BusinessException {
        User user = AppContext.getCurrentUser();
        CtpEnum meta = new CtpEnum();
        if (businessDataBean.isResetId()) {
            meta.setNewId();
        } else {
            meta.setId(ParamUtil.getLong(enumInfoMap, (String)"id"));
        }
        meta.setProgramCode(meta.getId().toString());
        meta.setEnumname(ParamUtil.getString(enumInfoMap, (String)"enumname"));
        meta.setCategory(Integer.valueOf(ModuleType.global.getKey()));
        meta.setSortnumber(ParamUtil.getInt(enumInfoMap, (String)"sortnumber"));
        meta.setDescription(ParamUtil.getString(enumInfoMap, (String)"description"));
        meta.setIfuse("Y");
        meta.setParentId(Long.valueOf(0L));
        if (parentEnum != null) {
            meta.setParentId(parentEnum.getId());
        }
        meta.setEnumstate(Integer.valueOf(1));
        Long orgAccountId = ParamUtil.getLong(enumInfoMap, (String)"orgaccountid", (Long)0L);
        if (orgAccountId != 0L) {
            meta.setOrgAccountId(user.getLoginAccount());
        }
        meta.setBelongMemberId(Long.valueOf(AppContext.currentUserId()));
        meta.setCreateMemberId(Long.valueOf(AppContext.currentUserId()));
        meta.setEnumtype(ParamUtil.getInt(enumInfoMap, (String)"enumtype"));
        businessDataBean.addEnumMapOld2New(ParamUtil.getString(enumInfoMap, (String)"id"), meta.getId().toString());
        businessDataBean.addCtpEnumList(meta);
        BusinessImportAndExport4Enum.createNewCtpEnumItem(businessDataBean, enumInfoMap, meta, 0L);
    }

    private static void createNewCtpEnumItem(BusinessDataBean businessDataBean, Map<String, Object> enumInfoMap, CtpEnum ctpEnum, Long parentId) throws BusinessException {
        List items = (List)enumInfoMap.get("items");
        if (!Strings.isEmpty((Collection)items)) {
            for (Map map : items) {
                CtpEnumItem item = new CtpEnumItem();
                Long oldId = ParamUtil.getLong((Map)map, (String)"id");
                BusinessImportAndExport4Enum.createSingleEnumItem(businessDataBean, item, map, ctpEnum, parentId);
                businessDataBean.addEnumMapOld2New(oldId.toString(), item.getId().toString());
                businessDataBean.addCtpEnumItem(item);
                BusinessImportAndExport4Enum.createNewCtpEnumItem(businessDataBean, map, ctpEnum, item.getId());
            }
        }
    }

    private static void createSingleEnumItem(BusinessDataBean businessDataBean, CtpEnumItem item, Map<String, Object> map, CtpEnum ctpEnum, Long parentId) throws BusinessException {
        Long oldId = ParamUtil.getLong(map, (String)"id");
        if (businessDataBean.isResetId()) {
            item.setNewId();
        } else {
            CtpEnumItem oldEnumItem = enumManagerNew.getCtpEnumItem(oldId);
            boolean conflict = false;
            if (oldEnumItem != null) {
                conflict = true;
            }
            item.setId(businessDataBean.genNewIdByOldId(oldId, conflict, false));
        }
        item.setShowvalue(ParamUtil.getString(map, (String)"showvalue"));
        item.setEnumvalue(ParamUtil.getString(map, (String)"enumvalue"));
        item.setState(Integer.valueOf(1));
        item.setOutputSwitch(Integer.valueOf(1));
        String sortNumber = ParamUtil.getString(map, (String)"sort");
        if (StringUtil.checkNull((String)sortNumber)) {
            item.setSortnumber(Long.valueOf(1L));
        } else {
            item.setSortnumber(Long.valueOf(sortNumber));
        }
        item.setIfuse("N");
        item.setParentId(parentId);
        item.setRefEnumid(ctpEnum.getId());
        item.setOrgAccountId(ctpEnum.getOrgAccountId());
        item.setLevelNum(ParamUtil.getInt(map, (String)"level"));
        if (ctpEnum.getEnumtype() == 4 || ctpEnum.getEnumtype() == 8) {
            item.setImageId(ParamUtil.getLong(map, (String)"imageid"));
            businessDataBean.getImageEnumItem().add(item);
        }
    }

    private static CtpEnum checkEnumClassHasExist(CtpEnum ctpEnum, List<CtpEnumBean> allEnums, Map<String, CtpEnum> enumClassNameMap) {
        String key;
        CtpEnum result = null;
        if (allEnums != null) {
            for (CtpEnumBean enumBean : allEnums) {
                if (enumBean.getEnumtype() != 3 || !ctpEnum.getEnumname().equals(enumBean.getEnumname()) || !enumBean.getCategory().equals(ctpEnum.getCategory())) continue;
                if (null == ctpEnum.getOrgAccountId()) {
                    if (null == enumBean.getOrgAccountId()) {
                        result = enumBean;
                    }
                } else if (enumBean.getOrgAccountId() != null && enumBean.getOrgAccountId().equals(AppContext.currentAccountId())) {
                    result = enumBean;
                }
                if (result == null) continue;
                break;
            }
        }
        if (result == null && !enumClassNameMap.isEmpty() && enumClassNameMap.get(key = ctpEnum.getEnumname() + "@" + ctpEnum.getCategory()) != null) {
            result = enumClassNameMap.get(key);
        }
        return result;
    }
}

