/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.importandexport;

import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormBindAuthBean;
import com.seeyon.cap4.form.bean.FormBindBean;
import com.seeyon.cap4.form.bean.FormCheckRuleBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormFlowBusinessBean;
import com.seeyon.cap4.form.bean.FormTableBean;
import com.seeyon.cap4.form.bean.fieldCtrl.FormFieldCustomCtrl;
import com.seeyon.cap4.form.biz.vo.BizValidateResultVO;
import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.cap4.form.modules.business.BizEnums;
import com.seeyon.cap4.form.modules.business.BusinessManager;
import com.seeyon.cap4.form.modules.business.CapBizConfigItemManager;
import com.seeyon.cap4.form.modules.importandexport.AppUpgradeCacheBean;
import com.seeyon.cap4.form.modules.importandexport.BusinessDataBean;
import com.seeyon.cap4.form.modules.importandexport.BusinessEnums;
import com.seeyon.cap4.form.modules.importandexport.BusinessExportConstant;
import com.seeyon.cap4.form.modules.importandexport.BusinessFormExportManager;
import com.seeyon.cap4.form.modules.importandexport.BusinessImportAndExport4Enum;
import com.seeyon.cap4.form.modules.importandexport.BusinessImportAndExportManager;
import com.seeyon.cap4.form.modules.importandexport.BusinessModuleExportManager;
import com.seeyon.cap4.form.modules.importandexport.BusinessRedirectDataBean;
import com.seeyon.cap4.form.modules.importandexport.CapConflictMappingDao;
import com.seeyon.cap4.form.modules.importandexport.CompatibilityDetectionResultBean;
import com.seeyon.cap4.form.modules.importandexport.IncompatibleInfoBaseBean;
import com.seeyon.cap4.form.po.CapBizConfigItem;
import com.seeyon.cap4.form.po.CapConflictMapping;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.service.CAP4FormManager;
import com.seeyon.cap4.form.util.CapUtil;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.form.util.FormDesignUtil;
import com.seeyon.cap4.form.util.StringUtils;
import com.seeyon.cap4.validity.ValidityUtil;
import com.seeyon.cap4.validity.constant.ValidityEnum;
import com.seeyon.cap4.validity.service.ValidateManager;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.ModuleType;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.cache.CacheAccessable;
import com.seeyon.ctp.common.cache.CacheFactory;
import com.seeyon.ctp.common.cache.CacheMap;
import com.seeyon.ctp.common.constants.ApplicationCategoryEnum;
import com.seeyon.ctp.common.ctpenumnew.manager.EnumManager;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.filemanager.manager.FileManager;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.ctpenumnew.CtpEnum;
import com.seeyon.ctp.common.po.ctpenumnew.CtpEnumItem;
import com.seeyon.ctp.common.po.filemanager.V3XFile;
import com.seeyon.ctp.common.po.template.CtpTemplateCategory;
import com.seeyon.ctp.common.security.SecurityHelper;
import com.seeyon.ctp.common.template.manager.TemplateCategoryManager;
import com.seeyon.ctp.common.template.manager.TemplateManager;
import com.seeyon.ctp.form.bean.FormSerialNumberBean;
import com.seeyon.ctp.form.po.FormOwner;
import com.seeyon.ctp.form.po.FormSerialNumber;
import com.seeyon.ctp.form.service.FormCacheManager;
import com.seeyon.ctp.form.service.FormManager;
import com.seeyon.ctp.organization.bo.V3xOrgAccount;
import com.seeyon.ctp.organization.manager.OrgManager;
import com.seeyon.ctp.util.DBAgent;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.Datetimes;
import com.seeyon.ctp.util.FileUtil;
import com.seeyon.ctp.util.ParamUtil;
import com.seeyon.ctp.util.StringUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDLong;
import com.seeyon.ctp.util.ZipUtil;
import com.seeyon.ctp.util.json.JSONUtil;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.lingala.zip4j.exception.ZipException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import www.seeyon.com.biz.BizChicken4;
import www.seeyon.com.biz.enums.BizOperationEnum4;

public class BusinessImportAndExportManagerImpl
implements BusinessImportAndExportManager {
    private static final Log logger = CtpLogFactory.getLog(BusinessImportAndExportManagerImpl.class);
    private static final String FORM_EXT_NAME = ".sfp";
    private static final String APPLICATION_EXT_NAME = ".syz";
    private static final int EXPORT_MAX_FORMS = 100;
    private CAP4FormCacheManager cap4FormCacheManager;
    private FileManager fileManager;
    private EnumManager enumManagerNew;
    private FormCacheManager formCacheManager;
    private CAP4FormManager cap4FormManager;
    private TemplateManager templateManager;
    private TemplateCategoryManager templateCategoryManager;
    private FormManager formManager;
    private BusinessManager businessManager4;
    private CapBizConfigItemManager capBizConfigItemManager;
    private OrgManager orgManager;
    private ValidateManager validateManager;
    private CapConflictMappingDao capConflictMappingDao;
    private static CacheMap<Long, AppUpgradeCacheBean> APP_UPGRADE_MAP;

    @Override
    public void init() {
        if (APP_UPGRADE_MAP == null) {
            CacheAccessable cacheFactory = CacheFactory.getInstance(BusinessImportAndExportManagerImpl.class);
            APP_UPGRADE_MAP = cacheFactory.createMap("APP_UPGRADE_MAP");
        }
    }

    @Override
    public List<Map<String, String>> getExportAppTypeList(BizConfigBean bizConfigBean) {
        ArrayList<Map<String, String>> appTypeList = new ArrayList<Map<String, String>>();
        HashMap<String, String> typeInfo = new HashMap<String, String>(2);
        appTypeList.add(typeInfo);
        if (bizConfigBean.isMallApp()) {
            typeInfo.put("key", BusinessEnums.ExportAppType.BACKUP_APP.getKey());
            typeInfo.put("text", BusinessEnums.ExportAppType.BACKUP_APP.getI18n());
        } else if (bizConfigBean.isTrial()) {
            if (SystemEnvironment.isDevOrTG() || AppContext.isRunningModeDevelop() || this.validateManager.validatePartener()) {
                typeInfo.put("key", BusinessEnums.ExportAppType.CUSTOM_TRAIL.getKey());
                typeInfo.put("text", BusinessEnums.ExportAppType.CUSTOM_TRAIL.getI18n());
            } else {
                typeInfo.put("key", BusinessEnums.ExportAppType.NONE.getKey());
                typeInfo.put("text", BusinessEnums.ExportAppType.NONE.getI18n());
            }
        } else {
            typeInfo.put("key", BusinessEnums.ExportAppType.PRIVATE_APP.getKey());
            typeInfo.put("text", BusinessEnums.ExportAppType.PRIVATE_APP.getI18n());
            if (SystemEnvironment.isDevOrTG() || AppContext.isRunningModeDevelop() || this.validateManager.validatePartener()) {
                typeInfo = new HashMap(2);
                typeInfo.put("key", BusinessEnums.ExportAppType.CUSTOM_TRAIL.getKey());
                typeInfo.put("text", BusinessEnums.ExportAppType.CUSTOM_TRAIL.getI18n());
                appTypeList.add(typeInfo);
            }
        }
        return appTypeList;
    }

    @Override
    public Map<String, Object> exportForm(Map<String, Object> params) throws BusinessException {
        return this.executeExport(BusinessEnums.ExportType.FORM, params);
    }

    @Override
    public Map<String, Object> exportBusiness(Map<String, Object> params) throws BusinessException {
        return this.executeExport(BusinessEnums.ExportType.APPLICATION, params);
    }

    private Map<String, Object> executeExport(BusinessEnums.ExportType exportType, Map<String, Object> params) throws BusinessException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(2);
        Date date = new Date();
        StringBuilder url = new StringBuilder();
        String fileId = String.valueOf(date.getTime());
        url.append("fileUpload.do?method=download&fileId=").append(fileId);
        url.append("&createDate=").append(DateUtil.format((Date)date));
        url.append("&v=").append(SecurityHelper.digest((Object[])new Object[]{fileId})).append("&filename=");
        resultMap.put("fileurl", url.toString());
        String exportFileName = "";
        HashMap<String, Object> rootMap = new HashMap<String, Object>(16);
        rootMap.put("type", exportType.getKey());
        BusinessDataBean businessDataBean = new BusinessDataBean();
        businessDataBean.setExportType(exportType);
        ArrayList<FormBean> formBeanList = new ArrayList<FormBean>();
        String baseFolder = this.fileManager.getNowFolder(true);
        long bizConfigId = ParamUtil.getLong(params, (String)"bizConfigId", (Long)0L);
        Long subFolder = bizConfigId == 0L ? UUIDLong.absLongUUID() : bizConfigId;
        String rootPath = baseFolder + File.separator + String.valueOf(subFolder) + File.separator;
        businessDataBean.setZipFolder(rootPath);
        BizConfigBean bizConfigBean = null;
        if (0L != bizConfigId) {
            bizConfigBean = this.businessManager4.findBizConfigById(bizConfigId);
        }
        if (exportType == BusinessEnums.ExportType.APPLICATION) {
            String type = ParamUtil.getString(params, (String)"appExportType");
            BusinessEnums.ExportAppType exportAppType = BusinessEnums.ExportAppType.getEnumByKey((String)type);
            boolean trial = false;
            if (BusinessEnums.ExportAppType.CUSTOM_TRAIL == exportAppType) {
                trial = true;
            }
            if (!trial && !ValidityUtil.isValidMplusAccount()) {
                throw new BusinessException(ResourceUtil.getString((String)"com.cap.export.app.certificate.error.tips"));
            }
            if (bizConfigBean == null) {
                throw new BusinessException(ResourceUtil.getString((String)"com.cap.export.app.application.invalid.tips"));
            }
            List<Map<String, String>> canExportTypeList = this.getExportAppTypeList(bizConfigBean);
            int exportAppTypeValid = 0;
            for (Map<String, String> map : canExportTypeList) {
                if (!exportAppType.getKey().equals(map.get("key"))) continue;
                exportAppTypeValid = 1;
                break;
            }
            if (exportAppTypeValid == 0) {
                throw new BusinessException("\u5f53\u524d\u5e94\u7528\u4e0d\u80fd\u5bfc\u51fa\u4e3a\u8be5\u7c7b\u578b\u7684\u5e94\u7528\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
            }
            params.put("trial", trial);
            this.validateManager.preValidateExport(bizConfigBean, params);
            exportFileName = bizConfigBean.getName();
            if (trial) {
                exportFileName = exportFileName + "_" + ResourceUtil.getString((String)"com.cap.export.app.trial.label");
            }
            businessDataBean.setBizConfigBean(bizConfigBean);
            List moduleExportManagers = FormDesignUtil.getBusinessModuleExportManager();
            for (BusinessModuleExportManager moduleExportManager : moduleExportManagers) {
                moduleExportManager.exportData(businessDataBean, rootMap);
            }
            formBeanList.addAll(businessDataBean.getFormBeanList());
        } else {
            String formIds = ParamUtil.getString(params, (String)"formIds", (String)"");
            if (Strings.isBlank((String)formIds)) {
                throw new BusinessException(ResourceUtil.getString((String)"com.cap.export.app.no.form.export.tips"));
            }
            String[] ids = formIds.split(",");
            for (String id : ids) {
                FormBean formBean = this.cap4FormCacheManager.getForm(Long.valueOf(id));
                if (formBean == null) continue;
                formBeanList.add(formBean);
            }
        }
        if (formBeanList.isEmpty()) {
            throw new BusinessException(ResourceUtil.getString((String)"com.cap.export.app.no.form.in.app.tips"));
        }
        if (formBeanList.size() > 100) {
            throw new BusinessException(ResourceUtil.getString((String)"com.cap.export.app.over.100.forms.tips", (Object)100));
        }
        ArrayList<Map<String, Object>> formExportList = new ArrayList<Map<String, Object>>();
        for (FormBean formBean : formBeanList) {
            formExportList.add(this.exportSingleForm(formBean, businessDataBean));
        }
        for (FormBean formBean : businessDataBean.getUpgradeFormList()) {
            this.cap4FormManager.saveOrUpdateFormBean(formBean);
        }
        rootMap.put("forms", formExportList);
        Set enumSet = businessDataBean.getEnumsId();
        if (!enumSet.isEmpty()) {
            rootMap.put("enums", BusinessImportAndExport4Enum.exportEnumInfo(businessDataBean));
        }
        ArrayList<Map<String, Object>> serialNumbers = new ArrayList<Map<String, Object>>();
        List serialnumberPos = businessDataBean.getFormSerialNumberList();
        for (FormSerialNumber serialNumber : serialnumberPos) {
            serialNumbers.add(this.convertSerialNmuber2Map(businessDataBean, serialNumber));
        }
        rootMap.put("serialnumbers", serialNumbers);
        String attPath = rootPath + "attachment" + File.separator;
        this.exportAttachment(attPath, businessDataBean);
        if (!businessDataBean.getAttNameMapping().isEmpty()) {
            rootMap.put("attachmentMapping", businessDataBean.getAttNameMapping());
        }
        CapUtil.writeFile((String)rootPath, (String)"cappackageinfo.json", (String)JSONUtil.toJSONString(rootMap));
        Map extensionMap = CapUtil.generateExtensionInfoMap();
        if (BusinessEnums.ExportType.APPLICATION == exportType) {
            boolean trial;
            BizConfigBean bizConfigBean2 = businessDataBean.getBizConfigBean();
            extensionMap.put("appName", bizConfigBean2.getName());
            extensionMap.put("creator", bizConfigBean2.getCreateName());
            extensionMap.put("createType", bizConfigBean2.getBizCreateType());
            extensionMap.put("createTypeName", BizEnums.BizCreateSourceType.getByKey((int)bizConfigBean2.getBizCreateType()).getName());
            V3xOrgAccount orgAccount = this.orgManager.getAccountById(bizConfigBean2.getOrgAccountId());
            extensionMap.put("creatorAccount", orgAccount.getName());
            String createTime = Datetimes.formatNoTimeZone((Date)bizConfigBean2.getCreateDate(), (String)"yyyy-MM-dd HH:mm:ss");
            extensionMap.put("createTime", createTime);
            extensionMap.put("customCtrl", businessDataBean.getCustomCtrlMapList());
            extensionMap.put("goodsId", bizConfigBean2.getAppInfo().getGoodsId());
            extensionMap.put("orderGoodsId", bizConfigBean2.getAppInfo().getOrderGoodsId());
            extensionMap.put("bizVersion", bizConfigBean2.getAppInfo().getAppVersion());
            extensionMap.put("trial", bizConfigBean2.getAppInfo().getTrial());
            extensionMap.put("customCopyrightOrgID", bizConfigBean2.getAppInfo().getCustomCopyrightOrgID());
            extensionMap.put("createCorpId", bizConfigBean2.getAppInfo().getCreateCorpId());
            extensionMap.put("createCorpName", bizConfigBean2.getAppInfo().getCreateCorpName());
            extensionMap.put("createDogNo", bizConfigBean2.getAppInfo().getCreateDogNo());
            extensionMap.put("copyrightOrgName", bizConfigBean2.getAppInfo().getCopyrightOrgname());
            extensionMap.put("validateInfo", bizConfigBean2.getBizSourceInfo());
            if (params.get("appLogs") != null) {
                List appLogs = bizConfigBean2.getAppLogsCopy();
                appLogs.add((Map)params.get("appLogs"));
                extensionMap.put("appLogs", JSONUtil.toJSONString((Object)appLogs));
            }
            if (trial = Boolean.valueOf(ParamUtil.getString(params, (String)"trial", (String)"false")).booleanValue()) {
                extensionMap.put("trial", "true");
            }
            extensionMap.put("createOrgName", ValidityUtil.getMplusCorpName());
            extensionMap.put("createOrgId", ValidityUtil.getMplusCorpId());
            if (bizConfigBean.isMallApp()) {
                extensionMap.put("backup_app", "true");
                exportFileName = bizConfigBean.getName() + "_backup";
            }
        } else {
            for (FormBean formBean : formBeanList) {
                boolean isBackupForm = false;
                BusinessEnums.FormAttribute attribute = formBean.getFormAttribute();
                if (null == attribute) {
                    attribute = BusinessEnums.FormAttribute.NORMAL;
                }
                if (attribute.getKey().equals(BusinessEnums.FormAttribute.GOODS.getKey()) || attribute.getKey().equals(BusinessEnums.FormAttribute.SINGLETEMPLATEFORM.getKey())) {
                    if (ValidityUtil.isValidMplusAccount()) {
                        exportFileName = formBean.getFormName() + "_backup";
                        resultMap.put("hasMplus", "true");
                        isBackupForm = true;
                    } else {
                        resultMap.put("hasMplus", "false");
                    }
                } else if (Strings.isBlank((String)exportFileName)) {
                    exportFileName = formBean.getFormName();
                }
                extensionMap.put("backup_form", isBackupForm);
                extensionMap.put("form_attribute", attribute.getKey());
            }
        }
        CapUtil.writeFile((String)rootPath, (String)"extension.json", (String)JSONUtil.toJSONString((Object)extensionMap));
        File file = new File(rootPath);
        String extName = FORM_EXT_NAME;
        if (BusinessEnums.ExportType.APPLICATION == exportType) {
            extName = APPLICATION_EXT_NAME;
        }
        String toFileName = file.getParent() + File.separator + fileId;
        File toFile = new File(toFileName);
        try {
            boolean trial;
            ZipUtil.zip((File)file, (File)toFile, (String)"ahfhaflafpon", (boolean)true);
            if (BusinessEnums.ExportType.APPLICATION == exportType && !(trial = Boolean.valueOf(ParamUtil.getString(params, (String)"trial", (String)"false")).booleanValue())) {
                this.validateManager.signPrivatePackage(bizConfigBean, toFile, "ahfhaflafpon", true);
            }
        }
        catch (ZipException e) {
            logger.info((Object)("\u538b\u7f29\u5bfc\u51fa\u6587\u4ef6\u5f02\u5e38\uff1a" + e.getMessage()), (Throwable)e);
            throw new BusinessException(ResourceUtil.getString((String)"com.cap.export.app.zip.file.error.tips"));
        }
        finally {
            FileUtil.deleteFile((File)file);
        }
        resultMap.put("filename", exportFileName + extName);
        return resultMap;
    }

    private void exportSerialNumber(FormBean formBean, BusinessDataBean businessDataBean) {
        Set serialnumbers = this.formCacheManager.getSerialNumberSateByFormId(formBean.getId().longValue(), Enums.SerialNumberState.YES.getKey());
        if (serialnumbers != null && serialnumbers.size() > 0) {
            List exportSerialNumbers = businessDataBean.getFormSerialNumberList();
            for (FormSerialNumberBean serialNumberBean : serialnumbers) {
                boolean containTag = false;
                for (FormSerialNumber serialNumber : exportSerialNumbers) {
                    if (!serialNumberBean.getId().equals(serialNumber.getId())) continue;
                    containTag = true;
                    break;
                }
                if (containTag) continue;
                try {
                    exportSerialNumbers.add(serialNumberBean.toFormSerialNumber());
                }
                catch (BusinessException e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private Map<String, Object> convertSerialNmuber2Map(BusinessDataBean businessDataBean, FormSerialNumber serialNumber) {
        HashMap<String, Object> result = new HashMap<String, Object>(20);
        result.put("id", businessDataBean.getRealId4Export(serialNumber.getId()));
        result.put("variablename", serialNumber.getVariableName() == null ? "" : serialNumber.getVariableName());
        result.put("digit", serialNumber.getDigit());
        result.put("prefix", serialNumber.getPrefix() == null ? "" : serialNumber.getPrefix());
        result.put("value", serialNumber.getValue() == null ? "1" : serialNumber.getValue());
        result.put("numberstep", serialNumber.getNumberStep() == null ? "" : serialNumber.getNumberStep());
        result.put("createdate", DateUtil.format((Date)serialNumber.getCreateDate(), (String)"yyyy-MM-dd HH:mm:ss"));
        result.put("state", serialNumber.getState() == null ? "1" : serialNumber.getState());
        result.put("accountid", serialNumber.getAccountId() == null ? AppContext.currentAccountId() : serialNumber.getAccountId());
        result.put("formid", serialNumber.getFormId() == null ? "0" : businessDataBean.getRealId4Export(serialNumber.getFormId()));
        result.put("texttimebehind", serialNumber.getTextTimeBehind() == null ? "" : serialNumber.getTextTimeBehind());
        result.put("texttimefront", serialNumber.getTextTimeFront() == null ? "" : serialNumber.getTextTimeFront());
        result.put("timedate", serialNumber.getTimeDate() == null ? "0" : serialNumber.getTimeDate());
        result.put("suffix", serialNumber.getSuffix() == null ? "" : serialNumber.getSuffix());
        result.put("minvalue", serialNumber.getMinValue() == null ? "" : serialNumber.getMinValue());
        result.put("rulereset", serialNumber.getRuleReset() == null ? "0" : serialNumber.getRuleReset());
        result.put("currentmarkdate", serialNumber.getCurrentMarkDate() == null ? "" : DateUtil.format((Date)serialNumber.getCurrentMarkDate(), (String)"yyyy-MM-dd HH:mm:ss"));
        result.put("fixlenshow", serialNumber.getFixLenShow() == null ? "" : serialNumber.getFixLenShow());
        result.put("version", serialNumber.getVersion() == null ? "" : serialNumber.getVersion());
        return result;
    }

    private Map<String, Object> exportSingleForm(FormBean formBean, BusinessDataBean businessDataBean) throws BusinessException {
        HashMap<String, Object> formDataMap = new HashMap<String, Object>(16);
        formDataMap.putAll(this.exportFormBaseInfo(formBean, businessDataBean));
        List managerList = FormDesignUtil.getExportManagerList();
        for (BusinessFormExportManager manager : managerList) {
            manager.exportData(formBean, businessDataBean, formDataMap);
        }
        if (businessDataBean.getExportType() == BusinessEnums.ExportType.APPLICATION) {
            this.exportSerialNumber(formBean, businessDataBean);
        }
        return formDataMap;
    }

    private Map<String, Object> exportFormBaseInfo(FormBean formBean, BusinessDataBean businessDataBean) throws BusinessException {
        HashMap<String, Object> exportMap = new HashMap<String, Object>(16);
        exportMap.put("id", businessDataBean.getRealId4Export(formBean.getId()) + "");
        exportMap.put("formName", formBean.getFormName());
        TemplateManager templateManager = (TemplateManager)AppContext.getBean((String)"templateManager");
        CtpTemplateCategory category = templateManager.getCtpTemplateCategory(Long.valueOf(formBean.getCategoryId()));
        if (category == null) {
            logger.info((Object)(formBean.getFormName() + "\u8868\u5355\u5206\u7c7b\u4e3a\u7a7a\uff0c\u8bf7\u8bbe\u7f6e\u4e4b\u540e\u518d\u5bfc\u51fa\uff01"));
            throw new BusinessException(ResourceUtil.getString((String)"com.cap.export.app.form.category.null.tips", (Object)formBean.getFormName()));
        }
        exportMap.put("categoryName", category.getName());
        exportMap.put("categoryId", businessDataBean.getRealId4Export(category.getId()) + "");
        exportMap.put("formType", formBean.getFormType());
        ArrayList<String> tableNameList = new ArrayList<String>();
        for (FormTableBean table : formBean.getTableList()) {
            tableNameList.add(table.getTableName());
        }
        exportMap.put("tableList", tableNameList);
        exportMap.put("checkRules", formBean.getCheckRuleBean() == null ? "" : formBean.getCheckRuleBean().toExportMap());
        exportMap.put("unique", formBean.getUniqueFieldJson());
        HashMap advanceMap = new HashMap();
        if (null != formBean.getAdvancedSet()) {
            advanceMap.putAll(formBean.getAdvancedSet());
        }
        exportMap.put("advancedSettings", advanceMap);
        exportMap.put("formAttribute", formBean.getFormAttribute() != null ? formBean.getFormAttribute().getKey() : BusinessEnums.FormAttribute.NORMAL.getKey());
        return exportMap;
    }

    private void exportAttachment(String path, BusinessDataBean businessDataBean) throws BusinessException {
        Map attMap = businessDataBean.getUnifiedExportAttachment();
        if (!attMap.isEmpty()) {
            for (Map.Entry entry : attMap.entrySet()) {
                List fileIds = (List)entry.getValue();
                String folder = (String)entry.getKey();
                for (Long fileId : fileIds) {
                    File attachFile;
                    V3XFile v3x = this.fileManager.getV3XFile(fileId);
                    if (null == v3x || (attachFile = this.fileManager.getFile(v3x.getId(), v3x.getCreateDate())) == null) continue;
                    try {
                        File destFile = new File(path + folder + File.separator + v3x.getId());
                        FileUtil.copyFile((File)attachFile, (File)destFile);
                    }
                    catch (Exception e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={BusinessException.class})
    public Map<String, Object> formSetup(Map<String, Object> params) throws BusinessException {
        return this.executeImport(BusinessEnums.ExportType.FORM, params);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={BusinessException.class})
    public Map<String, Object> appSetup(Map<String, Object> params) throws BusinessException {
        return this.executeImport(BusinessEnums.ExportType.APPLICATION, params);
    }

    private BusinessRedirectDataBean redirectBusiness(BusinessDataBean businessDataBean) throws BusinessException {
        BusinessRedirectDataBean businessRedirectDataBean = new BusinessRedirectDataBean();
        List moduleExportManagers = FormDesignUtil.getBusinessModuleExportManager();
        for (BusinessModuleExportManager manager : moduleExportManagers) {
            manager.redirectBusiness(businessRedirectDataBean, businessDataBean);
        }
        return businessRedirectDataBean;
    }

    private Map<String, Object> executeImport(BusinessEnums.ExportType exportType, Map<String, Object> params) throws BusinessException {
        String setupType;
        HashMap<String, Object> resultMap = new HashMap<String, Object>(2);
        resultMap.put("success", true);
        BusinessDataBean businessDataBean = new BusinessDataBean();
        String from = ParamUtil.getString(params, (String)"from");
        businessDataBean.setFrom(from);
        businessDataBean.setExportType(exportType);
        String resetId = ParamUtil.getString(params, (String)"resetId", (String)"true");
        businessDataBean.setResetId(Boolean.valueOf(resetId).booleanValue());
        String upgrade = ParamUtil.getString(params, (String)"upgrade", (String)"false");
        businessDataBean.setUpgrade(Boolean.valueOf(upgrade).booleanValue());
        if (businessDataBean.isUpgrade()) {
            AppUpgradeCacheBean appUpgradeCacheBean = new AppUpgradeCacheBean();
            businessDataBean.setAppUpgradeCacheBean(appUpgradeCacheBean);
        }
        File unZipFile = null;
        Date createDate = null;
        if (exportType == BusinessEnums.ExportType.FORM) {
            block50: {
                Long fileId = ParamUtil.getLong(params, (String)"fileId", (Long)0L);
                File importFile = this.fileManager.getFile(fileId, DateUtil.currentDate());
                if (importFile == null || !importFile.exists() || importFile.length() == 0L) {
                    throw new BusinessException(ResourceUtil.getString((String)"com.cap.import.app.cant.find.specified.file.tips"));
                }
                try {
                    String unZipDir = BusinessExportConstant.TEMP_DIR + File.separator + UUIDLong.absLongUUID();
                    unZipFile = new File(unZipDir);
                    ZipUtil.unzip((File)importFile, (File)unZipFile, (String)"ahfhaflafpon");
                    File[] files = unZipFile.listFiles();
                    if (files.length != 3 || !"META-INF".equals(files[0].getName()) && !"META-INF".equals(files[1].getName()) && !"META-INF".equals(files[2].getName())) break block50;
                    Map<String, Object> infoMap = this.validateManager.validatePackage(importFile, false, "", new HashMap<String, Object>());
                    Object authto = infoMap.get("authto");
                    logger.info((Object)("\u5bfc\u5165\u8868\u5355\u8bb8\u53ef\u5355\u4f4d\u4e3a\uff1a'" + String.valueOf(authto) + "'"));
                    if (null != authto && !StringUtil.checkNull((String)String.valueOf(authto))) {
                        businessDataBean.putExtraAttr("formAuthTo", authto);
                    }
                    if (infoMap.containsKey("resultFile")) {
                        unZipFile = (File)infoMap.get("resultFile");
                        break block50;
                    }
                    ValidityEnum.ValidityResult type = ValidityEnum.ValidityResult.getEnumByKey(String.valueOf(infoMap.get("code")));
                    resultMap.put("success", false);
                    resultMap.put("msg", type.getName());
                    logger.info((Object)("import form error:" + type.getName()));
                    return resultMap;
                }
                catch (ZipException e) {
                    logger.info((Object)("\u89e3\u538b\u6587\u4ef6\u5f02\u5e38\uff0c" + e.getMessage()), (Throwable)e);
                    new BusinessException(ResourceUtil.getString((String)"com.cap.import.app.error.tips"));
                }
            }
            Long bizConfigId = ParamUtil.getLong(params, (String)"bizConfigId", (Long)0L);
            BizConfigBean bizConfigBean = null;
            if (!bizConfigId.equals(0L)) {
                bizConfigBean = this.businessManager4.findBizConfigById(bizConfigId);
            }
            if (bizConfigBean != null) {
                businessDataBean.setBizConfigBean(bizConfigBean);
            }
            int importFormType = ParamUtil.getInt(params, (String)"formType", (int)1);
            businessDataBean.setImportFormType(importFormType);
        } else {
            String filePath = params.get("filePath").toString();
            unZipFile = new File(filePath);
            if (null == unZipFile || !unZipFile.isDirectory()) {
                resultMap.put("success", false);
                resultMap.put("msg", ResourceUtil.getString((String)"com.cap.import.app.file.path.error.tips"));
                return resultMap;
            }
            if (null != params.get("verifyInfo") && params.get("verifyInfo") instanceof Map) {
                BizValidateResultVO bizValidateResultVO;
                boolean trial;
                Map verifyInfo = (Map)params.get("verifyInfo");
                int sourceValue = ParamUtil.getInt((Map)verifyInfo, (String)"sourceValue", (int)BizEnums.BizCreateSourceType.Import.getKey());
                if (BizEnums.BizCreateSourceType.ImportFromMall.getKey() == sourceValue) {
                    businessDataBean.setMallApp(true);
                }
                Long appId = Long.valueOf(verifyInfo.get("resultAppId").toString());
                if (businessDataBean.isUpgrade()) {
                    BizConfigBean bizConfigBean = this.businessManager4.findBizConfigById(appId);
                    businessDataBean.setUpgradeSourceApp(bizConfigBean);
                    createDate = bizConfigBean.getCreateDate();
                    List<CapBizConfigItem> itemList = this.capBizConfigItemManager.findByBizId(appId);
                    if (!Strings.isEmpty(itemList)) {
                        for (CapBizConfigItem item : itemList) {
                            businessDataBean.addUpgradeSourceAppItem(item);
                        }
                    }
                }
                if ((trial = Boolean.parseBoolean(ParamUtil.getString((Map)verifyInfo, (String)"trial", (String)"false"))) || BizEnums.BizCreateSourceType.ImportFromMall.getKey() == sourceValue || BizEnums.BizCreateSourceType.ImportFromRequir.getKey() == sourceValue) {
                    businessDataBean.getOldNoNewList().add(appId);
                }
                boolean needCapCheck = true;
                if (businessDataBean.isUpgrade()) {
                    BizConfigBean bizConfigBean = this.businessManager4.findBizConfigById(appId);
                    needCapCheck = bizConfigBean != null && bizConfigBean.isCapFree();
                }
                if (needCapCheck && (!trial || BizEnums.BizCreateSourceType.SelfCreate.getKey() != sourceValue && BizEnums.BizCreateSourceType.Import.getKey() != sourceValue) && !(bizValidateResultVO = this.validateManager.preValidateBiz(sourceValue, BizOperationEnum4.import_app_save)).isSuccess()) {
                    logger.info((Object)"\u5bb9\u91cf\u9a8c\u8bc1\u5931\u8d25");
                    resultMap.put("success", false);
                    resultMap.put("msg", ResourceUtil.getString((String)"com.cap.application.validate.over.capacity.tips", (Object)BizChicken4.getTotalNum()));
                    return resultMap;
                }
            }
            setupType = ParamUtil.getString(params, (String)"setupType", (String)"");
            businessDataBean.setSetupType(setupType);
            businessDataBean.setParams(params);
        }
        try {
            File[] files = unZipFile.listFiles()[0].listFiles();
            businessDataBean.setFilePath(unZipFile.listFiles()[0].getCanonicalPath());
            File jsonFile = null;
            File viewsFile = null;
            File attachmentFile = null;
            File extensionFile = null;
            for (File tempFile : files) {
                if (tempFile.isFile() && "cappackageinfo.json".equals(tempFile.getName())) {
                    jsonFile = tempFile;
                    continue;
                }
                if (tempFile.isFile() && "extension.json".equals(tempFile.getName())) {
                    extensionFile = tempFile;
                    continue;
                }
                if (tempFile.isDirectory() && "views".equals(tempFile.getName())) {
                    viewsFile = tempFile;
                    businessDataBean.setViewFolder(viewsFile);
                    continue;
                }
                if (tempFile.isDirectory() && "attachment".equals(tempFile.getName())) {
                    attachmentFile = tempFile;
                    businessDataBean.setAttachmentFolder(attachmentFile);
                    continue;
                }
                if (!tempFile.isDirectory() || !"customTemplate".equals(tempFile.getName())) continue;
                businessDataBean.setCustomTemplateFolder(tempFile);
            }
            if (BusinessEnums.ExportType.FORM.getKey().equals(exportType.getKey()) && extensionFile != null) {
                boolean isDevEnv;
                boolean bl = isDevEnv = SystemEnvironment.isDev() || AppContext.isRunningModeDevelop();
                if (!isDevEnv) {
                    String backupFlag;
                    String extension = FileUtils.readFileToString((File)extensionFile, (String)"UTF-8");
                    Map extensionMap = (Map)JSONUtil.parseJSONString((String)extension);
                    if (extensionMap.containsKey("backup_form") && "true".equals(backupFlag = extensionMap.get("backup_form").toString())) {
                        logger.info((Object)"\u7531\u4e8e\u8868\u5355\u662f\u5907\u4efd\u8868\u5355\uff0c\u53ea\u80fd\u5bfc\u5165\u5f00\u53d1\u73af\u5883\uff01");
                        throw new BusinessException(ResourceUtil.getString((String)"com.cap.import.form.cant.import.tips"));
                    }
                    String packageFormType = (String)extensionMap.get("form_attribute");
                    businessDataBean.putExtraAttr("packageFormType", packageFormType);
                }
            }
            if (jsonFile == null) {
                throw new BusinessException(ResourceUtil.getString((String)"com.cap.import.app.error.tips"));
            }
            this.readImportDefinition(jsonFile, businessDataBean);
            if (businessDataBean.isUpgrade()) {
                CompatibilityDetectionResultBean resultBean = new CompatibilityDetectionResultBean();
                List moduleExportManagers = FormDesignUtil.getBusinessModuleExportManager();
                for (Object manager : moduleExportManagers) {
                    manager.compatibilityDetection(businessDataBean, resultBean);
                }
                Map incompatibleMap = businessDataBean.getIncompatibleMap();
                if (incompatibleMap.size() > 0) {
                    for (Map.Entry hashMap : incompatibleMap.entrySet()) {
                        List incompatibleInfoBaseBeanList = (List)hashMap.getValue();
                        CompatibilityDetectionResultBean.IncompatibleType type = CompatibilityDetectionResultBean.IncompatibleType.getEnumByKey((String)((String)hashMap.getKey()));
                        for (IncompatibleInfoBaseBean baseBean : incompatibleInfoBaseBeanList) {
                            resultBean.addIncompatibleInfo(type, baseBean);
                        }
                    }
                }
                if (resultBean.getResultMap().size() > 0) {
                    HashMap<String, Map> tempMap = new HashMap<String, Map>();
                    tempMap.put("incompatibleData", resultBean.getResultMap());
                    resultMap.put("data", tempMap);
                    HashMap<String, Object> hashMap = resultMap;
                    return hashMap;
                }
                if (createDate != null) {
                    businessDataBean.getAppUpgradeCacheBean().getBizConfigBean().setCreateDate(createDate);
                }
                APP_UPGRADE_MAP.remove((Serializable)businessDataBean.getUpgradeSourceApp().getId());
                APP_UPGRADE_MAP.put((Serializable)businessDataBean.getUpgradeSourceApp().getId(), (Serializable)businessDataBean.getAppUpgradeCacheBean());
            } else {
                this.saveImportDataInfo(businessDataBean);
            }
            if (exportType == BusinessEnums.ExportType.FORM) {
                HashMap<String, Integer> idAndType = new HashMap<String, Integer>();
                for (FormBean formBean : businessDataBean.getFormBeanList()) {
                    idAndType.put(formBean.getId().toString(), formBean.getFormType());
                }
                resultMap.put("idAndType", idAndType);
            } else {
                BusinessRedirectDataBean businessRedirectDataBean = this.redirectBusiness(businessDataBean);
                resultMap.put("data", businessRedirectDataBean.getData());
                resultMap.put("bizConfigId", businessDataBean.getBizConfigBean().getId() + "");
            }
        }
        catch (Exception e) {
            logger.error((Object)("\u5bfc\u5165\u53d1\u751f\u5f02\u5e38\uff1a" + e.getMessage()), (Throwable)e);
            if (exportType == BusinessEnums.ExportType.APPLICATION && Strings.isNotBlank((String)(setupType = businessDataBean.getSetupType()))) {
                String setupTypeLog = BusinessEnums.SetupType.LOCAL.getKey().equals(setupType) ? "\u672c\u5730\u5b89\u88c5" : "\u5728\u7ebf\u5b89\u88c5";
                String appName = "";
                if (businessDataBean.getBizConfigBean() != null) {
                    appName = businessDataBean.getBizConfigBean().getName();
                }
                logger.info((Object)(AppContext.currentUserName() + setupTypeLog + "\u5e94\u7528" + appName + "\u5931\u8d25\uff01"));
            }
            resultMap.put("success", false);
            String msg = "";
            msg = e instanceof BusinessException ? e.getMessage() : ResourceUtil.getString((String)"com.cap.import.app.error.tips");
            resultMap.put("msg", msg);
            if (businessDataBean.isUpgrade() && businessDataBean.getUpgradeSourceApp() != null) {
                this.removeUpgradeMap(businessDataBean.getUpgradeSourceApp().getId());
            }
            if (!businessDataBean.isUpgrade()) {
                this.rollBack4Import(businessDataBean);
            }
            throw new BusinessException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (!businessDataBean.isUpgrade()) {
                FileUtil.deleteFile((File)unZipFile);
            }
        }
        return resultMap;
    }

    private void readImportDefinition(File jsonFile, BusinessDataBean businessDataBean) throws BusinessException, IOException {
        String packageInfo = FileUtils.readFileToString((File)jsonFile, (String)"UTF-8");
        Map rootMap = (Map)JSONUtil.parseJSONString((String)packageInfo);
        businessDataBean.setRootMap(rootMap);
        String type = String.valueOf(rootMap.get("type"));
        BusinessEnums.ExportType exportType = businessDataBean.getExportType();
        Map attNameMapping = (Map)rootMap.get("attachmentMapping");
        if (attNameMapping != null) {
            businessDataBean.setAttNameMapping(attNameMapping);
        }
        if (!exportType.getKey().equals(type)) {
            throw new BusinessException("\u5bfc\u5165\u7684\u6587\u4ef6\u4e0e\u5f53\u524d\u64cd\u4f5c\u4e0d\u5339\u914d\uff01");
        }
        List enumList = (List)rootMap.get("enums");
        BusinessImportAndExport4Enum.importEnumInfo(businessDataBean, enumList);
        this.importSerialNumber(businessDataBean, (List)rootMap.get("serialnumbers"));
        List formRootMap = (List)rootMap.get("forms");
        boolean isImportForm = BusinessEnums.ExportType.FORM == exportType;
        boolean isDevEnv = SystemEnvironment.isDev() || AppContext.isRunningModeDevelop();
        ArrayList<String> formIdList = new ArrayList<String>();
        for (Map map : formRootMap) {
            boolean isBindMplus;
            String attTypeStr;
            if (!(isDevEnv || !isImportForm || StringUtil.checkNull((String)(attTypeStr = String.valueOf(map.get("formAttribute")))) || attTypeStr.equals(BusinessEnums.FormAttribute.NORMAL.getKey()) || (isBindMplus = ValidityUtil.isValidMplusAccount()))) {
                throw new BusinessException(ResourceUtil.getString((String)"com.cap.business.export.bindmplus"));
            }
            this.importSingleForm(businessDataBean, map);
            formIdList.add(map.get("id").toString());
        }
        logger.info((Object)("\u672c\u6b21\u5bfc\u5165\u8868\u5355id\uff1a" + ((Object)formIdList).toString()));
        for (Object tempBean : businessDataBean.getFormSerialNumberList()) {
            tempBean.setFormId(businessDataBean.genNewIdByOldId(tempBean.getFormId()));
        }
        this.importAttachment(businessDataBean);
        if (BusinessEnums.ExportType.APPLICATION == exportType) {
            List moduleExportManagers = FormDesignUtil.getBusinessModuleExportManager();
            for (BusinessModuleExportManager manager : moduleExportManagers) {
                manager.importData(businessDataBean, rootMap);
            }
            for (BusinessModuleExportManager manager : moduleExportManagers) {
                manager.refreshImportInfo(businessDataBean);
            }
            businessDataBean.refreshConfigId4ConflictMapping();
        }
        for (FormBean formBean : businessDataBean.getFormBeanList()) {
            FormBindBean bindBean;
            List fields = formBean.getCustomFields();
            if (null != fields && fields.size() > 0) {
                for (FormFieldBean field : fields) {
                    FormFieldCustomCtrl ctrl = (FormFieldCustomCtrl)field.getFieldCtrl();
                    ctrl.importInfoAfterBizImport(formBean, field, businessDataBean);
                }
            }
            if ((bindBean = formBean.getBind()) == null) continue;
            if (formBean.isFlowForm()) {
                Map flowBusinessBeanMap = bindBean.getFlowBusinessMap();
                for (Map.Entry entry : flowBusinessBeanMap.entrySet()) {
                    FormFlowBusinessBean flowBusiness = (FormFlowBusinessBean)entry.getValue();
                    flowBusiness.importInfoAfterBizImport(formBean, businessDataBean);
                }
                continue;
            }
            Map bindAuthMap = bindBean.getUnFlowTemplateMap();
            for (Map.Entry entry : bindAuthMap.entrySet()) {
                FormBindAuthBean bindAuth = (FormBindAuthBean)entry.getValue();
                bindAuth.importInfoAfterBizImport(formBean, businessDataBean);
            }
        }
    }

    private void importAttachment(BusinessDataBean businessDataBean) throws BusinessException {
        File attachmentFolder = businessDataBean.getAttachmentFolder();
        if (attachmentFolder != null && attachmentFolder.isDirectory() && attachmentFolder.listFiles().length > 0) {
            Map<String, Long> idRepalceMap = this.importAttachmentFile(attachmentFolder, "enumimage", businessDataBean);
            this.importAttachmentFile(attachmentFolder, "bizImage", businessDataBean);
            if (idRepalceMap != null && !idRepalceMap.isEmpty()) {
                List imageEnumItemList = businessDataBean.getImageEnumItem();
                for (CtpEnumItem ctpEnumItem : imageEnumItemList) {
                    ctpEnumItem.setImageId(idRepalceMap.get(ctpEnumItem.getImageId().toString()));
                }
            }
        }
    }

    private Map<String, Long> importAttachmentFile(File attachmentPath, String folder, BusinessDataBean businessDataBean) throws BusinessException {
        File fileFolder = new File(attachmentPath.getAbsolutePath() + File.separator + folder);
        HashMap<String, Long> replaceMap = null;
        if (fileFolder.isDirectory() && fileFolder.listFiles().length > 0) {
            File[] files;
            replaceMap = new HashMap<String, Long>(16);
            for (File tempFile : files = fileFolder.listFiles()) {
                String oldId = tempFile.getName();
                V3XFile v3xfile = this.fileManager.save(tempFile, ApplicationCategoryEnum.form, tempFile.getName(), DateUtil.currentDate(), Boolean.valueOf(true));
                if (v3xfile == null) continue;
                businessDataBean.getImportFileSet().add(v3xfile.getId());
                businessDataBean.addNewFileId(oldId, String.valueOf(v3xfile.getId()));
                replaceMap.put(oldId, v3xfile.getId());
            }
        }
        return replaceMap;
    }

    private void saveImportDataInfo(BusinessDataBean businessDataBean) throws BusinessException {
        BizConfigBean bizConfigBean;
        this.enumManagerNew.saveCtpEnums(businessDataBean.getCtpEnumList());
        this.enumManagerNew.saveCtpEnumItems(businessDataBean.getCtpEnumItemList());
        ArrayList<CapBizConfigItem> directSaveList = new ArrayList<CapBizConfigItem>();
        directSaveList.addAll(businessDataBean.getFormSerialNumberList());
        if (businessDataBean.getExportType() == BusinessEnums.ExportType.FORM && BusinessEnums.ExportType.APPLICATION.getKey().equals(businessDataBean.getFrom())) {
            List<CapBizConfigItem> bizConfigItemList = this.getConfigItemByForms(businessDataBean);
            directSaveList.addAll(bizConfigItemList);
            businessDataBean.setBizConfigItemList(bizConfigItemList);
        }
        if (businessDataBean.getExportType() == BusinessEnums.ExportType.APPLICATION) {
            List managerList = FormDesignUtil.getBusinessModuleExportManager();
            for (BusinessModuleExportManager manager : managerList) {
                manager.saveImportData(businessDataBean, directSaveList);
            }
            if (businessDataBean.getConflictMappingList() != null) {
                directSaveList.addAll(businessDataBean.getConflictMappingList());
            }
        }
        DBAgent.saveAll(directSaveList);
        ArrayList tempFormBeanList = new ArrayList(businessDataBean.getFormBeanList());
        for (FormBean formBean : tempFormBeanList) {
            int imortOption = 1;
            if (businessDataBean.getExportType() == BusinessEnums.ExportType.FORM) {
                imortOption = 3;
            }
            this.cap4FormManager.saveOrUpdateFormBean(formBean, imortOption);
            businessDataBean.getFormBeanList().remove(formBean);
            businessDataBean.addFormBean(this.cap4FormCacheManager.getForm(formBean.getId()));
        }
        this.formCacheManager.initFormSerialNumber(businessDataBean.getFormSerialNumberList());
        if (businessDataBean.getCtpEnumList().size() > 0) {
            this.enumManagerNew.updateEnumCache(businessDataBean.getCtpEnumList());
        }
        if (businessDataBean.getCtpEnumItemList().size() > 0) {
            this.enumManagerNew.updateEnumItemCache(businessDataBean.getCtpEnumItemList());
        }
        if ((bizConfigBean = businessDataBean.getBizConfigBean()) != null && bizConfigBean.getAppInfo() != null && (bizConfigBean.getAppInfo().getForms() == 0 || bizConfigBean.getAppInfo().getBizRelations() == 0)) {
            try {
                this.businessManager4.loadBizCounts(bizConfigBean);
            }
            catch (Exception e) {
                logger.error((Object)"\u521d\u59cb\u5316\u8868\u5355\u6570\u91cf\u76f8\u5173\u6570\u636e\u540e\u4fdd\u5b58\u51fa\u9519\uff01", (Throwable)e);
            }
        }
    }

    private List<CapBizConfigItem> getConfigItemByForms(BusinessDataBean businessDataBean) {
        ArrayList<CapBizConfigItem> configItemList = new ArrayList<CapBizConfigItem>();
        CapBizConfigItem capBizConfigItem = null;
        for (FormBean formBean : businessDataBean.getFormBeanList()) {
            capBizConfigItem = new CapBizConfigItem();
            capBizConfigItem.setIdIfNew();
            capBizConfigItem.setBizId(businessDataBean.getBizConfigBean().getId());
            capBizConfigItem.setFormId(formBean.getId());
            capBizConfigItem.setSort(Integer.valueOf(0));
            capBizConfigItem.setFormType(Integer.valueOf(0));
            capBizConfigItem.setCategoryId(Long.valueOf(-1L));
            capBizConfigItem.setCreateTime(DateUtil.currentDate());
            capBizConfigItem.setModifyTime(DateUtil.currentDate());
            configItemList.add(capBizConfigItem);
        }
        return configItemList;
    }

    private void rollBack4Import(BusinessDataBean businessDataBean) {
        logger.info((Object)"\u5bfc\u5165\u5931\u8d25\uff0c\u5f00\u59cb\u56de\u6eda\u6570\u636e.....");
        if (businessDataBean != null) {
            ArrayList directDeleteList = new ArrayList();
            if (businessDataBean.getExportType() == BusinessEnums.ExportType.APPLICATION && businessDataBean.getBizConfigBean() != null) {
                List managerList = FormDesignUtil.getBusinessModuleExportManager();
                Iterator iterator = managerList.iterator();
                while (iterator.hasNext()) {
                    BusinessModuleExportManager manager = (BusinessModuleExportManager)iterator.next();
                    try {
                        manager.rollBackImportData(businessDataBean, directDeleteList);
                    }
                    catch (Exception e) {
                        logger.error((Object)("\u56de\u6eda\u5bfc\u5165\u5e94\u7528[+" + manager.getClass().getSimpleName() + "+]\u5f02\u5e38\uff1a" + e.getMessage()), (Throwable)e);
                    }
                }
            }
            try {
                for (FormSerialNumber serialNumber : businessDataBean.getFormSerialNumberList()) {
                    this.formCacheManager.removeFormSerialNumberBean(serialNumber.getId().longValue());
                }
                if (Strings.isNotEmpty((Collection)businessDataBean.getFormModuleAuthList())) {
                    // empty if block
                }
                List formBeanList = businessDataBean.getFormBeanList();
                for (FormBean formBean : formBeanList) {
                    FormOwner formOwner = this.cap4FormCacheManager.getFormOwner(formBean.getId());
                    if (formOwner != null) {
                        // empty if block
                    }
                    this.cap4FormCacheManager.removeFormBean(formBean.getId());
                }
                for (CtpEnum ctpEnum : businessDataBean.getCtpEnumList()) {
                    this.enumManagerNew.deleteEnumCache(ctpEnum.getId());
                }
                for (CtpEnumItem ctpEnumItem : businessDataBean.getMergeCtpEnumItemList()) {
                    this.enumManagerNew.deleteEnumItemCache(ctpEnumItem.getId(), true);
                }
                if (businessDataBean.getImportFileSet().size() > 0) {
                    for (Long fileId : businessDataBean.getImportFileSet()) {
                        this.fileManager.deleteFile(fileId, Boolean.valueOf(true));
                    }
                }
            }
            catch (Exception e) {
                logger.error((Object)("\u56de\u6eda\u4e1a\u52a1\u5305\u5f02\u5e38\uff1a" + e.getMessage()), (Throwable)e);
            }
        }
    }

    private List<FormSerialNumber> importSerialNumber(BusinessDataBean businessDataBean, List<Map<String, Object>> serialNumerRootMap) {
        ArrayList<FormSerialNumber> serialNumbers = null;
        HashSet<String> serialNames = null;
        for (Map<String, Object> serialNumberMap : serialNumerRootMap) {
            String digitStr;
            String fixLenShowStr;
            String stateStr;
            String versionStr;
            String suffixStr;
            String prefixStrStr;
            if (null == serialNumbers) {
                serialNumbers = new ArrayList<FormSerialNumber>();
                serialNames = new HashSet<String>();
            }
            FormSerialNumber serialNumber = new FormSerialNumber();
            String serialIdStr = (String)serialNumberMap.get("id");
            Long serialNumberId = Long.parseLong(serialIdStr);
            String serialFormIdStr = (String)serialNumberMap.get("formid");
            Long formId = Long.parseLong(serialFormIdStr);
            String minValueStr = (String)serialNumberMap.get("minvalue");
            if (!StringUtil.checkNull((String)minValueStr)) {
                serialNumber.setMinValue(Long.valueOf(Long.parseLong(minValueStr)));
            } else {
                serialNumber.setMinValue(Long.valueOf(1L));
            }
            serialNumber.setValue(serialNumber.getMinValue());
            serialNumber.setCreateDate(new Date(System.currentTimeMillis()));
            String variableNameStr = (String)serialNumberMap.get("variablename");
            boolean needCheckName = true;
            boolean needMark = false;
            if (businessDataBean.isResetId()) {
                serialNumber.setId(businessDataBean.genNewIdByOldId(serialNumberId));
            } else {
                if (businessDataBean.isUpgrade()) {
                    serialNumberId = businessDataBean.getRealId4Upgrade(serialNumberId);
                    formId = businessDataBean.getRealId4Upgrade(formId);
                }
                FormSerialNumberBean oldSerialNumber = this.formCacheManager.getSerialNumber(serialNumberId.longValue());
                boolean conflict = false;
                if (oldSerialNumber != null) {
                    if (businessDataBean.isUpgrade()) {
                        IncompatibleInfoBaseBean incompatibleInfoBaseBean;
                        if (oldSerialNumber.getFormId() != null && !formId.equals(oldSerialNumber.getFormId())) {
                            conflict = true;
                            logger.info((Object)("\u6d41\u6c34\u53f7\u7ed1\u5b9a\u7684\u8868\u5355\u4e0d\u4e00\u81f4\uff1a" + formId.toString() + ">>" + (oldSerialNumber.getFormId() == null ? "" : oldSerialNumber.getFormId().toString())));
                            incompatibleInfoBaseBean = new IncompatibleInfoBaseBean(variableNameStr, "\u6d41\u6c34\u53f7\u7ed1\u5b9a\u7684\u8868\u5355\u4e0d\u4e00\u81f4");
                            businessDataBean.addIncompatibleList(CompatibilityDetectionResultBean.IncompatibleType.SERIAL_NUMBER, incompatibleInfoBaseBean);
                        } else if (!this.serialNumberCanUpgrade(serialNumberMap, oldSerialNumber)) {
                            conflict = true;
                            incompatibleInfoBaseBean = new IncompatibleInfoBaseBean(variableNameStr, "\u540c\u539f" + oldSerialNumber.getVariableName() + "\u5185\u5bb9\u4e0d\u4e00\u81f4\uff01");
                            businessDataBean.addIncompatibleList(CompatibilityDetectionResultBean.IncompatibleType.SERIAL_NUMBER, incompatibleInfoBaseBean);
                        } else {
                            needMark = true;
                            serialNumber.setValue(Long.valueOf(oldSerialNumber.getValue()));
                            serialNumber.setCurrentMarkDate(oldSerialNumber.getCurrentMarkDate());
                            serialNumber.setCreateDate(oldSerialNumber.getCreateTime());
                        }
                    } else {
                        conflict = true;
                    }
                }
                serialNumber.setId(businessDataBean.genNewIdByOldId(serialNumberId, conflict, false));
            }
            serialNumber.setFormId(formId);
            String ruleResetStr = (String)serialNumberMap.get("rulereset");
            if (!StringUtil.checkNull((String)ruleResetStr)) {
                serialNumber.setRuleReset(Integer.valueOf(Integer.parseInt(ruleResetStr)));
            }
            if (!StringUtil.checkNull((String)(prefixStrStr = (String)serialNumberMap.get("prefix")))) {
                serialNumber.setPrefix(prefixStrStr);
            }
            if (!StringUtil.checkNull((String)(suffixStr = (String)serialNumberMap.get("suffix")))) {
                serialNumber.setSuffix(suffixStr);
            }
            if (!StringUtil.checkNull((String)(versionStr = (String)serialNumberMap.get("version")))) {
                serialNumber.setVersion(versionStr);
            }
            String textTimeFrontStr = (String)serialNumberMap.get("texttimefront");
            serialNumber.setTextTimeFront(textTimeFrontStr);
            String timeDateStr = (String)serialNumberMap.get("timedate");
            if (!StringUtil.checkNull((String)timeDateStr)) {
                serialNumber.setTimeDate(Integer.valueOf(Integer.parseInt(timeDateStr)));
            }
            serialNumber.setAccountId(Long.valueOf(AppContext.currentAccountId()));
            String textTimeBehindStr = (String)serialNumberMap.get("texttimebehind");
            serialNumber.setTextTimeBehind(textTimeBehindStr);
            String newVariableNameStr = variableNameStr;
            if (needCheckName) {
                newVariableNameStr = this.checkSerialNumberName(serialNumber.getId(), variableNameStr, serialNames);
                if (needMark && variableNameStr.equals(newVariableNameStr)) {
                    serialNumber.putExtraAttr("needDisplay", false);
                }
            }
            serialNames.add(newVariableNameStr);
            businessDataBean.addOldAndNewStringMap(variableNameStr, newVariableNameStr);
            serialNumber.setVariableName(newVariableNameStr);
            String numberStepStr = (String)serialNumberMap.get("numberstep");
            if (!StringUtil.checkNull((String)numberStepStr)) {
                serialNumber.setNumberStep(Long.valueOf(Long.parseLong(numberStepStr)));
            }
            if (!StringUtil.checkNull((String)(stateStr = (String)serialNumberMap.get("state")))) {
                serialNumber.setState(Integer.valueOf(Integer.parseInt(stateStr)));
            }
            if (!StringUtil.checkNull((String)(fixLenShowStr = (String)serialNumberMap.get("fixlenshow")))) {
                serialNumber.setFixLenShow(Integer.valueOf(Integer.parseInt(fixLenShowStr)));
            }
            if (!StringUtil.checkNull((String)(digitStr = (String)serialNumberMap.get("digit")))) {
                serialNumber.setDigit(Integer.valueOf(Integer.parseInt(digitStr)));
            }
            serialNumbers.add(serialNumber);
        }
        if (!Strings.isEmpty(serialNumbers)) {
            businessDataBean.setFormSerialNumberList(serialNumbers);
        }
        return serialNumbers;
    }

    private boolean serialNumberCanUpgrade(Map<String, Object> serialNumberMap, FormSerialNumberBean oldSerialNumber) {
        String oldSuffix;
        String oldTexttimebehind;
        String oldPrefix;
        String variableNameStr = (String)serialNumberMap.get("variablename");
        if (!variableNameStr.equals(oldSerialNumber.getVariableName())) {
            // empty if block
        }
        String prefix = ParamUtil.getString(serialNumberMap, (String)"prefix", (String)"");
        String string = oldPrefix = oldSerialNumber.getPrefix() == null ? "" : oldSerialNumber.getPrefix();
        if (!prefix.equals(oldPrefix)) {
            return false;
        }
        int timedate = ParamUtil.getInt(serialNumberMap, (String)"timedate");
        if (timedate != oldSerialNumber.getTimeDate()) {
            return false;
        }
        String texttimebehind = ParamUtil.getString(serialNumberMap, (String)"texttimebehind", (String)"");
        String string2 = oldTexttimebehind = oldSerialNumber.getTextTimeBehind() == null ? "" : oldSerialNumber.getTextTimeBehind();
        if (!texttimebehind.equals(oldTexttimebehind)) {
            return false;
        }
        String minvalue = ParamUtil.getString(serialNumberMap, (String)"minvalue");
        if (!minvalue.equals(String.valueOf(oldSerialNumber.getMinValue()))) {
            return false;
        }
        int digit = ParamUtil.getInt(serialNumberMap, (String)"digit");
        if (digit != oldSerialNumber.getDigit()) {
            return false;
        }
        int fixlenshow = ParamUtil.getInt(serialNumberMap, (String)"fixlenshow");
        if (fixlenshow != oldSerialNumber.getFixLenShow()) {
            return false;
        }
        String suffix = ParamUtil.getString(serialNumberMap, (String)"suffix", (String)"");
        String string3 = oldSuffix = oldSerialNumber.getSuffix() == null ? "" : oldSerialNumber.getSuffix();
        if (!suffix.equals(oldSuffix)) {
            return false;
        }
        int rulereset = ParamUtil.getInt(serialNumberMap, (String)"rulereset");
        return rulereset == oldSerialNumber.getRuleReset();
    }

    private String checkSerialNumberName(Long serialId, String name, Set<String> serialNameTemp) {
        String returnName = name;
        FormSerialNumberBean fsnb = this.formCacheManager.getSerialNumberByName(name, Long.valueOf(AppContext.currentAccountId()));
        if (fsnb != null && !fsnb.getId().equals(serialId) || serialNameTemp.contains(name)) {
            returnName = name + "1";
            return this.checkSerialNumberName(serialId, returnName, serialNameTemp);
        }
        return returnName;
    }

    private void importSingleForm(BusinessDataBean businessDataBean, Map<String, Object> definitionMap) throws BusinessException {
        FormBean formBean = new FormBean();
        int formType = ParamUtil.getInt(definitionMap, (String)"formType");
        formBean.setFormType(formType);
        if (BusinessEnums.ExportType.FORM == businessDataBean.getExportType()) {
            int formTypeRule = businessDataBean.getImportFormType();
            if (formTypeRule == 1) {
                formBean.setFormType(Enums.FormType.processesForm.getKey());
            } else if (formTypeRule == 2) {
                formBean.setFormType(Enums.FormType.unFlowForm.getKey());
            }
            Iterator authTo = businessDataBean.getExtraAttr("formAuthTo");
            if (null != authTo) {
                formBean.setFormAuthTo(String.valueOf(authTo));
            }
        }
        this.importFormInfo(businessDataBean, definitionMap, formBean);
        if (!businessDataBean.isUpgrade()) {
            this.cap4FormCacheManager.getForms().put(formBean.getId(), formBean);
        } else {
            FormBean oldFormBean = this.cap4FormCacheManager.getForm(formBean.getId());
            if (oldFormBean != null) {
                formBean.setFormRelationshipIdList(new ArrayList(oldFormBean.getFormRelationshipIdList()));
                formBean.setFormTriggerIdList(oldFormBean.getFormTriggerIdList());
            }
        }
        businessDataBean.addFormBean(formBean);
        List managerList = FormDesignUtil.getExportManagerList();
        for (BusinessFormExportManager manager : managerList) {
            manager.importData(formBean, businessDataBean, definitionMap);
        }
        if (!formBean.checkFieldLength()) {
            BusinessException exception = new BusinessException(ResourceUtil.getString((String)"form.base.inporterror.mysql65535"));
            exception.setCode("65535");
            throw exception;
        }
    }

    private void importFormInfo(BusinessDataBean businessDataBean, Map<String, Object> definitionMap, FormBean formBean) throws BusinessException {
        block39: {
            List tableNames;
            Map advanceMap;
            formBean.setFormName(definitionMap.get("formName").toString());
            Long oldFormId = Long.valueOf(definitionMap.get("id").toString());
            FormBean cacheFormBean = null;
            boolean isUpgrade = businessDataBean.isUpgrade();
            if (businessDataBean.isResetId()) {
                formBean.setId(businessDataBean.genNewIdByOldId(oldFormId));
            } else {
                if (isUpgrade) {
                    oldFormId = businessDataBean.getRealId4Upgrade(oldFormId);
                }
                cacheFormBean = this.cap4FormCacheManager.getForm(oldFormId);
                boolean conflict = false;
                if (null != cacheFormBean) {
                    if (isUpgrade) {
                        CapBizConfigItem configItem = businessDataBean.getUpgradeSourceAppItem(oldFormId);
                        if (null == configItem) {
                            conflict = true;
                            cacheFormBean = null;
                        }
                    } else {
                        conflict = true;
                    }
                }
                formBean.setId(businessDataBean.genNewIdByOldId(oldFormId, conflict, false));
            }
            formBean.setOwnerId(AppContext.currentUserId());
            formBean.setCreatorId(AppContext.currentUserId());
            if (isUpgrade && null != cacheFormBean && null != cacheFormBean.getCreateDate()) {
                formBean.setCreateDate(cacheFormBean.getCreateDate());
            } else {
                formBean.setCreateDate(DateUtil.currentDate());
            }
            formBean.setCategoryId(AppContext.currentUserId());
            if (businessDataBean.getExportType() == BusinessEnums.ExportType.FORM) {
                if (null != businessDataBean.getBizConfigBean()) {
                    formBean.setPublishFlag(businessDataBean.getBizConfigBean().getPublishFlag().intValue());
                } else {
                    formBean.setPublishFlag(Enums.FormPublishFlagEnum.unpublished.getKey());
                }
            } else if (businessDataBean.isUpgrade()) {
                formBean.setPublishFlag(businessDataBean.getUpgradeSourceApp().getPublishFlag().intValue());
            } else {
                formBean.setPublishFlag(Enums.FormPublishFlagEnum.unpublished.getKey());
            }
            formBean.setState(Enums.FormStateEnum.official.getKey());
            formBean.setModifyDate(DateUtil.currentDate());
            if (definitionMap.get("advancedSettings") != null && (advanceMap = (Map)definitionMap.get("advancedSettings")).size() > 0) {
                formBean.setAdvancedSet(advanceMap);
            }
            if (businessDataBean.isMallApp()) {
                formBean.setFormAttribute(BusinessEnums.FormAttribute.GOODS);
            } else {
                String packageFormType = (String)businessDataBean.getExtraAttr("packageFormType");
                if (StringUtil.checkNull((String)packageFormType)) {
                    String attTypeStr = String.valueOf(definitionMap.get("formAttribute"));
                    if (!StringUtil.checkNull((String)attTypeStr)) {
                        formBean.setFormAttribute(BusinessEnums.FormAttribute.getEnumByKey((String)attTypeStr));
                    } else {
                        formBean.setFormAttribute(BusinessEnums.FormAttribute.NORMAL);
                    }
                } else {
                    BusinessEnums.FormAttribute attribute = BusinessEnums.FormAttribute.getEnumByKey((String)packageFormType);
                    if (null != attribute) {
                        formBean.setFormAttribute(attribute);
                    } else {
                        formBean.setFormAttribute(BusinessEnums.FormAttribute.NORMAL);
                    }
                }
            }
            Map checkRuleMap = (Map)definitionMap.get("checkRules");
            if (checkRuleMap != null && !checkRuleMap.isEmpty()) {
                String forceCheck = (String)checkRuleMap.get("forceCheck");
                String showDetail = (String)checkRuleMap.get("showDetail");
                String remark = (String)checkRuleMap.get("remark");
                FormCheckRuleBean checkRuleBean = new FormCheckRuleBean(formBean);
                checkRuleBean.setForceCheck(Integer.valueOf(forceCheck).intValue());
                checkRuleBean.setShowDetail(Integer.valueOf(showDetail).intValue());
                checkRuleBean.setRemark(remark);
                formBean.setCheckRuleBean(checkRuleBean);
            }
            this.importCtpTemplateCategory(businessDataBean, definitionMap, formBean);
            if (!formBean.isFlowForm()) {
                if (isUpgrade && null != cacheFormBean) {
                    ArrayList uniqueList = new ArrayList();
                    uniqueList.addAll(cacheFormBean.getUniqueFieldList());
                    formBean.setUniqueFieldList(uniqueList);
                } else {
                    Map uniqueMap = (Map)definitionMap.get("unique");
                    ArrayList uniqueList = new ArrayList();
                    if (uniqueMap != null && !uniqueMap.isEmpty()) {
                        List sonUnique;
                        List mainUnique = (List)uniqueMap.get("formmain");
                        if (mainUnique != null) {
                            uniqueList.addAll(mainUnique);
                        }
                        if ((sonUnique = (List)uniqueMap.get("formsons")) != null) {
                            for (Map sonMap : sonUnique) {
                                List sonList = (List)sonMap.get("fields");
                                uniqueList.addAll(sonList);
                            }
                        }
                    }
                    formBean.setUniqueFieldList(uniqueList);
                }
            }
            if (Strings.isEmpty((Collection)(tableNames = (List)definitionMap.get("tableList")))) break block39;
            if (businessDataBean.isUpgrade() && null != cacheFormBean) {
                Map fieldInfoMap = (Map)definitionMap.get("fieldInfo");
                Map masterInfo = (Map)fieldInfoMap.get("front_formmain");
                List sonInfoMaps = (List)fieldInfoMap.get("formsons");
                String masterId = (String)masterInfo.get("id");
                FormTableBean cacheMasterTableBean = cacheFormBean.getMasterTableBean();
                String oldMasterId = String.valueOf(cacheFormBean.getMasterTableBean().getId());
                if (!masterId.equals(oldMasterId)) {
                    String errorMsg = ResourceUtil.getString((String)"com.cap.app.import.reset.tablename.conflict.", (Object)cacheFormBean.getFormName(), (Object)definitionMap.get("formName")) + oldMasterId + " " + masterId;
                    logger.error((Object)errorMsg);
                    throw new BusinessException(errorMsg);
                }
                businessDataBean.addOldAndNewStringMap((String)masterInfo.get("tableName"), cacheMasterTableBean.getTableName());
                List formTableBeanList = cacheFormBean.getTableList();
                for (Map sonInfoMap : sonInfoMaps) {
                    String sonTableName = (String)sonInfoMap.get("tableName");
                    String sonTableId = (String)sonInfoMap.get("id");
                    Long sonTableIdLong = Long.parseLong(sonTableId);
                    FormTableBean targetTableBean = null;
                    for (FormTableBean tableBean : formTableBeanList) {
                        if (tableBean.isMainTable() || tableBean.getId().longValue() != sonTableIdLong.longValue()) continue;
                        targetTableBean = tableBean;
                        break;
                    }
                    if (null == targetTableBean) {
                        long tempTableNum = this.formManager.getFormTableNumber(1);
                        String newTableNameStr = Enums.TableType.SLAVE.getTableSufName() + "_" + StringUtils.getFieldNumByCount((long)(++tempTableNum), (int)4);
                        businessDataBean.addOldAndNewStringMap(sonTableName, newTableNameStr);
                        businessDataBean.addOldAndNewStringMap("isNew" + sonTableName, "true");
                        logger.info((Object)("\u5e94\u7528\u5347\u7ea7\u8986\u76d6\u8868\u5355'" + cacheFormBean.getFormName() + "',\u627e\u4e0d\u5230\u660e\u7ec6\u8868-tableName:" + sonTableName + " id:" + sonTableId + ",\u6240\u4ee5\u65b0\u53d6\u4e00\u4e2a\u660e\u7ec6\u8868\u53f7\uff1a" + newTableNameStr));
                        continue;
                    }
                    businessDataBean.addOldAndNewStringMap(sonTableName, targetTableBean.getTableName());
                    logger.info((Object)("\u5e94\u7528\u5347\u7ea7\u8986\u76d6\u8868\u5355'" + cacheFormBean.getFormName() + "'\uff0c\u5728\u672c\u5730\u548c\u4e1a\u52a1\u5305\u4e2d\u90fd\u80fd\u627e\u5230id\u4e3a" + targetTableBean.getId() + "\u3001\u4e1a\u52a1\u5305\u660e\u7ec6\u8868\u8868\u540d\uff1a" + sonTableName + "\u7684\u660e\u7ec6\u8868\uff0c\u6240\u4ee5\u4f7f\u7528\u539f\u6709\u660e\u7ec6\u8868\u8868\u540d" + targetTableBean.getTableName()));
                }
            } else {
                long currentNum = this.formManager.getFormTableNumber(tableNames.size());
                for (String tableName : tableNames) {
                    String newTableName = tableName.contains(Enums.TableType.MASTER.getTableSufName()) ? Enums.TableType.MASTER.getTableSufName() + "_" + StringUtils.getFieldNumByCount((long)currentNum, (int)4) : Enums.TableType.SLAVE.getTableSufName() + "_" + StringUtils.getFieldNumByCount((long)(++currentNum), (int)4);
                    businessDataBean.addOldAndNewStringMap(tableName, newTableName);
                }
            }
        }
    }

    private void importCtpTemplateCategory(BusinessDataBean businessDataBean, Map<String, Object> definitionMap, FormBean formBean) throws BusinessException {
        Object categoryNameObj = definitionMap.get("categoryName");
        if (null != categoryNameObj) {
            String categoryName = categoryNameObj.toString();
            Long oldCategoryId = Long.valueOf(definitionMap.get("categoryId").toString());
            if (businessDataBean.isUpgrade()) {
                oldCategoryId = businessDataBean.getRealId4Upgrade(oldCategoryId);
            }
            List<CtpTemplateCategory> templateCategories = this.cap4FormManager.getFormCategoryListByMyAccount();
            boolean findCategory = false;
            if (!businessDataBean.isResetId()) {
                for (CtpTemplateCategory category : templateCategories) {
                    if (!category.getId().equals(oldCategoryId)) continue;
                    formBean.setCategoryId(category.getId().longValue());
                    businessDataBean.addOldAndNewIdMap(oldCategoryId, category.getId());
                    findCategory = true;
                    break;
                }
            }
            if (!findCategory) {
                for (CtpTemplateCategory category : templateCategories) {
                    if (!category.getName().equals(categoryName)) continue;
                    formBean.setCategoryId(category.getId().longValue());
                    businessDataBean.addOldAndNewIdMap(oldCategoryId, category.getId());
                    findCategory = true;
                    if (businessDataBean.isResetId() || businessDataBean.containCapConflictMapping(String.valueOf(oldCategoryId))) break;
                    CapConflictMapping capConflictMapping = new CapConflictMapping(String.valueOf(oldCategoryId), String.valueOf(category.getId()));
                    businessDataBean.addCapConflictMapping(capConflictMapping);
                    break;
                }
            }
            if (!findCategory) {
                CtpTemplateCategory oldTemplateCategory;
                boolean conflict = false;
                if (!businessDataBean.isResetId() && (oldTemplateCategory = this.templateCategoryManager.get(oldCategoryId)) != null) {
                    conflict = true;
                }
                CtpTemplateCategory newCtpTemplateCategory = new CtpTemplateCategory();
                newCtpTemplateCategory.setId(businessDataBean.genNewIdByOldId(oldCategoryId, conflict, false));
                newCtpTemplateCategory.setCreateDate(DateUtil.currentDate());
                newCtpTemplateCategory.setCreateMember(Long.valueOf(AppContext.currentUserId()));
                newCtpTemplateCategory.setName(categoryName);
                newCtpTemplateCategory.setDelete(Boolean.valueOf(false));
                newCtpTemplateCategory.setModifyDate(DateUtil.currentDate());
                newCtpTemplateCategory.setModifyMember(Long.valueOf(AppContext.currentUserId()));
                newCtpTemplateCategory.setOrgAccountId(Long.valueOf(AppContext.currentAccountId()));
                Long rootId = ModuleType.form.getKey();
                newCtpTemplateCategory.setParentId(rootId);
                newCtpTemplateCategory.setSort(Integer.valueOf(0));
                newCtpTemplateCategory.setState(Integer.valueOf(0));
                newCtpTemplateCategory.setType(Integer.valueOf(ModuleType.form.getKey()));
                formBean.setCategoryId(newCtpTemplateCategory.getId().longValue());
                this.templateManager.saveCtpTemplateCategory(newCtpTemplateCategory);
            }
        }
    }

    @Override
    public void initConflictMappingInfo(BizConfigBean bizConfigBean) {
        long startTime = System.currentTimeMillis();
        List<CapConflictMapping> conflictMappingList = this.capConflictMappingDao.selectByBizId(bizConfigBean.getId());
        HashMap<String, String> conflictMap = null;
        for (CapConflictMapping capConflictMapping : conflictMappingList) {
            if (null == conflictMap) {
                conflictMap = new HashMap<String, String>();
            }
            conflictMap.put(capConflictMapping.getOldValue(), capConflictMapping.getNewValue());
        }
        if (null != conflictMap) {
            bizConfigBean.setConflictMap(conflictMap);
        }
        logger.debug((Object)("loading [" + bizConfigBean.getName() + "] application conflict mapping time-consuming : " + (System.currentTimeMillis() - startTime)));
    }

    @Override
    public AppUpgradeCacheBean getAppUpgradeCacheBean(Long bizConfigId) {
        return (AppUpgradeCacheBean)APP_UPGRADE_MAP.get((Serializable)bizConfigId);
    }

    @Override
    public void removeUpgradeMap(Long bizConfigId) {
        APP_UPGRADE_MAP.remove((Serializable)bizConfigId);
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public void setFileManager(FileManager fileManager) {
        this.fileManager = fileManager;
    }

    public void setEnumManagerNew(EnumManager enumManagerNew) {
        this.enumManagerNew = enumManagerNew;
    }

    public void setFormCacheManager(FormCacheManager formCacheManager) {
        this.formCacheManager = formCacheManager;
    }

    public void setCap4FormManager(CAP4FormManager cap4FormManager) {
        this.cap4FormManager = cap4FormManager;
    }

    public void setTemplateManager(TemplateManager templateManager) {
        this.templateManager = templateManager;
    }

    public void setTemplateCategoryManager(TemplateCategoryManager templateCategoryManager) {
        this.templateCategoryManager = templateCategoryManager;
    }

    public void setFormManager(FormManager formManager) {
        this.formManager = formManager;
    }

    public void setBusinessManager4(BusinessManager businessManager4) {
        this.businessManager4 = businessManager4;
    }

    public void setOrgManager(OrgManager orgManager) {
        this.orgManager = orgManager;
    }

    public void setValidateManager(ValidateManager validateManager) {
        this.validateManager = validateManager;
    }

    public void setCapConflictMappingDao(CapConflictMappingDao capConflictMappingDao) {
        this.capConflictMappingDao = capConflictMappingDao;
    }

    public void setCapBizConfigItemManager(CapBizConfigItemManager capBizConfigItemManager) {
        this.capBizConfigItemManager = capBizConfigItemManager;
    }
}

