/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.importandexport;

import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.cap4.form.modules.business.BizEnums;
import com.seeyon.cap4.form.modules.business.BusinessManager;
import com.seeyon.cap4.form.modules.business.CapBizConfigItemManager;
import com.seeyon.cap4.form.modules.business.CtpBizConfigItem;
import com.seeyon.cap4.form.modules.importandexport.AbstractBusinessModuleExportManager;
import com.seeyon.cap4.form.modules.importandexport.AppUpgradeCacheBean;
import com.seeyon.cap4.form.modules.importandexport.BusinessDataBean;
import com.seeyon.cap4.form.modules.importandexport.BusinessEnums;
import com.seeyon.cap4.form.modules.importandexport.BusinessRedirectDataBean;
import com.seeyon.cap4.form.modules.importandexport.BusinessRedirectResultBean;
import com.seeyon.cap4.form.modules.importandexport.BusinessRedirectResultBean4Authorization;
import com.seeyon.cap4.form.modules.importandexport.RollbackCacheBean;
import com.seeyon.cap4.form.po.CapBizConfig;
import com.seeyon.cap4.form.service.CAP4FormCache;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.util.BusinessUtil;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.organization.bo.V3xOrgEntity;
import com.seeyon.ctp.organization.manager.OrgManager;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.ParamUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDLong;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;

public class BusinessModuleExportManager4BizConfig
extends AbstractBusinessModuleExportManager {
    private BusinessManager businessManager4;
    private CAP4FormCacheManager cap4FormCacheManager;
    private CapBizConfigItemManager capBizConfigItemManager;
    private final Log logger = CtpLogFactory.getLog(BusinessModuleExportManager4BizConfig.class);

    public Integer getSort() {
        return 1;
    }

    public void exportData(BusinessDataBean businessDataBean, Map<String, Object> rootMap) throws BusinessException {
        BizConfigBean bizConfigBean = businessDataBean.getBizConfigBean();
        if (bizConfigBean != null) {
            List<Map<String, Object>> bizConfigMenuList;
            Long bizConfigId = bizConfigBean.getId();
            List<FormBean> formBeanList = this.businessManager4.getFormBeanListByBizId(bizConfigId);
            businessDataBean.getFormBeanList().addAll(formBeanList);
            Map bizConfigMap = bizConfigBean.getJsonMap4BizExport();
            String bizIcon = ParamUtil.getString((Map)bizConfigMap, (String)"bizIcon");
            this.setIconFieldId(bizIcon, businessDataBean);
            String bizLogicImgId = ParamUtil.getString((Map)bizConfigMap, (String)"bizLogicImgId");
            if (Strings.isNotEmpty((String)bizLogicImgId)) {
                businessDataBean.addUnifiedExportAttachment("bizImage", Long.valueOf(Long.parseLong(bizLogicImgId)));
            }
            if (Strings.isNotEmpty(bizConfigMenuList = BusinessUtil.validateBizMenu(formBeanList, bizConfigBean))) {
                for (Map<String, Object> menuMap : bizConfigMenuList) {
                    String menuIcon = ParamUtil.getString(menuMap, (String)"menuIcon");
                    this.setIconFieldId(menuIcon, businessDataBean);
                }
            }
            bizConfigMap.put("menus", bizConfigMenuList);
            bizConfigMap.put("authValue", bizConfigBean.getAuthValue());
            bizConfigMap.put("authText", bizConfigBean.getAuthText());
            int bizPage = 0;
            if (BusinessUtil.isBizPage(bizConfigBean)) {
                bizPage = 1;
            }
            bizConfigMap.put("bizPage", bizPage);
            rootMap.put("bizconfig", bizConfigMap);
        }
    }

    private void setIconFieldId(String bizIcon, BusinessDataBean businessDataBean) {
        if (Strings.isNotEmpty((String)bizIcon) && bizIcon.indexOf("fileId=") != -1) {
            int idIndex = bizIcon.indexOf("fileId=") + "fileId=".length();
            String fieldId = bizIcon.substring(idIndex, bizIcon.indexOf("&", idIndex));
            businessDataBean.addUnifiedExportAttachment("bizImage", Long.valueOf(Long.parseLong(fieldId)));
        }
    }

    private String recoveryFieldId(BusinessDataBean businessDataBean, String icon) {
        int idIndex;
        String fieldId;
        String newFieldId;
        if (Strings.isNotEmpty((String)icon) && icon.indexOf("fileId=") != -1 && Strings.isNotEmpty((String)(newFieldId = businessDataBean.getNewFileID(fieldId = icon.substring(idIndex = icon.indexOf("fileId=") + "fileId=".length(), icon.indexOf("&", idIndex)))))) {
            icon = icon.replace(fieldId, newFieldId);
        }
        return icon;
    }

    public void importData(BusinessDataBean businessDataBean, Map<String, Object> dataMap) throws BusinessException {
        if (dataMap != null && dataMap.containsKey("bizconfig")) {
            Map onlineParam;
            String newBizLogicImgId;
            Map bizConfigMap = (Map)dataMap.get("bizconfig");
            CapBizConfig capBizConfig = new CapBizConfig(businessDataBean, bizConfigMap);
            ArrayList<CtpBizConfigItem> ctpBizConfigItemList = new ArrayList<CtpBizConfigItem>();
            List bizConfigMenuList = (List)bizConfigMap.get("menus");
            if (Strings.isNotEmpty((Collection)bizConfigMenuList)) {
                for (Map menuMap : bizConfigMenuList) {
                    CtpBizConfigItem ctpBizConfigItem = new CtpBizConfigItem(businessDataBean, menuMap);
                    ctpBizConfigItem.setMenuId(Long.valueOf(UUIDLong.longUUID()));
                    ctpBizConfigItem.setBizConfigId(capBizConfig.getId());
                    Long oldSourceId = ctpBizConfigItem.getSourceId();
                    Long oldFormAppmainId = ctpBizConfigItem.getFormAppmainId();
                    if (businessDataBean.isUpgrade()) {
                        oldSourceId = businessDataBean.getRealId4Upgrade(oldSourceId);
                        oldFormAppmainId = businessDataBean.getRealId4Upgrade(oldFormAppmainId);
                    }
                    ctpBizConfigItem.setSourceId(businessDataBean.genNewIdByOldId(oldSourceId));
                    ctpBizConfigItem.setMenuIcon(this.recoveryFieldId(businessDataBean, ctpBizConfigItem.getMenuIcon()));
                    ctpBizConfigItem.setFormAppmainId(businessDataBean.genNewIdByOldId(oldFormAppmainId));
                    ctpBizConfigItemList.add(ctpBizConfigItem);
                }
            }
            String bizIcon = capBizConfig.getBizIcon();
            capBizConfig.setBizIcon(this.recoveryFieldId(businessDataBean, bizIcon));
            capBizConfig.putExtraAttr("BIZ_PAGE_VALUE", (Object)ParamUtil.getInt((Map)bizConfigMap, (String)"bizPage"));
            Long bizLogicImgId = capBizConfig.getBizLogicImgId();
            if (bizLogicImgId != null && Strings.isNotEmpty((String)(newBizLogicImgId = businessDataBean.getNewFileID(bizLogicImgId + "")))) {
                capBizConfig.setBizLogicImgId(Long.valueOf(Long.parseLong(newBizLogicImgId)));
            }
            if (businessDataBean.getParams().get("verifyInfo") != null && businessDataBean.getParams().get("verifyInfo") instanceof Map) {
                Map verifyInfo = (Map)businessDataBean.getParams().get("verifyInfo");
                capBizConfig.setBizVersion(ParamUtil.getString((Map)verifyInfo, (String)"bizVersion"));
                capBizConfig.getExtraMap().putAll(verifyInfo);
                Long appId = Long.valueOf(verifyInfo.get("resultAppId").toString());
                capBizConfig.setId(businessDataBean.genNewIdByOldId(appId));
                boolean trial = Boolean.valueOf(ParamUtil.getString((Map)verifyInfo, (String)"trial", (String)"false"));
                if (trial) {
                    capBizConfig.setTrial(Integer.valueOf(BizEnums.BizTrial.trial.getKey()));
                } else {
                    capBizConfig.setTrial(Integer.valueOf(BizEnums.BizTrial.noTrial.getKey()));
                }
                try {
                    capBizConfig.setEndDate(DateUtil.parse((String)ParamUtil.getString((Map)verifyInfo, (String)"endtime"), (String)"yyyy-MM-dd HH:mm:ss"));
                }
                catch (ParseException e) {
                    this.logger.error((Object)("\u65e5\u671f\u8f6c\u6362\u9519\u8bef\uff01" + ParamUtil.getString((Map)verifyInfo, (String)"endtime")), (Throwable)e);
                }
            }
            if ((onlineParam = businessDataBean.getParams()) != null) {
                int sourceValue;
                String bizVersion;
                String onLineFlag = ParamUtil.getString((Map)onlineParam, (String)"setupType", (String)"");
                if ("online".equals(onLineFlag) && Strings.isNotEmpty((String)(bizVersion = ParamUtil.getString((Map)onlineParam, (String)"version")))) {
                    capBizConfig.setBizVersion(bizVersion);
                }
                if ((sourceValue = ParamUtil.getInt((Map)onlineParam, (String)"sourceValue", (int)BizEnums.BizCreateSourceType.Import.getKey()).intValue()) == BizEnums.BizCreateSourceType.SelfCreate.getKey()) {
                    sourceValue = BizEnums.BizCreateSourceType.Import.getKey();
                }
                capBizConfig.setBizCreateType(Integer.valueOf(sourceValue));
                capBizConfig.putExtraAttr("BIZ_SOURCE_VALUE", sourceValue);
            }
            BizConfigBean bizConfigBean = new BizConfigBean(capBizConfig);
            bizConfigBean.getExtraMap().putAll(capBizConfig.getExtraMap());
            bizConfigBean.setAuthValue(ParamUtil.getString((Map)bizConfigMap, (String)"authValue", (String)""));
            bizConfigBean.setAuthText(ParamUtil.getString((Map)bizConfigMap, (String)"authText", (String)""));
            bizConfigBean.setItems(ctpBizConfigItemList);
            bizConfigBean.putExtraAttr("BIZ_PAGE_VALUE", (Object)ParamUtil.getInt((Map)bizConfigMap, (String)"bizPage"));
            if (businessDataBean.isUpgrade()) {
                businessDataBean.getAppUpgradeCacheBean().setBizConfigBean(bizConfigBean);
                bizConfigBean.setPublishFlag(businessDataBean.getUpgradeSourceApp().getPublishFlag());
                bizConfigBean.setBizCreateType(Integer.valueOf(this.countUpGradeCreateType(bizConfigBean.getBizCreateType(), businessDataBean.getUpgradeSourceApp().getBizCreateType())));
                bizConfigBean.setTrial(Integer.valueOf(this.countUpGradeTrial(bizConfigBean.getTrial(), businessDataBean.getUpgradeSourceApp().getTrial())));
            }
            businessDataBean.setBizConfigBean(bizConfigBean);
        }
    }

    private int countUpGradeTrial(Integer trial1, Integer trial2) {
        if (trial1 == null || trial2 == null) {
            return BizEnums.BizTrial.noTrial.getKey();
        }
        if (trial1.intValue() == BizEnums.BizTrial.noTrial.getKey() || trial2.intValue() == BizEnums.BizTrial.noTrial.getKey()) {
            return BizEnums.BizTrial.noTrial.getKey();
        }
        return BizEnums.BizTrial.trial.getKey();
    }

    private int countUpGradeCreateType(Integer type1, Integer type2) {
        if (type1 == null) {
            type1 = BizEnums.BizCreateSourceType.Import.getKey();
        }
        if (type2 == null) {
            type2 = BizEnums.BizCreateSourceType.Import.getKey();
        }
        if (type1.intValue() == BizEnums.BizCreateSourceType.ImportFromMall.getKey() || type2.intValue() == BizEnums.BizCreateSourceType.ImportFromMall.getKey()) {
            return BizEnums.BizCreateSourceType.ImportFromMall.getKey();
        }
        if (type1.intValue() == BizEnums.BizCreateSourceType.ImportFromRequir.getKey() || type2.intValue() == BizEnums.BizCreateSourceType.ImportFromRequir.getKey()) {
            return BizEnums.BizCreateSourceType.ImportFromRequir.getKey();
        }
        return BizEnums.BizCreateSourceType.Import.getKey();
    }

    public void saveImportData(BusinessDataBean businessDataBean, List directSaveList) throws BusinessException {
        BizConfigBean bizConfigBean = businessDataBean.getBizConfigBean();
        CapBizConfig capBizConfig = bizConfigBean.getConfig();
        capBizConfig.putExtraAttr("BIZ_AUTHORITY_VALUE", bizConfigBean.getAuthValue());
        if (bizConfigBean.getExtraAttr("BIZ_PAGE_VALUE") != null) {
            capBizConfig.putExtraAttr("BIZ_PAGE_VALUE", (Object)((Integer)bizConfigBean.getExtraAttr("BIZ_PAGE_VALUE")));
        }
        List formBeanList = businessDataBean.getFormBeanList();
        this.capBizConfigItemManager.importBizFormRelation(formBeanList, capBizConfig.getId());
        capBizConfig.setBizState(Integer.valueOf(BizEnums.BizState.inactive.getKey()));
        capBizConfig.setPublishFlag(Integer.valueOf(BizEnums.BizPublishState.initState.getKey()));
        this.businessManager4.doSaveBizConfig4Import(capBizConfig, bizConfigBean.getItems(), false);
        BizConfigBean bizConfigBeanNew = this.businessManager4.findBizConfigById(bizConfigBean.getId());
        if (bizConfigBeanNew != null) {
            businessDataBean.setBizConfigBean(bizConfigBeanNew);
            if (Strings.isNotEmpty((String)bizConfigBean.getAuthValue()) && Strings.isNotEmpty((String)bizConfigBean.getAuthText())) {
                bizConfigBeanNew.setAuthText(bizConfigBean.getAuthText());
                bizConfigBeanNew.setAuthValue(bizConfigBean.getAuthValue());
                if (Strings.isNotEmpty((Collection)bizConfigBean.getItems())) {
                    bizConfigBeanNew.setItems(bizConfigBean.getItems());
                }
            }
        }
    }

    public void rollBackImportData(BusinessDataBean businessDataBean, List directDeleteList) throws BusinessException {
        BizConfigBean bizConfigBean;
        if (businessDataBean != null && (bizConfigBean = businessDataBean.getBizConfigBean()) != null) {
            this.businessManager4.cap4BizImportRollBack(bizConfigBean.getId());
        }
    }

    public void clearBusinessData(BizConfigBean bizConfigBean) {
        this.logger.info((Object)("clearBusinessData\u5f00\u59cb\u6e05\u7406\u5b89\u88c5\u5e94\u7528\u7684\u6570\u636e\uff0cid:" + bizConfigBean.getId()));
        if (bizConfigBean != null) {
            try {
                this.businessManager4.cap4BizImportRollBack(bizConfigBean.getId());
            }
            catch (Exception e) {
                this.logger.error((Object)("\u53d6\u6d88\u5e94\u7528\u5b89\u88c5\u5f02\u5e38\uff1a" + e.getMessage()), (Throwable)e);
            }
        }
    }

    public void redirectBusiness(BusinessRedirectDataBean businessRedirectDataBean, BusinessDataBean businessDataBean) throws BusinessException {
        BizConfigBean bizConfigBean = businessDataBean.getBizConfigBean();
        String authValue = bizConfigBean.getAuthValue();
        String authText = bizConfigBean.getAuthText();
        if (Strings.isNotEmpty((String)authValue) && Strings.isNotEmpty((String)authText)) {
            String[] authValueArray = authValue.split(",");
            String[] authTextArray = authText.split("\u3001");
            OrgManager orgManager = (OrgManager)AppContext.getBean((String)"orgManager");
            for (int i = 0; i < authValueArray.length; ++i) {
                BizConfigBean oldBizConfigBean;
                String orgId;
                String[] authData = authValueArray[i].split("\\|");
                String orgType = authData[0];
                V3xOrgEntity entity = orgManager.getEntity(orgType, Long.valueOf(Long.parseLong(orgId = authData[1])));
                if (null != entity || businessDataBean.isUpgrade() && (oldBizConfigBean = this.businessManager4.findBizConfigById(bizConfigBean.getId())) != null) continue;
                String orgName = authTextArray[i];
                String key = BusinessRedirectDataBean.createKey((String)orgType, (String)orgName);
                BusinessRedirectResultBean4Authorization authorization = new BusinessRedirectResultBean4Authorization();
                authorization.setAuthorizationType(BusinessRedirectResultBean4Authorization.AuthorizationType.APPLICATION.name());
                authorization.setSourceId(bizConfigBean.getId());
                authorization.setOldValue4Show(orgName);
                authorization.setOldValue4System(orgId);
                authorization.setOrgType(orgType);
                businessRedirectDataBean.addResultBean(key, (BusinessRedirectResultBean)authorization);
                HashMap<String, String> valueMap = new HashMap<String, String>();
                valueMap.put(BusinessEnums.AuthorizationDetailKey.LOCATION.getKey(), ResourceUtil.getString((String)"form.import.export.auth.details"));
                valueMap.put(BusinessEnums.AuthorizationDetailKey.TYPE.getKey(), ResourceUtil.getString((String)"cap.monitor.application"));
                valueMap.put(BusinessEnums.AuthorizationDetailKey.AUTH_ITEM.getKey(), bizConfigBean.getName());
                businessRedirectDataBean.addRedirectDetail(key, authorization.getCategory(), valueMap);
            }
        }
    }

    public void mergeRedirectData(Map<String, List<Map<String, Object>>> redirectData, BizConfigBean bizConfigBean, AppUpgradeCacheBean appUpgradeCacheBean) throws BusinessException {
        List<Map<String, Object>> authList;
        if (bizConfigBean != null && Strings.isNotEmpty(authList = redirectData.get("authorization"))) {
            String authValue = bizConfigBean.getAuthValue();
            String authText = bizConfigBean.getAuthText();
            if (Strings.isNotEmpty((String)authText) && Strings.isNotEmpty((String)authValue)) {
                for (Map<String, Object> authMap : authList) {
                    String authorizationType = ParamUtil.getString(authMap, (String)"authorizationType");
                    if (!BusinessRedirectResultBean4Authorization.AuthorizationType.APPLICATION.name().equals(authorizationType)) continue;
                    String oldValue4System = ParamUtil.getString(authMap, (String)"oldValue4System");
                    String newValue4Show = ParamUtil.getString(authMap, (String)"newValue4Show");
                    String newValue4System = ParamUtil.getString(authMap, (String)"newValue4System");
                    String[] authValueArray = authValue.split(",");
                    String[] authTextArray = authText.split("\u3001");
                    for (int i = 0; i < authValueArray.length; ++i) {
                        String[] authData = authValueArray[i].split("\\|");
                        if (!oldValue4System.equals(authData[1])) continue;
                        authValueArray[i] = authValueArray[i].replace(oldValue4System, newValue4System);
                        authTextArray[i] = newValue4Show;
                    }
                    authValue = Strings.join((String)",", (String[])authValueArray);
                    authText = Strings.join((String)"\u3001", (String[])authTextArray);
                }
                bizConfigBean.setAuthValue(authValue);
                bizConfigBean.setAuthText(authText);
            }
        }
    }

    public void finalSaveRedirectData(BizConfigBean bizConfigBean) throws BusinessException {
        CapBizConfig capBizConfig = bizConfigBean.getConfig();
        capBizConfig.setBizState(Integer.valueOf(BizEnums.BizState.Activated.getKey()));
        capBizConfig.putExtraAttr("BIZ_AUTHORITY_VALUE", bizConfigBean.getAuthValue());
        try {
            this.businessManager4.doSaveOrUpdateBizConfig(capBizConfig);
        }
        catch (Exception e) {
            this.logger.error((Object)("\u5bfc\u5165\u5e94\u7528\u4fdd\u5b58\u5f02\u5e38\uff1a" + e.getMessage()), (Throwable)e);
            throw new BusinessException(e.getMessage());
        }
    }

    public void completeUpgrade(AppUpgradeCacheBean appUpgradeCacheBean) throws BusinessException {
        BizConfigBean bizConfigBean = appUpgradeCacheBean.getBizConfigBean();
        if (bizConfigBean != null) {
            CapBizConfig capBizConfig = bizConfigBean.getConfig();
            capBizConfig.putExtraAttr("BIZ_AUTHORITY_VALUE", bizConfigBean.getAuthValue());
            if (bizConfigBean.getExtraAttr("BIZ_PAGE_VALUE") != null) {
                capBizConfig.putExtraAttr("BIZ_PAGE_VALUE", (Object)((Integer)bizConfigBean.getExtraAttr("BIZ_PAGE_VALUE")));
            }
            List formBeanList = appUpgradeCacheBean.getAllForm();
            this.capBizConfigItemManager.updateBizFormRelation(formBeanList, capBizConfig.getId());
            BizConfigBean bizConfigBeanOld = this.businessManager4.findBizConfigById(bizConfigBean.getId());
            if (bizConfigBeanOld != null) {
                bizConfigBean.setAuthText(bizConfigBeanOld.getAuthText());
                bizConfigBean.setAuthValue(bizConfigBeanOld.getAuthValue());
            }
            this.businessManager4.doSaveBizConfig4Import(capBizConfig, bizConfigBean.getItems(), true);
            BizConfigBean bizConfigBeanNew = this.businessManager4.findBizConfigById(bizConfigBean.getId());
            if (bizConfigBeanNew != null) {
                bizConfigBeanNew.setAuthText(bizConfigBeanOld.getAuthText());
                bizConfigBeanNew.setAuthValue(bizConfigBeanOld.getAuthValue());
                this.finalSaveRedirectData(bizConfigBeanNew);
            }
        }
    }

    public void loadCache(AppUpgradeCacheBean appUpgradeCacheBean) throws BusinessException {
    }

    public void restoreCache(AppUpgradeCacheBean appUpgradeCacheBean) throws BusinessException {
        RollbackCacheBean rollbackCacheBean = appUpgradeCacheBean.getRollbackCacheBean();
        if (rollbackCacheBean != null) {
            this.businessManager4.initBizConfig(appUpgradeCacheBean.getId(), false);
        }
    }

    public void afterCommit(AppUpgradeCacheBean appUpgradeCacheBean) throws BusinessException {
        if (SystemEnvironment.isClusterEnabled()) {
            BizConfigBean bizConfigBean = appUpgradeCacheBean.getBizConfigBean();
            this.cap4FormCacheManager.sendNotification((Object)bizConfigBean.getId(), CAP4FormCache.FormCacheType.FromBizConfig_Reload, bizConfigBean.getId());
        }
    }

    public void setBusinessManager4(BusinessManager businessManager4) {
        this.businessManager4 = businessManager4;
    }

    public void setCapBizConfigItemManager(CapBizConfigItemManager capBizConfigItemManager) {
        this.capBizConfigItemManager = capBizConfigItemManager;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }
}

