/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.importandexport;

import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.cap4.form.modules.importandexport.AbstractBusinessModuleExportManager;
import com.seeyon.cap4.form.modules.importandexport.AppUpgradeCacheBean;
import com.seeyon.cap4.form.modules.importandexport.BusinessDataBean;
import com.seeyon.cap4.form.modules.importandexport.BusinessEnums;
import com.seeyon.cap4.form.modules.importandexport.BusinessRedirectDataBean;
import com.seeyon.cap4.form.modules.importandexport.BusinessRedirectResultBean;
import com.seeyon.cap4.form.modules.importandexport.BusinessRedirectResultBean4Authorization;
import com.seeyon.cap4.form.modules.importandexport.RollbackCacheBean;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.form.modules.bizmap.BizMapBo;
import com.seeyon.ctp.form.modules.bizmap.BizMapItemBo;
import com.seeyon.ctp.form.modules.bizmap.manager.BizMapItemManager;
import com.seeyon.ctp.form.modules.bizmap.manager.BizMapManager;
import com.seeyon.ctp.form.modules.engin.authorization.FormAuthModuleDAO;
import com.seeyon.ctp.form.po.CtpBizMap;
import com.seeyon.ctp.form.po.CtpBizMapItem;
import com.seeyon.ctp.form.po.FormModuleAuth;
import com.seeyon.ctp.form.service.FormCache;
import com.seeyon.ctp.form.service.FormCacheManager;
import com.seeyon.ctp.form.util.Enums;
import com.seeyon.ctp.organization.bo.V3xOrgEntity;
import com.seeyon.ctp.organization.manager.OrgManager;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.ParamUtil;
import com.seeyon.ctp.util.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;

public class BusinessModuleExportManager4BizMap
extends AbstractBusinessModuleExportManager {
    private final Log logger = CtpLogFactory.getLog(BusinessModuleExportManager4BizMap.class);
    private BizMapManager bizMapManager;
    private BizMapItemManager bizMapItemManager;
    private FormAuthModuleDAO formAuthModuleDAO;
    private OrgManager orgManager;
    private FormCacheManager formCacheManager;

    public Integer getSort() {
        return 7;
    }

    public void exportData(BusinessDataBean businessDataBean, Map<String, Object> rootMap) throws BusinessException {
        BizConfigBean bizConfigBean = businessDataBean.getBizConfigBean();
        ArrayList<Map<String, Object>> bizMap = new ArrayList<Map<String, Object>>();
        if (bizConfigBean != null) {
            Long bizId = bizConfigBean.getId();
            List ctpBizMapList = this.bizMapManager.getBizMapByBizId(bizId);
            for (CtpBizMap ctpBizMap : ctpBizMapList) {
                BizMapBo bizMapBo = this.bizMapManager.getBizMapAndItem(ctpBizMap.getId(), false);
                Long imgId = ctpBizMap.getAttId();
                if (imgId != null) {
                    businessDataBean.addUnifiedExportAttachment("bizImage", imgId);
                    bizMapBo.setAttId(imgId);
                }
                bizMap.add(this.getJsonMap4BizExport(businessDataBean, bizMapBo));
            }
            rootMap.put("bizmap", bizMap);
        }
    }

    public void importData(BusinessDataBean businessDataBean, Map<String, Object> dataMap) throws BusinessException {
        if (dataMap != null && dataMap.containsKey("bizmap")) {
            List mapBoList = (List)dataMap.get("bizmap");
            boolean isResetId = businessDataBean.isResetId();
            if (Strings.isNotEmpty((Collection)mapBoList)) {
                ArrayList<BizMapBo> bizMapList = new ArrayList<BizMapBo>();
                for (Map bizMap : mapBoList) {
                    BizMapBo bizMapBO = new BizMapBo();
                    Long oldMapId = ParamUtil.getLong((Map)bizMap, (String)"id");
                    if (isResetId) {
                        bizMapBO.setId(businessDataBean.genNewIdByOldId(oldMapId));
                    } else {
                        boolean conflict = false;
                        CtpBizMap ctpBizMap = this.bizMapManager.getBizMap(oldMapId);
                        if (ctpBizMap != null) {
                            if (businessDataBean.isUpgrade()) {
                                oldMapId = businessDataBean.getRealId4Upgrade(oldMapId);
                                if (ctpBizMap.getBizId() != null && !ctpBizMap.getBizId().equals(businessDataBean.getBizConfigBean().getId())) {
                                    conflict = true;
                                }
                            } else {
                                conflict = true;
                            }
                        }
                        bizMapBO.setId(businessDataBean.genNewIdByOldId(oldMapId, conflict, false));
                    }
                    String attId = ParamUtil.getString((Map)bizMap, (String)"attId");
                    if (Strings.isNotEmpty((String)attId)) {
                        Long newAttId = Long.parseLong(businessDataBean.getNewFileID(attId));
                        bizMapBO.setAttId(newAttId);
                    }
                    Long bizId = ParamUtil.getLong((Map)bizMap, (String)"bizId");
                    Long newBizId = businessDataBean.genNewIdByOldId(bizId);
                    bizMapBO.setBizId(newBizId);
                    bizMapBO.setCreatorId(Long.valueOf(AppContext.currentUserId()));
                    bizMapBO.setModifierId(Long.valueOf(AppContext.currentUserId()));
                    bizMapBO.setCreateTime(DateUtil.currentDate());
                    bizMapBO.setModifyTime(DateUtil.currentDate());
                    bizMapBO.setName(ParamUtil.getString((Map)bizMap, (String)"name"));
                    bizMapBO.setOrgId(Long.valueOf(AppContext.currentAccountId()));
                    bizMapBO.setState(ParamUtil.getInt((Map)bizMap, (String)"state"));
                    bizMapBO.setLayout(ParamUtil.getString((Map)bizMap, (String)"layout"));
                    bizMapBO.setLayoutType(ParamUtil.getInt((Map)bizMap, (String)"layoutType"));
                    List bizMapItemBoList = (List)bizMap.get("bizMapItem");
                    ArrayList<CtpBizMapItem> ctpBizMapItemList = new ArrayList<CtpBizMapItem>();
                    if (Strings.isNotEmpty((Collection)bizMapItemBoList)) {
                        for (Map bizMapItem : bizMapItemBoList) {
                            CtpBizMapItem ctpBizMapItem = new CtpBizMapItem();
                            Long bizMapItemId = ParamUtil.getLong((Map)bizMapItem, (String)"id");
                            if (isResetId) {
                                ctpBizMapItem.setId(businessDataBean.genNewIdByOldId(bizMapItemId));
                            } else {
                                boolean conflict = false;
                                if (businessDataBean.isUpgrade()) {
                                    bizMapItemId = businessDataBean.getRealId4Upgrade(bizMapItemId);
                                    Long mapId = ParamUtil.getLong((Map)bizMapItem, (String)"mapId", (Long)0L);
                                    CtpBizMap ctpBizMap = this.bizMapManager.getBizMap(oldMapId);
                                    if (ctpBizMap != null && !ctpBizMap.getId().equals(mapId)) {
                                        conflict = true;
                                    }
                                }
                                ctpBizMapItem.setId(businessDataBean.genNewIdByOldId(bizMapItemId, conflict, false));
                            }
                            ctpBizMapItem.setOrgId(Long.valueOf(AppContext.currentAccountId()));
                            ctpBizMapItem.setMapId(bizMapBO.getId());
                            ctpBizMapItem.setParam(ParamUtil.getString((Map)bizMapItem, (String)"param"));
                            ctpBizMapItem.setPosition(ParamUtil.getString((Map)bizMapItem, (String)"position"));
                            ctpBizMapItem.setItemType(ParamUtil.getInt((Map)bizMapItem, (String)"itemType"));
                            ctpBizMapItem.setTitle(ParamUtil.getString((Map)bizMapItem, (String)"title"));
                            ctpBizMapItem.setUrl(ParamUtil.getString((Map)bizMapItem, (String)"url"));
                            String url = ParamUtil.getString((Map)bizMapItem, (String)"url");
                            if (Strings.isNotEmpty((String)url)) {
                                url = url.replace(bizId + "", newBizId + "");
                            }
                            if (ctpBizMapItem.getParams() == null) continue;
                            String param = ctpBizMapItem.getParam();
                            Map map = ctpBizMapItem.getParams();
                            String linkType = ParamUtil.getString((Map)map, (String)"linkType");
                            if (!Strings.isNotEmpty((String)linkType)) continue;
                            Long sourceValue = ParamUtil.getLong((Map)map, (String)"sourceValue");
                            Long formAppmainId = ParamUtil.getLong((Map)map, (String)"formAppmainId");
                            if (sourceValue != null) {
                                Long sourceValueNew = businessDataBean.genNewIdByOldId(sourceValue);
                                param = param.replace(sourceValue + "", sourceValueNew + "");
                                if (Strings.isNotEmpty((String)url)) {
                                    url = url.replace(sourceValue + "", sourceValueNew + "");
                                }
                            }
                            if (formAppmainId != null && !formAppmainId.equals(-1L)) {
                                Long formAppmainIdNew = businessDataBean.genNewIdByOldId(formAppmainId);
                                param = param.replace(formAppmainId + "", formAppmainIdNew + "");
                                if (Strings.isNotEmpty((String)url)) {
                                    url = url.replace(formAppmainId + "", formAppmainIdNew + "");
                                }
                            }
                            ctpBizMapItem.setParam(param);
                            ctpBizMapItem.setUrl(url);
                            ctpBizMapItemList.add(ctpBizMapItem);
                        }
                    }
                    if (Strings.isNotEmpty(ctpBizMapItemList)) {
                        bizMapBO.setCtpBizMapItemList(ctpBizMapItemList);
                    } else {
                        bizMapBO.setCtpBizMapItemList(new ArrayList());
                    }
                    List formModuleAuthMapList = (List)bizMap.get("formModuleAuth");
                    ArrayList<FormModuleAuth> formModuleAuthList = new ArrayList<FormModuleAuth>();
                    if (Strings.isNotEmpty((Collection)formModuleAuthMapList)) {
                        for (Map authMap : formModuleAuthMapList) {
                            FormModuleAuth formModuleAuth = new FormModuleAuth();
                            Long moduleAuthId = ParamUtil.getLong((Map)authMap, (String)"id");
                            if (isResetId) {
                                formModuleAuth.setId(businessDataBean.genNewIdByOldId(moduleAuthId));
                            } else {
                                boolean conflict = false;
                                if (businessDataBean.isUpgrade()) {
                                    moduleAuthId = businessDataBean.getRealId4Upgrade(moduleAuthId);
                                    Long moduleId = ParamUtil.getLong((Map)authMap, (String)"moduleId", (Long)0L);
                                    CtpBizMap ctpBizMap = this.bizMapManager.getBizMap(oldMapId);
                                    if (ctpBizMap != null && !bizMapBO.getId().equals(moduleId)) {
                                        conflict = true;
                                    }
                                }
                                formModuleAuth.setId(businessDataBean.genNewIdByOldId(moduleAuthId, conflict, false));
                            }
                            formModuleAuth.setFormId(businessDataBean.genNewIdByOldId(ParamUtil.getLong((Map)authMap, (String)"formId")));
                            formModuleAuth.setModuleName(ParamUtil.getString((Map)authMap, (String)"moduleName"));
                            formModuleAuth.setModuleType(ParamUtil.getInt((Map)authMap, (String)"moduleType"));
                            formModuleAuth.setState(ParamUtil.getInt((Map)authMap, (String)"state"));
                            formModuleAuth.setOrgType(ParamUtil.getInt((Map)authMap, (String)"orgType"));
                            formModuleAuth.setModuleId(businessDataBean.genNewIdByOldId(ParamUtil.getLong((Map)authMap, (String)"moduleId")));
                            formModuleAuth.setOrgId(ParamUtil.getLong((Map)authMap, (String)"orgId"));
                            formModuleAuth.putExtraAttr("showName", ParamUtil.getString((Map)authMap, (String)"showName"));
                            formModuleAuthList.add(formModuleAuth);
                        }
                    }
                    if (Strings.isNotEmpty(formModuleAuthList)) {
                        bizMapBO.setFormModuleAuthList(formModuleAuthList);
                    }
                    bizMapList.add(bizMapBO);
                }
                if (businessDataBean.isUpgrade()) {
                    businessDataBean.getAppUpgradeCacheBean().setBizMapBoList(bizMapList);
                }
                businessDataBean.setBizMapBoList(bizMapList);
            }
        }
    }

    public void redirectBusiness(BusinessRedirectDataBean businessRedirectDataBean, BusinessDataBean businessDataBean) throws BusinessException {
        List bizMapBoList = businessDataBean.getBizMapBoList();
        for (BizMapBo bizMapBo : bizMapBoList) {
            List formModuleAuthList;
            List formModuleList;
            CtpBizMap ctpBizMap;
            LinkedHashSet<Long> localModuleId = new LinkedHashSet<Long>();
            if (businessDataBean.isUpgrade() && (ctpBizMap = this.bizMapManager.getBizMap(bizMapBo.getId())) != null && Strings.isNotEmpty((Collection)(formModuleList = ctpBizMap.getModuleAuthList()))) {
                for (FormModuleAuth formModuleAuth : formModuleList) {
                    localModuleId.add(formModuleAuth.getModuleId());
                }
            }
            if (null == (formModuleAuthList = bizMapBo.getFormModuleAuthList())) continue;
            for (FormModuleAuth formModuleAuth : formModuleAuthList) {
                int orgTypeInt = formModuleAuth.getOrgType();
                Long orgId = formModuleAuth.getOrgId();
                String orgType = Enums.FormModuleAuthOrgType.getFormModuleAuthOrgTypeByKey((int)orgTypeInt).getText();
                V3xOrgEntity entity = this.orgManager.getEntity(orgType, orgId);
                if (null != entity || businessDataBean.isUpgrade() && Strings.isNotEmpty(localModuleId) && localModuleId.contains(formModuleAuth.getModuleId())) continue;
                String orgName = (String)formModuleAuth.getExtraAttr("showName");
                String key = BusinessRedirectDataBean.createKey((String)(orgType + ""), (String)orgName);
                BusinessRedirectResultBean4Authorization authorization = new BusinessRedirectResultBean4Authorization();
                authorization.setAuthorizationType(BusinessRedirectResultBean4Authorization.AuthorizationType.BIZMAP.name());
                authorization.setSourceId(formModuleAuth.getId());
                authorization.setOldValue4Show(orgName);
                authorization.setOldValue4System(orgId + "");
                authorization.setOrgType(orgType + "");
                businessRedirectDataBean.addResultBean(key, (BusinessRedirectResultBean)authorization);
                HashMap<String, String> valueMap = new HashMap<String, String>();
                valueMap.put(BusinessEnums.AuthorizationDetailKey.LOCATION.getKey(), ResourceUtil.getString((String)"form.import.export.auth.details"));
                valueMap.put(BusinessEnums.AuthorizationDetailKey.TYPE.getKey(), ResourceUtil.getString((String)"cap.template.portal.map"));
                valueMap.put(BusinessEnums.AuthorizationDetailKey.AUTH_ITEM.getKey(), bizMapBo.getName());
                businessRedirectDataBean.addRedirectDetail(key, authorization.getCategory(), valueMap);
            }
        }
    }

    public void mergeRedirectData(Map<String, List<Map<String, Object>>> redirectData, BizConfigBean bizConfigBean, AppUpgradeCacheBean appUpgradeCacheBean) throws BusinessException {
        List<Map<String, Object>> authList = redirectData.get("authorization");
        if (Strings.isNotEmpty(authList)) {
            ArrayList<Long> authIdList = new ArrayList<Long>();
            HashMap<Long, String> authModuleMap = new HashMap<Long, String>();
            for (Map<String, Object> authMap : authList) {
                String authorizationType = ParamUtil.getString(authMap, (String)"authorizationType");
                if (!BusinessRedirectResultBean4Authorization.AuthorizationType.BIZMAP.name().equals(authorizationType)) continue;
                String newValue4System = ParamUtil.getString(authMap, (String)"newValue4System");
                Long sourceId = ParamUtil.getLong(authMap, (String)"sourceId", (Long)0L);
                authIdList.add(sourceId);
                authModuleMap.put(sourceId, newValue4System);
            }
            if (appUpgradeCacheBean != null) {
                List bizMapBoList = appUpgradeCacheBean.getBizMapBoList();
                if (Strings.isNotEmpty((Collection)bizMapBoList)) {
                    for (BizMapBo bizMapBo : bizMapBoList) {
                        List formModuleAuthList = bizMapBo.getFormModuleAuthList();
                        if (formModuleAuthList == null) continue;
                        for (FormModuleAuth formModuleAuth : formModuleAuthList) {
                            if (authModuleMap == null || !authModuleMap.containsKey(formModuleAuth.getId())) continue;
                            Long orgId = Long.parseLong((String)authModuleMap.get(formModuleAuth.getId()));
                            formModuleAuth.setOrgId(orgId);
                        }
                    }
                }
            } else if (Strings.isNotEmpty(authIdList)) {
                List formModuleAuths = this.formAuthModuleDAO.selectByIds(authIdList);
                for (FormModuleAuth formModuleAuth : formModuleAuths) {
                    Long orgId = Long.parseLong((String)authModuleMap.get(formModuleAuth.getId()));
                    formModuleAuth.setOrgId(orgId);
                }
                this.formAuthModuleDAO.saveOrUpdate(formModuleAuths);
            }
        }
    }

    public void clearBusinessData(BizConfigBean bizConfigBean) {
        try {
            List ctpBizMapList = this.bizMapManager.getBizMapByBizId(bizConfigBean.getId());
            ArrayList<Long> bizMapIdList = new ArrayList<Long>();
            for (CtpBizMap ctpBizMap : ctpBizMapList) {
                bizMapIdList.add(ctpBizMap.getId());
            }
            this.bizMapManager.deleteBizMap(bizMapIdList);
        }
        catch (BusinessException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void rollBackImportData(BusinessDataBean businessDataBean, List directDeleteList) throws BusinessException {
        List bizMapBoList = businessDataBean.getBizMapBoList();
        ArrayList<Long> bizMapIdList = new ArrayList<Long>();
        for (BizMapBo bizMapBo : bizMapBoList) {
            bizMapIdList.add(bizMapBo.getId());
        }
        this.bizMapManager.deleteBizMap(bizMapIdList);
    }

    public void saveImportData(BusinessDataBean businessDataBean, List directSaveList) throws BusinessException {
        List bizMapBoList = businessDataBean.getBizMapBoList();
        if (Strings.isNotEmpty((Collection)bizMapBoList)) {
            ArrayList<BizMapBo> bizMapBoListSave = new ArrayList<BizMapBo>();
            Long bizId = businessDataBean.getBizConfigBean().getId();
            for (BizMapBo bizMapBo : bizMapBoList) {
                if (bizMapBo.getBizId() == null || !bizId.equals(bizMapBo.getBizId())) continue;
                bizMapBoListSave.add(bizMapBo);
            }
            if (Strings.isNotEmpty(bizMapBoListSave)) {
                this.bizMapManager.saveAllBizMap4Cap4(bizMapBoListSave);
            }
        }
    }

    public void finalSaveRedirectData(BizConfigBean bizConfigBean) throws BusinessException {
        List ctpBizMapList = this.bizMapManager.getBizMapByBizId(bizConfigBean.getId());
        if (Strings.isNotEmpty((Collection)ctpBizMapList)) {
            for (CtpBizMap ctpBizMap : ctpBizMapList) {
                CtpBizMap cbm = this.bizMapManager.getBizMap(ctpBizMap.getId());
                cbm.setDelFlag(Integer.valueOf(0));
                cbm.setState(Integer.valueOf(Enums.BizMapState.activated.getKey()));
                this.bizMapManager.updateBizMap(cbm);
            }
        }
    }

    public Map<String, Object> getJsonMap4BizExport(BusinessDataBean businessDataBean, BizMapBo bizMapBo) {
        HashMap<String, Object> jsonMap = new HashMap<String, Object>(16);
        if (bizMapBo != null) {
            jsonMap.put("id", businessDataBean.getRealId4Export(bizMapBo.getId()));
            jsonMap.put("name", bizMapBo.getName());
            jsonMap.put("bizId", businessDataBean.getRealId4Export(bizMapBo.getBizId()));
            jsonMap.put("attId", bizMapBo.getAttId());
            jsonMap.put("layoutType", bizMapBo.getLayoutType());
            jsonMap.put("delFlag", bizMapBo.getDelFlag());
            jsonMap.put("layout", bizMapBo.getLayout());
            jsonMap.put("state", bizMapBo.getState());
            jsonMap.put("htmlContent", bizMapBo.getHtmlContent());
            try {
                List formModuleAuthList = this.bizMapManager.getBizMapAuth(bizMapBo.getId());
                ArrayList formModuleAuthMapList = new ArrayList();
                for (FormModuleAuth formModuleAuth : formModuleAuthList) {
                    HashMap<String, Object> result = new HashMap<String, Object>();
                    result.put("id", businessDataBean.getRealId4Export(formModuleAuth.getId()));
                    result.put("formId", formModuleAuth.getFormId() == null ? "" : businessDataBean.getRealId4Export(formModuleAuth.getFormId()));
                    result.put("moduleName", formModuleAuth.getModuleName());
                    result.put("moduleType", formModuleAuth.getModuleType());
                    result.put("state", formModuleAuth.getState());
                    result.put("orgType", formModuleAuth.getOrgType());
                    result.put("orgId", formModuleAuth.getOrgId());
                    result.put("moduleId", businessDataBean.getRealId4Export(formModuleAuth.getModuleId()));
                    int orgType = formModuleAuth.getOrgType();
                    Object entity = null;
                    entity = Enums.FormModuleAuthOrgType.Member.getKey() == orgType ? this.orgManager.getMemberById(formModuleAuth.getOrgId()) : (Enums.FormModuleAuthOrgType.Department.getKey() == orgType ? this.orgManager.getDepartmentById(formModuleAuth.getOrgId()) : (Enums.FormModuleAuthOrgType.Team.getKey() == orgType ? this.orgManager.getTeamById(formModuleAuth.getOrgId()) : (Enums.FormModuleAuthOrgType.Level.getKey() == orgType ? this.orgManager.getLevelById(formModuleAuth.getOrgId()) : (Enums.FormModuleAuthOrgType.Post.getKey() == orgType ? this.orgManager.getPostById(formModuleAuth.getOrgId()) : (Enums.FormModuleAuthOrgType.Account.getKey() == orgType ? this.orgManager.getAccountById(formModuleAuth.getOrgId()) : this.orgManager.getEntityOnlyById(formModuleAuth.getOrgId()))))));
                    if (null != entity) {
                        result.put("showName", entity.getName());
                    } else {
                        this.logger.info((Object)("\u901a\u8fc7\u7ec4\u7ec7\u673a\u6784" + formModuleAuth.getOrgId() + "\u627e\u4e0d\u5230\u5bf9\u5e94\u7ec4\u7ec7\uff01"));
                    }
                    formModuleAuthMapList.add(result);
                }
                jsonMap.put("formModuleAuth", formModuleAuthMapList);
            }
            catch (BusinessException e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
            List bizMapItemBoList = bizMapBo.getBizMapItem();
            if (Strings.isNotEmpty((Collection)bizMapItemBoList)) {
                ArrayList bizMapItemList = new ArrayList();
                for (BizMapItemBo bizMapItemBo : bizMapItemBoList) {
                    int sourceType;
                    Map map = bizMapItemBo.getParams();
                    String linkType = ParamUtil.getString((Map)map, (String)"linkType");
                    if (Strings.isNotEmpty((String)linkType) && ((sourceType = ParamUtil.getInt((Map)map, (String)"sourceType").intValue()) == Enums.SourceType.SOURCE_TYPE_QUERY.getKey() || sourceType == Enums.SourceType.SOURCE_TYPE_REPORT.getKey() || sourceType == Enums.SourceType.SOURCE_TYPE_DOCUMENT.getKey() || sourceType == Enums.SourceType.SOURCE_TYPE_ADMIN_BUL.getKey() || sourceType == Enums.SourceType.SOURCE_TYPE_ADMIN_NEWS.getKey() || sourceType == Enums.SourceType.SOURCE_TYPE_ADMIN_BBS.getKey() || sourceType == Enums.SourceType.SOURCE_TYPE_ADMIN_INQUIRY.getKey() || sourceType == Enums.SourceType.SOURCE_TYPE_GROUP_BUL.getKey() || sourceType == Enums.SourceType.SOURCE_TYPE_GROUP_NEWS.getKey() || sourceType == Enums.SourceType.SOURCE_TYPE_GROUP_BBS.getKey() || sourceType == Enums.SourceType.SOURCE_TYPE_GROUP_INQUIRY.getKey())) continue;
                    HashMap<String, Object> bizMapItem = new HashMap<String, Object>(16);
                    bizMapItem.put("id", businessDataBean.getRealId4Export(bizMapItemBo.getId()));
                    bizMapItem.put("mapId", businessDataBean.getRealId4Export(bizMapItemBo.getMapId()));
                    bizMapItem.put("title", bizMapItemBo.getTitle());
                    bizMapItem.put("itemType", bizMapItemBo.getItemType());
                    bizMapItem.put("url", bizMapItemBo.getUrl());
                    bizMapItem.put("position", bizMapItemBo.getPosition());
                    bizMapItem.put("param", bizMapItemBo.getParam());
                    bizMapItem.put("orgId", bizMapItemBo.getOrgId());
                    bizMapItemList.add(bizMapItem);
                }
                jsonMap.put("bizMapItem", bizMapItemList);
            }
        }
        return jsonMap;
    }

    public void completeUpgrade(AppUpgradeCacheBean appUpgradeCacheBean) throws BusinessException {
        List bizMapBoList = appUpgradeCacheBean.getBizMapBoList();
        if (Strings.isNotEmpty((Collection)bizMapBoList)) {
            RollbackCacheBean rollbackCacheBean = appUpgradeCacheBean.getRollbackCacheBean();
            ArrayList<BizMapBo> bizMapBoListSave = new ArrayList<BizMapBo>();
            ArrayList<BizMapBo> bizMapBoListUpdate = new ArrayList<BizMapBo>();
            Long bizId = appUpgradeCacheBean.getBizConfigBean().getId();
            List localCtpBizMapList = this.bizMapManager.getBizMapByBizId(bizId);
            HashSet<Long> localMapIds = new HashSet<Long>();
            for (CtpBizMap ctpBizMap : localCtpBizMapList) {
                localMapIds.add(ctpBizMap.getId());
            }
            ArrayList formModuleAuths = new ArrayList();
            for (BizMapBo bizMapBo : bizMapBoList) {
                if (bizMapBo.getBizId() == null || !bizId.equals(bizMapBo.getBizId())) continue;
                bizMapBo.setDelFlag(Integer.valueOf(0));
                if (localMapIds.contains(bizMapBo.getId())) {
                    rollbackCacheBean.addUpdateCtpBizMap(bizMapBo.getCtpBizMap());
                    bizMapBoListUpdate.add(bizMapBo);
                    continue;
                }
                bizMapBoListSave.add(bizMapBo);
                rollbackCacheBean.addNewCtpBizMap(bizMapBo.getId());
                if (!Strings.isNotEmpty((Collection)bizMapBo.getFormModuleAuthList())) continue;
                formModuleAuths.addAll(bizMapBo.getFormModuleAuthList());
            }
            if (Strings.isNotEmpty(formModuleAuths)) {
                this.formAuthModuleDAO.saveOrUpdate(formModuleAuths);
            }
            if (Strings.isNotEmpty(bizMapBoListUpdate)) {
                for (BizMapBo bizMapBo : bizMapBoListUpdate) {
                    this.bizMapManager.updateBizMap(bizMapBo.getCtpBizMap());
                }
            }
            if (Strings.isNotEmpty(bizMapBoListSave)) {
                this.bizMapManager.saveAllBizMap4Cap4(bizMapBoListSave);
            }
        }
    }

    public void afterCommit(AppUpgradeCacheBean appUpgradeCacheBean) throws BusinessException {
        List bizMapBoList;
        if (SystemEnvironment.isClusterEnabled() && Strings.isNotEmpty((Collection)(bizMapBoList = appUpgradeCacheBean.getBizMapBoList()))) {
            for (BizMapBo bizMapBo : bizMapBoList) {
                this.formCacheManager.sendNotification((Object)bizMapBo.getId(), FormCache.FormCacheType.BizMap_reload);
            }
        }
    }

    public void restoreCache(AppUpgradeCacheBean appUpgradeCacheBean) throws BusinessException {
        RollbackCacheBean rollbackCacheBean = appUpgradeCacheBean.getRollbackCacheBean();
        if (rollbackCacheBean != null) {
            List newCtpBizMapIds = rollbackCacheBean.getNewCtpBizMap();
            for (Long mapId : newCtpBizMapIds) {
                this.bizMapManager.deleteBizMapCache(mapId);
            }
            List updateCtpBizMapIds = rollbackCacheBean.getUpdateCtpBizMap();
            for (CtpBizMap ctpBizMap : updateCtpBizMapIds) {
                this.bizMapManager.deleteBizMapCache(ctpBizMap.getId());
                this.bizMapManager.getBizMap(ctpBizMap.getId());
            }
        }
    }

    public void setFormCacheManager(FormCacheManager formCacheManager) {
        this.formCacheManager = formCacheManager;
    }

    public void setBizMapManager(BizMapManager bizMapManager) {
        this.bizMapManager = bizMapManager;
    }

    public void setBizMapItemManager(BizMapItemManager bizMapItemManager) {
        this.bizMapItemManager = bizMapItemManager;
    }

    public void setFormAuthModuleDAO(FormAuthModuleDAO formAuthModuleDAO) {
        this.formAuthModuleDAO = formAuthModuleDAO;
    }

    public void setOrgManager(OrgManager orgManager) {
        this.orgManager = orgManager;
    }
}

