/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.importandexport;

import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormFormulaBean;
import com.seeyon.cap4.form.bean.FormRelationshipBean;
import com.seeyon.cap4.form.bean.FormRelationshipMapBean;
import com.seeyon.cap4.form.bean.FormTriggerBean;
import com.seeyon.cap4.form.bean.FormTriggerConditionBean;
import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.cap4.form.modules.engin.businessRelation.CAP4FormBusinessRelationDAO;
import com.seeyon.cap4.form.modules.engin.businessRelation.CAP4FormBusinessRelationManager;
import com.seeyon.cap4.form.modules.engin.relation.FormRelationEnums;
import com.seeyon.cap4.form.modules.engin.trigger.CAP4FormTriggerManager;
import com.seeyon.cap4.form.modules.engin.trigger.CAP4FormTriggerRecordDAO;
import com.seeyon.cap4.form.modules.engin.trigger.FormTriggerUtil;
import com.seeyon.cap4.form.modules.importandexport.AbstractBusinessModuleExportManager;
import com.seeyon.cap4.form.modules.importandexport.AppUpgradeCacheBean;
import com.seeyon.cap4.form.modules.importandexport.BusinessDataBean;
import com.seeyon.cap4.form.modules.importandexport.BusinessRedirectDataBean;
import com.seeyon.cap4.form.modules.importandexport.CompatibilityDetectionResultBean;
import com.seeyon.cap4.form.po.CAPFormBusinessRelation;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.form.util.FormDesignUtil;
import com.seeyon.cap4.magic.manager.ICAP4MagicManager;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.BasePO;
import com.seeyon.ctp.form.modules.engin.formula.FormulaDAO;
import com.seeyon.ctp.form.po.CtpFormula;
import com.seeyon.ctp.util.DBAgent;
import com.seeyon.ctp.util.ParamUtil;
import com.seeyon.ctp.util.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;

public class BusinessModuleExportManager4BusinessRelation
extends AbstractBusinessModuleExportManager {
    private final Log logger = CtpLogFactory.getLog(BusinessModuleExportManager4BusinessRelation.class);
    private CAP4FormCacheManager cap4FormCacheManager;
    private CAP4FormBusinessRelationDAO cap4FormBusinessRelationDAO;
    private FormulaDAO formulaDAO;
    private CAP4FormTriggerRecordDAO cap4FormTriggerRecordDAO;
    private CAP4FormBusinessRelationManager cap4FormBusinessRelationManager;
    private ICAP4MagicManager cap4MagicManager;
    private CAP4FormTriggerManager cap4FormTriggerManager;

    public Integer getSort() {
        return 4;
    }

    public void exportData(BusinessDataBean businessDataBean, Map<String, Object> rootMap) throws BusinessException {
        ArrayList<Map> relationMapList = new ArrayList<Map>();
        ArrayList<Map> triggerMapList = new ArrayList<Map>();
        List formBeans = businessDataBean.getFormBeanList();
        for (FormBean formBean : formBeans) {
            if (null == formBean) continue;
            Set<FormRelationshipBean> relationList = this.cap4FormCacheManager.getFormRelationshipBeanListByFormId(formBean.getId());
            for (FormRelationshipBean relation : relationList) {
                if (FormRelationEnums.relationApplicationType.inner.getKey().equals(relation.getApplicationType()) && !FormRelationEnums.RelationObjType.RELATION_CURRENT_FORM.getKey().equals(relation.getRelationObjType())) continue;
                relationMapList.add(relation.getJsonMap4Export(businessDataBean));
            }
            Set<FormTriggerBean> triggerList = this.cap4FormCacheManager.getFormTriggerBeanListByFormId(formBean.getId());
            for (FormTriggerBean triggerBean : triggerList) {
                if (triggerBean.isDataMagic() || formBean.getId().longValue() == triggerBean.getTargetFormId()) continue;
                triggerMapList.add(triggerBean.getJsonMap4Export(businessDataBean));
            }
        }
        HashMap<String, ArrayList<Map>> businessRelationMap = new HashMap<String, ArrayList<Map>>();
        businessRelationMap.put("relation", relationMapList);
        businessRelationMap.put("trigger", triggerMapList);
        rootMap.put("businessRelation", businessRelationMap);
    }

    public void importData(BusinessDataBean businessDataBean, Map<String, Object> dataMap) throws BusinessException {
        List triggerMapList;
        Map businessRelationMap = (Map)dataMap.get("businessRelation");
        List relationMapList = (List)businessRelationMap.get("relation");
        if (Strings.isNotEmpty((Collection)relationMapList)) {
            for (Map jsonMap : relationMapList) {
                Long oldId;
                FormRelationshipBean formRelationshipBean;
                boolean conflict = false;
                if (!businessDataBean.isResetId() && null != (formRelationshipBean = this.cap4FormCacheManager.getFormRelationshipBean(oldId = ParamUtil.getLong((Map)jsonMap, (String)"id")))) {
                    if (businessDataBean.isUpgrade()) {
                        Long sourceFormId = businessDataBean.getRealId4Upgrade(ParamUtil.getLong((Map)jsonMap, (String)"sourceFormId"));
                        if (formRelationshipBean.getSourceFormId() != businessDataBean.genNewIdByOldId(sourceFormId).longValue()) {
                            conflict = true;
                        }
                    } else {
                        conflict = true;
                    }
                }
                businessDataBean.addRelationshipBean(new FormRelationshipBean(businessDataBean, jsonMap, conflict));
            }
        }
        if (Strings.isNotEmpty((Collection)(triggerMapList = (List)businessRelationMap.get("trigger")))) {
            for (Map jsonMap : triggerMapList) {
                List formulaMapList;
                Long oldId;
                FormTriggerBean formTriggerBean;
                boolean conflict = false;
                if (!businessDataBean.isResetId() && null != (formTriggerBean = this.cap4FormCacheManager.getFormTriggerBean(oldId = ParamUtil.getLong((Map)jsonMap, (String)"id")))) {
                    if (businessDataBean.isUpgrade()) {
                        Long sourceFormId = businessDataBean.getRealId4Upgrade(ParamUtil.getLong((Map)jsonMap, (String)"sourceFormId"));
                        if (formTriggerBean.getSourceFormId() != businessDataBean.genNewIdByOldId(sourceFormId).longValue()) {
                            conflict = true;
                        }
                    } else {
                        conflict = true;
                    }
                }
                if (Strings.isNotEmpty((Collection)(formulaMapList = (List)jsonMap.get("formulaList")))) {
                    Long oldSourceFormId = Long.valueOf(jsonMap.get("sourceFormId").toString());
                    if (businessDataBean.isUpgrade()) {
                        oldSourceFormId = businessDataBean.getRealId4Upgrade(oldSourceFormId);
                    }
                    Long newSourceFormId = businessDataBean.getNewIdByOldId(oldSourceFormId);
                    FormBean sourceForm = businessDataBean.isUpgrade() ? businessDataBean.getAppUpgradeCacheBean().getForm(newSourceFormId) : this.cap4FormCacheManager.getForm(newSourceFormId);
                    for (Map formulaMap : formulaMapList) {
                        FormDesignUtil.getFormulaFromMap4Import((BusinessDataBean)businessDataBean, (Map)formulaMap, (FormBean)sourceForm, (int)2, (boolean)true);
                    }
                }
                FormTriggerBean triggerBean = new FormTriggerBean(jsonMap, businessDataBean, conflict);
                businessDataBean.addTriggerBean(triggerBean);
            }
        }
    }

    public void compatibilityDetection(BusinessDataBean businessDataBean, CompatibilityDetectionResultBean resultBean) throws BusinessException {
        List allImportForm = businessDataBean.getAppUpgradeCacheBean().getAllForm();
        for (FormBean newImpFormBean : allImportForm) {
            FormBean cacheFormBean = this.cap4FormCacheManager.getForm(newImpFormBean.getId());
            if (cacheFormBean == null) continue;
            List oldFormRelationshipIdList = cacheFormBean.getFormRelationshipIdList();
            List relationshipBeanList = businessDataBean.getRelationshipBeanList();
            this.relationMerge(businessDataBean, oldFormRelationshipIdList, relationshipBeanList, Enums.FormBusinessRelationType.RELATION.getKey());
            List oldFormTriggerIdList = cacheFormBean.getFormTriggerIdList();
            List triggerBeanList = businessDataBean.getTriggerBeanList();
            this.relationMerge(businessDataBean, oldFormTriggerIdList, triggerBeanList, Enums.FormBusinessRelationType.TRIGGER.getKey());
        }
    }

    private void relationMerge(BusinessDataBean businessDataBean, List<Long> oldRelationIds, Object businessRelations, String formBusinessRelationType) {
        Iterator<Long> oldIterator = oldRelationIds.iterator();
        Iterator iterator = ((List)businessRelations).iterator();
        ArrayList<Long> newRelationIds = new ArrayList<Long>();
        while (iterator.hasNext()) {
            newRelationIds.add(((BasePO)iterator.next()).getId());
        }
        while (oldIterator.hasNext()) {
            long next2 = oldIterator.next();
            if (!newRelationIds.contains(next2)) continue;
            if (Enums.FormBusinessRelationType.TRIGGER.getKey().equals(formBusinessRelationType)) {
                FormTriggerBean formTriggerBean = this.cap4FormCacheManager.getFormTriggerBean(next2);
                businessDataBean.addLocalTriggerBeanNeedDelete(formTriggerBean);
                continue;
            }
            FormRelationshipBean formRelationshipBean = this.cap4FormCacheManager.getFormRelationshipBean(next2);
            businessDataBean.addLocalRelationshipBeanNeedDelete(formRelationshipBean);
        }
    }

    private List<String> getAllRelationNames(Map<Long, FormRelationshipBean> map) {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<Long, FormRelationshipBean> next : map.entrySet()) {
            list.add(next.getValue().getName());
        }
        return list;
    }

    private List<String> getAllTriggerNames(Map<Long, FormTriggerBean> map) {
        ArrayList<String> list = new ArrayList<String>();
        Iterator<Map.Entry<Long, FormTriggerBean>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            list.add(iterator.next().getValue().getName());
        }
        return list;
    }

    private String getRelationName(List<String> conflictNames, String name) {
        if (conflictNames.contains(name)) {
            name = this.getRelationName(conflictNames, name + "1");
        } else {
            conflictNames.add(name);
        }
        return name;
    }

    public void saveImportData(BusinessDataBean businessDataBean, List directSaveList) throws BusinessException {
        directSaveList.addAll(businessDataBean.getSingleHandFormulaList());
        for (FormRelationshipBean relationshipBean : businessDataBean.getRelationshipBeanList()) {
            directSaveList.add(relationshipBean.toCAPFormBusinessRelation());
        }
        for (FormTriggerBean triggerBean : businessDataBean.getTriggerBeanList()) {
            directSaveList.add(triggerBean.toCAPFormBusinessRelation());
        }
    }

    public void rollBackImportData(BusinessDataBean businessDataBean, List directDeleteList) throws BusinessException {
        directDeleteList.addAll(businessDataBean.getSingleHandFormulaList());
        for (FormRelationshipBean relationshipBean : businessDataBean.getRelationshipBeanList()) {
            directDeleteList.add(relationshipBean.toCAPFormBusinessRelation());
        }
        for (FormTriggerBean triggerBean : businessDataBean.getTriggerBeanList()) {
            directDeleteList.add(triggerBean.toCAPFormBusinessRelation());
        }
        this.clearSessionContent(businessDataBean.getBizConfigBean().getId());
    }

    public void redirectBusiness(BusinessRedirectDataBean businessRedirectDataBean, BusinessDataBean businessDataBean) throws BusinessException {
        ArrayList importTriggerList;
        this.clearSessionContent(businessDataBean.getBizConfigBean().getId());
        ArrayList importRelationList = new ArrayList(businessDataBean.getRelationshipBeanList());
        if (Strings.isNotEmpty(importRelationList)) {
            ArrayList<Long> relationIdList = new ArrayList<Long>();
            for (FormRelationshipBean relation : importRelationList) {
                FormRelationshipBean cacheRelationBean = !businessDataBean.isUpgrade() ? this.cap4FormCacheManager.getFormRelationshipBean(relation.getId()) : relation;
                relationIdList.add(relation.getId());
                boolean needRedirect = false;
                if (FormRelationEnums.relationApplicationType.between.getKey().equals(cacheRelationBean.getApplicationType()) && (cacheRelationBean.isUserRelation() || cacheRelationBean.isIncreaseRowRelation())) {
                    needRedirect = true;
                }
                if (FormRelationEnums.relationApplicationType.inner.getKey().equals(cacheRelationBean.getApplicationType()) && cacheRelationBean.isUserRelation() && FormRelationEnums.RelationObjType.RELATION_CURRENT_FORM.getKey().equals(cacheRelationBean.getRelationObjType())) {
                    needRedirect = true;
                }
                if (!needRedirect) continue;
                this.cap4FormBusinessRelationManager.redirectBusiness(businessRedirectDataBean, businessDataBean, cacheRelationBean);
            }
            AppContext.putSessionContext((String)(AppContext.currentUserId() + "_" + businessDataBean.getBizConfigBean().getId() + "_relation"), relationIdList);
        }
        if (Strings.isNotEmpty(importTriggerList = new ArrayList(businessDataBean.getTriggerBeanList()))) {
            ArrayList<Long> triggerIdList = new ArrayList<Long>();
            for (FormTriggerBean triggerBean : importTriggerList) {
                if (triggerBean.isDataMagic()) continue;
                if (businessDataBean.isUpgrade()) {
                    triggerBean.redirectBusiness(businessDataBean, businessRedirectDataBean);
                } else {
                    FormTriggerBean cacheTriggerBean = this.cap4FormCacheManager.getFormTriggerBean(triggerBean.getId());
                    cacheTriggerBean.redirectBusiness(businessDataBean, businessRedirectDataBean);
                    businessDataBean.getTriggerBeanList().remove(triggerBean);
                    businessDataBean.getTriggerBeanList().add(cacheTriggerBean);
                }
                triggerIdList.add(triggerBean.getId());
            }
            AppContext.putSessionContext((String)(AppContext.currentUserId() + "_" + businessDataBean.getBizConfigBean().getId() + "_trigger"), triggerIdList);
        }
    }

    public void mergeRedirectData(Map<String, List<Map<String, Object>>> redirectData, BizConfigBean bizConfigBean, AppUpgradeCacheBean appUpgradeCacheBean) throws BusinessException {
        List triggerIdList;
        List<Map<String, Object>> redirectMapList = redirectData.get("businessRelation");
        if (Strings.isEmpty(redirectMapList)) {
            return;
        }
        HashMap<Long, ArrayList<Map<String, Object>>> assortedRedirectMap = new HashMap<Long, ArrayList<Map<String, Object>>>();
        for (Map<String, Object> map : redirectMapList) {
            Long sourceId = Long.valueOf(map.get("sourceId").toString());
            ArrayList<Map<String, Object>> list = (ArrayList<Map<String, Object>>)assortedRedirectMap.get(sourceId);
            if (list == null) {
                list = new ArrayList<Map<String, Object>>();
                assortedRedirectMap.put(sourceId, list);
            }
            list.add(map);
        }
        List formBeanList = appUpgradeCacheBean == null ? null : appUpgradeCacheBean.getAllForm();
        List relationIdList = (List)AppContext.getSessionContext((String)(AppContext.currentUserId() + "_" + bizConfigBean.getId() + "_relation"));
        if (Strings.isNotEmpty((Collection)relationIdList)) {
            for (Long relationId : relationIdList) {
                FormRelationshipBean relationBean = appUpgradeCacheBean != null ? appUpgradeCacheBean.getFormRelationshipBean(relationId) : this.cap4FormCacheManager.getFormRelationshipBean(relationId);
                List redirectMap = (List)assortedRedirectMap.get(relationId);
                if (redirectMap == null || redirectMap.isEmpty()) continue;
                this.cap4FormBusinessRelationManager.updateRedirectData(redirectMap, relationBean, formBeanList);
                if (appUpgradeCacheBean == null) continue;
                FormBean formBean = appUpgradeCacheBean.getForm(Long.valueOf(relationBean.getSourceFormId()));
                for (FormRelationshipMapBean relationshipMapBean : relationBean.getRelationMapList()) {
                    if (relationshipMapBean.getConditionFormulaId() == 0L) continue;
                    CtpFormula ctpFormula = formBean.newCTPFormula4Save(relationshipMapBean.getConditionFormula(), 2);
                    appUpgradeCacheBean.addSingleHandFormula(ctpFormula);
                }
            }
        }
        if (Strings.isNotEmpty((Collection)(triggerIdList = (List)AppContext.getSessionContext((String)(AppContext.currentUserId() + "_" + bizConfigBean.getId() + "_trigger"))))) {
            for (Long triggerId : triggerIdList) {
                FormTriggerBean triggerBean = appUpgradeCacheBean != null ? appUpgradeCacheBean.getFormTriggerBean(triggerId) : this.cap4FormCacheManager.getFormTriggerBean(triggerId);
                List redirectMap = (List)assortedRedirectMap.get(triggerId);
                if (redirectMap == null || redirectMap.isEmpty()) continue;
                triggerBean.updateRedirectData(redirectMap, formBeanList);
                if (appUpgradeCacheBean == null) continue;
                List formulaList = triggerBean.getCtpFormulaList();
                for (CtpFormula formula : formulaList) {
                    appUpgradeCacheBean.addSingleHandFormula(formula);
                }
            }
        }
    }

    public void finalSaveRedirectData(BizConfigBean bizConfigBean) throws BusinessException {
        List triggerIdList;
        List relationIdList = (List)AppContext.getSessionContext((String)(AppContext.currentUserId() + "_" + bizConfigBean.getId() + "_relation"));
        if (Strings.isNotEmpty((Collection)relationIdList)) {
            ArrayList<CtpFormula> ctpFormulaList = new ArrayList<CtpFormula>();
            ArrayList<CtpFormula> newFormulaList = new ArrayList<CtpFormula>();
            for (Long relationId : relationIdList) {
                FormRelationshipBean relationBean = this.cap4FormCacheManager.getFormRelationshipBean(relationId);
                if (!relationBean.isUserRelation() && !relationBean.isIncreaseRowRelation()) continue;
                FormBean formBean = this.cap4FormCacheManager.getForm(relationBean.getSourceFormId());
                for (Object relationshipMapBean : relationBean.getRelationMapList()) {
                    if (relationshipMapBean.getConditionFormulaId() == 0L) continue;
                    ctpFormulaList.add(this.cap4FormCacheManager.getFormula(relationshipMapBean.getConditionFormulaId()));
                    CtpFormula ctpFormula = formBean.newCTPFormula4Save(relationshipMapBean.getConditionFormula(), 2);
                    newFormulaList.add(ctpFormula);
                }
            }
            if (Strings.isNotEmpty(ctpFormulaList)) {
                this.formulaDAO.deleteList(ctpFormulaList);
                this.formulaDAO.insertList(newFormulaList);
            }
        }
        if (Strings.isNotEmpty((Collection)(triggerIdList = (List)AppContext.getSessionContext((String)(AppContext.currentUserId() + "_" + bizConfigBean.getId() + "_trigger"))))) {
            for (Long triggerId : triggerIdList) {
                FormTriggerBean triggerBean = this.cap4FormCacheManager.getFormTriggerBean(triggerId);
                List formulaList = triggerBean.getFormulaList();
                ArrayList<CtpFormula> ctpFormulas = new ArrayList<CtpFormula>();
                for (FormFormulaBean formula : formulaList) {
                    CtpFormula ctpFormula = this.cap4FormCacheManager.getFormula(formula.getFormulaId());
                    if (ctpFormula == null) continue;
                    ctpFormulas.add(ctpFormula);
                }
                this.formulaDAO.deleteList(ctpFormulas);
                this.formulaDAO.insertList(triggerBean.getCtpFormulaList());
                this.cap4FormBusinessRelationDAO.deleteById(triggerBean.getId());
                CAPFormBusinessRelation businessRelation = triggerBean.toCAPFormBusinessRelation();
                this.cap4FormBusinessRelationDAO.save(businessRelation);
                FormBean sourceForm = this.cap4FormCacheManager.getForm(triggerBean.getSourceFormId());
                this.cap4FormTriggerRecordDAO.createTriggerRecordTable(FormTriggerUtil.getTriggerRecordName(sourceForm));
            }
        }
    }

    public void clearBusinessData(BizConfigBean bizConfigBean) {
        this.logger.info((Object)("clearBusinessData\u5f00\u59cb\u6267\u884c\u5e94\u7528\u5b89\u88c5\u4e1a\u52a1\u5173\u7cfb\u6570\u636e\u6e05\u7406\uff0c\u5e94\u7528id\uff1a" + bizConfigBean.getId()));
        ArrayList<CtpFormula> ctpFormulas = new ArrayList<CtpFormula>();
        ArrayList<CAPFormBusinessRelation> capFormBusinessRelations = new ArrayList<CAPFormBusinessRelation>();
        try {
            CtpFormula ctpFormula;
            List relationIdList = (List)AppContext.getSessionContext((String)(AppContext.currentUserId() + "_" + bizConfigBean.getId() + "_relation"));
            List triggerIdList = (List)AppContext.getSessionContext((String)(AppContext.currentUserId() + "_" + bizConfigBean.getId() + "_trigger"));
            this.clearSessionContent(bizConfigBean.getId());
            if (Strings.isNotEmpty((Collection)relationIdList)) {
                AppContext.removeSessionArrribute((String)(AppContext.currentUserId() + "_" + bizConfigBean.getId() + "_relation"));
                for (Long relationId : relationIdList) {
                    FormRelationshipBean formRelationshipBean = this.cap4FormCacheManager.getFormRelationshipBean(relationId);
                    if (formRelationshipBean == null) continue;
                    List relationshipMapList = formRelationshipBean.getRelationMapList();
                    for (FormRelationshipMapBean relationship : relationshipMapList) {
                        Long formulaId = relationship.getConditionFormulaId();
                        if (formulaId == 0L || null == (ctpFormula = this.cap4FormCacheManager.getFormula(formulaId))) continue;
                        ctpFormulas.add(ctpFormula);
                    }
                    capFormBusinessRelations.add(formRelationshipBean.toCAPFormBusinessRelation());
                }
            }
            if (Strings.isNotEmpty((Collection)triggerIdList)) {
                AppContext.removeSessionArrribute((String)(AppContext.currentUserId() + "_" + bizConfigBean.getId() + "_trigger"));
                for (Long id : triggerIdList) {
                    FormTriggerBean triggerBean = this.cap4FormCacheManager.getFormTriggerBean(id);
                    List formulaList = triggerBean.getFormulaList();
                    for (FormFormulaBean formula : formulaList) {
                        ctpFormula = this.cap4FormCacheManager.getFormula(formula.getFormulaId());
                        if (ctpFormula == null) continue;
                        ctpFormulas.add(ctpFormula);
                    }
                    capFormBusinessRelations.add(triggerBean.toCAPFormBusinessRelation());
                    FormBean sourceForm = this.cap4FormCacheManager.getForm(triggerBean.getSourceFormId());
                    this.cap4FormTriggerRecordDAO.dropRecordTable(FormTriggerUtil.getTriggerRecordName(sourceForm));
                }
            }
            if (!ctpFormulas.isEmpty()) {
                this.formulaDAO.deleteList(ctpFormulas);
                this.cap4FormCacheManager.removeFormula(ctpFormulas);
            }
            if (!capFormBusinessRelations.isEmpty()) {
                this.cap4FormBusinessRelationDAO.delete(capFormBusinessRelations);
            }
        }
        catch (Exception e) {
            this.logger.info((Object)("\u53d6\u6d88\u5b89\u88c5\u56de\u6eda\u6570\u636e\u5f02\u5e38\uff1a" + e.getMessage()), (Throwable)e);
        }
    }

    private void clearSessionContent(Long bizConfigId) {
        AppContext.removeSessionArrribute((String)(AppContext.currentUserId() + "_" + bizConfigId + "_relation"));
        AppContext.removeSessionArrribute((String)(AppContext.currentUserId() + "_" + bizConfigId + "_trigger"));
    }

    public void completeUpgrade(AppUpgradeCacheBean appUpgradeCacheBean) throws BusinessException {
        Map relationCacheMap = appUpgradeCacheBean.getRelationCacheMap();
        Map triggerCacheMap = appUpgradeCacheBean.getTriggerCacheMap();
        List<String> allRelationNames = this.getAllRelationNames(relationCacheMap);
        List<String> allTriggerNames = this.getAllTriggerNames(triggerCacheMap);
        Map localRelationshipBeanNeedDelete = appUpgradeCacheBean.getLocalRelationshipBeanNeedDelete();
        Map localTriggerBeanNeedDelete = appUpgradeCacheBean.getLocalTriggerBeanNeedDelete();
        this.deleteTrigger4Upgrade(localTriggerBeanNeedDelete, appUpgradeCacheBean);
        this.deleteRelation4Upgrade(localRelationshipBeanNeedDelete);
        ArrayList relationshipFormula = new ArrayList(appUpgradeCacheBean.getSingleHandFormulaMap().values());
        if (relationshipFormula.size() > 0) {
            ArrayList<Long> formulaIdList = new ArrayList<Long>();
            for (CtpFormula ctpFormula : relationshipFormula) {
                formulaIdList.add(ctpFormula.getId());
            }
            this.formulaDAO.deleteById(formulaIdList);
            this.formulaDAO.insertList(relationshipFormula);
        }
        for (Map.Entry next : relationCacheMap.entrySet()) {
            CAPFormBusinessRelation capFormBusinessRelation = ((FormRelationshipBean)next.getValue()).toCAPFormBusinessRelation();
            capFormBusinessRelation.setName(this.getRelationName(allRelationNames, capFormBusinessRelation.getName()));
            DBAgent.save((Object)capFormBusinessRelation);
        }
        for (Map.Entry next : triggerCacheMap.entrySet()) {
            CAPFormBusinessRelation capFormBusinessRelation = ((FormTriggerBean)next.getValue()).toCAPFormBusinessRelation();
            capFormBusinessRelation.setName(this.getRelationName(allTriggerNames, capFormBusinessRelation.getName()));
            DBAgent.save((Object)capFormBusinessRelation);
            FormBean sourceForm = appUpgradeCacheBean.getForm(Long.valueOf(((FormTriggerBean)next.getValue()).getSourceFormId()));
            this.cap4FormTriggerRecordDAO.createTriggerRecordTable(FormTriggerUtil.getTriggerRecordName(sourceForm));
        }
        this.clearSessionContent(appUpgradeCacheBean.getBizConfigBean().getId());
    }

    private void deleteTrigger4Upgrade(Map<Long, FormTriggerBean> formTriggerBeans, AppUpgradeCacheBean appUpgradeCacheBean) throws BusinessException {
        Iterator<Map.Entry<Long, FormTriggerBean>> iterator = formTriggerBeans.entrySet().iterator();
        while (iterator.hasNext()) {
            Long key = iterator.next().getKey();
            FormTriggerBean oldTriggerBean = this.cap4FormCacheManager.getFormTriggerBean(key);
            if (oldTriggerBean != null) {
                if (oldTriggerBean.hasTimeCondition()) {
                    FormTriggerBean newFormTriggerBean = appUpgradeCacheBean.getFormTriggerBean(key);
                    FormTriggerConditionBean oldDateCondition = oldTriggerBean.getDateCondition();
                    newFormTriggerBean.putExtraAttr("oldTimeQuartz", oldDateCondition.getTimeFrequency() + "|" + oldDateCondition.getConditionFormula().getFormulaForDisplay() + "|" + oldDateCondition.getTriggerTime());
                }
                this.deleteFormulaInTrigger4Upgrade(oldTriggerBean.getFormulaList());
                this.cap4MagicManager.deleteReflectionsByTrigger(oldTriggerBean);
            }
            Map triggerCacheMap = appUpgradeCacheBean.getTriggerCacheMap();
            Iterator triggerCach = triggerCacheMap.entrySet().iterator();
            while (triggerCach.hasNext()) {
                CtpFormula ctpFormula;
                FormTriggerBean value = (FormTriggerBean)triggerCach.next().getValue();
                if (value.getDateCondition() == null || value.getDateCondition().getConditionFormula() == null || (ctpFormula = this.cap4FormCacheManager.getFormula(value.getDateCondition().getConditionFormula().getFormulaId())) == null) continue;
                this.formulaDAO.delete(ctpFormula);
            }
            this.cap4FormBusinessRelationDAO.deleteById(key);
            this.logger.info((Object)("\u5e94\u7528\u5347\u7ea7\u5220\u9664\u4e1a\u52a1\u5173\u7cfb\u6210\u529f\uff1a" + key));
        }
    }

    private void deleteFormulaInTrigger4Upgrade(List<FormFormulaBean> formulaList) throws BusinessException {
        if (Strings.isNotEmpty(formulaList)) {
            ArrayList<CtpFormula> ctpFormulas = new ArrayList<CtpFormula>();
            for (FormFormulaBean formula : formulaList) {
                CtpFormula ctpFormula;
                if (formula == null || formula.getFormulaId() == null || (ctpFormula = this.cap4FormCacheManager.getFormula(formula.getFormulaId())) == null) continue;
                ctpFormulas.add(ctpFormula);
            }
            this.formulaDAO.deleteList(ctpFormulas);
        }
    }

    private void deleteRelation4Upgrade(Map<Long, FormRelationshipBean> formRelationshipBeans) throws BusinessException {
        Iterator<Map.Entry<Long, FormRelationshipBean>> iterator = formRelationshipBeans.entrySet().iterator();
        while (iterator.hasNext()) {
            Long relationId = iterator.next().getKey();
            FormRelationshipBean formRelationshipBean = this.cap4FormCacheManager.getFormRelationshipBean(relationId);
            if (formRelationshipBean == null) continue;
            this.deleteFormulaInRelation4Upgrade(formRelationshipBean);
            this.cap4FormBusinessRelationDAO.deleteById(relationId);
            this.cap4MagicManager.deleteReflectionByShip(formRelationshipBean);
            this.logger.info((Object)("\u5e94\u7528\u5347\u7ea7\u5220\u9664\u5173\u8054\u4e1a\u52a1\u5173\u7cfb\u6210\u529f\uff1a" + relationId));
        }
    }

    private void deleteFormulaInRelation4Upgrade(FormRelationshipBean formRelationship) throws BusinessException {
        if (null == formRelationship) {
            return;
        }
        ArrayList<CtpFormula> ctpFormulas = new ArrayList<CtpFormula>();
        List relationshipMapList = formRelationship.getRelationMapList();
        for (FormRelationshipMapBean relationship : relationshipMapList) {
            CtpFormula ctpFormula;
            Long formulaId = relationship.getConditionFormulaId();
            if (formulaId == 0L || null == (ctpFormula = this.cap4FormCacheManager.getFormula(formulaId))) continue;
            ctpFormulas.add(ctpFormula);
        }
        this.formulaDAO.deleteList(ctpFormulas);
        DBAgent.evict(ctpFormulas);
    }

    public void afterCommit(AppUpgradeCacheBean appUpgradeCacheBean) throws BusinessException {
        Map triggerCacheMap = appUpgradeCacheBean.getTriggerCacheMap();
        Iterator iterator = triggerCacheMap.entrySet().iterator();
        while (iterator.hasNext()) {
            FormTriggerBean formTriggerBean = (FormTriggerBean)iterator.next().getValue();
            FormTriggerConditionBean dateCondition = formTriggerBean.getDateCondition();
            boolean newTimeCondition = formTriggerBean.hasTimeCondition();
            Object oldTimeSet = formTriggerBean.getExtraAttr("oldTimeQuartz");
            if (newTimeCondition) {
                String newTimeSet = dateCondition.getTimeFrequency() + "|" + dateCondition.getConditionFormula().getFormulaForDisplay() + "|" + dateCondition.getTriggerTime();
                if (oldTimeSet != null) {
                    this.cap4FormTriggerManager.updateTriggerQuartzJob(formTriggerBean, false, (String)oldTimeSet, newTimeSet);
                    continue;
                }
                this.cap4FormTriggerManager.updateTriggerQuartzJob(formTriggerBean, true, "", newTimeSet);
                continue;
            }
            if (oldTimeSet == null) continue;
            this.cap4FormTriggerManager.updateTriggerQuartzJob(formTriggerBean, false, (String)oldTimeSet, "");
        }
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public void setCap4FormBusinessRelationDAO(CAP4FormBusinessRelationDAO cap4FormBusinessRelationDAO) {
        this.cap4FormBusinessRelationDAO = cap4FormBusinessRelationDAO;
    }

    public void setFormulaDAO(FormulaDAO formulaDAO) {
        this.formulaDAO = formulaDAO;
    }

    public void setCap4FormTriggerRecordDAO(CAP4FormTriggerRecordDAO cap4FormTriggerRecordDAO) {
        this.cap4FormTriggerRecordDAO = cap4FormTriggerRecordDAO;
    }

    public void setCap4FormBusinessRelationManager(CAP4FormBusinessRelationManager cap4FormBusinessRelationManager) {
        this.cap4FormBusinessRelationManager = cap4FormBusinessRelationManager;
    }

    public ICAP4MagicManager getCap4MagicManager() {
        return this.cap4MagicManager;
    }

    public void setCap4MagicManager(ICAP4MagicManager cap4MagicManager) {
        this.cap4MagicManager = cap4MagicManager;
    }

    public CAP4FormTriggerManager getCap4FormTriggerManager() {
        return this.cap4FormTriggerManager;
    }

    public void setCap4FormTriggerManager(CAP4FormTriggerManager cap4FormTriggerManager) {
        this.cap4FormTriggerManager = cap4FormTriggerManager;
    }
}

