/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.importandexport;

import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.cap4.form.modules.engin.base.formBase.CAP4FormDefinitionDAO;
import com.seeyon.cap4.form.modules.engin.base.formBase.CAP4FormResourceDAO;
import com.seeyon.cap4.form.modules.engin.base.formData.CAP4FormDataDAO;
import com.seeyon.cap4.form.modules.engin.base.formData.CAPFormDataCacheManager;
import com.seeyon.cap4.form.modules.engin.bind.CAP4FormBindDesignManager;
import com.seeyon.cap4.form.modules.importandexport.AbstractBusinessModuleExportManager;
import com.seeyon.cap4.form.modules.importandexport.AppUpgradeCacheBean;
import com.seeyon.cap4.form.modules.importandexport.BusinessDataBean;
import com.seeyon.cap4.form.modules.importandexport.BusinessFormExportManager;
import com.seeyon.cap4.form.modules.importandexport.BusinessRedirectDataBean;
import com.seeyon.cap4.form.modules.importandexport.CompatibilityDetectionResultBean;
import com.seeyon.cap4.form.modules.importandexport.RollbackCacheBean;
import com.seeyon.cap4.form.modules.serialNumber.CAP4SerialNumberManager;
import com.seeyon.cap4.form.po.CAPFormDefinition;
import com.seeyon.cap4.form.service.CAP4FormCache;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.service.CAP4FormManager;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.form.util.FormDesignUtil;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.appLog.manager.AppLogManager;
import com.seeyon.ctp.common.ctpenumnew.CtpEnumUtil;
import com.seeyon.ctp.common.ctpenumnew.manager.EnumManager;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.ctpenumnew.CtpEnum;
import com.seeyon.ctp.common.po.ctpenumnew.CtpEnumBean;
import com.seeyon.ctp.common.po.ctpenumnew.CtpEnumItem;
import com.seeyon.ctp.form.bean.FormSerialNumberBean;
import com.seeyon.ctp.form.modules.engin.authorization.FormAuthModuleDAO;
import com.seeyon.ctp.form.modules.engin.base.formBase.FormOwnerDAO;
import com.seeyon.ctp.form.modules.engin.formula.FormCustomFunctionDAO;
import com.seeyon.ctp.form.modules.engin.formula.FormulaConditionDAO;
import com.seeyon.ctp.form.modules.engin.formula.FormulaDAO;
import com.seeyon.ctp.form.modules.engin.relation.FormRelationDAO;
import com.seeyon.ctp.form.modules.serialNumber.SerialNumberManager;
import com.seeyon.ctp.form.po.CtpFormula;
import com.seeyon.ctp.form.po.FormOwner;
import com.seeyon.ctp.form.po.FormSerialNumber;
import com.seeyon.ctp.form.service.FormCacheManager;
import com.seeyon.ctp.util.DBAgent;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDLong;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;

public class BusinessModuleExportManager4Form
extends AbstractBusinessModuleExportManager {
    private final Log logger = CtpLogFactory.getLog(BusinessModuleExportManager4Form.class);
    private CAP4FormManager cap4FormManager;
    private CAP4FormCacheManager cap4FormCacheManager;
    private EnumManager enumManagerNew;
    private FormCacheManager formCacheManager;
    private AppLogManager appLogManager;
    private CAP4FormDefinitionDAO cap4FormDefinitionDAO;
    private FormAuthModuleDAO formAuthModuleDAO;
    private CAP4FormResourceDAO cap4FormResourceDAO;
    private FormulaDAO formulaDAO;
    private FormulaConditionDAO formulaConditionDAO;
    private FormOwnerDAO formOwnerDAO;
    private FormRelationDAO relationDAO;
    private FormCustomFunctionDAO formCustomFunctionDAO;
    private CAP4FormDataDAO cap4FormDataDAO;
    private CAP4FormBindDesignManager cap4FormBindDesignManager;
    private SerialNumberManager serialNumberManager;
    private CAP4SerialNumberManager cap4SerialNumberManager;
    private CAPFormDataCacheManager capFormDataCacheManager;

    public Integer getSort() {
        return 6;
    }

    public void compatibilityDetection(BusinessDataBean businessDataBean, CompatibilityDetectionResultBean resultBean) throws BusinessException {
        List allImportForm = businessDataBean.getAppUpgradeCacheBean().getAllForm();
        for (FormBean newImpFormBean : allImportForm) {
            FormBean cacheFormBean = this.cap4FormCacheManager.getForm(newImpFormBean.getId());
            List managerList = FormDesignUtil.getExportManagerList();
            for (BusinessFormExportManager manager : managerList) {
                manager.compatibilityDetection(businessDataBean, resultBean, newImpFormBean, cacheFormBean);
            }
        }
    }

    public void saveImportData(BusinessDataBean businessDataBean, List directSaveList) throws BusinessException {
        List managerList = FormDesignUtil.getExportManagerList();
        for (BusinessFormExportManager manager : managerList) {
            manager.saveImportData(businessDataBean);
        }
    }

    public void rollBackImportData(BusinessDataBean businessDataBean, List directDeleteList) throws BusinessException {
        List managerList = FormDesignUtil.getExportManagerList();
        for (BusinessFormExportManager manager : managerList) {
            manager.rollBackImportData(businessDataBean);
        }
        this.clearSessionContent(businessDataBean.getBizConfigBean().getId());
    }

    public void redirectBusiness(BusinessRedirectDataBean businessRedirectDataBean, BusinessDataBean businessDataBean) throws BusinessException {
        List serialNumInfo;
        List mergeCtpEnumItemList;
        this.clearSessionContent(businessDataBean.getBizConfigBean().getId());
        List formBeanList = businessDataBean.getFormBeanList();
        ArrayList<Long> formIdList = new ArrayList<Long>();
        List managerList = FormDesignUtil.getExportManagerList();
        for (FormBean formBean : formBeanList) {
            formIdList.add(formBean.getId());
            for (Object manager : managerList) {
                manager.redirectForm(formBean, businessRedirectDataBean, businessDataBean);
            }
        }
        List enumInfo = businessDataBean.getEnumDetail4Display();
        if (Strings.isNotEmpty((Collection)enumInfo)) {
            businessRedirectDataBean.addBaseData("enums", enumInfo);
            List ctpEnumList = businessDataBean.getCtpEnumList();
            ArrayList<Long> enumIdList = new ArrayList<Long>();
            for (CtpEnum ctpEnum : ctpEnumList) {
                enumIdList.add(ctpEnum.getId());
            }
            AppContext.putSessionContext((String)(AppContext.currentUserId() + "_" + businessDataBean.getBizConfigBean().getId() + "_enums"), enumIdList);
        }
        if ((mergeCtpEnumItemList = businessDataBean.getMergeCtpEnumItemList()).size() > 0) {
            ArrayList<Long> mergeCtpEnumItemIdList = new ArrayList<Long>();
            for (CtpEnumItem ctpEnumItem : mergeCtpEnumItemList) {
                mergeCtpEnumItemIdList.add(ctpEnumItem.getId());
            }
            AppContext.putSessionContext((String)(AppContext.currentUserId() + "_" + businessDataBean.getBizConfigBean().getId() + "_enumItem"), mergeCtpEnumItemIdList);
        }
        if (Strings.isNotEmpty((Collection)(serialNumInfo = businessDataBean.getSerialNumDetail4Display()))) {
            businessRedirectDataBean.addBaseData("serialnumbers", serialNumInfo);
            List serialNumberList = businessDataBean.getFormSerialNumberList();
            ArrayList<Long> serialNumIdList = new ArrayList<Long>();
            for (FormSerialNumber serialNumber : serialNumberList) {
                serialNumIdList.add(serialNumber.getId());
            }
            AppContext.putSessionContext((String)(AppContext.currentUserId() + "_" + businessDataBean.getBizConfigBean().getId() + "_serialnumbers"), serialNumIdList);
        }
        AppContext.putSessionContext((String)(AppContext.currentUserId() + "_" + businessDataBean.getBizConfigBean().getId() + "_formIds"), formIdList);
    }

    public void mergeRedirectData(Map<String, List<Map<String, Object>>> redirectData, BizConfigBean bizConfigBean, AppUpgradeCacheBean appUpgradeCacheBean) throws BusinessException {
        List formIdList = (List)AppContext.getSessionContext((String)(AppContext.currentUserId() + "_" + bizConfigBean.getId() + "_formIds"));
        HashMap redirectData4Module = new HashMap(16);
        FormDesignUtil.assortRedirectData(redirectData, redirectData4Module);
        List managerList = FormDesignUtil.getExportManagerList();
        for (Long formId : formIdList) {
            FormBean formBean = appUpgradeCacheBean != null ? appUpgradeCacheBean.getForm(formId) : this.cap4FormCacheManager.getForm(formId);
            Map redirectMap = (Map)redirectData4Module.get(formBean.getId());
            if (redirectMap == null || redirectMap.isEmpty()) continue;
            for (BusinessFormExportManager manager : managerList) {
                manager.mergeRedirectData(redirectMap, formBean, appUpgradeCacheBean);
            }
        }
    }

    public void finalSaveRedirectData(BizConfigBean bizConfigBean) throws BusinessException {
        List formIdList = (List)AppContext.getSessionContext((String)(AppContext.currentUserId() + "_" + bizConfigBean.getId() + "_formIds"));
        for (Long formId : formIdList) {
            FormBean formBean = this.cap4FormCacheManager.getForm(formId);
            this.cap4FormManager.saveOrUpdateFormBean(formBean, 2);
        }
    }

    public void clearBusinessData(BizConfigBean bizConfigBean) {
        this.logger.info((Object)("clearBusinessData\u5f00\u59cb\u6267\u884c\u5e94\u7528\u5b89\u88c5\u8868\u5355\u6570\u636e\u6e05\u7406\uff0c\u5e94\u7528id\uff1a" + bizConfigBean.getId()));
        ArrayList batchDeleteList = new ArrayList();
        List formIdList = (List)AppContext.getSessionContext((String)(AppContext.currentUserId() + "_" + bizConfigBean.getId() + "_formIds"));
        List enumIdList = (List)AppContext.getSessionContext((String)(AppContext.currentUserId() + "_" + bizConfigBean.getId() + "_enums"));
        List mergeEnumItemIdList = (List)AppContext.getSessionContext((String)(AppContext.currentUserId() + "_" + bizConfigBean.getId() + "_enumItem"));
        List serialNumIdList = (List)AppContext.getSessionContext((String)(AppContext.currentUserId() + "_" + bizConfigBean.getId() + "_serialnumbers"));
        this.clearSessionContent(bizConfigBean.getId());
        if (Strings.isNotEmpty((Collection)enumIdList)) {
            for (Long enumId : enumIdList) {
                try {
                    this.enumManagerNew.deleteEnum(enumId);
                }
                catch (BusinessException e) {
                    this.logger.info((Object)("\u6e05\u7406\u679a\u4e3e\u5f02\u5e38\uff1a" + e.getMessage()), (Throwable)e);
                }
            }
        }
        if (Strings.isNotEmpty((Collection)mergeEnumItemIdList)) {
            for (Object enumItemId : mergeEnumItemIdList) {
                try {
                    this.enumManagerNew.deleteEnumItem((Long)enumItemId);
                }
                catch (BusinessException e) {
                    this.logger.info((Object)("\u6e05\u7406\u679a\u4e3e\u9879\u5f02\u5e38\uff1a" + e.getMessage()), (Throwable)e);
                }
            }
        }
        if (Strings.isNotEmpty((Collection)serialNumIdList)) {
            ArrayList<FormSerialNumber> serialNumberList = new ArrayList<FormSerialNumber>();
            for (Object serialId : serialNumIdList) {
                try {
                    serialNumberList.add(this.formCacheManager.getSerialNumber(((Long)serialId).longValue()).toFormSerialNumber());
                }
                catch (BusinessException businessException) {
                    // empty catch block
                }
                this.formCacheManager.removeFormSerialNumberBean(((Long)serialId).longValue());
            }
            batchDeleteList.addAll(serialNumberList);
        }
        if (Strings.isNotEmpty((Collection)formIdList)) {
            ArrayList<FormBean> formBeanList = new ArrayList<FormBean>();
            for (Long formId : formIdList) {
                FormBean formBean = this.cap4FormCacheManager.getForm(formId);
                if (formBean == null) continue;
                formBeanList.add(formBean);
                this.cap4FormCacheManager.removeFormBean(formId);
                try {
                    this.cap4FormManager.clearFormBeanData(formId);
                    CAPFormDefinition formDefinition = formBean.toFormDefinition();
                    if (formDefinition == null) continue;
                    batchDeleteList.add(formDefinition);
                }
                catch (Exception e) {
                    this.logger.info((Object)("\u53d6\u6d88\u5b89\u88c5\u5220\u9664\u8868\u5355\u6570\u636e\u5f02\u5e38\uff1a" + e.getMessage()), (Throwable)e);
                }
            }
            if (Strings.isNotEmpty(formBeanList)) {
                List managerList = FormDesignUtil.getExportManagerList();
                for (BusinessFormExportManager manager : managerList) {
                    manager.clearData(formBeanList);
                }
            }
        }
        DBAgent.deleteAll(batchDeleteList);
    }

    private void clearSessionContent(Long bizConfigId) {
        AppContext.removeSessionArrribute((String)(AppContext.currentUserId() + "_" + bizConfigId + "_formIds"));
        AppContext.removeSessionArrribute((String)(AppContext.currentUserId() + "_" + bizConfigId + "_enums"));
        AppContext.removeSessionArrribute((String)(AppContext.currentUserId() + "_" + bizConfigId + "_enumItem"));
        AppContext.removeSessionArrribute((String)(AppContext.currentUserId() + "_" + bizConfigId + "_serialnumbers"));
    }

    public void completeUpgrade(AppUpgradeCacheBean appUpgradeCacheBean) throws BusinessException {
        RollbackCacheBean rollbackCacheBean = appUpgradeCacheBean.getRollbackCacheBean();
        List serialNumberList = appUpgradeCacheBean.getFormSerialNumberList();
        HashMap<Long, HashSet<Long>> formsSerialId = new HashMap<Long, HashSet<Long>>();
        if (!serialNumberList.isEmpty()) {
            ArrayList<Object> needDeleteList = new ArrayList<Object>();
            for (Object formSerialNumber : serialNumberList) {
                FormSerialNumberBean oldSerialNumber = this.formCacheManager.getSerialNumber(formSerialNumber.getId().longValue());
                if (oldSerialNumber != null) {
                    needDeleteList.add(formSerialNumber);
                    try {
                        rollbackCacheBean.addUpdateSerialNumber((FormSerialNumberBean)oldSerialNumber.clone());
                    }
                    catch (CloneNotSupportedException e) {
                        throw new BusinessException("clone serialNumber error!");
                    }
                } else {
                    rollbackCacheBean.addNewSerialNumber(formSerialNumber.getId());
                }
                HashSet<Long> serialIdSet = (HashSet<Long>)formsSerialId.get(formSerialNumber.getFormId());
                if (serialIdSet == null) {
                    serialIdSet = new HashSet<Long>();
                    formsSerialId.put(formSerialNumber.getFormId(), serialIdSet);
                }
                serialIdSet.add(formSerialNumber.getId());
            }
            if (needDeleteList.size() > 0) {
                DBAgent.deleteAll(needDeleteList);
            }
            DBAgent.saveAll((List)serialNumberList);
        }
        List enumList = appUpgradeCacheBean.getCtpEnumList();
        List enumItemList = appUpgradeCacheBean.getCtpEnumItemList();
        this.enumManagerNew.saveCtpEnums(enumList);
        this.enumManagerNew.saveCtpEnumItems(enumItemList);
        for (CtpEnum ctpEnum : appUpgradeCacheBean.getCtpEnumList()) {
            rollbackCacheBean.addNewEnumId(ctpEnum.getId());
        }
        for (Object ctpEnumItem : appUpgradeCacheBean.getCtpEnumItemList()) {
            CtpEnumBean ctpEnumBean = this.enumManagerNew.getEnum(ctpEnumItem.getRefEnumid());
            if (ctpEnumBean != null) {
                rollbackCacheBean.addUpdateEnumBean(CtpEnumUtil.cloneEnumBean((CtpEnumBean)ctpEnumBean));
            }
            rollbackCacheBean.addNewEnumItemId(ctpEnumItem.getId());
        }
        this.enumManagerNew.updateEnumCache(enumList);
        this.enumManagerNew.updateEnumItemCache(enumItemList);
        List formBeanList = appUpgradeCacheBean.getAllForm();
        for (FormBean formBean : formBeanList) {
            if (Strings.isNotEmpty((Collection)((Collection)formsSerialId.get(formBean.getId())))) {
                formBean.putExtraAttr("serialIdSet", new ArrayList((Collection)formsSerialId.get(formBean.getId())));
            }
            this.saveFormBean4Setup(formBean, appUpgradeCacheBean);
            List managerList = FormDesignUtil.getExportManagerList();
            for (BusinessFormExportManager manager : managerList) {
                manager.completeUpgrade(formBean, appUpgradeCacheBean);
            }
        }
        List conflictMappingList = appUpgradeCacheBean.getConflictMappingList();
        if (conflictMappingList.size() > 0) {
            DBAgent.saveAll((List)conflictMappingList);
        }
    }

    private void saveFormBean4Setup(FormBean formBean, AppUpgradeCacheBean appUpgradeCacheBean) throws BusinessException {
        FormBean oldFormBean = this.cap4FormCacheManager.getForm(formBean.getId());
        CAPFormDefinition formDefinition = formBean.toFormDefinition();
        List resourceList = formBean.toResource4FormBean();
        FormOwner formOwner = new FormOwner();
        formOwner.setVersion("4.0");
        formOwner.setId(Long.valueOf(UUIDLong.longUUID()));
        formOwner.setFormId(formBean.getId());
        formOwner.setOwnerId(Long.valueOf(AppContext.currentUserId()));
        formOwner.setOrgAccountId(Long.valueOf(AppContext.currentAccountId()));
        List moduleAuthList = formBean.getAllModuleAuthList();
        if (oldFormBean == null) {
            formDefinition.setCreateTime(DateUtil.currentDate());
            formDefinition.setModifyTime(DateUtil.currentDate());
            this.cap4FormDefinitionDAO.insert(formDefinition);
            this.cap4FormResourceDAO.insert(resourceList);
            List<CtpFormula> formulaList = this.cap4FormCacheManager.getFormulaList(formBean);
            this.formulaDAO.insertList(formulaList);
            List formulaConditionList = formBean.getFormulaConditionList();
            this.formulaConditionDAO.insertList(formulaConditionList);
            this.formCustomFunctionDAO.insertList(formBean.getCustomFunctionList());
            List relationList = formBean.getRelationList();
            this.relationDAO.insertList(relationList);
            this.formOwnerDAO.insert(formOwner);
            this.formAuthModuleDAO.saveOrUpdate(moduleAuthList);
            this.cap4FormDataDAO.saveTable4Db(formBean);
            this.cap4FormDataDAO.saveTableIndex4Db(formBean, null, false);
        } else {
            formDefinition.setModifyTime(DateUtil.currentDate());
            this.cap4FormManager.dealChangeFieldType(formBean, oldFormBean, appUpgradeCacheBean.getBizConfigBean().isPublishedConfig());
            this.cap4FormDefinitionDAO.update(formDefinition);
            int[] property_type = new int[]{Enums.FormResourcePropertyTypeEnum.DefaultInput.getKey(), Enums.FormResourcePropertyTypeEnum.View.getKey(), Enums.FormResourcePropertyTypeEnum.Operation.getKey(), Enums.FormResourcePropertyTypeEnum.MultiLanView.getKey()};
            this.cap4FormResourceDAO.delete(formBean.getId(), property_type);
            this.cap4FormResourceDAO.merge(resourceList);
            this.formOwnerDAO.delete(formBean.getId().longValue());
            this.formOwnerDAO.insert(formOwner);
            this.formAuthModuleDAO.deleteByFormId(formBean.getId().longValue());
            DBAgent.evict((Object)moduleAuthList);
            this.formAuthModuleDAO.saveOrUpdate(moduleAuthList);
            List<Long> businessFormulaId = this.cap4FormManager.getCtpFormulaIdFromRelationAndTrigger(formBean, appUpgradeCacheBean);
            if (Strings.isNotEmpty(businessFormulaId)) {
                HashMap<String, List<Long>> params = new HashMap<String, List<Long>>();
                params.put("formulaId", businessFormulaId);
                this.formulaDAO.deleteByModuleId(formBean.getId(), params);
            } else {
                this.formulaDAO.deleteByModuleId(formBean.getId());
            }
            List<CtpFormula> formulaList = this.cap4FormCacheManager.getFormulaList(formBean);
            this.formulaDAO.insertList(formulaList);
            this.formulaConditionDAO.deleteByModuleId(formBean.getId());
            List formulaConditionList = formBean.getFormulaConditionList();
            this.formulaConditionDAO.insertList(formulaConditionList);
            this.formCustomFunctionDAO.deleteByFormId(formBean.getId());
            DBAgent.evict((Object)formBean.getCustomFunctionList());
            this.formCustomFunctionDAO.insertList(formBean.getCustomFunctionList());
            this.relationDAO.deleteByModuleId(formBean.getId());
            List relationList = formBean.getRelationList();
            this.relationDAO.insertList(relationList);
            ArrayList serialId = (ArrayList)formBean.getExtraAttr("serialIdSet");
            if (serialId == null) {
                serialId = new ArrayList();
            }
            this.serialNumberManager.bindingSerialNumber(serialId, formBean.getId());
        }
        this.cap4FormBindDesignManager.saveTemplate2DB4Setup(formBean);
        this.cap4FormManager.saveOrDeleteEnumRef(formBean, oldFormBean, false);
        this.capFormDataCacheManager.removeByFormId(formBean.getId());
    }

    public void loadCache(AppUpgradeCacheBean appUpgradeCacheBean) throws BusinessException {
        List formBeanList = appUpgradeCacheBean.getAllForm();
        RollbackCacheBean rollbackCacheBean = appUpgradeCacheBean.getRollbackCacheBean();
        for (FormBean formBean : formBeanList) {
            FormBean oldFormBean = this.cap4FormCacheManager.getForm(formBean.getId());
            if (oldFormBean != null) {
                rollbackCacheBean.addUpdateForms(oldFormBean);
                this.cap4FormCacheManager.removeFormBean(formBean.getId());
            }
            FormBean newFormBean = this.cap4FormCacheManager.initForm(formBean.getId(), false);
            if (oldFormBean != null) continue;
            rollbackCacheBean.addNewForms(newFormBean);
        }
        List managerList = FormDesignUtil.getExportManagerList();
        for (BusinessFormExportManager manager : managerList) {
            manager.loadCache(appUpgradeCacheBean);
        }
    }

    public void restoreCache(AppUpgradeCacheBean appUpgradeCacheBean) throws BusinessException {
        RollbackCacheBean rollbackCacheBean = appUpgradeCacheBean.getRollbackCacheBean();
        if (rollbackCacheBean != null) {
            Set clearSerialNumber;
            List clearForms;
            List updateForms = rollbackCacheBean.getUpdateForms();
            if (updateForms.size() > 0) {
                for (FormBean formBean : updateForms) {
                    this.cap4FormCacheManager.removeFormBean(formBean.getId());
                    this.cap4FormCacheManager.initForm(formBean.getId());
                }
            }
            if ((clearForms = rollbackCacheBean.getNewForms()).size() > 0) {
                for (FormBean formBean : clearForms) {
                    this.cap4FormCacheManager.removeFormBean(formBean.getId());
                }
            }
            List managerList = FormDesignUtil.getExportManagerList();
            for (Object manager : managerList) {
                manager.restoreCache(appUpgradeCacheBean);
            }
            List updateSerialNumber = rollbackCacheBean.getUpdateSerialNumbers();
            if (updateSerialNumber.size() > 0) {
                for (FormSerialNumberBean formSerialNumberBean : updateSerialNumber) {
                    this.formCacheManager.addFormSerialNumberBean(formSerialNumberBean.getId().longValue(), formSerialNumberBean);
                }
            }
            if ((clearSerialNumber = rollbackCacheBean.getNewSerialNumberIdSet()).size() > 0) {
                for (Object serialNumberId : clearSerialNumber) {
                    this.formCacheManager.removeFormSerialNumberBean(((Long)serialNumberId).longValue());
                }
            }
            List enumItemIdList = rollbackCacheBean.getNewEnumItemIds();
            for (Long enumItemId : enumItemIdList) {
                this.enumManagerNew.deleteEnumItemCache(enumItemId, false);
            }
            List clearEnumId = rollbackCacheBean.getNewEnumIds();
            for (Long enumId : clearEnumId) {
                this.enumManagerNew.deleteEnumCache(enumId);
            }
            this.enumManagerNew.restoreEnumCache4AppUpgrade(rollbackCacheBean.getUpdateEnumBeanList());
        }
    }

    public void afterCommit(AppUpgradeCacheBean appUpgradeCacheBean) throws BusinessException {
        if (SystemEnvironment.isClusterEnabled()) {
            List formBeanList = appUpgradeCacheBean.getAllForm();
            for (FormBean formBean : formBeanList) {
                this.cap4FormCacheManager.sendNotification((Object)formBean.getId(), CAP4FormCache.FormCacheType.Form_init, formBean.getId());
            }
        }
    }

    public void setCap4FormManager(CAP4FormManager cap4FormManager) {
        this.cap4FormManager = cap4FormManager;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public void setEnumManagerNew(EnumManager enumManagerNew) {
        this.enumManagerNew = enumManagerNew;
    }

    public void setFormCacheManager(FormCacheManager formCacheManager) {
        this.formCacheManager = formCacheManager;
    }

    public void setAppLogManager(AppLogManager appLogManager) {
        this.appLogManager = appLogManager;
    }

    public void setCap4FormDefinitionDAO(CAP4FormDefinitionDAO cap4FormDefinitionDAO) {
        this.cap4FormDefinitionDAO = cap4FormDefinitionDAO;
    }

    public void setFormAuthModuleDAO(FormAuthModuleDAO formAuthModuleDAO) {
        this.formAuthModuleDAO = formAuthModuleDAO;
    }

    public void setCap4FormResourceDAO(CAP4FormResourceDAO cap4FormResourceDAO) {
        this.cap4FormResourceDAO = cap4FormResourceDAO;
    }

    public void setFormulaDAO(FormulaDAO formulaDAO) {
        this.formulaDAO = formulaDAO;
    }

    public void setFormulaConditionDAO(FormulaConditionDAO formulaConditionDAO) {
        this.formulaConditionDAO = formulaConditionDAO;
    }

    public void setFormOwnerDAO(FormOwnerDAO formOwnerDAO) {
        this.formOwnerDAO = formOwnerDAO;
    }

    public void setRelationDAO(FormRelationDAO relationDAO) {
        this.relationDAO = relationDAO;
    }

    public void setFormCustomFunctionDAO(FormCustomFunctionDAO formCustomFunctionDAO) {
        this.formCustomFunctionDAO = formCustomFunctionDAO;
    }

    public void setCap4FormDataDAO(CAP4FormDataDAO cap4FormDataDAO) {
        this.cap4FormDataDAO = cap4FormDataDAO;
    }

    public void setCap4FormBindDesignManager(CAP4FormBindDesignManager cap4FormBindDesignManager) {
        this.cap4FormBindDesignManager = cap4FormBindDesignManager;
    }

    public void setSerialNumberManager(SerialNumberManager serialNumberManager) {
        this.serialNumberManager = serialNumberManager;
    }

    public void setCap4SerialNumberManager(CAP4SerialNumberManager cap4SerialNumberManager) {
        this.cap4SerialNumberManager = cap4SerialNumberManager;
    }

    public void setCapFormDataCacheManager(CAPFormDataCacheManager capFormDataCacheManager) {
        this.capFormDataCacheManager = capFormDataCacheManager;
    }
}

