/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.importandexport;

import com.seeyon.cap4.form.bean.FormFieldComEnum;
import com.seeyon.cap4.form.bean.FormFormulaBean;
import com.seeyon.cap4.form.bean.FormRelationshipBean;
import com.seeyon.cap4.form.bean.FormRelationshipMapBean;
import com.seeyon.cap4.form.bean.FormTriggerActionBean;
import com.seeyon.cap4.form.bean.FormTriggerBean;
import com.seeyon.cap4.form.bean.SimpleObjectBean;
import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.cap4.form.modules.engin.businessRelation.CAP4FormBusinessRelationDAO;
import com.seeyon.cap4.form.modules.engin.businessRelation.CAP4FormBusinessRelationManager;
import com.seeyon.cap4.form.modules.engin.relation.FormRelationEnums;
import com.seeyon.cap4.form.modules.engin.trigger.CAP4FormTriggerRecordDAO;
import com.seeyon.cap4.form.modules.engin.trigger.FormTriggerUtil;
import com.seeyon.cap4.form.modules.importandexport.AbstractBusinessModuleExportManager;
import com.seeyon.cap4.form.modules.importandexport.AppUpgradeCacheBean;
import com.seeyon.cap4.form.modules.importandexport.BusinessDataBean;
import com.seeyon.cap4.form.modules.importandexport.BusinessRedirectDataBean;
import com.seeyon.cap4.form.modules.importandexport.BusinessRedirectResultBean4BusinessRelation;
import com.seeyon.cap4.form.po.CAPFormBusinessRelation;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.util.FormDesignUtil;
import com.seeyon.cap4.magic.business.importandexport.IMagicExportManager;
import com.seeyon.cap4.magic.business.incision.ICAP4MagicIncisionManager;
import com.seeyon.cap4.magic.dao.IMagicInterfaceDefineDao;
import com.seeyon.cap4.magic.dao.IMagicProviderDao;
import com.seeyon.cap4.magic.dao.IMagicReflectionRelationDao;
import com.seeyon.cap4.magic.dao.IMagicServiceSummaryDao;
import com.seeyon.cap4.magic.initializer.CAP4MagicCacheInitializer;
import com.seeyon.cap4.magic.manager.ICAP4MagicManager;
import com.seeyon.cap4.magic.po.MagicInterfaceDefineEntity;
import com.seeyon.cap4.magic.po.MagicReflectionRelationPO;
import com.seeyon.cap4.magic.po.MagicServiceProviderPO;
import com.seeyon.cap4.magic.po.MagicServiceSummary;
import com.seeyon.cap4.magic.utils.MagicPrivateUtils;
import com.seeyon.cap4.magic.vo.MagicEnums;
import com.seeyon.cap4.magic.vo.MagicImportResult;
import com.seeyon.cap4.magic.vo.MagicServiceDetail;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.constants.ApplicationCategoryEnum;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.form.bean.FormBean;
import com.seeyon.ctp.form.modules.engin.formula.FormulaDAO;
import com.seeyon.ctp.form.po.CtpFormula;
import com.seeyon.ctp.form.service.FormCacheManager;
import com.seeyon.ctp.util.ParamUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.ZipUtil;
import com.seeyon.ctp.util.json.JSONUtil;
import com.seeyon.datamagic.engine.domain.mapping.MethodMappingConfig;
import com.seeyon.datamagic.engine.domain.service.ServiceConfig;
import com.seeyon.datamagic.engine.utils.JSONUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;

public class BusinessModuleExportManager4Magic
extends AbstractBusinessModuleExportManager {
    private ICAP4MagicIncisionManager cap4MagicIncisionManager;
    private IMagicInterfaceDefineDao magicInterfaceDefineDao;
    private CAP4FormCacheManager cap4FormCacheManager;
    private ICAP4MagicManager cap4MagicManager;
    private IMagicReflectionRelationDao magicReflectionRelationDao;
    private IMagicProviderDao magicProviderDao;
    private CAP4FormBusinessRelationDAO cap4FormBusinessRelationDAO;
    private IMagicServiceSummaryDao magicServiceSummaryDao;
    private FormulaDAO formulaDAO;
    private CAP4FormTriggerRecordDAO cap4FormTriggerRecordDAO;
    private CAP4FormBusinessRelationManager cap4FormBusinessRelationManager;
    private static final Log LOGGER = CtpLogFactory.getLog(BusinessModuleExportManager4Magic.class);
    private static final String SERVICE_MAPPING = "serviceMapping";
    private static final String INVOKE_SERVICE = "invokeServices";
    private static final String PROVIDER_SERVICE_IMPL = "providerServiceImpl";
    private static final String PROVIDER_SERVICES = "providerServices";
    private static final String EXPORT_VERSION = "exportVersion";
    private IMagicExportManager magicExternalExportManager;
    private IMagicExportManager magicInternalExportManager;
    private static Map<String, MagicImportResult> importResultMap = new HashMap<String, MagicImportResult>();

    public Integer getSort() {
        return 5;
    }

    public void exportData(BusinessDataBean businessDataBean, Map<String, Object> rootMap) throws BusinessException {
        ArrayList<Map> relationMapList = new ArrayList<Map>();
        ArrayList<Object> triggerMapList = new ArrayList<Object>();
        HashSet<String> callPoint = new HashSet<String>();
        for (com.seeyon.cap4.form.bean.FormBean formBean : businessDataBean.getFormBeanList()) {
            Object targetFb;
            if (null == formBean) continue;
            Set<FormRelationshipBean> relationList = this.cap4FormCacheManager.getFormRelationshipBeanListByFormId(formBean.getId());
            for (FormRelationshipBean formRelationshipBean : relationList) {
                if (!FormRelationEnums.relationApplicationType.inner.getKey().equals(formRelationshipBean.getApplicationType()) || FormRelationEnums.RelationObjType.RELATION_CURRENT_FORM.getKey().equals(formRelationshipBean.getRelationObjType())) continue;
                Map exportMap = formRelationshipBean.getJsonMap4Export(businessDataBean);
                exportMap.remove("targetFormId");
                relationMapList.add(exportMap);
                Long id = formRelationshipBean.getId();
                com.seeyon.cap4.form.bean.FormBean formBean2 = this.cap4FormCacheManager.getForm(formRelationshipBean.getSourceFormId());
                targetFb = this.cap4FormCacheManager.getForm(formRelationshipBean.getTargetFormId());
                ArrayList<Map> mapList = new ArrayList<Map>();
                for (FormRelationshipMapBean ship : formRelationshipBean.getRelationMapList()) {
                    HashMap<String, String> params = new HashMap<String, String>(ship.getParams());
                    String bid = ParamUtil.getString(params, (String)"businessId");
                    String versionid = ParamUtil.getString(params, (String)"versionId");
                    String serviceName = ParamUtil.getString(params, (String)"methodName");
                    MagicInterfaceDefineEntity serviceEntry = null;
                    Map shipJSON = ship.toJsonObject(businessDataBean);
                    if (Strings.isBlank((String)bid) || Strings.isBlank((String)versionid) || Strings.isBlank((String)serviceName)) {
                        if (formRelationshipBean.getRelationType() == 1) {
                            serviceEntry = this.cap4MagicManager.getServiceEntryByCallPoint(formRelationshipBean.getId() + "_" + ship.getSelectedField(), MagicEnums.BusinessMethodType.RELATION_USER);
                        } else if (formRelationshipBean.getRelationType() == 2) {
                            serviceEntry = this.cap4MagicManager.getServiceEntryByCallPoint(formRelationshipBean.getId() + "_" + ship.getConditionFormulaId(), MagicEnums.BusinessMethodType.RELATION_SYS);
                        } else if (formRelationshipBean.getRelationType() == FormRelationEnums.ViewSelectType.auto_increase_row.getKey()) {
                            serviceEntry = this.cap4MagicManager.getServiceEntryByCallPoint(formRelationshipBean.getId() + "_" + FormRelationEnums.ViewSelectType.auto_increase_row.name(), MagicEnums.BusinessMethodType.RELATION_USER);
                        }
                        if (serviceEntry != null) {
                            params.put("businessId", serviceEntry.getBusinessId());
                            params.put("versionId", serviceEntry.getVersionId());
                            params.put("methodName", serviceEntry.getMethodName());
                        }
                        shipJSON.put("params", params);
                    } else {
                        serviceEntry = this.magicInterfaceDefineDao.loadDefineById(bid, versionid, serviceName);
                    }
                    if (formRelationshipBean.getRelationType() == 1 || formRelationshipBean.getRelationType() == 4) {
                        CtpFormula formula = this.cap4FormCacheManager.getFormula(ship.getConditionFormulaId());
                        if (ship.getConditionFormula() != null) {
                            String formulaDisplay;
                            Map<String, String> fieldMaps;
                            String display;
                            Map conditionFormula = FormDesignUtil.getFormulaJsonMap4Export((com.seeyon.cap4.form.bean.FormBean)formBean2, (CtpFormula)formula, (FormFormulaBean)ship.getConditionFormula(), (BusinessDataBean)businessDataBean);
                            if (targetFb != null) {
                                display = ship.getConditionFormula().getFormulaForDisplay();
                                fieldMaps = MagicPrivateUtils.getNewNameMapper((com.seeyon.cap4.form.bean.FormBean)targetFb);
                                formulaDisplay = MagicPrivateUtils.replatFieldNames(fieldMaps, display);
                                conditionFormula.put("expression4Display", formulaDisplay);
                                shipJSON.put("conditionFormula", conditionFormula);
                            } else if (serviceEntry != null) {
                                display = ship.getConditionFormula().getFormulaForDisplay(MagicPrivateUtils.convert(serviceEntry), 1);
                                fieldMaps = MagicPrivateUtils.getNewNameMapper((com.seeyon.cap4.form.bean.FormBean)targetFb);
                                formulaDisplay = MagicPrivateUtils.replatFieldNames(fieldMaps, display.toString());
                                conditionFormula.put("expression4Display", formulaDisplay);
                                shipJSON.put("conditionFormula", conditionFormula);
                            }
                        }
                    }
                    mapList.add(shipJSON);
                }
                exportMap.put("relationMapList", mapList);
                for (FormRelationshipMapBean ship : formRelationshipBean.getRelationMapList()) {
                    if (FormRelationEnums.ViewSelectType.user.getKey() == formRelationshipBean.getRelationType()) {
                        callPoint.add(id + "_" + ship.getSelectedField());
                        continue;
                    }
                    if (FormRelationEnums.ViewSelectType.system.getKey() == formRelationshipBean.getRelationType()) {
                        callPoint.add(id + "_" + ship.getConditionFormulaId());
                        continue;
                    }
                    if (FormRelationEnums.ViewSelectType.auto_increase_row.getKey() != formRelationshipBean.getRelationType()) continue;
                    callPoint.add(id + "_" + FormRelationEnums.ViewSelectType.auto_increase_row.name());
                }
            }
            Set<FormTriggerBean> triggerList = this.cap4FormCacheManager.getFormTriggerBeanListByFormId(formBean.getId());
            Iterator iterator = triggerList.iterator();
            while (iterator.hasNext()) {
                FormTriggerBean triggerBean = (FormTriggerBean)iterator.next();
                if (triggerBean.getSourceFormId() != formBean.getId().longValue() || !triggerBean.getType().equals(FormTriggerBean.TriggerBusinessType.DataInterface.getKey()) && !triggerBean.getType().equals(FormTriggerBean.TriggerBusinessType.OuterForm.getKey())) continue;
                Map exportMap = triggerBean.getJsonMap4Export(businessDataBean);
                exportMap.remove("targetFormId");
                exportMap.put("type", FormTriggerBean.TriggerBusinessType.DataInterface.getKey());
                if (FormTriggerBean.TriggerBusinessType.OuterForm.getKey().equals(triggerBean.getType())) {
                    List list = (List)exportMap.get("formulaList");
                    targetFb = this.getCap4FormCacheManager().getForm(triggerBean.getTargetFormId());
                    Map<String, String> fieldMaps = MagicPrivateUtils.getNewNameMapper((com.seeyon.cap4.form.bean.FormBean)targetFb);
                    for (FormTriggerActionBean action : triggerBean.getActionList()) {
                        if (!FormTriggerBean.TriggerType.Update.getKey().equals(action.getParam("triggerType").toString())) continue;
                        List fillBackList = (List)action.getParam(FormTriggerBean.ActionParam.FillBack.getKey());
                        for (SimpleObjectBean sob : fillBackList) {
                            if (!FormTriggerBean.FillBackType.formula.getKey().equals(sob.getType())) continue;
                            Long formulaId = Long.valueOf(sob.getValue());
                            FormFormulaBean ffb = (FormFormulaBean)sob.getExtraAttr(formulaId.toString());
                            if (ffb == null) {
                                try {
                                    ffb = this.getCap4FormCacheManager().loadFormFormulaBean(formBean, formulaId);
                                }
                                catch (BusinessException e) {
                                    LOGGER.warn((Object)e.getLocalizedMessage());
                                }
                            }
                            if (ffb == null) continue;
                            String formulaDisplay = MagicPrivateUtils.replatFieldNames(fieldMaps, ffb.getFormulaForDisplay());
                            for (Map formula : list) {
                                if (!sob.getValue().equals(ParamUtil.getString((Map)formula, (String)"id"))) continue;
                                formula.put("expression4Display", formulaDisplay);
                            }
                        }
                    }
                }
                triggerMapList.add(exportMap);
                Long l = triggerBean.getId();
                for (FormTriggerActionBean action : triggerBean.getActionList()) {
                    callPoint.add(l + "_" + action.getId());
                }
            }
        }
        ArrayList<String> points = new ArrayList<String>(callPoint);
        List<MagicReflectionRelationPO> smList = this.cap4MagicManager.getMappingByPoints(points);
        ArrayList<Map> exportRelations = new ArrayList<Map>();
        for (MagicReflectionRelationPO magicReflectionRelationPO : smList) {
            exportRelations.add(magicReflectionRelationPO.getExportData());
        }
        HashMap<String, Object> businessRelationMap = new HashMap<String, Object>();
        Map<String, List<MagicInterfaceDefineEntity>> map = this.cap4MagicManager.getServicesEntryByMapping(smList);
        ArrayList<String> enumInputTypes = new ArrayList<String>();
        enumInputTypes.add(FormFieldComEnum.SELECT.getKey());
        enumInputTypes.add(FormFieldComEnum.IMAGE_SELECT.getKey());
        enumInputTypes.add(FormFieldComEnum.RADIO.getKey());
        enumInputTypes.add(FormFieldComEnum.IMAGE_RADIO.getKey());
        for (Map.Entry entry : map.entrySet()) {
            List values = (List)entry.getValue();
            for (MagicInterfaceDefineEntity e : values) {
                Map ext;
                Map fieldLimits;
                String ext1 = e.getExt1();
                if (Strings.isBlank((String)ext1) || (fieldLimits = (Map)(ext = (Map)JSONUtil.parseJSONString((String)ext1, Map.class)).get("fieldLimit")) == null) continue;
                for (Map.Entry limit : fieldLimits.entrySet()) {
                    Map itemLists = (Map)JSONUtil.parseJSONString((String)limit.getValue().toString(), Map.class);
                    if (itemLists == null || !enumInputTypes.contains(itemLists.get("inputType"))) continue;
                    Long enumId = ParamUtil.getLong((Map)itemLists, (String)"value", (Long)0L);
                    enumId = this.getRealId4Export(businessDataBean, enumId);
                    businessDataBean.addEnumsId(enumId);
                }
            }
        }
        List<ServiceConfig> invokeServices = this.cap4MagicManager.convertEntrys(map);
        businessRelationMap.put("relation", relationMapList);
        businessRelationMap.put("trigger", triggerMapList);
        businessRelationMap.put(SERVICE_MAPPING, exportRelations);
        businessRelationMap.put(INVOKE_SERVICE, com.seeyon.cap4.magic.utils.JSONUtils.getJSonString(invokeServices));
        List<ServiceConfig> list = this.cap4MagicManager.getAllServicesByBizId(businessDataBean.getBizConfigBean().getId(), Collections.<String, Object>emptyMap());
        this.exportProvider(businessDataBean, list);
        businessRelationMap.put(EXPORT_VERSION, CAP4MagicCacheInitializer.getLatestUpdateVersion());
        rootMap.put("MagicBusinessRelation", businessRelationMap);
    }

    private Long getRealId4Export(BusinessDataBean businessDataBean, Long oldId) {
        String newId;
        Map conflictMap = businessDataBean.getBizConfigBean().getConflictMap();
        if (conflictMap != null && Strings.isNotBlank((String)(newId = (String)conflictMap.get(String.valueOf(oldId))))) {
            return Long.valueOf(newId);
        }
        return oldId;
    }

    public void importData(BusinessDataBean businessDataBean, Map<String, Object> dataMap) throws BusinessException {
        Map businessRelationMap = (Map)dataMap.get("MagicBusinessRelation");
        String export_version = ParamUtil.getString((Map)businessRelationMap, (String)EXPORT_VERSION, (String)"");
        String invokeServices = ParamUtil.getString((Map)businessRelationMap, (String)INVOKE_SERVICE);
        String providerServices = ParamUtil.getString((Map)businessRelationMap, (String)PROVIDER_SERVICES);
        ArrayList<ServiceConfig> invokeList = new ArrayList<ServiceConfig>();
        com.seeyon.cap4.magic.utils.JSONUtils.parseJSonListObj_Class(invokeServices, invokeList, ServiceConfig.class);
        ArrayList<ServiceConfig> providersList = new ArrayList<ServiceConfig>();
        com.seeyon.cap4.magic.utils.JSONUtils.parseJSonListObj_Class(providerServices, providersList, ServiceConfig.class);
        MagicImportResult importServiceResult = new MagicImportResult();
        importServiceResult.setExportVersion(export_version);
        if (String.valueOf(CAP4MagicCacheInitializer.getLatestUpdateVersion()).equals(export_version)) {
            this.importProviderService(businessDataBean, importServiceResult);
            this.cap4MagicManager.importInvokeService(invokeList, businessDataBean, importServiceResult);
        } else {
            Map<String, Object> providerEntryFormRelation = (Map<String, Object>)businessRelationMap.get("providerEntryFormRelation");
            if (providerEntryFormRelation == null) {
                providerEntryFormRelation = Collections.emptyMap();
            }
            Map providerEntryLimit = (Map)businessRelationMap.get("providerEntryLimit");
            this.cap4MagicManager.importMagicService(invokeList, providersList, providerEntryFormRelation, businessDataBean, providerEntryLimit, importServiceResult, invokeServices, providerServices);
            businessDataBean.setMagicImportResultInfo(importServiceResult);
            importServiceResult.setExportVersion(export_version);
        }
        businessDataBean.setMagicImportResultInfo(importServiceResult);
        List relationMapList = (List)businessRelationMap.get("relation");
        ArrayList<FormRelationshipBean> relationShips = new ArrayList<FormRelationshipBean>();
        if (Strings.isNotEmpty((Collection)relationMapList)) {
            for (Map jsonMap : relationMapList) {
                Long oldId;
                FormRelationshipBean formRelationshipBean;
                boolean conflict = false;
                if (!businessDataBean.isResetId() && null != (formRelationshipBean = this.cap4FormCacheManager.getFormRelationshipBean(oldId = ParamUtil.getLong((Map)jsonMap, (String)"id")))) {
                    if (businessDataBean.isUpgrade()) {
                        Long sourceFormId = businessDataBean.getRealId4Upgrade(ParamUtil.getLong((Map)jsonMap, (String)"sourceFormId"));
                        if (formRelationshipBean.getSourceFormId() != businessDataBean.genNewIdByOldId(sourceFormId).longValue()) {
                            conflict = true;
                        }
                    } else {
                        conflict = true;
                    }
                }
                FormRelationshipBean shipMap = new FormRelationshipBean(businessDataBean, jsonMap, conflict);
                relationShips.add(shipMap);
                businessDataBean.addRelationshipBean(shipMap);
            }
        }
        List triggerMapList = (List)businessRelationMap.get("trigger");
        ArrayList<FormTriggerBean> triggerList = new ArrayList<FormTriggerBean>();
        importServiceResult.setRelationShips(relationShips);
        if (Strings.isNotEmpty((Collection)triggerMapList)) {
            for (Map jsonMap : triggerMapList) {
                Long oldId;
                FormTriggerBean formTriggerBean;
                boolean conflict = false;
                if (!businessDataBean.isResetId() && null != (formTriggerBean = this.cap4FormCacheManager.getFormTriggerBean(oldId = ParamUtil.getLong((Map)jsonMap, (String)"id")))) {
                    if (businessDataBean.isUpgrade()) {
                        Long sourceFormId = businessDataBean.getRealId4Upgrade(ParamUtil.getLong((Map)jsonMap, (String)"sourceFormId"));
                        if (formTriggerBean.getSourceFormId() != businessDataBean.genNewIdByOldId(sourceFormId).longValue()) {
                            conflict = true;
                        }
                    } else {
                        conflict = true;
                    }
                }
                HashMap<String, String[]> formulaMapService = new HashMap<String, String[]>();
                List actionMapJsonList = (List)jsonMap.get("actionList");
                for (Map action : actionMapJsonList) {
                    Map paramJsonMap = (Map)action.get("param");
                    List fillBackMapList = (List)paramJsonMap.get(FormTriggerBean.ActionParam.FillBack.getKey());
                    String businessId = ParamUtil.getString((Map)paramJsonMap, (String)"businessId");
                    String versionId = ParamUtil.getString((Map)paramJsonMap, (String)"versionId");
                    String methodName = ParamUtil.getString((Map)paramJsonMap, (String)"methodName");
                    String[] serviceInfo = new String[]{businessId, versionId, methodName};
                    if (fillBackMapList == null) continue;
                    for (Map map : fillBackMapList) {
                        SimpleObjectBean object = new SimpleObjectBean();
                        object.setType((String)map.get("type"));
                        if (!object.getType().equals(FormTriggerBean.FillBackType.formula.getKey())) continue;
                        String oldFormulaId = (String)map.get("value");
                        formulaMapService.put(oldFormulaId, serviceInfo);
                    }
                }
                List formulaMapList = (List)jsonMap.get("formulaList");
                if (Strings.isNotEmpty((Collection)formulaMapList)) {
                    Long oldSourceFormId = Long.valueOf(jsonMap.get("sourceFormId").toString());
                    Long newSourceFormId = businessDataBean.getNewIdByOldId(oldSourceFormId);
                    com.seeyon.cap4.form.bean.FormBean sourceForm = this.cap4FormCacheManager.getForm(newSourceFormId);
                    for (Map formulaMap : formulaMapList) {
                        String[] serviceInfo = (String[])formulaMapService.get(ParamUtil.getString((Map)formulaMap, (String)"id", (String)""));
                        if (serviceInfo != null) {
                            MagicInterfaceDefineEntity serviceEntry = importServiceResult.getServiceEntry(serviceInfo[0], serviceInfo[1], serviceInfo[2]);
                            MagicServiceSummary serviceSummary = importServiceResult.getServiceSummary(serviceInfo[0], serviceInfo[1]);
                            MagicServiceDetail detail = MagicPrivateUtils.convert(serviceSummary, serviceEntry);
                            FormDesignUtil.getFormulaFromMap4Import((BusinessDataBean)businessDataBean, (MagicServiceDetail)detail, (Map)formulaMap, (com.seeyon.cap4.form.bean.FormBean)sourceForm, (int)2);
                            continue;
                        }
                        FormDesignUtil.getFormulaFromMap4Import((BusinessDataBean)businessDataBean, (Map)formulaMap, (com.seeyon.cap4.form.bean.FormBean)sourceForm, (int)2, (boolean)true);
                    }
                }
                FormTriggerBean newTriggerBean = new FormTriggerBean(jsonMap, businessDataBean, conflict);
                for (FormTriggerActionBean action : newTriggerBean.getActionList()) {
                    MagicServiceProviderPO provider;
                    Map params = action.getParam();
                    String bId = ParamUtil.getString((Map)params, (String)"businessId");
                    String versionId = ParamUtil.getString((Map)params, (String)"versionId");
                    String methodName = ParamUtil.getString((Map)params, (String)"methodName");
                    MagicInterfaceDefineEntity entity = importServiceResult.getServiceEntry(bId, versionId, methodName);
                    action.setType(FormTriggerBean.TriggerType.DataMagicInterface.getKey());
                    if (entity == null) continue;
                    action.addParam("dataMagicId", (Object)entity.getId());
                    String triggerType = ParamUtil.getString((Map)action.getParam(), (String)"triggerType", (String)"");
                    if (!FormTriggerBean.TriggerType.Distribution.getKey().equals(triggerType) || (provider = this.magicProviderDao.loadProviders(entity.getBusinessId(), entity.getVersionId(), MagicEnums.ProviderStatus.ON)) == null || !MagicEnums.ProviderType.DEFAULT_FORM.getType().equals(provider.getSourceType()) || !MagicPrivateUtils.isNumeric(provider.getSource())) continue;
                    Long source = Long.parseLong(provider.getSource());
                    newTriggerBean.setTargetFormId(source.longValue());
                }
                businessDataBean.addTriggerBean(newTriggerBean);
                triggerList.add(newTriggerBean);
            }
        }
        List serviceMapping = (List)businessRelationMap.get(SERVICE_MAPPING);
        List<MagicReflectionRelationPO> allRelations = this.cap4MagicManager.importMagicMappings(serviceMapping, businessDataBean);
        importServiceResult.addRelations(allRelations);
        importServiceResult.setTriggerBeans(triggerList);
    }

    private Map<String, Object> convert(List<com.seeyon.cap4.form.bean.FormBean> newFormBean, CAP4FormCacheManager cap4FormCacheManager, MagicImportResult magicImportResult) {
        FormBean fb;
        FormCacheManager formCacheManager;
        MagicServiceProviderPO currentProvider;
        String serviceName;
        MagicInterfaceDefineEntity invokeService;
        com.seeyon.cap4.form.bean.FormBean sourceFormBean;
        HashMap<Long, com.seeyon.cap4.form.bean.FormBean> formBeanMap = new HashMap<Long, com.seeyon.cap4.form.bean.FormBean>();
        for (com.seeyon.cap4.form.bean.FormBean fb3 : newFormBean) {
            if (fb3 == null) continue;
            formBeanMap.put(fb3.getId(), fb3);
        }
        HashMap allServices = new HashMap();
        allServices.putAll(magicImportResult.getInvokeExistsService());
        allServices.putAll(magicImportResult.getInvokeNewMethods());
        HashMap<String, Object> tempMap1 = new HashMap<String, Object>();
        for (Object m : allServices.values()) {
            tempMap1.put(m.getBusinessId() + "_" + m.getVersionId() + "_" + m.getMethodName(), m);
        }
        HashMap<String, MagicInterfaceDefineEntity> allRelationMap = new HashMap<String, MagicInterfaceDefineEntity>();
        for (MagicReflectionRelationPO p : magicImportResult.getAllRelations()) {
            String bid = p.getCalleeBusinessId();
            String vid = p.getVersionId();
            ArrayList mmcList = new ArrayList();
            com.seeyon.cap4.magic.utils.JSONUtils.parseJSonListObj_Class(p.getMappingConfig(), mmcList, MethodMappingConfig.class);
            for (MethodMappingConfig methodMappingConfig : mmcList) {
                MagicInterfaceDefineEntity tempEntry = (MagicInterfaceDefineEntity)tempMap1.get(bid + "_" + vid + "_" + methodMappingConfig.getMethodName());
                if (tempEntry == null) continue;
                allRelationMap.put(p.getCallingPoint(), tempEntry);
            }
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList invokeSuccessInfo = new ArrayList();
        ArrayList invokeErrorInfo = new ArrayList();
        ArrayList providerInfo = new ArrayList();
        HashMap<String, String> data = null;
        for (FormTriggerBean formTriggerBean : magicImportResult.getTriggers()) {
            sourceFormBean = (com.seeyon.cap4.form.bean.FormBean)formBeanMap.get(formTriggerBean.getSourceFormId());
            if (sourceFormBean == null) continue;
            for (FormTriggerActionBean action : formTriggerBean.getActionList()) {
                Long serviceId = ParamUtil.getLong((Map)action.getParam(), (String)"dataMagicId", (Long)0L);
                invokeService = (MagicInterfaceDefineEntity)allServices.get(serviceId);
                if (invokeService == null) continue;
                data = new HashMap();
                data.put("formName", sourceFormBean.getFormName());
                serviceName = invokeService.getName(AppContext.getLocale());
                if (serviceName != null) {
                    data.put("dataService", serviceName);
                } else {
                    data.put("dataService", "");
                }
                currentProvider = (MagicServiceProviderPO)magicImportResult.getProviders().get(invokeService.getBusinessId() + "_" + invokeService.getVersionId() + "_" + invokeService.getMethodName());
                data.put("shipName", formTriggerBean.getName());
                data.put("shipType", "trigger");
                data.put("serviceType", ResourceUtil.getString((String)"cap.magic.invoke.label"));
                if (currentProvider != null) {
                    try {
                        boolean isExists = false;
                        if (MagicEnums.ProviderType.DEFAULT_FORM.getType().equals(currentProvider.getSourceType())) {
                            com.seeyon.cap4.form.bean.FormBean fb2 = cap4FormCacheManager.getForm(Long.parseLong(currentProvider.getSource()));
                            if (fb2 != null) {
                                isExists = true;
                                data.put("dataProvider", fb2.getFormName());
                                invokeSuccessInfo.add(data);
                            }
                        } else if (MagicEnums.ProviderType.DEFAULT_FORM_CAP3.getType().equals(currentProvider.getSourceType())) {
                            formCacheManager = (FormCacheManager)AppContext.getBean((String)"formCacheManager");
                            fb = formCacheManager.getForm(Long.parseLong(currentProvider.getSource()));
                            if (fb != null) {
                                data.put("dataProvider", fb.getFormName());
                                invokeSuccessInfo.add(data);
                                isExists = true;
                            }
                        } else {
                            isExists = true;
                            data.put("dataProvider", "-");
                            invokeSuccessInfo.add(data);
                        }
                        if (isExists) continue;
                        data.put("dataProvider", "");
                        invokeErrorInfo.add(data);
                    }
                    catch (NumberFormatException e) {
                        data.put("dataProvider", "");
                        invokeErrorInfo.add(data);
                    }
                    continue;
                }
                data.put("dataProvider", "");
                invokeErrorInfo.add(data);
            }
        }
        for (FormRelationshipBean formRelationshipBean : magicImportResult.getShips()) {
            sourceFormBean = (com.seeyon.cap4.form.bean.FormBean)formBeanMap.get(formRelationshipBean.getSourceFormId());
            if (sourceFormBean == null) continue;
            for (FormRelationshipMapBean shipMap : formRelationshipBean.getRelationMapList()) {
                String point = "";
                point = FormRelationEnums.ViewSelectType.user.getKey() == formRelationshipBean.getRelationType() ? formRelationshipBean.getId() + "_" + shipMap.getSelectedField() : formRelationshipBean.getId() + "_" + shipMap.getConditionFormulaId();
                invokeService = (MagicInterfaceDefineEntity)allRelationMap.get(point);
                if (invokeService == null) continue;
                data = new HashMap();
                data.put("formName", sourceFormBean.getFormName());
                serviceName = invokeService.getName(AppContext.getLocale());
                if (serviceName != null) {
                    data.put("dataService", serviceName);
                } else {
                    data.put("dataService", "");
                }
                currentProvider = (MagicServiceProviderPO)magicImportResult.getProviders().get(invokeService.getBusinessId() + "_" + invokeService.getVersionId() + "_" + invokeService.getMethodName());
                data.put("shipName", formRelationshipBean.getName());
                data.put("shipType", "relation");
                data.put("serviceType", ResourceUtil.getString((String)"cap.magic.invoke.label"));
                if (currentProvider != null && Strings.isNotBlank((String)currentProvider.getSource())) {
                    try {
                        boolean isExists = false;
                        if (MagicEnums.ProviderType.DEFAULT_FORM.getType().equals(currentProvider.getSourceType())) {
                            com.seeyon.cap4.form.bean.FormBean fb2 = cap4FormCacheManager.getForm(Long.parseLong(currentProvider.getSource()));
                            if (fb2 != null) {
                                isExists = true;
                                data.put("dataProvider", fb2.getFormName());
                                invokeSuccessInfo.add(data);
                            }
                        } else if (MagicEnums.ProviderType.DEFAULT_FORM_CAP3.getType().equals(currentProvider.getSourceType()) && (fb = (formCacheManager = (FormCacheManager)AppContext.getBean((String)"formCacheManager")).getForm(Long.parseLong(currentProvider.getSource()))) != null) {
                            data.put("dataProvider", fb.getFormName());
                            invokeSuccessInfo.add(data);
                            isExists = true;
                        }
                        if (isExists) continue;
                        data.put("dataProvider", "");
                        invokeErrorInfo.add(data);
                    }
                    catch (NumberFormatException e) {
                        data.put("dataProvider", "");
                        invokeErrorInfo.add(data);
                    }
                    continue;
                }
                data.put("dataProvider", "");
                invokeErrorInfo.add(data);
            }
        }
        allServices.clear();
        allServices.putAll(magicImportResult.getProviderUpdateMethods());
        allServices.putAll(magicImportResult.getProviderNewsMethods());
        for (Map.Entry entry : allServices.entrySet()) {
            data = new HashMap<String, String>();
            MagicInterfaceDefineEntity entity = (MagicInterfaceDefineEntity)entry.getValue();
            com.seeyon.cap4.form.bean.FormBean sourceFormBean2 = (com.seeyon.cap4.form.bean.FormBean)formBeanMap.get(entity.getFormId());
            if (sourceFormBean2 != null) {
                data.put("formName", sourceFormBean2.getFormName());
            }
            data.put("dataService", (String)MagicPrivateUtils.getI18nNames(entity));
            MagicServiceProviderPO currentProvider2 = (MagicServiceProviderPO)magicImportResult.getProviders().get(String.valueOf(entity.getId()));
            if (currentProvider2 != null) {
                data.put("dataProvider", currentProvider2.getSource());
            }
            data.put("serviceType", ResourceUtil.getString((String)"cap.magic.service.is.called"));
            providerInfo.add(data);
        }
        result.put("total", String.valueOf(invokeErrorInfo.size()));
        result.put("provider", providerInfo);
        result.put("invokeError", invokeErrorInfo);
        result.put("invokeSuccess", invokeSuccessInfo);
        return result;
    }

    public void redirectBusiness(BusinessRedirectDataBean businessRedirectDataBean, BusinessDataBean businessDataBean) throws BusinessException {
        MagicImportResult magicResult = businessDataBean.getMagicImportResultInfo();
        if (magicResult != null) {
            businessRedirectDataBean.addMagicResultInfo(this.convert(businessDataBean.getFormBeanList(), this.cap4FormCacheManager, magicResult));
            List magicTriggers = magicResult.getTriggers();
            ArrayList<Long> triggerIdList = new ArrayList<Long>();
            for (FormTriggerBean triggerBean : magicTriggers) {
                FormTriggerBean cacheTriggerBean = this.cap4FormCacheManager.getFormTriggerBean(triggerBean.getId());
                if (cacheTriggerBean == null) continue;
                cacheTriggerBean.redirectBusiness(businessDataBean, businessRedirectDataBean);
                businessDataBean.getTriggerBeanList().remove(triggerBean);
                businessDataBean.getTriggerBeanList().add(cacheTriggerBean);
                triggerIdList.add(triggerBean.getId());
            }
            AppContext.putSessionContext((String)(AppContext.currentUserId() + "_" + businessDataBean.getBizConfigBean().getId() + "_magic_trigger"), triggerIdList);
            List ships = magicResult.getShips();
            ArrayList<Long> relationIdList = new ArrayList<Long>(ships.size());
            for (FormRelationshipBean ship : ships) {
                FormRelationshipBean cacheRelationBean = this.cap4FormCacheManager.getFormRelationshipBean(ship.getId());
                if (cacheRelationBean == null) continue;
                this.cap4FormBusinessRelationManager.redirectBusiness(businessRedirectDataBean, businessDataBean, cacheRelationBean);
                relationIdList.add(ship.getId());
            }
            AppContext.putSessionContext((String)(AppContext.currentUserId() + "_" + businessDataBean.getBizConfigBean().getId() + "_magic_relation"), relationIdList);
            Map newProviderList = magicResult.getNewFormulaBean();
            for (MagicImportResult.ImportFormula p : newProviderList.values()) {
                com.seeyon.cap4.form.bean.FormBean formBean = this.cap4FormCacheManager.getForm(p.getFormId());
                MagicServiceProviderPO providerPO = magicResult.getProviderById(p.getSourceId());
                FormFormulaBean filterFormula = p.getNewFormulaBean();
                if (filterFormula == null || providerPO == null) continue;
                HashMap<String, String> valueShareMap = new HashMap<String, String>();
                valueShareMap.put("name", providerPO.getDisplayName());
                valueShareMap.put("sourceForm", formBean.getFormName());
                valueShareMap.put("type", "\u63a5\u53e3");
                HashMap<String, String> valueMap = new HashMap<String, String>();
                valueMap.putAll(valueShareMap);
                valueMap.put("location", "\u8bbf\u95ee\u8303\u56f4");
                FormDesignUtil.redirectFormulaBean((Long)providerPO.getId(), (String)String.valueOf(filterFormula.getFormulaId()), (FormFormulaBean)filterFormula, (BusinessRedirectDataBean)businessRedirectDataBean, valueMap, BusinessRedirectResultBean4BusinessRelation.class, (com.seeyon.cap4.form.bean.FormBean)formBean);
            }
            importResultMap.put(AppContext.currentUserId() + "_" + businessDataBean.getBizConfigBean().getId(), magicResult);
        }
    }

    public void mergeRedirectData(Map<String, List<Map<String, Object>>> redirectData, BizConfigBean bizConfigBean, AppUpgradeCacheBean appUpgradeCacheBean) throws BusinessException {
        List relationIdList;
        List<Map<String, Object>> redirectMapList = redirectData.get("businessRelation");
        if (Strings.isEmpty(redirectMapList)) {
            return;
        }
        HashMap<Long, ArrayList<Map<String, Object>>> assortedRedirectMap = new HashMap<Long, ArrayList<Map<String, Object>>>();
        for (Map<String, Object> map : redirectMapList) {
            Long sourceId = Long.valueOf(map.get("sourceId").toString());
            ArrayList<Map<String, Object>> list = (ArrayList<Map<String, Object>>)assortedRedirectMap.get(sourceId);
            if (list == null) {
                list = new ArrayList<Map<String, Object>>();
                assortedRedirectMap.put(sourceId, list);
            }
            list.add(map);
        }
        List formBeanList = appUpgradeCacheBean == null ? null : appUpgradeCacheBean.getAllForm();
        List triggerIdList = (List)AppContext.getSessionContext((String)(AppContext.currentUserId() + "_" + bizConfigBean.getId() + "_magic_trigger"));
        if (Strings.isNotEmpty((Collection)triggerIdList)) {
            for (Object triggerId : triggerIdList) {
                FormTriggerBean triggerBean = this.cap4FormCacheManager.getFormTriggerBean((Long)triggerId);
                List redirectMap = (List)assortedRedirectMap.get(triggerId);
                if (redirectMap == null || redirectMap.isEmpty()) continue;
                triggerBean.updateRedirectData(redirectMap, formBeanList);
            }
        }
        if (Strings.isNotEmpty((Collection)(relationIdList = (List)AppContext.getSessionContext((String)(AppContext.currentUserId() + "_" + bizConfigBean.getId() + "_magic_relation"))))) {
            for (Long relationId : relationIdList) {
                FormRelationshipBean relationBean = this.cap4FormCacheManager.getFormRelationshipBean(relationId);
                List redirectMap = (List)assortedRedirectMap.get(relationId);
                if (redirectMap == null || redirectMap.isEmpty()) continue;
                this.cap4FormBusinessRelationManager.updateRedirectData(redirectMap, relationBean, formBeanList);
            }
        }
        MagicImportResult magicResult = importResultMap.get(AppContext.currentUserId() + "_" + bizConfigBean.getId());
        Map newProviderList = magicResult.getNewFormulaBean();
        for (MagicImportResult.ImportFormula p : newProviderList.values()) {
            List redirectMap = (List)assortedRedirectMap.get(p.getSourceId());
            if (redirectMap == null || redirectMap.isEmpty()) continue;
            for (Map orgMap : redirectMap) {
                FormFormulaBean conditionFormula = p.getNewFormulaBean();
                conditionFormula.updateFormula4BizRedirect(orgMap.get("oldValue").toString(), orgMap.get("newValue").toString(), formBeanList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearBusinessData(BizConfigBean bizConfigBean) {
        String key = "";
        try {
            key = AppContext.currentUserId() + "_" + bizConfigBean.getId();
            MagicImportResult importResultStr = importResultMap.get(key);
            this.rollBackMagicResult(importResultStr);
        }
        catch (Exception e) {
            LOGGER.warn((Object)e.getLocalizedMessage());
        }
        finally {
            importResultMap.remove(key);
        }
    }

    public void saveImportData(BusinessDataBean businessDataBean, List directSaveList) throws BusinessException {
        MagicImportResult magicImportResult = businessDataBean.getMagicImportResultInfo();
        if (magicImportResult != null) {
            importResultMap.put(AppContext.currentUserId() + "_" + businessDataBean.getBizConfigBean().getId(), magicImportResult);
        }
    }

    public void rollBackImportData(BusinessDataBean businessDataBean, List directDeleteList) throws BusinessException {
        MagicImportResult magicImportResult = businessDataBean.getMagicImportResultInfo();
        this.rollBackMagicResult(magicImportResult);
        String key = AppContext.currentUserId() + "_" + businessDataBean.getBizConfigBean().getId();
        importResultMap.remove(key);
    }

    public void restoreCache(AppUpgradeCacheBean appUpgradeCacheBean) throws BusinessException {
        this.clearBusinessData(appUpgradeCacheBean.getBizConfigBean());
    }

    private void rollBackMagicResult(MagicImportResult magicImportResult) throws BusinessException {
        if (magicImportResult != null) {
            CtpFormula ctpFormula;
            List relations = magicImportResult.getAllRelations();
            this.magicReflectionRelationDao.deleteEntrys(relations);
            this.magicServiceSummaryDao.deleteAll(magicImportResult.getNewServiceSumaryList().values());
            this.magicServiceSummaryDao.updateAll(magicImportResult.getExistsServiceSummaryList().values());
            HashMap deletOrUpdateMethodMap = new HashMap();
            deletOrUpdateMethodMap.putAll(magicImportResult.getProviderNewsMethods());
            deletOrUpdateMethodMap.putAll(magicImportResult.getInvokeNewMethods());
            ArrayList<MagicInterfaceDefineEntity> deleteOrUpdateMethodList = new ArrayList<MagicInterfaceDefineEntity>();
            deleteOrUpdateMethodList.addAll(deletOrUpdateMethodMap.values());
            this.magicInterfaceDefineDao.delete(deleteOrUpdateMethodList);
            deletOrUpdateMethodMap.clear();
            deleteOrUpdateMethodList.clear();
            deletOrUpdateMethodMap.putAll(magicImportResult.getProviderExistsMethods());
            deletOrUpdateMethodMap.putAll(magicImportResult.getInvokeExistsMethods());
            deleteOrUpdateMethodList.addAll(deletOrUpdateMethodMap.values());
            this.magicInterfaceDefineDao.updateList(deleteOrUpdateMethodList);
            ArrayList<MagicServiceProviderPO> providersList = new ArrayList<MagicServiceProviderPO>();
            providersList.addAll(magicImportResult.getNewProviderCache().values());
            this.magicProviderDao.deleteProvides(providersList);
            providersList.clear();
            providersList.addAll(magicImportResult.getUpdateProviderCache().values());
            this.magicProviderDao.updateProviders(providersList);
            ArrayList<CtpFormula> ctpFormulas = new ArrayList<CtpFormula>();
            ArrayList<CAPFormBusinessRelation> capFormBusinessRelations = new ArrayList<CAPFormBusinessRelation>();
            for (FormRelationshipBean formRelationshipBean : magicImportResult.getShips()) {
                List relationshipMapList = formRelationshipBean.getRelationMapList();
                for (FormRelationshipMapBean relationship : relationshipMapList) {
                    Long formulaId = relationship.getConditionFormulaId();
                    if (formulaId == 0L || null == (ctpFormula = this.cap4FormCacheManager.getFormula(formulaId))) continue;
                    ctpFormulas.add(ctpFormula);
                }
                capFormBusinessRelations.add(formRelationshipBean.toCAPFormBusinessRelation());
            }
            for (FormTriggerBean triggerBean : magicImportResult.getTriggers()) {
                List formulaList = triggerBean.getFormulaList();
                for (FormFormulaBean formula : formulaList) {
                    ctpFormula = this.cap4FormCacheManager.getFormula(formula.getFormulaId());
                    if (ctpFormula == null) continue;
                    ctpFormulas.add(ctpFormula);
                }
                capFormBusinessRelations.add(triggerBean.toCAPFormBusinessRelation());
                com.seeyon.cap4.form.bean.FormBean sourceForm = this.cap4FormCacheManager.getForm(triggerBean.getSourceFormId());
                this.cap4FormTriggerRecordDAO.dropRecordTable(FormTriggerUtil.getTriggerRecordName(sourceForm));
            }
            if (!ctpFormulas.isEmpty()) {
                this.formulaDAO.deleteList(ctpFormulas);
            }
            if (!capFormBusinessRelations.isEmpty()) {
                this.cap4FormBusinessRelationDAO.delete(capFormBusinessRelations);
            }
        }
    }

    private void saveMagicInfo(MagicImportResult magicImportResult) throws BusinessException {
        if (magicImportResult != null) {
            this.magicServiceSummaryDao.saveAll(magicImportResult.getNewServiceSumaryList().values());
            this.magicServiceSummaryDao.updateAll(magicImportResult.getUpdateServiceSummaryList().values());
            HashMap saveOrUpdateMethodMap = new HashMap();
            saveOrUpdateMethodMap.putAll(magicImportResult.getProviderNewsMethods());
            saveOrUpdateMethodMap.putAll(magicImportResult.getInvokeNewMethods());
            ArrayList<MagicInterfaceDefineEntity> saveOrUpdateMethodList = new ArrayList<MagicInterfaceDefineEntity>();
            saveOrUpdateMethodList.addAll(saveOrUpdateMethodMap.values());
            this.magicInterfaceDefineDao.saveDefine(saveOrUpdateMethodList);
            saveOrUpdateMethodMap.clear();
            saveOrUpdateMethodList.clear();
            saveOrUpdateMethodMap.putAll(magicImportResult.getProviderUpdateMethods());
            saveOrUpdateMethodMap.putAll(magicImportResult.getInvokeUpdateMethods());
            saveOrUpdateMethodList.addAll(saveOrUpdateMethodMap.values());
            this.magicInterfaceDefineDao.updateList(saveOrUpdateMethodList);
            Map newProviderList = magicImportResult.getNewFormulaBean();
            for (MagicImportResult.ImportFormula p : newProviderList.values()) {
                MagicServiceProviderPO providerPO = magicImportResult.getProviderById(p.getSourceId());
                FormFormulaBean formFormulaBean = p.getNewFormulaBean();
                if (providerPO == null || formFormulaBean == null) continue;
                String formulaStr = formFormulaBean.getFormulaForDisplay();
                HashMap<String, String> scopeSet = new HashMap<String, String>();
                scopeSet.put("formulaStr", formulaStr);
                HashMap<String, HashMap<String, String>> ext2 = new HashMap<String, HashMap<String, String>>();
                ext2.put("scopeSet", scopeSet);
                providerPO.setExt2(JSONUtils.getJSonString(ext2));
            }
            ArrayList<MagicServiceProviderPO> providers = new ArrayList<MagicServiceProviderPO>();
            providers.addAll(magicImportResult.getNewProviderCache().values());
            this.magicProviderDao.saveProviders(providers);
            providers.clear();
            providers.addAll(magicImportResult.getUpdateProviderCache().values());
            this.magicProviderDao.updateProviders(providers);
            List relations = magicImportResult.getAllRelations();
            this.magicReflectionRelationDao.saveAll(relations);
        }
    }

    private List<MagicInterfaceDefineEntity> getTriggerDistribute(MagicImportResult magicImportResult) {
        LinkedList<MagicInterfaceDefineEntity> providersMapper = new LinkedList<MagicInterfaceDefineEntity>();
        for (MagicInterfaceDefineEntity entry : magicImportResult.getProviderNewsMethods().values()) {
            if (MagicEnums.BusinessMethodType.TRIGGER_DISTRIBUTE.getType() != entry.getServiceType()) continue;
            providersMapper.add(entry);
        }
        for (MagicInterfaceDefineEntity entry : magicImportResult.getProviderUpdateMethods().values()) {
            if (MagicEnums.BusinessMethodType.TRIGGER_DISTRIBUTE.getType() != entry.getServiceType()) continue;
            providersMapper.add(entry);
        }
        return providersMapper;
    }

    public void finalSaveRedirectData(BizConfigBean bizConfigBean) throws BusinessException {
        String key;
        MagicImportResult magicImportResult;
        List triggerIdList;
        List relationIdList = (List)AppContext.getSessionContext((String)(AppContext.currentUserId() + "_" + bizConfigBean.getId() + "_magic_relation"));
        if (Strings.isNotEmpty((Collection)relationIdList)) {
            ArrayList<CtpFormula> ctpFormulaList = new ArrayList<CtpFormula>();
            ArrayList<CtpFormula> newFormulaList = new ArrayList<CtpFormula>();
            for (Long relationId : relationIdList) {
                FormRelationshipBean relationBean = this.cap4FormCacheManager.getFormRelationshipBean(relationId);
                if (!relationBean.isUserRelation()) continue;
                com.seeyon.cap4.form.bean.FormBean formBean = this.cap4FormCacheManager.getForm(relationBean.getSourceFormId());
                for (Object relationshipMapBean : relationBean.getRelationMapList()) {
                    if (relationshipMapBean.getConditionFormulaId() == 0L) continue;
                    ctpFormulaList.add(this.cap4FormCacheManager.getFormula(relationshipMapBean.getConditionFormulaId()));
                    CtpFormula ctpFormula = formBean.newCTPFormula4Save(relationshipMapBean.getConditionFormula(), 2);
                    newFormulaList.add(ctpFormula);
                }
            }
            if (Strings.isNotEmpty(ctpFormulaList)) {
                this.formulaDAO.deleteList(ctpFormulaList);
                this.formulaDAO.insertList(newFormulaList);
            }
        }
        if (Strings.isNotEmpty((Collection)(triggerIdList = (List)AppContext.getSessionContext((String)(AppContext.currentUserId() + "_" + bizConfigBean.getId() + "_magic_trigger"))))) {
            for (Long triggerId : triggerIdList) {
                FormTriggerBean triggerBean = this.cap4FormCacheManager.getFormTriggerBean(triggerId);
                List formulaList = triggerBean.getFormulaList();
                ArrayList ctpFormulas = new ArrayList();
                for (FormFormulaBean formula : formulaList) {
                    CtpFormula ctpFormula = this.cap4FormCacheManager.getFormula(formula.getFormulaId());
                    if (ctpFormula == null) continue;
                    ctpFormulas.add(ctpFormula);
                }
                this.formulaDAO.deleteList(ctpFormulas);
                this.formulaDAO.insertList(triggerBean.getCtpFormulaList());
                this.cap4FormBusinessRelationDAO.deleteById(triggerBean.getId());
                CAPFormBusinessRelation businessRelation = triggerBean.toCAPFormBusinessRelation();
                this.cap4FormBusinessRelationDAO.save(businessRelation);
                com.seeyon.cap4.form.bean.FormBean sourceForm = this.cap4FormCacheManager.getForm(triggerBean.getSourceFormId());
                this.cap4FormTriggerRecordDAO.createTriggerRecordTable(FormTriggerUtil.getTriggerRecordName(sourceForm));
            }
        }
        if ((magicImportResult = importResultMap.get(key = AppContext.currentUserId() + "_" + bizConfigBean.getId())) != null) {
            HashSet<String> businessIds = new HashSet<String>();
            HashMap<String, Long> providersMapper = new HashMap<String, Long>();
            List<MagicInterfaceDefineEntity> allDistributeMethod = this.getTriggerDistribute(magicImportResult);
            for (MagicInterfaceDefineEntity entry : allDistributeMethod) {
                businessIds.add(entry.getBusinessId());
                MagicServiceProviderPO tempProvider = this.magicProviderDao.loadProviders(entry.getBusinessId(), entry.getVersionId(), MagicEnums.ProviderStatus.ON);
                if (tempProvider == null || !MagicEnums.ProviderType.DEFAULT_FORM.getType().equals(tempProvider.getSourceType()) || !MagicPrivateUtils.isNumeric(tempProvider.getSource())) continue;
                providersMapper.put(entry.getBusinessId(), Long.parseLong(tempProvider.getSource()));
            }
            List<MagicReflectionRelationPO> distributeRelations = this.magicReflectionRelationDao.getReflectionByBids(businessIds);
            ArrayList<CAPFormBusinessRelation> relationList = new ArrayList<CAPFormBusinessRelation>();
            for (MagicReflectionRelationPO t : distributeRelations) {
                String callPoint = t.getCallingPoint();
                String triggerId = callPoint.split("[_]")[0];
                if (!MagicPrivateUtils.isNumeric(triggerId)) continue;
                FormTriggerBean triggerBean = this.cap4FormCacheManager.getFormTriggerBean(Long.parseLong(triggerId));
                Long targetFormId = (Long)providersMapper.get(t.getCalleeBusinessId());
                if (triggerBean == null || targetFormId == null || targetFormId.longValue() == triggerBean.getTargetFormId()) continue;
                com.seeyon.cap4.form.bean.FormBean oldBean = this.cap4FormCacheManager.getForm(triggerBean.getTargetFormId());
                if (oldBean != null) {
                    oldBean.removeFormTriggerSet(triggerBean.getId());
                }
                triggerBean.setTargetFormId(targetFormId.longValue());
                this.cap4FormBusinessRelationDAO.deleteById(triggerBean.getId());
                CAPFormBusinessRelation businessRelation = triggerBean.toCAPFormBusinessRelation();
                relationList.add(businessRelation);
            }
            if (!relationList.isEmpty()) {
                this.cap4FormBusinessRelationDAO.saveList(relationList);
            }
            this.saveMagicInfo(magicImportResult);
        }
        importResultMap.remove(key);
    }

    public void exportProvider(BusinessDataBean businessDataBean, List<ServiceConfig> sc) throws BusinessException {
        ArrayList<ServiceConfig> internalList = new ArrayList<ServiceConfig>();
        ArrayList<ServiceConfig> externalList = new ArrayList<ServiceConfig>();
        for (ServiceConfig s : sc) {
            if (MagicEnums.BusinessType.INTERNAL_BUSINESS.getKey().equals(s.getBusinessType())) {
                internalList.add(s);
            }
            if (!MagicEnums.BusinessType.EXTERNAL_BUSINESS.getKey().equals(s.getBusinessType())) continue;
            externalList.add(s);
        }
        HashMap<String, Object> extParams = new HashMap<String, Object>();
        extParams.put("from", ApplicationCategoryEnum.cap4biz.name());
        if (!internalList.isEmpty()) {
            this.magicInternalExportManager.exportMagic(businessDataBean, internalList, extParams);
        }
        if (!externalList.isEmpty()) {
            this.magicExternalExportManager.exportMagic(businessDataBean, externalList, extParams);
        }
    }

    public void importProviderService(BusinessDataBean businessDataBean, MagicImportResult importResult) throws BusinessException {
        try {
            File[] magicZipList;
            String filePath = ParamUtil.getString((Map)businessDataBean.getParams(), (String)"filePath");
            File rootFile = new File(filePath);
            File bizFile = rootFile.listFiles()[0];
            File magicFile = new File(bizFile, "interface");
            if (magicFile.exists() && (magicZipList = magicFile.listFiles()) != null) {
                for (File f : magicZipList) {
                    File unzipFile = new File(f.getParentFile(), f.getName().split("[.]")[0]);
                    ZipUtil.unzip((File)f, (File)unzipFile);
                    File interfaceZip = new File(unzipFile, "interface.zip");
                    if (!interfaceZip.exists()) continue;
                    File unzipInterfaceFolder = new File(unzipFile, "interface");
                    ZipUtil.unzip((File)interfaceZip, (File)unzipInterfaceFolder);
                    String setStr = FileUtils.readFileToString((File)new File(unzipInterfaceFolder, "serviceConfig.json"), (String)"UTF-8");
                    ServiceConfig sc = com.seeyon.cap4.magic.utils.JSONUtils.parseJSonStr_Class(setStr, ServiceConfig.class);
                    if (MagicEnums.BusinessType.EXTERNAL_BUSINESS.getKey().equals(sc.getBusinessType())) {
                        this.magicExternalExportManager.importMagic(f, unzipFile, sc, businessDataBean, importResult);
                        continue;
                    }
                    if (!MagicEnums.BusinessType.INTERNAL_BUSINESS.getKey().equals(sc.getBusinessType())) continue;
                    this.magicInternalExportManager.importMagic(f, unzipFile, sc, businessDataBean, importResult);
                }
            }
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
    }

    public void completeUpgrade(AppUpgradeCacheBean appUpgradeCacheBean) throws BusinessException {
        BizConfigBean bizConfigBean = appUpgradeCacheBean.getBizConfigBean();
        String key = AppContext.currentUserId() + "_" + bizConfigBean.getId();
        MagicImportResult magicImportResult = importResultMap.get(key);
        if (magicImportResult != null) {
            this.saveMagicInfo(magicImportResult);
        }
        importResultMap.remove(key);
    }

    public ICAP4MagicIncisionManager getCap4MagicIncisionManager() {
        return this.cap4MagicIncisionManager;
    }

    public void setCap4MagicIncisionManager(ICAP4MagicIncisionManager cap4MagicIncisionManager) {
        this.cap4MagicIncisionManager = cap4MagicIncisionManager;
    }

    public IMagicInterfaceDefineDao getMagicInterfaceDefineDao() {
        return this.magicInterfaceDefineDao;
    }

    public void setMagicInterfaceDefineDao(IMagicInterfaceDefineDao magicInterfaceDefineDao) {
        this.magicInterfaceDefineDao = magicInterfaceDefineDao;
    }

    public CAP4FormCacheManager getCap4FormCacheManager() {
        return this.cap4FormCacheManager;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public IMagicReflectionRelationDao getMagicReflectionRelationDao() {
        return this.magicReflectionRelationDao;
    }

    public void setMagicReflectionRelationDao(IMagicReflectionRelationDao magicReflectionRelationDao) {
        this.magicReflectionRelationDao = magicReflectionRelationDao;
    }

    public IMagicProviderDao getMagicProviderDao() {
        return this.magicProviderDao;
    }

    public void setMagicProviderDao(IMagicProviderDao magicProviderDao) {
        this.magicProviderDao = magicProviderDao;
    }

    public CAP4FormBusinessRelationDAO getCap4FormBusinessRelationDAO() {
        return this.cap4FormBusinessRelationDAO;
    }

    public void setCap4FormBusinessRelationDAO(CAP4FormBusinessRelationDAO cap4FormBusinessRelationDAO) {
        this.cap4FormBusinessRelationDAO = cap4FormBusinessRelationDAO;
    }

    public FormulaDAO getFormulaDAO() {
        return this.formulaDAO;
    }

    public void setFormulaDAO(FormulaDAO formulaDAO) {
        this.formulaDAO = formulaDAO;
    }

    public CAP4FormTriggerRecordDAO getCap4FormTriggerRecordDAO() {
        return this.cap4FormTriggerRecordDAO;
    }

    public void setCap4FormTriggerRecordDAO(CAP4FormTriggerRecordDAO cap4FormTriggerRecordDAO) {
        this.cap4FormTriggerRecordDAO = cap4FormTriggerRecordDAO;
    }

    public ICAP4MagicManager getCap4MagicManager() {
        return this.cap4MagicManager;
    }

    public void setCap4MagicManager(ICAP4MagicManager cap4MagicManager) {
        this.cap4MagicManager = cap4MagicManager;
    }

    public void setCap4FormBusinessRelationManager(CAP4FormBusinessRelationManager cap4FormBusinessRelationManager) {
        this.cap4FormBusinessRelationManager = cap4FormBusinessRelationManager;
    }

    public IMagicServiceSummaryDao getMagicServiceSummaryDao() {
        return this.magicServiceSummaryDao;
    }

    public void setMagicServiceSummaryDao(IMagicServiceSummaryDao magicServiceSummaryDao) {
        this.magicServiceSummaryDao = magicServiceSummaryDao;
    }

    public IMagicExportManager getMagicExternalExportManager() {
        return this.magicExternalExportManager;
    }

    public void setMagicExternalExportManager(IMagicExportManager magicExternalExportManager) {
        this.magicExternalExportManager = magicExternalExportManager;
    }

    public IMagicExportManager getMagicInternalExportManager() {
        return this.magicInternalExportManager;
    }

    public void setMagicInternalExportManager(IMagicExportManager magicInternalExportManager) {
        this.magicInternalExportManager = magicInternalExportManager;
    }
}

