/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.importandexport;

import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.cap4.form.modules.business.BusinessManager;
import com.seeyon.cap4.form.modules.business.FormAppBO;
import com.seeyon.cap4.form.modules.importandexport.AbstractBusinessModuleExportManager;
import com.seeyon.cap4.form.modules.importandexport.AppUpgradeCacheBean;
import com.seeyon.cap4.form.modules.importandexport.BusinessDataBean;
import com.seeyon.cap4.form.modules.importandexport.BusinessEnums;
import com.seeyon.cap4.form.modules.importandexport.BusinessPortalTemplateDataBean;
import com.seeyon.cap4.form.modules.importandexport.BusinessRedirectDataBean;
import com.seeyon.cap4.form.modules.importandexport.BusinessRedirectResultBean;
import com.seeyon.cap4.form.modules.importandexport.BusinessRedirectResultBean4Authorization;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.template.bo.CAPBusinessColumnBO;
import com.seeyon.cap4.template.bo.CAPBusinessConfigBO;
import com.seeyon.cap4.template.bo.CAPBusinessElementBO;
import com.seeyon.cap4.template.bo.CAPBusinessOrgBO;
import com.seeyon.cap4.template.bo.CAPBusinessTemplateBO;
import com.seeyon.cap4.template.constant.CAPBusinessConstant;
import com.seeyon.cap4.template.constant.CAPBusinessEnum;
import com.seeyon.cap4.template.manager.CAPBusinessColumnManager;
import com.seeyon.cap4.template.manager.CAPBusinessConfigManager;
import com.seeyon.cap4.template.manager.CAPBusinessElementManager;
import com.seeyon.cap4.template.manager.CAPBusinessTemplateClusterManager;
import com.seeyon.cap4.template.manager.CAPBusinessTemplateManager;
import com.seeyon.cap4.template.manager.CAPBusinessTemplateOrgManager;
import com.seeyon.cap4.template.po.CAPBusinessTemplate;
import com.seeyon.cap4.template.thread.CAPDeleteTemplateFileRunnable;
import com.seeyon.cap4.template.util.CAPBuildM3Util;
import com.seeyon.cap4.template.util.CAPBusinessTemplateUtil;
import com.seeyon.cap4.template.util.CAPBusinessUtil;
import com.seeyon.cap4.template.util.CAPParamUtil;
import com.seeyon.cap4.template.util.FileUtil;
import com.seeyon.cap4.template.vo.config.ConfigColumnVO;
import com.seeyon.cap4.template.vo.config.ConfigElementVO;
import com.seeyon.cap4.template.vo.config.ConfigTemplateVO;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.authenticate.domain.User;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.organization.bo.V3xOrgEntity;
import com.seeyon.ctp.organization.manager.OrgManager;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDLong;
import com.seeyon.ctp.util.json.JSONUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;

public class BusinessModuleExportManager4Portal
extends AbstractBusinessModuleExportManager {
    private static final Log LOGGER = CtpLogFactory.getLog(BusinessModuleExportManager4Portal.class);
    private static final String ELEMENTS = "elements";
    private static final String COLUMNS = "columns";
    private static final String TEMPLATES = "templates";
    private static final String CONFIGS = "configs";
    private static final String AUTHS = "auths";
    private static final String PC = "pc";
    private static final String MOBILE = "mobile";
    private static final String FRAME = "frame";
    private static final String IMPORT_CUSTOM_TEMPLATE_ORGS = "_import_custom_template_orgs";
    private static final String UPDATE_TEMPLATES = "update_templates";
    private CAPBusinessTemplateManager capBusinessTemplateManager;
    private CAPBusinessColumnManager capBusinessColumnManager;
    private CAPBusinessElementManager capBusinessElementManager;
    private CAPBusinessConfigManager capBusinessConfigManager;
    private CAPBusinessTemplateOrgManager capBusinessTemplateOrgManager;
    private BusinessManager businessManager4;
    private CAPBusinessTemplateClusterManager capBusinessTemplateClusterManager;

    public Integer getSort() {
        return 2;
    }

    public void exportData(BusinessDataBean businessDataBean, Map<String, Object> rootMap) throws BusinessException {
        List<CAPBusinessConfigBO> list;
        Long bizId = businessDataBean.getBizConfigBean().getId();
        Long exportBizId = businessDataBean.getRealId4Export(bizId);
        List<CAPBusinessTemplateBO> capBusinessTemplateBOs = this.capBusinessTemplateManager.getCAPBusinessTemplatesByBizId(bizId);
        if (CollectionUtils.isEmpty(capBusinessTemplateBOs)) {
            return;
        }
        ArrayList<Long> templateIds = new ArrayList<Long>();
        HashMap capBusinessPortalMap = new HashMap();
        ArrayList<Map<String, Object>> capBusinessTemplateMaps = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> capBusinessColumnMaps = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> capBusinessElementMaps = new ArrayList<Map<String, Object>>();
        ArrayList<Map<String, Object>> capBusinessConfigMaps = new ArrayList<Map<String, Object>>();
        capBusinessPortalMap.put(TEMPLATES, capBusinessTemplateMaps);
        capBusinessPortalMap.put(COLUMNS, capBusinessColumnMaps);
        capBusinessPortalMap.put(ELEMENTS, capBusinessElementMaps);
        capBusinessPortalMap.put(CONFIGS, capBusinessConfigMaps);
        for (CAPBusinessTemplateBO templateBO : capBusinessTemplateBOs) {
            if (Integer.valueOf(templateBO.getState()).intValue() == CAPBusinessEnum.State.EDIT.getState()) continue;
            Long templateId = Long.valueOf(templateBO.getId());
            Long exportTemplateId = businessDataBean.getRealId4Export(templateId);
            templateIds.add(templateId);
            Map<String, Object> map = templateBO.exportToJSon();
            map.put("id", String.valueOf(exportTemplateId));
            if (!templateBO.getTemplateType().equals(String.valueOf(CAPBusinessEnum.TemplateType.TP_BIZ_INDEX.getType()))) {
                map.put("pathId", String.valueOf(businessDataBean.getRealId4Export(Long.valueOf(Long.parseLong(templateBO.getPathId())))));
            } else {
                map.put("pathId", String.valueOf(exportBizId));
            }
            map.put("eggId", String.valueOf(exportBizId));
            List<CAPBusinessOrgBO> capBusinessOrgBOS = this.capBusinessTemplateOrgManager.getCAPBusinessOrgBOsByTemplateId(templateId);
            ArrayList<Map<String, Object>> authList = new ArrayList<Map<String, Object>>();
            for (CAPBusinessOrgBO capBusinessOrgBO : capBusinessOrgBOS) {
                Map<String, Object> authMap = capBusinessOrgBO.exportToJSon();
                authMap.put("templateId", String.valueOf(exportTemplateId));
                authList.add(authMap);
            }
            map.put(AUTHS, authList);
            capBusinessTemplateMaps.add(map);
        }
        List<CAPBusinessColumnBO> columnBOS = this.capBusinessColumnManager.getCAPBusinessColumnBOsByTemplateIds(templateIds);
        ArrayList<String> dbColumnAndElementIds = new ArrayList<String>();
        if (Strings.isNotEmpty(columnBOS)) {
            ArrayList<Long> columnIds = new ArrayList<Long>();
            for (CAPBusinessColumnBO cAPBusinessColumnBO : columnBOS) {
                Long columnId = Long.valueOf(cAPBusinessColumnBO.getId());
                columnIds.add(columnId);
                Map<String, Object> map = cAPBusinessColumnBO.exportToJSon();
                map.put("templateId", String.valueOf(businessDataBean.getRealId4Export(Long.valueOf(cAPBusinessColumnBO.getTemplateId()))));
                capBusinessColumnMaps.add(map);
                dbColumnAndElementIds.add(cAPBusinessColumnBO.getId());
            }
            List<CAPBusinessElementBO> elementBOS = this.capBusinessElementManager.getCAPBusinessElementBOsByColumnIds(columnIds);
            if (Strings.isNotEmpty(elementBOS)) {
                for (CAPBusinessElementBO elementBO : elementBOS) {
                    capBusinessElementMaps.add(elementBO.exportToJSon());
                    dbColumnAndElementIds.add(elementBO.getId());
                }
            }
        }
        ArrayList<Long> configPathIds = new ArrayList<Long>();
        List<FormAppBO> formAppBOS = this.businessManager4.getFormListByBizId(bizId);
        for (FormAppBO formAppBO : formAppBOS) {
            if (Enums.FormType.processesForm.getKey() != formAppBO.getSourceType()) continue;
            configPathIds.add(Long.valueOf(formAppBO.getId()));
        }
        if (configPathIds.size() > 0 && Strings.isNotEmpty(list = this.capBusinessConfigManager.getCAPBusinessConfigBOsByPathIds(configPathIds))) {
            for (CAPBusinessConfigBO configBO : list) {
                Map<String, Object> map = configBO.exportToJSon();
                map.put("pathId", String.valueOf(businessDataBean.getRealId4Export(Long.valueOf(configBO.getPathId()))));
                capBusinessConfigMaps.add(map);
            }
        }
        rootMap.put("portal", capBusinessPortalMap);
        try {
            this.exportDataTemplateFile(businessDataBean, capBusinessTemplateBOs, dbColumnAndElementIds);
        }
        catch (IOException iOException) {
            LOGGER.error((Object)"exportData IOException ", (Throwable)iOException);
            throw new BusinessException(iOException.getMessage(), (Throwable)iOException);
        }
    }

    private void exportDataTemplateFile(BusinessDataBean businessDataBean, List<CAPBusinessTemplateBO> capBusinessTemplateBOs, List<String> dbColumnAndElementIds) throws BusinessException, IOException {
        Long bizId = businessDataBean.getBizConfigBean().getId();
        Long exportBizId = businessDataBean.getRealId4Export(bizId);
        String copyToParentPath = businessDataBean.getZipFolder() + "customTemplate";
        for (CAPBusinessTemplateBO templateBO : capBusinessTemplateBOs) {
            if (Integer.parseInt(templateBO.getState()) == CAPBusinessEnum.State.EDIT.getState()) continue;
            int client = Integer.parseInt(templateBO.getClient());
            String copyFromBaseFolder = CAPBusinessTemplateUtil.getTemplatePath("base", templateBO, false);
            String relativePath = CAPBusinessTemplateUtil.getBaseTemplateRelativePathByPath(client, copyFromBaseFolder);
            String exportTemplateId = String.valueOf(businessDataBean.getRealId4Export(Long.valueOf(Long.parseLong(templateBO.getId()))));
            if (templateBO.isBizIndex()) {
                relativePath = relativePath.replace(String.valueOf(bizId), String.valueOf(exportBizId));
                relativePath = relativePath.replace(templateBO.getId(), exportTemplateId);
            } else {
                relativePath = relativePath.replace(templateBO.getPathId(), String.valueOf(businessDataBean.getRealId4Export(Long.valueOf(Long.parseLong(templateBO.getPathId())))));
            }
            String copyTo = copyToParentPath + File.separator;
            if (client == CAPBusinessEnum.Platform.PC.getType()) {
                copyTo = copyTo + PC;
            } else if (client == CAPBusinessEnum.Platform.MOBILE.getType()) {
                copyTo = copyTo + MOBILE;
            }
            copyTo = copyTo + File.separator + relativePath;
            copyTo = copyTo.endsWith(File.separator) ? copyTo : copyTo + File.separator;
            File copyFromFile = new File(copyFromBaseFolder);
            if (!copyFromFile.exists()) {
                LOGGER.error((Object)("export file not exits " + copyFromFile.getAbsolutePath() + " " + templateBO.exportToJSon()));
                String path = copyFromFile.getAbsolutePath();
                path = path.substring(CAPBusinessTemplateUtil.getBaseFolderPath().length(), path.length());
                throw new BusinessException(ResourceUtil.getString((String)"cap.template.export.file.notExits", (Object)(templateBO.getName() + "(" + (templateBO.isBizIndex() ? templateBO.getId() : templateBO.getPathId()) + ")"), (Object)path));
            }
            String baseConfigPath = CAPBusinessTemplateUtil.getTemplateConfigPath("base", templateBO, false);
            ConfigTemplateVO configTemplateVO = this.capBusinessTemplateManager.getConfigTemplateVO(baseConfigPath);
            if (configTemplateVO == null) {
                LOGGER.error((Object)("exportDataTemplateFile config.json is null." + baseConfigPath));
                throw new BusinessException("exportDataTemplateFile config.json is null." + templateBO.getId() + " " + templateBO.getName());
            }
            this.checkId(templateBO, configTemplateVO, dbColumnAndElementIds, "exportTemplateFile");
            FileUtil.copyDirectory((String)copyFromBaseFolder, (String)copyTo);
            if (templateBO.getId().equals(exportTemplateId)) continue;
            configTemplateVO.setTemplateFolder(exportTemplateId);
            configTemplateVO.setTemplateId(exportTemplateId);
            CAPBusinessUtil.writeConfigJSON(copyTo + CAPBusinessConstant.DIST_STATIC_CONFIG_JSON, configTemplateVO.exportToMap());
        }
        this.exportDataTemplateFrame(copyToParentPath, bizId, exportBizId);
    }

    private void checkId(CAPBusinessTemplateBO templateBO, ConfigTemplateVO configTemplateVO, List<String> dbColumnAndElementIds, String type) throws BusinessException {
        LOGGER.info((Object)(type + " check db id is equal to config.json! " + templateBO.getId() + "," + templateBO.getName()));
        if (CollectionUtils.isEmpty(configTemplateVO.getColumns()) && CollectionUtils.isEmpty(dbColumnAndElementIds)) {
            return;
        }
        if (CollectionUtils.isEmpty(configTemplateVO.getColumns()) || CollectionUtils.isEmpty(dbColumnAndElementIds)) {
            LOGGER.error((Object)(type + " 1 configTemplateVO " + configTemplateVO));
            LOGGER.error((Object)(type + " 1 dbColumnAndElementIds " + dbColumnAndElementIds));
            throw new BusinessException(templateBO.getName() + "(" + configTemplateVO.getTemplateId() + ") database column id is not map to config.json! something is empty!");
        }
        for (ConfigColumnVO columnVO : configTemplateVO.getColumns()) {
            if (!dbColumnAndElementIds.contains(columnVO.getColumnId())) {
                String message = templateBO.getName() + "(" + templateBO.getId() + ") " + columnVO.getColumnId() + " config.json column id is not map to database!";
                LOGGER.error((Object)message);
                LOGGER.error((Object)(type + " 2 configTemplateVO " + configTemplateVO));
                LOGGER.error((Object)(type + " 2 dbColumnAndElementIds " + dbColumnAndElementIds));
                throw new BusinessException(message);
            }
            if (!CollectionUtils.isNotEmpty(columnVO.getElements())) continue;
            for (ConfigElementVO elementVO : columnVO.getElements()) {
                if (dbColumnAndElementIds.contains(elementVO.getElementId())) continue;
                String message = templateBO.getName() + "(" + templateBO.getId() + ") " + elementVO.getElementId() + " config.json element id is not map to database!";
                LOGGER.error((Object)message);
                LOGGER.error((Object)(type + " 3 configTemplateVO " + configTemplateVO));
                LOGGER.error((Object)(type + " 3 dbColumnAndElementIds " + dbColumnAndElementIds));
                throw new BusinessException(message);
            }
        }
    }

    private void exportDataTemplateFrame(String copyToParentPath, Long bizId, Long exportBizId) throws IOException {
        CAPBusinessEnum.Platform[] platforms;
        for (CAPBusinessEnum.Platform platform : platforms = CAPBusinessEnum.Platform.values()) {
            String businessPath = CAPBusinessTemplateUtil.getBaseCustomTemplateBusinessFolder(bizId.toString(), platform.getType());
            File frameFile = new File(businessPath + FRAME);
            if (!frameFile.exists()) continue;
            String relativePath = CAPBusinessTemplateUtil.getBaseTemplateRelativePathByPath(platform.getType(), frameFile.getAbsolutePath());
            relativePath = relativePath.replace(String.valueOf(bizId), String.valueOf(exportBizId));
            String copyTo = copyToParentPath + File.separator;
            if (platform.getType() == CAPBusinessEnum.Platform.PC.getType()) {
                copyTo = copyTo + PC;
            } else if (platform.getType() == CAPBusinessEnum.Platform.MOBILE.getType()) {
                copyTo = copyTo + MOBILE;
            }
            FileUtil.copyDirectory((File)frameFile, (File)new File(copyTo + File.separator + relativePath));
        }
    }

    public void importData(BusinessDataBean businessDataBean, Map<String, Object> dataMap) throws BusinessException {
        Map capBusinessPortalMap = (Map)dataMap.get("portal");
        if (capBusinessPortalMap == null || capBusinessPortalMap.isEmpty()) {
            return;
        }
        if (businessDataBean.getCustomTemplateFolder() == null) {
            throw new BusinessException(ResourceUtil.getString((String)"cap.template.import.file.notExits"));
        }
        List capBusinessTemplateMaps = (List)capBusinessPortalMap.get(TEMPLATES);
        List capBusinessColumnMaps = (List)capBusinessPortalMap.get(COLUMNS);
        List capBusinessElementMaps = (List)capBusinessPortalMap.get(ELEMENTS);
        List capBusinessConfigMaps = (List)capBusinessPortalMap.get(CONFIGS);
        HashMap templateId2Columns = new HashMap();
        HashMap<String, List<Map<String, Object>>> columnId2Elements = new HashMap<String, List<Map<String, Object>>>();
        ArrayList<Long> oldTemplateIds = new ArrayList<Long>();
        for (Map map : capBusinessTemplateMaps) {
            String mapTemplateId = (String)map.get("id");
            String templateId = String.valueOf(businessDataBean.getRealId4Upgrade(Long.valueOf(mapTemplateId)));
            oldTemplateIds.add(Long.valueOf(templateId));
            for (Map columnMap : capBusinessColumnMaps) {
                if (!mapTemplateId.equals(columnMap.get("templateId"))) continue;
                if (templateId2Columns.get(templateId) == null) {
                    templateId2Columns.put(templateId, new ArrayList());
                }
                columnMap.put("templateId", templateId);
                ((List)templateId2Columns.get(templateId)).add(columnMap);
                String columnId = (String)columnMap.get("id");
                for (Map elementMap : capBusinessElementMaps) {
                    if (!columnId.equals(elementMap.get("columnId"))) continue;
                    if (columnId2Elements.get(columnId) == null) {
                        columnId2Elements.put(columnId, new ArrayList());
                    }
                    ((List)columnId2Elements.get(columnId)).add(elementMap);
                }
            }
        }
        List<CAPBusinessTemplate> oldIdExitsTemplates = this.capBusinessTemplateManager.getCAPBusinessTemplatesByIds(oldTemplateIds);
        ArrayList<Long> conflictIds = new ArrayList<Long>();
        if (CollectionUtils.isNotEmpty(oldIdExitsTemplates)) {
            for (CAPBusinessTemplate template : oldIdExitsTemplates) {
                conflictIds.add(template.getId());
            }
        }
        Map old2NewIdMap = businessDataBean.getOld2NewIdMap();
        Long newEggId = null;
        Long oldEggId = null;
        HashMap<String, Long> newPath2OldMap = new HashMap<String, Long>();
        User currentUser = AppContext.getCurrentUser();
        String nowDate = DateUtil.getDate((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
        List<CAPBusinessTemplateBO> dbTemplateBos = null;
        Map<Long, List<CAPBusinessOrgBO>> dbOrgBoMap = null;
        ArrayList<Long> dbTemplateIds = new ArrayList<Long>();
        if (businessDataBean.isUpgrade()) {
            oldEggId = Long.valueOf((String)((Map)capBusinessTemplateMaps.get(0)).get("eggId"));
            dbTemplateBos = this.capBusinessTemplateManager.getCAPBusinessTemplatesByBizId(oldEggId);
            for (CAPBusinessTemplateBO bo : dbTemplateBos) {
                if (!bo.isBizIndex()) continue;
                dbTemplateIds.add(Long.valueOf(bo.getId()));
            }
            dbOrgBoMap = this.capBusinessTemplateOrgManager.getCAPBusinessOrgBOsByTemplateIds(dbTemplateIds);
        }
        ArrayList<CAPBusinessTemplateBO> capBusinessTemplateBOS = new ArrayList<CAPBusinessTemplateBO>();
        ArrayList<CAPBusinessTemplateBO> updateTemplateBOS = new ArrayList<CAPBusinessTemplateBO>();
        for (Map map : capBusinessTemplateMaps) {
            Long eggId;
            Long newTemplateId;
            CAPBusinessTemplateBO templateBO = new CAPBusinessTemplateBO();
            templateBO.importFromJSon(map);
            Long oldTemplateId = businessDataBean.getRealId4Upgrade(Long.valueOf(templateBO.getId()));
            if (businessDataBean.isResetId()) {
                newTemplateId = businessDataBean.genNewIdByOldId(oldTemplateId);
            } else {
                boolean conflict = !businessDataBean.isUpgrade() && conflictIds.contains(oldTemplateId);
                newTemplateId = businessDataBean.genNewIdByOldId(oldTemplateId, conflict, false);
            }
            templateBO.setId(String.valueOf(newTemplateId));
            oldEggId = eggId = Long.valueOf(templateBO.getEggId());
            if (!businessDataBean.isExistIdMap(eggId)) {
                old2NewIdMap.put(eggId, UUIDLong.longUUID());
            }
            newEggId = (Long)old2NewIdMap.get(eggId);
            templateBO.setEggId(String.valueOf(old2NewIdMap.get(eggId)));
            Long oldPathId = Long.valueOf(templateBO.getPathId());
            if (!businessDataBean.isExistIdMap(oldPathId)) {
                old2NewIdMap.put(oldPathId, UUIDLong.longUUID());
            }
            newPath2OldMap.put(old2NewIdMap.get(oldPathId) + "_" + templateBO.getId(), Integer.valueOf(templateBO.getTemplateType()).intValue() == CAPBusinessEnum.TemplateType.TP_BIZ_INDEX.getType() ? oldTemplateId : oldPathId);
            templateBO.setPathId(String.valueOf(old2NewIdMap.get(oldPathId)));
            templateBO.setCreateMemberId(String.valueOf(currentUser.getId()));
            templateBO.setModifyMemberId(String.valueOf(currentUser.getId()));
            templateBO.setCreateDate(nowDate);
            templateBO.setModifyDate(nowDate);
            List columnMaps = (List)templateId2Columns.get(String.valueOf(oldTemplateId));
            templateBO.setCapBusinessColumnBOs(this.importTemplateColumns(businessDataBean, columnMaps, columnId2Elements));
            List authList = map.get(AUTHS) == null ? null : (List)map.get(AUTHS);
            List<Object> templateOrgs = null;
            if (Strings.isNotEmpty((Collection)authList)) {
                if (businessDataBean.isUpgrade() && templateBO.isBizIndex() && dbTemplateIds.contains(oldTemplateId)) {
                    templateOrgs = dbOrgBoMap.get(oldTemplateId);
                } else {
                    templateOrgs = new ArrayList();
                    for (Map authMap : authList) {
                        CAPBusinessOrgBO capBusinessOrgBO = new CAPBusinessOrgBO();
                        capBusinessOrgBO.importFromJSon(authMap);
                        capBusinessOrgBO.setId(String.valueOf(UUIDLong.longUUID()));
                        capBusinessOrgBO.setTemplateId(templateBO.getId());
                        capBusinessOrgBO.setCreateMemberId(String.valueOf(currentUser.getId()));
                        capBusinessOrgBO.setCreateDate(nowDate);
                        templateOrgs.add(capBusinessOrgBO);
                    }
                }
            } else if (businessDataBean.isUpgrade() && templateBO.isBizIndex() && dbTemplateIds.contains(oldTemplateId)) {
                templateOrgs = dbOrgBoMap.get(oldTemplateId);
            }
            templateBO.setCapBusinessOrgBOs((List<CAPBusinessOrgBO>)(templateOrgs == null ? new ArrayList() : templateOrgs));
            if (CollectionUtils.isNotEmpty(dbTemplateBos)) {
                for (CAPBusinessTemplateBO dbTemplateBo : dbTemplateBos) {
                    if (!dbTemplateBo.getId().equals(String.valueOf(oldTemplateId))) continue;
                    updateTemplateBOS.add(dbTemplateBo);
                    break;
                }
            }
            capBusinessTemplateBOS.add(templateBO);
        }
        List<CAPBusinessConfigBO> capBusinessConfigBOS = this.importTemplateConfigs(businessDataBean, capBusinessConfigMaps);
        if (businessDataBean.getBusinessPortalTemplateDataBean() == null) {
            businessDataBean.setBusinessPortalTemplateDataBean(new BusinessPortalTemplateDataBean());
        }
        BusinessPortalTemplateDataBean templateDataBean = businessDataBean.getBusinessPortalTemplateDataBean();
        templateDataBean.setBizId(newEggId);
        templateDataBean.setOldBizId(oldEggId);
        templateDataBean.setNewPath2OldMap(newPath2OldMap);
        templateDataBean.addDataList(CAPBusinessTemplateBO.class, capBusinessTemplateBOS);
        templateDataBean.addDataList(CAPBusinessConfigBO.class, capBusinessConfigBOS);
        templateDataBean.addDataList(UPDATE_TEMPLATES, updateTemplateBOS);
        templateDataBean.setCustomTemplateFolder(businessDataBean.getCustomTemplateFolder().getAbsolutePath());
        templateDataBean.setOld2NewIdMap(businessDataBean.getOld2NewIdMap());
        if (businessDataBean.isUpgrade()) {
            businessDataBean.getAppUpgradeCacheBean().setBusinessPortalTemplateDataBean(templateDataBean);
        }
    }

    private List<CAPBusinessConfigBO> importTemplateConfigs(BusinessDataBean businessDataBean, List<Map<String, Object>> capBusinessConfigMaps) {
        ArrayList<CAPBusinessConfigBO> capBusinessConfigBOS = new ArrayList<CAPBusinessConfigBO>();
        Map old2NewIdMap = businessDataBean.getOld2NewIdMap();
        User currentUser = AppContext.getCurrentUser();
        String nowDate = DateUtil.getDate((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
        for (Map<String, Object> map : capBusinessConfigMaps) {
            CAPBusinessConfigBO configBO = new CAPBusinessConfigBO();
            configBO.importFromJSon(map);
            configBO.setId(String.valueOf(UUIDLong.longUUID()));
            Long pathId = Long.valueOf(configBO.getPathId());
            if (!businessDataBean.isExistIdMap(pathId)) {
                old2NewIdMap.put(pathId, UUIDLong.longUUID());
            }
            configBO.setPathId(String.valueOf(old2NewIdMap.get(pathId)));
            configBO.setCreateMemberId(String.valueOf(currentUser.getId()));
            configBO.setModifyMemberId(String.valueOf(currentUser.getId()));
            configBO.setCreateDate(nowDate);
            configBO.setModifyDate(nowDate);
            capBusinessConfigBOS.add(configBO);
        }
        return capBusinessConfigBOS;
    }

    private List<CAPBusinessColumnBO> importTemplateColumns(BusinessDataBean businessDataBean, List<Map<String, Object>> columnMaps, Map<String, List<Map<String, Object>>> columnId2Elements) {
        ArrayList<CAPBusinessColumnBO> capBusinessColumnBOs = new ArrayList<CAPBusinessColumnBO>();
        Map old2NewIdMap = businessDataBean.getOld2NewIdMap();
        User currentUser = AppContext.getCurrentUser();
        String nowDate = DateUtil.getDate((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
        for (Map<String, Object> columnMap : columnMaps) {
            CAPBusinessColumnBO columnBO = new CAPBusinessColumnBO();
            columnBO.importFromJSon(columnMap);
            Long id = Long.valueOf(columnBO.getId());
            if (!businessDataBean.isExistIdMap(id)) {
                old2NewIdMap.put(id, UUIDLong.longUUID());
            }
            old2NewIdMap.put(id, old2NewIdMap.get(id));
            columnBO.setId(String.valueOf(old2NewIdMap.get(id)));
            Long templateId = Long.valueOf(columnBO.getTemplateId());
            columnBO.setTemplateId(String.valueOf(old2NewIdMap.get(templateId)));
            columnBO.setCreateMemberId(String.valueOf(currentUser.getId()));
            columnBO.setModifyMemberId(String.valueOf(currentUser.getId()));
            columnBO.setCreateDate(nowDate);
            columnBO.setModifyDate(nowDate);
            List<Map<String, Object>> elementMaps = columnId2Elements.get(String.valueOf(id));
            columnBO.setCapBusinessElementBOs(this.importTemplateColumnElements(businessDataBean, elementMaps));
            capBusinessColumnBOs.add(columnBO);
        }
        return capBusinessColumnBOs;
    }

    private List<CAPBusinessElementBO> importTemplateColumnElements(BusinessDataBean businessDataBean, List<Map<String, Object>> elementMaps) {
        ArrayList<CAPBusinessElementBO> capBusinessElementBOs = new ArrayList<CAPBusinessElementBO>();
        Map old2NewIdMap = businessDataBean.getOld2NewIdMap();
        User currentUser = AppContext.getCurrentUser();
        String nowDate = DateUtil.getDate((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss");
        for (Map<String, Object> map : elementMaps) {
            CAPBusinessElementBO elementBO = new CAPBusinessElementBO();
            elementBO.importFromJSon(map);
            Long id = Long.valueOf(elementBO.getId());
            Long newId = UUIDLong.longUUID();
            elementBO.setId(String.valueOf(newId));
            old2NewIdMap.put(id, newId);
            Long columnId = Long.valueOf(elementBO.getColumnId());
            elementBO.setColumnId(String.valueOf(old2NewIdMap.get(columnId)));
            elementBO.setCreateMemberId(String.valueOf(currentUser.getId()));
            elementBO.setModifyMemberId(String.valueOf(currentUser.getId()));
            elementBO.setCreateDate(nowDate);
            elementBO.setModifyDate(nowDate);
            Map<String, Object> dataInfo = elementBO.getDataInfo();
            this.resetElementDataSource(dataInfo, businessDataBean);
            elementBO.setDataInfo(dataInfo);
            capBusinessElementBOs.add(elementBO);
        }
        return capBusinessElementBOs;
    }

    public void completeUpgrade(AppUpgradeCacheBean appUpgradeCacheBean) throws BusinessException {
        BusinessPortalTemplateDataBean templateDataBean = appUpgradeCacheBean.getBusinessPortalTemplateDataBean();
        if (templateDataBean != null) {
            List updateTemplates = templateDataBean.getDataList(UPDATE_TEMPLATES);
            ArrayList<File> backUpFile = new ArrayList<File>();
            if (CollectionUtils.isNotEmpty((Collection)updateTemplates)) {
                String savePath = CAPBusinessTemplateUtil.getTemplateTempFolder();
                for (CAPBusinessTemplateBO bo : updateTemplates) {
                    String fileName = "import_update_" + bo.getId();
                    LOGGER.info((Object)("ImportCustomTemplate completeUpgrade \u5907\u4efd\u6570\u636e, savePath:" + savePath + ", fileName:" + fileName + ", templateBo:" + bo.toString()));
                    this.capBusinessTemplateManager.zipTemplateFileWithData(bo, savePath, fileName);
                    backUpFile.add(new File(savePath + File.separator + fileName));
                }
                this.capBusinessTemplateManager.deleteCAPBusinessTemplatesByBO(templateDataBean.getOldBizId(), updateTemplates, 0);
            }
            this.saveData(templateDataBean, true);
            this.capBusinessTemplateManager.addDelayTask(new CAPDeleteTemplateFileRunnable(backUpFile), 600);
            this.buildM3(appUpgradeCacheBean.getBizConfigBean().getId());
        }
    }

    public void restoreCache(AppUpgradeCacheBean appUpgradeCacheBean) throws BusinessException {
        BusinessPortalTemplateDataBean templateDataBean = appUpgradeCacheBean.getBusinessPortalTemplateDataBean();
        if (templateDataBean != null) {
            List updateTemplates = templateDataBean.getDataList(UPDATE_TEMPLATES);
            if (CollectionUtils.isNotEmpty((Collection)updateTemplates)) {
                String savePath = CAPBusinessTemplateUtil.getTemplateTempFolder();
                for (CAPBusinessTemplateBO bo : updateTemplates) {
                    String fileName = "import_update_" + bo.getId();
                    LOGGER.info((Object)("ImportCustomTemplate restoreCache \u6062\u590d\u5907\u4efd\u6570\u636e, savePath:" + savePath + ", fileName:" + fileName + ", templateBo:" + bo.toString()));
                    this.capBusinessTemplateManager.restoreTemplateFile(bo, savePath, fileName);
                }
            }
            this.buildM3(appUpgradeCacheBean.getBizConfigBean().getId());
        }
    }

    public void saveImportData(BusinessDataBean businessDataBean, List directSaveList) throws BusinessException {
        BusinessPortalTemplateDataBean templateDataBean = businessDataBean.getBusinessPortalTemplateDataBean();
        if (templateDataBean != null) {
            List capBusinessTemplateBOs = templateDataBean.getDataList(CAPBusinessTemplateBO.class);
            if (CollectionUtils.isEmpty((Collection)capBusinessTemplateBOs)) {
                return;
            }
            this.saveData(templateDataBean, false);
        }
    }

    private void saveData(BusinessPortalTemplateDataBean templateDataBean, boolean isUpdate) throws BusinessException {
        List capBusinessTemplateBOs = templateDataBean.getDataList(CAPBusinessTemplateBO.class);
        List capBusinessConfigBOs = templateDataBean.getDataList(CAPBusinessConfigBO.class);
        ArrayList<CAPBusinessColumnBO> capBusinessColumnBOs = new ArrayList<CAPBusinessColumnBO>();
        ArrayList<CAPBusinessElementBO> capBusinessElementBOs = new ArrayList<CAPBusinessElementBO>();
        Long newEggId = templateDataBean.getBizId();
        ArrayList<CAPBusinessOrgBO> capBusinessOrgBOS = null;
        ArrayList<String> dbColumnAndElementIds = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty((Collection)capBusinessTemplateBOs)) {
            capBusinessOrgBOS = new ArrayList<CAPBusinessOrgBO>();
            for (CAPBusinessTemplateBO templateBO : capBusinessTemplateBOs) {
                if (CollectionUtils.isNotEmpty(templateBO.getCapBusinessColumnBOs())) {
                    capBusinessColumnBOs.addAll(templateBO.getCapBusinessColumnBOs());
                    for (CAPBusinessColumnBO cAPBusinessColumnBO : templateBO.getCapBusinessColumnBOs()) {
                        dbColumnAndElementIds.add(cAPBusinessColumnBO.getId());
                        if (!CollectionUtils.isNotEmpty(cAPBusinessColumnBO.getCapBusinessElementBOs())) continue;
                        capBusinessElementBOs.addAll(cAPBusinessColumnBO.getCapBusinessElementBOs());
                        for (CAPBusinessElementBO elementBO : cAPBusinessColumnBO.getCapBusinessElementBOs()) {
                            dbColumnAndElementIds.add(elementBO.getId());
                        }
                    }
                }
                if (!CollectionUtils.isNotEmpty(templateBO.getCapBusinessOrgBOs())) continue;
                capBusinessOrgBOS.addAll(templateBO.getCapBusinessOrgBOs());
            }
        }
        LOGGER.info((Object)("ImportCustomTemplate info , templates size " + capBusinessTemplateBOs.size() + " , columns size " + capBusinessColumnBOs.size() + " , elements size " + capBusinessElementBOs.size() + " , configs size " + capBusinessConfigBOs.size() + " , isUpdate " + isUpdate));
        this.capBusinessTemplateManager.saveCAPBusinessTemplateBOs(capBusinessTemplateBOs);
        this.capBusinessColumnManager.saveCAPBusinessColumnBOs(capBusinessColumnBOs);
        this.capBusinessElementManager.saveCAPBusinessElementBOs(capBusinessElementBOs);
        this.capBusinessConfigManager.insertCAPBusinessConfigBOs(capBusinessConfigBOs);
        if (isUpdate) {
            CAPBusinessOrgBO bo;
            List<CAPBusinessOrgBO> insertBos = new ArrayList<CAPBusinessOrgBO>();
            Map idToOrgBos = (Map)AppContext.getSessionContext((String)(AppContext.currentUserId() + IMPORT_CUSTOM_TEMPLATE_ORGS));
            Map map = idToOrgBos = idToOrgBos == null ? new HashMap() : idToOrgBos;
            if (CollectionUtils.isNotEmpty(capBusinessOrgBOS)) {
                for (CAPBusinessOrgBO cAPBusinessOrgBO : capBusinessOrgBOS) {
                    if (idToOrgBos.get(cAPBusinessOrgBO.getId()) != null) {
                        bo = (CAPBusinessOrgBO)JSONUtil.parseJSONString((String)((String)idToOrgBos.get(cAPBusinessOrgBO.getId())), CAPBusinessOrgBO.class);
                        insertBos.add(bo);
                        idToOrgBos.remove(cAPBusinessOrgBO.getId());
                        continue;
                    }
                    insertBos.add(cAPBusinessOrgBO);
                }
            }
            for (Map.Entry entry : idToOrgBos.entrySet()) {
                bo = (CAPBusinessOrgBO)JSONUtil.parseJSONString((String)((String)entry.getValue()), CAPBusinessOrgBO.class);
                insertBos.add(bo);
            }
            if (CollectionUtils.isNotEmpty(insertBos)) {
                insertBos = this.clearOrgBo(insertBos);
                LOGGER.info((Object)("ImportCustomTemplate auth bo size " + insertBos.size()));
                this.capBusinessTemplateOrgManager.saveCAPBusinessTemplateOrgs(insertBos);
            }
        }
        this.saveDataFile(templateDataBean, isUpdate, dbColumnAndElementIds);
        this.capBusinessTemplateClusterManager.sendImportBusiness(newEggId);
    }

    private List<CAPBusinessOrgBO> clearOrgBo(List<CAPBusinessOrgBO> insertBos) {
        ArrayList<Long> orgBoIds = new ArrayList<Long>();
        for (CAPBusinessOrgBO bo : insertBos) {
            orgBoIds.add(Long.valueOf(bo.getId()));
        }
        List<CAPBusinessOrgBO> dbOrgBos = this.capBusinessTemplateOrgManager.getBOsByIds(orgBoIds);
        if (CollectionUtils.isNotEmpty(dbOrgBos)) {
            for (CAPBusinessOrgBO dbBo : dbOrgBos) {
                Iterator<CAPBusinessOrgBO> iterator = insertBos.iterator();
                while (iterator.hasNext()) {
                    CAPBusinessOrgBO insertBo = iterator.next();
                    if (!this.capBusinessTemplateOrgManager.isEqual(insertBo, dbBo)) continue;
                    LOGGER.info((Object)("ImportCustomTemplate auth bo db has equal " + insertBo));
                    iterator.remove();
                }
            }
        }
        for (CAPBusinessOrgBO insertBo : insertBos) {
            insertBo.setId(String.valueOf(UUIDLong.longUUID()));
        }
        return insertBos;
    }

    private void saveDataFile(BusinessPortalTemplateDataBean templateDataBean, boolean isUpdate, List<String> dbColumnAndElementIds) throws BusinessException {
        List capBusinessTemplateBOs = templateDataBean.getDataList(CAPBusinessTemplateBO.class);
        Map old2NewIdMap = templateDataBean.getOld2NewIdMap();
        File customTemplateFolder = new File(templateDataBean.getCustomTemplateFolder());
        Long newEggId = templateDataBean.getBizId();
        Long oldEggId = templateDataBean.getOldBizId();
        Map newPath2OldMap = templateDataBean.getNewPath2OldMap();
        ArrayList<Long> needInitBackUpTemplateIds = new ArrayList<Long>();
        boolean hasCopyFrame = false;
        for (CAPBusinessTemplateBO capBusinessTemplateBO : capBusinessTemplateBOs) {
            String copyToPath;
            boolean isBizIndex;
            String copyFromRootRelativePath;
            int templateType = Integer.valueOf(capBusinessTemplateBO.getTemplateType());
            int client = Integer.valueOf(capBusinessTemplateBO.getClient());
            int frameType = Strings.isBlank((String)capBusinessTemplateBO.getFrameType()) ? CAPBusinessEnum.TemplateFrameType.NEED_FRAME.getType() : Integer.valueOf(capBusinessTemplateBO.getFrameType()).intValue();
            String copyFromRelativePath = copyFromRootRelativePath = (client == CAPBusinessEnum.Platform.MOBILE.getType() ? MOBILE : PC) + File.separator;
            String pathIdKey = capBusinessTemplateBO.getPathId() + "_" + capBusinessTemplateBO.getId();
            String bizBase = CAPBusinessTemplateUtil.getBaseCustomTemplateTypeDataFolder(capBusinessTemplateBO.getEggId(), client, templateType);
            boolean bl = isBizIndex = templateType == CAPBusinessEnum.TemplateType.TP_BIZ_INDEX.getType();
            if (isBizIndex) {
                copyToPath = bizBase + capBusinessTemplateBO.getId() + File.separator;
                copyFromRelativePath = copyFromRelativePath + CAPBusinessTemplateUtil.getOnlyRelativePath(String.valueOf(oldEggId), client, templateType) + newPath2OldMap.get(pathIdKey) + File.separator;
            } else {
                copyToPath = CAPBusinessTemplateUtil.getBaseCustomTemplateTypeDataFolder(capBusinessTemplateBO.getPathId(), client, templateType);
                copyFromRelativePath = copyFromRelativePath + CAPBusinessTemplateUtil.getOnlyRelativePath(String.valueOf(newPath2OldMap.get(pathIdKey)), client, templateType);
            }
            File srcFile = new File(customTemplateFolder, copyFromRelativePath);
            File destFile = new File(copyToPath);
            try {
                if (!hasCopyFrame && client == CAPBusinessEnum.Platform.PC.getType() && templateType == CAPBusinessEnum.TemplateType.TP_BIZ_INDEX.getType()) {
                    String frameFromRelativePath = copyFromRootRelativePath + CAPBusinessTemplateUtil.getOnlyRelativePath(String.valueOf(oldEggId), client, templateType) + FRAME;
                    File srcFrame = new File(customTemplateFolder, frameFromRelativePath);
                    if (srcFrame.exists()) {
                        FileUtil.copyDirectory((File)srcFrame, (File)new File(bizBase + FRAME));
                    }
                    hasCopyFrame = true;
                }
                if (!srcFile.exists()) {
                    LOGGER.error((Object)("ImportCustomTemplate src file is not exits " + capBusinessTemplateBO.getId() + " " + capBusinessTemplateBO.getName() + " " + srcFile.getAbsolutePath()));
                    continue;
                }
                FileUtil.copyDirectory((File)srcFile, (File)destFile, (int)5);
                LOGGER.info((Object)("ImportCustomTemplate copy to base , src " + srcFile.getAbsolutePath()));
                LOGGER.info((Object)("ImportCustomTemplate copy to base , dest " + destFile.getAbsolutePath()));
            }
            catch (IOException e) {
                LOGGER.error((Object)"ImportCustomTemplate IOException ", (Throwable)e);
                throw new BusinessException(e.getMessage(), (Throwable)e);
            }
            String baseConfigPath = CAPBusinessTemplateUtil.getTemplateConfigPath("base", capBusinessTemplateBO, false);
            ConfigTemplateVO configTemplateVO = this.capBusinessTemplateManager.getConfigTemplateVO(baseConfigPath);
            if (configTemplateVO == null) {
                LOGGER.error((Object)("ImportCustomTemplate config.json is null." + baseConfigPath + " , templateBo is " + capBusinessTemplateBO.exportToJSon()));
                continue;
            }
            HashSet<String> oldColumnIds = new HashSet<String>();
            if (Strings.isNotEmpty(configTemplateVO.getColumns())) {
                for (ConfigColumnVO columnVO : configTemplateVO.getColumns()) {
                    if (!Strings.isNotBlank((String)columnVO.getColumnId())) continue;
                    oldColumnIds.add(columnVO.getColumnId());
                }
            }
            this.importDataRenameColumnFolder(oldColumnIds, old2NewIdMap, copyToPath);
            this.capBusinessTemplateManager.resetTemplateConfigJSONIds(capBusinessTemplateBO, configTemplateVO, old2NewIdMap);
            this.checkId(capBusinessTemplateBO, configTemplateVO, dbColumnAndElementIds, "importTemplateFile");
            CAPBusinessUtil.writeConfigJSON(baseConfigPath, configTemplateVO.exportToMap());
            if (frameType != CAPBusinessEnum.TemplateFrameType.NO_NEED_FRAME.getType()) continue;
            needInitBackUpTemplateIds.add(Long.valueOf(capBusinessTemplateBO.getId()));
        }
        Long copyStartTime = System.currentTimeMillis();
        try {
            CAPBusinessUtil.copyTemplatesFromBaseToRuntime(newEggId, capBusinessTemplateBOs, true);
        }
        catch (IOException e) {
            LOGGER.error((Object)"ImportCustomTemplate IOException . copy base to runtime .", (Throwable)e);
            throw new BusinessException(e.getMessage(), (Throwable)e);
        }
        LOGGER.info((Object)("ImportCustomTemplate copy base files to runtime use time " + (System.currentTimeMillis() - copyStartTime) + " MS ,eggId " + newEggId + " , template size " + capBusinessTemplateBOs.size()));
        this.capBusinessTemplateManager.execTemplateInitialBackup(needInitBackUpTemplateIds);
    }

    private void importDataRenameColumnFolder(Set<String> oldColumnIds, Map<Long, Long> old2NewIdMap, String copyToPath) {
        if (Strings.isEmpty(oldColumnIds)) {
            return;
        }
        File columnFolder = new File(copyToPath + (copyToPath.endsWith(File.separator) ? "" : File.separator) + COLUMNS);
        if (columnFolder.exists() && columnFolder.list().length > 0) {
            String[] fileNames = columnFolder.list();
            for (int i = 0; i < fileNames.length; ++i) {
                Long newId;
                if (!oldColumnIds.contains(fileNames[i]) || (newId = old2NewIdMap.get(Long.valueOf(fileNames[i]))) == null || fileNames[i].equals(String.valueOf(newId))) continue;
                File columnFile = new File(columnFolder, fileNames[i]);
                columnFile.renameTo(new File(columnFolder, String.valueOf(newId)));
            }
        }
    }

    private void resetElementDataSource(Map<String, Object> dataInfo, BusinessDataBean businessDataBean) {
        if (dataInfo == null) {
            return;
        }
        for (String key : dataInfo.keySet()) {
            Object value = dataInfo.get(key);
            if (value == null) continue;
            if (value instanceof String || value instanceof Long) {
                Long oldId = null;
                if (value instanceof Long) {
                    oldId = (Long)value;
                } else {
                    String valueStr = String.valueOf(value);
                    if (Strings.isBlank((String)valueStr) || valueStr.length() < 15) continue;
                    try {
                        oldId = Long.parseLong(valueStr);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (oldId == null || oldId.equals(0L)) continue;
                Long newId = businessDataBean.genNewIdByOldId(oldId);
                dataInfo.put(key, String.valueOf(newId));
                continue;
            }
            if (!(value instanceof Map)) continue;
            this.resetElementDataSource((Map)value, businessDataBean);
        }
    }

    public void rollBackImportData(BusinessDataBean businessDataBean, List directDeleteList) throws BusinessException {
        BusinessPortalTemplateDataBean templateDataBean = businessDataBean.getBusinessPortalTemplateDataBean();
        if (templateDataBean == null || templateDataBean.getBizId() == null) {
            LOGGER.info((Object)"ImportCustomTemplate rollBackImportData , custom template is not do , continue other roolback");
            return;
        }
        Long bizId = templateDataBean.getBizId();
        List capBusinessTemplateBOs = templateDataBean.getDataList(CAPBusinessTemplateBO.class);
        if (capBusinessTemplateBOs == null) {
            LOGGER.info((Object)"ImportCustomTemplate rollBackImportData , custom template is null , continue other roolback");
            return;
        }
        this.capBusinessTemplateManager.deleteCAPBusinessTemplatesByBO(bizId, capBusinessTemplateBOs, 0);
        List capBusinessConfigBOS = templateDataBean.getDataList(CAPBusinessConfigBO.class);
        if (capBusinessConfigBOS != null) {
            this.capBusinessConfigManager.deleteCAPBusinessConfigBOs(capBusinessConfigBOS);
        }
    }

    public void clearBusinessData(BizConfigBean bizConfigBean) {
        List<CAPBusinessTemplateBO> capBusinessTemplateBOs = this.capBusinessTemplateManager.getCAPBusinessTemplatesByBizId(bizConfigBean.getId());
        try {
            this.capBusinessTemplateManager.deleteCAPBusinessTemplatesByBO(bizConfigBean.getId(), capBusinessTemplateBOs, 0);
        }
        catch (BusinessException e) {
            LOGGER.error((Object)"ImportCustomTemplate clearBusinessData is error ", (Throwable)e);
        }
    }

    public void redirectBusiness(BusinessRedirectDataBean businessRedirectDataBean, BusinessDataBean businessDataBean) throws BusinessException {
        List capBusinessTemplateBOS = businessDataBean.getBusinessPortalTemplateDataBean().getDataList(CAPBusinessTemplateBO.class);
        HashMap<String, String> idToOrgBos = new HashMap<String, String>();
        if (Strings.isNotEmpty((Collection)capBusinessTemplateBOS)) {
            OrgManager orgManager = (OrgManager)AppContext.getBean((String)"orgManager");
            for (CAPBusinessTemplateBO capBusinessTemplateBO : capBusinessTemplateBOS) {
                List<CAPBusinessOrgBO> capBusinessOrgBOS = capBusinessTemplateBO.getCapBusinessOrgBOs();
                if (!Strings.isNotEmpty((Collection)capBusinessTemplateBOS)) continue;
                for (CAPBusinessOrgBO capBusinessOrgBO : capBusinessOrgBOS) {
                    String orgType = capBusinessOrgBO.getOrgType();
                    String orgId = capBusinessOrgBO.getOrgId();
                    String orgName = capBusinessOrgBO.getOrgName();
                    V3xOrgEntity v3xOrgEntity = orgManager.getEntity(orgType, Long.valueOf(orgId));
                    if (v3xOrgEntity != null) {
                        idToOrgBos.put(capBusinessOrgBO.getId(), JSONUtil.toJSONString((Object)capBusinessOrgBO));
                        continue;
                    }
                    String key = BusinessRedirectDataBean.createKey((String)orgType, (String)orgName);
                    BusinessRedirectResultBean4Authorization authorization = new BusinessRedirectResultBean4Authorization();
                    authorization.setAuthorizationType(BusinessRedirectResultBean4Authorization.AuthorizationType.CUSTOM_TEMPLATE.name());
                    authorization.setTemplateId(Long.valueOf(capBusinessTemplateBO.getId()));
                    authorization.setSourceId(Long.valueOf(capBusinessOrgBO.getId()));
                    authorization.setOldValue4Show(orgName);
                    authorization.setOldValue4System(orgId);
                    authorization.setOrgType(orgType);
                    businessRedirectDataBean.addResultBean(key, (BusinessRedirectResultBean)authorization);
                    HashMap<String, String> valueMap = new HashMap<String, String>();
                    valueMap.put(BusinessEnums.AuthorizationDetailKey.LOCATION.getKey(), ResourceUtil.getString((String)"form.import.export.auth.details"));
                    valueMap.put(BusinessEnums.AuthorizationDetailKey.TYPE.getKey(), ResourceUtil.getString((String)"cap.template.portal.template"));
                    valueMap.put(BusinessEnums.AuthorizationDetailKey.AUTH_ITEM.getKey(), capBusinessTemplateBO.getName());
                    businessRedirectDataBean.addRedirectDetail(key, authorization.getCategory(), valueMap);
                    idToOrgBos.put(capBusinessOrgBO.getId(), JSONUtil.toJSONString((Object)capBusinessOrgBO));
                }
            }
        }
        AppContext.putSessionContext((String)(AppContext.currentUserId() + IMPORT_CUSTOM_TEMPLATE_ORGS), idToOrgBos);
    }

    public void mergeRedirectData(Map<String, List<Map<String, Object>>> redirectData, BizConfigBean bizConfigBean, AppUpgradeCacheBean appUpgradeCacheBean) throws BusinessException {
        List<Map<String, Object>> authList = redirectData.get("authorization");
        Map idToOrgBos = (Map)AppContext.getSessionContext((String)(AppContext.currentUserId() + IMPORT_CUSTOM_TEMPLATE_ORGS));
        if (Strings.isNotEmpty(authList) && idToOrgBos != null) {
            for (Map<String, Object> authMap : authList) {
                String authorizationType = CAPParamUtil.getString(authMap, (String)"authorizationType");
                if (!BusinessRedirectResultBean4Authorization.AuthorizationType.CUSTOM_TEMPLATE.name().equals(authorizationType)) continue;
                String newValue4Show = CAPParamUtil.getString(authMap, (String)"newValue4Show");
                String newValue4System = CAPParamUtil.getString(authMap, (String)"newValue4System");
                String sourceId = CAPParamUtil.getString(authMap, (String)"sourceId");
                String orgType = CAPParamUtil.getString(authMap, (String)"orgType");
                String orgMap = (String)idToOrgBos.get(sourceId);
                if (orgMap == null) continue;
                CAPBusinessOrgBO capBusinessOrgBO = (CAPBusinessOrgBO)JSONUtil.parseJSONString((String)orgMap, CAPBusinessOrgBO.class);
                capBusinessOrgBO.setOrgId(newValue4System);
                capBusinessOrgBO.setOrgType(orgType);
                capBusinessOrgBO.setOrgName(newValue4Show);
                idToOrgBos.put(sourceId, JSONUtil.toJSONString((Object)capBusinessOrgBO));
            }
        }
    }

    public void finalSaveRedirectData(BizConfigBean bizConfigBean) throws BusinessException {
        String sessionKey = AppContext.currentUserId() + IMPORT_CUSTOM_TEMPLATE_ORGS;
        Map idToOrgBos = (Map)AppContext.getSessionContext((String)sessionKey);
        if (idToOrgBos != null) {
            ArrayList<CAPBusinessOrgBO> orgBOS = new ArrayList<CAPBusinessOrgBO>();
            for (Map.Entry entry : idToOrgBos.entrySet()) {
                CAPBusinessOrgBO bo = (CAPBusinessOrgBO)JSONUtil.parseJSONString((String)((String)entry.getValue()), CAPBusinessOrgBO.class);
                orgBOS.add(bo);
            }
            if (orgBOS.size() > 0) {
                LOGGER.info((Object)("ImportCustomTemplate auth bo size " + orgBOS.size()));
                this.capBusinessTemplateOrgManager.saveCAPBusinessTemplateOrgs(orgBOS);
                AppContext.removeSessionArrribute((String)sessionKey);
            }
        }
        this.buildM3(bizConfigBean.getId());
    }

    private void buildM3(Long bizId) {
        LOGGER.info((Object)("ImportCustomTemplate begin build m3 , eggId " + bizId));
        CAPBuildM3Util.buildM3AppsByBizId(bizId, true);
        LOGGER.info((Object)("ImportCustomTemplate end build m3 , eggId " + bizId));
    }

    public void setCapBusinessTemplateManager(CAPBusinessTemplateManager capBusinessTemplateManager) {
        this.capBusinessTemplateManager = capBusinessTemplateManager;
    }

    public void setCapBusinessColumnManager(CAPBusinessColumnManager capBusinessColumnManager) {
        this.capBusinessColumnManager = capBusinessColumnManager;
    }

    public void setCapBusinessElementManager(CAPBusinessElementManager capBusinessElementManager) {
        this.capBusinessElementManager = capBusinessElementManager;
    }

    public void setCapBusinessConfigManager(CAPBusinessConfigManager capBusinessConfigManager) {
        this.capBusinessConfigManager = capBusinessConfigManager;
    }

    public void setCapBusinessTemplateOrgManager(CAPBusinessTemplateOrgManager capBusinessTemplateOrgManager) {
        this.capBusinessTemplateOrgManager = capBusinessTemplateOrgManager;
    }

    public void setBusinessManager4(BusinessManager businessManager4) {
        this.businessManager4 = businessManager4;
    }

    public void setCapBusinessTemplateClusterManager(CAPBusinessTemplateClusterManager capBusinessTemplateClusterManager) {
        this.capBusinessTemplateClusterManager = capBusinessTemplateClusterManager;
    }
}

