/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.importandexport;

import com.seeyon.apps.cloudapp.constant.MallEnum;
import com.seeyon.apps.mplus.api.MplusApi;
import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.fieldCtrl.FormFieldCustomCtrl;
import com.seeyon.cap4.form.bean.fieldCtrl.FormFieldUtil;
import com.seeyon.cap4.form.modules.business.BizConfigBean;
import com.seeyon.cap4.form.modules.business.BusinessDAO;
import com.seeyon.cap4.form.modules.business.BusinessManager;
import com.seeyon.cap4.form.modules.importandexport.AppUpgradeCacheBean;
import com.seeyon.cap4.form.modules.importandexport.BusinessEnums;
import com.seeyon.cap4.form.modules.importandexport.BusinessExportConstant;
import com.seeyon.cap4.form.modules.importandexport.BusinessFormExportManager;
import com.seeyon.cap4.form.modules.importandexport.BusinessImportAndExportManager;
import com.seeyon.cap4.form.modules.importandexport.BusinessModuleExportManager;
import com.seeyon.cap4.form.modules.importandexport.BusinessRedirectDataBean;
import com.seeyon.cap4.form.modules.importandexport.CAPRedirectOrgMatchDao;
import com.seeyon.cap4.form.modules.importandexport.CapAppSetupManager;
import com.seeyon.cap4.form.modules.importandexport.RollbackCacheBean;
import com.seeyon.cap4.form.po.CAPRedirectOrgMatch;
import com.seeyon.cap4.form.po.CapBizConfig;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.util.BusinessUtil;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.form.util.FormDesignUtil;
import com.seeyon.cap4.template.manager.CAPDownloadBaseManager;
import com.seeyon.cap4.template.util.CAPParamUtil;
import com.seeyon.cap4.template.util.HttpClientUtil;
import com.seeyon.cap4.template.util.mall.MallUtil;
import com.seeyon.cap4.template.vo.CAPDownloadUrlVO;
import com.seeyon.cap4.validity.constant.ValidityEnum;
import com.seeyon.cap4.validity.service.ValidateManager;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.SystemEnvironment;
import com.seeyon.ctp.common.appLog.AppLogAction;
import com.seeyon.ctp.common.appLog.manager.AppLogManager;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.filemanager.manager.FileManager;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.organization.OrgConstants;
import com.seeyon.ctp.organization.bo.V3xOrgEntity;
import com.seeyon.ctp.organization.manager.OrgManager;
import com.seeyon.ctp.portal.api.PortalApi;
import com.seeyon.ctp.privilege.manager.PrivilegeMenuManager;
import com.seeyon.ctp.util.DBAgent;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.Datetimes;
import com.seeyon.ctp.util.FileUtil;
import com.seeyon.ctp.util.ParamUtil;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDLong;
import com.seeyon.ctp.util.ZipUtil;
import com.seeyon.ctp.util.annotation.AjaxAccess;
import com.seeyon.ctp.util.annotation.CheckRoleAccess;
import com.seeyon.ctp.util.json.JSONUtil;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.web.client.RestTemplate;
import www.seeyon.com.utils.SSLUtil;

@CheckRoleAccess(roleTypes={OrgConstants.Role_NAME.BusinessDesigner})
public class CapAppSetupManagerImpl
implements CapAppSetupManager {
    private final Log logger = CtpLogFactory.getLog(CapAppSetupManagerImpl.class);
    private BusinessImportAndExportManager businessImportAndExportManager;
    private FileManager fileManager;
    private ValidateManager validateManager;
    private CAPRedirectOrgMatchDao capRedirectOrgMatchDao;
    private BusinessManager businessManager4;
    private BusinessDAO businessDAO4;
    private OrgManager orgManager;
    private CAP4FormCacheManager cap4FormCacheManager;
    private AppLogManager appLogManager;
    private MplusApi mplusApi;
    private CAPDownloadBaseManager capDownloadBaseManager;
    private PrivilegeMenuManager privilegeMenuManager;
    private static final String filestorageurl = AppContext.getSystemProperty((String)"cloudapp.filestorageurl");
    private PortalApi portalApi;

    @Override
    @AjaxAccess
    public Map<String, Object> verifyApp(Map<String, Object> params) throws BusinessException {
        this.logger.info((Object)(AppContext.currentUserName() + "\u5f00\u59cb\u672c\u5730\u5b89\u88c5\u5e94\u7528\uff01"));
        Long fileId = ParamUtil.getLong(params, (String)"fileId", (Long)0L);
        File importFile = this.fileManager.getFile(fileId, DateUtil.currentDate());
        if (importFile == null || !importFile.exists() || importFile.length() == 0L) {
            throw new BusinessException(ResourceUtil.getString((String)"com.cap.import.app.cant.find.specified.file.tips"));
        }
        Map<String, Object> resultMap = this.validateManager.validatePackage(importFile, true, "appSetup", params);
        return resultMap;
    }

    @Override
    @AjaxAccess
    public Map<String, Object> onlineInstall(Map<String, Object> params) throws BusinessException {
        String fileDownloadUrl;
        this.logger.info((Object)(AppContext.currentUserName() + "\u5f00\u59cb\u5728\u7ebf\u5b89\u88c5\u5e94\u7528\uff01"));
        String url = ParamUtil.getString(params, (String)"url", (String)"");
        String source = ParamUtil.getString(params, (String)"source", (String)"");
        if (Strings.isNotEmpty((String)source)) {
            try {
                fileDownloadUrl = this.getSetupFileDownloadUrl(url);
            }
            catch (Exception e) {
                this.logger.info((Object)("Online download file error, fileId:" + url), (Throwable)e);
                throw new BusinessException(ResourceUtil.getString((String)"com.cap.import.app.file.online.fail.tips"), (Throwable)e);
            }
        } else {
            fileDownloadUrl = this.mplusApi.getDomain() + url;
        }
        this.logger.info((Object)("fileDownloadUrl is :" + fileDownloadUrl));
        if (Strings.isNotEmpty((String)url)) {
            String fileName = UUIDLong.absLongUUID() + "";
            File appFile = new File(this.fileManager.getNowFolder(true), fileName);
            boolean downLoadFlag = HttpClientUtil.doHttpFileDownload(fileDownloadUrl, appFile);
            if (downLoadFlag) {
                Map<String, Object> resultMap = this.validateManager.validatePackage(appFile, true, "appSetup", params);
                FileUtil.deleteFile((File)appFile);
                return resultMap;
            }
        } else {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("code", ValidityEnum.ValidityResult.AppFail.getKey());
            result.put("message", ResourceUtil.getString((String)"com.cap.import.app.file.online.fail.tips"));
            return result;
        }
        return Collections.EMPTY_MAP;
    }

    private String getSetupFileDownloadUrl(String fileId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("access_token", "");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("appID", 9);
        map.put("code", MallUtil.getMallCommonParams((MallEnum.MallAction)null, new HashMap<String, Object>()).get("code"));
        map.put("params", params);
        String tokenUrl = MallUtil.CLOUD_APP_URL + "/rest/mall/index?action=/api/v5mall/getObsToken";
        String token = null;
        Map<String, Object> tokenResMap = HttpClientUtil.doPost(tokenUrl, map);
        if (tokenResMap != null && "1000".equals(CAPParamUtil.getString(tokenResMap, (String)"code"))) {
            token = CAPParamUtil.getString(tokenResMap, (String)"data");
        }
        RestTemplate restTemplate = new RestTemplate();
        SSLUtil.trustAll();
        this.logger.info((Object)filestorageurl);
        return (String)restTemplate.getForObject(filestorageurl + "/api/file/download_file?fileId=" + fileId + "&white_sword=" + token, String.class, new Object[0]);
    }

    @Override
    @AjaxAccess
    public Map<String, Object> systemDetection(Map<String, Object> params) throws BusinessException {
        String filePath;
        HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
        resultMap.put("success", false);
        String path = ParamUtil.getString(params, (String)"path");
        Object pathObj = AppContext.getSessionContext((String)BusinessUtil.getUnzipFilePathSessionKey(AppContext.currentUserId(), path));
        String string = filePath = pathObj == null ? "" : pathObj.toString();
        if (Strings.isBlank((String)filePath)) {
            resultMap.put("msg", ResourceUtil.getString((String)"com.cap.import.app.cant.find.file.path.tips"));
            return resultMap;
        }
        File appFile = new File(filePath);
        if (appFile == null || !appFile.isDirectory()) {
            resultMap.put("msg", ResourceUtil.getString((String)"com.cap.import.app.file.path.error.tips"));
            return resultMap;
        }
        File[] files = appFile.listFiles()[0].listFiles();
        File extensionFile = null;
        for (File tempFile : files) {
            if (!tempFile.isFile() || !"extension.json".equals(tempFile.getName())) continue;
            extensionFile = tempFile;
            break;
        }
        if (extensionFile == null) {
            resultMap.put("msg", ResourceUtil.getString((String)"com.cap.import.app.file.tamper.tips"));
            return resultMap;
        }
        try {
            String extension = FileUtils.readFileToString(extensionFile, (String)"UTF-8");
            Map extensionMap = (Map)JSONUtil.parseJSONString((String)extension);
            HashMap<String, String> editionCheckResult = new HashMap<String, String>();
            String bizEdition = (String)extensionMap.get("fileVersion");
            Enums.CapAppVersionType currentVersion = Enums.CapAppVersionType.getEnumByKey((String)"v2.0");
            if (null != currentVersion && currentVersion.getSupportedEggVersions().contains(bizEdition)) {
                editionCheckResult.put("checkResult", "true");
                editionCheckResult.put("msg", ResourceUtil.getString((String)"com.cap.import.app.system.detection.success.tips"));
            } else {
                if (null == currentVersion) {
                    this.logger.error((Object)("\u627e\u4e0d\u5230\u201c" + bizEdition + "\u201d\u6240\u5bf9\u5e94\u7684\u4e1a\u52a1\u5305\u679a\u4e3e\u7248\u672c\u4fe1\u606f\uff01"));
                }
                editionCheckResult.put("checkResult", "false");
                editionCheckResult.put("msg", ResourceUtil.getString((String)"com.cap.import.app.system.detection.fail.tips"));
            }
            editionCheckResult.put("bizFileEdition", bizEdition);
            editionCheckResult.put("supportedEdition", "v2.0");
            editionCheckResult.put("capContainerVersionInFile", (String)extensionMap.get("capContainerVersion"));
            StringBuilder appPlatformVersion = new StringBuilder();
            appPlatformVersion.append("B").append(Datetimes.format((Date)SystemEnvironment.getProductBuildDate(), (String)"yyMMdd"));
            appPlatformVersion.append(".").append(SystemEnvironment.getProductBuildVersion()).append(".CTP");
            appPlatformVersion.append(SystemEnvironment.getCtpProductBuildVersion());
            editionCheckResult.put("capContainerVersion", appPlatformVersion.toString());
            resultMap.put("editionCheckResult", editionCheckResult);
            boolean isOnline = MallUtil.isCloudConnect();
            HashMap<String, Serializable> customCtrlCheckResult = new HashMap<String, Serializable>();
            List customCtrls = (List)extensionMap.get("customCtrl");
            boolean existsNotInCtrl = false;
            ArrayList customCtrlJsons = new ArrayList();
            if (customCtrls != null && customCtrls.size() > 0) {
                for (Map customCtrl : customCtrls) {
                    String ctrlKey = (String)customCtrl.get("key");
                    String ctrlText = (String)customCtrl.get("text");
                    FormFieldCustomCtrl ctrl = FormFieldUtil.getCustomCtrlByKey((String)ctrlKey);
                    HashMap<String, Object> res = new HashMap<String, Object>();
                    res.put("text", ctrlText);
                    if (null != ctrl && ctrl.isValid()) {
                        res.put("state", "3");
                    } else {
                        existsNotInCtrl = true;
                        if (isOnline) {
                            HashMap<String, Object> in = new HashMap<String, Object>();
                            ArrayList<String> list = new ArrayList<String>();
                            list.add(ctrlKey);
                            in.put("goodsKeys", list);
                            Map<String, CAPDownloadUrlVO> result = this.capDownloadBaseManager.getFreeDownloadInfo(in);
                            if (null == result || result.size() < 1) {
                                res.put("state", "2");
                            } else {
                                CAPDownloadUrlVO capDownloadUrlVO = result.get(ctrlKey);
                                res.put("state", capDownloadUrlVO.isFree() ? "1" : "2");
                                res.put("goodId", capDownloadUrlVO.getGoodId());
                                res.put("url", capDownloadUrlVO.getInfoUrl());
                            }
                        } else {
                            res.put("state", "1");
                        }
                    }
                    customCtrlJsons.add(res);
                }
            }
            customCtrlCheckResult.put("existsNotInCtrl", Boolean.valueOf(existsNotInCtrl));
            customCtrlCheckResult.put("ctrlList", customCtrlJsons);
            customCtrlCheckResult.put("isOnline", Boolean.valueOf(isOnline));
            resultMap.put("ctrlCheckResult", customCtrlCheckResult);
            String upgrade = ParamUtil.getString(params, (String)"upgrade", (String)"");
            if ("true".equals(upgrade) && !this.checkAppVersion4Upgrade(params, resultMap)) {
                return resultMap;
            }
        }
        catch (IOException e) {
            this.logger.info((Object)("\u89e3\u6790\u5e94\u7528\u5c5e\u6027\u6587\u4ef6\u5f02\u5e38\uff0c" + e.getMessage()), (Throwable)e);
            resultMap.put("msg", ResourceUtil.getString((String)"com.cap.import.app.analysis.file.error.tips") + e.getMessage());
        }
        resultMap.put("success", true);
        return resultMap;
    }

    private boolean checkAppVersion4Upgrade(Map<String, Object> params, Map<String, Object> resultMap) throws BusinessException {
        Map editionCheckResultMap = (Map)resultMap.get("editionCheckResult");
        Map verifyInfo = (Map)params.get("verifyInfo");
        Long bizConfigId = ParamUtil.getLong((Map)verifyInfo, (String)"resultAppId", (Long)0L);
        BizConfigBean bizConfigBean = this.businessManager4.findBizConfigById(bizConfigId);
        if (bizConfigBean != null) {
            String appVersion = bizConfigBean.getBizVersion();
            String bizVersion = ParamUtil.getString((Map)verifyInfo, (String)"bizVersion", (String)"");
            editionCheckResultMap.put("currentAppVersion", appVersion == null ? "" : appVersion);
            editionCheckResultMap.put("upgradeAppVersion", bizVersion);
            if (Strings.isEmpty((String)appVersion) || Strings.isEmpty((String)bizVersion)) {
                editionCheckResultMap.put("confirmUpgrade4Version", true);
                editionCheckResultMap.put("confirmMsg", ResourceUtil.getString((String)"com.cap.app.upgrade.no.version.tips"));
            } else {
                boolean canUpgrade = true;
                appVersion = appVersion.replace("V", "").replace("v", "");
                bizVersion = bizVersion.replace("V", "").replace("v", "");
                String[] currentArr = appVersion.split("[.]");
                String[] upgradeArr = bizVersion.split("[.]");
                int currentPlantVersion = CapAppSetupManagerImpl.getVersionNum(currentArr, 0);
                int upgradePlantVersion = CapAppSetupManagerImpl.getVersionNum(upgradeArr, 0);
                if (upgradePlantVersion < currentPlantVersion) {
                    canUpgrade = false;
                }
                if (upgradePlantVersion == currentPlantVersion) {
                    int currentSecondPlant = CapAppSetupManagerImpl.getVersionNum(currentArr, 1);
                    int upgradeSecondPlant = CapAppSetupManagerImpl.getVersionNum(upgradeArr, 1);
                    if (upgradeSecondPlant < currentSecondPlant) {
                        canUpgrade = false;
                    } else if (upgradeSecondPlant == currentSecondPlant) {
                        int upgradeCustomizeVersion;
                        int currentCustomizeVersion;
                        int currentProductVersion = CapAppSetupManagerImpl.getVersionNum(currentArr, 2);
                        int upgradeProductVersion = CapAppSetupManagerImpl.getVersionNum(upgradeArr, 2);
                        if (upgradeProductVersion < currentProductVersion) {
                            canUpgrade = false;
                        } else if (upgradeProductVersion == currentProductVersion && (currentCustomizeVersion = CapAppSetupManagerImpl.getVersionNum(currentArr, 3)) > (upgradeCustomizeVersion = CapAppSetupManagerImpl.getVersionNum(upgradeArr, 3))) {
                            canUpgrade = false;
                        }
                    }
                }
                if (!canUpgrade) {
                    resultMap.put("success", true);
                    editionCheckResultMap.put("checkResult", "false");
                    editionCheckResultMap.put("msg", "\u5e94\u7528\u7248\u672c\u4e0d\u5339\u914d\uff0c\u4e0d\u80fd\u7ee7\u7eed\u5347\u7ea7\uff01");
                    return false;
                }
            }
        }
        return true;
    }

    private static int getVersionNum(String[] arr, int index) {
        int result = 0;
        if (arr.length > index) {
            String str = arr[index];
            return Integer.valueOf(str);
        }
        return result;
    }

    @Override
    @AjaxAccess
    public Map<String, Object> officialImport(Map<String, Object> params) throws BusinessException {
        String filePath;
        if (params == null) {
            params = new HashMap<String, Object>(16);
        }
        String path = ParamUtil.getString(params, (String)"path");
        Object pathObj = AppContext.getSessionContext((String)BusinessUtil.getUnzipFilePathSessionKey(AppContext.currentUserId(), path));
        String string = filePath = pathObj == null ? "" : pathObj.toString();
        if (Strings.isBlank((String)filePath)) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>(4);
            resultMap.put("success", false);
            resultMap.put("msg", ResourceUtil.getString((String)"com.cap.import.app.cant.find.file.path.tips"));
            return resultMap;
        }
        params.put("filePath", filePath);
        return this.businessImportAndExportManager.appSetup(params);
    }

    @Override
    @AjaxAccess
    public Map<String, Object> intelligentMatch(Map<String, Object> params) throws BusinessException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        resultMap.put("success", true);
        Long bizConfigId = ParamUtil.getLong(params, (String)"bizConfigId", (Long)0L);
        Map baseParam = (Map)params.get("baseParam");
        String upgrade = ParamUtil.getString((Map)baseParam, (String)"upgrade", (String)"false");
        BizConfigBean bizConfigBean = this.businessManager4.findBizConfigById(bizConfigId);
        Map matchData = (Map)params.get("matchData");
        List<CAPRedirectOrgMatch> redirectOrgMatchList = this.capRedirectOrgMatchDao.selectByOwnerId(AppContext.currentUserId());
        if (redirectOrgMatchList == null) {
            redirectOrgMatchList = new ArrayList<CAPRedirectOrgMatch>();
        }
        HashMap<String, CAPRedirectOrgMatch> autoMatchData = new HashMap<String, CAPRedirectOrgMatch>(16);
        for (CAPRedirectOrgMatch temp : redirectOrgMatchList) {
            String key = BusinessRedirectDataBean.createKey((String)temp.getOldOrgType(), (String)temp.getOldOrgName());
            autoMatchData.put(key, temp);
        }
        ArrayList<CAPRedirectOrgMatch> invalidList = new ArrayList<CAPRedirectOrgMatch>();
        ArrayList<CAPRedirectOrgMatch> addList = new ArrayList<CAPRedirectOrgMatch>();
        HashMap<String, List<Map<String, Object>>> categoryMap = new HashMap<String, List<Map<String, Object>>>(16);
        HashMap matchedData = new HashMap(16);
        for (Map.Entry entry : matchData.entrySet()) {
            CAPRedirectOrgMatch capRedirectOrgMatch = (CAPRedirectOrgMatch)((Object)autoMatchData.get(entry.getKey()));
            V3xOrgEntity v3xOrgEntity = null;
            boolean hasMatch = false;
            if (capRedirectOrgMatch != null) {
                if (invalidList.contains((Object)capRedirectOrgMatch)) continue;
                String newOrgValue = capRedirectOrgMatch.getNewOrgValue();
                if (Strings.isDigits((String)newOrgValue)) {
                    v3xOrgEntity = this.orgManager.getEntity(capRedirectOrgMatch.getOldOrgType(), Long.valueOf(newOrgValue));
                }
                if (v3xOrgEntity != null) {
                    if (v3xOrgEntity.isValid()) {
                        hasMatch = true;
                    } else {
                        invalidList.add(capRedirectOrgMatch);
                        v3xOrgEntity = null;
                        hasMatch = false;
                    }
                } else {
                    hasMatch = false;
                }
            }
            Map dataMap = (Map)((List)entry.getValue()).get(0);
            String oldValue = dataMap.get("oldValue4System").toString();
            String oldName = dataMap.get("oldValue4Show").toString();
            String key = (String)entry.getKey();
            String orgType = key.split("@@@")[0];
            String newOrgValue = "";
            if (!hasMatch) {
                Map tempMap = FormDesignUtil.customerRoleIntelligentMatch((String)orgType, (String)oldName, (String)oldValue);
                v3xOrgEntity = (V3xOrgEntity)tempMap.get("v3x");
                newOrgValue = (String)tempMap.get("value");
                if (v3xOrgEntity != null) {
                    capRedirectOrgMatch = this.createRedirectOrgMatch(orgType, newOrgValue, oldName);
                    addList.add(capRedirectOrgMatch);
                }
            }
            if (v3xOrgEntity == null) continue;
            for (Map map : (List)entry.getValue()) {
                map.put("newValue4System", capRedirectOrgMatch.getNewOrgValue());
                map.put("newValue4Show", v3xOrgEntity.getName());
                map.put("oldValue", map.get("oldValue4System") + "::" + map.get("oldValue4Show") + "::");
                map.put("newValue", capRedirectOrgMatch.getNewOrgValue() + "::" + v3xOrgEntity.getName() + "::");
                String category = map.get("category").toString();
                ArrayList<Map> list = (ArrayList<Map>)categoryMap.get(category);
                if (list == null) {
                    list = new ArrayList<Map>();
                    categoryMap.put(category, list);
                }
                list.add(map);
            }
            matchedData.put(entry.getKey(), entry.getValue());
        }
        if (Strings.isNotEmpty(invalidList)) {
            this.capRedirectOrgMatchDao.delete(invalidList);
        }
        if (Strings.isNotEmpty(addList)) {
            this.capRedirectOrgMatchDao.insert(addList);
        }
        this.executeMerge(categoryMap, bizConfigBean, Boolean.valueOf(upgrade));
        for (Map.Entry entry : matchedData.entrySet()) {
            for (Map temp : (List)entry.getValue()) {
                temp.put("oldValue4System", temp.get("newValue4System"));
                temp.put("oldValue4Show", temp.get("newValue4Show"));
            }
        }
        resultMap.put("matchData", matchedData);
        return resultMap;
    }

    private CAPRedirectOrgMatch createRedirectOrgMatch(String orgType, String newOrgValue, String oldOrgName) {
        CAPRedirectOrgMatch capRedirectOrgMatch = new CAPRedirectOrgMatch();
        capRedirectOrgMatch.setNewId();
        capRedirectOrgMatch.setCreateId(AppContext.currentUserId());
        Date currentDate = DateUtil.currentDate();
        capRedirectOrgMatch.setCreateTime(currentDate);
        capRedirectOrgMatch.setModifyTime(currentDate);
        capRedirectOrgMatch.setOldOrgType(orgType);
        capRedirectOrgMatch.setNewOrgValue(newOrgValue);
        capRedirectOrgMatch.setOldOrgName(oldOrgName);
        capRedirectOrgMatch.setOwnerId(AppContext.currentUserId());
        return capRedirectOrgMatch;
    }

    @Override
    @AjaxAccess
    public Map<String, Object> redirectSingleOrg(Map<String, Object> params) throws BusinessException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        Long bizConfigId = ParamUtil.getLong(params, (String)"bizConfigId", (Long)0L);
        Map baseParam = (Map)params.get("baseParam");
        String upgrade = ParamUtil.getString((Map)baseParam, (String)"upgrade", (String)"false");
        BizConfigBean bizConfigBean = this.businessManager4.findBizConfigById(bizConfigId);
        Map orgData = (Map)params.get("orgData");
        List matchData = (List)params.get("matchData");
        String value = orgData.get("value").toString();
        String[] array = value.split("[|]");
        value = array[1];
        String orgType = orgData.get("orgType").toString();
        String orgName = orgData.get("text").toString();
        String oldOrgName = "";
        boolean seted = false;
        for (Map map : matchData) {
            if (!seted) {
                oldOrgName = map.get("oldValue4Show").toString();
                seted = true;
            }
            map.put("newValue4System", value);
            map.put("newValue4Show", orgName);
            map.put("oldValue", map.get("oldValue4System") + "::" + map.get("oldValue4Show") + "::");
            map.put("newValue", value + "::" + orgName + "::");
            map.put("newOrgType", orgType);
        }
        this.mergeRedirectData(matchData, bizConfigBean, Boolean.valueOf(upgrade));
        for (Map map : matchData) {
            map.put("oldValue4System", map.get("newValue4System"));
            map.put("oldValue4Show", map.get("newValue4Show"));
        }
        HashMap<String, Object> queryMap = new HashMap<String, Object>(3);
        queryMap.put("oldOrgType", orgType);
        queryMap.put("oldOrgName", oldOrgName);
        queryMap.put("ownerId", AppContext.currentUserId());
        List<CAPRedirectOrgMatch> redirectOrgMatchList = this.capRedirectOrgMatchDao.selectByParam(queryMap);
        CAPRedirectOrgMatch capRedirectOrgMatch = null;
        if (Strings.isEmpty(redirectOrgMatchList)) {
            capRedirectOrgMatch = this.createRedirectOrgMatch(orgType, value, oldOrgName);
            this.capRedirectOrgMatchDao.insert(capRedirectOrgMatch);
        } else {
            capRedirectOrgMatch = redirectOrgMatchList.get(0);
            capRedirectOrgMatch.setModifyTime(DateUtil.currentDate());
            capRedirectOrgMatch.setNewOrgValue(value);
            this.capRedirectOrgMatchDao.update(capRedirectOrgMatch);
        }
        resultMap.put("matchData", matchData);
        return resultMap;
    }

    private void mergeRedirectData(List<Map<String, Object>> redirectDataList, BizConfigBean bizConfigBean, boolean upgrade) throws BusinessException {
        HashMap<String, List<Map<String, Object>>> categoryMap = new HashMap<String, List<Map<String, Object>>>(16);
        for (Map<String, Object> tempMap : redirectDataList) {
            String category = tempMap.get("category").toString();
            ArrayList<Map<String, Object>> list = (ArrayList<Map<String, Object>>)categoryMap.get(category);
            if (list == null) {
                list = new ArrayList<Map<String, Object>>();
                categoryMap.put(category, list);
            }
            list.add(tempMap);
        }
        this.executeMerge(categoryMap, bizConfigBean, upgrade);
    }

    private void executeMerge(Map<String, List<Map<String, Object>>> categoryMap, BizConfigBean bizConfigBean, boolean upgrade) throws BusinessException {
        List managerList = FormDesignUtil.getBusinessModuleExportManager();
        AppUpgradeCacheBean appUpgradeCacheBean = null;
        if (upgrade) {
            appUpgradeCacheBean = this.businessImportAndExportManager.getAppUpgradeCacheBean(bizConfigBean.getId());
            bizConfigBean = appUpgradeCacheBean.getBizConfigBean();
        }
        for (BusinessModuleExportManager manager : managerList) {
            manager.mergeRedirectData(categoryMap, bizConfigBean, appUpgradeCacheBean);
        }
    }

    @Override
    @AjaxAccess
    public Map<String, Object> completeSetup(Map<String, Object> params) throws BusinessException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(2);
        Long bizConfigId = ParamUtil.getLong(params, (String)"bizConfigId", (Long)0L);
        CapBizConfig capBizConfig = this.businessDAO4.findBizConfigById(bizConfigId);
        if (capBizConfig != null) {
            try {
                BizConfigBean bizConfigBean = new BizConfigBean(capBizConfig);
                List managerList = FormDesignUtil.getBusinessModuleExportManager();
                for (BusinessModuleExportManager manager : managerList) {
                    manager.finalSaveRedirectData(bizConfigBean);
                }
                String setupType = ParamUtil.getString(params, (String)"setupType");
                this.insertSetupLog(bizConfigBean.getName(), setupType, BusinessEnums.AppOperation.success);
                String setupTypeLog = BusinessEnums.SetupType.LOCAL.getKey().equals(setupType) ? "\u672c\u5730\u5b89\u88c5" : "\u5728\u7ebf\u5b89\u88c5";
                this.logger.info((Object)(AppContext.currentUserName() + "\u5b8c\u6210" + setupTypeLog + "\u5e94\u7528" + bizConfigBean.getName() + "\uff01"));
            }
            catch (Exception e) {
                this.cancelSetup(params);
                throw new BusinessException(e.getMessage(), (Throwable)e);
            }
        }
        resultMap.put("success", true);
        return resultMap;
    }

    @Override
    public void insertSetupLog(String appName, String setupType, BusinessEnums.AppOperation appOperation) {
        AppLogAction appLogAction = AppLogAction.APP_ONLINE_SETUP;
        if (BusinessEnums.SetupType.LOCAL.getKey().equals(setupType)) {
            appLogAction = AppLogAction.APP_LOCAL_SETUP;
        }
        this.appLogManager.insertLog(AppContext.getCurrentUser(), appLogAction, new String[]{AppContext.currentUserName(), appOperation.getPrefix(), appName, appOperation.getSuffix()});
    }

    @Override
    @AjaxAccess
    public Map<String, Object> cancelSetup(Map<String, Object> params) throws BusinessException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(2);
        String setupType = ParamUtil.getString(params, (String)"setupType");
        Long bizConfigId = ParamUtil.getLong(params, (String)"bizConfigId", (Long)0L);
        BizConfigBean bizConfigBean = this.businessManager4.findBizConfigById(bizConfigId);
        String setupTypeLog = BusinessEnums.SetupType.LOCAL.getKey().equals(setupType) ? "\u672c\u5730\u5b89\u88c5" : "\u5728\u7ebf\u5b89\u88c5";
        String appName = bizConfigBean == null ? "" : bizConfigBean.getName();
        this.logger.info((Object)(AppContext.currentUserName() + "\u53d6\u6d88" + setupTypeLog + "\u5e94\u7528" + appName + "\uff01"));
        if (bizConfigBean != null) {
            List managerList = FormDesignUtil.getBusinessModuleExportManager();
            for (BusinessModuleExportManager manager : managerList) {
                try {
                    manager.clearBusinessData(bizConfigBean);
                }
                catch (Exception e) {
                    this.logger.info((Object)("\u53d6\u6d88\u5e94\u7528\u5b89\u88c5[+" + manager.getClass().getSimpleName() + "+]\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getMessage()), (Throwable)e);
                }
            }
        } else {
            File file;
            String filePath;
            String path = ParamUtil.getString(params, (String)"path");
            Object pathObj = AppContext.getSessionContext((String)BusinessUtil.getUnzipFilePathSessionKey(AppContext.currentUserId(), path));
            String string = filePath = pathObj == null ? "" : pathObj.toString();
            if (Strings.isNotBlank((String)filePath) && (file = new File(filePath)).isDirectory()) {
                FileUtil.deleteFile((File)file);
            }
        }
        resultMap.put("success", true);
        return resultMap;
    }

    @Override
    public Map<String, Object> mergeNodePolicy(Map<String, Object> params) throws BusinessException {
        BizConfigBean bizConfigBean;
        HashMap<String, Object> resultMap = new HashMap<String, Object>(2);
        resultMap.put("success", true);
        Map baseParam = (Map)params.get("baseParam");
        String upgrade = ParamUtil.getString((Map)baseParam, (String)"upgrade", (String)"false");
        Long bizConfigId = ParamUtil.getLong(params, (String)"bizConfigId", (Long)0L);
        Map nodePolicyMap = (Map)params.get("nodePolicyMap");
        AppUpgradeCacheBean appUpgradeCacheBean = null;
        if ("true".equals(upgrade)) {
            appUpgradeCacheBean = this.businessImportAndExportManager.getAppUpgradeCacheBean(bizConfigId);
        }
        if ((bizConfigBean = this.businessManager4.findBizConfigById(bizConfigId)) != null) {
            ArrayList<FormBean> formBeanList = new ArrayList<FormBean>();
            List formIdList = (List)AppContext.getSessionContext((String)(AppContext.currentUserId() + "_" + bizConfigBean.getId() + "_formIds"));
            for (Long formId : formIdList) {
                FormBean formBean = appUpgradeCacheBean != null ? appUpgradeCacheBean.getForm(formId) : this.cap4FormCacheManager.getForm(formId);
                formBeanList.add(formBean);
            }
            if (Strings.isNotEmpty(formBeanList)) {
                List managerList = FormDesignUtil.getExportManagerList();
                for (BusinessFormExportManager manager : managerList) {
                    manager.mergeNodePolicy(formBeanList, nodePolicyMap, appUpgradeCacheBean);
                }
            }
        }
        return resultMap;
    }

    @Override
    public Map<String, Object> exportAppValidate(Map<String, Object> params) throws BusinessException {
        HashMap<String, Object> result = new HashMap<String, Object>(4);
        result.put("success", false);
        Long bizConfigId = ParamUtil.getLong(params, (String)"bizConfigId", (Long)0L);
        BizConfigBean bizConfigBean = this.businessManager4.findBizConfigById(bizConfigId);
        if (bizConfigBean == null) {
            result.put("msg", "can't find current application,please refresh this page!");
            return result;
        }
        result.put("licensed", SystemEnvironment.isTG());
        result.put("exportTypeList", this.businessImportAndExportManager.getExportAppTypeList(bizConfigBean));
        result.put("success", true);
        return result;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED, rollbackFor={BusinessException.class})
    public Map<String, Object> completeUpgrade(Map<String, Object> params) throws BusinessException {
        File file;
        String filePath;
        HashMap<String, Object> resultMap = new HashMap<String, Object>(2);
        Long bizConfigId = ParamUtil.getLong(params, (String)"bizConfigId", (Long)0L);
        final AppUpgradeCacheBean appUpgradeCacheBean = this.businessImportAndExportManager.getAppUpgradeCacheBean(bizConfigId);
        final List managerList = FormDesignUtil.getBusinessModuleExportManager();
        try {
            RollbackCacheBean rollbackCacheBean = new RollbackCacheBean();
            appUpgradeCacheBean.setRollbackCacheBean(rollbackCacheBean);
            if (TransactionSynchronizationManager.isActualTransactionActive()) {
                TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

                    public void afterCompletion(int status) {
                        super.afterCompletion(status);
                        if (status == 1 && appUpgradeCacheBean.getRollbackCacheBean() != null) {
                            DBAgent.clear();
                            for (BusinessModuleExportManager manager : managerList) {
                                try {
                                    manager.restoreCache(appUpgradeCacheBean);
                                }
                                catch (BusinessException e) {
                                    CapAppSetupManagerImpl.this.logger.info((Object)("restore cache exception:" + e.getMessage()), (Throwable)e);
                                }
                            }
                        }
                    }

                    public void afterCommit() {
                        super.afterCommit();
                        for (BusinessModuleExportManager manager : managerList) {
                            try {
                                manager.afterCommit(appUpgradeCacheBean);
                            }
                            catch (BusinessException e) {
                                CapAppSetupManagerImpl.this.logger.info((Object)("after commit exception:" + e.getMessage()), (Throwable)e);
                            }
                        }
                    }
                });
            }
            for (BusinessModuleExportManager manager : managerList) {
                manager.completeUpgrade(appUpgradeCacheBean);
            }
            for (BusinessModuleExportManager manager : managerList) {
                manager.loadCache(appUpgradeCacheBean);
            }
            this.privilegeMenuManager.updateBiz();
            this.portalApi.clearPortalMenusCache();
            this.businessImportAndExportManager.removeUpgradeMap(bizConfigId);
        }
        catch (Exception e) {
            try {
                this.logger.info((Object)("\u5b8c\u6210\u5347\u7ea7\u7684\u65f6\u5019\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getMessage()), (Throwable)e);
                throw new BusinessException(e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                File file2;
                String filePath2;
                this.businessImportAndExportManager.removeUpgradeMap(bizConfigId);
                String path = ParamUtil.getString(params, (String)"path");
                Object pathObj = AppContext.getSessionContext((String)BusinessUtil.getUnzipFilePathSessionKey(AppContext.currentUserId(), path));
                String string = filePath2 = pathObj == null ? "" : pathObj.toString();
                if (Strings.isNotBlank((String)filePath2) && (file2 = new File(filePath2)).isDirectory()) {
                    FileUtil.deleteFile((File)file2);
                }
                throw throwable;
            }
        }
        String path = ParamUtil.getString(params, (String)"path");
        Object pathObj = AppContext.getSessionContext((String)BusinessUtil.getUnzipFilePathSessionKey(AppContext.currentUserId(), path));
        String string = filePath = pathObj == null ? "" : pathObj.toString();
        if (Strings.isNotBlank((String)filePath) && (file = new File(filePath)).isDirectory()) {
            FileUtil.deleteFile((File)file);
        }
        resultMap.put("success", true);
        return resultMap;
    }

    @Override
    @AjaxAccess
    public Map<String, Object> cancelUpgrade(Map<String, Object> params) throws BusinessException {
        File file;
        String filePath;
        Map verifyInfoMap;
        Long bizConfigId = ParamUtil.getLong(params, (String)"bizConfigId", (Long)0L);
        if (bizConfigId.equals(0L) && (verifyInfoMap = (Map)params.get("verifyInfo")) != null) {
            bizConfigId = ParamUtil.getLong((Map)verifyInfoMap, (String)"resultAppId", (Long)0L);
        }
        this.businessImportAndExportManager.removeUpgradeMap(bizConfigId);
        BizConfigBean bizConfigBean = this.businessManager4.findBizConfigById(bizConfigId);
        String appName = bizConfigBean == null ? "" : bizConfigBean.getName();
        this.logger.info((Object)(AppContext.currentUserName() + "\u53d6\u6d88\u3010" + appName + "\u3011\u5e94\u7528\u5347\u7ea7\uff01"));
        String path = ParamUtil.getString(params, (String)"path");
        Object pathObj = AppContext.getSessionContext((String)BusinessUtil.getUnzipFilePathSessionKey(AppContext.currentUserId(), path));
        String string = filePath = pathObj == null ? "" : pathObj.toString();
        if (Strings.isNotBlank((String)filePath) && (file = new File(filePath)).isDirectory()) {
            FileUtil.deleteFile((File)file);
        }
        return null;
    }

    @Override
    @AjaxAccess
    public Map<String, Object> checkAppBeforeInstall(Map<String, Object> params) throws BusinessException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(3);
        resultMap.put("success", true);
        Long fileId = ParamUtil.getLong(params, (String)"fileId", (Long)0L);
        File importFile = this.fileManager.getFile(fileId, DateUtil.currentDate());
        if (importFile == null || !importFile.exists() || importFile.length() == 0L) {
            throw new BusinessException(ResourceUtil.getString((String)"com.cap.import.app.cant.find.specified.file.tips"));
        }
        String unZipPath = BusinessExportConstant.TEMP_DIR + File.separator + UUIDLong.absLongUUID();
        File unZipFile = new File(unZipPath);
        try {
            ZipUtil.unzip((File)importFile, (File)unZipFile, (String)"ahfhaflafpon");
            File[] files = unZipFile.listFiles();
            String appIdStr = "";
            for (File file : files) {
                String id;
                String[] arr;
                if (!file.isFile() || !file.getName().endsWith(".zip") || (arr = (id = file.getName().substring(0, file.getName().lastIndexOf("."))).split("[_]")).length != 2) continue;
                appIdStr = arr[1];
                break;
            }
            if (Strings.isEmpty((String)appIdStr) && files.length == 1) {
                appIdStr = files[0].getName();
            }
            if (Strings.isNotEmpty((String)appIdStr) && Strings.isLong((String)appIdStr)) {
                Long bizConfigId = Long.parseLong(appIdStr);
                BizConfigBean bizConfigBean = this.businessManager4.findBizConfigById(bizConfigId);
                if (bizConfigBean != null) {
                    resultMap.put("msg", ResourceUtil.getString((String)"com.cap.setup.app.exist.and.confirm.new.or.upgrade"));
                    resultMap.put("exist", true);
                    resultMap.put("appName", bizConfigBean.getName());
                    resultMap.put("appId", bizConfigBean.getId());
                } else {
                    resultMap.put("exist", false);
                }
            } else {
                resultMap.put("success", false);
                resultMap.put("msg", ResourceUtil.getString((String)"com.cap.setup.app.upload.file.illegal.tips"));
            }
        }
        catch (Exception e) {
            this.logger.info((Object)("\u68c0\u67e5\u5b89\u88c5\u6587\u4ef6\u5f02\u5e38\uff1a" + e.getMessage()), (Throwable)e);
            throw new BusinessException(e.getMessage(), (Throwable)e);
        }
        finally {
            FileUtil.deleteFile((File)unZipFile);
        }
        return resultMap;
    }

    public void setBusinessImportAndExportManager(BusinessImportAndExportManager businessImportAndExportManager) {
        this.businessImportAndExportManager = businessImportAndExportManager;
    }

    public void setFileManager(FileManager fileManager) {
        this.fileManager = fileManager;
    }

    public void setValidateManager(ValidateManager validateManager) {
        this.validateManager = validateManager;
    }

    public void setCapRedirectOrgMatchDao(CAPRedirectOrgMatchDao capRedirectOrgMatchDao) {
        this.capRedirectOrgMatchDao = capRedirectOrgMatchDao;
    }

    public void setBusinessManager4(BusinessManager businessManager4) {
        this.businessManager4 = businessManager4;
    }

    public void setOrgManager(OrgManager orgManager) {
        this.orgManager = orgManager;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public void setAppLogManager(AppLogManager appLogManager) {
        this.appLogManager = appLogManager;
    }

    public void setBusinessDAO4(BusinessDAO businessDAO4) {
        this.businessDAO4 = businessDAO4;
    }

    public void setMplusApi(MplusApi mplusApi) {
        this.mplusApi = mplusApi;
    }

    public CAPDownloadBaseManager getCapDownloadBaseManager() {
        return this.capDownloadBaseManager;
    }

    public void setCapDownloadBaseManager(CAPDownloadBaseManager capDownloadBaseManager) {
        this.capDownloadBaseManager = capDownloadBaseManager;
    }

    public void setPrivilegeMenuManager(PrivilegeMenuManager privilegeMenuManager) {
        this.privilegeMenuManager = privilegeMenuManager;
    }

    public void setPortalApi(PortalApi portalApi) {
        this.portalApi = portalApi;
    }
}

