/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.index;

import com.seeyon.apps.index.api.IndexApi;
import com.seeyon.apps.index.bo.IndexInfo;
import com.seeyon.cap4.form.bean.FormAuthViewBean;
import com.seeyon.cap4.form.bean.FormAuthViewFieldBean;
import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormBindAuthBean;
import com.seeyon.cap4.form.bean.FormDataMasterBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.SimpleObjectBean;
import com.seeyon.cap4.form.service.CAP4FormCacheManager;
import com.seeyon.cap4.form.service.CAP4FormManager;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.form.util.FormUtil;
import com.seeyon.ctp.cap.api.manager.CAPFormManager;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.ModuleType;
import com.seeyon.ctp.common.authenticate.domain.User;
import com.seeyon.ctp.common.constants.ApplicationCategoryEnum;
import com.seeyon.ctp.common.constants.Constants;
import com.seeyon.ctp.common.content.mainbody.MainbodyManager;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.filemanager.manager.AttachmentManager;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.common.po.content.CtpContentAll;
import com.seeyon.ctp.form.modules.index.FormIndex4UnFlow;
import com.seeyon.ctp.form.modules.index.FormIndexModuleType;
import com.seeyon.ctp.organization.bo.V3xOrgMember;
import com.seeyon.ctp.organization.manager.OrgManager;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.Strings;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;

public class UnflowFormIndex
implements FormIndexModuleType {
    private static final Log log = CtpLogFactory.getLog(UnflowFormIndex.class);
    private AttachmentManager attachmentManager;
    private CAP4FormCacheManager cap4FormCacheManager;
    private CAP4FormManager cap4FormManager;
    private OrgManager orgManager;
    private IndexApi indexApi;
    private CAPFormManager capFormManager;

    public void setCapFormManager(CAPFormManager capFormManager) {
        this.capFormManager = capFormManager;
    }

    public OrgManager getOrgManager() {
        return this.orgManager;
    }

    public void setOrgManager(OrgManager orgManager) {
        this.orgManager = orgManager;
    }

    public AttachmentManager getAttachmentManager() {
        return this.attachmentManager;
    }

    public void setAttachmentManager(AttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
    }

    public CAP4FormCacheManager getCap4FormCacheManager() {
        return this.cap4FormCacheManager;
    }

    public void setCap4FormCacheManager(CAP4FormCacheManager cap4FormCacheManager) {
        this.cap4FormCacheManager = cap4FormCacheManager;
    }

    public CAP4FormManager getCap4FormManager() {
        return this.cap4FormManager;
    }

    public void setCap4FormManager(CAP4FormManager cap4FormManager) {
        this.cap4FormManager = cap4FormManager;
    }

    public void setIndexApi(IndexApi indexApi) {
        this.indexApi = indexApi;
    }

    public Integer getModuleType() {
        return ModuleType.cap4UnflowForm.getKey();
    }

    public IndexInfo getIndexInfo(Long id, ModuleType type) throws BusinessException {
        if (id == null || type == null) {
            log.error((Object)("\u65e0\u6d41\u7a0b\u5168\u6587\u68c0\u7d22\u5165\u5e93\u5f02\u5e38\uff0c\u4f20\u5165\u53c2\u6570\u4e3aid:" + id));
            throw new BusinessException((Throwable)new NullPointerException());
        }
        IndexInfo info = new IndexInfo();
        info.setEntityID(id.longValue());
        info.setAppType(ApplicationCategoryEnum.form);
        info.setContent(this.getFormContent(id, type, info));
        info.addExtendProperties("formType", "cap4UnflowForm", IndexInfo.FieldIndex_Type.IndexNo.ordinal());
        return info;
    }

    private String getFormContent(Long id, ModuleType type, IndexInfo info) throws BusinessException {
        if (id == null) {
            return "";
        }
        CtpContentAll contentAll = this.getContentAllByModuleTypeAndModuleId(id, type);
        Long formId = contentAll.getContentTemplateId();
        FormBean formBean = this.cap4FormCacheManager.getForm(formId);
        return this.getFormContentFromDataBean(formBean, id, id, info, type);
    }

    private CtpContentAll getContentAllByModuleTypeAndModuleId(Long id, ModuleType type) {
        MainbodyManager contentManager = (MainbodyManager)AppContext.getBean((String)"ctpMainbodyManager");
        List contentAllList = contentManager.getContentListByModuleIdAndModuleType(type, id);
        CtpContentAll contentAll = (CtpContentAll)contentAllList.get(0);
        return contentAll;
    }

    public String getFormContentFromDataBean(FormBean formBean, Long masterId, Long moduleId, IndexInfo info, ModuleType type) throws BusinessException {
        HashSet<String> hiddenFormFields = new HashSet<String>();
        List formAuthViewBeanList = formBean.getAllFormAuthViewBeans();
        if (formAuthViewBeanList != null) {
            for (FormAuthViewBean formAuthViewBean : formAuthViewBeanList) {
                List FormAuthList = formAuthViewBean.getFormAuthorizationFieldList();
                for (FormAuthViewFieldBean formAuthViewFieldBean : FormAuthList) {
                    if (!Enums.FieldAccessType.hide.getKey().equals(formAuthViewFieldBean.getAccess())) continue;
                    hiddenFormFields.add(formAuthViewFieldBean.getFieldName());
                }
            }
        }
        FormDataMasterBean formDataMasterBean = null;
        try {
            if (AppContext.getCurrentUser() == null) {
                User u = new User();
                u.setId(Long.valueOf(0L));
                u.setAccountId(Long.valueOf(0L));
                AppContext.putThreadContext((String)"SESSION_CONTEXT_USERINFO_KEY", (Object)u);
            } else if (AppContext.getCurrentUser().getLoginAccount() == null) {
                AppContext.getCurrentUser().setLoginAccount(Long.valueOf(0L));
            }
            formDataMasterBean = this.cap4FormManager.getDataMasterBeanById(masterId, formBean, null);
        }
        catch (SQLException e) {
            log.info((Object)"\u67e5\u8be2\u51fa\u9519!", (Throwable)e);
        }
        StringBuilder str = new StringBuilder();
        if (formDataMasterBean != null) {
            Map dataMap;
            if (info != null) {
                info.setStartMemberId(Long.valueOf(formDataMasterBean.getStartMemberId()));
                info.setHasAttachment(false);
                V3xOrgMember member = null;
                try {
                    member = (V3xOrgMember)this.orgManager.getEntityById(V3xOrgMember.class, Long.valueOf(formDataMasterBean.getStartMemberId()));
                }
                catch (BusinessException e) {
                    log.info((Object)("\u65e0\u6d41\u7a0b\u5168\u6587\u68c0\u7d22\u5165\u5e93\u67e5\u627e\u53d1\u8d77\u4eba\u51fa\u73b0\u5f02\u5e38,id:" + formDataMasterBean.getStartMemberId()));
                    throw new BusinessException("\u65e0\u6d41\u7a0b\u5168\u6587\u68c0\u7d22\u5165\u5e93\u67e5\u627e\u53d1\u8d77\u4eba\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
                }
                info.setAuthor(member.getName());
                StringBuilder sb = new StringBuilder();
                FormBindAuthBean formBindAuthBean = this.getFormBind(formBean, masterId, type, false);
                if (formBindAuthBean != null) {
                    sb.append(formBindAuthBean.getName());
                } else {
                    sb.append(formBean.getFormName());
                }
                sb.append(" ").append(ResourceUtil.getString((String)"index.com.seeyon.v3x.index.createUser")).append("\uff1a").append(member.getName());
                sb.append(" ").append(ResourceUtil.getString((String)"index.com.seeyon.v3x.index.createDate")).append("\uff1a").append(DateUtil.getDate((Date)formDataMasterBean.getStartDate(), (String)"yyyy-MM-dd HH:mm:ss")).append(" ");
                sb.append(ResourceUtil.getString((String)"cap4.form.business.common.index.updatetime")).append("\uff1a").append(DateUtil.getDate((Date)formDataMasterBean.getModifyDate(), (String)"yyyy-MM-dd HH:mm:ss"));
                info.setTitle(sb.toString());
                info.setAuthorizationInfo(this.cap4FormManager.getAuthByFormBean(formBean));
                Date createDate = new Date(formDataMasterBean.getStartDate().getTime());
                info.setCreateDate(createDate);
                this.indexApi.convertToAccessory(info);
            }
            if ((dataMap = formDataMasterBean.getAllDataMap()) != null) {
                for (String key : dataMap.keySet()) {
                    Object obj = dataMap.get(key);
                    FormFieldBean formFieldBean = formBean.getFieldBeanByName(key);
                    if (formFieldBean == null || hiddenFormFields.contains(key)) continue;
                    String display = formFieldBean.getDisplay();
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("formFieldBean", formFieldBean);
                    params.put("reference", moduleId);
                    params.put("value", obj);
                    if (obj != null && obj instanceof List) {
                        List subList = (List)obj;
                        for (Object o : subList) {
                            params.put("value", o);
                            String disPlayValue = this.convertDisplayForSomeType(params);
                            if (!Strings.isNotBlank((String)disPlayValue)) continue;
                            str.append(display).append(":").append(disPlayValue).append(" ");
                        }
                        continue;
                    }
                    String disPlayValue = this.convertDisplayForSomeType(params);
                    if (!Strings.isNotBlank((String)disPlayValue)) continue;
                    str.append(display).append(":").append(disPlayValue).append(" ");
                }
            }
        }
        return str.toString();
    }

    private String convertDisplayForSomeType(Map<String, Object> params) {
        FormFieldBean formFieldBean = (FormFieldBean)params.get("formFieldBean");
        try {
            Object value = params.get("value");
            if (value == null || "".equals(value)) {
                return null;
            }
            return formFieldBean.getFieldCtrl().convertVal4Index(params);
        }
        catch (Exception e) {
            log.error((Object)("\u83b7\u53d6" + formFieldBean.getDisplay() + "\u8868\u5355\u5b57\u6bb5\u5b9e\u9645\u503c\u51fa\u9519!"), (Throwable)e);
            return null;
        }
    }

    public FormBindAuthBean getFormBind(FormBean formBean, Long masterId, ModuleType type, boolean needFindOther) throws BusinessException {
        MainbodyManager contentManager = (MainbodyManager)AppContext.getBean((String)"ctpMainbodyManager");
        List contentAllList = contentManager.getContentListByModuleIdAndModuleType(type, masterId);
        CtpContentAll contentAll = (CtpContentAll)contentAllList.get(0);
        CtpContentAll moduleContent = contentManager.getContentById(contentAll.getModuleTemplateId());
        FormBindAuthBean bindAuthBean = null;
        if (moduleContent != null) {
            bindAuthBean = formBean.getBind().getFormBindAuthBean(String.valueOf(moduleContent.getModuleId()));
        }
        if (bindAuthBean == null && needFindOther) {
            Map unFlowTemplateMap = formBean.getBind().getUnFlowTemplateMap();
            for (Map.Entry tempBind : unFlowTemplateMap.entrySet()) {
                if (!((FormBindAuthBean)tempBind.getValue()).checkRight(AppContext.currentUserId())) continue;
                bindAuthBean = (FormBindAuthBean)tempBind.getValue();
                break;
            }
        }
        return bindAuthBean;
    }

    public Integer findIndexResumeCount(Date starDate, Date endDate) throws BusinessException {
        return null;
    }

    public List<Long> findIndexResumeIDList(Date starDate, Date endDate, Integer firstRow, Integer pageSize) throws BusinessException {
        return null;
    }

    public Map<String, Object> findSourceInfo(Long id) throws BusinessException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        FormIndex4UnFlow formIndex4UnFlow = (FormIndex4UnFlow)AppContext.getBean((String)"formIndex4UnFlow");
        Map map = formIndex4UnFlow.findFormIndexModuleType(id, false);
        if (map.get("moduleType") == null) {
            return resultMap;
        }
        int type = (Integer)map.get("moduleType");
        ModuleType moduleType = ModuleType.getEnumByKey((int)type);
        CtpContentAll contentAll = this.getContentAllByModuleTypeAndModuleId(id, moduleType);
        if (contentAll != null) {
            Long formId = contentAll.getContentTemplateId();
            FormBean formBean = this.cap4FormCacheManager.getForm(formId);
            FormBindAuthBean formBindAuthBean = this.getFormBind(formBean, id, moduleType, true);
            Long rightId = 0L;
            if (formBindAuthBean == null) {
                resultMap.put("rightId", rightId);
                resultMap.put("moduleType", moduleType);
                resultMap.put("sourceId", id + "|" + moduleType.getKey() + "|" + rightId);
                return resultMap;
            }
            boolean isMbLogin = Constants.login_sign.pc.value() != AppContext.getCurrentUser().getLoginSign() && Constants.login_sign.ucpc.value() != AppContext.getCurrentUser().getLoginSign();
            String rightIdStr = "";
            SimpleObjectBean simpleObjectBean = formBindAuthBean.getAuthObjByName(FormBindAuthBean.AuthName.BROWSE.getKey());
            if (isMbLogin) {
                String[] mbRights;
                String[] pcRights;
                String pcRight = Strings.join(Arrays.asList(simpleObjectBean.getValue().split("[|]")), (String)"_");
                for (String r : pcRights = FormUtil.paraseOperationIds((String)simpleObjectBean.getValue())) {
                    this.capFormManager.addRightId(Long.valueOf(Long.parseLong(r)));
                }
                String mbRight = Strings.join(Arrays.asList(simpleObjectBean.getPhoneValue().split("[|]")), (String)"_");
                for (String r : mbRights = FormUtil.paraseOperationIds((String)simpleObjectBean.getPhoneValue())) {
                    this.capFormManager.addRightId(Long.valueOf(Long.parseLong(r)));
                }
                resultMap.put("rightId", mbRight + "_" + pcRight);
            } else {
                rightIdStr = formBindAuthBean.getShowFormAuth();
                if (!Strings.isBlank((String)rightIdStr)) {
                    if (rightIdStr.contains("|")) {
                        String[] str = rightIdStr.split("[|]");
                        if ((rightIdStr = str[0]).contains(".")) {
                            String[] ids = rightIdStr.split("[.]");
                            rightId = Long.valueOf(ids[1]);
                        }
                    } else if (rightIdStr.contains(".")) {
                        String[] ids = rightIdStr.split("[.]");
                        rightId = Long.valueOf(ids[1]);
                    }
                }
                resultMap.put("rightId", rightId);
                this.capFormManager.addRightId(rightId);
            }
            resultMap.put("moduleType", moduleType);
            resultMap.put("sourceId", id + "|" + moduleType.getKey() + "|" + rightId);
            resultMap.put("formId", formBean.getId());
        }
        return resultMap;
    }

    public boolean isShowIndexSummary() throws BusinessException {
        return false;
    }
}

