/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.log;

import com.seeyon.cap4.form.modules.log.CapLogDAO;
import com.seeyon.cap4.form.po.CapRunningLog;
import com.seeyon.cap4.form.po.CapSettingLog;
import com.seeyon.ctp.common.AppContext;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.report.utils.ReportDBUtils;
import com.seeyon.ctp.util.DBAgent;
import com.seeyon.ctp.util.Datetimes;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.JDBCAgent;
import com.seeyon.ctp.util.Strings;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;

public class CapLogDAOImpl
implements CapLogDAO {
    private static final Log logger = CtpLogFactory.getLog(CapLogDAOImpl.class);

    @Override
    public void saveRunningLog(CapRunningLog log) throws BusinessException {
        DBAgent.save((Object)((Object)log));
    }

    @Override
    public void saveAllRunningLog(List<CapRunningLog> list) throws BusinessException {
        DBAgent.saveAll(list);
    }

    @Override
    public void saveSettingLog(CapSettingLog log) throws BusinessException {
        DBAgent.save((Object)((Object)log));
    }

    @Override
    public void saveAllSettingLog(List<CapSettingLog> list) throws BusinessException {
        DBAgent.saveAll(list);
    }

    @Override
    public List<Map<String, Object>> selectRunningLogByFlipInfo(FlipInfo fi, Map<String, Object> params) throws BusinessException, ParseException {
        HashMap<String, Object> p = new HashMap<String, Object>();
        StringBuilder sql = new StringBuilder();
        if (params.get("formId") != null && !"".equals(params.get("formId").toString()) && 0L != Long.valueOf(params.get("formId").toString())) {
            sql.append("SELECT new map(cr.id as id, cr.bizName as bizName, cr.formName as formName, cr.operateType as operateType, ");
            sql.append("cr.operator as operator, cr.operateDate as operateDate, cr.operatorOrgName as operatorOrgName, cr.creator as creator, ");
            sql.append("cr.createDate as createDate, cr.description as description, cr.ipAddress as ipAddress) FROM CapRunningLog cr WHERE 1=1 ");
            sql.append(this.getConditionSql(p, params));
            sql.append(" ORDER BY cr.operateDate DESC ");
        } else {
            sql.append("SELECT new map(cr.id as id, cr.bizName as bizName, cr.formName as formName, cr.operateType as operateType, ");
            sql.append("cr.operator as operator, cr.operateDate as operateDate, cr.operatorOrgName as operatorOrgName, cr.creator as creator, ");
            sql.append("cr.createDate as createDate, cr.description as description, cr.ipAddress as ipAddress) FROM CapRunningLog cr, CapBizConfig cb ");
            sql.append("WHERE cb.id = cr.bizId and cb.ownerId = :ownerId");
            sql.append(this.getConditionSql(p, params));
            sql.append(" ORDER BY cr.operateDate DESC ");
            sql.append(" UNION ");
            sql.append("SELECT new map(cr.id as id, cr.bizName as bizName, cr.formName as formName, cr.operateType as operateType, ");
            sql.append("cr.operator as operator, cr.operateDate as operateDate, cr.operatorOrgName as operatorOrgName, cr.creator as creator, ");
            sql.append("cr.createDate as createDate, cr.description as description, cr.ipAddress as ipAddress) FROM CapRunningLog cr, FormOwner fo ");
            sql.append("WHERE cr.formId = fo.formId ");
            sql.append(" AND cr.formId not in (select ccf.formId from CapBizConfigItem ccf )");
            sql.append(" AND fo.ownerId = :ownerId");
            sql.append(this.getConditionSql(p, params));
            sql.append(" ORDER BY cr.operateDate DESC ");
            p.put("ownerId", AppContext.currentUserId());
        }
        if (params.get("findAll") != null) {
            return DBAgent.find((String)sql.toString(), p);
        }
        return DBAgent.find((String)sql.toString(), p, (FlipInfo)fi);
    }

    @Override
    public List<Map<String, Object>> selectSettingLogByFlipInfo(FlipInfo fi, Map<String, Object> params) throws BusinessException, ParseException {
        HashMap<String, Object> p = new HashMap<String, Object>();
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT new map(cr.id as id, cr.bizName as bizName, cr.resourceName as resourceName, cr.operateType as operateType, ");
        sql.append("cr.operator as operator, cr.operateDate as operateDate, cr.operatorOrgName as operatorOrgName, cr.creator as creator, ");
        sql.append("cr.createDate as createDate, cr.description as description, cr.ipAddress as ipAddress) FROM CapSettingLog cr, CapBizConfig cb ");
        sql.append("WHERE cb.id = cr.bizId and cb.ownerId = :ownerId");
        sql.append(this.getConditionSql(p, params));
        sql.append(" ORDER BY cr.operateDate DESC ");
        sql.append(" UNION ");
        sql.append("SELECT new map(cr.id as id, cr.bizName as bizName, cr.resourceName as resourceName, cr.operateType as operateType, ");
        sql.append("cr.operator as operator, cr.operateDate as operateDate, cr.operatorOrgName as operatorOrgName, cr.creator as creator, ");
        sql.append("cr.createDate as createDate, cr.description as description, cr.ipAddress as ipAddress) FROM CapSettingLog cr, FormOwner fo ");
        sql.append("WHERE cr.resourceId = fo.formId ");
        sql.append(" AND cr.resourceId not in (select ccf.formId from CapBizConfigItem ccf )");
        sql.append(" AND fo.ownerId = :ownerId");
        sql.append(this.getConditionSql(p, params));
        sql.append(" ORDER BY cr.operateDate DESC ");
        p.put("ownerId", AppContext.currentUserId());
        if (params.get("findAll") != null) {
            return DBAgent.find((String)sql.toString(), p);
        }
        return DBAgent.find((String)sql.toString(), p, (FlipInfo)fi);
    }

    private String getConditionSql(Map<String, Object> sqlParam, Map<String, Object> params) {
        StringBuilder sql = new StringBuilder();
        if (params != null) {
            for (Map.Entry<String, Object> map : params.entrySet()) {
                int i;
                String[] descArr;
                String key = map.getKey();
                ArrayList<Long> pValue = map.getValue();
                if ("findAll".equals(key) || "bizId".equals(key) || pValue == null || Strings.isBlank((String)String.valueOf(pValue))) continue;
                sql.append(" AND ");
                if ("beginoperatime".equals(key)) {
                    if (ReportDBUtils.isSQLServerRuntime()) {
                        sql.append("DATEDIFF(Mi, cr.").append("operateDate").append(", CONVERT(datetime, :").append(key).append(",120)) <= 0");
                    } else {
                        sql.append(this.getDateSql("operateDate", "cr.")).append(" >= :").append(key).append(" ");
                    }
                } else if ("endoperatime".equals(key)) {
                    if (ReportDBUtils.isSQLServerRuntime()) {
                        sql.append("DATEDIFF(Mi, cr.").append("operateDate").append(", CONVERT(datetime, :").append(key).append(",120)) >= 0");
                    } else {
                        sql.append(this.getDateSql("operateDate", "cr.")).append(" <= :").append(key).append(" ");
                    }
                } else if ("begincreatetime".equals(key)) {
                    if (ReportDBUtils.isSQLServerRuntime()) {
                        sql.append("DATEDIFF(Mi, cr.").append("createDate").append(", CONVERT(datetime, :").append(key).append(",120)) <= 0");
                    } else {
                        sql.append(this.getDateSql("createDate", "cr.")).append(" >= :").append(key).append(" ");
                    }
                } else if ("endcreatetime".equals(key)) {
                    if (ReportDBUtils.isSQLServerRuntime()) {
                        sql.append("DATEDIFF(Mi, cr.").append("createDate").append(", CONVERT(datetime, :").append(key).append(",120)) >= 0");
                    } else {
                        sql.append(this.getDateSql("createDate", "cr.")).append(" <= :").append(key).append(" ");
                    }
                } else if ("creator".equals(key) || "operator".equals(key)) {
                    sql.append("cr.").append(key).append(" IN (:").append(key).append(") ");
                } else if ("description".equals(key)) {
                    descArr = ((Object)pValue).toString().split(" ");
                    sql.append("(");
                    for (i = 0; i < descArr.length; ++i) {
                        sql.append(" cr.description like :").append(key).append(i).append(" OR");
                    }
                    sql.append(" 1<>1 )");
                } else if ("bizName".equals(key)) {
                    sql.append(" cr.bizName like :").append(key).append(" ");
                    pValue = "%" + pValue + "%";
                } else {
                    sql.append("cr.").append(key).append(" = :").append(key).append(" ");
                }
                if ("description".equals(key)) {
                    descArr = ((Object)pValue).toString().split(" ");
                    for (i = 0; i < descArr.length; ++i) {
                        sqlParam.put(key + i, "%" + descArr[i] + "%");
                    }
                    continue;
                }
                if ("formId".equals(key) || "recordId".equals(key)) {
                    pValue = Long.parseLong(pValue + "");
                } else if ("creator".equals(key) || "operator".equals(key)) {
                    String[] temp;
                    ArrayList<Long> list = new ArrayList<Long>();
                    for (String t : temp = ((Object)pValue).toString().split(",")) {
                        String[] ta = t.split("\\|");
                        list.add(Long.parseLong(ta.length > 1 ? ta[1] : ta[0]));
                    }
                    pValue = list;
                } else if ("operateType".equals(key)) {
                    pValue = Integer.parseInt(String.valueOf(pValue));
                }
                sqlParam.put(key, pValue);
            }
        }
        return sql.toString();
    }

    private String getDateSql(String fieldName, String prefix) {
        StringBuilder sql = new StringBuilder();
        if (ReportDBUtils.isOracleRuntime() || ReportDBUtils.isDMSQLRuntime() || JDBCAgent.isKingBaseesRunTime()) {
            sql.append("TO_CHAR(").append(prefix).append(fieldName).append(",'yyyy-MM-dd hh24:mi')");
        } else if (!ReportDBUtils.isSQLServerRuntime()) {
            if (ReportDBUtils.isPostgreSQLRuntime()) {
                sql.append("TO_CHAR(").append(prefix).append(fieldName).append(",'YYYY-MM-DD HH24:MI')");
            } else {
                sql.append("DATE_FORMAT(").append(prefix).append(fieldName).append(",'%Y-%m-%d %H:%i')");
            }
        }
        return sql.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteByFormId(Long formId) throws BusinessException {
        StringBuilder sql = new StringBuilder();
        sql.append("delete from cap_running_log where form_id = ").append(formId);
        JDBCAgent jdbc = null;
        try {
            jdbc = new JDBCAgent();
            logger.warn((Object)("\u5220\u9664\u8868\u5355\u8fd0\u884c\u65e5\u5fd7" + formId));
            jdbc.execute(sql.toString());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (jdbc != null) {
                jdbc.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteByRecordId(Long recordId) throws BusinessException {
        StringBuilder sql = new StringBuilder();
        sql.append("delete from cap_running_log where record_id = ").append(recordId);
        JDBCAgent jdbc = null;
        try {
            jdbc = new JDBCAgent();
            logger.warn((Object)("\u5220\u9664\u8868\u5355\u8fd0\u884c\u65e5\u5fd7" + recordId));
            jdbc.execute(sql.toString());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            if (jdbc != null) {
                jdbc.close();
            }
        }
    }

    @Override
    public void deleteByDateString(Date date) throws BusinessException {
        String sql = "DELETE FROM CAP_RUNNING_LOG WHERE CREATE_DATE < " + this.getDateSql();
        JDBCAgent jdbcAgent = null;
        try {
            jdbcAgent = new JDBCAgent(false, false);
            jdbcAgent.execute(sql, (Object)Datetimes.format((Date)date, (String)"yyyy-MM-dd HH:mm:ss"));
        }
        catch (Exception e) {
            throw new BusinessException((Throwable)e);
        }
        finally {
            if (jdbcAgent != null) {
                jdbcAgent.close();
            }
        }
    }

    private String getDateSql() {
        String sql = "";
        sql = ReportDBUtils.isOracleRuntime() || ReportDBUtils.isPostgreSQLRuntime() ? "to_char(' ? ,yyyy-mm-dd hh24:mi')" : (ReportDBUtils.isSQLServerRuntime() ? "convert(nvarchar(255), ? ,120)" : "DATE_FORMAT( ? ,'%Y-%m-%d %H:%i:%s')");
        return sql;
    }
}

