/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.log;

import com.seeyon.cap4.form.bean.FormBean;
import com.seeyon.cap4.form.bean.FormDataMasterBean;
import com.seeyon.cap4.form.bean.FormDataSubBean;
import com.seeyon.cap4.form.bean.FormFieldBean;
import com.seeyon.cap4.form.bean.FormFieldComEnum;
import com.seeyon.cap4.form.bean.FormTableBean;
import com.seeyon.cap4.form.modules.engin.base.formData.CAP4FormDataDAO;
import com.seeyon.cap4.form.modules.engin.formula.FormulaFunction;
import com.seeyon.cap4.form.modules.log.CapLogDAO;
import com.seeyon.cap4.form.modules.log.CapRunningLogManager;
import com.seeyon.cap4.form.po.CapRunningLog;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.cap4.form.util.FormLogUtil;
import com.seeyon.ctp.common.content.mainbody.MainbodyStatus;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.organization.bo.V3xOrgMember;
import com.seeyon.ctp.organization.manager.OrgManager;
import com.seeyon.ctp.util.DBAgent;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDLong;
import com.seeyon.ctp.util.annotation.AjaxAccess;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;

public class CapRunningLogManagerImpl
implements CapRunningLogManager {
    private static final Log LOGGER = CtpLogFactory.getLog(CapRunningLogManagerImpl.class);
    private CapLogDAO capLogDAO;
    private CAP4FormDataDAO cap4FormDataDAO;
    private OrgManager orgManager;

    @Override
    @AjaxAccess
    public FlipInfo getRunningLogList(FlipInfo fi, Map<String, Object> params) throws BusinessException, ParseException {
        try {
            Long singleStart = System.currentTimeMillis();
            List<Map<String, Object>> runningLogs = this.capLogDAO.selectRunningLogByFlipInfo(fi, params);
            Long singleEnd = System.currentTimeMillis();
            LOGGER.info((Object)(" \u67e5\u8be2\u8017\u65f6:" + (singleEnd - singleStart)));
            singleStart = System.currentTimeMillis();
            ArrayList data = new ArrayList();
            for (Map<String, Object> log : runningLogs) {
                V3xOrgMember member;
                HashMap<String, Object> hm = new HashMap<String, Object>();
                hm.put("id", log.get("id"));
                hm.put("operatedate", log.get("operateDate"));
                hm.put("createtime", log.get("createDate"));
                hm.put("operatetype", Enums.CapLogType.getLogTypeByKey((int)((Integer)log.get("operateType"))).getText());
                hm.put("ipAddress", log.get("ipAddress"));
                hm.put("bizName", log.get("bizName"));
                hm.put("operatorOrgName", log.get("operatorOrgName"));
                hm.put("formName", log.get("formName"));
                hm.put("creator", "");
                hm.put("operator", "");
                if ((Long)log.get("operator") == 0L) {
                    hm.put("operator", ResourceUtil.getString((String)"form.trigger.triggerSet.unflow.log.system"));
                } else {
                    member = this.orgManager.getMemberById((Long)log.get("operator"));
                    if (member != null) {
                        hm.put("operator", member.getName());
                    }
                }
                member = this.orgManager.getMemberById((Long)log.get("creator"));
                if (member != null) {
                    hm.put("creator", member.getName());
                }
                hm.put("description", "");
                String desc = log.get("description").toString();
                if (Strings.isNotBlank((String)desc)) {
                    if (desc.length() >= 1024) {
                        hm.put("description", desc.trim().substring(0, 1024));
                    } else {
                        hm.put("description", desc.trim());
                    }
                }
                data.add(hm);
            }
            fi.setData(data);
            singleEnd = System.currentTimeMillis();
            LOGGER.info((Object)(" \u8017\u65f6:" + (singleEnd - singleStart)));
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new BusinessException("\u67e5\u8be2\u5f02\u5e38");
        }
        return fi;
    }

    @Override
    public void saveRunningLog(CapRunningLog log) throws BusinessException {
        this.capLogDAO.saveRunningLog(log);
    }

    @Override
    public void saveRunningLog(List<CapRunningLog> logList) throws BusinessException {
        this.capLogDAO.saveAllRunningLog(logList);
    }

    @Override
    public void saveRunningLog(Long bizId, String bizName, Long formId, String formName, Long dataId, int operateType, String desc, Long operator, Long creator, Date createDate, String operatorOrgName, String ipAddress) throws BusinessException {
        CapRunningLog log = new CapRunningLog();
        log.setId(UUIDLong.longUUID());
        log.setBizId(bizId);
        log.setBizName(bizName);
        log.setFormId(formId);
        log.setFormName(formName);
        log.setRecordId(dataId);
        log.setOperateType(operateType);
        log.setOperateDate(DateUtil.currentDate());
        log.setOperator(operator);
        log.setOperatorOrgName(operatorOrgName);
        log.setCreator(creator);
        log.setCreateDate(createDate);
        log.setIpAddress(ipAddress);
        if (Strings.isNotEmpty((String)desc)) {
            int allowLen = 1333;
            if (allowLen >= desc.length()) {
                log.setDescription(desc);
            } else {
                log.setDescription(desc.substring(0, allowLen));
            }
        }
        this.capLogDAO.saveRunningLog(log);
    }

    @Override
    public String getDataLog(FormBean fb, FormDataMasterBean dataBean, MainbodyStatus status) throws BusinessException {
        return this.getDataLog(fb, dataBean, status, null);
    }

    @Override
    public String getDataLog(FormBean fb, FormDataMasterBean dataBean, MainbodyStatus status, FormDataMasterBean oldDataBean) throws BusinessException {
        return this.getDataLog(fb, dataBean, status, oldDataBean, null);
    }

    @Override
    public String getDataLog(FormBean fb, FormDataMasterBean dataBean, MainbodyStatus status, FormDataMasterBean oldDataBean, List<String> changeFieldList) throws BusinessException {
        List logFieldList = fb.isFlowForm() ? changeFieldList : fb.getBind().getLogFieldList();
        if (Strings.isEmpty((Collection)logFieldList)) {
            return "";
        }
        String logFieldLogs = "";
        if (status == MainbodyStatus.STATUS_POST_SAVE) {
            logFieldLogs = this.mergeLog4Insert(fb, dataBean, logFieldList);
        } else if (status == MainbodyStatus.STATUS_POST_UPDATE) {
            if (oldDataBean == null) {
                try {
                    oldDataBean = this.cap4FormDataDAO.selectDataByMasterId(dataBean.getId(), fb, null);
                }
                catch (SQLException e) {
                    throw new BusinessException((Throwable)e);
                }
            }
            logFieldLogs = this.mergeLog4Update(fb, dataBean, oldDataBean, logFieldList);
        }
        return logFieldLogs;
    }

    private String mergeLog4Insert(FormBean fb, FormDataMasterBean masterData, List<String> logFieldList) throws BusinessException {
        StringBuilder sb = new StringBuilder();
        LinkedHashMap<String, ArrayList<String>> subLogFieldMap = new LinkedHashMap<String, ArrayList<String>>();
        for (String logField : logFieldList) {
            String fieldName = logField.contains(".") ? logField.substring(logField.indexOf(".") + 1) : logField;
            FormFieldBean ffb = fb.getFieldBeanByName(fieldName);
            if (ffb.isMasterField()) {
                sb.append(FormLogUtil.getFieldLogDesc(ffb, null, masterData.getFieldValue(fieldName), Enums.CapLogType.INSERT));
                continue;
            }
            String subTable = ffb.getOwnerTableName();
            ArrayList<String> subLogFieldList = (ArrayList<String>)subLogFieldMap.get(subTable);
            if (subLogFieldList == null) {
                subLogFieldList = new ArrayList<String>();
                subLogFieldMap.put(subTable, subLogFieldList);
            }
            subLogFieldList.add(fieldName);
        }
        for (Map.Entry entry : subLogFieldMap.entrySet()) {
            String subTableName = (String)entry.getKey();
            List subLogFieldList = (List)subLogFieldMap.get(subTableName);
            List subBeans = masterData.getSubData(subTableName);
            String insertLog = this.mergeSubBeanLog(fb, subTableName, subBeans, Enums.CapLogType.INSERT, subLogFieldList);
            sb.append(insertLog);
        }
        return sb.toString();
    }

    private String mergeLog4Update(FormBean fb, FormDataMasterBean dataBean, FormDataMasterBean oldDataBean, List<String> logFieldList) throws BusinessException {
        StringBuilder sb = new StringBuilder();
        LinkedHashMap<String, ArrayList<String>> subLogFieldMap = new LinkedHashMap<String, ArrayList<String>>();
        for (String logField : logFieldList) {
            String fieldName = logField.contains(".") ? logField.substring(logField.indexOf(".") + 1) : logField;
            FormFieldBean ffb = fb.getFieldBeanByName(fieldName);
            if (ffb.isMasterField()) {
                sb.append(this.getFieldModifyLog(ffb, oldDataBean.getFieldValue(fieldName), dataBean.getFieldValue(fieldName)));
                continue;
            }
            String subTable = ffb.getOwnerTableName();
            ArrayList<String> subLogFieldList = (ArrayList<String>)subLogFieldMap.get(subTable);
            if (subLogFieldList == null) {
                subLogFieldList = new ArrayList<String>();
                subLogFieldMap.put(subTable, subLogFieldList);
            }
            subLogFieldList.add(fieldName);
        }
        Map subBeanMap = dataBean.getSubTables();
        for (Map.Entry entry : subBeanMap.entrySet()) {
            FormFieldBean ffb;
            FormDataSubBean newSubBean;
            String subTableName = (String)entry.getKey();
            List subLogFieldList = (List)subLogFieldMap.get(subTableName);
            if (Strings.isEmpty((Collection)subLogFieldList)) continue;
            FormTableBean subTable = fb.getTableByTableName(subTableName);
            List subBeans = (List)entry.getValue();
            List oldSubBeans = oldDataBean.getSubData(subTableName);
            if (Strings.isNotEmpty((Collection)subBeans) && Strings.isEmpty((Collection)oldSubBeans)) {
                String delLog = this.mergeSubBeanLog(fb, subTableName, oldSubBeans, Enums.CapLogType.DELETE, subLogFieldList);
                sb.append(delLog);
                continue;
            }
            if (Strings.isEmpty((Collection)subBeans) && Strings.isNotEmpty((Collection)oldSubBeans)) {
                String insertLog = this.mergeSubBeanLog(fb, subTableName, subBeans, Enums.CapLogType.INSERT, subLogFieldList);
                sb.append(insertLog);
                continue;
            }
            if (!Strings.isNotEmpty((Collection)subBeans) || !Strings.isNotEmpty((Collection)oldSubBeans)) continue;
            LinkedHashMap<Long, FormDataSubBean> newSubBeanMap = new LinkedHashMap<Long, FormDataSubBean>();
            for (FormDataSubBean newSubBean2 : subBeans) {
                newSubBeanMap.put(newSubBean2.getId(), newSubBean2);
            }
            StringBuilder subLogSb = new StringBuilder();
            int k = -1;
            for (FormDataSubBean subBean : oldSubBeans) {
                ++k;
                newSubBean = (FormDataSubBean)newSubBeanMap.get(subBean.getId());
                if (newSubBean != null) {
                    String modifyPrefix = FormLogUtil.getSlaveLogPrefix(subTable.getDisplay(), k + 1, Enums.CapLogType.MODIFY);
                    StringBuilder modifyLogsSb = new StringBuilder();
                    for (String fieldName : subLogFieldList) {
                        ffb = fb.getFieldBeanByName(fieldName);
                        modifyLogsSb.append(this.getFieldModifyLog(ffb, subBean.getFieldValue(fieldName), newSubBean.getFieldValue(fieldName)));
                    }
                    if (Strings.isNotBlank((String)modifyLogsSb.toString())) {
                        subLogSb.append(modifyPrefix).append((CharSequence)modifyLogsSb);
                    }
                } else {
                    String deletePrefix = FormLogUtil.getSlaveLogPrefix(subTable.getDisplay(), k + 1, Enums.CapLogType.DELETE);
                    StringBuilder delLogSb = new StringBuilder(deletePrefix);
                    for (String fieldName : subLogFieldList) {
                        ffb = fb.getFieldBeanByName(fieldName);
                        delLogSb.append(FormLogUtil.getFieldLogDesc(ffb, subBean.getFieldValue(fieldName), null, Enums.CapLogType.DELETE));
                    }
                    subLogSb.append((CharSequence)delLogSb);
                }
                newSubBeanMap.remove(subBean.getId());
            }
            if (!newSubBeanMap.isEmpty()) {
                k = -1;
                for (FormDataSubBean subBean : subBeans) {
                    ++k;
                    newSubBean = (FormDataSubBean)newSubBeanMap.get(subBean.getId());
                    if (newSubBean == null) continue;
                    String insertPrefix = FormLogUtil.getSlaveLogPrefix(subTable.getDisplay(), k + 1, Enums.CapLogType.INSERT);
                    StringBuilder insertLogSb = new StringBuilder(insertPrefix);
                    for (String fieldName : subLogFieldList) {
                        ffb = fb.getFieldBeanByName(fieldName);
                        insertLogSb.append(FormLogUtil.getFieldLogDesc(ffb, null, newSubBean.getFieldValue(fieldName), Enums.CapLogType.INSERT));
                    }
                    subLogSb.append((CharSequence)insertLogSb);
                }
            }
            sb.append((CharSequence)subLogSb);
        }
        return sb.toString();
    }

    private String mergeSubBeanLog(FormBean fb, String subTableName, List<FormDataSubBean> subBeanList, Enums.CapLogType type, List<String> subLogFieldList) throws BusinessException {
        StringBuilder sb = new StringBuilder();
        HashMap<Integer, String> subLogMap = new HashMap<Integer, String>();
        for (String string : subLogFieldList) {
            FormFieldBean ffb = fb.getFieldBeanByName(string);
            FormTableBean subTable = fb.getTableByTableName(subTableName);
            for (int k = 0; k < subBeanList.size(); ++k) {
                FormDataSubBean subBean = subBeanList.get(k);
                String subLog = (String)subLogMap.get(k);
                if (subLog == null) {
                    subLog = FormLogUtil.getSlaveLogPrefix(subTable.getDisplay(), k + 1, type);
                }
                subLog = subLog + FormLogUtil.getFieldLogDesc(ffb, null, subBean.getFieldValue(string), type);
                subLogMap.put(k, subLog);
            }
        }
        for (Map.Entry entry : subLogMap.entrySet()) {
            sb.append((String)entry.getValue());
        }
        return sb.toString();
    }

    private String getFieldModifyLog(FormFieldBean ffb, Object beforeValue, Object afterValue) throws BusinessException {
        if (beforeValue != null && afterValue != null) {
            if (Enums.FieldType.getEnumByKey((String)ffb.getFieldType().toUpperCase()) == Enums.FieldType.DATETIME) {
                String spDate;
                if (beforeValue instanceof Date && Strings.isNotBlank((String)(spDate = DateUtil.formatDateTime((Date)((Date)beforeValue))))) {
                    beforeValue = spDate;
                }
                beforeValue = beforeValue.toString().substring(0, 16);
                afterValue = afterValue.toString().substring(0, 16);
            } else if (!(Enums.FieldType.getEnumByKey((String)ffb.getFieldType().toUpperCase()) != Enums.FieldType.DECIMAL || ffb.getInputType().equals(FormFieldComEnum.SELECT.getKey()) || ffb.getInputType().equals(FormFieldComEnum.RADIO.getKey()) || ffb.getInputType().equals(FormFieldComEnum.IMAGE_SELECT.getKey()) || ffb.getInputType().equals(FormFieldComEnum.IMAGE_RADIO.getKey()) || ffb.getInputType().equals(FormFieldComEnum.CHECKBOX.getKey()))) {
                String digit = ffb.getDigitNum();
                int intDigit = 0;
                if (Strings.isNotEmpty((String)digit)) {
                    intDigit = Integer.parseInt(digit);
                }
                BigDecimal bd = new BigDecimal(beforeValue.toString());
                DecimalFormat decimalFmt = FormulaFunction.getDecimalFormat((int)intDigit, (String)("0.0".equals(beforeValue.toString()) ? "0" : ""));
                beforeValue = decimalFmt.format(bd);
                bd = new BigDecimal(afterValue.toString());
                decimalFmt = FormulaFunction.getDecimalFormat((int)intDigit, (String)("0.0".equals(afterValue.toString()) ? "0" : ""));
                afterValue = decimalFmt.format(bd);
            }
        }
        return FormLogUtil.getFieldLogDesc(ffb, beforeValue, afterValue, Enums.CapLogType.MODIFY);
    }

    @Override
    public String getDeleteLog(FormBean fb, FormDataMasterBean dataBean) throws BusinessException {
        List logFieldList = fb.getBind().getLogFieldList();
        if (Strings.isEmpty((Collection)logFieldList)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String logField : logFieldList) {
            String fieldName = logField.contains(".") ? logField.substring(logField.indexOf(".") + 1) : logField;
            FormFieldBean ffb = fb.getFieldBeanByName(fieldName);
            if (!ffb.isMasterField()) continue;
            sb.append(FormLogUtil.getFieldLogDesc(ffb, dataBean.getFieldValue(fieldName), null, Enums.CapLogType.DELETE));
        }
        return sb.toString();
    }

    @Override
    public void deleteRunningLog(List<CapRunningLog> logList) {
        if (null != logList) {
            DBAgent.deleteAll(logList);
        }
    }

    @Override
    public void deleteRunningLogByDateString(Date date) throws BusinessException {
        LOGGER.info((Object)"running log start clear");
        this.capLogDAO.deleteByDateString(date);
        LOGGER.info((Object)"running log end clear");
    }

    public void setCapLogDAO(CapLogDAO capLogDAO) {
        this.capLogDAO = capLogDAO;
    }

    public void setOrgManager(OrgManager orgManager) {
        this.orgManager = orgManager;
    }

    public void setCap4FormDataDAO(CAP4FormDataDAO cap4FormDataDAO) {
        this.cap4FormDataDAO = cap4FormDataDAO;
    }
}

