/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.log;

import com.seeyon.cap4.form.modules.engin.base.formData.CAP4FormDataDAO;
import com.seeyon.cap4.form.modules.log.CapLogDAO;
import com.seeyon.cap4.form.modules.log.CapSettingLogManager;
import com.seeyon.cap4.form.po.CapSettingLog;
import com.seeyon.cap4.form.util.Enums;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.common.log.CtpLogFactory;
import com.seeyon.ctp.organization.bo.V3xOrgMember;
import com.seeyon.ctp.organization.manager.OrgManager;
import com.seeyon.ctp.util.DateUtil;
import com.seeyon.ctp.util.FlipInfo;
import com.seeyon.ctp.util.Strings;
import com.seeyon.ctp.util.UUIDLong;
import com.seeyon.ctp.util.annotation.AjaxAccess;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;

public class CapSettingLogManagerImpl
implements CapSettingLogManager {
    private static final Log LOGGER = CtpLogFactory.getLog(CapSettingLogManagerImpl.class);
    private CapLogDAO capLogDAO;
    private CAP4FormDataDAO cap4FormDataDAO;
    private OrgManager orgManager;

    @Override
    @AjaxAccess
    public FlipInfo getSettingLogList(FlipInfo fi, Map<String, Object> params) throws BusinessException, ParseException {
        LOGGER.info((Object)("\u5f00\u59cb\u6267\u884c\u65f6\u95f4\uff1a" + new Date()));
        try {
            List<Map<String, Object>> settingLogs = this.capLogDAO.selectSettingLogByFlipInfo(fi, params);
            ArrayList data = new ArrayList();
            for (Map<String, Object> log : settingLogs) {
                V3xOrgMember member;
                HashMap<String, Object> hm = new HashMap<String, Object>();
                hm.put("id", log.get("id"));
                hm.put("operatedate", log.get("operateDate"));
                hm.put("createtime", log.get("createDate"));
                hm.put("operatetype", Enums.CapLogType.getLogTypeByKey((int)((Integer)log.get("operateType"))).getText());
                hm.put("ipAddress", log.get("ipAddress"));
                hm.put("bizName", log.get("bizName"));
                hm.put("operatorOrgName", log.get("operatorOrgName"));
                hm.put("resourceName", log.get("resourceName"));
                hm.put("creator", "");
                hm.put("operator", "");
                if ((Long)log.get("operator") == 0L) {
                    hm.put("operator", ResourceUtil.getString((String)"form.trigger.triggerSet.unflow.log.system"));
                } else {
                    member = this.orgManager.getMemberById((Long)log.get("operator"));
                    if (member != null) {
                        hm.put("operator", member.getName());
                    }
                }
                member = this.orgManager.getMemberById((Long)log.get("creator"));
                if (member != null) {
                    hm.put("creator", member.getName());
                }
                hm.put("description", "");
                String desc = log.get("description").toString();
                if (Strings.isNotBlank((String)desc)) {
                    if (desc.length() >= 1024) {
                        hm.put("description", desc.trim().substring(0, 1024));
                    } else {
                        hm.put("description", desc.trim());
                    }
                }
                data.add(hm);
            }
            fi.setData(data);
            LOGGER.info((Object)("\u7ed3\u675f\u6267\u884c\u65f6\u95f4\uff1a" + new Date()));
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new BusinessException("\u67e5\u8be2\u5f02\u5e38");
        }
        return fi;
    }

    @Override
    public void saveSettingLog(Long bizId, String bizName, Long resourceId, String resourceName, int operateType, String desc, Long operator, Long creator, Date createDate, String operatorOrgName, String ipAddress) throws BusinessException {
        CapSettingLog log = new CapSettingLog();
        log.setId(UUIDLong.longUUID());
        log.setBizId(bizId);
        log.setBizName(bizName);
        log.setResourceId(resourceId);
        log.setResourceName(resourceName);
        log.setOperateType(operateType);
        log.setOperateDate(DateUtil.currentDate());
        log.setOperator(operator);
        log.setOperatorOrgName(operatorOrgName);
        log.setCreator(creator);
        log.setCreateDate(createDate);
        log.setIpAddress(ipAddress);
        if (Strings.isNotEmpty((String)desc)) {
            int allowLen = 1333;
            if (allowLen >= desc.length()) {
                log.setDescription(desc);
            } else {
                log.setDescription(desc.substring(0, allowLen));
            }
        }
        this.capLogDAO.saveSettingLog(log);
    }

    public void setCapLogDAO(CapLogDAO capLogDAO) {
        this.capLogDAO = capLogDAO;
    }

    public void setOrgManager(OrgManager orgManager) {
        this.orgManager = orgManager;
    }

    public void setCap4FormDataDAO(CAP4FormDataDAO cap4FormDataDAO) {
        this.cap4FormDataDAO = cap4FormDataDAO;
    }
}

