/*
 * Decompiled with CFR 0.152.
 */
package com.seeyon.cap4.form.modules.memberLeave;

import com.seeyon.cap4.form.modules.business.BusinessDAO;
import com.seeyon.cap4.form.modules.business.BusinessManager;
import com.seeyon.cap4.form.po.CapBizConfig;
import com.seeyon.ctp.common.exceptions.BusinessException;
import com.seeyon.ctp.common.i18n.ResourceUtil;
import com.seeyon.ctp.organization.bo.V3xOrgAccount;
import com.seeyon.ctp.organization.bo.V3xOrgMember;
import com.seeyon.ctp.organization.manager.OrgManager;
import com.seeyon.ctp.organization.memberleave.bo.MemberLeaveDetail;
import com.seeyon.ctp.organization.memberleave.manager.AbstractMemberLeaveClearItem;
import com.seeyon.ctp.organization.memberleave.manager.MemberLeaveClearItemInterface;
import java.util.ArrayList;
import java.util.List;

public class Cap4MemberLeaveClearItemBussinessImpl
extends AbstractMemberLeaveClearItem {
    private BusinessManager businessManager4;
    private OrgManager orgManager;
    private BusinessDAO businessDAO4;

    public void updateAuthority(Long oldMemberId, Long newMemberId, List<String> bizConfigIds) throws BusinessException {
        String authNames = this.getAuthNames(oldMemberId, bizConfigIds, new String[]{"title"});
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bizConfigIds.size(); ++i) {
            sb.append(bizConfigIds.get(i)).append(",");
        }
        V3xOrgMember member = this.orgManager.getMemberById(newMemberId);
        this.businessManager4.updatePeopleBelongBatch(sb.toString().substring(0, sb.toString().length() - 1), newMemberId, member.getName(), "biz", member.getOrgAccountId());
        this.saveLog(oldMemberId, newMemberId, authNames);
    }

    public MemberLeaveClearItemInterface.Category getCategory() {
        return MemberLeaveClearItemInterface.Category.BusinessCap4;
    }

    public List<MemberLeaveDetail> getItems(long memberId) throws BusinessException {
        ArrayList<MemberLeaveDetail> result = new ArrayList<MemberLeaveDetail>();
        V3xOrgMember member = this.orgManager.getMemberById(Long.valueOf(memberId));
        if (member == null) {
            return result;
        }
        List<CapBizConfig> allCtpBizConfig = this.businessDAO4.getAllCtpBizConfig();
        for (CapBizConfig capBizConfig : allCtpBizConfig) {
            Long ownerId = capBizConfig.getOwnerId();
            if (capBizConfig.getOwnerId() != memberId) continue;
            Long orgAccountId = this.orgManager.getMemberById(ownerId).getOrgAccountId();
            V3xOrgAccount v3xOrgAccount = this.orgManager.getAccountById(orgAccountId);
            String accountName = v3xOrgAccount.getName();
            MemberLeaveDetail memberLeaveDetail = new MemberLeaveDetail();
            memberLeaveDetail.setId(capBizConfig.getId().toString());
            memberLeaveDetail.setDealInterfaceClassName(((Object)((Object)this)).getClass().getSimpleName());
            memberLeaveDetail.setType(ResourceUtil.getString((String)"member.leave.business.title"));
            memberLeaveDetail.setAccountName(accountName);
            memberLeaveDetail.setAccountId(capBizConfig.getOrgAccountId());
            memberLeaveDetail.setContent(member.getName());
            memberLeaveDetail.setTitle(capBizConfig.getName());
            result.add(memberLeaveDetail);
        }
        return result;
    }

    public Integer getSortId() {
        return 3;
    }

    public void setBusinessManager4(BusinessManager businessManager4) {
        this.businessManager4 = businessManager4;
    }

    public void setOrgManager(OrgManager orgManager) {
        this.orgManager = orgManager;
    }

    public void setBusinessDAO4(BusinessDAO businessDAO4) {
        this.businessDAO4 = businessDAO4;
    }
}

